package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Datebox;

/**
 * Immutable implementation of {@link IDatebox}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IDatebox.Builder()}.
 */
@Generated(from = "IDatebox", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIDatebox implements IDatebox {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final boolean readonly;
  private final @Nullable String name;
  private final @Nullable String placeholder;
  private final @Nullable ImmutableMap<String, String> inputAttributes;
  private final @Nullable Date value;
  private final @Nullable String constraint;
  private final @Nullable String errorboxSclass;
  private final @Nullable String errorboxIconSclass;
  private final boolean disabled;
  private final boolean inplace;
  private final int maxlength;
  private final boolean instant;
  private final @Nullable String errorMessage;
  private final @Nullable String format;
  private final @Nullable Locale locale;
  private final TimeZone timeZone;
  private final @Nullable ZonedDateTime valueInZonedDateTime;
  private final @Nullable LocalDateTime valueInLocalDateTime;
  private final @Nullable LocalDate valueInLocalDate;
  private final @Nullable LocalTime valueInLocalTime;
  private final String widgetClass;
  private final @Nullable ImmutableList<TimeZone> displayedTimeZones;
  private final @Nullable LocalDateTime defaultDateTime;
  private final boolean buttonVisible;
  private final boolean lenient;
  private final boolean timeZonesReadonly;
  private final boolean weekOfYear;
  private final String position;
  private final boolean strictDate;
  private final boolean showTodayLink;
  private final String todayLinkLabel;
  private final String selectLevel;
  private final boolean closePopupOnTimezoneChange;
  private final int cols;

  private ImmutableIDatebox(ImmutableIDatebox.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.name = builder.name;
    this.placeholder = builder.placeholder;
    this.inputAttributes = builder.inputAttributes == null ? null : builder.inputAttributes.build();
    this.value = builder.value;
    this.constraint = builder.constraint;
    this.errorboxSclass = builder.errorboxSclass;
    this.errorboxIconSclass = builder.errorboxIconSclass;
    this.errorMessage = builder.errorMessage;
    this.format = builder.format;
    this.locale = builder.locale;
    this.defaultDateTime = builder.defaultDateTime;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.readonlyIsSet()) {
      initShim.setReadonly(builder.readonly);
    }
    if (builder.disabledIsSet()) {
      initShim.setDisabled(builder.disabled);
    }
    if (builder.inplaceIsSet()) {
      initShim.setInplace(builder.inplace);
    }
    if (builder.maxlengthIsSet()) {
      initShim.setMaxlength(builder.maxlength);
    }
    if (builder.instantIsSet()) {
      initShim.setInstant(builder.instant);
    }
    if (builder.timeZone != null) {
      initShim.setTimeZone(builder.timeZone);
    }
    if (builder.valueInZonedDateTimeIsSet()) {
      initShim.setValueInZonedDateTime(builder.valueInZonedDateTime);
    }
    if (builder.valueInLocalDateTimeIsSet()) {
      initShim.setValueInLocalDateTime(builder.valueInLocalDateTime);
    }
    if (builder.valueInLocalDateIsSet()) {
      initShim.setValueInLocalDate(builder.valueInLocalDate);
    }
    if (builder.valueInLocalTimeIsSet()) {
      initShim.setValueInLocalTime(builder.valueInLocalTime);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.displayedTimeZonesIsSet()) {
      initShim.setDisplayedTimeZones(builder.displayedTimeZones == null ? null : builder.displayedTimeZones.build());
    }
    if (builder.buttonVisibleIsSet()) {
      initShim.setButtonVisible(builder.buttonVisible);
    }
    if (builder.lenientIsSet()) {
      initShim.setLenient(builder.lenient);
    }
    if (builder.timeZonesReadonlyIsSet()) {
      initShim.setTimeZonesReadonly(builder.timeZonesReadonly);
    }
    if (builder.weekOfYearIsSet()) {
      initShim.setWeekOfYear(builder.weekOfYear);
    }
    if (builder.position != null) {
      initShim.setPosition(builder.position);
    }
    if (builder.strictDateIsSet()) {
      initShim.setStrictDate(builder.strictDate);
    }
    if (builder.showTodayLinkIsSet()) {
      initShim.setShowTodayLink(builder.showTodayLink);
    }
    if (builder.todayLinkLabel != null) {
      initShim.setTodayLinkLabel(builder.todayLinkLabel);
    }
    if (builder.selectLevel != null) {
      initShim.setSelectLevel(builder.selectLevel);
    }
    if (builder.closePopupOnTimezoneChangeIsSet()) {
      initShim.setClosePopupOnTimezoneChange(builder.closePopupOnTimezoneChange);
    }
    if (builder.colsIsSet()) {
      initShim.setCols(builder.cols);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.readonly = initShim.isReadonly();
    this.disabled = initShim.isDisabled();
    this.inplace = initShim.isInplace();
    this.maxlength = initShim.getMaxlength();
    this.instant = initShim.getInstant();
    this.timeZone = initShim.getTimeZone();
    this.valueInZonedDateTime = initShim.getValueInZonedDateTime();
    this.valueInLocalDateTime = initShim.getValueInLocalDateTime();
    this.valueInLocalDate = initShim.getValueInLocalDate();
    this.valueInLocalTime = initShim.getValueInLocalTime();
    this.widgetClass = initShim.getWidgetClass();
    this.displayedTimeZones = initShim.getDisplayedTimeZones();
    this.buttonVisible = initShim.isButtonVisible();
    this.lenient = initShim.isLenient();
    this.timeZonesReadonly = initShim.isTimeZonesReadonly();
    this.weekOfYear = initShim.isWeekOfYear();
    this.position = initShim.getPosition();
    this.strictDate = initShim.isStrictDate();
    this.showTodayLink = initShim.getShowTodayLink();
    this.todayLinkLabel = initShim.getTodayLinkLabel();
    this.selectLevel = initShim.getSelectLevel();
    this.closePopupOnTimezoneChange = initShim.getClosePopupOnTimezoneChange();
    this.cols = initShim.getCols();
    this.initShim = null;
  }

  private ImmutableIDatebox(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      boolean readonly,
      @Nullable String name,
      @Nullable String placeholder,
      @Nullable ImmutableMap<String, String> inputAttributes,
      @Nullable Date value,
      @Nullable String constraint,
      @Nullable String errorboxSclass,
      @Nullable String errorboxIconSclass,
      boolean disabled,
      boolean inplace,
      int maxlength,
      boolean instant,
      @Nullable String errorMessage,
      @Nullable String format,
      @Nullable Locale locale,
      TimeZone timeZone,
      @Nullable ZonedDateTime valueInZonedDateTime,
      @Nullable LocalDateTime valueInLocalDateTime,
      @Nullable LocalDate valueInLocalDate,
      @Nullable LocalTime valueInLocalTime,
      String widgetClass,
      @Nullable ImmutableList<TimeZone> displayedTimeZones,
      @Nullable LocalDateTime defaultDateTime,
      boolean buttonVisible,
      boolean lenient,
      boolean timeZonesReadonly,
      boolean weekOfYear,
      String position,
      boolean strictDate,
      boolean showTodayLink,
      String todayLinkLabel,
      String selectLevel,
      boolean closePopupOnTimezoneChange,
      int cols) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.readonly = readonly;
    this.name = name;
    this.placeholder = placeholder;
    this.inputAttributes = inputAttributes;
    this.value = value;
    this.constraint = constraint;
    this.errorboxSclass = errorboxSclass;
    this.errorboxIconSclass = errorboxIconSclass;
    this.disabled = disabled;
    this.inplace = inplace;
    this.maxlength = maxlength;
    this.instant = instant;
    this.errorMessage = errorMessage;
    this.format = format;
    this.locale = locale;
    this.timeZone = timeZone;
    this.valueInZonedDateTime = valueInZonedDateTime;
    this.valueInLocalDateTime = valueInLocalDateTime;
    this.valueInLocalDate = valueInLocalDate;
    this.valueInLocalTime = valueInLocalTime;
    this.widgetClass = widgetClass;
    this.displayedTimeZones = displayedTimeZones;
    this.defaultDateTime = defaultDateTime;
    this.buttonVisible = buttonVisible;
    this.lenient = lenient;
    this.timeZonesReadonly = timeZonesReadonly;
    this.weekOfYear = weekOfYear;
    this.position = position;
    this.strictDate = strictDate;
    this.showTodayLink = showTodayLink;
    this.todayLinkLabel = todayLinkLabel;
    this.selectLevel = selectLevel;
    this.closePopupOnTimezoneChange = closePopupOnTimezoneChange;
    this.cols = cols;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IDatebox", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte readonlyBuildStage = STAGE_UNINITIALIZED;
    private boolean readonly;

    boolean isReadonly() {
      if (readonlyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (readonlyBuildStage == STAGE_UNINITIALIZED) {
        readonlyBuildStage = STAGE_INITIALIZING;
        this.readonly = isReadonlyInitialize();
        readonlyBuildStage = STAGE_INITIALIZED;
      }
      return this.readonly;
    }

    void setReadonly(boolean readonly) {
      this.readonly = readonly;
      readonlyBuildStage = STAGE_INITIALIZED;
    }

    private byte disabledBuildStage = STAGE_UNINITIALIZED;
    private boolean disabled;

    boolean isDisabled() {
      if (disabledBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disabledBuildStage == STAGE_UNINITIALIZED) {
        disabledBuildStage = STAGE_INITIALIZING;
        this.disabled = isDisabledInitialize();
        disabledBuildStage = STAGE_INITIALIZED;
      }
      return this.disabled;
    }

    void setDisabled(boolean disabled) {
      this.disabled = disabled;
      disabledBuildStage = STAGE_INITIALIZED;
    }

    private byte inplaceBuildStage = STAGE_UNINITIALIZED;
    private boolean inplace;

    boolean isInplace() {
      if (inplaceBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (inplaceBuildStage == STAGE_UNINITIALIZED) {
        inplaceBuildStage = STAGE_INITIALIZING;
        this.inplace = isInplaceInitialize();
        inplaceBuildStage = STAGE_INITIALIZED;
      }
      return this.inplace;
    }

    void setInplace(boolean inplace) {
      this.inplace = inplace;
      inplaceBuildStage = STAGE_INITIALIZED;
    }

    private byte maxlengthBuildStage = STAGE_UNINITIALIZED;
    private int maxlength;

    int getMaxlength() {
      if (maxlengthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxlengthBuildStage == STAGE_UNINITIALIZED) {
        maxlengthBuildStage = STAGE_INITIALIZING;
        this.maxlength = getMaxlengthInitialize();
        maxlengthBuildStage = STAGE_INITIALIZED;
      }
      return this.maxlength;
    }

    void setMaxlength(int maxlength) {
      this.maxlength = maxlength;
      maxlengthBuildStage = STAGE_INITIALIZED;
    }

    private byte instantBuildStage = STAGE_UNINITIALIZED;
    private boolean instant;

    boolean getInstant() {
      if (instantBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (instantBuildStage == STAGE_UNINITIALIZED) {
        instantBuildStage = STAGE_INITIALIZING;
        this.instant = getInstantInitialize();
        instantBuildStage = STAGE_INITIALIZED;
      }
      return this.instant;
    }

    void setInstant(boolean instant) {
      this.instant = instant;
      instantBuildStage = STAGE_INITIALIZED;
    }

    private byte timeZoneBuildStage = STAGE_UNINITIALIZED;
    private TimeZone timeZone;

    TimeZone getTimeZone() {
      if (timeZoneBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (timeZoneBuildStage == STAGE_UNINITIALIZED) {
        timeZoneBuildStage = STAGE_INITIALIZING;
        this.timeZone = Objects.requireNonNull(getTimeZoneInitialize(), "timeZone");
        timeZoneBuildStage = STAGE_INITIALIZED;
      }
      return this.timeZone;
    }

    void setTimeZone(TimeZone timeZone) {
      this.timeZone = timeZone;
      timeZoneBuildStage = STAGE_INITIALIZED;
    }

    private byte valueInZonedDateTimeBuildStage = STAGE_UNINITIALIZED;
    private ZonedDateTime valueInZonedDateTime;

    ZonedDateTime getValueInZonedDateTime() {
      if (valueInZonedDateTimeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (valueInZonedDateTimeBuildStage == STAGE_UNINITIALIZED) {
        valueInZonedDateTimeBuildStage = STAGE_INITIALIZING;
        this.valueInZonedDateTime = getValueInZonedDateTimeInitialize();
        valueInZonedDateTimeBuildStage = STAGE_INITIALIZED;
      }
      return this.valueInZonedDateTime;
    }

    void setValueInZonedDateTime(ZonedDateTime valueInZonedDateTime) {
      this.valueInZonedDateTime = valueInZonedDateTime;
      valueInZonedDateTimeBuildStage = STAGE_INITIALIZED;
    }

    private byte valueInLocalDateTimeBuildStage = STAGE_UNINITIALIZED;
    private LocalDateTime valueInLocalDateTime;

    LocalDateTime getValueInLocalDateTime() {
      if (valueInLocalDateTimeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (valueInLocalDateTimeBuildStage == STAGE_UNINITIALIZED) {
        valueInLocalDateTimeBuildStage = STAGE_INITIALIZING;
        this.valueInLocalDateTime = getValueInLocalDateTimeInitialize();
        valueInLocalDateTimeBuildStage = STAGE_INITIALIZED;
      }
      return this.valueInLocalDateTime;
    }

    void setValueInLocalDateTime(LocalDateTime valueInLocalDateTime) {
      this.valueInLocalDateTime = valueInLocalDateTime;
      valueInLocalDateTimeBuildStage = STAGE_INITIALIZED;
    }

    private byte valueInLocalDateBuildStage = STAGE_UNINITIALIZED;
    private LocalDate valueInLocalDate;

    LocalDate getValueInLocalDate() {
      if (valueInLocalDateBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (valueInLocalDateBuildStage == STAGE_UNINITIALIZED) {
        valueInLocalDateBuildStage = STAGE_INITIALIZING;
        this.valueInLocalDate = getValueInLocalDateInitialize();
        valueInLocalDateBuildStage = STAGE_INITIALIZED;
      }
      return this.valueInLocalDate;
    }

    void setValueInLocalDate(LocalDate valueInLocalDate) {
      this.valueInLocalDate = valueInLocalDate;
      valueInLocalDateBuildStage = STAGE_INITIALIZED;
    }

    private byte valueInLocalTimeBuildStage = STAGE_UNINITIALIZED;
    private LocalTime valueInLocalTime;

    LocalTime getValueInLocalTime() {
      if (valueInLocalTimeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (valueInLocalTimeBuildStage == STAGE_UNINITIALIZED) {
        valueInLocalTimeBuildStage = STAGE_INITIALIZING;
        this.valueInLocalTime = getValueInLocalTimeInitialize();
        valueInLocalTimeBuildStage = STAGE_INITIALIZED;
      }
      return this.valueInLocalTime;
    }

    void setValueInLocalTime(LocalTime valueInLocalTime) {
      this.valueInLocalTime = valueInLocalTime;
      valueInLocalTimeBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte displayedTimeZonesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableList<TimeZone> displayedTimeZones;

    ImmutableList<TimeZone> getDisplayedTimeZones() {
      if (displayedTimeZonesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (displayedTimeZonesBuildStage == STAGE_UNINITIALIZED) {
        displayedTimeZonesBuildStage = STAGE_INITIALIZING;
        this.displayedTimeZones = getDisplayedTimeZonesInitialize() == null ? null : ImmutableList.copyOf(getDisplayedTimeZonesInitialize());
        displayedTimeZonesBuildStage = STAGE_INITIALIZED;
      }
      return this.displayedTimeZones;
    }

    void setDisplayedTimeZones(ImmutableList<TimeZone> displayedTimeZones) {
      this.displayedTimeZones = displayedTimeZones;
      displayedTimeZonesBuildStage = STAGE_INITIALIZED;
    }

    private byte buttonVisibleBuildStage = STAGE_UNINITIALIZED;
    private boolean buttonVisible;

    boolean isButtonVisible() {
      if (buttonVisibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (buttonVisibleBuildStage == STAGE_UNINITIALIZED) {
        buttonVisibleBuildStage = STAGE_INITIALIZING;
        this.buttonVisible = isButtonVisibleInitialize();
        buttonVisibleBuildStage = STAGE_INITIALIZED;
      }
      return this.buttonVisible;
    }

    void setButtonVisible(boolean buttonVisible) {
      this.buttonVisible = buttonVisible;
      buttonVisibleBuildStage = STAGE_INITIALIZED;
    }

    private byte lenientBuildStage = STAGE_UNINITIALIZED;
    private boolean lenient;

    boolean isLenient() {
      if (lenientBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (lenientBuildStage == STAGE_UNINITIALIZED) {
        lenientBuildStage = STAGE_INITIALIZING;
        this.lenient = isLenientInitialize();
        lenientBuildStage = STAGE_INITIALIZED;
      }
      return this.lenient;
    }

    void setLenient(boolean lenient) {
      this.lenient = lenient;
      lenientBuildStage = STAGE_INITIALIZED;
    }

    private byte timeZonesReadonlyBuildStage = STAGE_UNINITIALIZED;
    private boolean timeZonesReadonly;

    boolean isTimeZonesReadonly() {
      if (timeZonesReadonlyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (timeZonesReadonlyBuildStage == STAGE_UNINITIALIZED) {
        timeZonesReadonlyBuildStage = STAGE_INITIALIZING;
        this.timeZonesReadonly = isTimeZonesReadonlyInitialize();
        timeZonesReadonlyBuildStage = STAGE_INITIALIZED;
      }
      return this.timeZonesReadonly;
    }

    void setTimeZonesReadonly(boolean timeZonesReadonly) {
      this.timeZonesReadonly = timeZonesReadonly;
      timeZonesReadonlyBuildStage = STAGE_INITIALIZED;
    }

    private byte weekOfYearBuildStage = STAGE_UNINITIALIZED;
    private boolean weekOfYear;

    boolean isWeekOfYear() {
      if (weekOfYearBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (weekOfYearBuildStage == STAGE_UNINITIALIZED) {
        weekOfYearBuildStage = STAGE_INITIALIZING;
        this.weekOfYear = isWeekOfYearInitialize();
        weekOfYearBuildStage = STAGE_INITIALIZED;
      }
      return this.weekOfYear;
    }

    void setWeekOfYear(boolean weekOfYear) {
      this.weekOfYear = weekOfYear;
      weekOfYearBuildStage = STAGE_INITIALIZED;
    }

    private byte positionBuildStage = STAGE_UNINITIALIZED;
    private String position;

    String getPosition() {
      if (positionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (positionBuildStage == STAGE_UNINITIALIZED) {
        positionBuildStage = STAGE_INITIALIZING;
        this.position = Objects.requireNonNull(getPositionInitialize(), "position");
        positionBuildStage = STAGE_INITIALIZED;
      }
      return this.position;
    }

    void setPosition(String position) {
      this.position = position;
      positionBuildStage = STAGE_INITIALIZED;
    }

    private byte strictDateBuildStage = STAGE_UNINITIALIZED;
    private boolean strictDate;

    boolean isStrictDate() {
      if (strictDateBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (strictDateBuildStage == STAGE_UNINITIALIZED) {
        strictDateBuildStage = STAGE_INITIALIZING;
        this.strictDate = isStrictDateInitialize();
        strictDateBuildStage = STAGE_INITIALIZED;
      }
      return this.strictDate;
    }

    void setStrictDate(boolean strictDate) {
      this.strictDate = strictDate;
      strictDateBuildStage = STAGE_INITIALIZED;
    }

    private byte showTodayLinkBuildStage = STAGE_UNINITIALIZED;
    private boolean showTodayLink;

    boolean getShowTodayLink() {
      if (showTodayLinkBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (showTodayLinkBuildStage == STAGE_UNINITIALIZED) {
        showTodayLinkBuildStage = STAGE_INITIALIZING;
        this.showTodayLink = getShowTodayLinkInitialize();
        showTodayLinkBuildStage = STAGE_INITIALIZED;
      }
      return this.showTodayLink;
    }

    void setShowTodayLink(boolean showTodayLink) {
      this.showTodayLink = showTodayLink;
      showTodayLinkBuildStage = STAGE_INITIALIZED;
    }

    private byte todayLinkLabelBuildStage = STAGE_UNINITIALIZED;
    private String todayLinkLabel;

    String getTodayLinkLabel() {
      if (todayLinkLabelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (todayLinkLabelBuildStage == STAGE_UNINITIALIZED) {
        todayLinkLabelBuildStage = STAGE_INITIALIZING;
        this.todayLinkLabel = Objects.requireNonNull(getTodayLinkLabelInitialize(), "todayLinkLabel");
        todayLinkLabelBuildStage = STAGE_INITIALIZED;
      }
      return this.todayLinkLabel;
    }

    void setTodayLinkLabel(String todayLinkLabel) {
      this.todayLinkLabel = todayLinkLabel;
      todayLinkLabelBuildStage = STAGE_INITIALIZED;
    }

    private byte selectLevelBuildStage = STAGE_UNINITIALIZED;
    private String selectLevel;

    String getSelectLevel() {
      if (selectLevelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (selectLevelBuildStage == STAGE_UNINITIALIZED) {
        selectLevelBuildStage = STAGE_INITIALIZING;
        this.selectLevel = Objects.requireNonNull(getSelectLevelInitialize(), "selectLevel");
        selectLevelBuildStage = STAGE_INITIALIZED;
      }
      return this.selectLevel;
    }

    void setSelectLevel(String selectLevel) {
      this.selectLevel = selectLevel;
      selectLevelBuildStage = STAGE_INITIALIZED;
    }

    private byte closePopupOnTimezoneChangeBuildStage = STAGE_UNINITIALIZED;
    private boolean closePopupOnTimezoneChange;

    boolean getClosePopupOnTimezoneChange() {
      if (closePopupOnTimezoneChangeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (closePopupOnTimezoneChangeBuildStage == STAGE_UNINITIALIZED) {
        closePopupOnTimezoneChangeBuildStage = STAGE_INITIALIZING;
        this.closePopupOnTimezoneChange = getClosePopupOnTimezoneChangeInitialize();
        closePopupOnTimezoneChangeBuildStage = STAGE_INITIALIZED;
      }
      return this.closePopupOnTimezoneChange;
    }

    void setClosePopupOnTimezoneChange(boolean closePopupOnTimezoneChange) {
      this.closePopupOnTimezoneChange = closePopupOnTimezoneChange;
      closePopupOnTimezoneChangeBuildStage = STAGE_INITIALIZED;
    }

    private byte colsBuildStage = STAGE_UNINITIALIZED;
    private int cols;

    int getCols() {
      if (colsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (colsBuildStage == STAGE_UNINITIALIZED) {
        colsBuildStage = STAGE_INITIALIZING;
        this.cols = getColsInitialize();
        colsBuildStage = STAGE_INITIALIZED;
      }
      return this.cols;
    }

    void setCols(int cols) {
      this.cols = cols;
      colsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (readonlyBuildStage == STAGE_INITIALIZING) attributes.add("readonly");
      if (disabledBuildStage == STAGE_INITIALIZING) attributes.add("disabled");
      if (inplaceBuildStage == STAGE_INITIALIZING) attributes.add("inplace");
      if (maxlengthBuildStage == STAGE_INITIALIZING) attributes.add("maxlength");
      if (instantBuildStage == STAGE_INITIALIZING) attributes.add("instant");
      if (timeZoneBuildStage == STAGE_INITIALIZING) attributes.add("timeZone");
      if (valueInZonedDateTimeBuildStage == STAGE_INITIALIZING) attributes.add("valueInZonedDateTime");
      if (valueInLocalDateTimeBuildStage == STAGE_INITIALIZING) attributes.add("valueInLocalDateTime");
      if (valueInLocalDateBuildStage == STAGE_INITIALIZING) attributes.add("valueInLocalDate");
      if (valueInLocalTimeBuildStage == STAGE_INITIALIZING) attributes.add("valueInLocalTime");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (displayedTimeZonesBuildStage == STAGE_INITIALIZING) attributes.add("displayedTimeZones");
      if (buttonVisibleBuildStage == STAGE_INITIALIZING) attributes.add("buttonVisible");
      if (lenientBuildStage == STAGE_INITIALIZING) attributes.add("lenient");
      if (timeZonesReadonlyBuildStage == STAGE_INITIALIZING) attributes.add("timeZonesReadonly");
      if (weekOfYearBuildStage == STAGE_INITIALIZING) attributes.add("weekOfYear");
      if (positionBuildStage == STAGE_INITIALIZING) attributes.add("position");
      if (strictDateBuildStage == STAGE_INITIALIZING) attributes.add("strictDate");
      if (showTodayLinkBuildStage == STAGE_INITIALIZING) attributes.add("showTodayLink");
      if (todayLinkLabelBuildStage == STAGE_INITIALIZING) attributes.add("todayLinkLabel");
      if (selectLevelBuildStage == STAGE_INITIALIZING) attributes.add("selectLevel");
      if (closePopupOnTimezoneChangeBuildStage == STAGE_INITIALIZING) attributes.add("closePopupOnTimezoneChange");
      if (colsBuildStage == STAGE_INITIALIZING) attributes.add("cols");
      return "Cannot build IDatebox, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IDatebox.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IDatebox.super.isVisible();
  }

  private String getMoldInitialize() {
    return IDatebox.super.getMold();
  }

  private int getZIndexInitialize() {
    return IDatebox.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IDatebox.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IDatebox.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IDatebox.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IDatebox.super.getRenderdefer();
  }

  private boolean isReadonlyInitialize() {
    return IDatebox.super.isReadonly();
  }

  private boolean isDisabledInitialize() {
    return IDatebox.super.isDisabled();
  }

  private boolean isInplaceInitialize() {
    return IDatebox.super.isInplace();
  }

  private int getMaxlengthInitialize() {
    return IDatebox.super.getMaxlength();
  }

  private boolean getInstantInitialize() {
    return IDatebox.super.getInstant();
  }

  private TimeZone getTimeZoneInitialize() {
    return IDatebox.super.getTimeZone();
  }

  private @Nullable ZonedDateTime getValueInZonedDateTimeInitialize() {
    return IDatebox.super.getValueInZonedDateTime();
  }

  private @Nullable LocalDateTime getValueInLocalDateTimeInitialize() {
    return IDatebox.super.getValueInLocalDateTime();
  }

  private @Nullable LocalDate getValueInLocalDateInitialize() {
    return IDatebox.super.getValueInLocalDate();
  }

  private @Nullable LocalTime getValueInLocalTimeInitialize() {
    return IDatebox.super.getValueInLocalTime();
  }

  private String getWidgetClassInitialize() {
    return IDatebox.super.getWidgetClass();
  }

  private @Nullable List<TimeZone> getDisplayedTimeZonesInitialize() {
    return IDatebox.super.getDisplayedTimeZones();
  }

  private boolean isButtonVisibleInitialize() {
    return IDatebox.super.isButtonVisible();
  }

  private boolean isLenientInitialize() {
    return IDatebox.super.isLenient();
  }

  private boolean isTimeZonesReadonlyInitialize() {
    return IDatebox.super.isTimeZonesReadonly();
  }

  private boolean isWeekOfYearInitialize() {
    return IDatebox.super.isWeekOfYear();
  }

  private String getPositionInitialize() {
    return IDatebox.super.getPosition();
  }

  private boolean isStrictDateInitialize() {
    return IDatebox.super.isStrictDate();
  }

  private boolean getShowTodayLinkInitialize() {
    return IDatebox.super.getShowTodayLink();
  }

  private String getTodayLinkLabelInitialize() {
    return IDatebox.super.getTodayLinkLabel();
  }

  private String getSelectLevelInitialize() {
    return IDatebox.super.getSelectLevel();
  }

  private boolean getClosePopupOnTimezoneChangeInitialize() {
    return IDatebox.super.getClosePopupOnTimezoneChange();
  }

  private int getColsInitialize() {
    return IDatebox.super.getCols();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code readonly} attribute
   */
  @Override
  public boolean isReadonly() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isReadonly()
        : this.readonly;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @Override
  public @Nullable String getPlaceholder() {
    return placeholder;
  }

  /**
   * @return The value of the {@code inputAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getInputAttributes() {
    return inputAttributes;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public @Nullable Date getValue() {
    return value;
  }

  /**
   * @return The value of the {@code constraint} attribute
   */
  @Override
  public @Nullable String getConstraint() {
    return constraint;
  }

  /**
   * @return The value of the {@code errorboxSclass} attribute
   */
  @Override
  public @Nullable String getErrorboxSclass() {
    return errorboxSclass;
  }

  /**
   * @return The value of the {@code errorboxIconSclass} attribute
   */
  @Override
  public @Nullable String getErrorboxIconSclass() {
    return errorboxIconSclass;
  }

  /**
   * @return The value of the {@code disabled} attribute
   */
  @Override
  public boolean isDisabled() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDisabled()
        : this.disabled;
  }

  /**
   * @return The value of the {@code inplace} attribute
   */
  @Override
  public boolean isInplace() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isInplace()
        : this.inplace;
  }

  /**
   * @return The value of the {@code maxlength} attribute
   */
  @Override
  public int getMaxlength() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMaxlength()
        : this.maxlength;
  }

  /**
   * @return The value of the {@code instant} attribute
   */
  @Override
  public boolean getInstant() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getInstant()
        : this.instant;
  }

  /**
   * @return The value of the {@code errorMessage} attribute
   */
  @Override
  public @Nullable String getErrorMessage() {
    return errorMessage;
  }

  /**
   * @return The value of the {@code format} attribute
   */
  @Override
  public @Nullable String getFormat() {
    return format;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @Override
  public @Nullable Locale getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code timeZone} attribute
   */
  @Override
  public TimeZone getTimeZone() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getTimeZone()
        : this.timeZone;
  }

  /**
   * @return The value of the {@code valueInZonedDateTime} attribute
   */
  @Override
  public @Nullable ZonedDateTime getValueInZonedDateTime() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getValueInZonedDateTime()
        : this.valueInZonedDateTime;
  }

  /**
   * @return The value of the {@code valueInLocalDateTime} attribute
   */
  @Override
  public @Nullable LocalDateTime getValueInLocalDateTime() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getValueInLocalDateTime()
        : this.valueInLocalDateTime;
  }

  /**
   * @return The value of the {@code valueInLocalDate} attribute
   */
  @Override
  public @Nullable LocalDate getValueInLocalDate() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getValueInLocalDate()
        : this.valueInLocalDate;
  }

  /**
   * @return The value of the {@code valueInLocalTime} attribute
   */
  @Override
  public @Nullable LocalTime getValueInLocalTime() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getValueInLocalTime()
        : this.valueInLocalTime;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code displayedTimeZones} attribute
   */
  @Override
  public @Nullable ImmutableList<TimeZone> getDisplayedTimeZones() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDisplayedTimeZones()
        : this.displayedTimeZones;
  }

  /**
   * @return The value of the {@code defaultDateTime} attribute
   */
  @Override
  public @Nullable LocalDateTime getDefaultDateTime() {
    return defaultDateTime;
  }

  /**
   * @return The value of the {@code buttonVisible} attribute
   */
  @Override
  public boolean isButtonVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isButtonVisible()
        : this.buttonVisible;
  }

  /**
   * @return The value of the {@code lenient} attribute
   */
  @Override
  public boolean isLenient() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isLenient()
        : this.lenient;
  }

  /**
   * @return The value of the {@code timeZonesReadonly} attribute
   */
  @Override
  public boolean isTimeZonesReadonly() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isTimeZonesReadonly()
        : this.timeZonesReadonly;
  }

  /**
   * @return The value of the {@code weekOfYear} attribute
   */
  @Override
  public boolean isWeekOfYear() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isWeekOfYear()
        : this.weekOfYear;
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public String getPosition() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPosition()
        : this.position;
  }

  /**
   * @return The value of the {@code strictDate} attribute
   */
  @Override
  public boolean isStrictDate() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isStrictDate()
        : this.strictDate;
  }

  /**
   * @return The value of the {@code showTodayLink} attribute
   */
  @Override
  public boolean getShowTodayLink() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getShowTodayLink()
        : this.showTodayLink;
  }

  /**
   * @return The value of the {@code todayLinkLabel} attribute
   */
  @Override
  public String getTodayLinkLabel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getTodayLinkLabel()
        : this.todayLinkLabel;
  }

  /**
   * @return The value of the {@code selectLevel} attribute
   */
  @Override
  public String getSelectLevel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSelectLevel()
        : this.selectLevel;
  }

  /**
   * @return The value of the {@code closePopupOnTimezoneChange} attribute
   */
  @Override
  public boolean getClosePopupOnTimezoneChange() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getClosePopupOnTimezoneChange()
        : this.closePopupOnTimezoneChange;
  }

  /**
   * @return The value of the {@code cols} attribute
   */
  @Override
  public int getCols() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCols()
        : this.cols;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIDatebox(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IDatebox#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDatebox withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIDatebox(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.readonly,
          this.name,
          this.placeholder,
          this.inputAttributes,
          this.value,
          this.constraint,
          this.errorboxSclass,
          this.errorboxIconSclass,
          this.disabled,
          this.inplace,
          this.maxlength,
          this.instant,
          this.errorMessage,
          this.format,
          this.locale,
          this.timeZone,
          this.valueInZonedDateTime,
          this.valueInLocalDateTime,
          this.valueInLocalDate,
          this.valueInLocalTime,
          this.widgetClass,
          this.displayedTimeZones,
          this.defaultDateTime,
          this.buttonVisible,
          this.lenient,
          this.timeZonesReadonly,
          this.weekOfYear,
          this.position,
          this.strictDate,
          this.showTodayLink,
          this.todayLinkLabel,
          this.selectLevel,
          this.closePopupOnTimezoneChange,
          this.cols));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IDatebox#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDatebox withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by replacing the {@link IDatebox#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDatebox withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by replacing the {@link IDatebox#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDatebox withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by replacing the {@link IDatebox#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDatebox withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#isReadonly() readonly} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for readonly
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withReadonly(boolean value) {
    if (this.readonly == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        value,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        value,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getPlaceholder() placeholder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for placeholder (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withPlaceholder(@Nullable String value) {
    if (Objects.equals(this.placeholder, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        value,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by replacing the {@link IDatebox#getInputAttributes() inputAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the inputAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDatebox withInputAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.inputAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        newValue,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withValue(@Nullable Date value) {
    if (this.value == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getConstraint() constraint} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for constraint (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withConstraint(@Nullable String value) {
    if (Objects.equals(this.constraint, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        value,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getErrorboxSclass() errorboxSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorboxSclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withErrorboxSclass(@Nullable String value) {
    if (Objects.equals(this.errorboxSclass, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        value,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getErrorboxIconSclass() errorboxIconSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorboxIconSclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withErrorboxIconSclass(@Nullable String value) {
    if (Objects.equals(this.errorboxIconSclass, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        value,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#isDisabled() disabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withDisabled(boolean value) {
    if (this.disabled == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        value,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#isInplace() inplace} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inplace
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withInplace(boolean value) {
    if (this.inplace == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        value,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getMaxlength() maxlength} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxlength
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withMaxlength(int value) {
    if (this.maxlength == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        value,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getInstant() instant} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for instant
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withInstant(boolean value) {
    if (this.instant == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        value,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getErrorMessage() errorMessage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorMessage (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withErrorMessage(@Nullable String value) {
    if (Objects.equals(this.errorMessage, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        value,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getFormat() format} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for format (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withFormat(@Nullable String value) {
    if (Objects.equals(this.format, value)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        value,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getLocale() locale} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withLocale(@Nullable Locale value) {
    if (this.locale == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        value,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getTimeZone() timeZone} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeZone
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withTimeZone(TimeZone value) {
    if (this.timeZone == value) return this;
    TimeZone newValue = Objects.requireNonNull(value, "timeZone");
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        newValue,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getValueInZonedDateTime() valueInZonedDateTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueInZonedDateTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withValueInZonedDateTime(@Nullable ZonedDateTime value) {
    if (this.valueInZonedDateTime == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        value,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getValueInLocalDateTime() valueInLocalDateTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueInLocalDateTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withValueInLocalDateTime(@Nullable LocalDateTime value) {
    if (this.valueInLocalDateTime == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        value,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getValueInLocalDate() valueInLocalDate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueInLocalDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withValueInLocalDate(@Nullable LocalDate value) {
    if (this.valueInLocalDate == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        value,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getValueInLocalTime() valueInLocalTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueInLocalTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withValueInLocalTime(@Nullable LocalTime value) {
    if (this.valueInLocalTime == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        value,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        newValue,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IDatebox#getDisplayedTimeZones() displayedTimeZones}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDatebox withDisplayedTimeZones(@Nullable TimeZone... elements) {
    if (elements == null) {
      return validate(new ImmutableIDatebox(
          this.id,
          this.action,
          this.actions,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.readonly,
          this.name,
          this.placeholder,
          this.inputAttributes,
          this.value,
          this.constraint,
          this.errorboxSclass,
          this.errorboxIconSclass,
          this.disabled,
          this.inplace,
          this.maxlength,
          this.instant,
          this.errorMessage,
          this.format,
          this.locale,
          this.timeZone,
          this.valueInZonedDateTime,
          this.valueInLocalDateTime,
          this.valueInLocalDate,
          this.valueInLocalTime,
          this.widgetClass,
          null,
          this.defaultDateTime,
          this.buttonVisible,
          this.lenient,
          this.timeZonesReadonly,
          this.weekOfYear,
          this.position,
          this.strictDate,
          this.showTodayLink,
          this.todayLinkLabel,
          this.selectLevel,
          this.closePopupOnTimezoneChange,
          this.cols));
    }
    @Nullable ImmutableList<TimeZone> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        newValue,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IDatebox#getDisplayedTimeZones() displayedTimeZones}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of displayedTimeZones elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDatebox withDisplayedTimeZones(@Nullable Iterable<? extends TimeZone> elements) {
    if (this.displayedTimeZones == elements) return this;
    @Nullable ImmutableList<TimeZone> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        newValue,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getDefaultDateTime() defaultDateTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultDateTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withDefaultDateTime(@Nullable LocalDateTime value) {
    if (this.defaultDateTime == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        value,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#isButtonVisible() buttonVisible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for buttonVisible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withButtonVisible(boolean value) {
    if (this.buttonVisible == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        value,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#isLenient() lenient} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lenient
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withLenient(boolean value) {
    if (this.lenient == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        value,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#isTimeZonesReadonly() timeZonesReadonly} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeZonesReadonly
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withTimeZonesReadonly(boolean value) {
    if (this.timeZonesReadonly == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        value,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#isWeekOfYear() weekOfYear} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for weekOfYear
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withWeekOfYear(boolean value) {
    if (this.weekOfYear == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        value,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getPosition() position} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for position
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withPosition(String value) {
    String newValue = Objects.requireNonNull(value, "position");
    if (this.position.equals(newValue)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        newValue,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#isStrictDate() strictDate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for strictDate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withStrictDate(boolean value) {
    if (this.strictDate == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        value,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getShowTodayLink() showTodayLink} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for showTodayLink
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withShowTodayLink(boolean value) {
    if (this.showTodayLink == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        value,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getTodayLinkLabel() todayLinkLabel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for todayLinkLabel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withTodayLinkLabel(String value) {
    String newValue = Objects.requireNonNull(value, "todayLinkLabel");
    if (this.todayLinkLabel.equals(newValue)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        newValue,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getSelectLevel() selectLevel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for selectLevel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withSelectLevel(String value) {
    String newValue = Objects.requireNonNull(value, "selectLevel");
    if (this.selectLevel.equals(newValue)) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        newValue,
        this.closePopupOnTimezoneChange,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getClosePopupOnTimezoneChange() closePopupOnTimezoneChange} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for closePopupOnTimezoneChange
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withClosePopupOnTimezoneChange(boolean value) {
    if (this.closePopupOnTimezoneChange == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        value,
        this.cols));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDatebox#getCols() cols} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cols
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDatebox withCols(int value) {
    if (this.cols == value) return this;
    return validate(new ImmutableIDatebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.displayedTimeZones,
        this.defaultDateTime,
        this.buttonVisible,
        this.lenient,
        this.timeZonesReadonly,
        this.weekOfYear,
        this.position,
        this.strictDate,
        this.showTodayLink,
        this.todayLinkLabel,
        this.selectLevel,
        this.closePopupOnTimezoneChange,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIDatebox} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIDatebox
        && equalTo((ImmutableIDatebox) another);
  }

  private boolean equalTo(ImmutableIDatebox another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && readonly == another.readonly
        && Objects.equals(name, another.name)
        && Objects.equals(placeholder, another.placeholder)
        && Objects.equals(inputAttributes, another.inputAttributes)
        && Objects.equals(value, another.value)
        && Objects.equals(constraint, another.constraint)
        && Objects.equals(errorboxSclass, another.errorboxSclass)
        && Objects.equals(errorboxIconSclass, another.errorboxIconSclass)
        && disabled == another.disabled
        && inplace == another.inplace
        && maxlength == another.maxlength
        && instant == another.instant
        && Objects.equals(errorMessage, another.errorMessage)
        && Objects.equals(format, another.format)
        && Objects.equals(locale, another.locale)
        && timeZone.equals(another.timeZone)
        && Objects.equals(valueInZonedDateTime, another.valueInZonedDateTime)
        && Objects.equals(valueInLocalDateTime, another.valueInLocalDateTime)
        && Objects.equals(valueInLocalDate, another.valueInLocalDate)
        && Objects.equals(valueInLocalTime, another.valueInLocalTime)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(displayedTimeZones, another.displayedTimeZones)
        && Objects.equals(defaultDateTime, another.defaultDateTime)
        && buttonVisible == another.buttonVisible
        && lenient == another.lenient
        && timeZonesReadonly == another.timeZonesReadonly
        && weekOfYear == another.weekOfYear
        && position.equals(another.position)
        && strictDate == another.strictDate
        && showTodayLink == another.showTodayLink
        && todayLinkLabel.equals(another.todayLinkLabel)
        && selectLevel.equals(another.selectLevel)
        && closePopupOnTimezoneChange == another.closePopupOnTimezoneChange
        && cols == another.cols;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code readonly}, {@code name}, {@code placeholder}, {@code inputAttributes}, {@code value}, {@code constraint}, {@code errorboxSclass}, {@code errorboxIconSclass}, {@code disabled}, {@code inplace}, {@code maxlength}, {@code instant}, {@code errorMessage}, {@code format}, {@code locale}, {@code timeZone}, {@code valueInZonedDateTime}, {@code valueInLocalDateTime}, {@code valueInLocalDate}, {@code valueInLocalTime}, {@code widgetClass}, {@code displayedTimeZones}, {@code defaultDateTime}, {@code buttonVisible}, {@code lenient}, {@code timeZonesReadonly}, {@code weekOfYear}, {@code position}, {@code strictDate}, {@code showTodayLink}, {@code todayLinkLabel}, {@code selectLevel}, {@code closePopupOnTimezoneChange}, {@code cols}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + Booleans.hashCode(readonly);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(placeholder);
    h += (h << 5) + Objects.hashCode(inputAttributes);
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Objects.hashCode(constraint);
    h += (h << 5) + Objects.hashCode(errorboxSclass);
    h += (h << 5) + Objects.hashCode(errorboxIconSclass);
    h += (h << 5) + Booleans.hashCode(disabled);
    h += (h << 5) + Booleans.hashCode(inplace);
    h += (h << 5) + maxlength;
    h += (h << 5) + Booleans.hashCode(instant);
    h += (h << 5) + Objects.hashCode(errorMessage);
    h += (h << 5) + Objects.hashCode(format);
    h += (h << 5) + Objects.hashCode(locale);
    h += (h << 5) + timeZone.hashCode();
    h += (h << 5) + Objects.hashCode(valueInZonedDateTime);
    h += (h << 5) + Objects.hashCode(valueInLocalDateTime);
    h += (h << 5) + Objects.hashCode(valueInLocalDate);
    h += (h << 5) + Objects.hashCode(valueInLocalTime);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(displayedTimeZones);
    h += (h << 5) + Objects.hashCode(defaultDateTime);
    h += (h << 5) + Booleans.hashCode(buttonVisible);
    h += (h << 5) + Booleans.hashCode(lenient);
    h += (h << 5) + Booleans.hashCode(timeZonesReadonly);
    h += (h << 5) + Booleans.hashCode(weekOfYear);
    h += (h << 5) + position.hashCode();
    h += (h << 5) + Booleans.hashCode(strictDate);
    h += (h << 5) + Booleans.hashCode(showTodayLink);
    h += (h << 5) + todayLinkLabel.hashCode();
    h += (h << 5) + selectLevel.hashCode();
    h += (h << 5) + Booleans.hashCode(closePopupOnTimezoneChange);
    h += (h << 5) + cols;
    return h;
  }

  /**
   * Prints the immutable value {@code IDatebox} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IDatebox")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("readonly", readonly)
        .add("name", name)
        .add("placeholder", placeholder)
        .add("inputAttributes", inputAttributes)
        .add("value", value)
        .add("constraint", constraint)
        .add("errorboxSclass", errorboxSclass)
        .add("errorboxIconSclass", errorboxIconSclass)
        .add("disabled", disabled)
        .add("inplace", inplace)
        .add("maxlength", maxlength)
        .add("instant", instant)
        .add("errorMessage", errorMessage)
        .add("format", format)
        .add("locale", locale)
        .add("timeZone", timeZone)
        .add("valueInZonedDateTime", valueInZonedDateTime)
        .add("valueInLocalDateTime", valueInLocalDateTime)
        .add("valueInLocalDate", valueInLocalDate)
        .add("valueInLocalTime", valueInLocalTime)
        .add("widgetClass", widgetClass)
        .add("displayedTimeZones", displayedTimeZones)
        .add("defaultDateTime", defaultDateTime)
        .add("buttonVisible", buttonVisible)
        .add("lenient", lenient)
        .add("timeZonesReadonly", timeZonesReadonly)
        .add("weekOfYear", weekOfYear)
        .add("position", position)
        .add("strictDate", strictDate)
        .add("showTodayLink", showTodayLink)
        .add("todayLinkLabel", todayLinkLabel)
        .add("selectLevel", selectLevel)
        .add("closePopupOnTimezoneChange", closePopupOnTimezoneChange)
        .add("cols", cols)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long ZONE_ID_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient ZoneId zoneId;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IDatebox#getZoneId() zoneId} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zoneId} attribute
   */
  @Override
  public ZoneId getZoneId() {
    if ((lazyInitBitmap & ZONE_ID_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ZONE_ID_LAZY_INIT_BIT) == 0) {
          this.zoneId = IDatebox.super.getZoneId();
          lazyInitBitmap |= ZONE_ID_LAZY_INIT_BIT;
        }
      }
    }
    return zoneId;
  }

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient Class<Datebox> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IDatebox#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Datebox> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IDatebox.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static final long UNFORMATER_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient String unformater;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IDatebox#getUnformater() unformater} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code unformater} attribute
   */
  @Override
  public String getUnformater() {
    if ((lazyInitBitmap & UNFORMATER_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & UNFORMATER_LAZY_INIT_BIT) == 0) {
          this.unformater = IDatebox.super.getUnformater();
          lazyInitBitmap |= UNFORMATER_LAZY_INIT_BIT;
        }
      }
    }
    return unformater;
  }

  private static final long REAL_FORMAT_LAZY_INIT_BIT = 0x8L;

  @SuppressWarnings("Immutable")
  private transient String realFormat;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IDatebox#getRealFormat() realFormat} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code realFormat} attribute
   */
  @Override
  public String getRealFormat() {
    if ((lazyInitBitmap & REAL_FORMAT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & REAL_FORMAT_LAZY_INIT_BIT) == 0) {
          this.realFormat = Objects.requireNonNull(IDatebox.super.getRealFormat(), "realFormat");
          lazyInitBitmap |= REAL_FORMAT_LAZY_INIT_BIT;
        }
      }
    }
    return realFormat;
  }

  private static ImmutableIDatebox validate(ImmutableIDatebox instance) {
    instance = (ImmutableIDatebox) instance.updateValue();
    instance.checkSelectLevel();
    instance.checkCols();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIDatebox) instance.checkDroppable();
    instance = (ImmutableIDatebox) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IDatebox} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IDatebox instance
   */
  public static IDatebox copyOf(IDatebox instance) {
    if (instance instanceof ImmutableIDatebox) {
      return (ImmutableIDatebox) instance;
    }
    return new IDatebox.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IDatebox IDatebox}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IDatebox", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_READONLY = 0x10L;
    private static final long OPT_BIT_DISABLED = 0x20L;
    private static final long OPT_BIT_INPLACE = 0x40L;
    private static final long OPT_BIT_MAXLENGTH = 0x80L;
    private static final long OPT_BIT_INSTANT = 0x100L;
    private static final long OPT_BIT_VALUE_IN_ZONED_DATE_TIME = 0x200L;
    private static final long OPT_BIT_VALUE_IN_LOCAL_DATE_TIME = 0x400L;
    private static final long OPT_BIT_VALUE_IN_LOCAL_DATE = 0x800L;
    private static final long OPT_BIT_VALUE_IN_LOCAL_TIME = 0x1000L;
    private static final long OPT_BIT_DISPLAYED_TIME_ZONES = 0x2000L;
    private static final long OPT_BIT_BUTTON_VISIBLE = 0x4000L;
    private static final long OPT_BIT_LENIENT = 0x8000L;
    private static final long OPT_BIT_TIME_ZONES_READONLY = 0x10000L;
    private static final long OPT_BIT_WEEK_OF_YEAR = 0x20000L;
    private static final long OPT_BIT_STRICT_DATE = 0x40000L;
    private static final long OPT_BIT_SHOW_TODAY_LINK = 0x80000L;
    private static final long OPT_BIT_CLOSE_POPUP_ON_TIMEZONE_CHANGE = 0x100000L;
    private static final long OPT_BIT_COLS = 0x200000L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private boolean readonly;
    private @Nullable String name;
    private @Nullable String placeholder;
    private ImmutableMap.Builder<String, String> inputAttributes = null;
    private @Nullable Date value;
    private @Nullable String constraint;
    private @Nullable String errorboxSclass;
    private @Nullable String errorboxIconSclass;
    private boolean disabled;
    private boolean inplace;
    private int maxlength;
    private boolean instant;
    private @Nullable String errorMessage;
    private @Nullable String format;
    private @Nullable Locale locale;
    private @Nullable TimeZone timeZone;
    private @Nullable ZonedDateTime valueInZonedDateTime;
    private @Nullable LocalDateTime valueInLocalDateTime;
    private @Nullable LocalDate valueInLocalDate;
    private @Nullable LocalTime valueInLocalTime;
    private @Nullable String widgetClass;
    private ImmutableList.Builder<TimeZone> displayedTimeZones = null;
    private @Nullable LocalDateTime defaultDateTime;
    private boolean buttonVisible;
    private boolean lenient;
    private boolean timeZonesReadonly;
    private boolean weekOfYear;
    private @Nullable String position;
    private boolean strictDate;
    private boolean showTodayLink;
    private @Nullable String todayLinkLabel;
    private @Nullable String selectLevel;
    private boolean closePopupOnTimezoneChange;
    private int cols;

    /**
     * Creates a builder for {@link IDatebox IDatebox} instances.
     * <pre>
     * new IDatebox.Builder()
     *    .setId(String) // optional {@link IDatebox#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IDatebox#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IDatebox#getActions() actions}
     *    .setVisible(boolean) // optional {@link IDatebox#isVisible() visible}
     *    .setMold(String) // optional {@link IDatebox#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IDatebox#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IDatebox#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IDatebox#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IDatebox#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IDatebox#getLeft() left}
     *    .setTop(String | null) // nullable {@link IDatebox#getTop() top}
     *    .setZIndex(int) // optional {@link IDatebox#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IDatebox#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IDatebox#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IDatebox#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IDatebox#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IDatebox#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IDatebox#getStyle() style}
     *    .setDraggable(String) // optional {@link IDatebox#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IDatebox#isFocus() focus}
     *    .setDroppable(String) // optional {@link IDatebox#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IDatebox#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IDatebox#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IDatebox#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IDatebox#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IDatebox#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IDatebox#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IDatebox#getContext() context}
     *    .setPopup(String | null) // nullable {@link IDatebox#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IDatebox#getTooltip() tooltip}
     *    .setReadonly(boolean) // optional {@link IDatebox#isReadonly() readonly}
     *    .setName(String | null) // nullable {@link IDatebox#getName() name}
     *    .setPlaceholder(String | null) // nullable {@link IDatebox#getPlaceholder() placeholder}
     *    .setInputAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IDatebox#getInputAttributes() inputAttributes}
     *    .setValue(Date | null) // nullable {@link IDatebox#getValue() value}
     *    .setConstraint(String | null) // nullable {@link IDatebox#getConstraint() constraint}
     *    .setErrorboxSclass(String | null) // nullable {@link IDatebox#getErrorboxSclass() errorboxSclass}
     *    .setErrorboxIconSclass(String | null) // nullable {@link IDatebox#getErrorboxIconSclass() errorboxIconSclass}
     *    .setDisabled(boolean) // optional {@link IDatebox#isDisabled() disabled}
     *    .setInplace(boolean) // optional {@link IDatebox#isInplace() inplace}
     *    .setMaxlength(int) // optional {@link IDatebox#getMaxlength() maxlength}
     *    .setInstant(boolean) // optional {@link IDatebox#getInstant() instant}
     *    .setErrorMessage(String | null) // nullable {@link IDatebox#getErrorMessage() errorMessage}
     *    .setFormat(String | null) // nullable {@link IDatebox#getFormat() format}
     *    .setLocale(Locale | null) // nullable {@link IDatebox#getLocale() locale}
     *    .setTimeZone(TimeZone) // optional {@link IDatebox#getTimeZone() timeZone}
     *    .setValueInZonedDateTime(java.time.ZonedDateTime | null) // nullable {@link IDatebox#getValueInZonedDateTime() valueInZonedDateTime}
     *    .setValueInLocalDateTime(java.time.LocalDateTime | null) // nullable {@link IDatebox#getValueInLocalDateTime() valueInLocalDateTime}
     *    .setValueInLocalDate(java.time.LocalDate | null) // nullable {@link IDatebox#getValueInLocalDate() valueInLocalDate}
     *    .setValueInLocalTime(java.time.LocalTime | null) // nullable {@link IDatebox#getValueInLocalTime() valueInLocalTime}
     *    .setWidgetClass(String) // optional {@link IDatebox#getWidgetClass() widgetClass}
     *    .setDisplayedTimeZones(List&amp;lt;TimeZone&amp;gt; | null) // nullable {@link IDatebox#getDisplayedTimeZones() displayedTimeZones}
     *    .setDefaultDateTime(java.time.LocalDateTime | null) // nullable {@link IDatebox#getDefaultDateTime() defaultDateTime}
     *    .setButtonVisible(boolean) // optional {@link IDatebox#isButtonVisible() buttonVisible}
     *    .setLenient(boolean) // optional {@link IDatebox#isLenient() lenient}
     *    .setTimeZonesReadonly(boolean) // optional {@link IDatebox#isTimeZonesReadonly() timeZonesReadonly}
     *    .setWeekOfYear(boolean) // optional {@link IDatebox#isWeekOfYear() weekOfYear}
     *    .setPosition(String) // optional {@link IDatebox#getPosition() position}
     *    .setStrictDate(boolean) // optional {@link IDatebox#isStrictDate() strictDate}
     *    .setShowTodayLink(boolean) // optional {@link IDatebox#getShowTodayLink() showTodayLink}
     *    .setTodayLinkLabel(String) // optional {@link IDatebox#getTodayLinkLabel() todayLinkLabel}
     *    .setSelectLevel(String) // optional {@link IDatebox#getSelectLevel() selectLevel}
     *    .setClosePopupOnTimezoneChange(boolean) // optional {@link IDatebox#getClosePopupOnTimezoneChange() closePopupOnTimezoneChange}
     *    .setCols(int) // optional {@link IDatebox#getCols() cols}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IDatebox.Builder)) {
        throw new UnsupportedOperationException("Use: new IDatebox.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IDatebox} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder from(IDatebox instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setReadonly(instance.isReadonly());
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        setName(nameValue);
      }
      @Nullable String placeholderValue = instance.getPlaceholder();
      if (placeholderValue != null) {
        setPlaceholder(placeholderValue);
      }
      @Nullable Map<String, String> inputAttributesValue = instance.getInputAttributes();
      if (inputAttributesValue != null) {
        putAllInputAttributes(inputAttributesValue);
      }
      @Nullable Date valueValue = instance.getValue();
      if (valueValue != null) {
        setValue(valueValue);
      }
      @Nullable String constraintValue = instance.getConstraint();
      if (constraintValue != null) {
        setConstraint(constraintValue);
      }
      @Nullable String errorboxSclassValue = instance.getErrorboxSclass();
      if (errorboxSclassValue != null) {
        setErrorboxSclass(errorboxSclassValue);
      }
      @Nullable String errorboxIconSclassValue = instance.getErrorboxIconSclass();
      if (errorboxIconSclassValue != null) {
        setErrorboxIconSclass(errorboxIconSclassValue);
      }
      setDisabled(instance.isDisabled());
      setInplace(instance.isInplace());
      setMaxlength(instance.getMaxlength());
      setInstant(instance.getInstant());
      @Nullable String errorMessageValue = instance.getErrorMessage();
      if (errorMessageValue != null) {
        setErrorMessage(errorMessageValue);
      }
      @Nullable String formatValue = instance.getFormat();
      if (formatValue != null) {
        setFormat(formatValue);
      }
      @Nullable Locale localeValue = instance.getLocale();
      if (localeValue != null) {
        setLocale(localeValue);
      }
      setTimeZone(instance.getTimeZone());
      @Nullable ZonedDateTime valueInZonedDateTimeValue = instance.getValueInZonedDateTime();
      if (valueInZonedDateTimeValue != null) {
        setValueInZonedDateTime(valueInZonedDateTimeValue);
      }
      @Nullable LocalDateTime valueInLocalDateTimeValue = instance.getValueInLocalDateTime();
      if (valueInLocalDateTimeValue != null) {
        setValueInLocalDateTime(valueInLocalDateTimeValue);
      }
      @Nullable LocalDate valueInLocalDateValue = instance.getValueInLocalDate();
      if (valueInLocalDateValue != null) {
        setValueInLocalDate(valueInLocalDateValue);
      }
      @Nullable LocalTime valueInLocalTimeValue = instance.getValueInLocalTime();
      if (valueInLocalTimeValue != null) {
        setValueInLocalTime(valueInLocalTimeValue);
      }
      setWidgetClass(instance.getWidgetClass());
      @Nullable List<TimeZone> displayedTimeZonesValue = instance.getDisplayedTimeZones();
      if (displayedTimeZonesValue != null) {
        addAllDisplayedTimeZones(displayedTimeZonesValue);
      }
      @Nullable LocalDateTime defaultDateTimeValue = instance.getDefaultDateTime();
      if (defaultDateTimeValue != null) {
        setDefaultDateTime(defaultDateTimeValue);
      }
      setButtonVisible(instance.isButtonVisible());
      setLenient(instance.isLenient());
      setTimeZonesReadonly(instance.isTimeZonesReadonly());
      setWeekOfYear(instance.isWeekOfYear());
      setPosition(instance.getPosition());
      setStrictDate(instance.isStrictDate());
      setShowTodayLink(instance.getShowTodayLink());
      setTodayLinkLabel(instance.getTodayLinkLabel());
      setSelectLevel(instance.getSelectLevel());
      setClosePopupOnTimezoneChange(instance.getClosePopupOnTimezoneChange());
      setCols(instance.getCols());
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IDatebox.Builder) this;
    }

    /**
     * Adds one element to {@link IDatebox#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IDatebox.Builder) this;
    }

    /**
     * Adds elements to {@link IDatebox#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IDatebox.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IDatebox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IDatebox.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IDatebox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IDatebox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDatebox#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IDatebox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDatebox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IDatebox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IDatebox#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IDatebox.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IDatebox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IDatebox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDatebox#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IDatebox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDatebox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IDatebox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IDatebox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IDatebox.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IDatebox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IDatebox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDatebox#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IDatebox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDatebox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IDatebox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IDatebox#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IDatebox.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IDatebox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setTop(@Nullable String top) {
      this.top = top;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setContext(@Nullable String context) {
      this.context = context;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#isReadonly() readonly} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#isReadonly() readonly}.</em>
     * @param readonly The value for readonly 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setReadonly(boolean readonly) {
      this.readonly = readonly;
      optBits |= OPT_BIT_READONLY;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setName(@Nullable String name) {
      this.name = name;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getPlaceholder() placeholder} attribute.
     * @param placeholder The value for placeholder (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setPlaceholder(@Nullable String placeholder) {
      this.placeholder = placeholder;
      return (IDatebox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDatebox#getInputAttributes() inputAttributes} map.
     * @param key The key in the inputAttributes map
     * @param value The associated value in the inputAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder putInputAttributes(String key, String value) {
      if (this.inputAttributes == null) {
        this.inputAttributes = ImmutableMap.builder();
      }
      this.inputAttributes.put(key, value);
      return (IDatebox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDatebox#getInputAttributes() inputAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder putInputAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.inputAttributes == null) {
        this.inputAttributes = ImmutableMap.builder();
      }
      this.inputAttributes.put(entry);
      return (IDatebox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IDatebox#getInputAttributes() inputAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the inputAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setInputAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.inputAttributes = null;
        return (IDatebox.Builder) this;
      }
      this.inputAttributes = ImmutableMap.builder();
      return putAllInputAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IDatebox#getInputAttributes() inputAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the inputAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder putAllInputAttributes(Map<String, ? extends String> entries) {
      if (this.inputAttributes == null) {
        this.inputAttributes = ImmutableMap.builder();
      }
      this.inputAttributes.putAll(entries);
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setValue(@Nullable Date value) {
      this.value = value;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getConstraint() constraint} attribute.
     * @param constraint The value for constraint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setConstraint(@Nullable String constraint) {
      this.constraint = constraint;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getErrorboxSclass() errorboxSclass} attribute.
     * @param errorboxSclass The value for errorboxSclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setErrorboxSclass(@Nullable String errorboxSclass) {
      this.errorboxSclass = errorboxSclass;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getErrorboxIconSclass() errorboxIconSclass} attribute.
     * @param errorboxIconSclass The value for errorboxIconSclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setErrorboxIconSclass(@Nullable String errorboxIconSclass) {
      this.errorboxIconSclass = errorboxIconSclass;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#isDisabled() disabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#isDisabled() disabled}.</em>
     * @param disabled The value for disabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setDisabled(boolean disabled) {
      this.disabled = disabled;
      optBits |= OPT_BIT_DISABLED;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#isInplace() inplace} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#isInplace() inplace}.</em>
     * @param inplace The value for inplace 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setInplace(boolean inplace) {
      this.inplace = inplace;
      optBits |= OPT_BIT_INPLACE;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getMaxlength() maxlength} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getMaxlength() maxlength}.</em>
     * @param maxlength The value for maxlength 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setMaxlength(int maxlength) {
      this.maxlength = maxlength;
      optBits |= OPT_BIT_MAXLENGTH;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getInstant() instant} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getInstant() instant}.</em>
     * @param instant The value for instant 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setInstant(boolean instant) {
      this.instant = instant;
      optBits |= OPT_BIT_INSTANT;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getErrorMessage() errorMessage} attribute.
     * @param errorMessage The value for errorMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setErrorMessage(@Nullable String errorMessage) {
      this.errorMessage = errorMessage;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getFormat() format} attribute.
     * @param format The value for format (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setFormat(@Nullable String format) {
      this.format = format;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getLocale() locale} attribute.
     * @param locale The value for locale (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setLocale(@Nullable Locale locale) {
      this.locale = locale;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getTimeZone() timeZone} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getTimeZone() timeZone}.</em>
     * @param timeZone The value for timeZone 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setTimeZone(TimeZone timeZone) {
      this.timeZone = Objects.requireNonNull(timeZone, "timeZone");
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getValueInZonedDateTime() valueInZonedDateTime} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getValueInZonedDateTime() valueInZonedDateTime}.</em>
     * @param valueInZonedDateTime The value for valueInZonedDateTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setValueInZonedDateTime(@Nullable ZonedDateTime valueInZonedDateTime) {
      this.valueInZonedDateTime = valueInZonedDateTime;
      optBits |= OPT_BIT_VALUE_IN_ZONED_DATE_TIME;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getValueInLocalDateTime() valueInLocalDateTime} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getValueInLocalDateTime() valueInLocalDateTime}.</em>
     * @param valueInLocalDateTime The value for valueInLocalDateTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setValueInLocalDateTime(@Nullable LocalDateTime valueInLocalDateTime) {
      this.valueInLocalDateTime = valueInLocalDateTime;
      optBits |= OPT_BIT_VALUE_IN_LOCAL_DATE_TIME;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getValueInLocalDate() valueInLocalDate} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getValueInLocalDate() valueInLocalDate}.</em>
     * @param valueInLocalDate The value for valueInLocalDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setValueInLocalDate(@Nullable LocalDate valueInLocalDate) {
      this.valueInLocalDate = valueInLocalDate;
      optBits |= OPT_BIT_VALUE_IN_LOCAL_DATE;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getValueInLocalTime() valueInLocalTime} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getValueInLocalTime() valueInLocalTime}.</em>
     * @param valueInLocalTime The value for valueInLocalTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setValueInLocalTime(@Nullable LocalTime valueInLocalTime) {
      this.valueInLocalTime = valueInLocalTime;
      optBits |= OPT_BIT_VALUE_IN_LOCAL_TIME;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IDatebox.Builder) this;
    }

    /**
     * Adds one element to {@link IDatebox#getDisplayedTimeZones() displayedTimeZones} list.
     * @param element A displayedTimeZones element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder addDisplayedTimeZones(TimeZone element) {
      if (this.displayedTimeZones == null) {
        this.displayedTimeZones = ImmutableList.builder();
      }
      this.displayedTimeZones.add(element);
      optBits |= OPT_BIT_DISPLAYED_TIME_ZONES;
      return (IDatebox.Builder) this;
    }

    /**
     * Adds elements to {@link IDatebox#getDisplayedTimeZones() displayedTimeZones} list.
     * @param elements An array of displayedTimeZones elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder addDisplayedTimeZones(TimeZone... elements) {
      if (this.displayedTimeZones == null) {
        this.displayedTimeZones = ImmutableList.builder();
      }
      this.displayedTimeZones.add(elements);
      optBits |= OPT_BIT_DISPLAYED_TIME_ZONES;
      return (IDatebox.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IDatebox#getDisplayedTimeZones() displayedTimeZones} list.
     * @param elements An iterable of displayedTimeZones elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setDisplayedTimeZones(@Nullable Iterable<? extends TimeZone> elements) {
      if (elements == null) {
        this.displayedTimeZones = null;
        optBits |= OPT_BIT_DISPLAYED_TIME_ZONES;
        return (IDatebox.Builder) this;
      }
      this.displayedTimeZones = ImmutableList.builder();
      return addAllDisplayedTimeZones(elements);
    }

    /**
     * Adds elements to {@link IDatebox#getDisplayedTimeZones() displayedTimeZones} list.
     * @param elements An iterable of displayedTimeZones elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder addAllDisplayedTimeZones(Iterable<? extends TimeZone> elements) {
      Objects.requireNonNull(elements, "displayedTimeZones element");
      if (this.displayedTimeZones == null) {
        this.displayedTimeZones = ImmutableList.builder();
      }
      this.displayedTimeZones.addAll(elements);
      optBits |= OPT_BIT_DISPLAYED_TIME_ZONES;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getDefaultDateTime() defaultDateTime} attribute.
     * @param defaultDateTime The value for defaultDateTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setDefaultDateTime(@Nullable LocalDateTime defaultDateTime) {
      this.defaultDateTime = defaultDateTime;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#isButtonVisible() buttonVisible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#isButtonVisible() buttonVisible}.</em>
     * @param buttonVisible The value for buttonVisible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setButtonVisible(boolean buttonVisible) {
      this.buttonVisible = buttonVisible;
      optBits |= OPT_BIT_BUTTON_VISIBLE;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#isLenient() lenient} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#isLenient() lenient}.</em>
     * @param lenient The value for lenient 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setLenient(boolean lenient) {
      this.lenient = lenient;
      optBits |= OPT_BIT_LENIENT;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#isTimeZonesReadonly() timeZonesReadonly} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#isTimeZonesReadonly() timeZonesReadonly}.</em>
     * @param timeZonesReadonly The value for timeZonesReadonly 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setTimeZonesReadonly(boolean timeZonesReadonly) {
      this.timeZonesReadonly = timeZonesReadonly;
      optBits |= OPT_BIT_TIME_ZONES_READONLY;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#isWeekOfYear() weekOfYear} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#isWeekOfYear() weekOfYear}.</em>
     * @param weekOfYear The value for weekOfYear 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setWeekOfYear(boolean weekOfYear) {
      this.weekOfYear = weekOfYear;
      optBits |= OPT_BIT_WEEK_OF_YEAR;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getPosition() position} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getPosition() position}.</em>
     * @param position The value for position 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setPosition(String position) {
      this.position = Objects.requireNonNull(position, "position");
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#isStrictDate() strictDate} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#isStrictDate() strictDate}.</em>
     * @param strictDate The value for strictDate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setStrictDate(boolean strictDate) {
      this.strictDate = strictDate;
      optBits |= OPT_BIT_STRICT_DATE;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getShowTodayLink() showTodayLink} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getShowTodayLink() showTodayLink}.</em>
     * @param showTodayLink The value for showTodayLink 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setShowTodayLink(boolean showTodayLink) {
      this.showTodayLink = showTodayLink;
      optBits |= OPT_BIT_SHOW_TODAY_LINK;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getTodayLinkLabel() todayLinkLabel} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getTodayLinkLabel() todayLinkLabel}.</em>
     * @param todayLinkLabel The value for todayLinkLabel 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setTodayLinkLabel(String todayLinkLabel) {
      this.todayLinkLabel = Objects.requireNonNull(todayLinkLabel, "todayLinkLabel");
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getSelectLevel() selectLevel} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getSelectLevel() selectLevel}.</em>
     * @param selectLevel The value for selectLevel 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setSelectLevel(String selectLevel) {
      this.selectLevel = Objects.requireNonNull(selectLevel, "selectLevel");
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getClosePopupOnTimezoneChange() closePopupOnTimezoneChange} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getClosePopupOnTimezoneChange() closePopupOnTimezoneChange}.</em>
     * @param closePopupOnTimezoneChange The value for closePopupOnTimezoneChange 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setClosePopupOnTimezoneChange(boolean closePopupOnTimezoneChange) {
      this.closePopupOnTimezoneChange = closePopupOnTimezoneChange;
      optBits |= OPT_BIT_CLOSE_POPUP_ON_TIMEZONE_CHANGE;
      return (IDatebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDatebox#getCols() cols} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDatebox#getCols() cols}.</em>
     * @param cols The value for cols 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDatebox.Builder setCols(int cols) {
      this.cols = cols;
      optBits |= OPT_BIT_COLS;
      return (IDatebox.Builder) this;
    }

    /**
     * Builds a new {@link IDatebox IDatebox}.
     * @return An immutable instance of IDatebox
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IDatebox build() {
      return ImmutableIDatebox.validate(new ImmutableIDatebox(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean readonlyIsSet() {
      return (optBits & OPT_BIT_READONLY) != 0;
    }

    private boolean disabledIsSet() {
      return (optBits & OPT_BIT_DISABLED) != 0;
    }

    private boolean inplaceIsSet() {
      return (optBits & OPT_BIT_INPLACE) != 0;
    }

    private boolean maxlengthIsSet() {
      return (optBits & OPT_BIT_MAXLENGTH) != 0;
    }

    private boolean instantIsSet() {
      return (optBits & OPT_BIT_INSTANT) != 0;
    }

    private boolean valueInZonedDateTimeIsSet() {
      return (optBits & OPT_BIT_VALUE_IN_ZONED_DATE_TIME) != 0;
    }

    private boolean valueInLocalDateTimeIsSet() {
      return (optBits & OPT_BIT_VALUE_IN_LOCAL_DATE_TIME) != 0;
    }

    private boolean valueInLocalDateIsSet() {
      return (optBits & OPT_BIT_VALUE_IN_LOCAL_DATE) != 0;
    }

    private boolean valueInLocalTimeIsSet() {
      return (optBits & OPT_BIT_VALUE_IN_LOCAL_TIME) != 0;
    }

    private boolean displayedTimeZonesIsSet() {
      return (optBits & OPT_BIT_DISPLAYED_TIME_ZONES) != 0;
    }

    private boolean buttonVisibleIsSet() {
      return (optBits & OPT_BIT_BUTTON_VISIBLE) != 0;
    }

    private boolean lenientIsSet() {
      return (optBits & OPT_BIT_LENIENT) != 0;
    }

    private boolean timeZonesReadonlyIsSet() {
      return (optBits & OPT_BIT_TIME_ZONES_READONLY) != 0;
    }

    private boolean weekOfYearIsSet() {
      return (optBits & OPT_BIT_WEEK_OF_YEAR) != 0;
    }

    private boolean strictDateIsSet() {
      return (optBits & OPT_BIT_STRICT_DATE) != 0;
    }

    private boolean showTodayLinkIsSet() {
      return (optBits & OPT_BIT_SHOW_TODAY_LINK) != 0;
    }

    private boolean closePopupOnTimezoneChangeIsSet() {
      return (optBits & OPT_BIT_CLOSE_POPUP_ON_TIMEZONE_CHANGE) != 0;
    }

    private boolean colsIsSet() {
      return (optBits & OPT_BIT_COLS) != 0;
    }
  }
}
