package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zkmax.zul.Biglistbox;
import org.zkoss.zkmax.zul.MatrixComparatorProvider;

/**
 * Immutable implementation of {@link IBiglistbox}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IBiglistbox.Builder()}.
 */
@Generated(from = "IBiglistbox", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIBiglistbox implements IBiglistbox {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final String widgetClass;
  private final boolean autoCols;
  private final boolean autoRows;
  private final int frozenCols;
  private final boolean fixFrozenCols;
  private final String oddRowSclass;
  private final int preloadSize;
  private final int rows;
  private final int cols;
  private final String rowHeight;
  private final String colWidth;
  private final @Nullable MatrixComparatorProvider<?> sortAscending;
  private final @Nullable MatrixComparatorProvider<?> sortDescending;
  private final ImmutableMap<String, Object> auxInfo;

  private ImmutableIBiglistbox(ImmutableIBiglistbox.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.sortAscending = builder.sortAscending;
    this.sortDescending = builder.sortDescending;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.autoColsIsSet()) {
      initShim.setAutoCols(builder.autoCols);
    }
    if (builder.autoRowsIsSet()) {
      initShim.setAutoRows(builder.autoRows);
    }
    if (builder.frozenColsIsSet()) {
      initShim.setFrozenCols(builder.frozenCols);
    }
    if (builder.fixFrozenColsIsSet()) {
      initShim.setFixFrozenCols(builder.fixFrozenCols);
    }
    if (builder.oddRowSclass != null) {
      initShim.setOddRowSclass(builder.oddRowSclass);
    }
    if (builder.preloadSizeIsSet()) {
      initShim.setPreloadSize(builder.preloadSize);
    }
    if (builder.rowsIsSet()) {
      initShim.setRows(builder.rows);
    }
    if (builder.colsIsSet()) {
      initShim.setCols(builder.cols);
    }
    if (builder.rowHeight != null) {
      initShim.setRowHeight(builder.rowHeight);
    }
    if (builder.colWidth != null) {
      initShim.setColWidth(builder.colWidth);
    }
    if (builder.auxInfoIsSet()) {
      initShim.setAuxInfo(builder.auxInfo.build());
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.widgetClass = initShim.getWidgetClass();
    this.autoCols = initShim.isAutoCols();
    this.autoRows = initShim.isAutoRows();
    this.frozenCols = initShim.getFrozenCols();
    this.fixFrozenCols = initShim.isFixFrozenCols();
    this.oddRowSclass = initShim.getOddRowSclass();
    this.preloadSize = initShim.getPreloadSize();
    this.rows = initShim.getRows();
    this.cols = initShim.getCols();
    this.rowHeight = initShim.getRowHeight();
    this.colWidth = initShim.getColWidth();
    this.auxInfo = initShim.getAuxInfo();
    this.initShim = null;
  }

  private ImmutableIBiglistbox(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      String widgetClass,
      boolean autoCols,
      boolean autoRows,
      int frozenCols,
      boolean fixFrozenCols,
      String oddRowSclass,
      int preloadSize,
      int rows,
      int cols,
      String rowHeight,
      String colWidth,
      @Nullable MatrixComparatorProvider<?> sortAscending,
      @Nullable MatrixComparatorProvider<?> sortDescending,
      ImmutableMap<String, Object> auxInfo) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.widgetClass = widgetClass;
    this.autoCols = autoCols;
    this.autoRows = autoRows;
    this.frozenCols = frozenCols;
    this.fixFrozenCols = fixFrozenCols;
    this.oddRowSclass = oddRowSclass;
    this.preloadSize = preloadSize;
    this.rows = rows;
    this.cols = cols;
    this.rowHeight = rowHeight;
    this.colWidth = colWidth;
    this.sortAscending = sortAscending;
    this.sortDescending = sortDescending;
    this.auxInfo = auxInfo;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IBiglistbox", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte autoColsBuildStage = STAGE_UNINITIALIZED;
    private boolean autoCols;

    boolean isAutoCols() {
      if (autoColsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (autoColsBuildStage == STAGE_UNINITIALIZED) {
        autoColsBuildStage = STAGE_INITIALIZING;
        this.autoCols = isAutoColsInitialize();
        autoColsBuildStage = STAGE_INITIALIZED;
      }
      return this.autoCols;
    }

    void setAutoCols(boolean autoCols) {
      this.autoCols = autoCols;
      autoColsBuildStage = STAGE_INITIALIZED;
    }

    private byte autoRowsBuildStage = STAGE_UNINITIALIZED;
    private boolean autoRows;

    boolean isAutoRows() {
      if (autoRowsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (autoRowsBuildStage == STAGE_UNINITIALIZED) {
        autoRowsBuildStage = STAGE_INITIALIZING;
        this.autoRows = isAutoRowsInitialize();
        autoRowsBuildStage = STAGE_INITIALIZED;
      }
      return this.autoRows;
    }

    void setAutoRows(boolean autoRows) {
      this.autoRows = autoRows;
      autoRowsBuildStage = STAGE_INITIALIZED;
    }

    private byte frozenColsBuildStage = STAGE_UNINITIALIZED;
    private int frozenCols;

    int getFrozenCols() {
      if (frozenColsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (frozenColsBuildStage == STAGE_UNINITIALIZED) {
        frozenColsBuildStage = STAGE_INITIALIZING;
        this.frozenCols = getFrozenColsInitialize();
        frozenColsBuildStage = STAGE_INITIALIZED;
      }
      return this.frozenCols;
    }

    void setFrozenCols(int frozenCols) {
      this.frozenCols = frozenCols;
      frozenColsBuildStage = STAGE_INITIALIZED;
    }

    private byte fixFrozenColsBuildStage = STAGE_UNINITIALIZED;
    private boolean fixFrozenCols;

    boolean isFixFrozenCols() {
      if (fixFrozenColsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fixFrozenColsBuildStage == STAGE_UNINITIALIZED) {
        fixFrozenColsBuildStage = STAGE_INITIALIZING;
        this.fixFrozenCols = isFixFrozenColsInitialize();
        fixFrozenColsBuildStage = STAGE_INITIALIZED;
      }
      return this.fixFrozenCols;
    }

    void setFixFrozenCols(boolean fixFrozenCols) {
      this.fixFrozenCols = fixFrozenCols;
      fixFrozenColsBuildStage = STAGE_INITIALIZED;
    }

    private byte oddRowSclassBuildStage = STAGE_UNINITIALIZED;
    private String oddRowSclass;

    String getOddRowSclass() {
      if (oddRowSclassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (oddRowSclassBuildStage == STAGE_UNINITIALIZED) {
        oddRowSclassBuildStage = STAGE_INITIALIZING;
        this.oddRowSclass = Objects.requireNonNull(getOddRowSclassInitialize(), "oddRowSclass");
        oddRowSclassBuildStage = STAGE_INITIALIZED;
      }
      return this.oddRowSclass;
    }

    void setOddRowSclass(String oddRowSclass) {
      this.oddRowSclass = oddRowSclass;
      oddRowSclassBuildStage = STAGE_INITIALIZED;
    }

    private byte preloadSizeBuildStage = STAGE_UNINITIALIZED;
    private int preloadSize;

    int getPreloadSize() {
      if (preloadSizeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (preloadSizeBuildStage == STAGE_UNINITIALIZED) {
        preloadSizeBuildStage = STAGE_INITIALIZING;
        this.preloadSize = getPreloadSizeInitialize();
        preloadSizeBuildStage = STAGE_INITIALIZED;
      }
      return this.preloadSize;
    }

    void setPreloadSize(int preloadSize) {
      this.preloadSize = preloadSize;
      preloadSizeBuildStage = STAGE_INITIALIZED;
    }

    private byte rowsBuildStage = STAGE_UNINITIALIZED;
    private int rows;

    int getRows() {
      if (rowsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rowsBuildStage == STAGE_UNINITIALIZED) {
        rowsBuildStage = STAGE_INITIALIZING;
        this.rows = getRowsInitialize();
        rowsBuildStage = STAGE_INITIALIZED;
      }
      return this.rows;
    }

    void setRows(int rows) {
      this.rows = rows;
      rowsBuildStage = STAGE_INITIALIZED;
    }

    private byte colsBuildStage = STAGE_UNINITIALIZED;
    private int cols;

    int getCols() {
      if (colsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (colsBuildStage == STAGE_UNINITIALIZED) {
        colsBuildStage = STAGE_INITIALIZING;
        this.cols = getColsInitialize();
        colsBuildStage = STAGE_INITIALIZED;
      }
      return this.cols;
    }

    void setCols(int cols) {
      this.cols = cols;
      colsBuildStage = STAGE_INITIALIZED;
    }

    private byte rowHeightBuildStage = STAGE_UNINITIALIZED;
    private String rowHeight;

    String getRowHeight() {
      if (rowHeightBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rowHeightBuildStage == STAGE_UNINITIALIZED) {
        rowHeightBuildStage = STAGE_INITIALIZING;
        this.rowHeight = Objects.requireNonNull(getRowHeightInitialize(), "rowHeight");
        rowHeightBuildStage = STAGE_INITIALIZED;
      }
      return this.rowHeight;
    }

    void setRowHeight(String rowHeight) {
      this.rowHeight = rowHeight;
      rowHeightBuildStage = STAGE_INITIALIZED;
    }

    private byte colWidthBuildStage = STAGE_UNINITIALIZED;
    private String colWidth;

    String getColWidth() {
      if (colWidthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (colWidthBuildStage == STAGE_UNINITIALIZED) {
        colWidthBuildStage = STAGE_INITIALIZING;
        this.colWidth = Objects.requireNonNull(getColWidthInitialize(), "colWidth");
        colWidthBuildStage = STAGE_INITIALIZED;
      }
      return this.colWidth;
    }

    void setColWidth(String colWidth) {
      this.colWidth = colWidth;
      colWidthBuildStage = STAGE_INITIALIZED;
    }

    private byte auxInfoBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMap<String, Object> auxInfo;

    ImmutableMap<String, Object> getAuxInfo() {
      if (auxInfoBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (auxInfoBuildStage == STAGE_UNINITIALIZED) {
        auxInfoBuildStage = STAGE_INITIALIZING;
        this.auxInfo = ImmutableMap.copyOf(getAuxInfoInitialize());
        auxInfoBuildStage = STAGE_INITIALIZED;
      }
      return this.auxInfo;
    }

    void setAuxInfo(ImmutableMap<String, Object> auxInfo) {
      this.auxInfo = auxInfo;
      auxInfoBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (autoColsBuildStage == STAGE_INITIALIZING) attributes.add("autoCols");
      if (autoRowsBuildStage == STAGE_INITIALIZING) attributes.add("autoRows");
      if (frozenColsBuildStage == STAGE_INITIALIZING) attributes.add("frozenCols");
      if (fixFrozenColsBuildStage == STAGE_INITIALIZING) attributes.add("fixFrozenCols");
      if (oddRowSclassBuildStage == STAGE_INITIALIZING) attributes.add("oddRowSclass");
      if (preloadSizeBuildStage == STAGE_INITIALIZING) attributes.add("preloadSize");
      if (rowsBuildStage == STAGE_INITIALIZING) attributes.add("rows");
      if (colsBuildStage == STAGE_INITIALIZING) attributes.add("cols");
      if (rowHeightBuildStage == STAGE_INITIALIZING) attributes.add("rowHeight");
      if (colWidthBuildStage == STAGE_INITIALIZING) attributes.add("colWidth");
      if (auxInfoBuildStage == STAGE_INITIALIZING) attributes.add("auxInfo");
      return "Cannot build IBiglistbox, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IBiglistbox.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IBiglistbox.super.isVisible();
  }

  private String getMoldInitialize() {
    return IBiglistbox.super.getMold();
  }

  private int getZIndexInitialize() {
    return IBiglistbox.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IBiglistbox.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IBiglistbox.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IBiglistbox.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IBiglistbox.super.getRenderdefer();
  }

  private String getWidgetClassInitialize() {
    return IBiglistbox.super.getWidgetClass();
  }

  private boolean isAutoColsInitialize() {
    return IBiglistbox.super.isAutoCols();
  }

  private boolean isAutoRowsInitialize() {
    return IBiglistbox.super.isAutoRows();
  }

  private int getFrozenColsInitialize() {
    return IBiglistbox.super.getFrozenCols();
  }

  private boolean isFixFrozenColsInitialize() {
    return IBiglistbox.super.isFixFrozenCols();
  }

  private String getOddRowSclassInitialize() {
    return IBiglistbox.super.getOddRowSclass();
  }

  private int getPreloadSizeInitialize() {
    return IBiglistbox.super.getPreloadSize();
  }

  private int getRowsInitialize() {
    return IBiglistbox.super.getRows();
  }

  private int getColsInitialize() {
    return IBiglistbox.super.getCols();
  }

  private String getRowHeightInitialize() {
    return IBiglistbox.super.getRowHeight();
  }

  private String getColWidthInitialize() {
    return IBiglistbox.super.getColWidth();
  }

  private Map<String, Object> getAuxInfoInitialize() {
    return IBiglistbox.super.getAuxInfo();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code autoCols} attribute
   */
  @Override
  public boolean isAutoCols() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isAutoCols()
        : this.autoCols;
  }

  /**
   * @return The value of the {@code autoRows} attribute
   */
  @Override
  public boolean isAutoRows() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isAutoRows()
        : this.autoRows;
  }

  /**
   * @return The value of the {@code frozenCols} attribute
   */
  @Override
  public int getFrozenCols() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getFrozenCols()
        : this.frozenCols;
  }

  /**
   * @return The value of the {@code fixFrozenCols} attribute
   */
  @Override
  public boolean isFixFrozenCols() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFixFrozenCols()
        : this.fixFrozenCols;
  }

  /**
   * @return The value of the {@code oddRowSclass} attribute
   */
  @Override
  public String getOddRowSclass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getOddRowSclass()
        : this.oddRowSclass;
  }

  /**
   * @return The value of the {@code preloadSize} attribute
   */
  @Override
  public int getPreloadSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPreloadSize()
        : this.preloadSize;
  }

  /**
   * @return The value of the {@code rows} attribute
   */
  @Override
  public int getRows() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRows()
        : this.rows;
  }

  /**
   * @return The value of the {@code cols} attribute
   */
  @Override
  public int getCols() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCols()
        : this.cols;
  }

  /**
   * @return The value of the {@code rowHeight} attribute
   */
  @Override
  public String getRowHeight() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRowHeight()
        : this.rowHeight;
  }

  /**
   * @return The value of the {@code colWidth} attribute
   */
  @Override
  public String getColWidth() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getColWidth()
        : this.colWidth;
  }

  /**
   * @return The value of the {@code sortAscending} attribute
   */
  @Override
  public @Nullable MatrixComparatorProvider<?> getSortAscending() {
    return sortAscending;
  }

  /**
   * @return The value of the {@code sortDescending} attribute
   */
  @Override
  public @Nullable MatrixComparatorProvider<?> getSortDescending() {
    return sortDescending;
  }

  /**
   * @return The value of the {@code auxInfo} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableMap<String, Object> getAuxInfo() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAuxInfo()
        : this.auxInfo;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIBiglistbox(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IBiglistbox#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBiglistbox withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIBiglistbox(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.widgetClass,
          this.autoCols,
          this.autoRows,
          this.frozenCols,
          this.fixFrozenCols,
          this.oddRowSclass,
          this.preloadSize,
          this.rows,
          this.cols,
          this.rowHeight,
          this.colWidth,
          this.sortAscending,
          this.sortDescending,
          this.auxInfo));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IBiglistbox#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBiglistbox withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link IBiglistbox#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBiglistbox withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link IBiglistbox#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBiglistbox withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link IBiglistbox#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBiglistbox withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#isAutoCols() autoCols} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autoCols
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withAutoCols(boolean value) {
    if (this.autoCols == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        value,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#isAutoRows() autoRows} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autoRows
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withAutoRows(boolean value) {
    if (this.autoRows == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        value,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getFrozenCols() frozenCols} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for frozenCols
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withFrozenCols(int value) {
    if (this.frozenCols == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        value,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#isFixFrozenCols() fixFrozenCols} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fixFrozenCols
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withFixFrozenCols(boolean value) {
    if (this.fixFrozenCols == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        value,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getOddRowSclass() oddRowSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for oddRowSclass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withOddRowSclass(String value) {
    String newValue = Objects.requireNonNull(value, "oddRowSclass");
    if (this.oddRowSclass.equals(newValue)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        newValue,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getPreloadSize() preloadSize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for preloadSize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withPreloadSize(int value) {
    if (this.preloadSize == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        value,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getRows() rows} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rows
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withRows(int value) {
    if (this.rows == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        value,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getCols() cols} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cols
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withCols(int value) {
    if (this.cols == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        value,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getRowHeight() rowHeight} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rowHeight
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withRowHeight(String value) {
    String newValue = Objects.requireNonNull(value, "rowHeight");
    if (this.rowHeight.equals(newValue)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        newValue,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getColWidth() colWidth} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for colWidth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withColWidth(String value) {
    String newValue = Objects.requireNonNull(value, "colWidth");
    if (this.colWidth.equals(newValue)) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        newValue,
        this.sortAscending,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getSortAscending() sortAscending} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sortAscending (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withSortAscending(@Nullable MatrixComparatorProvider<?> value) {
    if (this.sortAscending == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        value,
        this.sortDescending,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBiglistbox#getSortDescending() sortDescending} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sortDescending (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBiglistbox withSortDescending(@Nullable MatrixComparatorProvider<?> value) {
    if (this.sortDescending == value) return this;
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        value,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link IBiglistbox#getAuxInfo() auxInfo} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the auxInfo map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBiglistbox withAuxInfo(Map<String, ? extends Object> entries) {
    if (this.auxInfo == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new ImmutableIBiglistbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.autoCols,
        this.autoRows,
        this.frozenCols,
        this.fixFrozenCols,
        this.oddRowSclass,
        this.preloadSize,
        this.rows,
        this.cols,
        this.rowHeight,
        this.colWidth,
        this.sortAscending,
        this.sortDescending,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIBiglistbox} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIBiglistbox
        && equalTo((ImmutableIBiglistbox) another);
  }

  private boolean equalTo(ImmutableIBiglistbox another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && widgetClass.equals(another.widgetClass)
        && autoCols == another.autoCols
        && autoRows == another.autoRows
        && frozenCols == another.frozenCols
        && fixFrozenCols == another.fixFrozenCols
        && oddRowSclass.equals(another.oddRowSclass)
        && preloadSize == another.preloadSize
        && rows == another.rows
        && cols == another.cols
        && rowHeight.equals(another.rowHeight)
        && colWidth.equals(another.colWidth)
        && Objects.equals(sortAscending, another.sortAscending)
        && Objects.equals(sortDescending, another.sortDescending)
        && auxInfo.equals(another.auxInfo);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code widgetClass}, {@code autoCols}, {@code autoRows}, {@code frozenCols}, {@code fixFrozenCols}, {@code oddRowSclass}, {@code preloadSize}, {@code rows}, {@code cols}, {@code rowHeight}, {@code colWidth}, {@code sortAscending}, {@code sortDescending}, {@code auxInfo}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Booleans.hashCode(autoCols);
    h += (h << 5) + Booleans.hashCode(autoRows);
    h += (h << 5) + frozenCols;
    h += (h << 5) + Booleans.hashCode(fixFrozenCols);
    h += (h << 5) + oddRowSclass.hashCode();
    h += (h << 5) + preloadSize;
    h += (h << 5) + rows;
    h += (h << 5) + cols;
    h += (h << 5) + rowHeight.hashCode();
    h += (h << 5) + colWidth.hashCode();
    h += (h << 5) + Objects.hashCode(sortAscending);
    h += (h << 5) + Objects.hashCode(sortDescending);
    h += (h << 5) + auxInfo.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IBiglistbox} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IBiglistbox")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("widgetClass", widgetClass)
        .add("autoCols", autoCols)
        .add("autoRows", autoRows)
        .add("frozenCols", frozenCols)
        .add("fixFrozenCols", fixFrozenCols)
        .add("oddRowSclass", oddRowSclass)
        .add("preloadSize", preloadSize)
        .add("rows", rows)
        .add("cols", cols)
        .add("rowHeight", rowHeight)
        .add("colWidth", colWidth)
        .add("sortAscending", sortAscending)
        .add("sortDescending", sortDescending)
        .add("auxInfo", auxInfo)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Biglistbox> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IBiglistbox#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Biglistbox> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IBiglistbox.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableIBiglistbox validate(ImmutableIBiglistbox instance) {
    instance.check();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIBiglistbox) instance.checkDroppable();
    instance = (ImmutableIBiglistbox) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IBiglistbox} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IBiglistbox instance
   */
  public static IBiglistbox copyOf(IBiglistbox instance) {
    if (instance instanceof ImmutableIBiglistbox) {
      return (ImmutableIBiglistbox) instance;
    }
    return new IBiglistbox.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IBiglistbox IBiglistbox}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IBiglistbox", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_AUTO_COLS = 0x10L;
    private static final long OPT_BIT_AUTO_ROWS = 0x20L;
    private static final long OPT_BIT_FROZEN_COLS = 0x40L;
    private static final long OPT_BIT_FIX_FROZEN_COLS = 0x80L;
    private static final long OPT_BIT_PRELOAD_SIZE = 0x100L;
    private static final long OPT_BIT_ROWS = 0x200L;
    private static final long OPT_BIT_COLS = 0x400L;
    private static final long OPT_BIT_AUX_INFO = 0x800L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable String widgetClass;
    private boolean autoCols;
    private boolean autoRows;
    private int frozenCols;
    private boolean fixFrozenCols;
    private @Nullable String oddRowSclass;
    private int preloadSize;
    private int rows;
    private int cols;
    private @Nullable String rowHeight;
    private @Nullable String colWidth;
    private @Nullable MatrixComparatorProvider<?> sortAscending;
    private @Nullable MatrixComparatorProvider<?> sortDescending;
    private ImmutableMap.Builder<String, Object> auxInfo = ImmutableMap.builder();

    /**
     * Creates a builder for {@link IBiglistbox IBiglistbox} instances.
     * <pre>
     * new IBiglistbox.Builder()
     *    .setId(String) // optional {@link IBiglistbox#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IBiglistbox#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IBiglistbox#getActions() actions}
     *    .setVisible(boolean) // optional {@link IBiglistbox#isVisible() visible}
     *    .setMold(String) // optional {@link IBiglistbox#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IBiglistbox#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IBiglistbox#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IBiglistbox#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IBiglistbox#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IBiglistbox#getLeft() left}
     *    .setTop(String | null) // nullable {@link IBiglistbox#getTop() top}
     *    .setZIndex(int) // optional {@link IBiglistbox#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IBiglistbox#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IBiglistbox#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IBiglistbox#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IBiglistbox#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IBiglistbox#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IBiglistbox#getStyle() style}
     *    .setDraggable(String) // optional {@link IBiglistbox#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IBiglistbox#isFocus() focus}
     *    .setDroppable(String) // optional {@link IBiglistbox#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IBiglistbox#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IBiglistbox#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IBiglistbox#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IBiglistbox#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IBiglistbox#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IBiglistbox#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IBiglistbox#getContext() context}
     *    .setPopup(String | null) // nullable {@link IBiglistbox#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IBiglistbox#getTooltip() tooltip}
     *    .setWidgetClass(String) // optional {@link IBiglistbox#getWidgetClass() widgetClass}
     *    .setAutoCols(boolean) // optional {@link IBiglistbox#isAutoCols() autoCols}
     *    .setAutoRows(boolean) // optional {@link IBiglistbox#isAutoRows() autoRows}
     *    .setFrozenCols(int) // optional {@link IBiglistbox#getFrozenCols() frozenCols}
     *    .setFixFrozenCols(boolean) // optional {@link IBiglistbox#isFixFrozenCols() fixFrozenCols}
     *    .setOddRowSclass(String) // optional {@link IBiglistbox#getOddRowSclass() oddRowSclass}
     *    .setPreloadSize(int) // optional {@link IBiglistbox#getPreloadSize() preloadSize}
     *    .setRows(int) // optional {@link IBiglistbox#getRows() rows}
     *    .setCols(int) // optional {@link IBiglistbox#getCols() cols}
     *    .setRowHeight(String) // optional {@link IBiglistbox#getRowHeight() rowHeight}
     *    .setColWidth(String) // optional {@link IBiglistbox#getColWidth() colWidth}
     *    .setSortAscending(org.zkoss.zkmax.zul.MatrixComparatorProvider&amp;lt;?&amp;gt; | null) // nullable {@link IBiglistbox#getSortAscending() sortAscending}
     *    .setSortDescending(org.zkoss.zkmax.zul.MatrixComparatorProvider&amp;lt;?&amp;gt; | null) // nullable {@link IBiglistbox#getSortDescending() sortDescending}
     *    .putAuxInfo|putAllAuxInfo(String =&gt; Object) // {@link IBiglistbox#getAuxInfo() auxInfo} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IBiglistbox.Builder)) {
        throw new UnsupportedOperationException("Use: new IBiglistbox.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IBiglistbox} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder from(IBiglistbox instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setWidgetClass(instance.getWidgetClass());
      setAutoCols(instance.isAutoCols());
      setAutoRows(instance.isAutoRows());
      setFrozenCols(instance.getFrozenCols());
      setFixFrozenCols(instance.isFixFrozenCols());
      setOddRowSclass(instance.getOddRowSclass());
      setPreloadSize(instance.getPreloadSize());
      setRows(instance.getRows());
      setCols(instance.getCols());
      setRowHeight(instance.getRowHeight());
      setColWidth(instance.getColWidth());
      @Nullable MatrixComparatorProvider<?> sortAscendingValue = instance.getSortAscending();
      if (sortAscendingValue != null) {
        setSortAscending(sortAscendingValue);
      }
      @Nullable MatrixComparatorProvider<?> sortDescendingValue = instance.getSortDescending();
      if (sortDescendingValue != null) {
        setSortDescending(sortDescendingValue);
      }
      putAllAuxInfo(instance.getAuxInfo());
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Adds one element to {@link IBiglistbox#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IBiglistbox.Builder) this;
    }

    /**
     * Adds elements to {@link IBiglistbox#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IBiglistbox.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IBiglistbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IBiglistbox.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IBiglistbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBiglistbox#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IBiglistbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBiglistbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IBiglistbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IBiglistbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IBiglistbox.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IBiglistbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IBiglistbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBiglistbox#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IBiglistbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBiglistbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IBiglistbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IBiglistbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IBiglistbox.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IBiglistbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IBiglistbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBiglistbox#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IBiglistbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBiglistbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IBiglistbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IBiglistbox#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IBiglistbox.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IBiglistbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setTop(@Nullable String top) {
      this.top = top;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setContext(@Nullable String context) {
      this.context = context;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#isAutoCols() autoCols} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#isAutoCols() autoCols}.</em>
     * @param autoCols The value for autoCols 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setAutoCols(boolean autoCols) {
      this.autoCols = autoCols;
      optBits |= OPT_BIT_AUTO_COLS;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#isAutoRows() autoRows} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#isAutoRows() autoRows}.</em>
     * @param autoRows The value for autoRows 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setAutoRows(boolean autoRows) {
      this.autoRows = autoRows;
      optBits |= OPT_BIT_AUTO_ROWS;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getFrozenCols() frozenCols} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getFrozenCols() frozenCols}.</em>
     * @param frozenCols The value for frozenCols 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setFrozenCols(int frozenCols) {
      this.frozenCols = frozenCols;
      optBits |= OPT_BIT_FROZEN_COLS;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#isFixFrozenCols() fixFrozenCols} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#isFixFrozenCols() fixFrozenCols}.</em>
     * @param fixFrozenCols The value for fixFrozenCols 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setFixFrozenCols(boolean fixFrozenCols) {
      this.fixFrozenCols = fixFrozenCols;
      optBits |= OPT_BIT_FIX_FROZEN_COLS;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getOddRowSclass() oddRowSclass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getOddRowSclass() oddRowSclass}.</em>
     * @param oddRowSclass The value for oddRowSclass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setOddRowSclass(String oddRowSclass) {
      this.oddRowSclass = Objects.requireNonNull(oddRowSclass, "oddRowSclass");
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getPreloadSize() preloadSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getPreloadSize() preloadSize}.</em>
     * @param preloadSize The value for preloadSize 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setPreloadSize(int preloadSize) {
      this.preloadSize = preloadSize;
      optBits |= OPT_BIT_PRELOAD_SIZE;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getRows() rows} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getRows() rows}.</em>
     * @param rows The value for rows 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setRows(int rows) {
      this.rows = rows;
      optBits |= OPT_BIT_ROWS;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getCols() cols} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getCols() cols}.</em>
     * @param cols The value for cols 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setCols(int cols) {
      this.cols = cols;
      optBits |= OPT_BIT_COLS;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getRowHeight() rowHeight} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getRowHeight() rowHeight}.</em>
     * @param rowHeight The value for rowHeight 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setRowHeight(String rowHeight) {
      this.rowHeight = Objects.requireNonNull(rowHeight, "rowHeight");
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getColWidth() colWidth} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBiglistbox#getColWidth() colWidth}.</em>
     * @param colWidth The value for colWidth 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setColWidth(String colWidth) {
      this.colWidth = Objects.requireNonNull(colWidth, "colWidth");
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getSortAscending() sortAscending} attribute.
     * @param sortAscending The value for sortAscending (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setSortAscending(@Nullable MatrixComparatorProvider<?> sortAscending) {
      this.sortAscending = sortAscending;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBiglistbox#getSortDescending() sortDescending} attribute.
     * @param sortDescending The value for sortDescending (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setSortDescending(@Nullable MatrixComparatorProvider<?> sortDescending) {
      this.sortDescending = sortDescending;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBiglistbox#getAuxInfo() auxInfo} map.
     * @param key The key in the auxInfo map
     * @param value The associated value in the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder putAuxInfo(String key, Object value) {
      this.auxInfo.put(key, value);
      optBits |= OPT_BIT_AUX_INFO;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBiglistbox#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder putAuxInfo(Map.Entry<String, ? extends Object> entry) {
      this.auxInfo.put(entry);
      optBits |= OPT_BIT_AUX_INFO;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IBiglistbox#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder setAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo = ImmutableMap.builder();
      optBits |= OPT_BIT_AUX_INFO;
      return putAllAuxInfo(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IBiglistbox#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBiglistbox.Builder putAllAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo.putAll(entries);
      optBits |= OPT_BIT_AUX_INFO;
      return (IBiglistbox.Builder) this;
    }

    /**
     * Builds a new {@link IBiglistbox IBiglistbox}.
     * @return An immutable instance of IBiglistbox
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IBiglistbox build() {
      return ImmutableIBiglistbox.validate(new ImmutableIBiglistbox(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean autoColsIsSet() {
      return (optBits & OPT_BIT_AUTO_COLS) != 0;
    }

    private boolean autoRowsIsSet() {
      return (optBits & OPT_BIT_AUTO_ROWS) != 0;
    }

    private boolean frozenColsIsSet() {
      return (optBits & OPT_BIT_FROZEN_COLS) != 0;
    }

    private boolean fixFrozenColsIsSet() {
      return (optBits & OPT_BIT_FIX_FROZEN_COLS) != 0;
    }

    private boolean preloadSizeIsSet() {
      return (optBits & OPT_BIT_PRELOAD_SIZE) != 0;
    }

    private boolean rowsIsSet() {
      return (optBits & OPT_BIT_ROWS) != 0;
    }

    private boolean colsIsSet() {
      return (optBits & OPT_BIT_COLS) != 0;
    }

    private boolean auxInfoIsSet() {
      return (optBits & OPT_BIT_AUX_INFO) != 0;
    }
  }
}
