package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Grid;

/**
 * Immutable implementation of {@link IGrid}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IGrid.Builder()}.
 */
@Generated(from = "IGrid", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIGrid implements IGrid {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final @Nullable String span;
  private final @Nullable IPaging pagingChild;
  private final boolean sizedByContent;
  private final boolean autopaging;
  private final String pagingPosition;
  private final boolean nativeScrollbar;
  private final String widgetClass;
  private final @Nullable IRows rows;
  private final @Nullable IColumns columns;
  private final @Nullable IFoot foot;
  private final @Nullable IFrozen frozen;
  private final @Nullable String emptyMessage;
  private final int visibleRows;
  private final String innerWidth;
  private final @Nullable String autosort;
  private final String oddRowSclass;
  private final ImmutableMap<String, Object> auxInfo;
  private final ImmutableList<IAuxhead> auxhead;

  private ImmutableIGrid(ImmutableIGrid.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.span = builder.span;
    this.pagingChild = builder.pagingChild;
    this.rows = builder.rows;
    this.columns = builder.columns;
    this.foot = builder.foot;
    this.frozen = builder.frozen;
    this.emptyMessage = builder.emptyMessage;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.sizedByContentIsSet()) {
      initShim.setSizedByContent(builder.sizedByContent);
    }
    if (builder.autopagingIsSet()) {
      initShim.setAutopaging(builder.autopaging);
    }
    if (builder.pagingPosition != null) {
      initShim.setPagingPosition(builder.pagingPosition);
    }
    if (builder.nativeScrollbarIsSet()) {
      initShim.setNativeScrollbar(builder.nativeScrollbar);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.visibleRowsIsSet()) {
      initShim.setVisibleRows(builder.visibleRows);
    }
    if (builder.innerWidth != null) {
      initShim.setInnerWidth(builder.innerWidth);
    }
    if (builder.autosortIsSet()) {
      initShim.setAutosort(builder.autosort);
    }
    if (builder.oddRowSclass != null) {
      initShim.setOddRowSclass(builder.oddRowSclass);
    }
    if (builder.auxInfoIsSet()) {
      initShim.setAuxInfo(builder.auxInfo.build());
    }
    if (builder.auxheadIsSet()) {
      initShim.setAuxhead(builder.auxhead.build());
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.sizedByContent = initShim.isSizedByContent();
    this.autopaging = initShim.isAutopaging();
    this.pagingPosition = initShim.getPagingPosition();
    this.nativeScrollbar = initShim.isNativeScrollbar();
    this.widgetClass = initShim.getWidgetClass();
    this.visibleRows = initShim.getVisibleRows();
    this.innerWidth = initShim.getInnerWidth();
    this.autosort = initShim.getAutosort();
    this.oddRowSclass = initShim.getOddRowSclass();
    this.auxInfo = initShim.getAuxInfo();
    this.auxhead = initShim.getAuxhead();
    this.initShim = null;
  }

  private ImmutableIGrid(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      @Nullable String span,
      @Nullable IPaging pagingChild,
      boolean sizedByContent,
      boolean autopaging,
      String pagingPosition,
      boolean nativeScrollbar,
      String widgetClass,
      @Nullable IRows rows,
      @Nullable IColumns columns,
      @Nullable IFoot foot,
      @Nullable IFrozen frozen,
      @Nullable String emptyMessage,
      int visibleRows,
      String innerWidth,
      @Nullable String autosort,
      String oddRowSclass,
      ImmutableMap<String, Object> auxInfo,
      ImmutableList<IAuxhead> auxhead) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.span = span;
    this.pagingChild = pagingChild;
    this.sizedByContent = sizedByContent;
    this.autopaging = autopaging;
    this.pagingPosition = pagingPosition;
    this.nativeScrollbar = nativeScrollbar;
    this.widgetClass = widgetClass;
    this.rows = rows;
    this.columns = columns;
    this.foot = foot;
    this.frozen = frozen;
    this.emptyMessage = emptyMessage;
    this.visibleRows = visibleRows;
    this.innerWidth = innerWidth;
    this.autosort = autosort;
    this.oddRowSclass = oddRowSclass;
    this.auxInfo = auxInfo;
    this.auxhead = auxhead;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IGrid", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte sizedByContentBuildStage = STAGE_UNINITIALIZED;
    private boolean sizedByContent;

    boolean isSizedByContent() {
      if (sizedByContentBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sizedByContentBuildStage == STAGE_UNINITIALIZED) {
        sizedByContentBuildStage = STAGE_INITIALIZING;
        this.sizedByContent = isSizedByContentInitialize();
        sizedByContentBuildStage = STAGE_INITIALIZED;
      }
      return this.sizedByContent;
    }

    void setSizedByContent(boolean sizedByContent) {
      this.sizedByContent = sizedByContent;
      sizedByContentBuildStage = STAGE_INITIALIZED;
    }

    private byte autopagingBuildStage = STAGE_UNINITIALIZED;
    private boolean autopaging;

    boolean isAutopaging() {
      if (autopagingBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (autopagingBuildStage == STAGE_UNINITIALIZED) {
        autopagingBuildStage = STAGE_INITIALIZING;
        this.autopaging = isAutopagingInitialize();
        autopagingBuildStage = STAGE_INITIALIZED;
      }
      return this.autopaging;
    }

    void setAutopaging(boolean autopaging) {
      this.autopaging = autopaging;
      autopagingBuildStage = STAGE_INITIALIZED;
    }

    private byte pagingPositionBuildStage = STAGE_UNINITIALIZED;
    private String pagingPosition;

    String getPagingPosition() {
      if (pagingPositionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pagingPositionBuildStage == STAGE_UNINITIALIZED) {
        pagingPositionBuildStage = STAGE_INITIALIZING;
        this.pagingPosition = Objects.requireNonNull(getPagingPositionInitialize(), "pagingPosition");
        pagingPositionBuildStage = STAGE_INITIALIZED;
      }
      return this.pagingPosition;
    }

    void setPagingPosition(String pagingPosition) {
      this.pagingPosition = pagingPosition;
      pagingPositionBuildStage = STAGE_INITIALIZED;
    }

    private byte nativeScrollbarBuildStage = STAGE_UNINITIALIZED;
    private boolean nativeScrollbar;

    boolean isNativeScrollbar() {
      if (nativeScrollbarBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nativeScrollbarBuildStage == STAGE_UNINITIALIZED) {
        nativeScrollbarBuildStage = STAGE_INITIALIZING;
        this.nativeScrollbar = isNativeScrollbarInitialize();
        nativeScrollbarBuildStage = STAGE_INITIALIZED;
      }
      return this.nativeScrollbar;
    }

    void setNativeScrollbar(boolean nativeScrollbar) {
      this.nativeScrollbar = nativeScrollbar;
      nativeScrollbarBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleRowsBuildStage = STAGE_UNINITIALIZED;
    private int visibleRows;

    int getVisibleRows() {
      if (visibleRowsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleRowsBuildStage == STAGE_UNINITIALIZED) {
        visibleRowsBuildStage = STAGE_INITIALIZING;
        this.visibleRows = getVisibleRowsInitialize();
        visibleRowsBuildStage = STAGE_INITIALIZED;
      }
      return this.visibleRows;
    }

    void setVisibleRows(int visibleRows) {
      this.visibleRows = visibleRows;
      visibleRowsBuildStage = STAGE_INITIALIZED;
    }

    private byte innerWidthBuildStage = STAGE_UNINITIALIZED;
    private String innerWidth;

    String getInnerWidth() {
      if (innerWidthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (innerWidthBuildStage == STAGE_UNINITIALIZED) {
        innerWidthBuildStage = STAGE_INITIALIZING;
        this.innerWidth = Objects.requireNonNull(getInnerWidthInitialize(), "innerWidth");
        innerWidthBuildStage = STAGE_INITIALIZED;
      }
      return this.innerWidth;
    }

    void setInnerWidth(String innerWidth) {
      this.innerWidth = innerWidth;
      innerWidthBuildStage = STAGE_INITIALIZED;
    }

    private byte autosortBuildStage = STAGE_UNINITIALIZED;
    private String autosort;

    String getAutosort() {
      if (autosortBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (autosortBuildStage == STAGE_UNINITIALIZED) {
        autosortBuildStage = STAGE_INITIALIZING;
        this.autosort = getAutosortInitialize();
        autosortBuildStage = STAGE_INITIALIZED;
      }
      return this.autosort;
    }

    void setAutosort(String autosort) {
      this.autosort = autosort;
      autosortBuildStage = STAGE_INITIALIZED;
    }

    private byte oddRowSclassBuildStage = STAGE_UNINITIALIZED;
    private String oddRowSclass;

    String getOddRowSclass() {
      if (oddRowSclassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (oddRowSclassBuildStage == STAGE_UNINITIALIZED) {
        oddRowSclassBuildStage = STAGE_INITIALIZING;
        this.oddRowSclass = Objects.requireNonNull(getOddRowSclassInitialize(), "oddRowSclass");
        oddRowSclassBuildStage = STAGE_INITIALIZED;
      }
      return this.oddRowSclass;
    }

    void setOddRowSclass(String oddRowSclass) {
      this.oddRowSclass = oddRowSclass;
      oddRowSclassBuildStage = STAGE_INITIALIZED;
    }

    private byte auxInfoBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMap<String, Object> auxInfo;

    ImmutableMap<String, Object> getAuxInfo() {
      if (auxInfoBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (auxInfoBuildStage == STAGE_UNINITIALIZED) {
        auxInfoBuildStage = STAGE_INITIALIZING;
        this.auxInfo = ImmutableMap.copyOf(getAuxInfoInitialize());
        auxInfoBuildStage = STAGE_INITIALIZED;
      }
      return this.auxInfo;
    }

    void setAuxInfo(ImmutableMap<String, Object> auxInfo) {
      this.auxInfo = auxInfo;
      auxInfoBuildStage = STAGE_INITIALIZED;
    }

    private byte auxheadBuildStage = STAGE_UNINITIALIZED;
    private ImmutableList<IAuxhead> auxhead;

    ImmutableList<IAuxhead> getAuxhead() {
      if (auxheadBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (auxheadBuildStage == STAGE_UNINITIALIZED) {
        auxheadBuildStage = STAGE_INITIALIZING;
        this.auxhead = ImmutableList.copyOf(getAuxheadInitialize());
        auxheadBuildStage = STAGE_INITIALIZED;
      }
      return this.auxhead;
    }

    void setAuxhead(ImmutableList<IAuxhead> auxhead) {
      this.auxhead = auxhead;
      auxheadBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (sizedByContentBuildStage == STAGE_INITIALIZING) attributes.add("sizedByContent");
      if (autopagingBuildStage == STAGE_INITIALIZING) attributes.add("autopaging");
      if (pagingPositionBuildStage == STAGE_INITIALIZING) attributes.add("pagingPosition");
      if (nativeScrollbarBuildStage == STAGE_INITIALIZING) attributes.add("nativeScrollbar");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (visibleRowsBuildStage == STAGE_INITIALIZING) attributes.add("visibleRows");
      if (innerWidthBuildStage == STAGE_INITIALIZING) attributes.add("innerWidth");
      if (autosortBuildStage == STAGE_INITIALIZING) attributes.add("autosort");
      if (oddRowSclassBuildStage == STAGE_INITIALIZING) attributes.add("oddRowSclass");
      if (auxInfoBuildStage == STAGE_INITIALIZING) attributes.add("auxInfo");
      if (auxheadBuildStage == STAGE_INITIALIZING) attributes.add("auxhead");
      return "Cannot build IGrid, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IGrid.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IGrid.super.isVisible();
  }

  private String getMoldInitialize() {
    return IGrid.super.getMold();
  }

  private int getZIndexInitialize() {
    return IGrid.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IGrid.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IGrid.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IGrid.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IGrid.super.getRenderdefer();
  }

  private boolean isSizedByContentInitialize() {
    return IGrid.super.isSizedByContent();
  }

  private boolean isAutopagingInitialize() {
    return IGrid.super.isAutopaging();
  }

  private String getPagingPositionInitialize() {
    return IGrid.super.getPagingPosition();
  }

  private boolean isNativeScrollbarInitialize() {
    return IGrid.super.isNativeScrollbar();
  }

  private String getWidgetClassInitialize() {
    return IGrid.super.getWidgetClass();
  }

  private int getVisibleRowsInitialize() {
    return IGrid.super.getVisibleRows();
  }

  private String getInnerWidthInitialize() {
    return IGrid.super.getInnerWidth();
  }

  private @Nullable String getAutosortInitialize() {
    return IGrid.super.getAutosort();
  }

  private String getOddRowSclassInitialize() {
    return IGrid.super.getOddRowSclass();
  }

  private Map<String, Object> getAuxInfoInitialize() {
    return IGrid.super.getAuxInfo();
  }

  private List<IAuxhead> getAuxheadInitialize() {
    return IGrid.super.getAuxhead();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code span} attribute
   */
  @Override
  public @Nullable String getSpan() {
    return span;
  }

  /**
   * @return The value of the {@code pagingChild} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable IPaging getPagingChild() {
    return pagingChild;
  }

  /**
   * @return The value of the {@code sizedByContent} attribute
   */
  @Override
  public boolean isSizedByContent() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSizedByContent()
        : this.sizedByContent;
  }

  /**
   * @return The value of the {@code autopaging} attribute
   */
  @Override
  public boolean isAutopaging() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isAutopaging()
        : this.autopaging;
  }

  /**
   * @return The value of the {@code pagingPosition} attribute
   */
  @Override
  public String getPagingPosition() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPagingPosition()
        : this.pagingPosition;
  }

  /**
   * @return The value of the {@code nativeScrollbar} attribute
   */
  @Override
  public boolean isNativeScrollbar() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isNativeScrollbar()
        : this.nativeScrollbar;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code rows} attribute
   */
  @Override
  public @Nullable IRows getRows() {
    return rows;
  }

  /**
   * @return The value of the {@code columns} attribute
   */
  @Override
  public @Nullable IColumns getColumns() {
    return columns;
  }

  /**
   * @return The value of the {@code foot} attribute
   */
  @Override
  public @Nullable IFoot getFoot() {
    return foot;
  }

  /**
   * @return The value of the {@code frozen} attribute
   */
  @Override
  public @Nullable IFrozen getFrozen() {
    return frozen;
  }

  /**
   * @return The value of the {@code emptyMessage} attribute
   */
  @Override
  public @Nullable String getEmptyMessage() {
    return emptyMessage;
  }

  /**
   * @return The value of the {@code visibleRows} attribute
   */
  @Override
  public int getVisibleRows() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getVisibleRows()
        : this.visibleRows;
  }

  /**
   * @return The value of the {@code innerWidth} attribute
   */
  @Override
  public String getInnerWidth() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getInnerWidth()
        : this.innerWidth;
  }

  /**
   * @return The value of the {@code autosort} attribute
   */
  @Override
  public @Nullable String getAutosort() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAutosort()
        : this.autosort;
  }

  /**
   * @return The value of the {@code oddRowSclass} attribute
   */
  @Override
  public String getOddRowSclass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getOddRowSclass()
        : this.oddRowSclass;
  }

  /**
   * @return The value of the {@code auxInfo} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableMap<String, Object> getAuxInfo() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAuxInfo()
        : this.auxInfo;
  }

  /**
   * @return The value of the {@code auxhead} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableList<IAuxhead> getAuxhead() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAuxhead()
        : this.auxhead;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIGrid(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IGrid#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGrid withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIGrid(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.span,
          this.pagingChild,
          this.sizedByContent,
          this.autopaging,
          this.pagingPosition,
          this.nativeScrollbar,
          this.widgetClass,
          this.rows,
          this.columns,
          this.foot,
          this.frozen,
          this.emptyMessage,
          this.visibleRows,
          this.innerWidth,
          this.autosort,
          this.oddRowSclass,
          this.auxInfo,
          this.auxhead));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IGrid#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGrid withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by replacing the {@link IGrid#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGrid withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by replacing the {@link IGrid#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGrid withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by replacing the {@link IGrid#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGrid withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getSpan() span} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for span (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withSpan(@Nullable String value) {
    if (Objects.equals(this.span, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        value,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getPagingChild() pagingChild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pagingChild (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withPagingChild(@Nullable IPaging value) {
    if (this.pagingChild == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        value,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#isSizedByContent() sizedByContent} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sizedByContent
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withSizedByContent(boolean value) {
    if (this.sizedByContent == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        value,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#isAutopaging() autopaging} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autopaging
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withAutopaging(boolean value) {
    if (this.autopaging == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        value,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getPagingPosition() pagingPosition} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pagingPosition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withPagingPosition(String value) {
    String newValue = Objects.requireNonNull(value, "pagingPosition");
    if (this.pagingPosition.equals(newValue)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        newValue,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#isNativeScrollbar() nativeScrollbar} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nativeScrollbar
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withNativeScrollbar(boolean value) {
    if (this.nativeScrollbar == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        value,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        newValue,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getRows() rows} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rows (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withRows(@Nullable IRows value) {
    if (this.rows == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        value,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getColumns() columns} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for columns (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withColumns(@Nullable IColumns value) {
    if (this.columns == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        value,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getFoot() foot} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for foot (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withFoot(@Nullable IFoot value) {
    if (this.foot == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        value,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getFrozen() frozen} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for frozen (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withFrozen(@Nullable IFrozen value) {
    if (this.frozen == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        value,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getEmptyMessage() emptyMessage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for emptyMessage (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withEmptyMessage(@Nullable String value) {
    if (Objects.equals(this.emptyMessage, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        value,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getVisibleRows() visibleRows} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visibleRows
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withVisibleRows(int value) {
    if (this.visibleRows == value) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        value,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getInnerWidth() innerWidth} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for innerWidth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withInnerWidth(String value) {
    String newValue = Objects.requireNonNull(value, "innerWidth");
    if (this.innerWidth.equals(newValue)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        newValue,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getAutosort() autosort} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autosort (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withAutosort(@Nullable String value) {
    if (Objects.equals(this.autosort, value)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        value,
        this.oddRowSclass,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGrid#getOddRowSclass() oddRowSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for oddRowSclass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGrid withOddRowSclass(String value) {
    String newValue = Objects.requireNonNull(value, "oddRowSclass");
    if (this.oddRowSclass.equals(newValue)) return this;
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        newValue,
        this.auxInfo,
        this.auxhead));
  }

  /**
   * Copy the current immutable object by replacing the {@link IGrid#getAuxInfo() auxInfo} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the auxInfo map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGrid withAuxInfo(Map<String, ? extends Object> entries) {
    if (this.auxInfo == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        newValue,
        this.auxhead));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IGrid#getAuxhead() auxhead}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGrid withAuxhead(IAuxhead... elements) {
    ImmutableList<IAuxhead> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IGrid#getAuxhead() auxhead}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of auxhead elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGrid withAuxhead(Iterable<? extends IAuxhead> elements) {
    if (this.auxhead == elements) return this;
    ImmutableList<IAuxhead> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIGrid(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.rows,
        this.columns,
        this.foot,
        this.frozen,
        this.emptyMessage,
        this.visibleRows,
        this.innerWidth,
        this.autosort,
        this.oddRowSclass,
        this.auxInfo,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIGrid} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIGrid
        && equalTo((ImmutableIGrid) another);
  }

  private boolean equalTo(ImmutableIGrid another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && Objects.equals(span, another.span)
        && Objects.equals(pagingChild, another.pagingChild)
        && sizedByContent == another.sizedByContent
        && autopaging == another.autopaging
        && pagingPosition.equals(another.pagingPosition)
        && nativeScrollbar == another.nativeScrollbar
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(rows, another.rows)
        && Objects.equals(columns, another.columns)
        && Objects.equals(foot, another.foot)
        && Objects.equals(frozen, another.frozen)
        && Objects.equals(emptyMessage, another.emptyMessage)
        && visibleRows == another.visibleRows
        && innerWidth.equals(another.innerWidth)
        && Objects.equals(autosort, another.autosort)
        && oddRowSclass.equals(another.oddRowSclass)
        && auxInfo.equals(another.auxInfo)
        && auxhead.equals(another.auxhead);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code span}, {@code pagingChild}, {@code sizedByContent}, {@code autopaging}, {@code pagingPosition}, {@code nativeScrollbar}, {@code widgetClass}, {@code rows}, {@code columns}, {@code foot}, {@code frozen}, {@code emptyMessage}, {@code visibleRows}, {@code innerWidth}, {@code autosort}, {@code oddRowSclass}, {@code auxInfo}, {@code auxhead}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + Objects.hashCode(span);
    h += (h << 5) + Objects.hashCode(pagingChild);
    h += (h << 5) + Booleans.hashCode(sizedByContent);
    h += (h << 5) + Booleans.hashCode(autopaging);
    h += (h << 5) + pagingPosition.hashCode();
    h += (h << 5) + Booleans.hashCode(nativeScrollbar);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(rows);
    h += (h << 5) + Objects.hashCode(columns);
    h += (h << 5) + Objects.hashCode(foot);
    h += (h << 5) + Objects.hashCode(frozen);
    h += (h << 5) + Objects.hashCode(emptyMessage);
    h += (h << 5) + visibleRows;
    h += (h << 5) + innerWidth.hashCode();
    h += (h << 5) + Objects.hashCode(autosort);
    h += (h << 5) + oddRowSclass.hashCode();
    h += (h << 5) + auxInfo.hashCode();
    h += (h << 5) + auxhead.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IGrid} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IGrid")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("span", span)
        .add("pagingChild", pagingChild)
        .add("sizedByContent", sizedByContent)
        .add("autopaging", autopaging)
        .add("pagingPosition", pagingPosition)
        .add("nativeScrollbar", nativeScrollbar)
        .add("widgetClass", widgetClass)
        .add("rows", rows)
        .add("columns", columns)
        .add("foot", foot)
        .add("frozen", frozen)
        .add("emptyMessage", emptyMessage)
        .add("visibleRows", visibleRows)
        .add("innerWidth", innerWidth)
        .add("autosort", autosort)
        .add("oddRowSclass", oddRowSclass)
        .add("auxInfo", auxInfo)
        .add("auxhead", auxhead)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Grid> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IGrid#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Grid> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IGrid.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static final long AUTOSORT_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient boolean autosort$lazy;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IGrid#isAutosort() autosort} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code autosort} attribute
   */
  @Override
  public boolean isAutosort() {
    if ((lazyInitBitmap & AUTOSORT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & AUTOSORT_LAZY_INIT_BIT) == 0) {
          this.autosort$lazy = IGrid.super.isAutosort();
          lazyInitBitmap |= AUTOSORT_LAZY_INIT_BIT;
        }
      }
    }
    return autosort$lazy;
  }

  private static final long ALL_COMPONENTS_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient List<IMeshComposite> allComponents;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IGrid#getAllComponents() allComponents} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code allComponents} attribute
   */
  @Override
  public List<IMeshComposite> getAllComponents() {
    if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
          this.allComponents = Objects.requireNonNull(IGrid.super.getAllComponents(), "allComponents");
          lazyInitBitmap |= ALL_COMPONENTS_LAZY_INIT_BIT;
        }
      }
    }
    return allComponents;
  }

  private static ImmutableIGrid validate(ImmutableIGrid instance) {
    instance = (ImmutableIGrid) instance.checkMold();
    instance.checkVisibleRows();
    instance.checkPagingPosition();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIGrid) instance.checkDroppable();
    instance = (ImmutableIGrid) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IGrid} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IGrid instance
   */
  public static IGrid copyOf(IGrid instance) {
    if (instance instanceof ImmutableIGrid) {
      return (ImmutableIGrid) instance;
    }
    return new IGrid.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IGrid IGrid}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IGrid", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_SIZED_BY_CONTENT = 0x10L;
    private static final long OPT_BIT_AUTOPAGING = 0x20L;
    private static final long OPT_BIT_NATIVE_SCROLLBAR = 0x40L;
    private static final long OPT_BIT_VISIBLE_ROWS = 0x80L;
    private static final long OPT_BIT_AUTOSORT = 0x100L;
    private static final long OPT_BIT_AUX_INFO = 0x200L;
    private static final long OPT_BIT_AUXHEAD = 0x400L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable String span;
    private @Nullable IPaging pagingChild;
    private boolean sizedByContent;
    private boolean autopaging;
    private @Nullable String pagingPosition;
    private boolean nativeScrollbar;
    private @Nullable String widgetClass;
    private @Nullable IRows rows;
    private @Nullable IColumns columns;
    private @Nullable IFoot foot;
    private @Nullable IFrozen frozen;
    private @Nullable String emptyMessage;
    private int visibleRows;
    private @Nullable String innerWidth;
    private @Nullable String autosort;
    private @Nullable String oddRowSclass;
    private ImmutableMap.Builder<String, Object> auxInfo = ImmutableMap.builder();
    private ImmutableList.Builder<IAuxhead> auxhead = ImmutableList.builder();

    /**
     * Creates a builder for {@link IGrid IGrid} instances.
     * <pre>
     * new IGrid.Builder()
     *    .setId(String) // optional {@link IGrid#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IGrid#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IGrid#getActions() actions}
     *    .setVisible(boolean) // optional {@link IGrid#isVisible() visible}
     *    .setMold(String) // optional {@link IGrid#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IGrid#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IGrid#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IGrid#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IGrid#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IGrid#getLeft() left}
     *    .setTop(String | null) // nullable {@link IGrid#getTop() top}
     *    .setZIndex(int) // optional {@link IGrid#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IGrid#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IGrid#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IGrid#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IGrid#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IGrid#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IGrid#getStyle() style}
     *    .setDraggable(String) // optional {@link IGrid#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IGrid#isFocus() focus}
     *    .setDroppable(String) // optional {@link IGrid#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IGrid#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IGrid#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IGrid#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IGrid#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IGrid#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IGrid#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IGrid#getContext() context}
     *    .setPopup(String | null) // nullable {@link IGrid#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IGrid#getTooltip() tooltip}
     *    .setSpan(String | null) // nullable {@link IGrid#getSpan() span}
     *    .setPagingChild(org.zkoss.stateless.sul.IPaging | null) // nullable {@link IGrid#getPagingChild() pagingChild}
     *    .setSizedByContent(boolean) // optional {@link IGrid#isSizedByContent() sizedByContent}
     *    .setAutopaging(boolean) // optional {@link IGrid#isAutopaging() autopaging}
     *    .setPagingPosition(String) // optional {@link IGrid#getPagingPosition() pagingPosition}
     *    .setNativeScrollbar(boolean) // optional {@link IGrid#isNativeScrollbar() nativeScrollbar}
     *    .setWidgetClass(String) // optional {@link IGrid#getWidgetClass() widgetClass}
     *    .setRows(org.zkoss.stateless.sul.IRows | null) // nullable {@link IGrid#getRows() rows}
     *    .setColumns(org.zkoss.stateless.sul.IColumns | null) // nullable {@link IGrid#getColumns() columns}
     *    .setFoot(org.zkoss.stateless.sul.IFoot | null) // nullable {@link IGrid#getFoot() foot}
     *    .setFrozen(org.zkoss.stateless.sul.IFrozen | null) // nullable {@link IGrid#getFrozen() frozen}
     *    .setEmptyMessage(String | null) // nullable {@link IGrid#getEmptyMessage() emptyMessage}
     *    .setVisibleRows(int) // optional {@link IGrid#getVisibleRows() visibleRows}
     *    .setInnerWidth(String) // optional {@link IGrid#getInnerWidth() innerWidth}
     *    .setAutosort(String | null) // nullable {@link IGrid#getAutosort() autosort}
     *    .setOddRowSclass(String) // optional {@link IGrid#getOddRowSclass() oddRowSclass}
     *    .putAuxInfo|putAllAuxInfo(String =&gt; Object) // {@link IGrid#getAuxInfo() auxInfo} mappings
     *    .addAuxhead|addAllAuxhead(org.zkoss.stateless.sul.IAuxhead) // {@link IGrid#getAuxhead() auxhead} elements
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IGrid.Builder)) {
        throw new UnsupportedOperationException("Use: new IGrid.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IGrid} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder from(IGrid instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      @Nullable String spanValue = instance.getSpan();
      if (spanValue != null) {
        setSpan(spanValue);
      }
      @Nullable IPaging pagingChildValue = instance.getPagingChild();
      if (pagingChildValue != null) {
        setPagingChild(pagingChildValue);
      }
      setSizedByContent(instance.isSizedByContent());
      setAutopaging(instance.isAutopaging());
      setPagingPosition(instance.getPagingPosition());
      setNativeScrollbar(instance.isNativeScrollbar());
      setWidgetClass(instance.getWidgetClass());
      @Nullable IRows rowsValue = instance.getRows();
      if (rowsValue != null) {
        setRows(rowsValue);
      }
      @Nullable IColumns columnsValue = instance.getColumns();
      if (columnsValue != null) {
        setColumns(columnsValue);
      }
      @Nullable IFoot footValue = instance.getFoot();
      if (footValue != null) {
        setFoot(footValue);
      }
      @Nullable IFrozen frozenValue = instance.getFrozen();
      if (frozenValue != null) {
        setFrozen(frozenValue);
      }
      @Nullable String emptyMessageValue = instance.getEmptyMessage();
      if (emptyMessageValue != null) {
        setEmptyMessage(emptyMessageValue);
      }
      setVisibleRows(instance.getVisibleRows());
      setInnerWidth(instance.getInnerWidth());
      @Nullable String autosortValue = instance.getAutosort();
      if (autosortValue != null) {
        setAutosort(autosortValue);
      }
      setOddRowSclass(instance.getOddRowSclass());
      putAllAuxInfo(instance.getAuxInfo());
      addAllAuxhead(instance.getAuxhead());
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IGrid.Builder) this;
    }

    /**
     * Adds one element to {@link IGrid#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IGrid.Builder) this;
    }

    /**
     * Adds elements to {@link IGrid#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IGrid.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IGrid#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IGrid.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IGrid#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IGrid.Builder) this;
    }

    /**
     * Put one entry to the {@link IGrid#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IGrid.Builder) this;
    }

    /**
     * Put one entry to the {@link IGrid#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IGrid.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IGrid#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IGrid.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IGrid#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IGrid.Builder) this;
    }

    /**
     * Put one entry to the {@link IGrid#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IGrid.Builder) this;
    }

    /**
     * Put one entry to the {@link IGrid#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IGrid.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IGrid#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IGrid.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IGrid#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IGrid.Builder) this;
    }

    /**
     * Put one entry to the {@link IGrid#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IGrid.Builder) this;
    }

    /**
     * Put one entry to the {@link IGrid#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IGrid.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IGrid#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IGrid.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IGrid#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setTop(@Nullable String top) {
      this.top = top;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setContext(@Nullable String context) {
      this.context = context;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getSpan() span} attribute.
     * @param span The value for span (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setSpan(@Nullable String span) {
      this.span = span;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getPagingChild() pagingChild} attribute.
     * @param pagingChild The value for pagingChild (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setPagingChild(@Nullable IPaging pagingChild) {
      this.pagingChild = pagingChild;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#isSizedByContent() sizedByContent} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#isSizedByContent() sizedByContent}.</em>
     * @param sizedByContent The value for sizedByContent 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setSizedByContent(boolean sizedByContent) {
      this.sizedByContent = sizedByContent;
      optBits |= OPT_BIT_SIZED_BY_CONTENT;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#isAutopaging() autopaging} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#isAutopaging() autopaging}.</em>
     * @param autopaging The value for autopaging 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setAutopaging(boolean autopaging) {
      this.autopaging = autopaging;
      optBits |= OPT_BIT_AUTOPAGING;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getPagingPosition() pagingPosition} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#getPagingPosition() pagingPosition}.</em>
     * @param pagingPosition The value for pagingPosition 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setPagingPosition(String pagingPosition) {
      this.pagingPosition = Objects.requireNonNull(pagingPosition, "pagingPosition");
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#isNativeScrollbar() nativeScrollbar} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#isNativeScrollbar() nativeScrollbar}.</em>
     * @param nativeScrollbar The value for nativeScrollbar 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setNativeScrollbar(boolean nativeScrollbar) {
      this.nativeScrollbar = nativeScrollbar;
      optBits |= OPT_BIT_NATIVE_SCROLLBAR;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getRows() rows} attribute.
     * @param rows The value for rows (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setRows(@Nullable IRows rows) {
      this.rows = rows;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getColumns() columns} attribute.
     * @param columns The value for columns (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setColumns(@Nullable IColumns columns) {
      this.columns = columns;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getFoot() foot} attribute.
     * @param foot The value for foot (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setFoot(@Nullable IFoot foot) {
      this.foot = foot;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getFrozen() frozen} attribute.
     * @param frozen The value for frozen (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setFrozen(@Nullable IFrozen frozen) {
      this.frozen = frozen;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getEmptyMessage() emptyMessage} attribute.
     * @param emptyMessage The value for emptyMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setEmptyMessage(@Nullable String emptyMessage) {
      this.emptyMessage = emptyMessage;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getVisibleRows() visibleRows} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#getVisibleRows() visibleRows}.</em>
     * @param visibleRows The value for visibleRows 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setVisibleRows(int visibleRows) {
      this.visibleRows = visibleRows;
      optBits |= OPT_BIT_VISIBLE_ROWS;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getInnerWidth() innerWidth} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#getInnerWidth() innerWidth}.</em>
     * @param innerWidth The value for innerWidth 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setInnerWidth(String innerWidth) {
      this.innerWidth = Objects.requireNonNull(innerWidth, "innerWidth");
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getAutosort() autosort} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#getAutosort() autosort}.</em>
     * @param autosort The value for autosort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setAutosort(@Nullable String autosort) {
      this.autosort = autosort;
      optBits |= OPT_BIT_AUTOSORT;
      return (IGrid.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGrid#getOddRowSclass() oddRowSclass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGrid#getOddRowSclass() oddRowSclass}.</em>
     * @param oddRowSclass The value for oddRowSclass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setOddRowSclass(String oddRowSclass) {
      this.oddRowSclass = Objects.requireNonNull(oddRowSclass, "oddRowSclass");
      return (IGrid.Builder) this;
    }

    /**
     * Put one entry to the {@link IGrid#getAuxInfo() auxInfo} map.
     * @param key The key in the auxInfo map
     * @param value The associated value in the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder putAuxInfo(String key, Object value) {
      this.auxInfo.put(key, value);
      optBits |= OPT_BIT_AUX_INFO;
      return (IGrid.Builder) this;
    }

    /**
     * Put one entry to the {@link IGrid#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder putAuxInfo(Map.Entry<String, ? extends Object> entry) {
      this.auxInfo.put(entry);
      optBits |= OPT_BIT_AUX_INFO;
      return (IGrid.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IGrid#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo = ImmutableMap.builder();
      optBits |= OPT_BIT_AUX_INFO;
      return putAllAuxInfo(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IGrid#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder putAllAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo.putAll(entries);
      optBits |= OPT_BIT_AUX_INFO;
      return (IGrid.Builder) this;
    }

    /**
     * Adds one element to {@link IGrid#getAuxhead() auxhead} list.
     * @param element A auxhead element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder addAuxhead(IAuxhead element) {
      this.auxhead.add(element);
      optBits |= OPT_BIT_AUXHEAD;
      return (IGrid.Builder) this;
    }

    /**
     * Adds elements to {@link IGrid#getAuxhead() auxhead} list.
     * @param elements An array of auxhead elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder addAuxhead(IAuxhead... elements) {
      this.auxhead.add(elements);
      optBits |= OPT_BIT_AUXHEAD;
      return (IGrid.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IGrid#getAuxhead() auxhead} list.
     * @param elements An iterable of auxhead elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder setAuxhead(Iterable<? extends IAuxhead> elements) {
      this.auxhead = ImmutableList.builder();
      return addAllAuxhead(elements);
    }

    /**
     * Adds elements to {@link IGrid#getAuxhead() auxhead} list.
     * @param elements An iterable of auxhead elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGrid.Builder addAllAuxhead(Iterable<? extends IAuxhead> elements) {
      this.auxhead.addAll(elements);
      optBits |= OPT_BIT_AUXHEAD;
      return (IGrid.Builder) this;
    }

    /**
     * Builds a new {@link IGrid IGrid}.
     * @return An immutable instance of IGrid
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IGrid build() {
      return ImmutableIGrid.validate(new ImmutableIGrid(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean sizedByContentIsSet() {
      return (optBits & OPT_BIT_SIZED_BY_CONTENT) != 0;
    }

    private boolean autopagingIsSet() {
      return (optBits & OPT_BIT_AUTOPAGING) != 0;
    }

    private boolean nativeScrollbarIsSet() {
      return (optBits & OPT_BIT_NATIVE_SCROLLBAR) != 0;
    }

    private boolean visibleRowsIsSet() {
      return (optBits & OPT_BIT_VISIBLE_ROWS) != 0;
    }

    private boolean autosortIsSet() {
      return (optBits & OPT_BIT_AUTOSORT) != 0;
    }

    private boolean auxInfoIsSet() {
      return (optBits & OPT_BIT_AUX_INFO) != 0;
    }

    private boolean auxheadIsSet() {
      return (optBits & OPT_BIT_AUXHEAD) != 0;
    }
  }
}
