package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zkmax.zul.Camera;

/**
 * Immutable implementation of {@link ICamera}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ICamera.Builder()}.
 */
@Generated(from = "ICamera", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableICamera implements ICamera {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final String widgetClass;
  private final @Nullable String snapshotFormat;
  private final @Nullable String recordFormat;
  private final @Nullable ImmutableMap<String, Object> constraints;
  private final int maxsize;
  private final boolean audio;
  private final boolean previewRecord;
  private final int lengthLimit;

  private ImmutableICamera(ImmutableICamera.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.snapshotFormat = builder.snapshotFormat;
    this.recordFormat = builder.recordFormat;
    this.constraints = builder.constraints == null ? null : builder.constraints.build();
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.maxsizeIsSet()) {
      initShim.setMaxsize(builder.maxsize);
    }
    if (builder.audioIsSet()) {
      initShim.setAudio(builder.audio);
    }
    if (builder.previewRecordIsSet()) {
      initShim.setPreviewRecord(builder.previewRecord);
    }
    if (builder.lengthLimitIsSet()) {
      initShim.setLengthLimit(builder.lengthLimit);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.widgetClass = initShim.getWidgetClass();
    this.maxsize = initShim.getMaxsize();
    this.audio = initShim.isAudio();
    this.previewRecord = initShim.isPreviewRecord();
    this.lengthLimit = initShim.getLengthLimit();
    this.initShim = null;
  }

  private ImmutableICamera(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      String widgetClass,
      @Nullable String snapshotFormat,
      @Nullable String recordFormat,
      @Nullable ImmutableMap<String, Object> constraints,
      int maxsize,
      boolean audio,
      boolean previewRecord,
      int lengthLimit) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.widgetClass = widgetClass;
    this.snapshotFormat = snapshotFormat;
    this.recordFormat = recordFormat;
    this.constraints = constraints;
    this.maxsize = maxsize;
    this.audio = audio;
    this.previewRecord = previewRecord;
    this.lengthLimit = lengthLimit;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ICamera", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte maxsizeBuildStage = STAGE_UNINITIALIZED;
    private int maxsize;

    int getMaxsize() {
      if (maxsizeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxsizeBuildStage == STAGE_UNINITIALIZED) {
        maxsizeBuildStage = STAGE_INITIALIZING;
        this.maxsize = getMaxsizeInitialize();
        maxsizeBuildStage = STAGE_INITIALIZED;
      }
      return this.maxsize;
    }

    void setMaxsize(int maxsize) {
      this.maxsize = maxsize;
      maxsizeBuildStage = STAGE_INITIALIZED;
    }

    private byte audioBuildStage = STAGE_UNINITIALIZED;
    private boolean audio;

    boolean isAudio() {
      if (audioBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (audioBuildStage == STAGE_UNINITIALIZED) {
        audioBuildStage = STAGE_INITIALIZING;
        this.audio = isAudioInitialize();
        audioBuildStage = STAGE_INITIALIZED;
      }
      return this.audio;
    }

    void setAudio(boolean audio) {
      this.audio = audio;
      audioBuildStage = STAGE_INITIALIZED;
    }

    private byte previewRecordBuildStage = STAGE_UNINITIALIZED;
    private boolean previewRecord;

    boolean isPreviewRecord() {
      if (previewRecordBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (previewRecordBuildStage == STAGE_UNINITIALIZED) {
        previewRecordBuildStage = STAGE_INITIALIZING;
        this.previewRecord = isPreviewRecordInitialize();
        previewRecordBuildStage = STAGE_INITIALIZED;
      }
      return this.previewRecord;
    }

    void setPreviewRecord(boolean previewRecord) {
      this.previewRecord = previewRecord;
      previewRecordBuildStage = STAGE_INITIALIZED;
    }

    private byte lengthLimitBuildStage = STAGE_UNINITIALIZED;
    private int lengthLimit;

    int getLengthLimit() {
      if (lengthLimitBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (lengthLimitBuildStage == STAGE_UNINITIALIZED) {
        lengthLimitBuildStage = STAGE_INITIALIZING;
        this.lengthLimit = getLengthLimitInitialize();
        lengthLimitBuildStage = STAGE_INITIALIZED;
      }
      return this.lengthLimit;
    }

    void setLengthLimit(int lengthLimit) {
      this.lengthLimit = lengthLimit;
      lengthLimitBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (maxsizeBuildStage == STAGE_INITIALIZING) attributes.add("maxsize");
      if (audioBuildStage == STAGE_INITIALIZING) attributes.add("audio");
      if (previewRecordBuildStage == STAGE_INITIALIZING) attributes.add("previewRecord");
      if (lengthLimitBuildStage == STAGE_INITIALIZING) attributes.add("lengthLimit");
      return "Cannot build ICamera, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return ICamera.super.getId();
  }

  private boolean isVisibleInitialize() {
    return ICamera.super.isVisible();
  }

  private String getMoldInitialize() {
    return ICamera.super.getMold();
  }

  private int getZIndexInitialize() {
    return ICamera.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return ICamera.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return ICamera.super.isFocus();
  }

  private String getDroppableInitialize() {
    return ICamera.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return ICamera.super.getRenderdefer();
  }

  private String getWidgetClassInitialize() {
    return ICamera.super.getWidgetClass();
  }

  private int getMaxsizeInitialize() {
    return ICamera.super.getMaxsize();
  }

  private boolean isAudioInitialize() {
    return ICamera.super.isAudio();
  }

  private boolean isPreviewRecordInitialize() {
    return ICamera.super.isPreviewRecord();
  }

  private int getLengthLimitInitialize() {
    return ICamera.super.getLengthLimit();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code snapshotFormat} attribute
   */
  @Override
  public @Nullable String getSnapshotFormat() {
    return snapshotFormat;
  }

  /**
   * @return The value of the {@code recordFormat} attribute
   */
  @Override
  public @Nullable String getRecordFormat() {
    return recordFormat;
  }

  /**
   * @return The value of the {@code constraints} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, Object> getConstraints() {
    return constraints;
  }

  /**
   * @return The value of the {@code maxsize} attribute
   */
  @Override
  public int getMaxsize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMaxsize()
        : this.maxsize;
  }

  /**
   * @return The value of the {@code audio} attribute
   */
  @Override
  public boolean isAudio() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isAudio()
        : this.audio;
  }

  /**
   * @return The value of the {@code previewRecord} attribute
   */
  @Override
  public boolean isPreviewRecord() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isPreviewRecord()
        : this.previewRecord;
  }

  /**
   * @return The value of the {@code lengthLimit} attribute
   */
  @Override
  public int getLengthLimit() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLengthLimit()
        : this.lengthLimit;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableICamera(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableICamera(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ICamera#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICamera withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableICamera(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.widgetClass,
          this.snapshotFormat,
          this.recordFormat,
          this.constraints,
          this.maxsize,
          this.audio,
          this.previewRecord,
          this.lengthLimit));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ICamera#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICamera withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by replacing the {@link ICamera#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICamera withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by replacing the {@link ICamera#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICamera withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by replacing the {@link ICamera#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICamera withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getSnapshotFormat() snapshotFormat} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for snapshotFormat (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withSnapshotFormat(@Nullable String value) {
    if (Objects.equals(this.snapshotFormat, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        value,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getRecordFormat() recordFormat} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for recordFormat (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withRecordFormat(@Nullable String value) {
    if (Objects.equals(this.recordFormat, value)) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        value,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by replacing the {@link ICamera#getConstraints() constraints} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the constraints map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICamera withConstraints(@Nullable Map<String, ? extends Object> entries) {
    if (this.constraints == entries) return this;
    @Nullable ImmutableMap<String, Object> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        newValue,
        this.maxsize,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getMaxsize() maxsize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxsize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withMaxsize(int value) {
    if (this.maxsize == value) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        value,
        this.audio,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#isAudio() audio} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for audio
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withAudio(boolean value) {
    if (this.audio == value) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        value,
        this.previewRecord,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#isPreviewRecord() previewRecord} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for previewRecord
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withPreviewRecord(boolean value) {
    if (this.previewRecord == value) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        value,
        this.lengthLimit));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICamera#getLengthLimit() lengthLimit} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lengthLimit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICamera withLengthLimit(int value) {
    if (this.lengthLimit == value) return this;
    return validate(new ImmutableICamera(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.snapshotFormat,
        this.recordFormat,
        this.constraints,
        this.maxsize,
        this.audio,
        this.previewRecord,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableICamera} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableICamera
        && equalTo((ImmutableICamera) another);
  }

  private boolean equalTo(ImmutableICamera another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(snapshotFormat, another.snapshotFormat)
        && Objects.equals(recordFormat, another.recordFormat)
        && Objects.equals(constraints, another.constraints)
        && maxsize == another.maxsize
        && audio == another.audio
        && previewRecord == another.previewRecord
        && lengthLimit == another.lengthLimit;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code widgetClass}, {@code snapshotFormat}, {@code recordFormat}, {@code constraints}, {@code maxsize}, {@code audio}, {@code previewRecord}, {@code lengthLimit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(snapshotFormat);
    h += (h << 5) + Objects.hashCode(recordFormat);
    h += (h << 5) + Objects.hashCode(constraints);
    h += (h << 5) + maxsize;
    h += (h << 5) + Booleans.hashCode(audio);
    h += (h << 5) + Booleans.hashCode(previewRecord);
    h += (h << 5) + lengthLimit;
    return h;
  }

  /**
   * Prints the immutable value {@code ICamera} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ICamera")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("widgetClass", widgetClass)
        .add("snapshotFormat", snapshotFormat)
        .add("recordFormat", recordFormat)
        .add("constraints", constraints)
        .add("maxsize", maxsize)
        .add("audio", audio)
        .add("previewRecord", previewRecord)
        .add("lengthLimit", lengthLimit)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Camera> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ICamera#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Camera> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(ICamera.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableICamera validate(ImmutableICamera instance) {
    instance.checkMaxSize();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableICamera) instance.checkDroppable();
    instance = (ImmutableICamera) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ICamera} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ICamera instance
   */
  public static ICamera copyOf(ICamera instance) {
    if (instance instanceof ImmutableICamera) {
      return (ImmutableICamera) instance;
    }
    return new ICamera.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ICamera ICamera}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ICamera", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_MAXSIZE = 0x10L;
    private static final long OPT_BIT_AUDIO = 0x20L;
    private static final long OPT_BIT_PREVIEW_RECORD = 0x40L;
    private static final long OPT_BIT_LENGTH_LIMIT = 0x80L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable String widgetClass;
    private @Nullable String snapshotFormat;
    private @Nullable String recordFormat;
    private ImmutableMap.Builder<String, Object> constraints = null;
    private int maxsize;
    private boolean audio;
    private boolean previewRecord;
    private int lengthLimit;

    /**
     * Creates a builder for {@link ICamera ICamera} instances.
     * <pre>
     * new ICamera.Builder()
     *    .setId(String) // optional {@link ICamera#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link ICamera#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link ICamera#getActions() actions}
     *    .setVisible(boolean) // optional {@link ICamera#isVisible() visible}
     *    .setMold(String) // optional {@link ICamera#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link ICamera#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ICamera#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ICamera#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ICamera#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link ICamera#getLeft() left}
     *    .setTop(String | null) // nullable {@link ICamera#getTop() top}
     *    .setZIndex(int) // optional {@link ICamera#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link ICamera#getHeight() height}
     *    .setWidth(String | null) // nullable {@link ICamera#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link ICamera#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link ICamera#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link ICamera#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link ICamera#getStyle() style}
     *    .setDraggable(String) // optional {@link ICamera#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link ICamera#isFocus() focus}
     *    .setDroppable(String) // optional {@link ICamera#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link ICamera#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link ICamera#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link ICamera#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link ICamera#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link ICamera#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link ICamera#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link ICamera#getContext() context}
     *    .setPopup(String | null) // nullable {@link ICamera#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link ICamera#getTooltip() tooltip}
     *    .setWidgetClass(String) // optional {@link ICamera#getWidgetClass() widgetClass}
     *    .setSnapshotFormat(String | null) // nullable {@link ICamera#getSnapshotFormat() snapshotFormat}
     *    .setRecordFormat(String | null) // nullable {@link ICamera#getRecordFormat() recordFormat}
     *    .setConstraints(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link ICamera#getConstraints() constraints}
     *    .setMaxsize(int) // optional {@link ICamera#getMaxsize() maxsize}
     *    .setAudio(boolean) // optional {@link ICamera#isAudio() audio}
     *    .setPreviewRecord(boolean) // optional {@link ICamera#isPreviewRecord() previewRecord}
     *    .setLengthLimit(int) // optional {@link ICamera#getLengthLimit() lengthLimit}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ICamera.Builder)) {
        throw new UnsupportedOperationException("Use: new ICamera.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ICamera} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder from(ICamera instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setWidgetClass(instance.getWidgetClass());
      @Nullable String snapshotFormatValue = instance.getSnapshotFormat();
      if (snapshotFormatValue != null) {
        setSnapshotFormat(snapshotFormatValue);
      }
      @Nullable String recordFormatValue = instance.getRecordFormat();
      if (recordFormatValue != null) {
        setRecordFormat(recordFormatValue);
      }
      @Nullable Map<String, Object> constraintsValue = instance.getConstraints();
      if (constraintsValue != null) {
        putAllConstraints(constraintsValue);
      }
      setMaxsize(instance.getMaxsize());
      setAudio(instance.isAudio());
      setPreviewRecord(instance.isPreviewRecord());
      setLengthLimit(instance.getLengthLimit());
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICamera#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (ICamera.Builder) this;
    }

    /**
     * Adds one element to {@link ICamera#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (ICamera.Builder) this;
    }

    /**
     * Adds elements to {@link ICamera#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (ICamera.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link ICamera#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (ICamera.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link ICamera#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICamera#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICamera#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (ICamera.Builder) this;
    }

    /**
     * Put one entry to the {@link ICamera#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (ICamera.Builder) this;
    }

    /**
     * Put one entry to the {@link ICamera#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (ICamera.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ICamera#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (ICamera.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ICamera#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (ICamera.Builder) this;
    }

    /**
     * Put one entry to the {@link ICamera#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (ICamera.Builder) this;
    }

    /**
     * Put one entry to the {@link ICamera#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (ICamera.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ICamera#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (ICamera.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ICamera#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (ICamera.Builder) this;
    }

    /**
     * Put one entry to the {@link ICamera#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (ICamera.Builder) this;
    }

    /**
     * Put one entry to the {@link ICamera#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (ICamera.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ICamera#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (ICamera.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ICamera#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setTop(@Nullable String top) {
      this.top = top;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICamera#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICamera#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICamera#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICamera#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICamera#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setContext(@Nullable String context) {
      this.context = context;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICamera#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getSnapshotFormat() snapshotFormat} attribute.
     * @param snapshotFormat The value for snapshotFormat (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setSnapshotFormat(@Nullable String snapshotFormat) {
      this.snapshotFormat = snapshotFormat;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getRecordFormat() recordFormat} attribute.
     * @param recordFormat The value for recordFormat (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setRecordFormat(@Nullable String recordFormat) {
      this.recordFormat = recordFormat;
      return (ICamera.Builder) this;
    }

    /**
     * Put one entry to the {@link ICamera#getConstraints() constraints} map.
     * @param key The key in the constraints map
     * @param value The associated value in the constraints map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder putConstraints(String key, Object value) {
      if (this.constraints == null) {
        this.constraints = ImmutableMap.builder();
      }
      this.constraints.put(key, value);
      return (ICamera.Builder) this;
    }

    /**
     * Put one entry to the {@link ICamera#getConstraints() constraints} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder putConstraints(Map.Entry<String, ? extends Object> entry) {
      if (this.constraints == null) {
        this.constraints = ImmutableMap.builder();
      }
      this.constraints.put(entry);
      return (ICamera.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ICamera#getConstraints() constraints} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the constraints map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setConstraints(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.constraints = null;
        return (ICamera.Builder) this;
      }
      this.constraints = ImmutableMap.builder();
      return putAllConstraints(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ICamera#getConstraints() constraints} map. Nulls are not permitted
     * @param entries The entries that will be added to the constraints map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder putAllConstraints(Map<String, ? extends Object> entries) {
      if (this.constraints == null) {
        this.constraints = ImmutableMap.builder();
      }
      this.constraints.putAll(entries);
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getMaxsize() maxsize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICamera#getMaxsize() maxsize}.</em>
     * @param maxsize The value for maxsize 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setMaxsize(int maxsize) {
      this.maxsize = maxsize;
      optBits |= OPT_BIT_MAXSIZE;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#isAudio() audio} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICamera#isAudio() audio}.</em>
     * @param audio The value for audio 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setAudio(boolean audio) {
      this.audio = audio;
      optBits |= OPT_BIT_AUDIO;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#isPreviewRecord() previewRecord} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICamera#isPreviewRecord() previewRecord}.</em>
     * @param previewRecord The value for previewRecord 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setPreviewRecord(boolean previewRecord) {
      this.previewRecord = previewRecord;
      optBits |= OPT_BIT_PREVIEW_RECORD;
      return (ICamera.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICamera#getLengthLimit() lengthLimit} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICamera#getLengthLimit() lengthLimit}.</em>
     * @param lengthLimit The value for lengthLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICamera.Builder setLengthLimit(int lengthLimit) {
      this.lengthLimit = lengthLimit;
      optBits |= OPT_BIT_LENGTH_LIMIT;
      return (ICamera.Builder) this;
    }

    /**
     * Builds a new {@link ICamera ICamera}.
     * @return An immutable instance of ICamera
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ICamera build() {
      return ImmutableICamera.validate(new ImmutableICamera(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean maxsizeIsSet() {
      return (optBits & OPT_BIT_MAXSIZE) != 0;
    }

    private boolean audioIsSet() {
      return (optBits & OPT_BIT_AUDIO) != 0;
    }

    private boolean previewRecordIsSet() {
      return (optBits & OPT_BIT_PREVIEW_RECORD) != 0;
    }

    private boolean lengthLimitIsSet() {
      return (optBits & OPT_BIT_LENGTH_LIMIT) != 0;
    }
  }
}
