package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Checkbox;

/**
 * Immutable implementation of {@link ICheckbox}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ICheckbox.Builder()}.
 */
@Generated(from = "ICheckbox", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableICheckbox implements ICheckbox {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final String label;
  private final @Nullable String iconSclass;
  private final @Nullable String[] iconSclasses;
  private final @Nullable String iconTooltip;
  private final @Nullable String[] iconTooltips;
  private final @Nullable String image;
  private final @Nullable String hoverImage;
  private final boolean preloadImage;
  private final @Nullable Object value;
  private final @Nullable String autodisable;
  private final @Nullable String name;
  private final boolean disabled;
  private final boolean indeterminate;
  private final boolean checked;
  private final String widgetClass;

  private ImmutableICheckbox(ImmutableICheckbox.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.value = builder.value;
    this.autodisable = builder.autodisable;
    this.name = builder.name;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.label != null) {
      initShim.setLabel(builder.label);
    }
    if (builder.iconSclassIsSet()) {
      initShim.setIconSclass(builder.iconSclass);
    }
    if (builder.iconSclassesIsSet()) {
      initShim.setIconSclasses(builder.iconSclasses);
    }
    if (builder.iconTooltipIsSet()) {
      initShim.setIconTooltip(builder.iconTooltip);
    }
    if (builder.iconTooltipsIsSet()) {
      initShim.setIconTooltips(builder.iconTooltips);
    }
    if (builder.imageIsSet()) {
      initShim.setImage(builder.image);
    }
    if (builder.hoverImageIsSet()) {
      initShim.setHoverImage(builder.hoverImage);
    }
    if (builder.preloadImageIsSet()) {
      initShim.setPreloadImage(builder.preloadImage);
    }
    if (builder.disabledIsSet()) {
      initShim.setDisabled(builder.disabled);
    }
    if (builder.indeterminateIsSet()) {
      initShim.setIndeterminate(builder.indeterminate);
    }
    if (builder.checkedIsSet()) {
      initShim.setChecked(builder.checked);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.label = initShim.getLabel();
    this.iconSclass = initShim.getIconSclass();
    this.iconSclasses = initShim.getIconSclasses();
    this.iconTooltip = initShim.getIconTooltip();
    this.iconTooltips = initShim.getIconTooltips();
    this.image = initShim.getImage();
    this.hoverImage = initShim.getHoverImage();
    this.preloadImage = initShim.isPreloadImage();
    this.disabled = initShim.isDisabled();
    this.indeterminate = initShim.isIndeterminate();
    this.checked = initShim.isChecked();
    this.widgetClass = initShim.getWidgetClass();
    this.initShim = null;
  }

  private ImmutableICheckbox(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      String label,
      @Nullable String iconSclass,
      @Nullable String[] iconSclasses,
      @Nullable String iconTooltip,
      @Nullable String[] iconTooltips,
      @Nullable String image,
      @Nullable String hoverImage,
      boolean preloadImage,
      @Nullable Object value,
      @Nullable String autodisable,
      @Nullable String name,
      boolean disabled,
      boolean indeterminate,
      boolean checked,
      String widgetClass) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.label = label;
    this.iconSclass = iconSclass;
    this.iconSclasses = iconSclasses;
    this.iconTooltip = iconTooltip;
    this.iconTooltips = iconTooltips;
    this.image = image;
    this.hoverImage = hoverImage;
    this.preloadImage = preloadImage;
    this.value = value;
    this.autodisable = autodisable;
    this.name = name;
    this.disabled = disabled;
    this.indeterminate = indeterminate;
    this.checked = checked;
    this.widgetClass = widgetClass;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ICheckbox", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte labelBuildStage = STAGE_UNINITIALIZED;
    private String label;

    String getLabel() {
      if (labelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (labelBuildStage == STAGE_UNINITIALIZED) {
        labelBuildStage = STAGE_INITIALIZING;
        this.label = Objects.requireNonNull(getLabelInitialize(), "label");
        labelBuildStage = STAGE_INITIALIZED;
      }
      return this.label;
    }

    void setLabel(String label) {
      this.label = label;
      labelBuildStage = STAGE_INITIALIZED;
    }

    private byte iconSclassBuildStage = STAGE_UNINITIALIZED;
    private String iconSclass;

    String getIconSclass() {
      if (iconSclassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (iconSclassBuildStage == STAGE_UNINITIALIZED) {
        iconSclassBuildStage = STAGE_INITIALIZING;
        this.iconSclass = getIconSclassInitialize();
        iconSclassBuildStage = STAGE_INITIALIZED;
      }
      return this.iconSclass;
    }

    void setIconSclass(String iconSclass) {
      this.iconSclass = iconSclass;
      iconSclassBuildStage = STAGE_INITIALIZED;
    }

    private byte iconSclassesBuildStage = STAGE_UNINITIALIZED;
    private String[] iconSclasses;

    String[] getIconSclasses() {
      if (iconSclassesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (iconSclassesBuildStage == STAGE_UNINITIALIZED) {
        iconSclassesBuildStage = STAGE_INITIALIZING;
        this.iconSclasses = getIconSclassesInitialize();
        iconSclassesBuildStage = STAGE_INITIALIZED;
      }
      return this.iconSclasses;
    }

    void setIconSclasses(String[] iconSclasses) {
      this.iconSclasses = iconSclasses;
      iconSclassesBuildStage = STAGE_INITIALIZED;
    }

    private byte iconTooltipBuildStage = STAGE_UNINITIALIZED;
    private String iconTooltip;

    String getIconTooltip() {
      if (iconTooltipBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (iconTooltipBuildStage == STAGE_UNINITIALIZED) {
        iconTooltipBuildStage = STAGE_INITIALIZING;
        this.iconTooltip = getIconTooltipInitialize();
        iconTooltipBuildStage = STAGE_INITIALIZED;
      }
      return this.iconTooltip;
    }

    void setIconTooltip(String iconTooltip) {
      this.iconTooltip = iconTooltip;
      iconTooltipBuildStage = STAGE_INITIALIZED;
    }

    private byte iconTooltipsBuildStage = STAGE_UNINITIALIZED;
    private String[] iconTooltips;

    String[] getIconTooltips() {
      if (iconTooltipsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (iconTooltipsBuildStage == STAGE_UNINITIALIZED) {
        iconTooltipsBuildStage = STAGE_INITIALIZING;
        this.iconTooltips = getIconTooltipsInitialize();
        iconTooltipsBuildStage = STAGE_INITIALIZED;
      }
      return this.iconTooltips;
    }

    void setIconTooltips(String[] iconTooltips) {
      this.iconTooltips = iconTooltips;
      iconTooltipsBuildStage = STAGE_INITIALIZED;
    }

    private byte imageBuildStage = STAGE_UNINITIALIZED;
    private String image;

    String getImage() {
      if (imageBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (imageBuildStage == STAGE_UNINITIALIZED) {
        imageBuildStage = STAGE_INITIALIZING;
        this.image = getImageInitialize();
        imageBuildStage = STAGE_INITIALIZED;
      }
      return this.image;
    }

    void setImage(String image) {
      this.image = image;
      imageBuildStage = STAGE_INITIALIZED;
    }

    private byte hoverImageBuildStage = STAGE_UNINITIALIZED;
    private String hoverImage;

    String getHoverImage() {
      if (hoverImageBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (hoverImageBuildStage == STAGE_UNINITIALIZED) {
        hoverImageBuildStage = STAGE_INITIALIZING;
        this.hoverImage = getHoverImageInitialize();
        hoverImageBuildStage = STAGE_INITIALIZED;
      }
      return this.hoverImage;
    }

    void setHoverImage(String hoverImage) {
      this.hoverImage = hoverImage;
      hoverImageBuildStage = STAGE_INITIALIZED;
    }

    private byte preloadImageBuildStage = STAGE_UNINITIALIZED;
    private boolean preloadImage;

    boolean isPreloadImage() {
      if (preloadImageBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (preloadImageBuildStage == STAGE_UNINITIALIZED) {
        preloadImageBuildStage = STAGE_INITIALIZING;
        this.preloadImage = isPreloadImageInitialize();
        preloadImageBuildStage = STAGE_INITIALIZED;
      }
      return this.preloadImage;
    }

    void setPreloadImage(boolean preloadImage) {
      this.preloadImage = preloadImage;
      preloadImageBuildStage = STAGE_INITIALIZED;
    }

    private byte disabledBuildStage = STAGE_UNINITIALIZED;
    private boolean disabled;

    boolean isDisabled() {
      if (disabledBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disabledBuildStage == STAGE_UNINITIALIZED) {
        disabledBuildStage = STAGE_INITIALIZING;
        this.disabled = isDisabledInitialize();
        disabledBuildStage = STAGE_INITIALIZED;
      }
      return this.disabled;
    }

    void setDisabled(boolean disabled) {
      this.disabled = disabled;
      disabledBuildStage = STAGE_INITIALIZED;
    }

    private byte indeterminateBuildStage = STAGE_UNINITIALIZED;
    private boolean indeterminate;

    boolean isIndeterminate() {
      if (indeterminateBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (indeterminateBuildStage == STAGE_UNINITIALIZED) {
        indeterminateBuildStage = STAGE_INITIALIZING;
        this.indeterminate = isIndeterminateInitialize();
        indeterminateBuildStage = STAGE_INITIALIZED;
      }
      return this.indeterminate;
    }

    void setIndeterminate(boolean indeterminate) {
      this.indeterminate = indeterminate;
      indeterminateBuildStage = STAGE_INITIALIZED;
    }

    private byte checkedBuildStage = STAGE_UNINITIALIZED;
    private boolean checked;

    boolean isChecked() {
      if (checkedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (checkedBuildStage == STAGE_UNINITIALIZED) {
        checkedBuildStage = STAGE_INITIALIZING;
        this.checked = isCheckedInitialize();
        checkedBuildStage = STAGE_INITIALIZED;
      }
      return this.checked;
    }

    void setChecked(boolean checked) {
      this.checked = checked;
      checkedBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (labelBuildStage == STAGE_INITIALIZING) attributes.add("label");
      if (iconSclassBuildStage == STAGE_INITIALIZING) attributes.add("iconSclass");
      if (iconSclassesBuildStage == STAGE_INITIALIZING) attributes.add("iconSclasses");
      if (iconTooltipBuildStage == STAGE_INITIALIZING) attributes.add("iconTooltip");
      if (iconTooltipsBuildStage == STAGE_INITIALIZING) attributes.add("iconTooltips");
      if (imageBuildStage == STAGE_INITIALIZING) attributes.add("image");
      if (hoverImageBuildStage == STAGE_INITIALIZING) attributes.add("hoverImage");
      if (preloadImageBuildStage == STAGE_INITIALIZING) attributes.add("preloadImage");
      if (disabledBuildStage == STAGE_INITIALIZING) attributes.add("disabled");
      if (indeterminateBuildStage == STAGE_INITIALIZING) attributes.add("indeterminate");
      if (checkedBuildStage == STAGE_INITIALIZING) attributes.add("checked");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      return "Cannot build ICheckbox, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return ICheckbox.super.getId();
  }

  private boolean isVisibleInitialize() {
    return ICheckbox.super.isVisible();
  }

  private String getMoldInitialize() {
    return ICheckbox.super.getMold();
  }

  private int getZIndexInitialize() {
    return ICheckbox.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return ICheckbox.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return ICheckbox.super.isFocus();
  }

  private String getDroppableInitialize() {
    return ICheckbox.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return ICheckbox.super.getRenderdefer();
  }

  private String getLabelInitialize() {
    return ICheckbox.super.getLabel();
  }

  private @Nullable String getIconSclassInitialize() {
    return ICheckbox.super.getIconSclass();
  }

  private @Nullable String[] getIconSclassesInitialize() {
    return ICheckbox.super.getIconSclasses();
  }

  private @Nullable String getIconTooltipInitialize() {
    return ICheckbox.super.getIconTooltip();
  }

  private @Nullable String[] getIconTooltipsInitialize() {
    return ICheckbox.super.getIconTooltips();
  }

  private @Nullable String getImageInitialize() {
    return ICheckbox.super.getImage();
  }

  private @Nullable String getHoverImageInitialize() {
    return ICheckbox.super.getHoverImage();
  }

  private boolean isPreloadImageInitialize() {
    return ICheckbox.super.isPreloadImage();
  }

  private boolean isDisabledInitialize() {
    return ICheckbox.super.isDisabled();
  }

  private boolean isIndeterminateInitialize() {
    return ICheckbox.super.isIndeterminate();
  }

  private boolean isCheckedInitialize() {
    return ICheckbox.super.isChecked();
  }

  private String getWidgetClassInitialize() {
    return ICheckbox.super.getWidgetClass();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @Override
  public String getLabel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLabel()
        : this.label;
  }

  /**
   * @return The value of the {@code iconSclass} attribute
   */
  @Override
  public @Nullable String getIconSclass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getIconSclass()
        : this.iconSclass;
  }

  /**
   * @return A cloned {@code iconSclasses} array
   */
  @Override
  public @Nullable String[] getIconSclasses() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getIconSclasses()
        : this.iconSclasses;
  }

  /**
   * @return The value of the {@code iconTooltip} attribute
   */
  @Override
  public @Nullable String getIconTooltip() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getIconTooltip()
        : this.iconTooltip;
  }

  /**
   * @return A cloned {@code iconTooltips} array
   */
  @Override
  public @Nullable String[] getIconTooltips() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getIconTooltips()
        : this.iconTooltips;
  }

  /**
   * @return The value of the {@code image} attribute
   */
  @Override
  public @Nullable String getImage() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getImage()
        : this.image;
  }

  /**
   * @return The value of the {@code hoverImage} attribute
   */
  @Override
  public @Nullable String getHoverImage() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHoverImage()
        : this.hoverImage;
  }

  /**
   * @return The value of the {@code preloadImage} attribute
   */
  @StatelessOnly
  @Override
  public boolean isPreloadImage() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isPreloadImage()
        : this.preloadImage;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public @Nullable Object getValue() {
    return value;
  }

  /**
   * @return The value of the {@code autodisable} attribute
   */
  @Override
  public @Nullable String getAutodisable() {
    return autodisable;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code disabled} attribute
   */
  @Override
  public boolean isDisabled() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDisabled()
        : this.disabled;
  }

  /**
   * @return The value of the {@code indeterminate} attribute
   */
  @Override
  public boolean isIndeterminate() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isIndeterminate()
        : this.indeterminate;
  }

  /**
   * @return The value of the {@code checked} attribute
   */
  @Override
  public boolean isChecked() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isChecked()
        : this.checked;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableICheckbox(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ICheckbox#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICheckbox withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableICheckbox(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.label,
          this.iconSclass,
          this.iconSclasses,
          this.iconTooltip,
          this.iconTooltips,
          this.image,
          this.hoverImage,
          this.preloadImage,
          this.value,
          this.autodisable,
          this.name,
          this.disabled,
          this.indeterminate,
          this.checked,
          this.widgetClass));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ICheckbox#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICheckbox withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by replacing the {@link ICheckbox#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICheckbox withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by replacing the {@link ICheckbox#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICheckbox withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by replacing the {@link ICheckbox#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICheckbox withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getIconSclass() iconSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for iconSclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withIconSclass(@Nullable String value) {
    if (Objects.equals(this.iconSclass, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        value,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ICheckbox#getIconSclasses() iconSclasses}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for iconSclasses
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICheckbox withIconSclasses(@Nullable String... elements) {
    @Nullable String[] newValue = elements == null ? null : elements.clone();
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        newValue,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getIconTooltip() iconTooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for iconTooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withIconTooltip(@Nullable String value) {
    if (Objects.equals(this.iconTooltip, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        value,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ICheckbox#getIconTooltips() iconTooltips}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for iconTooltips
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICheckbox withIconTooltips(@Nullable String... elements) {
    @Nullable String[] newValue = elements == null ? null : elements.clone();
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        newValue,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getImage() image} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for image (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withImage(@Nullable String value) {
    if (Objects.equals(this.image, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        value,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getHoverImage() hoverImage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hoverImage (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withHoverImage(@Nullable String value) {
    if (Objects.equals(this.hoverImage, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        value,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#isPreloadImage() preloadImage} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for preloadImage
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withPreloadImage(boolean value) {
    if (this.preloadImage == value) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        value,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withValue(@Nullable Object value) {
    if (this.value == value) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getAutodisable() autodisable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autodisable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withAutodisable(@Nullable String value) {
    if (Objects.equals(this.autodisable, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        value,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        value,
        this.disabled,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#isDisabled() disabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withDisabled(boolean value) {
    if (this.disabled == value) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        value,
        this.indeterminate,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#isIndeterminate() indeterminate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for indeterminate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withIndeterminate(boolean value) {
    if (this.indeterminate == value) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        value,
        this.checked,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#isChecked() checked} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for checked
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withChecked(boolean value) {
    if (this.checked == value) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        value,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICheckbox#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICheckbox withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableICheckbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.label,
        this.iconSclass,
        this.iconSclasses,
        this.iconTooltip,
        this.iconTooltips,
        this.image,
        this.hoverImage,
        this.preloadImage,
        this.value,
        this.autodisable,
        this.name,
        this.disabled,
        this.indeterminate,
        this.checked,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableICheckbox} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableICheckbox
        && equalTo((ImmutableICheckbox) another);
  }

  private boolean equalTo(ImmutableICheckbox another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && label.equals(another.label)
        && Objects.equals(iconSclass, another.iconSclass)
        && Arrays.equals(iconSclasses, another.iconSclasses)
        && Objects.equals(iconTooltip, another.iconTooltip)
        && Arrays.equals(iconTooltips, another.iconTooltips)
        && Objects.equals(image, another.image)
        && Objects.equals(hoverImage, another.hoverImage)
        && preloadImage == another.preloadImage
        && Objects.equals(value, another.value)
        && Objects.equals(autodisable, another.autodisable)
        && Objects.equals(name, another.name)
        && disabled == another.disabled
        && indeterminate == another.indeterminate
        && checked == another.checked
        && widgetClass.equals(another.widgetClass);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code label}, {@code iconSclass}, {@code iconSclasses}, {@code iconTooltip}, {@code iconTooltips}, {@code image}, {@code hoverImage}, {@code preloadImage}, {@code value}, {@code autodisable}, {@code name}, {@code disabled}, {@code indeterminate}, {@code checked}, {@code widgetClass}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + label.hashCode();
    h += (h << 5) + Objects.hashCode(iconSclass);
    h += (h << 5) + Arrays.hashCode(iconSclasses);
    h += (h << 5) + Objects.hashCode(iconTooltip);
    h += (h << 5) + Arrays.hashCode(iconTooltips);
    h += (h << 5) + Objects.hashCode(image);
    h += (h << 5) + Objects.hashCode(hoverImage);
    h += (h << 5) + Booleans.hashCode(preloadImage);
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Objects.hashCode(autodisable);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Booleans.hashCode(disabled);
    h += (h << 5) + Booleans.hashCode(indeterminate);
    h += (h << 5) + Booleans.hashCode(checked);
    h += (h << 5) + widgetClass.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ICheckbox} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ICheckbox")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("label", label)
        .add("iconSclass", iconSclass)
        .add("iconSclasses", Arrays.toString(iconSclasses))
        .add("iconTooltip", iconTooltip)
        .add("iconTooltips", Arrays.toString(iconTooltips))
        .add("image", image)
        .add("hoverImage", hoverImage)
        .add("preloadImage", preloadImage)
        .add("value", value)
        .add("autodisable", autodisable)
        .add("name", name)
        .add("disabled", disabled)
        .add("indeterminate", indeterminate)
        .add("checked", checked)
        .add("widgetClass", widgetClass)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Checkbox> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ICheckbox#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Checkbox> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(ICheckbox.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableICheckbox validate(ImmutableICheckbox instance) {
    instance.checkMold();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableICheckbox) instance.checkDroppable();
    instance = (ImmutableICheckbox) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ICheckbox} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ICheckbox instance
   */
  public static ICheckbox copyOf(ICheckbox instance) {
    if (instance instanceof ImmutableICheckbox) {
      return (ImmutableICheckbox) instance;
    }
    return new ICheckbox.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ICheckbox ICheckbox}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ICheckbox", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_ICON_SCLASS = 0x10L;
    private static final long OPT_BIT_ICON_SCLASSES = 0x20L;
    private static final long OPT_BIT_ICON_TOOLTIP = 0x40L;
    private static final long OPT_BIT_ICON_TOOLTIPS = 0x80L;
    private static final long OPT_BIT_IMAGE = 0x100L;
    private static final long OPT_BIT_HOVER_IMAGE = 0x200L;
    private static final long OPT_BIT_PRELOAD_IMAGE = 0x400L;
    private static final long OPT_BIT_DISABLED = 0x800L;
    private static final long OPT_BIT_INDETERMINATE = 0x1000L;
    private static final long OPT_BIT_CHECKED = 0x2000L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable String label;
    private @Nullable String iconSclass;
    private @Nullable String[] iconSclasses;
    private @Nullable String iconTooltip;
    private @Nullable String[] iconTooltips;
    private @Nullable String image;
    private @Nullable String hoverImage;
    private boolean preloadImage;
    private @Nullable Object value;
    private @Nullable String autodisable;
    private @Nullable String name;
    private boolean disabled;
    private boolean indeterminate;
    private boolean checked;
    private @Nullable String widgetClass;

    /**
     * Creates a builder for {@link ICheckbox ICheckbox} instances.
     * <pre>
     * new ICheckbox.Builder()
     *    .setId(String) // optional {@link ICheckbox#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link ICheckbox#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link ICheckbox#getActions() actions}
     *    .setVisible(boolean) // optional {@link ICheckbox#isVisible() visible}
     *    .setMold(String) // optional {@link ICheckbox#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link ICheckbox#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ICheckbox#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ICheckbox#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ICheckbox#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link ICheckbox#getLeft() left}
     *    .setTop(String | null) // nullable {@link ICheckbox#getTop() top}
     *    .setZIndex(int) // optional {@link ICheckbox#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link ICheckbox#getHeight() height}
     *    .setWidth(String | null) // nullable {@link ICheckbox#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link ICheckbox#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link ICheckbox#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link ICheckbox#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link ICheckbox#getStyle() style}
     *    .setDraggable(String) // optional {@link ICheckbox#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link ICheckbox#isFocus() focus}
     *    .setDroppable(String) // optional {@link ICheckbox#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link ICheckbox#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link ICheckbox#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link ICheckbox#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link ICheckbox#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link ICheckbox#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link ICheckbox#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link ICheckbox#getContext() context}
     *    .setPopup(String | null) // nullable {@link ICheckbox#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link ICheckbox#getTooltip() tooltip}
     *    .setLabel(String) // optional {@link ICheckbox#getLabel() label}
     *    .setIconSclass(String | null) // nullable {@link ICheckbox#getIconSclass() iconSclass}
     *    .setIconSclasses(String[] | null) // nullable {@link ICheckbox#getIconSclasses() iconSclasses}
     *    .setIconTooltip(String | null) // nullable {@link ICheckbox#getIconTooltip() iconTooltip}
     *    .setIconTooltips(String[] | null) // nullable {@link ICheckbox#getIconTooltips() iconTooltips}
     *    .setImage(String | null) // nullable {@link ICheckbox#getImage() image}
     *    .setHoverImage(String | null) // nullable {@link ICheckbox#getHoverImage() hoverImage}
     *    .setPreloadImage(boolean) // optional {@link ICheckbox#isPreloadImage() preloadImage}
     *    .setValue(Object | null) // nullable {@link ICheckbox#getValue() value}
     *    .setAutodisable(String | null) // nullable {@link ICheckbox#getAutodisable() autodisable}
     *    .setName(String | null) // nullable {@link ICheckbox#getName() name}
     *    .setDisabled(boolean) // optional {@link ICheckbox#isDisabled() disabled}
     *    .setIndeterminate(boolean) // optional {@link ICheckbox#isIndeterminate() indeterminate}
     *    .setChecked(boolean) // optional {@link ICheckbox#isChecked() checked}
     *    .setWidgetClass(String) // optional {@link ICheckbox#getWidgetClass() widgetClass}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ICheckbox.Builder)) {
        throw new UnsupportedOperationException("Use: new ICheckbox.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ICheckbox} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder from(ICheckbox instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setLabel(instance.getLabel());
      @Nullable String iconSclassValue = instance.getIconSclass();
      if (iconSclassValue != null) {
        setIconSclass(iconSclassValue);
      }
      @Nullable String[] iconSclassesValue = instance.getIconSclasses();
      if (iconSclassesValue != null) {
        setIconSclasses(iconSclassesValue);
      }
      @Nullable String iconTooltipValue = instance.getIconTooltip();
      if (iconTooltipValue != null) {
        setIconTooltip(iconTooltipValue);
      }
      @Nullable String[] iconTooltipsValue = instance.getIconTooltips();
      if (iconTooltipsValue != null) {
        setIconTooltips(iconTooltipsValue);
      }
      @Nullable String imageValue = instance.getImage();
      if (imageValue != null) {
        setImage(imageValue);
      }
      @Nullable String hoverImageValue = instance.getHoverImage();
      if (hoverImageValue != null) {
        setHoverImage(hoverImageValue);
      }
      setPreloadImage(instance.isPreloadImage());
      @Nullable Object valueValue = instance.getValue();
      if (valueValue != null) {
        setValue(valueValue);
      }
      @Nullable String autodisableValue = instance.getAutodisable();
      if (autodisableValue != null) {
        setAutodisable(autodisableValue);
      }
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        setName(nameValue);
      }
      setDisabled(instance.isDisabled());
      setIndeterminate(instance.isIndeterminate());
      setChecked(instance.isChecked());
      setWidgetClass(instance.getWidgetClass());
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (ICheckbox.Builder) this;
    }

    /**
     * Adds one element to {@link ICheckbox#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (ICheckbox.Builder) this;
    }

    /**
     * Adds elements to {@link ICheckbox#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (ICheckbox.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link ICheckbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (ICheckbox.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link ICheckbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (ICheckbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ICheckbox#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (ICheckbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ICheckbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (ICheckbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ICheckbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (ICheckbox.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ICheckbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (ICheckbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ICheckbox#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (ICheckbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ICheckbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (ICheckbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ICheckbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (ICheckbox.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ICheckbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (ICheckbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ICheckbox#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (ICheckbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ICheckbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (ICheckbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ICheckbox#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (ICheckbox.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ICheckbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setTop(@Nullable String top) {
      this.top = top;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setContext(@Nullable String context) {
      this.context = context;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getLabel() label} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#getLabel() label}.</em>
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setLabel(String label) {
      this.label = Objects.requireNonNull(label, "label");
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getIconSclass() iconSclass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#getIconSclass() iconSclass}.</em>
     * @param iconSclass The value for iconSclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setIconSclass(@Nullable String iconSclass) {
      this.iconSclass = iconSclass;
      optBits |= OPT_BIT_ICON_SCLASS;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getIconSclasses() iconSclasses} attribute.
     * <p><em>If not set, this attribute will have a default value as defined by {@link ICheckbox#getIconSclasses() iconSclasses}.</em>
     * @param iconSclasses The elements for iconSclasses
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setIconSclasses(String... iconSclasses) {
      this.iconSclasses = iconSclasses;
      optBits |= OPT_BIT_ICON_SCLASSES;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getIconTooltip() iconTooltip} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#getIconTooltip() iconTooltip}.</em>
     * @param iconTooltip The value for iconTooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setIconTooltip(@Nullable String iconTooltip) {
      this.iconTooltip = iconTooltip;
      optBits |= OPT_BIT_ICON_TOOLTIP;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getIconTooltips() iconTooltips} attribute.
     * <p><em>If not set, this attribute will have a default value as defined by {@link ICheckbox#getIconTooltips() iconTooltips}.</em>
     * @param iconTooltips The elements for iconTooltips
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setIconTooltips(String... iconTooltips) {
      this.iconTooltips = iconTooltips;
      optBits |= OPT_BIT_ICON_TOOLTIPS;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getImage() image} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#getImage() image}.</em>
     * @param image The value for image (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setImage(@Nullable String image) {
      this.image = image;
      optBits |= OPT_BIT_IMAGE;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getHoverImage() hoverImage} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#getHoverImage() hoverImage}.</em>
     * @param hoverImage The value for hoverImage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setHoverImage(@Nullable String hoverImage) {
      this.hoverImage = hoverImage;
      optBits |= OPT_BIT_HOVER_IMAGE;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#isPreloadImage() preloadImage} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#isPreloadImage() preloadImage}.</em>
     * @param preloadImage The value for preloadImage 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setPreloadImage(boolean preloadImage) {
      this.preloadImage = preloadImage;
      optBits |= OPT_BIT_PRELOAD_IMAGE;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setValue(@Nullable Object value) {
      this.value = value;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getAutodisable() autodisable} attribute.
     * @param autodisable The value for autodisable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setAutodisable(@Nullable String autodisable) {
      this.autodisable = autodisable;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setName(@Nullable String name) {
      this.name = name;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#isDisabled() disabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#isDisabled() disabled}.</em>
     * @param disabled The value for disabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setDisabled(boolean disabled) {
      this.disabled = disabled;
      optBits |= OPT_BIT_DISABLED;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#isIndeterminate() indeterminate} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#isIndeterminate() indeterminate}.</em>
     * @param indeterminate The value for indeterminate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setIndeterminate(boolean indeterminate) {
      this.indeterminate = indeterminate;
      optBits |= OPT_BIT_INDETERMINATE;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#isChecked() checked} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#isChecked() checked}.</em>
     * @param checked The value for checked 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setChecked(boolean checked) {
      this.checked = checked;
      optBits |= OPT_BIT_CHECKED;
      return (ICheckbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICheckbox#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICheckbox#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICheckbox.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (ICheckbox.Builder) this;
    }

    /**
     * Builds a new {@link ICheckbox ICheckbox}.
     * @return An immutable instance of ICheckbox
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ICheckbox build() {
      return ImmutableICheckbox.validate(new ImmutableICheckbox(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean iconSclassIsSet() {
      return (optBits & OPT_BIT_ICON_SCLASS) != 0;
    }

    private boolean iconSclassesIsSet() {
      return (optBits & OPT_BIT_ICON_SCLASSES) != 0;
    }

    private boolean iconTooltipIsSet() {
      return (optBits & OPT_BIT_ICON_TOOLTIP) != 0;
    }

    private boolean iconTooltipsIsSet() {
      return (optBits & OPT_BIT_ICON_TOOLTIPS) != 0;
    }

    private boolean imageIsSet() {
      return (optBits & OPT_BIT_IMAGE) != 0;
    }

    private boolean hoverImageIsSet() {
      return (optBits & OPT_BIT_HOVER_IMAGE) != 0;
    }

    private boolean preloadImageIsSet() {
      return (optBits & OPT_BIT_PRELOAD_IMAGE) != 0;
    }

    private boolean disabledIsSet() {
      return (optBits & OPT_BIT_DISABLED) != 0;
    }

    private boolean indeterminateIsSet() {
      return (optBits & OPT_BIT_INDETERMINATE) != 0;
    }

    private boolean checkedIsSet() {
      return (optBits & OPT_BIT_CHECKED) != 0;
    }
  }
}
