package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zkmax.zul.Searchbox;

/**
 * Immutable implementation of {@link ISearchbox}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ISearchbox.Builder()}.
 */
@Generated(from = "ISearchbox", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableISearchbox implements ISearchbox {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final boolean disabled;
  private final String widgetClass;
  private final @Nullable String searchMessage;
  private final @Nullable String placeholder;
  private final boolean multiple;
  private final boolean open;
  private final boolean autoclose;
  private final @Nullable String searchText;
  private final ImmutableMap<String, Object> auxInfo;

  private ImmutableISearchbox(ImmutableISearchbox.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.searchMessage = builder.searchMessage;
    this.placeholder = builder.placeholder;
    this.searchText = builder.searchText;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.disabledIsSet()) {
      initShim.setDisabled(builder.disabled);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.multipleIsSet()) {
      initShim.setMultiple(builder.multiple);
    }
    if (builder.openIsSet()) {
      initShim.setOpen(builder.open);
    }
    if (builder.autocloseIsSet()) {
      initShim.setAutoclose(builder.autoclose);
    }
    if (builder.auxInfoIsSet()) {
      initShim.setAuxInfo(builder.auxInfo.build());
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.disabled = initShim.isDisabled();
    this.widgetClass = initShim.getWidgetClass();
    this.multiple = initShim.isMultiple();
    this.open = initShim.isOpen();
    this.autoclose = initShim.isAutoclose();
    this.auxInfo = initShim.getAuxInfo();
    this.initShim = null;
  }

  private ImmutableISearchbox(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      boolean disabled,
      String widgetClass,
      @Nullable String searchMessage,
      @Nullable String placeholder,
      boolean multiple,
      boolean open,
      boolean autoclose,
      @Nullable String searchText,
      ImmutableMap<String, Object> auxInfo) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.disabled = disabled;
    this.widgetClass = widgetClass;
    this.searchMessage = searchMessage;
    this.placeholder = placeholder;
    this.multiple = multiple;
    this.open = open;
    this.autoclose = autoclose;
    this.searchText = searchText;
    this.auxInfo = auxInfo;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ISearchbox", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte disabledBuildStage = STAGE_UNINITIALIZED;
    private boolean disabled;

    boolean isDisabled() {
      if (disabledBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disabledBuildStage == STAGE_UNINITIALIZED) {
        disabledBuildStage = STAGE_INITIALIZING;
        this.disabled = isDisabledInitialize();
        disabledBuildStage = STAGE_INITIALIZED;
      }
      return this.disabled;
    }

    void setDisabled(boolean disabled) {
      this.disabled = disabled;
      disabledBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte multipleBuildStage = STAGE_UNINITIALIZED;
    private boolean multiple;

    boolean isMultiple() {
      if (multipleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (multipleBuildStage == STAGE_UNINITIALIZED) {
        multipleBuildStage = STAGE_INITIALIZING;
        this.multiple = isMultipleInitialize();
        multipleBuildStage = STAGE_INITIALIZED;
      }
      return this.multiple;
    }

    void setMultiple(boolean multiple) {
      this.multiple = multiple;
      multipleBuildStage = STAGE_INITIALIZED;
    }

    private byte openBuildStage = STAGE_UNINITIALIZED;
    private boolean open;

    boolean isOpen() {
      if (openBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (openBuildStage == STAGE_UNINITIALIZED) {
        openBuildStage = STAGE_INITIALIZING;
        this.open = isOpenInitialize();
        openBuildStage = STAGE_INITIALIZED;
      }
      return this.open;
    }

    void setOpen(boolean open) {
      this.open = open;
      openBuildStage = STAGE_INITIALIZED;
    }

    private byte autocloseBuildStage = STAGE_UNINITIALIZED;
    private boolean autoclose;

    boolean isAutoclose() {
      if (autocloseBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (autocloseBuildStage == STAGE_UNINITIALIZED) {
        autocloseBuildStage = STAGE_INITIALIZING;
        this.autoclose = isAutocloseInitialize();
        autocloseBuildStage = STAGE_INITIALIZED;
      }
      return this.autoclose;
    }

    void setAutoclose(boolean autoclose) {
      this.autoclose = autoclose;
      autocloseBuildStage = STAGE_INITIALIZED;
    }

    private byte auxInfoBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMap<String, Object> auxInfo;

    ImmutableMap<String, Object> getAuxInfo() {
      if (auxInfoBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (auxInfoBuildStage == STAGE_UNINITIALIZED) {
        auxInfoBuildStage = STAGE_INITIALIZING;
        this.auxInfo = ImmutableMap.copyOf(getAuxInfoInitialize());
        auxInfoBuildStage = STAGE_INITIALIZED;
      }
      return this.auxInfo;
    }

    void setAuxInfo(ImmutableMap<String, Object> auxInfo) {
      this.auxInfo = auxInfo;
      auxInfoBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (disabledBuildStage == STAGE_INITIALIZING) attributes.add("disabled");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (multipleBuildStage == STAGE_INITIALIZING) attributes.add("multiple");
      if (openBuildStage == STAGE_INITIALIZING) attributes.add("open");
      if (autocloseBuildStage == STAGE_INITIALIZING) attributes.add("autoclose");
      if (auxInfoBuildStage == STAGE_INITIALIZING) attributes.add("auxInfo");
      return "Cannot build ISearchbox, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return ISearchbox.super.getId();
  }

  private boolean isVisibleInitialize() {
    return ISearchbox.super.isVisible();
  }

  private String getMoldInitialize() {
    return ISearchbox.super.getMold();
  }

  private int getZIndexInitialize() {
    return ISearchbox.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return ISearchbox.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return ISearchbox.super.isFocus();
  }

  private String getDroppableInitialize() {
    return ISearchbox.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return ISearchbox.super.getRenderdefer();
  }

  private boolean isDisabledInitialize() {
    return ISearchbox.super.isDisabled();
  }

  private String getWidgetClassInitialize() {
    return ISearchbox.super.getWidgetClass();
  }

  private boolean isMultipleInitialize() {
    return ISearchbox.super.isMultiple();
  }

  private boolean isOpenInitialize() {
    return ISearchbox.super.isOpen();
  }

  private boolean isAutocloseInitialize() {
    return ISearchbox.super.isAutoclose();
  }

  private Map<String, Object> getAuxInfoInitialize() {
    return ISearchbox.super.getAuxInfo();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code disabled} attribute
   */
  @Override
  public boolean isDisabled() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDisabled()
        : this.disabled;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code searchMessage} attribute
   */
  @Override
  public @Nullable String getSearchMessage() {
    return searchMessage;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @Override
  public @Nullable String getPlaceholder() {
    return placeholder;
  }

  /**
   * @return The value of the {@code multiple} attribute
   */
  @Override
  public boolean isMultiple() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMultiple()
        : this.multiple;
  }

  /**
   * @return The value of the {@code open} attribute
   */
  @Override
  public boolean isOpen() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isOpen()
        : this.open;
  }

  /**
   * @return The value of the {@code autoclose} attribute
   */
  @Override
  public boolean isAutoclose() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isAutoclose()
        : this.autoclose;
  }

  /**
   * @return The value of the {@code searchText} attribute
   */
  @Override
  public @Nullable String getSearchText() {
    return searchText;
  }

  /**
   * @return The value of the {@code auxInfo} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableMap<String, Object> getAuxInfo() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAuxInfo()
        : this.auxInfo;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableISearchbox(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ISearchbox#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISearchbox withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableISearchbox(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.disabled,
          this.widgetClass,
          this.searchMessage,
          this.placeholder,
          this.multiple,
          this.open,
          this.autoclose,
          this.searchText,
          this.auxInfo));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ISearchbox#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISearchbox withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISearchbox#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISearchbox withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISearchbox#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISearchbox withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISearchbox#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISearchbox withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#isDisabled() disabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withDisabled(boolean value) {
    if (this.disabled == value) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        newValue,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getSearchMessage() searchMessage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for searchMessage (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withSearchMessage(@Nullable String value) {
    if (Objects.equals(this.searchMessage, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        value,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getPlaceholder() placeholder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for placeholder (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withPlaceholder(@Nullable String value) {
    if (Objects.equals(this.placeholder, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        value,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#isMultiple() multiple} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for multiple
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withMultiple(boolean value) {
    if (this.multiple == value) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        value,
        this.open,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#isOpen() open} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for open
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withOpen(boolean value) {
    if (this.open == value) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        value,
        this.autoclose,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#isAutoclose() autoclose} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autoclose
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withAutoclose(boolean value) {
    if (this.autoclose == value) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        value,
        this.searchText,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISearchbox#getSearchText() searchText} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for searchText (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISearchbox withSearchText(@Nullable String value) {
    if (Objects.equals(this.searchText, value)) return this;
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        value,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISearchbox#getAuxInfo() auxInfo} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the auxInfo map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISearchbox withAuxInfo(Map<String, ? extends Object> entries) {
    if (this.auxInfo == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new ImmutableISearchbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.searchMessage,
        this.placeholder,
        this.multiple,
        this.open,
        this.autoclose,
        this.searchText,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableISearchbox} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableISearchbox
        && equalTo((ImmutableISearchbox) another);
  }

  private boolean equalTo(ImmutableISearchbox another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && disabled == another.disabled
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(searchMessage, another.searchMessage)
        && Objects.equals(placeholder, another.placeholder)
        && multiple == another.multiple
        && open == another.open
        && autoclose == another.autoclose
        && Objects.equals(searchText, another.searchText)
        && auxInfo.equals(another.auxInfo);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code disabled}, {@code widgetClass}, {@code searchMessage}, {@code placeholder}, {@code multiple}, {@code open}, {@code autoclose}, {@code searchText}, {@code auxInfo}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Booleans.hashCode(disabled);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(searchMessage);
    h += (h << 5) + Objects.hashCode(placeholder);
    h += (h << 5) + Booleans.hashCode(multiple);
    h += (h << 5) + Booleans.hashCode(open);
    h += (h << 5) + Booleans.hashCode(autoclose);
    h += (h << 5) + Objects.hashCode(searchText);
    h += (h << 5) + auxInfo.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ISearchbox} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ISearchbox")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("disabled", disabled)
        .add("widgetClass", widgetClass)
        .add("searchMessage", searchMessage)
        .add("placeholder", placeholder)
        .add("multiple", multiple)
        .add("open", open)
        .add("autoclose", autoclose)
        .add("searchText", searchText)
        .add("auxInfo", auxInfo)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Searchbox> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ISearchbox#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Searchbox> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(ISearchbox.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableISearchbox validate(ImmutableISearchbox instance) {
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableISearchbox) instance.checkDroppable();
    instance = (ImmutableISearchbox) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ISearchbox} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ISearchbox instance
   */
  public static ISearchbox copyOf(ISearchbox instance) {
    if (instance instanceof ImmutableISearchbox) {
      return (ImmutableISearchbox) instance;
    }
    return new ISearchbox.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ISearchbox ISearchbox}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ISearchbox", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_DISABLED = 0x10L;
    private static final long OPT_BIT_MULTIPLE = 0x20L;
    private static final long OPT_BIT_OPEN = 0x40L;
    private static final long OPT_BIT_AUTOCLOSE = 0x80L;
    private static final long OPT_BIT_AUX_INFO = 0x100L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private boolean disabled;
    private @Nullable String widgetClass;
    private @Nullable String searchMessage;
    private @Nullable String placeholder;
    private boolean multiple;
    private boolean open;
    private boolean autoclose;
    private @Nullable String searchText;
    private ImmutableMap.Builder<String, Object> auxInfo = ImmutableMap.builder();

    /**
     * Creates a builder for {@link ISearchbox ISearchbox} instances.
     * <pre>
     * new ISearchbox.Builder()
     *    .setId(String) // optional {@link ISearchbox#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link ISearchbox#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link ISearchbox#getActions() actions}
     *    .setVisible(boolean) // optional {@link ISearchbox#isVisible() visible}
     *    .setMold(String) // optional {@link ISearchbox#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link ISearchbox#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ISearchbox#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ISearchbox#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ISearchbox#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link ISearchbox#getLeft() left}
     *    .setTop(String | null) // nullable {@link ISearchbox#getTop() top}
     *    .setZIndex(int) // optional {@link ISearchbox#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link ISearchbox#getHeight() height}
     *    .setWidth(String | null) // nullable {@link ISearchbox#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link ISearchbox#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link ISearchbox#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link ISearchbox#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link ISearchbox#getStyle() style}
     *    .setDraggable(String) // optional {@link ISearchbox#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link ISearchbox#isFocus() focus}
     *    .setDroppable(String) // optional {@link ISearchbox#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link ISearchbox#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link ISearchbox#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link ISearchbox#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link ISearchbox#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link ISearchbox#getTabindex() tabindex}
     *    .setDisabled(boolean) // optional {@link ISearchbox#isDisabled() disabled}
     *    .setWidgetClass(String) // optional {@link ISearchbox#getWidgetClass() widgetClass}
     *    .setSearchMessage(String | null) // nullable {@link ISearchbox#getSearchMessage() searchMessage}
     *    .setPlaceholder(String | null) // nullable {@link ISearchbox#getPlaceholder() placeholder}
     *    .setMultiple(boolean) // optional {@link ISearchbox#isMultiple() multiple}
     *    .setOpen(boolean) // optional {@link ISearchbox#isOpen() open}
     *    .setAutoclose(boolean) // optional {@link ISearchbox#isAutoclose() autoclose}
     *    .setSearchText(String | null) // nullable {@link ISearchbox#getSearchText() searchText}
     *    .putAuxInfo|putAllAuxInfo(String =&gt; Object) // {@link ISearchbox#getAuxInfo() auxInfo} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ISearchbox.Builder)) {
        throw new UnsupportedOperationException("Use: new ISearchbox.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ISearchbox} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder from(ISearchbox instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      setDisabled(instance.isDisabled());
      setWidgetClass(instance.getWidgetClass());
      @Nullable String searchMessageValue = instance.getSearchMessage();
      if (searchMessageValue != null) {
        setSearchMessage(searchMessageValue);
      }
      @Nullable String placeholderValue = instance.getPlaceholder();
      if (placeholderValue != null) {
        setPlaceholder(placeholderValue);
      }
      setMultiple(instance.isMultiple());
      setOpen(instance.isOpen());
      setAutoclose(instance.isAutoclose());
      @Nullable String searchTextValue = instance.getSearchText();
      if (searchTextValue != null) {
        setSearchText(searchTextValue);
      }
      putAllAuxInfo(instance.getAuxInfo());
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISearchbox#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (ISearchbox.Builder) this;
    }

    /**
     * Adds one element to {@link ISearchbox#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (ISearchbox.Builder) this;
    }

    /**
     * Adds elements to {@link ISearchbox#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (ISearchbox.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link ISearchbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (ISearchbox.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link ISearchbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISearchbox#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISearchbox#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (ISearchbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISearchbox#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (ISearchbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISearchbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (ISearchbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISearchbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (ISearchbox.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISearchbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (ISearchbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISearchbox#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (ISearchbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISearchbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (ISearchbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISearchbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (ISearchbox.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISearchbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (ISearchbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISearchbox#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (ISearchbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISearchbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (ISearchbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISearchbox#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (ISearchbox.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISearchbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setTop(@Nullable String top) {
      this.top = top;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISearchbox#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISearchbox#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISearchbox#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISearchbox#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISearchbox#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#isDisabled() disabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISearchbox#isDisabled() disabled}.</em>
     * @param disabled The value for disabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setDisabled(boolean disabled) {
      this.disabled = disabled;
      optBits |= OPT_BIT_DISABLED;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISearchbox#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getSearchMessage() searchMessage} attribute.
     * @param searchMessage The value for searchMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setSearchMessage(@Nullable String searchMessage) {
      this.searchMessage = searchMessage;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getPlaceholder() placeholder} attribute.
     * @param placeholder The value for placeholder (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setPlaceholder(@Nullable String placeholder) {
      this.placeholder = placeholder;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#isMultiple() multiple} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISearchbox#isMultiple() multiple}.</em>
     * @param multiple The value for multiple 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setMultiple(boolean multiple) {
      this.multiple = multiple;
      optBits |= OPT_BIT_MULTIPLE;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#isOpen() open} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISearchbox#isOpen() open}.</em>
     * @param open The value for open 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setOpen(boolean open) {
      this.open = open;
      optBits |= OPT_BIT_OPEN;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#isAutoclose() autoclose} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISearchbox#isAutoclose() autoclose}.</em>
     * @param autoclose The value for autoclose 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setAutoclose(boolean autoclose) {
      this.autoclose = autoclose;
      optBits |= OPT_BIT_AUTOCLOSE;
      return (ISearchbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISearchbox#getSearchText() searchText} attribute.
     * @param searchText The value for searchText (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setSearchText(@Nullable String searchText) {
      this.searchText = searchText;
      return (ISearchbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISearchbox#getAuxInfo() auxInfo} map.
     * @param key The key in the auxInfo map
     * @param value The associated value in the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder putAuxInfo(String key, Object value) {
      this.auxInfo.put(key, value);
      optBits |= OPT_BIT_AUX_INFO;
      return (ISearchbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISearchbox#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder putAuxInfo(Map.Entry<String, ? extends Object> entry) {
      this.auxInfo.put(entry);
      optBits |= OPT_BIT_AUX_INFO;
      return (ISearchbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISearchbox#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder setAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo = ImmutableMap.builder();
      optBits |= OPT_BIT_AUX_INFO;
      return putAllAuxInfo(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISearchbox#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISearchbox.Builder putAllAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo.putAll(entries);
      optBits |= OPT_BIT_AUX_INFO;
      return (ISearchbox.Builder) this;
    }

    /**
     * Builds a new {@link ISearchbox ISearchbox}.
     * @return An immutable instance of ISearchbox
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ISearchbox build() {
      return ImmutableISearchbox.validate(new ImmutableISearchbox(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean disabledIsSet() {
      return (optBits & OPT_BIT_DISABLED) != 0;
    }

    private boolean multipleIsSet() {
      return (optBits & OPT_BIT_MULTIPLE) != 0;
    }

    private boolean openIsSet() {
      return (optBits & OPT_BIT_OPEN) != 0;
    }

    private boolean autocloseIsSet() {
      return (optBits & OPT_BIT_AUTOCLOSE) != 0;
    }

    private boolean auxInfoIsSet() {
      return (optBits & OPT_BIT_AUX_INFO) != 0;
    }
  }
}
