package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Paging;

/**
 * Immutable implementation of {@link IPaging}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IPaging.Builder()}.
 */
@Generated(from = "IPaging", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIPaging implements IPaging {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final boolean disabled;
  private final String widgetClass;
  private final int pageSize;
  private final int totalSize;
  private final int pageCount;
  private final boolean detailed;
  private final boolean autohide;
  private final int activePage;
  private final int pageIncrement;

  private ImmutableIPaging(ImmutableIPaging.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.disabledIsSet()) {
      initShim.setDisabled(builder.disabled);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.pageSizeIsSet()) {
      initShim.setPageSize(builder.pageSize);
    }
    if (builder.totalSizeIsSet()) {
      initShim.setTotalSize(builder.totalSize);
    }
    if (builder.pageCountIsSet()) {
      initShim.setPageCount(builder.pageCount);
    }
    if (builder.detailedIsSet()) {
      initShim.setDetailed(builder.detailed);
    }
    if (builder.autohideIsSet()) {
      initShim.setAutohide(builder.autohide);
    }
    if (builder.activePageIsSet()) {
      initShim.setActivePage(builder.activePage);
    }
    if (builder.pageIncrementIsSet()) {
      initShim.setPageIncrement(builder.pageIncrement);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.disabled = initShim.isDisabled();
    this.widgetClass = initShim.getWidgetClass();
    this.pageSize = initShim.getPageSize();
    this.totalSize = initShim.getTotalSize();
    this.pageCount = initShim.getPageCount();
    this.detailed = initShim.isDetailed();
    this.autohide = initShim.isAutohide();
    this.activePage = initShim.getActivePage();
    this.pageIncrement = initShim.getPageIncrement();
    this.initShim = null;
  }

  private ImmutableIPaging(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      boolean disabled,
      String widgetClass,
      int pageSize,
      int totalSize,
      int pageCount,
      boolean detailed,
      boolean autohide,
      int activePage,
      int pageIncrement) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.disabled = disabled;
    this.widgetClass = widgetClass;
    this.pageSize = pageSize;
    this.totalSize = totalSize;
    this.pageCount = pageCount;
    this.detailed = detailed;
    this.autohide = autohide;
    this.activePage = activePage;
    this.pageIncrement = pageIncrement;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IPaging", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte disabledBuildStage = STAGE_UNINITIALIZED;
    private boolean disabled;

    boolean isDisabled() {
      if (disabledBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disabledBuildStage == STAGE_UNINITIALIZED) {
        disabledBuildStage = STAGE_INITIALIZING;
        this.disabled = isDisabledInitialize();
        disabledBuildStage = STAGE_INITIALIZED;
      }
      return this.disabled;
    }

    void setDisabled(boolean disabled) {
      this.disabled = disabled;
      disabledBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte pageSizeBuildStage = STAGE_UNINITIALIZED;
    private int pageSize;

    int getPageSize() {
      if (pageSizeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pageSizeBuildStage == STAGE_UNINITIALIZED) {
        pageSizeBuildStage = STAGE_INITIALIZING;
        this.pageSize = getPageSizeInitialize();
        pageSizeBuildStage = STAGE_INITIALIZED;
      }
      return this.pageSize;
    }

    void setPageSize(int pageSize) {
      this.pageSize = pageSize;
      pageSizeBuildStage = STAGE_INITIALIZED;
    }

    private byte totalSizeBuildStage = STAGE_UNINITIALIZED;
    private int totalSize;

    int getTotalSize() {
      if (totalSizeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (totalSizeBuildStage == STAGE_UNINITIALIZED) {
        totalSizeBuildStage = STAGE_INITIALIZING;
        this.totalSize = getTotalSizeInitialize();
        totalSizeBuildStage = STAGE_INITIALIZED;
      }
      return this.totalSize;
    }

    void setTotalSize(int totalSize) {
      this.totalSize = totalSize;
      totalSizeBuildStage = STAGE_INITIALIZED;
    }

    private byte pageCountBuildStage = STAGE_UNINITIALIZED;
    private int pageCount;

    int getPageCount() {
      if (pageCountBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pageCountBuildStage == STAGE_UNINITIALIZED) {
        pageCountBuildStage = STAGE_INITIALIZING;
        this.pageCount = getPageCountInitialize();
        pageCountBuildStage = STAGE_INITIALIZED;
      }
      return this.pageCount;
    }

    void setPageCount(int pageCount) {
      this.pageCount = pageCount;
      pageCountBuildStage = STAGE_INITIALIZED;
    }

    private byte detailedBuildStage = STAGE_UNINITIALIZED;
    private boolean detailed;

    boolean isDetailed() {
      if (detailedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (detailedBuildStage == STAGE_UNINITIALIZED) {
        detailedBuildStage = STAGE_INITIALIZING;
        this.detailed = isDetailedInitialize();
        detailedBuildStage = STAGE_INITIALIZED;
      }
      return this.detailed;
    }

    void setDetailed(boolean detailed) {
      this.detailed = detailed;
      detailedBuildStage = STAGE_INITIALIZED;
    }

    private byte autohideBuildStage = STAGE_UNINITIALIZED;
    private boolean autohide;

    boolean isAutohide() {
      if (autohideBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (autohideBuildStage == STAGE_UNINITIALIZED) {
        autohideBuildStage = STAGE_INITIALIZING;
        this.autohide = isAutohideInitialize();
        autohideBuildStage = STAGE_INITIALIZED;
      }
      return this.autohide;
    }

    void setAutohide(boolean autohide) {
      this.autohide = autohide;
      autohideBuildStage = STAGE_INITIALIZED;
    }

    private byte activePageBuildStage = STAGE_UNINITIALIZED;
    private int activePage;

    int getActivePage() {
      if (activePageBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (activePageBuildStage == STAGE_UNINITIALIZED) {
        activePageBuildStage = STAGE_INITIALIZING;
        this.activePage = getActivePageInitialize();
        activePageBuildStage = STAGE_INITIALIZED;
      }
      return this.activePage;
    }

    void setActivePage(int activePage) {
      this.activePage = activePage;
      activePageBuildStage = STAGE_INITIALIZED;
    }

    private byte pageIncrementBuildStage = STAGE_UNINITIALIZED;
    private int pageIncrement;

    int getPageIncrement() {
      if (pageIncrementBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pageIncrementBuildStage == STAGE_UNINITIALIZED) {
        pageIncrementBuildStage = STAGE_INITIALIZING;
        this.pageIncrement = getPageIncrementInitialize();
        pageIncrementBuildStage = STAGE_INITIALIZED;
      }
      return this.pageIncrement;
    }

    void setPageIncrement(int pageIncrement) {
      this.pageIncrement = pageIncrement;
      pageIncrementBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (disabledBuildStage == STAGE_INITIALIZING) attributes.add("disabled");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (pageSizeBuildStage == STAGE_INITIALIZING) attributes.add("pageSize");
      if (totalSizeBuildStage == STAGE_INITIALIZING) attributes.add("totalSize");
      if (pageCountBuildStage == STAGE_INITIALIZING) attributes.add("pageCount");
      if (detailedBuildStage == STAGE_INITIALIZING) attributes.add("detailed");
      if (autohideBuildStage == STAGE_INITIALIZING) attributes.add("autohide");
      if (activePageBuildStage == STAGE_INITIALIZING) attributes.add("activePage");
      if (pageIncrementBuildStage == STAGE_INITIALIZING) attributes.add("pageIncrement");
      return "Cannot build IPaging, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IPaging.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IPaging.super.isVisible();
  }

  private String getMoldInitialize() {
    return IPaging.super.getMold();
  }

  private int getZIndexInitialize() {
    return IPaging.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IPaging.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IPaging.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IPaging.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IPaging.super.getRenderdefer();
  }

  private boolean isDisabledInitialize() {
    return IPaging.super.isDisabled();
  }

  private String getWidgetClassInitialize() {
    return IPaging.super.getWidgetClass();
  }

  private int getPageSizeInitialize() {
    return IPaging.super.getPageSize();
  }

  private int getTotalSizeInitialize() {
    return IPaging.super.getTotalSize();
  }

  private int getPageCountInitialize() {
    return IPaging.super.getPageCount();
  }

  private boolean isDetailedInitialize() {
    return IPaging.super.isDetailed();
  }

  private boolean isAutohideInitialize() {
    return IPaging.super.isAutohide();
  }

  private int getActivePageInitialize() {
    return IPaging.super.getActivePage();
  }

  private int getPageIncrementInitialize() {
    return IPaging.super.getPageIncrement();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code disabled} attribute
   */
  @Override
  public boolean isDisabled() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDisabled()
        : this.disabled;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code pageSize} attribute
   */
  @Override
  public int getPageSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPageSize()
        : this.pageSize;
  }

  /**
   * @return The value of the {@code totalSize} attribute
   */
  @Override
  public int getTotalSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getTotalSize()
        : this.totalSize;
  }

  /**
   * @return The value of the {@code pageCount} attribute
   */
  @Override
  public int getPageCount() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPageCount()
        : this.pageCount;
  }

  /**
   * @return The value of the {@code detailed} attribute
   */
  @Override
  public boolean isDetailed() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDetailed()
        : this.detailed;
  }

  /**
   * @return The value of the {@code autohide} attribute
   */
  @Override
  public boolean isAutohide() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isAutohide()
        : this.autohide;
  }

  /**
   * @return The value of the {@code activePage} attribute
   */
  @Override
  public int getActivePage() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getActivePage()
        : this.activePage;
  }

  /**
   * @return The value of the {@code pageIncrement} attribute
   */
  @Override
  public int getPageIncrement() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPageIncrement()
        : this.pageIncrement;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIPaging(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IPaging#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPaging withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIPaging(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.disabled,
          this.widgetClass,
          this.pageSize,
          this.totalSize,
          this.pageCount,
          this.detailed,
          this.autohide,
          this.activePage,
          this.pageIncrement));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IPaging#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPaging withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by replacing the {@link IPaging#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPaging withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by replacing the {@link IPaging#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPaging withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by replacing the {@link IPaging#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPaging withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#isDisabled() disabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withDisabled(boolean value) {
    if (this.disabled == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        value,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        newValue,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getPageSize() pageSize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pageSize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withPageSize(int value) {
    if (this.pageSize == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        value,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getTotalSize() totalSize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalSize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withTotalSize(int value) {
    if (this.totalSize == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        value,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getPageCount() pageCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pageCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withPageCount(int value) {
    if (this.pageCount == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        value,
        this.detailed,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#isDetailed() detailed} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for detailed
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withDetailed(boolean value) {
    if (this.detailed == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        value,
        this.autohide,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#isAutohide() autohide} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autohide
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withAutohide(boolean value) {
    if (this.autohide == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        value,
        this.activePage,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getActivePage() activePage} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for activePage
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withActivePage(int value) {
    if (this.activePage == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        value,
        this.pageIncrement));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPaging#getPageIncrement() pageIncrement} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pageIncrement
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPaging withPageIncrement(int value) {
    if (this.pageIncrement == value) return this;
    return validate(new ImmutableIPaging(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.widgetClass,
        this.pageSize,
        this.totalSize,
        this.pageCount,
        this.detailed,
        this.autohide,
        this.activePage,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIPaging} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIPaging
        && equalTo((ImmutableIPaging) another);
  }

  private boolean equalTo(ImmutableIPaging another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && disabled == another.disabled
        && widgetClass.equals(another.widgetClass)
        && pageSize == another.pageSize
        && totalSize == another.totalSize
        && pageCount == another.pageCount
        && detailed == another.detailed
        && autohide == another.autohide
        && activePage == another.activePage
        && pageIncrement == another.pageIncrement;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code disabled}, {@code widgetClass}, {@code pageSize}, {@code totalSize}, {@code pageCount}, {@code detailed}, {@code autohide}, {@code activePage}, {@code pageIncrement}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + Booleans.hashCode(disabled);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + pageSize;
    h += (h << 5) + totalSize;
    h += (h << 5) + pageCount;
    h += (h << 5) + Booleans.hashCode(detailed);
    h += (h << 5) + Booleans.hashCode(autohide);
    h += (h << 5) + activePage;
    h += (h << 5) + pageIncrement;
    return h;
  }

  /**
   * Prints the immutable value {@code IPaging} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IPaging")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("disabled", disabled)
        .add("widgetClass", widgetClass)
        .add("pageSize", pageSize)
        .add("totalSize", totalSize)
        .add("pageCount", pageCount)
        .add("detailed", detailed)
        .add("autohide", autohide)
        .add("activePage", activePage)
        .add("pageIncrement", pageIncrement)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Paging> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IPaging#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Paging> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IPaging.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableIPaging validate(ImmutableIPaging instance) {
    instance.checkTotalSize();
    instance.checkPageSize();
    instance.checkPageIncrement();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIPaging) instance.checkDroppable();
    instance = (ImmutableIPaging) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IPaging} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IPaging instance
   */
  public static IPaging copyOf(IPaging instance) {
    if (instance instanceof ImmutableIPaging) {
      return (ImmutableIPaging) instance;
    }
    return new IPaging.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IPaging IPaging}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IPaging", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_DISABLED = 0x10L;
    private static final long OPT_BIT_PAGE_SIZE = 0x20L;
    private static final long OPT_BIT_TOTAL_SIZE = 0x40L;
    private static final long OPT_BIT_PAGE_COUNT = 0x80L;
    private static final long OPT_BIT_DETAILED = 0x100L;
    private static final long OPT_BIT_AUTOHIDE = 0x200L;
    private static final long OPT_BIT_ACTIVE_PAGE = 0x400L;
    private static final long OPT_BIT_PAGE_INCREMENT = 0x800L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private boolean disabled;
    private @Nullable String widgetClass;
    private int pageSize;
    private int totalSize;
    private int pageCount;
    private boolean detailed;
    private boolean autohide;
    private int activePage;
    private int pageIncrement;

    /**
     * Creates a builder for {@link IPaging IPaging} instances.
     * <pre>
     * new IPaging.Builder()
     *    .setId(String) // optional {@link IPaging#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IPaging#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IPaging#getActions() actions}
     *    .setVisible(boolean) // optional {@link IPaging#isVisible() visible}
     *    .setMold(String) // optional {@link IPaging#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IPaging#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IPaging#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IPaging#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IPaging#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IPaging#getLeft() left}
     *    .setTop(String | null) // nullable {@link IPaging#getTop() top}
     *    .setZIndex(int) // optional {@link IPaging#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IPaging#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IPaging#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IPaging#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IPaging#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IPaging#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IPaging#getStyle() style}
     *    .setDraggable(String) // optional {@link IPaging#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IPaging#isFocus() focus}
     *    .setDroppable(String) // optional {@link IPaging#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IPaging#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IPaging#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IPaging#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IPaging#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IPaging#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IPaging#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IPaging#getContext() context}
     *    .setPopup(String | null) // nullable {@link IPaging#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IPaging#getTooltip() tooltip}
     *    .setDisabled(boolean) // optional {@link IPaging#isDisabled() disabled}
     *    .setWidgetClass(String) // optional {@link IPaging#getWidgetClass() widgetClass}
     *    .setPageSize(int) // optional {@link IPaging#getPageSize() pageSize}
     *    .setTotalSize(int) // optional {@link IPaging#getTotalSize() totalSize}
     *    .setPageCount(int) // optional {@link IPaging#getPageCount() pageCount}
     *    .setDetailed(boolean) // optional {@link IPaging#isDetailed() detailed}
     *    .setAutohide(boolean) // optional {@link IPaging#isAutohide() autohide}
     *    .setActivePage(int) // optional {@link IPaging#getActivePage() activePage}
     *    .setPageIncrement(int) // optional {@link IPaging#getPageIncrement() pageIncrement}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IPaging.Builder)) {
        throw new UnsupportedOperationException("Use: new IPaging.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IPaging} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder from(IPaging instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setDisabled(instance.isDisabled());
      setWidgetClass(instance.getWidgetClass());
      setPageSize(instance.getPageSize());
      setTotalSize(instance.getTotalSize());
      setPageCount(instance.getPageCount());
      setDetailed(instance.isDetailed());
      setAutohide(instance.isAutohide());
      setActivePage(instance.getActivePage());
      setPageIncrement(instance.getPageIncrement());
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IPaging.Builder) this;
    }

    /**
     * Adds one element to {@link IPaging#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IPaging.Builder) this;
    }

    /**
     * Adds elements to {@link IPaging#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IPaging.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IPaging#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IPaging.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IPaging#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IPaging.Builder) this;
    }

    /**
     * Put one entry to the {@link IPaging#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IPaging.Builder) this;
    }

    /**
     * Put one entry to the {@link IPaging#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IPaging.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IPaging#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IPaging.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IPaging#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IPaging.Builder) this;
    }

    /**
     * Put one entry to the {@link IPaging#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IPaging.Builder) this;
    }

    /**
     * Put one entry to the {@link IPaging#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IPaging.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IPaging#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IPaging.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IPaging#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IPaging.Builder) this;
    }

    /**
     * Put one entry to the {@link IPaging#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IPaging.Builder) this;
    }

    /**
     * Put one entry to the {@link IPaging#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IPaging.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IPaging#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IPaging.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IPaging#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setTop(@Nullable String top) {
      this.top = top;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setContext(@Nullable String context) {
      this.context = context;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#isDisabled() disabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#isDisabled() disabled}.</em>
     * @param disabled The value for disabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setDisabled(boolean disabled) {
      this.disabled = disabled;
      optBits |= OPT_BIT_DISABLED;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getPageSize() pageSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#getPageSize() pageSize}.</em>
     * @param pageSize The value for pageSize 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setPageSize(int pageSize) {
      this.pageSize = pageSize;
      optBits |= OPT_BIT_PAGE_SIZE;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getTotalSize() totalSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#getTotalSize() totalSize}.</em>
     * @param totalSize The value for totalSize 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setTotalSize(int totalSize) {
      this.totalSize = totalSize;
      optBits |= OPT_BIT_TOTAL_SIZE;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getPageCount() pageCount} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#getPageCount() pageCount}.</em>
     * @param pageCount The value for pageCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setPageCount(int pageCount) {
      this.pageCount = pageCount;
      optBits |= OPT_BIT_PAGE_COUNT;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#isDetailed() detailed} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#isDetailed() detailed}.</em>
     * @param detailed The value for detailed 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setDetailed(boolean detailed) {
      this.detailed = detailed;
      optBits |= OPT_BIT_DETAILED;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#isAutohide() autohide} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#isAutohide() autohide}.</em>
     * @param autohide The value for autohide 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setAutohide(boolean autohide) {
      this.autohide = autohide;
      optBits |= OPT_BIT_AUTOHIDE;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getActivePage() activePage} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#getActivePage() activePage}.</em>
     * @param activePage The value for activePage 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setActivePage(int activePage) {
      this.activePage = activePage;
      optBits |= OPT_BIT_ACTIVE_PAGE;
      return (IPaging.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPaging#getPageIncrement() pageIncrement} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPaging#getPageIncrement() pageIncrement}.</em>
     * @param pageIncrement The value for pageIncrement 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPaging.Builder setPageIncrement(int pageIncrement) {
      this.pageIncrement = pageIncrement;
      optBits |= OPT_BIT_PAGE_INCREMENT;
      return (IPaging.Builder) this;
    }

    /**
     * Builds a new {@link IPaging IPaging}.
     * @return An immutable instance of IPaging
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IPaging build() {
      return ImmutableIPaging.validate(new ImmutableIPaging(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean disabledIsSet() {
      return (optBits & OPT_BIT_DISABLED) != 0;
    }

    private boolean pageSizeIsSet() {
      return (optBits & OPT_BIT_PAGE_SIZE) != 0;
    }

    private boolean totalSizeIsSet() {
      return (optBits & OPT_BIT_TOTAL_SIZE) != 0;
    }

    private boolean pageCountIsSet() {
      return (optBits & OPT_BIT_PAGE_COUNT) != 0;
    }

    private boolean detailedIsSet() {
      return (optBits & OPT_BIT_DETAILED) != 0;
    }

    private boolean autohideIsSet() {
      return (optBits & OPT_BIT_AUTOHIDE) != 0;
    }

    private boolean activePageIsSet() {
      return (optBits & OPT_BIT_ACTIVE_PAGE) != 0;
    }

    private boolean pageIncrementIsSet() {
      return (optBits & OPT_BIT_PAGE_INCREMENT) != 0;
    }
  }
}
