package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.image.Image;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zkmax.zul.Cropper;

/**
 * Immutable implementation of {@link ICropper}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ICropper.Builder()}.
 */
@Generated(from = "ICropper", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableICropper implements ICropper {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final String widgetClass;
  private final @Nullable String crossorigin;
  private final @Nullable Image content;
  private final double aspectRatio;
  private final int minWidth;
  private final int minHeight;
  private final int maxWidth;
  private final int maxHeight;
  private final int x;
  private final int y;
  private final int w;
  private final int h;
  private final boolean toolbarVisible;
  private final String croppedFormat;
  private final boolean instant;
  private final @Nullable String src;

  private ImmutableICropper(ImmutableICropper.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.crossorigin = builder.crossorigin;
    this.content = builder.content;
    this.src = builder.src;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.aspectRatioIsSet()) {
      initShim.setAspectRatio(builder.aspectRatio);
    }
    if (builder.minWidthIsSet()) {
      initShim.setMinWidth(builder.minWidth);
    }
    if (builder.minHeightIsSet()) {
      initShim.setMinHeight(builder.minHeight);
    }
    if (builder.maxWidthIsSet()) {
      initShim.setMaxWidth(builder.maxWidth);
    }
    if (builder.maxHeightIsSet()) {
      initShim.setMaxHeight(builder.maxHeight);
    }
    if (builder.xIsSet()) {
      initShim.setX(builder.x);
    }
    if (builder.yIsSet()) {
      initShim.setY(builder.y);
    }
    if (builder.wIsSet()) {
      initShim.setW(builder.w);
    }
    if (builder.hIsSet()) {
      initShim.setH(builder.h);
    }
    if (builder.toolbarVisibleIsSet()) {
      initShim.setToolbarVisible(builder.toolbarVisible);
    }
    if (builder.croppedFormat != null) {
      initShim.setCroppedFormat(builder.croppedFormat);
    }
    if (builder.instantIsSet()) {
      initShim.setInstant(builder.instant);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.widgetClass = initShim.getWidgetClass();
    this.aspectRatio = initShim.getAspectRatio();
    this.minWidth = initShim.getMinWidth();
    this.minHeight = initShim.getMinHeight();
    this.maxWidth = initShim.getMaxWidth();
    this.maxHeight = initShim.getMaxHeight();
    this.x = initShim.getX();
    this.y = initShim.getY();
    this.w = initShim.getW();
    this.h = initShim.getH();
    this.toolbarVisible = initShim.isToolbarVisible();
    this.croppedFormat = initShim.getCroppedFormat();
    this.instant = initShim.isInstant();
    this.initShim = null;
  }

  private ImmutableICropper(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      String widgetClass,
      @Nullable String crossorigin,
      @Nullable Image content,
      double aspectRatio,
      int minWidth,
      int minHeight,
      int maxWidth,
      int maxHeight,
      int x,
      int y,
      int w,
      int h,
      boolean toolbarVisible,
      String croppedFormat,
      boolean instant,
      @Nullable String src) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.widgetClass = widgetClass;
    this.crossorigin = crossorigin;
    this.content = content;
    this.aspectRatio = aspectRatio;
    this.minWidth = minWidth;
    this.minHeight = minHeight;
    this.maxWidth = maxWidth;
    this.maxHeight = maxHeight;
    this.x = x;
    this.y = y;
    this.w = w;
    this.h = h;
    this.toolbarVisible = toolbarVisible;
    this.croppedFormat = croppedFormat;
    this.instant = instant;
    this.src = src;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ICropper", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte aspectRatioBuildStage = STAGE_UNINITIALIZED;
    private double aspectRatio;

    double getAspectRatio() {
      if (aspectRatioBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (aspectRatioBuildStage == STAGE_UNINITIALIZED) {
        aspectRatioBuildStage = STAGE_INITIALIZING;
        this.aspectRatio = getAspectRatioInitialize();
        aspectRatioBuildStage = STAGE_INITIALIZED;
      }
      return this.aspectRatio;
    }

    void setAspectRatio(double aspectRatio) {
      this.aspectRatio = aspectRatio;
      aspectRatioBuildStage = STAGE_INITIALIZED;
    }

    private byte minWidthBuildStage = STAGE_UNINITIALIZED;
    private int minWidth;

    int getMinWidth() {
      if (minWidthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minWidthBuildStage == STAGE_UNINITIALIZED) {
        minWidthBuildStage = STAGE_INITIALIZING;
        this.minWidth = getMinWidthInitialize();
        minWidthBuildStage = STAGE_INITIALIZED;
      }
      return this.minWidth;
    }

    void setMinWidth(int minWidth) {
      this.minWidth = minWidth;
      minWidthBuildStage = STAGE_INITIALIZED;
    }

    private byte minHeightBuildStage = STAGE_UNINITIALIZED;
    private int minHeight;

    int getMinHeight() {
      if (minHeightBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minHeightBuildStage == STAGE_UNINITIALIZED) {
        minHeightBuildStage = STAGE_INITIALIZING;
        this.minHeight = getMinHeightInitialize();
        minHeightBuildStage = STAGE_INITIALIZED;
      }
      return this.minHeight;
    }

    void setMinHeight(int minHeight) {
      this.minHeight = minHeight;
      minHeightBuildStage = STAGE_INITIALIZED;
    }

    private byte maxWidthBuildStage = STAGE_UNINITIALIZED;
    private int maxWidth;

    int getMaxWidth() {
      if (maxWidthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxWidthBuildStage == STAGE_UNINITIALIZED) {
        maxWidthBuildStage = STAGE_INITIALIZING;
        this.maxWidth = getMaxWidthInitialize();
        maxWidthBuildStage = STAGE_INITIALIZED;
      }
      return this.maxWidth;
    }

    void setMaxWidth(int maxWidth) {
      this.maxWidth = maxWidth;
      maxWidthBuildStage = STAGE_INITIALIZED;
    }

    private byte maxHeightBuildStage = STAGE_UNINITIALIZED;
    private int maxHeight;

    int getMaxHeight() {
      if (maxHeightBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxHeightBuildStage == STAGE_UNINITIALIZED) {
        maxHeightBuildStage = STAGE_INITIALIZING;
        this.maxHeight = getMaxHeightInitialize();
        maxHeightBuildStage = STAGE_INITIALIZED;
      }
      return this.maxHeight;
    }

    void setMaxHeight(int maxHeight) {
      this.maxHeight = maxHeight;
      maxHeightBuildStage = STAGE_INITIALIZED;
    }

    private byte xBuildStage = STAGE_UNINITIALIZED;
    private int x;

    int getX() {
      if (xBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (xBuildStage == STAGE_UNINITIALIZED) {
        xBuildStage = STAGE_INITIALIZING;
        this.x = getXInitialize();
        xBuildStage = STAGE_INITIALIZED;
      }
      return this.x;
    }

    void setX(int x) {
      this.x = x;
      xBuildStage = STAGE_INITIALIZED;
    }

    private byte yBuildStage = STAGE_UNINITIALIZED;
    private int y;

    int getY() {
      if (yBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (yBuildStage == STAGE_UNINITIALIZED) {
        yBuildStage = STAGE_INITIALIZING;
        this.y = getYInitialize();
        yBuildStage = STAGE_INITIALIZED;
      }
      return this.y;
    }

    void setY(int y) {
      this.y = y;
      yBuildStage = STAGE_INITIALIZED;
    }

    private byte wBuildStage = STAGE_UNINITIALIZED;
    private int w;

    int getW() {
      if (wBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (wBuildStage == STAGE_UNINITIALIZED) {
        wBuildStage = STAGE_INITIALIZING;
        this.w = getWInitialize();
        wBuildStage = STAGE_INITIALIZED;
      }
      return this.w;
    }

    void setW(int w) {
      this.w = w;
      wBuildStage = STAGE_INITIALIZED;
    }

    private byte hBuildStage = STAGE_UNINITIALIZED;
    private int h;

    int getH() {
      if (hBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (hBuildStage == STAGE_UNINITIALIZED) {
        hBuildStage = STAGE_INITIALIZING;
        this.h = getHInitialize();
        hBuildStage = STAGE_INITIALIZED;
      }
      return this.h;
    }

    void setH(int h) {
      this.h = h;
      hBuildStage = STAGE_INITIALIZED;
    }

    private byte toolbarVisibleBuildStage = STAGE_UNINITIALIZED;
    private boolean toolbarVisible;

    boolean isToolbarVisible() {
      if (toolbarVisibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (toolbarVisibleBuildStage == STAGE_UNINITIALIZED) {
        toolbarVisibleBuildStage = STAGE_INITIALIZING;
        this.toolbarVisible = isToolbarVisibleInitialize();
        toolbarVisibleBuildStage = STAGE_INITIALIZED;
      }
      return this.toolbarVisible;
    }

    void setToolbarVisible(boolean toolbarVisible) {
      this.toolbarVisible = toolbarVisible;
      toolbarVisibleBuildStage = STAGE_INITIALIZED;
    }

    private byte croppedFormatBuildStage = STAGE_UNINITIALIZED;
    private String croppedFormat;

    String getCroppedFormat() {
      if (croppedFormatBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (croppedFormatBuildStage == STAGE_UNINITIALIZED) {
        croppedFormatBuildStage = STAGE_INITIALIZING;
        this.croppedFormat = Objects.requireNonNull(getCroppedFormatInitialize(), "croppedFormat");
        croppedFormatBuildStage = STAGE_INITIALIZED;
      }
      return this.croppedFormat;
    }

    void setCroppedFormat(String croppedFormat) {
      this.croppedFormat = croppedFormat;
      croppedFormatBuildStage = STAGE_INITIALIZED;
    }

    private byte instantBuildStage = STAGE_UNINITIALIZED;
    private boolean instant;

    boolean isInstant() {
      if (instantBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (instantBuildStage == STAGE_UNINITIALIZED) {
        instantBuildStage = STAGE_INITIALIZING;
        this.instant = isInstantInitialize();
        instantBuildStage = STAGE_INITIALIZED;
      }
      return this.instant;
    }

    void setInstant(boolean instant) {
      this.instant = instant;
      instantBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (aspectRatioBuildStage == STAGE_INITIALIZING) attributes.add("aspectRatio");
      if (minWidthBuildStage == STAGE_INITIALIZING) attributes.add("minWidth");
      if (minHeightBuildStage == STAGE_INITIALIZING) attributes.add("minHeight");
      if (maxWidthBuildStage == STAGE_INITIALIZING) attributes.add("maxWidth");
      if (maxHeightBuildStage == STAGE_INITIALIZING) attributes.add("maxHeight");
      if (xBuildStage == STAGE_INITIALIZING) attributes.add("x");
      if (yBuildStage == STAGE_INITIALIZING) attributes.add("y");
      if (wBuildStage == STAGE_INITIALIZING) attributes.add("w");
      if (hBuildStage == STAGE_INITIALIZING) attributes.add("h");
      if (toolbarVisibleBuildStage == STAGE_INITIALIZING) attributes.add("toolbarVisible");
      if (croppedFormatBuildStage == STAGE_INITIALIZING) attributes.add("croppedFormat");
      if (instantBuildStage == STAGE_INITIALIZING) attributes.add("instant");
      return "Cannot build ICropper, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return ICropper.super.getId();
  }

  private boolean isVisibleInitialize() {
    return ICropper.super.isVisible();
  }

  private String getMoldInitialize() {
    return ICropper.super.getMold();
  }

  private int getZIndexInitialize() {
    return ICropper.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return ICropper.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return ICropper.super.isFocus();
  }

  private String getDroppableInitialize() {
    return ICropper.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return ICropper.super.getRenderdefer();
  }

  private String getWidgetClassInitialize() {
    return ICropper.super.getWidgetClass();
  }

  private double getAspectRatioInitialize() {
    return ICropper.super.getAspectRatio();
  }

  private int getMinWidthInitialize() {
    return ICropper.super.getMinWidth();
  }

  private int getMinHeightInitialize() {
    return ICropper.super.getMinHeight();
  }

  private int getMaxWidthInitialize() {
    return ICropper.super.getMaxWidth();
  }

  private int getMaxHeightInitialize() {
    return ICropper.super.getMaxHeight();
  }

  private int getXInitialize() {
    return ICropper.super.getX();
  }

  private int getYInitialize() {
    return ICropper.super.getY();
  }

  private int getWInitialize() {
    return ICropper.super.getW();
  }

  private int getHInitialize() {
    return ICropper.super.getH();
  }

  private boolean isToolbarVisibleInitialize() {
    return ICropper.super.isToolbarVisible();
  }

  private String getCroppedFormatInitialize() {
    return ICropper.super.getCroppedFormat();
  }

  private boolean isInstantInitialize() {
    return ICropper.super.isInstant();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code crossorigin} attribute
   */
  @Override
  public @Nullable String getCrossorigin() {
    return crossorigin;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public @Nullable Image getContent() {
    return content;
  }

  /**
   * @return The value of the {@code aspectRatio} attribute
   */
  @Override
  public double getAspectRatio() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAspectRatio()
        : this.aspectRatio;
  }

  /**
   * @return The value of the {@code minWidth} attribute
   */
  @Override
  public int getMinWidth() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMinWidth()
        : this.minWidth;
  }

  /**
   * @return The value of the {@code minHeight} attribute
   */
  @Override
  public int getMinHeight() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMinHeight()
        : this.minHeight;
  }

  /**
   * @return The value of the {@code maxWidth} attribute
   */
  @Override
  public int getMaxWidth() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMaxWidth()
        : this.maxWidth;
  }

  /**
   * @return The value of the {@code maxHeight} attribute
   */
  @Override
  public int getMaxHeight() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMaxHeight()
        : this.maxHeight;
  }

  /**
   * @return The value of the {@code x} attribute
   */
  @Override
  public int getX() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getX()
        : this.x;
  }

  /**
   * @return The value of the {@code y} attribute
   */
  @Override
  public int getY() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getY()
        : this.y;
  }

  /**
   * @return The value of the {@code w} attribute
   */
  @Override
  public int getW() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getW()
        : this.w;
  }

  /**
   * @return The value of the {@code h} attribute
   */
  @Override
  public int getH() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getH()
        : this.h;
  }

  /**
   * @return The value of the {@code toolbarVisible} attribute
   */
  @Override
  public boolean isToolbarVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isToolbarVisible()
        : this.toolbarVisible;
  }

  /**
   * @return The value of the {@code croppedFormat} attribute
   */
  @Override
  public String getCroppedFormat() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCroppedFormat()
        : this.croppedFormat;
  }

  /**
   * @return The value of the {@code instant} attribute
   */
  @Override
  public boolean isInstant() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isInstant()
        : this.instant;
  }

  /**
   * @return The value of the {@code src} attribute
   */
  @Override
  public @Nullable String getSrc() {
    return src;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableICropper(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ICropper#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICropper withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableICropper(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.widgetClass,
          this.crossorigin,
          this.content,
          this.aspectRatio,
          this.minWidth,
          this.minHeight,
          this.maxWidth,
          this.maxHeight,
          this.x,
          this.y,
          this.w,
          this.h,
          this.toolbarVisible,
          this.croppedFormat,
          this.instant,
          this.src));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ICropper#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICropper withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by replacing the {@link ICropper#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICropper withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by replacing the {@link ICropper#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICropper withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by replacing the {@link ICropper#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableICropper withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        newValue,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getCrossorigin() crossorigin} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for crossorigin (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withCrossorigin(@Nullable String value) {
    if (Objects.equals(this.crossorigin, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        value,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getContent() content} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withContent(@Nullable Image value) {
    if (this.content == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        value,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getAspectRatio() aspectRatio} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for aspectRatio
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withAspectRatio(double value) {
    if (Double.doubleToLongBits(this.aspectRatio) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        value,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getMinWidth() minWidth} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minWidth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withMinWidth(int value) {
    if (this.minWidth == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        value,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getMinHeight() minHeight} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minHeight
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withMinHeight(int value) {
    if (this.minHeight == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        value,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getMaxWidth() maxWidth} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxWidth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withMaxWidth(int value) {
    if (this.maxWidth == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        value,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getMaxHeight() maxHeight} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxHeight
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withMaxHeight(int value) {
    if (this.maxHeight == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        value,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getX() x} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for x
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withX(int value) {
    if (this.x == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        value,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getY() y} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for y
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withY(int value) {
    if (this.y == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        value,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getW() w} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for w
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withW(int value) {
    if (this.w == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        value,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getH() h} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for h
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withH(int value) {
    if (this.h == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        value,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#isToolbarVisible() toolbarVisible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toolbarVisible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withToolbarVisible(boolean value) {
    if (this.toolbarVisible == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        value,
        this.croppedFormat,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getCroppedFormat() croppedFormat} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for croppedFormat
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withCroppedFormat(String value) {
    String newValue = Objects.requireNonNull(value, "croppedFormat");
    if (this.croppedFormat.equals(newValue)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        newValue,
        this.instant,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#isInstant() instant} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for instant
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withInstant(boolean value) {
    if (this.instant == value) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        value,
        this.src));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ICropper#getSrc() src} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for src (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableICropper withSrc(@Nullable String value) {
    if (Objects.equals(this.src, value)) return this;
    return validate(new ImmutableICropper(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.widgetClass,
        this.crossorigin,
        this.content,
        this.aspectRatio,
        this.minWidth,
        this.minHeight,
        this.maxWidth,
        this.maxHeight,
        this.x,
        this.y,
        this.w,
        this.h,
        this.toolbarVisible,
        this.croppedFormat,
        this.instant,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableICropper} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableICropper
        && equalTo((ImmutableICropper) another);
  }

  private boolean equalTo(ImmutableICropper another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(crossorigin, another.crossorigin)
        && Objects.equals(content, another.content)
        && Double.doubleToLongBits(aspectRatio) == Double.doubleToLongBits(another.aspectRatio)
        && minWidth == another.minWidth
        && minHeight == another.minHeight
        && maxWidth == another.maxWidth
        && maxHeight == another.maxHeight
        && x == another.x
        && y == another.y
        && w == another.w
        && h == another.h
        && toolbarVisible == another.toolbarVisible
        && croppedFormat.equals(another.croppedFormat)
        && instant == another.instant
        && Objects.equals(src, another.src);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code widgetClass}, {@code crossorigin}, {@code content}, {@code aspectRatio}, {@code minWidth}, {@code minHeight}, {@code maxWidth}, {@code maxHeight}, {@code x}, {@code y}, {@code w}, {@code h}, {@code toolbarVisible}, {@code croppedFormat}, {@code instant}, {@code src}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h$$ = 5381;
    h$$ += (h$$ << 5) + id.hashCode();
    h$$ += (h$$ << 5) + Objects.hashCode(action);
    h$$ += (h$$ << 5) + Objects.hashCode(actions);
    h$$ += (h$$ << 5) + Booleans.hashCode(visible);
    h$$ += (h$$ << 5) + mold.hashCode();
    h$$ += (h$$ << 5) + Objects.hashCode(eventListenerMap);
    h$$ += (h$$ << 5) + Objects.hashCode(widgetListeners);
    h$$ += (h$$ << 5) + Objects.hashCode(widgetOverrides);
    h$$ += (h$$ << 5) + Objects.hashCode(clientAttributes);
    h$$ += (h$$ << 5) + Objects.hashCode(left);
    h$$ += (h$$ << 5) + Objects.hashCode(top);
    h$$ += (h$$ << 5) + zIndex;
    h$$ += (h$$ << 5) + Objects.hashCode(height);
    h$$ += (h$$ << 5) + Objects.hashCode(width);
    h$$ += (h$$ << 5) + Objects.hashCode(tooltiptext);
    h$$ += (h$$ << 5) + Objects.hashCode(zclass);
    h$$ += (h$$ << 5) + Objects.hashCode(sclass);
    h$$ += (h$$ << 5) + Objects.hashCode(style);
    h$$ += (h$$ << 5) + draggable.hashCode();
    h$$ += (h$$ << 5) + Booleans.hashCode(focus);
    h$$ += (h$$ << 5) + droppable.hashCode();
    h$$ += (h$$ << 5) + Objects.hashCode(vflex);
    h$$ += (h$$ << 5) + Objects.hashCode(hflex);
    h$$ += (h$$ << 5) + renderdefer;
    h$$ += (h$$ << 5) + Objects.hashCode(clientAction);
    h$$ += (h$$ << 5) + Objects.hashCode(tabindex);
    h$$ += (h$$ << 5) + widgetClass.hashCode();
    h$$ += (h$$ << 5) + Objects.hashCode(crossorigin);
    h$$ += (h$$ << 5) + Objects.hashCode(content);
    h$$ += (h$$ << 5) + Doubles.hashCode(aspectRatio);
    h$$ += (h$$ << 5) + minWidth;
    h$$ += (h$$ << 5) + minHeight;
    h$$ += (h$$ << 5) + maxWidth;
    h$$ += (h$$ << 5) + maxHeight;
    h$$ += (h$$ << 5) + x;
    h$$ += (h$$ << 5) + y;
    h$$ += (h$$ << 5) + w;
    h$$ += (h$$ << 5) + h;
    h$$ += (h$$ << 5) + Booleans.hashCode(toolbarVisible);
    h$$ += (h$$ << 5) + croppedFormat.hashCode();
    h$$ += (h$$ << 5) + Booleans.hashCode(instant);
    h$$ += (h$$ << 5) + Objects.hashCode(src);
    return h$$;
  }

  /**
   * Prints the immutable value {@code ICropper} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ICropper")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("widgetClass", widgetClass)
        .add("crossorigin", crossorigin)
        .add("content", content)
        .add("aspectRatio", aspectRatio)
        .add("minWidth", minWidth)
        .add("minHeight", minHeight)
        .add("maxWidth", maxWidth)
        .add("maxHeight", maxHeight)
        .add("x", x)
        .add("y", y)
        .add("w", w)
        .add("h", h)
        .add("toolbarVisible", toolbarVisible)
        .add("croppedFormat", croppedFormat)
        .add("instant", instant)
        .add("src", src)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Cropper> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ICropper#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Cropper> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(ICropper.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableICropper validate(ImmutableICropper instance) {
    instance.checkValue();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableICropper) instance.checkDroppable();
    instance = (ImmutableICropper) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ICropper} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ICropper instance
   */
  public static ICropper copyOf(ICropper instance) {
    if (instance instanceof ImmutableICropper) {
      return (ImmutableICropper) instance;
    }
    return new ICropper.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ICropper ICropper}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ICropper", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_ASPECT_RATIO = 0x10L;
    private static final long OPT_BIT_MIN_WIDTH = 0x20L;
    private static final long OPT_BIT_MIN_HEIGHT = 0x40L;
    private static final long OPT_BIT_MAX_WIDTH = 0x80L;
    private static final long OPT_BIT_MAX_HEIGHT = 0x100L;
    private static final long OPT_BIT_X = 0x200L;
    private static final long OPT_BIT_Y = 0x400L;
    private static final long OPT_BIT_W = 0x800L;
    private static final long OPT_BIT_H = 0x1000L;
    private static final long OPT_BIT_TOOLBAR_VISIBLE = 0x2000L;
    private static final long OPT_BIT_INSTANT = 0x4000L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String widgetClass;
    private @Nullable String crossorigin;
    private @Nullable Image content;
    private double aspectRatio;
    private int minWidth;
    private int minHeight;
    private int maxWidth;
    private int maxHeight;
    private int x;
    private int y;
    private int w;
    private int h;
    private boolean toolbarVisible;
    private @Nullable String croppedFormat;
    private boolean instant;
    private @Nullable String src;

    /**
     * Creates a builder for {@link ICropper ICropper} instances.
     * <pre>
     * new ICropper.Builder()
     *    .setId(String) // optional {@link ICropper#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link ICropper#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link ICropper#getActions() actions}
     *    .setVisible(boolean) // optional {@link ICropper#isVisible() visible}
     *    .setMold(String) // optional {@link ICropper#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link ICropper#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ICropper#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ICropper#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ICropper#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link ICropper#getLeft() left}
     *    .setTop(String | null) // nullable {@link ICropper#getTop() top}
     *    .setZIndex(int) // optional {@link ICropper#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link ICropper#getHeight() height}
     *    .setWidth(String | null) // nullable {@link ICropper#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link ICropper#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link ICropper#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link ICropper#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link ICropper#getStyle() style}
     *    .setDraggable(String) // optional {@link ICropper#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link ICropper#isFocus() focus}
     *    .setDroppable(String) // optional {@link ICropper#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link ICropper#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link ICropper#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link ICropper#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link ICropper#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link ICropper#getTabindex() tabindex}
     *    .setWidgetClass(String) // optional {@link ICropper#getWidgetClass() widgetClass}
     *    .setCrossorigin(String | null) // nullable {@link ICropper#getCrossorigin() crossorigin}
     *    .setContent(org.zkoss.image.Image | null) // nullable {@link ICropper#getContent() content}
     *    .setAspectRatio(double) // optional {@link ICropper#getAspectRatio() aspectRatio}
     *    .setMinWidth(int) // optional {@link ICropper#getMinWidth() minWidth}
     *    .setMinHeight(int) // optional {@link ICropper#getMinHeight() minHeight}
     *    .setMaxWidth(int) // optional {@link ICropper#getMaxWidth() maxWidth}
     *    .setMaxHeight(int) // optional {@link ICropper#getMaxHeight() maxHeight}
     *    .setX(int) // optional {@link ICropper#getX() x}
     *    .setY(int) // optional {@link ICropper#getY() y}
     *    .setW(int) // optional {@link ICropper#getW() w}
     *    .setH(int) // optional {@link ICropper#getH() h}
     *    .setToolbarVisible(boolean) // optional {@link ICropper#isToolbarVisible() toolbarVisible}
     *    .setCroppedFormat(String) // optional {@link ICropper#getCroppedFormat() croppedFormat}
     *    .setInstant(boolean) // optional {@link ICropper#isInstant() instant}
     *    .setSrc(String | null) // nullable {@link ICropper#getSrc() src}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ICropper.Builder)) {
        throw new UnsupportedOperationException("Use: new ICropper.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ICropper} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder from(ICropper instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      setWidgetClass(instance.getWidgetClass());
      @Nullable String crossoriginValue = instance.getCrossorigin();
      if (crossoriginValue != null) {
        setCrossorigin(crossoriginValue);
      }
      @Nullable Image contentValue = instance.getContent();
      if (contentValue != null) {
        setContent(contentValue);
      }
      setAspectRatio(instance.getAspectRatio());
      setMinWidth(instance.getMinWidth());
      setMinHeight(instance.getMinHeight());
      setMaxWidth(instance.getMaxWidth());
      setMaxHeight(instance.getMaxHeight());
      setX(instance.getX());
      setY(instance.getY());
      setW(instance.getW());
      setH(instance.getH());
      setToolbarVisible(instance.isToolbarVisible());
      setCroppedFormat(instance.getCroppedFormat());
      setInstant(instance.isInstant());
      @Nullable String srcValue = instance.getSrc();
      if (srcValue != null) {
        setSrc(srcValue);
      }
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (ICropper.Builder) this;
    }

    /**
     * Adds one element to {@link ICropper#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (ICropper.Builder) this;
    }

    /**
     * Adds elements to {@link ICropper#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (ICropper.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link ICropper#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (ICropper.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link ICropper#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (ICropper.Builder) this;
    }

    /**
     * Put one entry to the {@link ICropper#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (ICropper.Builder) this;
    }

    /**
     * Put one entry to the {@link ICropper#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (ICropper.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ICropper#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (ICropper.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ICropper#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (ICropper.Builder) this;
    }

    /**
     * Put one entry to the {@link ICropper#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (ICropper.Builder) this;
    }

    /**
     * Put one entry to the {@link ICropper#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (ICropper.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ICropper#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (ICropper.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ICropper#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (ICropper.Builder) this;
    }

    /**
     * Put one entry to the {@link ICropper#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (ICropper.Builder) this;
    }

    /**
     * Put one entry to the {@link ICropper#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (ICropper.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ICropper#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (ICropper.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ICropper#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setTop(@Nullable String top) {
      this.top = top;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getCrossorigin() crossorigin} attribute.
     * @param crossorigin The value for crossorigin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setCrossorigin(@Nullable String crossorigin) {
      this.crossorigin = crossorigin;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getContent() content} attribute.
     * @param content The value for content (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setContent(@Nullable Image content) {
      this.content = content;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getAspectRatio() aspectRatio} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getAspectRatio() aspectRatio}.</em>
     * @param aspectRatio The value for aspectRatio 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setAspectRatio(double aspectRatio) {
      this.aspectRatio = aspectRatio;
      optBits |= OPT_BIT_ASPECT_RATIO;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getMinWidth() minWidth} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getMinWidth() minWidth}.</em>
     * @param minWidth The value for minWidth 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setMinWidth(int minWidth) {
      this.minWidth = minWidth;
      optBits |= OPT_BIT_MIN_WIDTH;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getMinHeight() minHeight} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getMinHeight() minHeight}.</em>
     * @param minHeight The value for minHeight 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setMinHeight(int minHeight) {
      this.minHeight = minHeight;
      optBits |= OPT_BIT_MIN_HEIGHT;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getMaxWidth() maxWidth} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getMaxWidth() maxWidth}.</em>
     * @param maxWidth The value for maxWidth 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setMaxWidth(int maxWidth) {
      this.maxWidth = maxWidth;
      optBits |= OPT_BIT_MAX_WIDTH;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getMaxHeight() maxHeight} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getMaxHeight() maxHeight}.</em>
     * @param maxHeight The value for maxHeight 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setMaxHeight(int maxHeight) {
      this.maxHeight = maxHeight;
      optBits |= OPT_BIT_MAX_HEIGHT;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getX() x} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getX() x}.</em>
     * @param x The value for x 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setX(int x) {
      this.x = x;
      optBits |= OPT_BIT_X;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getY() y} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getY() y}.</em>
     * @param y The value for y 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setY(int y) {
      this.y = y;
      optBits |= OPT_BIT_Y;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getW() w} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getW() w}.</em>
     * @param w The value for w 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setW(int w) {
      this.w = w;
      optBits |= OPT_BIT_W;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getH() h} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getH() h}.</em>
     * @param h The value for h 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setH(int h) {
      this.h = h;
      optBits |= OPT_BIT_H;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#isToolbarVisible() toolbarVisible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#isToolbarVisible() toolbarVisible}.</em>
     * @param toolbarVisible The value for toolbarVisible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setToolbarVisible(boolean toolbarVisible) {
      this.toolbarVisible = toolbarVisible;
      optBits |= OPT_BIT_TOOLBAR_VISIBLE;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getCroppedFormat() croppedFormat} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#getCroppedFormat() croppedFormat}.</em>
     * @param croppedFormat The value for croppedFormat 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setCroppedFormat(String croppedFormat) {
      this.croppedFormat = Objects.requireNonNull(croppedFormat, "croppedFormat");
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#isInstant() instant} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ICropper#isInstant() instant}.</em>
     * @param instant The value for instant 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setInstant(boolean instant) {
      this.instant = instant;
      optBits |= OPT_BIT_INSTANT;
      return (ICropper.Builder) this;
    }

    /**
     * Initializes the value for the {@link ICropper#getSrc() src} attribute.
     * @param src The value for src (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ICropper.Builder setSrc(@Nullable String src) {
      this.src = src;
      return (ICropper.Builder) this;
    }

    /**
     * Builds a new {@link ICropper ICropper}.
     * @return An immutable instance of ICropper
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ICropper build() {
      return ImmutableICropper.validate(new ImmutableICropper(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean aspectRatioIsSet() {
      return (optBits & OPT_BIT_ASPECT_RATIO) != 0;
    }

    private boolean minWidthIsSet() {
      return (optBits & OPT_BIT_MIN_WIDTH) != 0;
    }

    private boolean minHeightIsSet() {
      return (optBits & OPT_BIT_MIN_HEIGHT) != 0;
    }

    private boolean maxWidthIsSet() {
      return (optBits & OPT_BIT_MAX_WIDTH) != 0;
    }

    private boolean maxHeightIsSet() {
      return (optBits & OPT_BIT_MAX_HEIGHT) != 0;
    }

    private boolean xIsSet() {
      return (optBits & OPT_BIT_X) != 0;
    }

    private boolean yIsSet() {
      return (optBits & OPT_BIT_Y) != 0;
    }

    private boolean wIsSet() {
      return (optBits & OPT_BIT_W) != 0;
    }

    private boolean hIsSet() {
      return (optBits & OPT_BIT_H) != 0;
    }

    private boolean toolbarVisibleIsSet() {
      return (optBits & OPT_BIT_TOOLBAR_VISIBLE) != 0;
    }

    private boolean instantIsSet() {
      return (optBits & OPT_BIT_INSTANT) != 0;
    }
  }
}
