package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zkmax.zul.Barcodescanner;

/**
 * Immutable implementation of {@link IBarcodescanner}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IBarcodescanner.Builder()}.
 */
@Generated(from = "IBarcodescanner", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIBarcodescanner implements IBarcodescanner {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final String widgetClass;
  private final @Nullable ImmutableMap<String, Object> constraints;
  private final String type;
  private final double interval;
  private final int consistencyBufferSize;
  private final int consistencyThreshold;
  private final double errorAcceptance;
  private final boolean continuous;
  private final boolean enable;

  private ImmutableIBarcodescanner(ImmutableIBarcodescanner.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.constraints = builder.constraints == null ? null : builder.constraints.build();
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.type != null) {
      initShim.setType(builder.type);
    }
    if (builder.intervalIsSet()) {
      initShim.setInterval(builder.interval);
    }
    if (builder.consistencyBufferSizeIsSet()) {
      initShim.setConsistencyBufferSize(builder.consistencyBufferSize);
    }
    if (builder.consistencyThresholdIsSet()) {
      initShim.setConsistencyThreshold(builder.consistencyThreshold);
    }
    if (builder.errorAcceptanceIsSet()) {
      initShim.setErrorAcceptance(builder.errorAcceptance);
    }
    if (builder.continuousIsSet()) {
      initShim.setContinuous(builder.continuous);
    }
    if (builder.enableIsSet()) {
      initShim.setEnable(builder.enable);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.widgetClass = initShim.getWidgetClass();
    this.type = initShim.getType();
    this.interval = initShim.getInterval();
    this.consistencyBufferSize = initShim.getConsistencyBufferSize();
    this.consistencyThreshold = initShim.getConsistencyThreshold();
    this.errorAcceptance = initShim.getErrorAcceptance();
    this.continuous = initShim.isContinuous();
    this.enable = initShim.isEnable();
    this.initShim = null;
  }

  private ImmutableIBarcodescanner(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      String widgetClass,
      @Nullable ImmutableMap<String, Object> constraints,
      String type,
      double interval,
      int consistencyBufferSize,
      int consistencyThreshold,
      double errorAcceptance,
      boolean continuous,
      boolean enable) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.widgetClass = widgetClass;
    this.constraints = constraints;
    this.type = type;
    this.interval = interval;
    this.consistencyBufferSize = consistencyBufferSize;
    this.consistencyThreshold = consistencyThreshold;
    this.errorAcceptance = errorAcceptance;
    this.continuous = continuous;
    this.enable = enable;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IBarcodescanner", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte typeBuildStage = STAGE_UNINITIALIZED;
    private String type;

    String getType() {
      if (typeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (typeBuildStage == STAGE_UNINITIALIZED) {
        typeBuildStage = STAGE_INITIALIZING;
        this.type = Objects.requireNonNull(getTypeInitialize(), "type");
        typeBuildStage = STAGE_INITIALIZED;
      }
      return this.type;
    }

    void setType(String type) {
      this.type = type;
      typeBuildStage = STAGE_INITIALIZED;
    }

    private byte intervalBuildStage = STAGE_UNINITIALIZED;
    private double interval;

    double getInterval() {
      if (intervalBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (intervalBuildStage == STAGE_UNINITIALIZED) {
        intervalBuildStage = STAGE_INITIALIZING;
        this.interval = getIntervalInitialize();
        intervalBuildStage = STAGE_INITIALIZED;
      }
      return this.interval;
    }

    void setInterval(double interval) {
      this.interval = interval;
      intervalBuildStage = STAGE_INITIALIZED;
    }

    private byte consistencyBufferSizeBuildStage = STAGE_UNINITIALIZED;
    private int consistencyBufferSize;

    int getConsistencyBufferSize() {
      if (consistencyBufferSizeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (consistencyBufferSizeBuildStage == STAGE_UNINITIALIZED) {
        consistencyBufferSizeBuildStage = STAGE_INITIALIZING;
        this.consistencyBufferSize = getConsistencyBufferSizeInitialize();
        consistencyBufferSizeBuildStage = STAGE_INITIALIZED;
      }
      return this.consistencyBufferSize;
    }

    void setConsistencyBufferSize(int consistencyBufferSize) {
      this.consistencyBufferSize = consistencyBufferSize;
      consistencyBufferSizeBuildStage = STAGE_INITIALIZED;
    }

    private byte consistencyThresholdBuildStage = STAGE_UNINITIALIZED;
    private int consistencyThreshold;

    int getConsistencyThreshold() {
      if (consistencyThresholdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (consistencyThresholdBuildStage == STAGE_UNINITIALIZED) {
        consistencyThresholdBuildStage = STAGE_INITIALIZING;
        this.consistencyThreshold = getConsistencyThresholdInitialize();
        consistencyThresholdBuildStage = STAGE_INITIALIZED;
      }
      return this.consistencyThreshold;
    }

    void setConsistencyThreshold(int consistencyThreshold) {
      this.consistencyThreshold = consistencyThreshold;
      consistencyThresholdBuildStage = STAGE_INITIALIZED;
    }

    private byte errorAcceptanceBuildStage = STAGE_UNINITIALIZED;
    private double errorAcceptance;

    double getErrorAcceptance() {
      if (errorAcceptanceBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (errorAcceptanceBuildStage == STAGE_UNINITIALIZED) {
        errorAcceptanceBuildStage = STAGE_INITIALIZING;
        this.errorAcceptance = getErrorAcceptanceInitialize();
        errorAcceptanceBuildStage = STAGE_INITIALIZED;
      }
      return this.errorAcceptance;
    }

    void setErrorAcceptance(double errorAcceptance) {
      this.errorAcceptance = errorAcceptance;
      errorAcceptanceBuildStage = STAGE_INITIALIZED;
    }

    private byte continuousBuildStage = STAGE_UNINITIALIZED;
    private boolean continuous;

    boolean isContinuous() {
      if (continuousBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (continuousBuildStage == STAGE_UNINITIALIZED) {
        continuousBuildStage = STAGE_INITIALIZING;
        this.continuous = isContinuousInitialize();
        continuousBuildStage = STAGE_INITIALIZED;
      }
      return this.continuous;
    }

    void setContinuous(boolean continuous) {
      this.continuous = continuous;
      continuousBuildStage = STAGE_INITIALIZED;
    }

    private byte enableBuildStage = STAGE_UNINITIALIZED;
    private boolean enable;

    boolean isEnable() {
      if (enableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (enableBuildStage == STAGE_UNINITIALIZED) {
        enableBuildStage = STAGE_INITIALIZING;
        this.enable = isEnableInitialize();
        enableBuildStage = STAGE_INITIALIZED;
      }
      return this.enable;
    }

    void setEnable(boolean enable) {
      this.enable = enable;
      enableBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (typeBuildStage == STAGE_INITIALIZING) attributes.add("type");
      if (intervalBuildStage == STAGE_INITIALIZING) attributes.add("interval");
      if (consistencyBufferSizeBuildStage == STAGE_INITIALIZING) attributes.add("consistencyBufferSize");
      if (consistencyThresholdBuildStage == STAGE_INITIALIZING) attributes.add("consistencyThreshold");
      if (errorAcceptanceBuildStage == STAGE_INITIALIZING) attributes.add("errorAcceptance");
      if (continuousBuildStage == STAGE_INITIALIZING) attributes.add("continuous");
      if (enableBuildStage == STAGE_INITIALIZING) attributes.add("enable");
      return "Cannot build IBarcodescanner, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IBarcodescanner.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IBarcodescanner.super.isVisible();
  }

  private String getMoldInitialize() {
    return IBarcodescanner.super.getMold();
  }

  private int getZIndexInitialize() {
    return IBarcodescanner.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IBarcodescanner.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IBarcodescanner.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IBarcodescanner.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IBarcodescanner.super.getRenderdefer();
  }

  private String getWidgetClassInitialize() {
    return IBarcodescanner.super.getWidgetClass();
  }

  private String getTypeInitialize() {
    return IBarcodescanner.super.getType();
  }

  private double getIntervalInitialize() {
    return IBarcodescanner.super.getInterval();
  }

  private int getConsistencyBufferSizeInitialize() {
    return IBarcodescanner.super.getConsistencyBufferSize();
  }

  private int getConsistencyThresholdInitialize() {
    return IBarcodescanner.super.getConsistencyThreshold();
  }

  private double getErrorAcceptanceInitialize() {
    return IBarcodescanner.super.getErrorAcceptance();
  }

  private boolean isContinuousInitialize() {
    return IBarcodescanner.super.isContinuous();
  }

  private boolean isEnableInitialize() {
    return IBarcodescanner.super.isEnable();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code constraints} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, Object> getConstraints() {
    return constraints;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public String getType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getType()
        : this.type;
  }

  /**
   * @return The value of the {@code interval} attribute
   */
  @Override
  public double getInterval() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getInterval()
        : this.interval;
  }

  /**
   * @return The value of the {@code consistencyBufferSize} attribute
   */
  @Override
  public int getConsistencyBufferSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getConsistencyBufferSize()
        : this.consistencyBufferSize;
  }

  /**
   * @return The value of the {@code consistencyThreshold} attribute
   */
  @Override
  public int getConsistencyThreshold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getConsistencyThreshold()
        : this.consistencyThreshold;
  }

  /**
   * @return The value of the {@code errorAcceptance} attribute
   */
  @Override
  public double getErrorAcceptance() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getErrorAcceptance()
        : this.errorAcceptance;
  }

  /**
   * @return The value of the {@code continuous} attribute
   */
  @Override
  public boolean isContinuous() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isContinuous()
        : this.continuous;
  }

  /**
   * @return The value of the {@code enable} attribute
   */
  @Override
  public boolean isEnable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isEnable()
        : this.enable;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIBarcodescanner(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IBarcodescanner#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBarcodescanner withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIBarcodescanner(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.widgetClass,
          this.constraints,
          this.type,
          this.interval,
          this.consistencyBufferSize,
          this.consistencyThreshold,
          this.errorAcceptance,
          this.continuous,
          this.enable));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IBarcodescanner#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBarcodescanner withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by replacing the {@link IBarcodescanner#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBarcodescanner withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by replacing the {@link IBarcodescanner#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBarcodescanner withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by replacing the {@link IBarcodescanner#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBarcodescanner withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by replacing the {@link IBarcodescanner#getConstraints() constraints} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the constraints map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBarcodescanner withConstraints(@Nullable Map<String, ? extends Object> entries) {
    if (this.constraints == entries) return this;
    @Nullable ImmutableMap<String, Object> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        newValue,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        newValue,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getInterval() interval} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for interval
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withInterval(double value) {
    if (Double.doubleToLongBits(this.interval) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        value,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getConsistencyBufferSize() consistencyBufferSize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for consistencyBufferSize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withConsistencyBufferSize(int value) {
    if (this.consistencyBufferSize == value) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        value,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getConsistencyThreshold() consistencyThreshold} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for consistencyThreshold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withConsistencyThreshold(int value) {
    if (this.consistencyThreshold == value) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        value,
        this.errorAcceptance,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#getErrorAcceptance() errorAcceptance} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorAcceptance
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withErrorAcceptance(double value) {
    if (Double.doubleToLongBits(this.errorAcceptance) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        value,
        this.continuous,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#isContinuous() continuous} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for continuous
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withContinuous(boolean value) {
    if (this.continuous == value) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        value,
        this.enable));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBarcodescanner#isEnable() enable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBarcodescanner withEnable(boolean value) {
    if (this.enable == value) return this;
    return validate(new ImmutableIBarcodescanner(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.constraints,
        this.type,
        this.interval,
        this.consistencyBufferSize,
        this.consistencyThreshold,
        this.errorAcceptance,
        this.continuous,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIBarcodescanner} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIBarcodescanner
        && equalTo((ImmutableIBarcodescanner) another);
  }

  private boolean equalTo(ImmutableIBarcodescanner another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(constraints, another.constraints)
        && type.equals(another.type)
        && Double.doubleToLongBits(interval) == Double.doubleToLongBits(another.interval)
        && consistencyBufferSize == another.consistencyBufferSize
        && consistencyThreshold == another.consistencyThreshold
        && Double.doubleToLongBits(errorAcceptance) == Double.doubleToLongBits(another.errorAcceptance)
        && continuous == another.continuous
        && enable == another.enable;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code widgetClass}, {@code constraints}, {@code type}, {@code interval}, {@code consistencyBufferSize}, {@code consistencyThreshold}, {@code errorAcceptance}, {@code continuous}, {@code enable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(constraints);
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Doubles.hashCode(interval);
    h += (h << 5) + consistencyBufferSize;
    h += (h << 5) + consistencyThreshold;
    h += (h << 5) + Doubles.hashCode(errorAcceptance);
    h += (h << 5) + Booleans.hashCode(continuous);
    h += (h << 5) + Booleans.hashCode(enable);
    return h;
  }

  /**
   * Prints the immutable value {@code IBarcodescanner} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IBarcodescanner")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("widgetClass", widgetClass)
        .add("constraints", constraints)
        .add("type", type)
        .add("interval", interval)
        .add("consistencyBufferSize", consistencyBufferSize)
        .add("consistencyThreshold", consistencyThreshold)
        .add("errorAcceptance", errorAcceptance)
        .add("continuous", continuous)
        .add("enable", enable)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Barcodescanner> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IBarcodescanner#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Barcodescanner> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IBarcodescanner.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableIBarcodescanner validate(ImmutableIBarcodescanner instance) {
    instance.checkThreshold();
    instance.checkAcceptance();
    instance.checkBufferSize();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIBarcodescanner) instance.checkDroppable();
    instance = (ImmutableIBarcodescanner) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IBarcodescanner} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IBarcodescanner instance
   */
  public static IBarcodescanner copyOf(IBarcodescanner instance) {
    if (instance instanceof ImmutableIBarcodescanner) {
      return (ImmutableIBarcodescanner) instance;
    }
    return new IBarcodescanner.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IBarcodescanner IBarcodescanner}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IBarcodescanner", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_INTERVAL = 0x10L;
    private static final long OPT_BIT_CONSISTENCY_BUFFER_SIZE = 0x20L;
    private static final long OPT_BIT_CONSISTENCY_THRESHOLD = 0x40L;
    private static final long OPT_BIT_ERROR_ACCEPTANCE = 0x80L;
    private static final long OPT_BIT_CONTINUOUS = 0x100L;
    private static final long OPT_BIT_ENABLE = 0x200L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable String widgetClass;
    private ImmutableMap.Builder<String, Object> constraints = null;
    private @Nullable String type;
    private double interval;
    private int consistencyBufferSize;
    private int consistencyThreshold;
    private double errorAcceptance;
    private boolean continuous;
    private boolean enable;

    /**
     * Creates a builder for {@link IBarcodescanner IBarcodescanner} instances.
     * <pre>
     * new IBarcodescanner.Builder()
     *    .setId(String) // optional {@link IBarcodescanner#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IBarcodescanner#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IBarcodescanner#getActions() actions}
     *    .setVisible(boolean) // optional {@link IBarcodescanner#isVisible() visible}
     *    .setMold(String) // optional {@link IBarcodescanner#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IBarcodescanner#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IBarcodescanner#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IBarcodescanner#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IBarcodescanner#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IBarcodescanner#getLeft() left}
     *    .setTop(String | null) // nullable {@link IBarcodescanner#getTop() top}
     *    .setZIndex(int) // optional {@link IBarcodescanner#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IBarcodescanner#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IBarcodescanner#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IBarcodescanner#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IBarcodescanner#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IBarcodescanner#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IBarcodescanner#getStyle() style}
     *    .setDraggable(String) // optional {@link IBarcodescanner#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IBarcodescanner#isFocus() focus}
     *    .setDroppable(String) // optional {@link IBarcodescanner#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IBarcodescanner#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IBarcodescanner#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IBarcodescanner#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IBarcodescanner#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IBarcodescanner#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IBarcodescanner#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IBarcodescanner#getContext() context}
     *    .setPopup(String | null) // nullable {@link IBarcodescanner#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IBarcodescanner#getTooltip() tooltip}
     *    .setWidgetClass(String) // optional {@link IBarcodescanner#getWidgetClass() widgetClass}
     *    .setConstraints(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link IBarcodescanner#getConstraints() constraints}
     *    .setType(String) // optional {@link IBarcodescanner#getType() type}
     *    .setInterval(double) // optional {@link IBarcodescanner#getInterval() interval}
     *    .setConsistencyBufferSize(int) // optional {@link IBarcodescanner#getConsistencyBufferSize() consistencyBufferSize}
     *    .setConsistencyThreshold(int) // optional {@link IBarcodescanner#getConsistencyThreshold() consistencyThreshold}
     *    .setErrorAcceptance(double) // optional {@link IBarcodescanner#getErrorAcceptance() errorAcceptance}
     *    .setContinuous(boolean) // optional {@link IBarcodescanner#isContinuous() continuous}
     *    .setEnable(boolean) // optional {@link IBarcodescanner#isEnable() enable}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IBarcodescanner.Builder)) {
        throw new UnsupportedOperationException("Use: new IBarcodescanner.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IBarcodescanner} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder from(IBarcodescanner instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setWidgetClass(instance.getWidgetClass());
      @Nullable Map<String, Object> constraintsValue = instance.getConstraints();
      if (constraintsValue != null) {
        putAllConstraints(constraintsValue);
      }
      setType(instance.getType());
      setInterval(instance.getInterval());
      setConsistencyBufferSize(instance.getConsistencyBufferSize());
      setConsistencyThreshold(instance.getConsistencyThreshold());
      setErrorAcceptance(instance.getErrorAcceptance());
      setContinuous(instance.isContinuous());
      setEnable(instance.isEnable());
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Adds one element to {@link IBarcodescanner#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Adds elements to {@link IBarcodescanner#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IBarcodescanner.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IBarcodescanner#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IBarcodescanner.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IBarcodescanner#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Put one entry to the {@link IBarcodescanner#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Put one entry to the {@link IBarcodescanner#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IBarcodescanner#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IBarcodescanner.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IBarcodescanner#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Put one entry to the {@link IBarcodescanner#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Put one entry to the {@link IBarcodescanner#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IBarcodescanner#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IBarcodescanner.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IBarcodescanner#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Put one entry to the {@link IBarcodescanner#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Put one entry to the {@link IBarcodescanner#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IBarcodescanner#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IBarcodescanner.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IBarcodescanner#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setTop(@Nullable String top) {
      this.top = top;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setContext(@Nullable String context) {
      this.context = context;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Put one entry to the {@link IBarcodescanner#getConstraints() constraints} map.
     * @param key The key in the constraints map
     * @param value The associated value in the constraints map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder putConstraints(String key, Object value) {
      if (this.constraints == null) {
        this.constraints = ImmutableMap.builder();
      }
      this.constraints.put(key, value);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Put one entry to the {@link IBarcodescanner#getConstraints() constraints} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder putConstraints(Map.Entry<String, ? extends Object> entry) {
      if (this.constraints == null) {
        this.constraints = ImmutableMap.builder();
      }
      this.constraints.put(entry);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IBarcodescanner#getConstraints() constraints} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the constraints map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setConstraints(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.constraints = null;
        return (IBarcodescanner.Builder) this;
      }
      this.constraints = ImmutableMap.builder();
      return putAllConstraints(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IBarcodescanner#getConstraints() constraints} map. Nulls are not permitted
     * @param entries The entries that will be added to the constraints map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder putAllConstraints(Map<String, ? extends Object> entries) {
      if (this.constraints == null) {
        this.constraints = ImmutableMap.builder();
      }
      this.constraints.putAll(entries);
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getType() type} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#getType() type}.</em>
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setType(String type) {
      this.type = Objects.requireNonNull(type, "type");
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getInterval() interval} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#getInterval() interval}.</em>
     * @param interval The value for interval 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setInterval(double interval) {
      this.interval = interval;
      optBits |= OPT_BIT_INTERVAL;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getConsistencyBufferSize() consistencyBufferSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#getConsistencyBufferSize() consistencyBufferSize}.</em>
     * @param consistencyBufferSize The value for consistencyBufferSize 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setConsistencyBufferSize(int consistencyBufferSize) {
      this.consistencyBufferSize = consistencyBufferSize;
      optBits |= OPT_BIT_CONSISTENCY_BUFFER_SIZE;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getConsistencyThreshold() consistencyThreshold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#getConsistencyThreshold() consistencyThreshold}.</em>
     * @param consistencyThreshold The value for consistencyThreshold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setConsistencyThreshold(int consistencyThreshold) {
      this.consistencyThreshold = consistencyThreshold;
      optBits |= OPT_BIT_CONSISTENCY_THRESHOLD;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#getErrorAcceptance() errorAcceptance} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#getErrorAcceptance() errorAcceptance}.</em>
     * @param errorAcceptance The value for errorAcceptance 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setErrorAcceptance(double errorAcceptance) {
      this.errorAcceptance = errorAcceptance;
      optBits |= OPT_BIT_ERROR_ACCEPTANCE;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#isContinuous() continuous} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#isContinuous() continuous}.</em>
     * @param continuous The value for continuous 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setContinuous(boolean continuous) {
      this.continuous = continuous;
      optBits |= OPT_BIT_CONTINUOUS;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBarcodescanner#isEnable() enable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBarcodescanner#isEnable() enable}.</em>
     * @param enable The value for enable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBarcodescanner.Builder setEnable(boolean enable) {
      this.enable = enable;
      optBits |= OPT_BIT_ENABLE;
      return (IBarcodescanner.Builder) this;
    }

    /**
     * Builds a new {@link IBarcodescanner IBarcodescanner}.
     * @return An immutable instance of IBarcodescanner
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IBarcodescanner build() {
      return ImmutableIBarcodescanner.validate(new ImmutableIBarcodescanner(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean intervalIsSet() {
      return (optBits & OPT_BIT_INTERVAL) != 0;
    }

    private boolean consistencyBufferSizeIsSet() {
      return (optBits & OPT_BIT_CONSISTENCY_BUFFER_SIZE) != 0;
    }

    private boolean consistencyThresholdIsSet() {
      return (optBits & OPT_BIT_CONSISTENCY_THRESHOLD) != 0;
    }

    private boolean errorAcceptanceIsSet() {
      return (optBits & OPT_BIT_ERROR_ACCEPTANCE) != 0;
    }

    private boolean continuousIsSet() {
      return (optBits & OPT_BIT_CONTINUOUS) != 0;
    }

    private boolean enableIsSet() {
      return (optBits & OPT_BIT_ENABLE) != 0;
    }
  }
}
