package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Decimalbox;

/**
 * Immutable implementation of {@link IDecimalbox}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IDecimalbox.Builder()}.
 */
@Generated(from = "IDecimalbox", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIDecimalbox implements IDecimalbox {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final boolean readonly;
  private final @Nullable String name;
  private final @Nullable String placeholder;
  private final @Nullable ImmutableMap<String, String> inputAttributes;
  private final @Nullable BigDecimal value;
  private final @Nullable String constraint;
  private final @Nullable String errorboxSclass;
  private final @Nullable String errorboxIconSclass;
  private final boolean disabled;
  private final boolean inplace;
  private final int maxlength;
  private final boolean instant;
  private final @Nullable String errorMessage;
  private final @Nullable String format;
  private final @Nullable Locale locale;
  private final int cols;
  private final int roundingMode;
  private final String widgetClass;
  private final int scale;

  private ImmutableIDecimalbox(ImmutableIDecimalbox.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.name = builder.name;
    this.placeholder = builder.placeholder;
    this.inputAttributes = builder.inputAttributes == null ? null : builder.inputAttributes.build();
    this.value = builder.value;
    this.constraint = builder.constraint;
    this.errorboxSclass = builder.errorboxSclass;
    this.errorboxIconSclass = builder.errorboxIconSclass;
    this.errorMessage = builder.errorMessage;
    this.format = builder.format;
    this.locale = builder.locale;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.readonlyIsSet()) {
      initShim.setReadonly(builder.readonly);
    }
    if (builder.disabledIsSet()) {
      initShim.setDisabled(builder.disabled);
    }
    if (builder.inplaceIsSet()) {
      initShim.setInplace(builder.inplace);
    }
    if (builder.maxlengthIsSet()) {
      initShim.setMaxlength(builder.maxlength);
    }
    if (builder.instantIsSet()) {
      initShim.setInstant(builder.instant);
    }
    if (builder.colsIsSet()) {
      initShim.setCols(builder.cols);
    }
    if (builder.roundingModeIsSet()) {
      initShim.setRoundingMode(builder.roundingMode);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.scaleIsSet()) {
      initShim.setScale(builder.scale);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.readonly = initShim.isReadonly();
    this.disabled = initShim.isDisabled();
    this.inplace = initShim.isInplace();
    this.maxlength = initShim.getMaxlength();
    this.instant = initShim.getInstant();
    this.cols = initShim.getCols();
    this.roundingMode = initShim.getRoundingMode();
    this.widgetClass = initShim.getWidgetClass();
    this.scale = initShim.getScale();
    this.initShim = null;
  }

  private ImmutableIDecimalbox(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      boolean readonly,
      @Nullable String name,
      @Nullable String placeholder,
      @Nullable ImmutableMap<String, String> inputAttributes,
      @Nullable BigDecimal value,
      @Nullable String constraint,
      @Nullable String errorboxSclass,
      @Nullable String errorboxIconSclass,
      boolean disabled,
      boolean inplace,
      int maxlength,
      boolean instant,
      @Nullable String errorMessage,
      @Nullable String format,
      @Nullable Locale locale,
      int cols,
      int roundingMode,
      String widgetClass,
      int scale) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.readonly = readonly;
    this.name = name;
    this.placeholder = placeholder;
    this.inputAttributes = inputAttributes;
    this.value = value;
    this.constraint = constraint;
    this.errorboxSclass = errorboxSclass;
    this.errorboxIconSclass = errorboxIconSclass;
    this.disabled = disabled;
    this.inplace = inplace;
    this.maxlength = maxlength;
    this.instant = instant;
    this.errorMessage = errorMessage;
    this.format = format;
    this.locale = locale;
    this.cols = cols;
    this.roundingMode = roundingMode;
    this.widgetClass = widgetClass;
    this.scale = scale;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IDecimalbox", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte readonlyBuildStage = STAGE_UNINITIALIZED;
    private boolean readonly;

    boolean isReadonly() {
      if (readonlyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (readonlyBuildStage == STAGE_UNINITIALIZED) {
        readonlyBuildStage = STAGE_INITIALIZING;
        this.readonly = isReadonlyInitialize();
        readonlyBuildStage = STAGE_INITIALIZED;
      }
      return this.readonly;
    }

    void setReadonly(boolean readonly) {
      this.readonly = readonly;
      readonlyBuildStage = STAGE_INITIALIZED;
    }

    private byte disabledBuildStage = STAGE_UNINITIALIZED;
    private boolean disabled;

    boolean isDisabled() {
      if (disabledBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disabledBuildStage == STAGE_UNINITIALIZED) {
        disabledBuildStage = STAGE_INITIALIZING;
        this.disabled = isDisabledInitialize();
        disabledBuildStage = STAGE_INITIALIZED;
      }
      return this.disabled;
    }

    void setDisabled(boolean disabled) {
      this.disabled = disabled;
      disabledBuildStage = STAGE_INITIALIZED;
    }

    private byte inplaceBuildStage = STAGE_UNINITIALIZED;
    private boolean inplace;

    boolean isInplace() {
      if (inplaceBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (inplaceBuildStage == STAGE_UNINITIALIZED) {
        inplaceBuildStage = STAGE_INITIALIZING;
        this.inplace = isInplaceInitialize();
        inplaceBuildStage = STAGE_INITIALIZED;
      }
      return this.inplace;
    }

    void setInplace(boolean inplace) {
      this.inplace = inplace;
      inplaceBuildStage = STAGE_INITIALIZED;
    }

    private byte maxlengthBuildStage = STAGE_UNINITIALIZED;
    private int maxlength;

    int getMaxlength() {
      if (maxlengthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxlengthBuildStage == STAGE_UNINITIALIZED) {
        maxlengthBuildStage = STAGE_INITIALIZING;
        this.maxlength = getMaxlengthInitialize();
        maxlengthBuildStage = STAGE_INITIALIZED;
      }
      return this.maxlength;
    }

    void setMaxlength(int maxlength) {
      this.maxlength = maxlength;
      maxlengthBuildStage = STAGE_INITIALIZED;
    }

    private byte instantBuildStage = STAGE_UNINITIALIZED;
    private boolean instant;

    boolean getInstant() {
      if (instantBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (instantBuildStage == STAGE_UNINITIALIZED) {
        instantBuildStage = STAGE_INITIALIZING;
        this.instant = getInstantInitialize();
        instantBuildStage = STAGE_INITIALIZED;
      }
      return this.instant;
    }

    void setInstant(boolean instant) {
      this.instant = instant;
      instantBuildStage = STAGE_INITIALIZED;
    }

    private byte colsBuildStage = STAGE_UNINITIALIZED;
    private int cols;

    int getCols() {
      if (colsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (colsBuildStage == STAGE_UNINITIALIZED) {
        colsBuildStage = STAGE_INITIALIZING;
        this.cols = getColsInitialize();
        colsBuildStage = STAGE_INITIALIZED;
      }
      return this.cols;
    }

    void setCols(int cols) {
      this.cols = cols;
      colsBuildStage = STAGE_INITIALIZED;
    }

    private byte roundingModeBuildStage = STAGE_UNINITIALIZED;
    private int roundingMode;

    int getRoundingMode() {
      if (roundingModeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (roundingModeBuildStage == STAGE_UNINITIALIZED) {
        roundingModeBuildStage = STAGE_INITIALIZING;
        this.roundingMode = getRoundingModeInitialize();
        roundingModeBuildStage = STAGE_INITIALIZED;
      }
      return this.roundingMode;
    }

    void setRoundingMode(int roundingMode) {
      this.roundingMode = roundingMode;
      roundingModeBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte scaleBuildStage = STAGE_UNINITIALIZED;
    private int scale;

    int getScale() {
      if (scaleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (scaleBuildStage == STAGE_UNINITIALIZED) {
        scaleBuildStage = STAGE_INITIALIZING;
        this.scale = getScaleInitialize();
        scaleBuildStage = STAGE_INITIALIZED;
      }
      return this.scale;
    }

    void setScale(int scale) {
      this.scale = scale;
      scaleBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (readonlyBuildStage == STAGE_INITIALIZING) attributes.add("readonly");
      if (disabledBuildStage == STAGE_INITIALIZING) attributes.add("disabled");
      if (inplaceBuildStage == STAGE_INITIALIZING) attributes.add("inplace");
      if (maxlengthBuildStage == STAGE_INITIALIZING) attributes.add("maxlength");
      if (instantBuildStage == STAGE_INITIALIZING) attributes.add("instant");
      if (colsBuildStage == STAGE_INITIALIZING) attributes.add("cols");
      if (roundingModeBuildStage == STAGE_INITIALIZING) attributes.add("roundingMode");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (scaleBuildStage == STAGE_INITIALIZING) attributes.add("scale");
      return "Cannot build IDecimalbox, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IDecimalbox.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IDecimalbox.super.isVisible();
  }

  private String getMoldInitialize() {
    return IDecimalbox.super.getMold();
  }

  private int getZIndexInitialize() {
    return IDecimalbox.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IDecimalbox.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IDecimalbox.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IDecimalbox.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IDecimalbox.super.getRenderdefer();
  }

  private boolean isReadonlyInitialize() {
    return IDecimalbox.super.isReadonly();
  }

  private boolean isDisabledInitialize() {
    return IDecimalbox.super.isDisabled();
  }

  private boolean isInplaceInitialize() {
    return IDecimalbox.super.isInplace();
  }

  private int getMaxlengthInitialize() {
    return IDecimalbox.super.getMaxlength();
  }

  private boolean getInstantInitialize() {
    return IDecimalbox.super.getInstant();
  }

  private int getColsInitialize() {
    return IDecimalbox.super.getCols();
  }

  private int getRoundingModeInitialize() {
    return IDecimalbox.super.getRoundingMode();
  }

  private String getWidgetClassInitialize() {
    return IDecimalbox.super.getWidgetClass();
  }

  private int getScaleInitialize() {
    return IDecimalbox.super.getScale();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code readonly} attribute
   */
  @Override
  public boolean isReadonly() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isReadonly()
        : this.readonly;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @Override
  public @Nullable String getPlaceholder() {
    return placeholder;
  }

  /**
   * @return The value of the {@code inputAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getInputAttributes() {
    return inputAttributes;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public @Nullable BigDecimal getValue() {
    return value;
  }

  /**
   * @return The value of the {@code constraint} attribute
   */
  @Override
  public @Nullable String getConstraint() {
    return constraint;
  }

  /**
   * @return The value of the {@code errorboxSclass} attribute
   */
  @Override
  public @Nullable String getErrorboxSclass() {
    return errorboxSclass;
  }

  /**
   * @return The value of the {@code errorboxIconSclass} attribute
   */
  @Override
  public @Nullable String getErrorboxIconSclass() {
    return errorboxIconSclass;
  }

  /**
   * @return The value of the {@code disabled} attribute
   */
  @Override
  public boolean isDisabled() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDisabled()
        : this.disabled;
  }

  /**
   * @return The value of the {@code inplace} attribute
   */
  @Override
  public boolean isInplace() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isInplace()
        : this.inplace;
  }

  /**
   * @return The value of the {@code maxlength} attribute
   */
  @Override
  public int getMaxlength() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMaxlength()
        : this.maxlength;
  }

  /**
   * @return The value of the {@code instant} attribute
   */
  @Override
  public boolean getInstant() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getInstant()
        : this.instant;
  }

  /**
   * @return The value of the {@code errorMessage} attribute
   */
  @Override
  public @Nullable String getErrorMessage() {
    return errorMessage;
  }

  /**
   * @return The value of the {@code format} attribute
   */
  @Override
  public @Nullable String getFormat() {
    return format;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @Override
  public @Nullable Locale getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code cols} attribute
   */
  @Override
  public int getCols() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCols()
        : this.cols;
  }

  /**
   * @return The value of the {@code roundingMode} attribute
   */
  @Override
  public int getRoundingMode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRoundingMode()
        : this.roundingMode;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code scale} attribute
   */
  @Override
  public int getScale() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getScale()
        : this.scale;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIDecimalbox(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IDecimalbox#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDecimalbox withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIDecimalbox(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.readonly,
          this.name,
          this.placeholder,
          this.inputAttributes,
          this.value,
          this.constraint,
          this.errorboxSclass,
          this.errorboxIconSclass,
          this.disabled,
          this.inplace,
          this.maxlength,
          this.instant,
          this.errorMessage,
          this.format,
          this.locale,
          this.cols,
          this.roundingMode,
          this.widgetClass,
          this.scale));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IDecimalbox#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDecimalbox withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by replacing the {@link IDecimalbox#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDecimalbox withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by replacing the {@link IDecimalbox#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDecimalbox withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by replacing the {@link IDecimalbox#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDecimalbox withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#isReadonly() readonly} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for readonly
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withReadonly(boolean value) {
    if (this.readonly == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        value,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        value,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getPlaceholder() placeholder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for placeholder (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withPlaceholder(@Nullable String value) {
    if (Objects.equals(this.placeholder, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        value,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by replacing the {@link IDecimalbox#getInputAttributes() inputAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the inputAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIDecimalbox withInputAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.inputAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        newValue,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withValue(@Nullable BigDecimal value) {
    if (Objects.equals(this.value, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getConstraint() constraint} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for constraint (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withConstraint(@Nullable String value) {
    if (Objects.equals(this.constraint, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        value,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getErrorboxSclass() errorboxSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorboxSclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withErrorboxSclass(@Nullable String value) {
    if (Objects.equals(this.errorboxSclass, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        value,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getErrorboxIconSclass() errorboxIconSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorboxIconSclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withErrorboxIconSclass(@Nullable String value) {
    if (Objects.equals(this.errorboxIconSclass, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        value,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#isDisabled() disabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withDisabled(boolean value) {
    if (this.disabled == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        value,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#isInplace() inplace} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inplace
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withInplace(boolean value) {
    if (this.inplace == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        value,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getMaxlength() maxlength} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxlength
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withMaxlength(int value) {
    if (this.maxlength == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        value,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getInstant() instant} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for instant
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withInstant(boolean value) {
    if (this.instant == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        value,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getErrorMessage() errorMessage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorMessage (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withErrorMessage(@Nullable String value) {
    if (Objects.equals(this.errorMessage, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        value,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getFormat() format} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for format (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withFormat(@Nullable String value) {
    if (Objects.equals(this.format, value)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        value,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getLocale() locale} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withLocale(@Nullable Locale value) {
    if (this.locale == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        value,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getCols() cols} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cols
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withCols(int value) {
    if (this.cols == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        value,
        this.roundingMode,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getRoundingMode() roundingMode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for roundingMode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withRoundingMode(int value) {
    if (this.roundingMode == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        value,
        this.widgetClass,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        newValue,
        this.scale));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IDecimalbox#getScale() scale} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIDecimalbox withScale(int value) {
    if (this.scale == value) return this;
    return validate(new ImmutableIDecimalbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.format,
        this.locale,
        this.cols,
        this.roundingMode,
        this.widgetClass,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIDecimalbox} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIDecimalbox
        && equalTo((ImmutableIDecimalbox) another);
  }

  private boolean equalTo(ImmutableIDecimalbox another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && readonly == another.readonly
        && Objects.equals(name, another.name)
        && Objects.equals(placeholder, another.placeholder)
        && Objects.equals(inputAttributes, another.inputAttributes)
        && Objects.equals(value, another.value)
        && Objects.equals(constraint, another.constraint)
        && Objects.equals(errorboxSclass, another.errorboxSclass)
        && Objects.equals(errorboxIconSclass, another.errorboxIconSclass)
        && disabled == another.disabled
        && inplace == another.inplace
        && maxlength == another.maxlength
        && instant == another.instant
        && Objects.equals(errorMessage, another.errorMessage)
        && Objects.equals(format, another.format)
        && Objects.equals(locale, another.locale)
        && cols == another.cols
        && roundingMode == another.roundingMode
        && widgetClass.equals(another.widgetClass)
        && scale == another.scale;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code readonly}, {@code name}, {@code placeholder}, {@code inputAttributes}, {@code value}, {@code constraint}, {@code errorboxSclass}, {@code errorboxIconSclass}, {@code disabled}, {@code inplace}, {@code maxlength}, {@code instant}, {@code errorMessage}, {@code format}, {@code locale}, {@code cols}, {@code roundingMode}, {@code widgetClass}, {@code scale}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + Booleans.hashCode(readonly);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(placeholder);
    h += (h << 5) + Objects.hashCode(inputAttributes);
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Objects.hashCode(constraint);
    h += (h << 5) + Objects.hashCode(errorboxSclass);
    h += (h << 5) + Objects.hashCode(errorboxIconSclass);
    h += (h << 5) + Booleans.hashCode(disabled);
    h += (h << 5) + Booleans.hashCode(inplace);
    h += (h << 5) + maxlength;
    h += (h << 5) + Booleans.hashCode(instant);
    h += (h << 5) + Objects.hashCode(errorMessage);
    h += (h << 5) + Objects.hashCode(format);
    h += (h << 5) + Objects.hashCode(locale);
    h += (h << 5) + cols;
    h += (h << 5) + roundingMode;
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + scale;
    return h;
  }

  /**
   * Prints the immutable value {@code IDecimalbox} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IDecimalbox")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("readonly", readonly)
        .add("name", name)
        .add("placeholder", placeholder)
        .add("inputAttributes", inputAttributes)
        .add("value", value)
        .add("constraint", constraint)
        .add("errorboxSclass", errorboxSclass)
        .add("errorboxIconSclass", errorboxIconSclass)
        .add("disabled", disabled)
        .add("inplace", inplace)
        .add("maxlength", maxlength)
        .add("instant", instant)
        .add("errorMessage", errorMessage)
        .add("format", format)
        .add("locale", locale)
        .add("cols", cols)
        .add("roundingMode", roundingMode)
        .add("widgetClass", widgetClass)
        .add("scale", scale)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long REAL_FORMAT_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String realFormat;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IDecimalbox#getRealFormat() realFormat} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code realFormat} attribute
   */
  @Override
  public String getRealFormat() {
    if ((lazyInitBitmap & REAL_FORMAT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & REAL_FORMAT_LAZY_INIT_BIT) == 0) {
          this.realFormat = IDecimalbox.super.getRealFormat();
          lazyInitBitmap |= REAL_FORMAT_LAZY_INIT_BIT;
        }
      }
    }
    return realFormat;
  }

  private static final long DEFAULT_FORMAT_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient String defaultFormat;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IDecimalbox#getDefaultFormat() defaultFormat} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code defaultFormat} attribute
   */
  @Override
  public String getDefaultFormat() {
    if ((lazyInitBitmap & DEFAULT_FORMAT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & DEFAULT_FORMAT_LAZY_INIT_BIT) == 0) {
          this.defaultFormat = Objects.requireNonNull(IDecimalbox.super.getDefaultFormat(), "defaultFormat");
          lazyInitBitmap |= DEFAULT_FORMAT_LAZY_INIT_BIT;
        }
      }
    }
    return defaultFormat;
  }

  private static final long LOCALE_FORMAT_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient boolean localeFormat;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IDecimalbox#isLocaleFormat() localeFormat} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code localeFormat} attribute
   */
  @Override
  public boolean isLocaleFormat() {
    if ((lazyInitBitmap & LOCALE_FORMAT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & LOCALE_FORMAT_LAZY_INIT_BIT) == 0) {
          this.localeFormat = IDecimalbox.super.isLocaleFormat();
          lazyInitBitmap |= LOCALE_FORMAT_LAZY_INIT_BIT;
        }
      }
    }
    return localeFormat;
  }

  private static final long DEFAULT_LOCALE_LAZY_INIT_BIT = 0x8L;

  @SuppressWarnings("Immutable")
  private transient Locale defaultLocale;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IDecimalbox#getDefaultLocale() defaultLocale} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code defaultLocale} attribute
   */
  @Override
  public Locale getDefaultLocale() {
    if ((lazyInitBitmap & DEFAULT_LOCALE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & DEFAULT_LOCALE_LAZY_INIT_BIT) == 0) {
          this.defaultLocale = Objects.requireNonNull(IDecimalbox.super.getDefaultLocale(), "defaultLocale");
          lazyInitBitmap |= DEFAULT_LOCALE_LAZY_INIT_BIT;
        }
      }
    }
    return defaultLocale;
  }

  private static final long REAL_SYMBOLS_LAZY_INIT_BIT = 0x10L;

  @SuppressWarnings("Immutable")
  private transient String realSymbols;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IDecimalbox#getRealSymbols() realSymbols} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code realSymbols} attribute
   */
  @Override
  public String getRealSymbols() {
    if ((lazyInitBitmap & REAL_SYMBOLS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & REAL_SYMBOLS_LAZY_INIT_BIT) == 0) {
          this.realSymbols = Objects.requireNonNull(IDecimalbox.super.getRealSymbols(), "realSymbols");
          lazyInitBitmap |= REAL_SYMBOLS_LAZY_INIT_BIT;
        }
      }
    }
    return realSymbols;
  }

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x20L;

  @SuppressWarnings("Immutable")
  private transient Class<Decimalbox> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IDecimalbox#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Decimalbox> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IDecimalbox.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableIDecimalbox validate(ImmutableIDecimalbox instance) {
    instance = (ImmutableIDecimalbox) instance.checkLocale();
    instance.checkCols();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIDecimalbox) instance.checkDroppable();
    instance = (ImmutableIDecimalbox) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IDecimalbox} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IDecimalbox instance
   */
  public static IDecimalbox copyOf(IDecimalbox instance) {
    if (instance instanceof ImmutableIDecimalbox) {
      return (ImmutableIDecimalbox) instance;
    }
    return new IDecimalbox.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IDecimalbox IDecimalbox}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IDecimalbox", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_READONLY = 0x10L;
    private static final long OPT_BIT_DISABLED = 0x20L;
    private static final long OPT_BIT_INPLACE = 0x40L;
    private static final long OPT_BIT_MAXLENGTH = 0x80L;
    private static final long OPT_BIT_INSTANT = 0x100L;
    private static final long OPT_BIT_COLS = 0x200L;
    private static final long OPT_BIT_ROUNDING_MODE = 0x400L;
    private static final long OPT_BIT_SCALE = 0x800L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private boolean readonly;
    private @Nullable String name;
    private @Nullable String placeholder;
    private ImmutableMap.Builder<String, String> inputAttributes = null;
    private @Nullable BigDecimal value;
    private @Nullable String constraint;
    private @Nullable String errorboxSclass;
    private @Nullable String errorboxIconSclass;
    private boolean disabled;
    private boolean inplace;
    private int maxlength;
    private boolean instant;
    private @Nullable String errorMessage;
    private @Nullable String format;
    private @Nullable Locale locale;
    private int cols;
    private int roundingMode;
    private @Nullable String widgetClass;
    private int scale;

    /**
     * Creates a builder for {@link IDecimalbox IDecimalbox} instances.
     * <pre>
     * new IDecimalbox.Builder()
     *    .setId(String) // optional {@link IDecimalbox#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IDecimalbox#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IDecimalbox#getActions() actions}
     *    .setVisible(boolean) // optional {@link IDecimalbox#isVisible() visible}
     *    .setMold(String) // optional {@link IDecimalbox#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IDecimalbox#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IDecimalbox#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IDecimalbox#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IDecimalbox#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IDecimalbox#getLeft() left}
     *    .setTop(String | null) // nullable {@link IDecimalbox#getTop() top}
     *    .setZIndex(int) // optional {@link IDecimalbox#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IDecimalbox#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IDecimalbox#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IDecimalbox#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IDecimalbox#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IDecimalbox#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IDecimalbox#getStyle() style}
     *    .setDraggable(String) // optional {@link IDecimalbox#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IDecimalbox#isFocus() focus}
     *    .setDroppable(String) // optional {@link IDecimalbox#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IDecimalbox#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IDecimalbox#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IDecimalbox#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IDecimalbox#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IDecimalbox#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IDecimalbox#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IDecimalbox#getContext() context}
     *    .setPopup(String | null) // nullable {@link IDecimalbox#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IDecimalbox#getTooltip() tooltip}
     *    .setReadonly(boolean) // optional {@link IDecimalbox#isReadonly() readonly}
     *    .setName(String | null) // nullable {@link IDecimalbox#getName() name}
     *    .setPlaceholder(String | null) // nullable {@link IDecimalbox#getPlaceholder() placeholder}
     *    .setInputAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IDecimalbox#getInputAttributes() inputAttributes}
     *    .setValue(java.math.BigDecimal | null) // nullable {@link IDecimalbox#getValue() value}
     *    .setConstraint(String | null) // nullable {@link IDecimalbox#getConstraint() constraint}
     *    .setErrorboxSclass(String | null) // nullable {@link IDecimalbox#getErrorboxSclass() errorboxSclass}
     *    .setErrorboxIconSclass(String | null) // nullable {@link IDecimalbox#getErrorboxIconSclass() errorboxIconSclass}
     *    .setDisabled(boolean) // optional {@link IDecimalbox#isDisabled() disabled}
     *    .setInplace(boolean) // optional {@link IDecimalbox#isInplace() inplace}
     *    .setMaxlength(int) // optional {@link IDecimalbox#getMaxlength() maxlength}
     *    .setInstant(boolean) // optional {@link IDecimalbox#getInstant() instant}
     *    .setErrorMessage(String | null) // nullable {@link IDecimalbox#getErrorMessage() errorMessage}
     *    .setFormat(String | null) // nullable {@link IDecimalbox#getFormat() format}
     *    .setLocale(Locale | null) // nullable {@link IDecimalbox#getLocale() locale}
     *    .setCols(int) // optional {@link IDecimalbox#getCols() cols}
     *    .setRoundingMode(int) // optional {@link IDecimalbox#getRoundingMode() roundingMode}
     *    .setWidgetClass(String) // optional {@link IDecimalbox#getWidgetClass() widgetClass}
     *    .setScale(int) // optional {@link IDecimalbox#getScale() scale}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IDecimalbox.Builder)) {
        throw new UnsupportedOperationException("Use: new IDecimalbox.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IDecimalbox} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder from(IDecimalbox instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setReadonly(instance.isReadonly());
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        setName(nameValue);
      }
      @Nullable String placeholderValue = instance.getPlaceholder();
      if (placeholderValue != null) {
        setPlaceholder(placeholderValue);
      }
      @Nullable Map<String, String> inputAttributesValue = instance.getInputAttributes();
      if (inputAttributesValue != null) {
        putAllInputAttributes(inputAttributesValue);
      }
      @Nullable BigDecimal valueValue = instance.getValue();
      if (valueValue != null) {
        setValue(valueValue);
      }
      @Nullable String constraintValue = instance.getConstraint();
      if (constraintValue != null) {
        setConstraint(constraintValue);
      }
      @Nullable String errorboxSclassValue = instance.getErrorboxSclass();
      if (errorboxSclassValue != null) {
        setErrorboxSclass(errorboxSclassValue);
      }
      @Nullable String errorboxIconSclassValue = instance.getErrorboxIconSclass();
      if (errorboxIconSclassValue != null) {
        setErrorboxIconSclass(errorboxIconSclassValue);
      }
      setDisabled(instance.isDisabled());
      setInplace(instance.isInplace());
      setMaxlength(instance.getMaxlength());
      setInstant(instance.getInstant());
      @Nullable String errorMessageValue = instance.getErrorMessage();
      if (errorMessageValue != null) {
        setErrorMessage(errorMessageValue);
      }
      @Nullable String formatValue = instance.getFormat();
      if (formatValue != null) {
        setFormat(formatValue);
      }
      @Nullable Locale localeValue = instance.getLocale();
      if (localeValue != null) {
        setLocale(localeValue);
      }
      setCols(instance.getCols());
      setRoundingMode(instance.getRoundingMode());
      setWidgetClass(instance.getWidgetClass());
      setScale(instance.getScale());
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Adds one element to {@link IDecimalbox#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Adds elements to {@link IDecimalbox#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IDecimalbox.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IDecimalbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IDecimalbox.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IDecimalbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDecimalbox#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDecimalbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IDecimalbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IDecimalbox.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IDecimalbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDecimalbox#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDecimalbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IDecimalbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IDecimalbox.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IDecimalbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDecimalbox#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDecimalbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IDecimalbox#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IDecimalbox.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IDecimalbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setTop(@Nullable String top) {
      this.top = top;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setContext(@Nullable String context) {
      this.context = context;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#isReadonly() readonly} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#isReadonly() readonly}.</em>
     * @param readonly The value for readonly 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setReadonly(boolean readonly) {
      this.readonly = readonly;
      optBits |= OPT_BIT_READONLY;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setName(@Nullable String name) {
      this.name = name;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getPlaceholder() placeholder} attribute.
     * @param placeholder The value for placeholder (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setPlaceholder(@Nullable String placeholder) {
      this.placeholder = placeholder;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDecimalbox#getInputAttributes() inputAttributes} map.
     * @param key The key in the inputAttributes map
     * @param value The associated value in the inputAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder putInputAttributes(String key, String value) {
      if (this.inputAttributes == null) {
        this.inputAttributes = ImmutableMap.builder();
      }
      this.inputAttributes.put(key, value);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IDecimalbox#getInputAttributes() inputAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder putInputAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.inputAttributes == null) {
        this.inputAttributes = ImmutableMap.builder();
      }
      this.inputAttributes.put(entry);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IDecimalbox#getInputAttributes() inputAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the inputAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setInputAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.inputAttributes = null;
        return (IDecimalbox.Builder) this;
      }
      this.inputAttributes = ImmutableMap.builder();
      return putAllInputAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IDecimalbox#getInputAttributes() inputAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the inputAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder putAllInputAttributes(Map<String, ? extends String> entries) {
      if (this.inputAttributes == null) {
        this.inputAttributes = ImmutableMap.builder();
      }
      this.inputAttributes.putAll(entries);
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setValue(@Nullable BigDecimal value) {
      this.value = value;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getConstraint() constraint} attribute.
     * @param constraint The value for constraint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setConstraint(@Nullable String constraint) {
      this.constraint = constraint;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getErrorboxSclass() errorboxSclass} attribute.
     * @param errorboxSclass The value for errorboxSclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setErrorboxSclass(@Nullable String errorboxSclass) {
      this.errorboxSclass = errorboxSclass;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getErrorboxIconSclass() errorboxIconSclass} attribute.
     * @param errorboxIconSclass The value for errorboxIconSclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setErrorboxIconSclass(@Nullable String errorboxIconSclass) {
      this.errorboxIconSclass = errorboxIconSclass;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#isDisabled() disabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#isDisabled() disabled}.</em>
     * @param disabled The value for disabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setDisabled(boolean disabled) {
      this.disabled = disabled;
      optBits |= OPT_BIT_DISABLED;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#isInplace() inplace} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#isInplace() inplace}.</em>
     * @param inplace The value for inplace 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setInplace(boolean inplace) {
      this.inplace = inplace;
      optBits |= OPT_BIT_INPLACE;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getMaxlength() maxlength} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#getMaxlength() maxlength}.</em>
     * @param maxlength The value for maxlength 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setMaxlength(int maxlength) {
      this.maxlength = maxlength;
      optBits |= OPT_BIT_MAXLENGTH;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getInstant() instant} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#getInstant() instant}.</em>
     * @param instant The value for instant 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setInstant(boolean instant) {
      this.instant = instant;
      optBits |= OPT_BIT_INSTANT;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getErrorMessage() errorMessage} attribute.
     * @param errorMessage The value for errorMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setErrorMessage(@Nullable String errorMessage) {
      this.errorMessage = errorMessage;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getFormat() format} attribute.
     * @param format The value for format (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setFormat(@Nullable String format) {
      this.format = format;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getLocale() locale} attribute.
     * @param locale The value for locale (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setLocale(@Nullable Locale locale) {
      this.locale = locale;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getCols() cols} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#getCols() cols}.</em>
     * @param cols The value for cols 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setCols(int cols) {
      this.cols = cols;
      optBits |= OPT_BIT_COLS;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getRoundingMode() roundingMode} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#getRoundingMode() roundingMode}.</em>
     * @param roundingMode The value for roundingMode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setRoundingMode(int roundingMode) {
      this.roundingMode = roundingMode;
      optBits |= OPT_BIT_ROUNDING_MODE;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IDecimalbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IDecimalbox#getScale() scale} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IDecimalbox#getScale() scale}.</em>
     * @param scale The value for scale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IDecimalbox.Builder setScale(int scale) {
      this.scale = scale;
      optBits |= OPT_BIT_SCALE;
      return (IDecimalbox.Builder) this;
    }

    /**
     * Builds a new {@link IDecimalbox IDecimalbox}.
     * @return An immutable instance of IDecimalbox
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IDecimalbox build() {
      return ImmutableIDecimalbox.validate(new ImmutableIDecimalbox(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean readonlyIsSet() {
      return (optBits & OPT_BIT_READONLY) != 0;
    }

    private boolean disabledIsSet() {
      return (optBits & OPT_BIT_DISABLED) != 0;
    }

    private boolean inplaceIsSet() {
      return (optBits & OPT_BIT_INPLACE) != 0;
    }

    private boolean maxlengthIsSet() {
      return (optBits & OPT_BIT_MAXLENGTH) != 0;
    }

    private boolean instantIsSet() {
      return (optBits & OPT_BIT_INSTANT) != 0;
    }

    private boolean colsIsSet() {
      return (optBits & OPT_BIT_COLS) != 0;
    }

    private boolean roundingModeIsSet() {
      return (optBits & OPT_BIT_ROUNDING_MODE) != 0;
    }

    private boolean scaleIsSet() {
      return (optBits & OPT_BIT_SCALE) != 0;
    }
  }
}
