package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Listbox;

/**
 * Immutable implementation of {@link IListbox}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IListbox.Builder()}.
 */
@Generated(from = "IListbox", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIListbox implements IListbox {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final @Nullable String span;
  private final @Nullable IPaging pagingChild;
  private final boolean sizedByContent;
  private final boolean autopaging;
  private final String pagingPosition;
  private final boolean nativeScrollbar;
  private final ImmutableList<IListitemBase> children;
  private final String widgetClass;
  private final @Nullable IListhead listhead;
  private final @Nullable IListfoot listfoot;
  private final @Nullable IFrozen frozen;
  private final ImmutableList<IAuxhead> auxhead;
  private final int rows;
  private final @Nullable String autosort;
  private final boolean multiple;
  private final boolean checkmark;
  private final @Nullable String nonselectableTags;
  private final boolean checkmarkDeselectOther;
  private final boolean selectOnHighlightDisabled;
  private final boolean rightSelect;
  private final boolean listgroupSelectable;
  private final String innerWidth;
  private final @Nullable String oddRowSclass;
  private final ImmutableMap<String, Object> auxInfo;

  private ImmutableIListbox(ImmutableIListbox.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.span = builder.span;
    this.pagingChild = builder.pagingChild;
    this.children = builder.children.build();
    this.listhead = builder.listhead;
    this.listfoot = builder.listfoot;
    this.frozen = builder.frozen;
    this.nonselectableTags = builder.nonselectableTags;
    this.oddRowSclass = builder.oddRowSclass;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.sizedByContentIsSet()) {
      initShim.setSizedByContent(builder.sizedByContent);
    }
    if (builder.autopagingIsSet()) {
      initShim.setAutopaging(builder.autopaging);
    }
    if (builder.pagingPosition != null) {
      initShim.setPagingPosition(builder.pagingPosition);
    }
    if (builder.nativeScrollbarIsSet()) {
      initShim.setNativeScrollbar(builder.nativeScrollbar);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.auxheadIsSet()) {
      initShim.setAuxhead(builder.auxhead.build());
    }
    if (builder.rowsIsSet()) {
      initShim.setRows(builder.rows);
    }
    if (builder.autosortIsSet()) {
      initShim.setAutosort(builder.autosort);
    }
    if (builder.multipleIsSet()) {
      initShim.setMultiple(builder.multiple);
    }
    if (builder.checkmarkIsSet()) {
      initShim.setCheckmark(builder.checkmark);
    }
    if (builder.checkmarkDeselectOtherIsSet()) {
      initShim.setCheckmarkDeselectOther(builder.checkmarkDeselectOther);
    }
    if (builder.selectOnHighlightDisabledIsSet()) {
      initShim.setSelectOnHighlightDisabled(builder.selectOnHighlightDisabled);
    }
    if (builder.rightSelectIsSet()) {
      initShim.setRightSelect(builder.rightSelect);
    }
    if (builder.listgroupSelectableIsSet()) {
      initShim.setListgroupSelectable(builder.listgroupSelectable);
    }
    if (builder.innerWidth != null) {
      initShim.setInnerWidth(builder.innerWidth);
    }
    if (builder.auxInfoIsSet()) {
      initShim.setAuxInfo(builder.auxInfo.build());
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.sizedByContent = initShim.isSizedByContent();
    this.autopaging = initShim.isAutopaging();
    this.pagingPosition = initShim.getPagingPosition();
    this.nativeScrollbar = initShim.isNativeScrollbar();
    this.widgetClass = initShim.getWidgetClass();
    this.auxhead = initShim.getAuxhead();
    this.rows = initShim.getRows();
    this.autosort = initShim.getAutosort();
    this.multiple = initShim.isMultiple();
    this.checkmark = initShim.isCheckmark();
    this.checkmarkDeselectOther = initShim.isCheckmarkDeselectOther();
    this.selectOnHighlightDisabled = initShim.isSelectOnHighlightDisabled();
    this.rightSelect = initShim.isRightSelect();
    this.listgroupSelectable = initShim.isListgroupSelectable();
    this.innerWidth = initShim.getInnerWidth();
    this.auxInfo = initShim.getAuxInfo();
    this.initShim = null;
  }

  private ImmutableIListbox(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      @Nullable String span,
      @Nullable IPaging pagingChild,
      boolean sizedByContent,
      boolean autopaging,
      String pagingPosition,
      boolean nativeScrollbar,
      ImmutableList<IListitemBase> children,
      String widgetClass,
      @Nullable IListhead listhead,
      @Nullable IListfoot listfoot,
      @Nullable IFrozen frozen,
      ImmutableList<IAuxhead> auxhead,
      int rows,
      @Nullable String autosort,
      boolean multiple,
      boolean checkmark,
      @Nullable String nonselectableTags,
      boolean checkmarkDeselectOther,
      boolean selectOnHighlightDisabled,
      boolean rightSelect,
      boolean listgroupSelectable,
      String innerWidth,
      @Nullable String oddRowSclass,
      ImmutableMap<String, Object> auxInfo) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.span = span;
    this.pagingChild = pagingChild;
    this.sizedByContent = sizedByContent;
    this.autopaging = autopaging;
    this.pagingPosition = pagingPosition;
    this.nativeScrollbar = nativeScrollbar;
    this.children = children;
    this.widgetClass = widgetClass;
    this.listhead = listhead;
    this.listfoot = listfoot;
    this.frozen = frozen;
    this.auxhead = auxhead;
    this.rows = rows;
    this.autosort = autosort;
    this.multiple = multiple;
    this.checkmark = checkmark;
    this.nonselectableTags = nonselectableTags;
    this.checkmarkDeselectOther = checkmarkDeselectOther;
    this.selectOnHighlightDisabled = selectOnHighlightDisabled;
    this.rightSelect = rightSelect;
    this.listgroupSelectable = listgroupSelectable;
    this.innerWidth = innerWidth;
    this.oddRowSclass = oddRowSclass;
    this.auxInfo = auxInfo;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IListbox", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte sizedByContentBuildStage = STAGE_UNINITIALIZED;
    private boolean sizedByContent;

    boolean isSizedByContent() {
      if (sizedByContentBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sizedByContentBuildStage == STAGE_UNINITIALIZED) {
        sizedByContentBuildStage = STAGE_INITIALIZING;
        this.sizedByContent = isSizedByContentInitialize();
        sizedByContentBuildStage = STAGE_INITIALIZED;
      }
      return this.sizedByContent;
    }

    void setSizedByContent(boolean sizedByContent) {
      this.sizedByContent = sizedByContent;
      sizedByContentBuildStage = STAGE_INITIALIZED;
    }

    private byte autopagingBuildStage = STAGE_UNINITIALIZED;
    private boolean autopaging;

    boolean isAutopaging() {
      if (autopagingBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (autopagingBuildStage == STAGE_UNINITIALIZED) {
        autopagingBuildStage = STAGE_INITIALIZING;
        this.autopaging = isAutopagingInitialize();
        autopagingBuildStage = STAGE_INITIALIZED;
      }
      return this.autopaging;
    }

    void setAutopaging(boolean autopaging) {
      this.autopaging = autopaging;
      autopagingBuildStage = STAGE_INITIALIZED;
    }

    private byte pagingPositionBuildStage = STAGE_UNINITIALIZED;
    private String pagingPosition;

    String getPagingPosition() {
      if (pagingPositionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pagingPositionBuildStage == STAGE_UNINITIALIZED) {
        pagingPositionBuildStage = STAGE_INITIALIZING;
        this.pagingPosition = Objects.requireNonNull(getPagingPositionInitialize(), "pagingPosition");
        pagingPositionBuildStage = STAGE_INITIALIZED;
      }
      return this.pagingPosition;
    }

    void setPagingPosition(String pagingPosition) {
      this.pagingPosition = pagingPosition;
      pagingPositionBuildStage = STAGE_INITIALIZED;
    }

    private byte nativeScrollbarBuildStage = STAGE_UNINITIALIZED;
    private boolean nativeScrollbar;

    boolean isNativeScrollbar() {
      if (nativeScrollbarBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nativeScrollbarBuildStage == STAGE_UNINITIALIZED) {
        nativeScrollbarBuildStage = STAGE_INITIALIZING;
        this.nativeScrollbar = isNativeScrollbarInitialize();
        nativeScrollbarBuildStage = STAGE_INITIALIZED;
      }
      return this.nativeScrollbar;
    }

    void setNativeScrollbar(boolean nativeScrollbar) {
      this.nativeScrollbar = nativeScrollbar;
      nativeScrollbarBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte auxheadBuildStage = STAGE_UNINITIALIZED;
    private ImmutableList<IAuxhead> auxhead;

    ImmutableList<IAuxhead> getAuxhead() {
      if (auxheadBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (auxheadBuildStage == STAGE_UNINITIALIZED) {
        auxheadBuildStage = STAGE_INITIALIZING;
        this.auxhead = ImmutableList.copyOf(getAuxheadInitialize());
        auxheadBuildStage = STAGE_INITIALIZED;
      }
      return this.auxhead;
    }

    void setAuxhead(ImmutableList<IAuxhead> auxhead) {
      this.auxhead = auxhead;
      auxheadBuildStage = STAGE_INITIALIZED;
    }

    private byte rowsBuildStage = STAGE_UNINITIALIZED;
    private int rows;

    int getRows() {
      if (rowsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rowsBuildStage == STAGE_UNINITIALIZED) {
        rowsBuildStage = STAGE_INITIALIZING;
        this.rows = getRowsInitialize();
        rowsBuildStage = STAGE_INITIALIZED;
      }
      return this.rows;
    }

    void setRows(int rows) {
      this.rows = rows;
      rowsBuildStage = STAGE_INITIALIZED;
    }

    private byte autosortBuildStage = STAGE_UNINITIALIZED;
    private String autosort;

    String getAutosort() {
      if (autosortBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (autosortBuildStage == STAGE_UNINITIALIZED) {
        autosortBuildStage = STAGE_INITIALIZING;
        this.autosort = getAutosortInitialize();
        autosortBuildStage = STAGE_INITIALIZED;
      }
      return this.autosort;
    }

    void setAutosort(String autosort) {
      this.autosort = autosort;
      autosortBuildStage = STAGE_INITIALIZED;
    }

    private byte multipleBuildStage = STAGE_UNINITIALIZED;
    private boolean multiple;

    boolean isMultiple() {
      if (multipleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (multipleBuildStage == STAGE_UNINITIALIZED) {
        multipleBuildStage = STAGE_INITIALIZING;
        this.multiple = isMultipleInitialize();
        multipleBuildStage = STAGE_INITIALIZED;
      }
      return this.multiple;
    }

    void setMultiple(boolean multiple) {
      this.multiple = multiple;
      multipleBuildStage = STAGE_INITIALIZED;
    }

    private byte checkmarkBuildStage = STAGE_UNINITIALIZED;
    private boolean checkmark;

    boolean isCheckmark() {
      if (checkmarkBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (checkmarkBuildStage == STAGE_UNINITIALIZED) {
        checkmarkBuildStage = STAGE_INITIALIZING;
        this.checkmark = isCheckmarkInitialize();
        checkmarkBuildStage = STAGE_INITIALIZED;
      }
      return this.checkmark;
    }

    void setCheckmark(boolean checkmark) {
      this.checkmark = checkmark;
      checkmarkBuildStage = STAGE_INITIALIZED;
    }

    private byte checkmarkDeselectOtherBuildStage = STAGE_UNINITIALIZED;
    private boolean checkmarkDeselectOther;

    boolean isCheckmarkDeselectOther() {
      if (checkmarkDeselectOtherBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (checkmarkDeselectOtherBuildStage == STAGE_UNINITIALIZED) {
        checkmarkDeselectOtherBuildStage = STAGE_INITIALIZING;
        this.checkmarkDeselectOther = isCheckmarkDeselectOtherInitialize();
        checkmarkDeselectOtherBuildStage = STAGE_INITIALIZED;
      }
      return this.checkmarkDeselectOther;
    }

    void setCheckmarkDeselectOther(boolean checkmarkDeselectOther) {
      this.checkmarkDeselectOther = checkmarkDeselectOther;
      checkmarkDeselectOtherBuildStage = STAGE_INITIALIZED;
    }

    private byte selectOnHighlightDisabledBuildStage = STAGE_UNINITIALIZED;
    private boolean selectOnHighlightDisabled;

    boolean isSelectOnHighlightDisabled() {
      if (selectOnHighlightDisabledBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (selectOnHighlightDisabledBuildStage == STAGE_UNINITIALIZED) {
        selectOnHighlightDisabledBuildStage = STAGE_INITIALIZING;
        this.selectOnHighlightDisabled = isSelectOnHighlightDisabledInitialize();
        selectOnHighlightDisabledBuildStage = STAGE_INITIALIZED;
      }
      return this.selectOnHighlightDisabled;
    }

    void setSelectOnHighlightDisabled(boolean selectOnHighlightDisabled) {
      this.selectOnHighlightDisabled = selectOnHighlightDisabled;
      selectOnHighlightDisabledBuildStage = STAGE_INITIALIZED;
    }

    private byte rightSelectBuildStage = STAGE_UNINITIALIZED;
    private boolean rightSelect;

    boolean isRightSelect() {
      if (rightSelectBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rightSelectBuildStage == STAGE_UNINITIALIZED) {
        rightSelectBuildStage = STAGE_INITIALIZING;
        this.rightSelect = isRightSelectInitialize();
        rightSelectBuildStage = STAGE_INITIALIZED;
      }
      return this.rightSelect;
    }

    void setRightSelect(boolean rightSelect) {
      this.rightSelect = rightSelect;
      rightSelectBuildStage = STAGE_INITIALIZED;
    }

    private byte listgroupSelectableBuildStage = STAGE_UNINITIALIZED;
    private boolean listgroupSelectable;

    boolean isListgroupSelectable() {
      if (listgroupSelectableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (listgroupSelectableBuildStage == STAGE_UNINITIALIZED) {
        listgroupSelectableBuildStage = STAGE_INITIALIZING;
        this.listgroupSelectable = isListgroupSelectableInitialize();
        listgroupSelectableBuildStage = STAGE_INITIALIZED;
      }
      return this.listgroupSelectable;
    }

    void setListgroupSelectable(boolean listgroupSelectable) {
      this.listgroupSelectable = listgroupSelectable;
      listgroupSelectableBuildStage = STAGE_INITIALIZED;
    }

    private byte innerWidthBuildStage = STAGE_UNINITIALIZED;
    private String innerWidth;

    String getInnerWidth() {
      if (innerWidthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (innerWidthBuildStage == STAGE_UNINITIALIZED) {
        innerWidthBuildStage = STAGE_INITIALIZING;
        this.innerWidth = Objects.requireNonNull(getInnerWidthInitialize(), "innerWidth");
        innerWidthBuildStage = STAGE_INITIALIZED;
      }
      return this.innerWidth;
    }

    void setInnerWidth(String innerWidth) {
      this.innerWidth = innerWidth;
      innerWidthBuildStage = STAGE_INITIALIZED;
    }

    private byte auxInfoBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMap<String, Object> auxInfo;

    ImmutableMap<String, Object> getAuxInfo() {
      if (auxInfoBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (auxInfoBuildStage == STAGE_UNINITIALIZED) {
        auxInfoBuildStage = STAGE_INITIALIZING;
        this.auxInfo = ImmutableMap.copyOf(getAuxInfoInitialize());
        auxInfoBuildStage = STAGE_INITIALIZED;
      }
      return this.auxInfo;
    }

    void setAuxInfo(ImmutableMap<String, Object> auxInfo) {
      this.auxInfo = auxInfo;
      auxInfoBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (sizedByContentBuildStage == STAGE_INITIALIZING) attributes.add("sizedByContent");
      if (autopagingBuildStage == STAGE_INITIALIZING) attributes.add("autopaging");
      if (pagingPositionBuildStage == STAGE_INITIALIZING) attributes.add("pagingPosition");
      if (nativeScrollbarBuildStage == STAGE_INITIALIZING) attributes.add("nativeScrollbar");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (auxheadBuildStage == STAGE_INITIALIZING) attributes.add("auxhead");
      if (rowsBuildStage == STAGE_INITIALIZING) attributes.add("rows");
      if (autosortBuildStage == STAGE_INITIALIZING) attributes.add("autosort");
      if (multipleBuildStage == STAGE_INITIALIZING) attributes.add("multiple");
      if (checkmarkBuildStage == STAGE_INITIALIZING) attributes.add("checkmark");
      if (checkmarkDeselectOtherBuildStage == STAGE_INITIALIZING) attributes.add("checkmarkDeselectOther");
      if (selectOnHighlightDisabledBuildStage == STAGE_INITIALIZING) attributes.add("selectOnHighlightDisabled");
      if (rightSelectBuildStage == STAGE_INITIALIZING) attributes.add("rightSelect");
      if (listgroupSelectableBuildStage == STAGE_INITIALIZING) attributes.add("listgroupSelectable");
      if (innerWidthBuildStage == STAGE_INITIALIZING) attributes.add("innerWidth");
      if (auxInfoBuildStage == STAGE_INITIALIZING) attributes.add("auxInfo");
      return "Cannot build IListbox, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IListbox.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IListbox.super.isVisible();
  }

  private String getMoldInitialize() {
    return IListbox.super.getMold();
  }

  private int getZIndexInitialize() {
    return IListbox.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IListbox.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IListbox.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IListbox.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IListbox.super.getRenderdefer();
  }

  private boolean isSizedByContentInitialize() {
    return IListbox.super.isSizedByContent();
  }

  private boolean isAutopagingInitialize() {
    return IListbox.super.isAutopaging();
  }

  private String getPagingPositionInitialize() {
    return IListbox.super.getPagingPosition();
  }

  private boolean isNativeScrollbarInitialize() {
    return IListbox.super.isNativeScrollbar();
  }

  private String getWidgetClassInitialize() {
    return IListbox.super.getWidgetClass();
  }

  private List<IAuxhead> getAuxheadInitialize() {
    return IListbox.super.getAuxhead();
  }

  private int getRowsInitialize() {
    return IListbox.super.getRows();
  }

  private @Nullable String getAutosortInitialize() {
    return IListbox.super.getAutosort();
  }

  private boolean isMultipleInitialize() {
    return IListbox.super.isMultiple();
  }

  private boolean isCheckmarkInitialize() {
    return IListbox.super.isCheckmark();
  }

  private boolean isCheckmarkDeselectOtherInitialize() {
    return IListbox.super.isCheckmarkDeselectOther();
  }

  private boolean isSelectOnHighlightDisabledInitialize() {
    return IListbox.super.isSelectOnHighlightDisabled();
  }

  private boolean isRightSelectInitialize() {
    return IListbox.super.isRightSelect();
  }

  private boolean isListgroupSelectableInitialize() {
    return IListbox.super.isListgroupSelectable();
  }

  private String getInnerWidthInitialize() {
    return IListbox.super.getInnerWidth();
  }

  private Map<String, Object> getAuxInfoInitialize() {
    return IListbox.super.getAuxInfo();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code span} attribute
   */
  @Override
  public @Nullable String getSpan() {
    return span;
  }

  /**
   * @return The value of the {@code pagingChild} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable IPaging getPagingChild() {
    return pagingChild;
  }

  /**
   * @return The value of the {@code sizedByContent} attribute
   */
  @Override
  public boolean isSizedByContent() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSizedByContent()
        : this.sizedByContent;
  }

  /**
   * @return The value of the {@code autopaging} attribute
   */
  @Override
  public boolean isAutopaging() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isAutopaging()
        : this.autopaging;
  }

  /**
   * @return The value of the {@code pagingPosition} attribute
   */
  @Override
  public String getPagingPosition() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPagingPosition()
        : this.pagingPosition;
  }

  /**
   * @return The value of the {@code nativeScrollbar} attribute
   */
  @Override
  public boolean isNativeScrollbar() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isNativeScrollbar()
        : this.nativeScrollbar;
  }

  /**
   * @return The value of the {@code children} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableList<IListitemBase> getChildren() {
    return children;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code listhead} attribute
   */
  @Override
  public @Nullable IListhead getListhead() {
    return listhead;
  }

  /**
   * @return The value of the {@code listfoot} attribute
   */
  @Override
  public @Nullable IListfoot getListfoot() {
    return listfoot;
  }

  /**
   * @return The value of the {@code frozen} attribute
   */
  @Override
  public @Nullable IFrozen getFrozen() {
    return frozen;
  }

  /**
   * @return The value of the {@code auxhead} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableList<IAuxhead> getAuxhead() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAuxhead()
        : this.auxhead;
  }

  /**
   * @return The value of the {@code rows} attribute
   */
  @Override
  public int getRows() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRows()
        : this.rows;
  }

  /**
   * @return The value of the {@code autosort} attribute
   */
  @Override
  public @Nullable String getAutosort() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAutosort()
        : this.autosort;
  }

  /**
   * @return The value of the {@code multiple} attribute
   */
  @Override
  public boolean isMultiple() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMultiple()
        : this.multiple;
  }

  /**
   * @return The value of the {@code checkmark} attribute
   */
  @Override
  public boolean isCheckmark() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isCheckmark()
        : this.checkmark;
  }

  /**
   * @return The value of the {@code nonselectableTags} attribute
   */
  @Override
  public @Nullable String getNonselectableTags() {
    return nonselectableTags;
  }

  /**
   * @return The value of the {@code checkmarkDeselectOther} attribute
   */
  @Override
  public boolean isCheckmarkDeselectOther() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isCheckmarkDeselectOther()
        : this.checkmarkDeselectOther;
  }

  /**
   * @return The value of the {@code selectOnHighlightDisabled} attribute
   */
  @Override
  public boolean isSelectOnHighlightDisabled() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSelectOnHighlightDisabled()
        : this.selectOnHighlightDisabled;
  }

  /**
   * @return The value of the {@code rightSelect} attribute
   */
  @Override
  public boolean isRightSelect() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isRightSelect()
        : this.rightSelect;
  }

  /**
   * @return The value of the {@code listgroupSelectable} attribute
   */
  @Override
  public boolean isListgroupSelectable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isListgroupSelectable()
        : this.listgroupSelectable;
  }

  /**
   * @return The value of the {@code innerWidth} attribute
   */
  @Override
  public String getInnerWidth() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getInnerWidth()
        : this.innerWidth;
  }

  /**
   * @return The value of the {@code oddRowSclass} attribute
   */
  @Override
  public @Nullable String getOddRowSclass() {
    return oddRowSclass;
  }

  /**
   * @return The value of the {@code auxInfo} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableMap<String, Object> getAuxInfo() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAuxInfo()
        : this.auxInfo;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIListbox(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IListbox#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIListbox withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIListbox(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.span,
          this.pagingChild,
          this.sizedByContent,
          this.autopaging,
          this.pagingPosition,
          this.nativeScrollbar,
          this.children,
          this.widgetClass,
          this.listhead,
          this.listfoot,
          this.frozen,
          this.auxhead,
          this.rows,
          this.autosort,
          this.multiple,
          this.checkmark,
          this.nonselectableTags,
          this.checkmarkDeselectOther,
          this.selectOnHighlightDisabled,
          this.rightSelect,
          this.listgroupSelectable,
          this.innerWidth,
          this.oddRowSclass,
          this.auxInfo));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IListbox#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIListbox withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link IListbox#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIListbox withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link IListbox#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIListbox withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link IListbox#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIListbox withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getSpan() span} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for span (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withSpan(@Nullable String value) {
    if (Objects.equals(this.span, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        value,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getPagingChild() pagingChild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pagingChild (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withPagingChild(@Nullable IPaging value) {
    if (this.pagingChild == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        value,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#isSizedByContent() sizedByContent} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sizedByContent
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withSizedByContent(boolean value) {
    if (this.sizedByContent == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        value,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#isAutopaging() autopaging} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autopaging
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withAutopaging(boolean value) {
    if (this.autopaging == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        value,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getPagingPosition() pagingPosition} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pagingPosition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withPagingPosition(String value) {
    String newValue = Objects.requireNonNull(value, "pagingPosition");
    if (this.pagingPosition.equals(newValue)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        newValue,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#isNativeScrollbar() nativeScrollbar} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nativeScrollbar
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withNativeScrollbar(boolean value) {
    if (this.nativeScrollbar == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        value,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IListbox#getChildren() children}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIListbox withChildren(IListitemBase... elements) {
    ImmutableList<IListitemBase> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        newValue,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IListbox#getChildren() children}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of children elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIListbox withChildren(Iterable<? extends IListitemBase> elements) {
    if (this.children == elements) return this;
    ImmutableList<IListitemBase> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        newValue,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        newValue,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getListhead() listhead} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for listhead (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withListhead(@Nullable IListhead value) {
    if (this.listhead == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        value,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getListfoot() listfoot} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for listfoot (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withListfoot(@Nullable IListfoot value) {
    if (this.listfoot == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        value,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getFrozen() frozen} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for frozen (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withFrozen(@Nullable IFrozen value) {
    if (this.frozen == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        value,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IListbox#getAuxhead() auxhead}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIListbox withAuxhead(IAuxhead... elements) {
    ImmutableList<IAuxhead> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        newValue,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IListbox#getAuxhead() auxhead}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of auxhead elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIListbox withAuxhead(Iterable<? extends IAuxhead> elements) {
    if (this.auxhead == elements) return this;
    ImmutableList<IAuxhead> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        newValue,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getRows() rows} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rows
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withRows(int value) {
    if (this.rows == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        value,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getAutosort() autosort} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autosort (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withAutosort(@Nullable String value) {
    if (Objects.equals(this.autosort, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        value,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#isMultiple() multiple} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for multiple
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withMultiple(boolean value) {
    if (this.multiple == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        value,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#isCheckmark() checkmark} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for checkmark
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withCheckmark(boolean value) {
    if (this.checkmark == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        value,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getNonselectableTags() nonselectableTags} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nonselectableTags (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withNonselectableTags(@Nullable String value) {
    if (Objects.equals(this.nonselectableTags, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        value,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#isCheckmarkDeselectOther() checkmarkDeselectOther} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for checkmarkDeselectOther
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withCheckmarkDeselectOther(boolean value) {
    if (this.checkmarkDeselectOther == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        value,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#isSelectOnHighlightDisabled() selectOnHighlightDisabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for selectOnHighlightDisabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withSelectOnHighlightDisabled(boolean value) {
    if (this.selectOnHighlightDisabled == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        value,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#isRightSelect() rightSelect} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rightSelect
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withRightSelect(boolean value) {
    if (this.rightSelect == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        value,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#isListgroupSelectable() listgroupSelectable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for listgroupSelectable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withListgroupSelectable(boolean value) {
    if (this.listgroupSelectable == value) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        value,
        this.innerWidth,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getInnerWidth() innerWidth} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for innerWidth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withInnerWidth(String value) {
    String newValue = Objects.requireNonNull(value, "innerWidth");
    if (this.innerWidth.equals(newValue)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        newValue,
        this.oddRowSclass,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IListbox#getOddRowSclass() oddRowSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for oddRowSclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIListbox withOddRowSclass(@Nullable String value) {
    if (Objects.equals(this.oddRowSclass, value)) return this;
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        value,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link IListbox#getAuxInfo() auxInfo} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the auxInfo map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIListbox withAuxInfo(Map<String, ? extends Object> entries) {
    if (this.auxInfo == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new ImmutableIListbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.children,
        this.widgetClass,
        this.listhead,
        this.listfoot,
        this.frozen,
        this.auxhead,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.listgroupSelectable,
        this.innerWidth,
        this.oddRowSclass,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIListbox} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIListbox
        && equalTo((ImmutableIListbox) another);
  }

  private boolean equalTo(ImmutableIListbox another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && Objects.equals(span, another.span)
        && Objects.equals(pagingChild, another.pagingChild)
        && sizedByContent == another.sizedByContent
        && autopaging == another.autopaging
        && pagingPosition.equals(another.pagingPosition)
        && nativeScrollbar == another.nativeScrollbar
        && children.equals(another.children)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(listhead, another.listhead)
        && Objects.equals(listfoot, another.listfoot)
        && Objects.equals(frozen, another.frozen)
        && auxhead.equals(another.auxhead)
        && rows == another.rows
        && Objects.equals(autosort, another.autosort)
        && multiple == another.multiple
        && checkmark == another.checkmark
        && Objects.equals(nonselectableTags, another.nonselectableTags)
        && checkmarkDeselectOther == another.checkmarkDeselectOther
        && selectOnHighlightDisabled == another.selectOnHighlightDisabled
        && rightSelect == another.rightSelect
        && listgroupSelectable == another.listgroupSelectable
        && innerWidth.equals(another.innerWidth)
        && Objects.equals(oddRowSclass, another.oddRowSclass)
        && auxInfo.equals(another.auxInfo);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code span}, {@code pagingChild}, {@code sizedByContent}, {@code autopaging}, {@code pagingPosition}, {@code nativeScrollbar}, {@code children}, {@code widgetClass}, {@code listhead}, {@code listfoot}, {@code frozen}, {@code auxhead}, {@code rows}, {@code autosort}, {@code multiple}, {@code checkmark}, {@code nonselectableTags}, {@code checkmarkDeselectOther}, {@code selectOnHighlightDisabled}, {@code rightSelect}, {@code listgroupSelectable}, {@code innerWidth}, {@code oddRowSclass}, {@code auxInfo}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + Objects.hashCode(span);
    h += (h << 5) + Objects.hashCode(pagingChild);
    h += (h << 5) + Booleans.hashCode(sizedByContent);
    h += (h << 5) + Booleans.hashCode(autopaging);
    h += (h << 5) + pagingPosition.hashCode();
    h += (h << 5) + Booleans.hashCode(nativeScrollbar);
    h += (h << 5) + children.hashCode();
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(listhead);
    h += (h << 5) + Objects.hashCode(listfoot);
    h += (h << 5) + Objects.hashCode(frozen);
    h += (h << 5) + auxhead.hashCode();
    h += (h << 5) + rows;
    h += (h << 5) + Objects.hashCode(autosort);
    h += (h << 5) + Booleans.hashCode(multiple);
    h += (h << 5) + Booleans.hashCode(checkmark);
    h += (h << 5) + Objects.hashCode(nonselectableTags);
    h += (h << 5) + Booleans.hashCode(checkmarkDeselectOther);
    h += (h << 5) + Booleans.hashCode(selectOnHighlightDisabled);
    h += (h << 5) + Booleans.hashCode(rightSelect);
    h += (h << 5) + Booleans.hashCode(listgroupSelectable);
    h += (h << 5) + innerWidth.hashCode();
    h += (h << 5) + Objects.hashCode(oddRowSclass);
    h += (h << 5) + auxInfo.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IListbox} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IListbox")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("span", span)
        .add("pagingChild", pagingChild)
        .add("sizedByContent", sizedByContent)
        .add("autopaging", autopaging)
        .add("pagingPosition", pagingPosition)
        .add("nativeScrollbar", nativeScrollbar)
        .add("children", children)
        .add("widgetClass", widgetClass)
        .add("listhead", listhead)
        .add("listfoot", listfoot)
        .add("frozen", frozen)
        .add("auxhead", auxhead)
        .add("rows", rows)
        .add("autosort", autosort)
        .add("multiple", multiple)
        .add("checkmark", checkmark)
        .add("nonselectableTags", nonselectableTags)
        .add("checkmarkDeselectOther", checkmarkDeselectOther)
        .add("selectOnHighlightDisabled", selectOnHighlightDisabled)
        .add("rightSelect", rightSelect)
        .add("listgroupSelectable", listgroupSelectable)
        .add("innerWidth", innerWidth)
        .add("oddRowSclass", oddRowSclass)
        .add("auxInfo", auxInfo)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Listbox> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IListbox#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Listbox> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IListbox.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static final long ALL_COMPONENTS_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient List<IMeshComposite> allComponents;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IListbox#getAllComponents() allComponents} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code allComponents} attribute
   */
  @Override
  public List<IMeshComposite> getAllComponents() {
    if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
          this.allComponents = Objects.requireNonNull(IListbox.super.getAllComponents(), "allComponents");
          lazyInitBitmap |= ALL_COMPONENTS_LAZY_INIT_BIT;
        }
      }
    }
    return allComponents;
  }

  private static final long AUTOSORT_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient boolean autosort$lazy;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IListbox#isAutosort() autosort} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code autosort} attribute
   */
  @Override
  public boolean isAutosort() {
    if ((lazyInitBitmap & AUTOSORT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & AUTOSORT_LAZY_INIT_BIT) == 0) {
          this.autosort$lazy = IListbox.super.isAutosort();
          lazyInitBitmap |= AUTOSORT_LAZY_INIT_BIT;
        }
      }
    }
    return autosort$lazy;
  }

  private static ImmutableIListbox validate(ImmutableIListbox instance) {
    instance.checkVisibleRows();
    instance = (ImmutableIListbox) instance.checkMold();
    instance.checkRows();
    instance.checkPagingPosition();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIListbox) instance.checkDroppable();
    instance = (ImmutableIListbox) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IListbox} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IListbox instance
   */
  public static IListbox copyOf(IListbox instance) {
    if (instance instanceof ImmutableIListbox) {
      return (ImmutableIListbox) instance;
    }
    return new IListbox.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IListbox IListbox}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IListbox", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_SIZED_BY_CONTENT = 0x10L;
    private static final long OPT_BIT_AUTOPAGING = 0x20L;
    private static final long OPT_BIT_NATIVE_SCROLLBAR = 0x40L;
    private static final long OPT_BIT_AUXHEAD = 0x80L;
    private static final long OPT_BIT_ROWS = 0x100L;
    private static final long OPT_BIT_AUTOSORT = 0x200L;
    private static final long OPT_BIT_MULTIPLE = 0x400L;
    private static final long OPT_BIT_CHECKMARK = 0x800L;
    private static final long OPT_BIT_CHECKMARK_DESELECT_OTHER = 0x1000L;
    private static final long OPT_BIT_SELECT_ON_HIGHLIGHT_DISABLED = 0x2000L;
    private static final long OPT_BIT_RIGHT_SELECT = 0x4000L;
    private static final long OPT_BIT_LISTGROUP_SELECTABLE = 0x8000L;
    private static final long OPT_BIT_AUX_INFO = 0x10000L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable String span;
    private @Nullable IPaging pagingChild;
    private boolean sizedByContent;
    private boolean autopaging;
    private @Nullable String pagingPosition;
    private boolean nativeScrollbar;
    private ImmutableList.Builder<IListitemBase> children = ImmutableList.builder();
    private @Nullable String widgetClass;
    private @Nullable IListhead listhead;
    private @Nullable IListfoot listfoot;
    private @Nullable IFrozen frozen;
    private ImmutableList.Builder<IAuxhead> auxhead = ImmutableList.builder();
    private int rows;
    private @Nullable String autosort;
    private boolean multiple;
    private boolean checkmark;
    private @Nullable String nonselectableTags;
    private boolean checkmarkDeselectOther;
    private boolean selectOnHighlightDisabled;
    private boolean rightSelect;
    private boolean listgroupSelectable;
    private @Nullable String innerWidth;
    private @Nullable String oddRowSclass;
    private ImmutableMap.Builder<String, Object> auxInfo = ImmutableMap.builder();

    /**
     * Creates a builder for {@link IListbox IListbox} instances.
     * <pre>
     * new IListbox.Builder()
     *    .setId(String) // optional {@link IListbox#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IListbox#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IListbox#getActions() actions}
     *    .setVisible(boolean) // optional {@link IListbox#isVisible() visible}
     *    .setMold(String) // optional {@link IListbox#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IListbox#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IListbox#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IListbox#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IListbox#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IListbox#getLeft() left}
     *    .setTop(String | null) // nullable {@link IListbox#getTop() top}
     *    .setZIndex(int) // optional {@link IListbox#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IListbox#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IListbox#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IListbox#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IListbox#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IListbox#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IListbox#getStyle() style}
     *    .setDraggable(String) // optional {@link IListbox#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IListbox#isFocus() focus}
     *    .setDroppable(String) // optional {@link IListbox#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IListbox#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IListbox#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IListbox#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IListbox#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IListbox#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IListbox#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IListbox#getContext() context}
     *    .setPopup(String | null) // nullable {@link IListbox#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IListbox#getTooltip() tooltip}
     *    .setSpan(String | null) // nullable {@link IListbox#getSpan() span}
     *    .setPagingChild(org.zkoss.stateless.sul.IPaging | null) // nullable {@link IListbox#getPagingChild() pagingChild}
     *    .setSizedByContent(boolean) // optional {@link IListbox#isSizedByContent() sizedByContent}
     *    .setAutopaging(boolean) // optional {@link IListbox#isAutopaging() autopaging}
     *    .setPagingPosition(String) // optional {@link IListbox#getPagingPosition() pagingPosition}
     *    .setNativeScrollbar(boolean) // optional {@link IListbox#isNativeScrollbar() nativeScrollbar}
     *    .addChildren|addAllChildren(org.zkoss.stateless.sul.IListitemBase) // {@link IListbox#getChildren() children} elements
     *    .setWidgetClass(String) // optional {@link IListbox#getWidgetClass() widgetClass}
     *    .setListhead(org.zkoss.stateless.sul.IListhead | null) // nullable {@link IListbox#getListhead() listhead}
     *    .setListfoot(org.zkoss.stateless.sul.IListfoot | null) // nullable {@link IListbox#getListfoot() listfoot}
     *    .setFrozen(org.zkoss.stateless.sul.IFrozen | null) // nullable {@link IListbox#getFrozen() frozen}
     *    .addAuxhead|addAllAuxhead(org.zkoss.stateless.sul.IAuxhead) // {@link IListbox#getAuxhead() auxhead} elements
     *    .setRows(int) // optional {@link IListbox#getRows() rows}
     *    .setAutosort(String | null) // nullable {@link IListbox#getAutosort() autosort}
     *    .setMultiple(boolean) // optional {@link IListbox#isMultiple() multiple}
     *    .setCheckmark(boolean) // optional {@link IListbox#isCheckmark() checkmark}
     *    .setNonselectableTags(String | null) // nullable {@link IListbox#getNonselectableTags() nonselectableTags}
     *    .setCheckmarkDeselectOther(boolean) // optional {@link IListbox#isCheckmarkDeselectOther() checkmarkDeselectOther}
     *    .setSelectOnHighlightDisabled(boolean) // optional {@link IListbox#isSelectOnHighlightDisabled() selectOnHighlightDisabled}
     *    .setRightSelect(boolean) // optional {@link IListbox#isRightSelect() rightSelect}
     *    .setListgroupSelectable(boolean) // optional {@link IListbox#isListgroupSelectable() listgroupSelectable}
     *    .setInnerWidth(String) // optional {@link IListbox#getInnerWidth() innerWidth}
     *    .setOddRowSclass(String | null) // nullable {@link IListbox#getOddRowSclass() oddRowSclass}
     *    .putAuxInfo|putAllAuxInfo(String =&gt; Object) // {@link IListbox#getAuxInfo() auxInfo} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IListbox.Builder)) {
        throw new UnsupportedOperationException("Use: new IListbox.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IListbox} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder from(IListbox instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      @Nullable String spanValue = instance.getSpan();
      if (spanValue != null) {
        setSpan(spanValue);
      }
      @Nullable IPaging pagingChildValue = instance.getPagingChild();
      if (pagingChildValue != null) {
        setPagingChild(pagingChildValue);
      }
      setSizedByContent(instance.isSizedByContent());
      setAutopaging(instance.isAutopaging());
      setPagingPosition(instance.getPagingPosition());
      setNativeScrollbar(instance.isNativeScrollbar());
      addAllChildren(instance.getChildren());
      setWidgetClass(instance.getWidgetClass());
      @Nullable IListhead listheadValue = instance.getListhead();
      if (listheadValue != null) {
        setListhead(listheadValue);
      }
      @Nullable IListfoot listfootValue = instance.getListfoot();
      if (listfootValue != null) {
        setListfoot(listfootValue);
      }
      @Nullable IFrozen frozenValue = instance.getFrozen();
      if (frozenValue != null) {
        setFrozen(frozenValue);
      }
      addAllAuxhead(instance.getAuxhead());
      setRows(instance.getRows());
      @Nullable String autosortValue = instance.getAutosort();
      if (autosortValue != null) {
        setAutosort(autosortValue);
      }
      setMultiple(instance.isMultiple());
      setCheckmark(instance.isCheckmark());
      @Nullable String nonselectableTagsValue = instance.getNonselectableTags();
      if (nonselectableTagsValue != null) {
        setNonselectableTags(nonselectableTagsValue);
      }
      setCheckmarkDeselectOther(instance.isCheckmarkDeselectOther());
      setSelectOnHighlightDisabled(instance.isSelectOnHighlightDisabled());
      setRightSelect(instance.isRightSelect());
      setListgroupSelectable(instance.isListgroupSelectable());
      setInnerWidth(instance.getInnerWidth());
      @Nullable String oddRowSclassValue = instance.getOddRowSclass();
      if (oddRowSclassValue != null) {
        setOddRowSclass(oddRowSclassValue);
      }
      putAllAuxInfo(instance.getAuxInfo());
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IListbox.Builder) this;
    }

    /**
     * Adds one element to {@link IListbox#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IListbox.Builder) this;
    }

    /**
     * Adds elements to {@link IListbox#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IListbox.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IListbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IListbox.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IListbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IListbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IListbox#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IListbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IListbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IListbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IListbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IListbox.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IListbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IListbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IListbox#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IListbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IListbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IListbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IListbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IListbox.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IListbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IListbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IListbox#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IListbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IListbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IListbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IListbox#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IListbox.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IListbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setTop(@Nullable String top) {
      this.top = top;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setContext(@Nullable String context) {
      this.context = context;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getSpan() span} attribute.
     * @param span The value for span (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setSpan(@Nullable String span) {
      this.span = span;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getPagingChild() pagingChild} attribute.
     * @param pagingChild The value for pagingChild (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setPagingChild(@Nullable IPaging pagingChild) {
      this.pagingChild = pagingChild;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#isSizedByContent() sizedByContent} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#isSizedByContent() sizedByContent}.</em>
     * @param sizedByContent The value for sizedByContent 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setSizedByContent(boolean sizedByContent) {
      this.sizedByContent = sizedByContent;
      optBits |= OPT_BIT_SIZED_BY_CONTENT;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#isAutopaging() autopaging} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#isAutopaging() autopaging}.</em>
     * @param autopaging The value for autopaging 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setAutopaging(boolean autopaging) {
      this.autopaging = autopaging;
      optBits |= OPT_BIT_AUTOPAGING;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getPagingPosition() pagingPosition} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#getPagingPosition() pagingPosition}.</em>
     * @param pagingPosition The value for pagingPosition 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setPagingPosition(String pagingPosition) {
      this.pagingPosition = Objects.requireNonNull(pagingPosition, "pagingPosition");
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#isNativeScrollbar() nativeScrollbar} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#isNativeScrollbar() nativeScrollbar}.</em>
     * @param nativeScrollbar The value for nativeScrollbar 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setNativeScrollbar(boolean nativeScrollbar) {
      this.nativeScrollbar = nativeScrollbar;
      optBits |= OPT_BIT_NATIVE_SCROLLBAR;
      return (IListbox.Builder) this;
    }

    /**
     * Adds one element to {@link IListbox#getChildren() children} list.
     * @param element A children element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder addChildren(IListitemBase element) {
      this.children.add(element);
      return (IListbox.Builder) this;
    }

    /**
     * Adds elements to {@link IListbox#getChildren() children} list.
     * @param elements An array of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder addChildren(IListitemBase... elements) {
      this.children.add(elements);
      return (IListbox.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IListbox#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setChildren(Iterable<? extends IListitemBase> elements) {
      this.children = ImmutableList.builder();
      return addAllChildren(elements);
    }

    /**
     * Adds elements to {@link IListbox#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder addAllChildren(Iterable<? extends IListitemBase> elements) {
      this.children.addAll(elements);
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getListhead() listhead} attribute.
     * @param listhead The value for listhead (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setListhead(@Nullable IListhead listhead) {
      this.listhead = listhead;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getListfoot() listfoot} attribute.
     * @param listfoot The value for listfoot (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setListfoot(@Nullable IListfoot listfoot) {
      this.listfoot = listfoot;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getFrozen() frozen} attribute.
     * @param frozen The value for frozen (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setFrozen(@Nullable IFrozen frozen) {
      this.frozen = frozen;
      return (IListbox.Builder) this;
    }

    /**
     * Adds one element to {@link IListbox#getAuxhead() auxhead} list.
     * @param element A auxhead element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder addAuxhead(IAuxhead element) {
      this.auxhead.add(element);
      optBits |= OPT_BIT_AUXHEAD;
      return (IListbox.Builder) this;
    }

    /**
     * Adds elements to {@link IListbox#getAuxhead() auxhead} list.
     * @param elements An array of auxhead elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder addAuxhead(IAuxhead... elements) {
      this.auxhead.add(elements);
      optBits |= OPT_BIT_AUXHEAD;
      return (IListbox.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IListbox#getAuxhead() auxhead} list.
     * @param elements An iterable of auxhead elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setAuxhead(Iterable<? extends IAuxhead> elements) {
      this.auxhead = ImmutableList.builder();
      return addAllAuxhead(elements);
    }

    /**
     * Adds elements to {@link IListbox#getAuxhead() auxhead} list.
     * @param elements An iterable of auxhead elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder addAllAuxhead(Iterable<? extends IAuxhead> elements) {
      this.auxhead.addAll(elements);
      optBits |= OPT_BIT_AUXHEAD;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getRows() rows} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#getRows() rows}.</em>
     * @param rows The value for rows 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setRows(int rows) {
      this.rows = rows;
      optBits |= OPT_BIT_ROWS;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getAutosort() autosort} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#getAutosort() autosort}.</em>
     * @param autosort The value for autosort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setAutosort(@Nullable String autosort) {
      this.autosort = autosort;
      optBits |= OPT_BIT_AUTOSORT;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#isMultiple() multiple} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#isMultiple() multiple}.</em>
     * @param multiple The value for multiple 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setMultiple(boolean multiple) {
      this.multiple = multiple;
      optBits |= OPT_BIT_MULTIPLE;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#isCheckmark() checkmark} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#isCheckmark() checkmark}.</em>
     * @param checkmark The value for checkmark 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setCheckmark(boolean checkmark) {
      this.checkmark = checkmark;
      optBits |= OPT_BIT_CHECKMARK;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getNonselectableTags() nonselectableTags} attribute.
     * @param nonselectableTags The value for nonselectableTags (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setNonselectableTags(@Nullable String nonselectableTags) {
      this.nonselectableTags = nonselectableTags;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#isCheckmarkDeselectOther() checkmarkDeselectOther} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#isCheckmarkDeselectOther() checkmarkDeselectOther}.</em>
     * @param checkmarkDeselectOther The value for checkmarkDeselectOther 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setCheckmarkDeselectOther(boolean checkmarkDeselectOther) {
      this.checkmarkDeselectOther = checkmarkDeselectOther;
      optBits |= OPT_BIT_CHECKMARK_DESELECT_OTHER;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#isSelectOnHighlightDisabled() selectOnHighlightDisabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#isSelectOnHighlightDisabled() selectOnHighlightDisabled}.</em>
     * @param selectOnHighlightDisabled The value for selectOnHighlightDisabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setSelectOnHighlightDisabled(boolean selectOnHighlightDisabled) {
      this.selectOnHighlightDisabled = selectOnHighlightDisabled;
      optBits |= OPT_BIT_SELECT_ON_HIGHLIGHT_DISABLED;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#isRightSelect() rightSelect} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#isRightSelect() rightSelect}.</em>
     * @param rightSelect The value for rightSelect 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setRightSelect(boolean rightSelect) {
      this.rightSelect = rightSelect;
      optBits |= OPT_BIT_RIGHT_SELECT;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#isListgroupSelectable() listgroupSelectable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#isListgroupSelectable() listgroupSelectable}.</em>
     * @param listgroupSelectable The value for listgroupSelectable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setListgroupSelectable(boolean listgroupSelectable) {
      this.listgroupSelectable = listgroupSelectable;
      optBits |= OPT_BIT_LISTGROUP_SELECTABLE;
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getInnerWidth() innerWidth} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IListbox#getInnerWidth() innerWidth}.</em>
     * @param innerWidth The value for innerWidth 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setInnerWidth(String innerWidth) {
      this.innerWidth = Objects.requireNonNull(innerWidth, "innerWidth");
      return (IListbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IListbox#getOddRowSclass() oddRowSclass} attribute.
     * @param oddRowSclass The value for oddRowSclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setOddRowSclass(@Nullable String oddRowSclass) {
      this.oddRowSclass = oddRowSclass;
      return (IListbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IListbox#getAuxInfo() auxInfo} map.
     * @param key The key in the auxInfo map
     * @param value The associated value in the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder putAuxInfo(String key, Object value) {
      this.auxInfo.put(key, value);
      optBits |= OPT_BIT_AUX_INFO;
      return (IListbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IListbox#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder putAuxInfo(Map.Entry<String, ? extends Object> entry) {
      this.auxInfo.put(entry);
      optBits |= OPT_BIT_AUX_INFO;
      return (IListbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IListbox#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder setAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo = ImmutableMap.builder();
      optBits |= OPT_BIT_AUX_INFO;
      return putAllAuxInfo(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IListbox#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IListbox.Builder putAllAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo.putAll(entries);
      optBits |= OPT_BIT_AUX_INFO;
      return (IListbox.Builder) this;
    }

    /**
     * Builds a new {@link IListbox IListbox}.
     * @return An immutable instance of IListbox
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IListbox build() {
      return ImmutableIListbox.validate(new ImmutableIListbox(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean sizedByContentIsSet() {
      return (optBits & OPT_BIT_SIZED_BY_CONTENT) != 0;
    }

    private boolean autopagingIsSet() {
      return (optBits & OPT_BIT_AUTOPAGING) != 0;
    }

    private boolean nativeScrollbarIsSet() {
      return (optBits & OPT_BIT_NATIVE_SCROLLBAR) != 0;
    }

    private boolean auxheadIsSet() {
      return (optBits & OPT_BIT_AUXHEAD) != 0;
    }

    private boolean rowsIsSet() {
      return (optBits & OPT_BIT_ROWS) != 0;
    }

    private boolean autosortIsSet() {
      return (optBits & OPT_BIT_AUTOSORT) != 0;
    }

    private boolean multipleIsSet() {
      return (optBits & OPT_BIT_MULTIPLE) != 0;
    }

    private boolean checkmarkIsSet() {
      return (optBits & OPT_BIT_CHECKMARK) != 0;
    }

    private boolean checkmarkDeselectOtherIsSet() {
      return (optBits & OPT_BIT_CHECKMARK_DESELECT_OTHER) != 0;
    }

    private boolean selectOnHighlightDisabledIsSet() {
      return (optBits & OPT_BIT_SELECT_ON_HIGHLIGHT_DISABLED) != 0;
    }

    private boolean rightSelectIsSet() {
      return (optBits & OPT_BIT_RIGHT_SELECT) != 0;
    }

    private boolean listgroupSelectableIsSet() {
      return (optBits & OPT_BIT_LISTGROUP_SELECTABLE) != 0;
    }

    private boolean auxInfoIsSet() {
      return (optBits & OPT_BIT_AUX_INFO) != 0;
    }
  }
}
