package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Row;

/**
 * Immutable implementation of {@link IRow}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IRow.Builder()}.
 */
@Generated(from = "IRow", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIRow<I extends IAnyGroup>
    implements IRow<I> {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final @Nullable String align;
  private final @Nullable String valign;
  private final boolean nowrap;
  private final boolean loaded;
  private final int index;
  private final ImmutableList<I> children;
  private final String widgetClass;
  private transient final @Nullable String width;
  private transient final @Nullable String hflex;
  private final @Nullable IDetailChild<? extends IDetailChild> detailChild;

  private ImmutableIRow(ImmutableIRow.Builder<I> builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.align = builder.align;
    this.valign = builder.valign;
    this.children = builder.children.build();
    this.detailChild = builder.detailChild;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.nowrapIsSet()) {
      initShim.setNowrap(builder.nowrap);
    }
    if (builder.loadedIsSet()) {
      initShim.setLoaded(builder.loaded);
    }
    if (builder.indexIsSet()) {
      initShim.setIndex(builder.index);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.nowrap = initShim.isNowrap();
    this.loaded = initShim.isLoaded();
    this.index = initShim.getIndex();
    this.widgetClass = initShim.getWidgetClass();
    this.width = initShim.getWidth();
    this.hflex = initShim.getHflex();
    this.initShim = null;
  }

  private ImmutableIRow(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      @Nullable String align,
      @Nullable String valign,
      boolean nowrap,
      boolean loaded,
      int index,
      ImmutableList<I> children,
      String widgetClass,
      @Nullable IDetailChild<? extends IDetailChild> detailChild) {
    initShim.setId(id);
    this.action = action;
    this.actions = actions;
    initShim.setVisible(visible);
    initShim.setMold(mold);
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    initShim.setZIndex(zIndex);
    this.height = height;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    initShim.setDraggable(draggable);
    initShim.setFocus(focus);
    initShim.setDroppable(droppable);
    this.vflex = vflex;
    initShim.setRenderdefer(renderdefer);
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.align = align;
    this.valign = valign;
    initShim.setNowrap(nowrap);
    initShim.setLoaded(loaded);
    initShim.setIndex(index);
    this.children = children;
    initShim.setWidgetClass(widgetClass);
    this.detailChild = detailChild;
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.nowrap = initShim.isNowrap();
    this.loaded = initShim.isLoaded();
    this.index = initShim.getIndex();
    this.widgetClass = initShim.getWidgetClass();
    this.width = initShim.getWidth();
    this.hflex = initShim.getHflex();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IRow", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte nowrapBuildStage = STAGE_UNINITIALIZED;
    private boolean nowrap;

    boolean isNowrap() {
      if (nowrapBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nowrapBuildStage == STAGE_UNINITIALIZED) {
        nowrapBuildStage = STAGE_INITIALIZING;
        this.nowrap = isNowrapInitialize();
        nowrapBuildStage = STAGE_INITIALIZED;
      }
      return this.nowrap;
    }

    void setNowrap(boolean nowrap) {
      this.nowrap = nowrap;
      nowrapBuildStage = STAGE_INITIALIZED;
    }

    private byte loadedBuildStage = STAGE_UNINITIALIZED;
    private boolean loaded;

    boolean isLoaded() {
      if (loadedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (loadedBuildStage == STAGE_UNINITIALIZED) {
        loadedBuildStage = STAGE_INITIALIZING;
        this.loaded = isLoadedInitialize();
        loadedBuildStage = STAGE_INITIALIZED;
      }
      return this.loaded;
    }

    void setLoaded(boolean loaded) {
      this.loaded = loaded;
      loadedBuildStage = STAGE_INITIALIZED;
    }

    private byte indexBuildStage = STAGE_UNINITIALIZED;
    private int index;

    int getIndex() {
      if (indexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (indexBuildStage == STAGE_UNINITIALIZED) {
        indexBuildStage = STAGE_INITIALIZING;
        this.index = getIndexInitialize();
        indexBuildStage = STAGE_INITIALIZED;
      }
      return this.index;
    }

    void setIndex(int index) {
      this.index = index;
      indexBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte widthBuildStage = STAGE_UNINITIALIZED;
    private String width;

    String getWidth() {
      if (widthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widthBuildStage == STAGE_UNINITIALIZED) {
        widthBuildStage = STAGE_INITIALIZING;
        this.width = getWidthInitialize();
        widthBuildStage = STAGE_INITIALIZED;
      }
      return this.width;
    }

    private byte hflexBuildStage = STAGE_UNINITIALIZED;
    private String hflex;

    String getHflex() {
      if (hflexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (hflexBuildStage == STAGE_UNINITIALIZED) {
        hflexBuildStage = STAGE_INITIALIZING;
        this.hflex = getHflexInitialize();
        hflexBuildStage = STAGE_INITIALIZED;
      }
      return this.hflex;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (nowrapBuildStage == STAGE_INITIALIZING) attributes.add("nowrap");
      if (loadedBuildStage == STAGE_INITIALIZING) attributes.add("loaded");
      if (indexBuildStage == STAGE_INITIALIZING) attributes.add("index");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (widthBuildStage == STAGE_INITIALIZING) attributes.add("width");
      if (hflexBuildStage == STAGE_INITIALIZING) attributes.add("hflex");
      return "Cannot build IRow, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IRow.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IRow.super.isVisible();
  }

  private String getMoldInitialize() {
    return IRow.super.getMold();
  }

  private int getZIndexInitialize() {
    return IRow.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IRow.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IRow.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IRow.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IRow.super.getRenderdefer();
  }

  private boolean isNowrapInitialize() {
    return IRow.super.isNowrap();
  }

  private boolean isLoadedInitialize() {
    return IRow.super.isLoaded();
  }

  private int getIndexInitialize() {
    return IRow.super.getIndex();
  }

  private String getWidgetClassInitialize() {
    return IRow.super.getWidgetClass();
  }

  private @Nullable String getWidthInitialize() {
    return IRow.super.getWidth();
  }

  private @Nullable String getHflexInitialize() {
    return IRow.super.getHflex();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code align} attribute
   */
  @Override
  public @Nullable String getAlign() {
    return align;
  }

  /**
   * @return The value of the {@code valign} attribute
   */
  @Override
  public @Nullable String getValign() {
    return valign;
  }

  /**
   * @return The value of the {@code nowrap} attribute
   */
  @Override
  public boolean isNowrap() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isNowrap()
        : this.nowrap;
  }

  /**
   * @return The value of the {@code loaded} attribute
   */
  @Override
  public boolean isLoaded() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isLoaded()
        : this.loaded;
  }

  /**
   * @return The value of the {@code index} attribute
   */
  @Override
  public int getIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getIndex()
        : this.index;
  }

  /**
   * @return The value of the {@code children} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableList<I> getChildren() {
    return children;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The computed-at-construction value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidth()
        : this.width;
  }

  /**
   * @return The computed-at-construction value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHflex()
        : this.hflex;
  }

  /**
   * @return The value of the {@code detailChild} attribute
   */
  @Override
  public @Nullable IDetailChild<? extends IDetailChild> getDetailChild() {
    return detailChild;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIRow<>(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IRow#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIRow<I> withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIRow<>(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.align,
          this.valign,
          this.nowrap,
          this.loaded,
          this.index,
          this.children,
          this.widgetClass,
          this.detailChild));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IRow#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIRow<I> withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by replacing the {@link IRow#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIRow<I> withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by replacing the {@link IRow#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIRow<I> withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by replacing the {@link IRow#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIRow<I> withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getAlign() align} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for align (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withAlign(@Nullable String value) {
    if (Objects.equals(this.align, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        value,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getValign() valign} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valign (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withValign(@Nullable String value) {
    if (Objects.equals(this.valign, value)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        value,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#isNowrap() nowrap} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nowrap
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withNowrap(boolean value) {
    if (this.nowrap == value) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        value,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#isLoaded() loaded} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for loaded
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withLoaded(boolean value) {
    if (this.loaded == value) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        value,
        this.index,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getIndex() index} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for index
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withIndex(int value) {
    if (this.index == value) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        value,
        this.children,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IRow#getChildren() children}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableIRow<I> withChildren(I... elements) {
    ImmutableList<I> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        newValue,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IRow#getChildren() children}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of children elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIRow<I> withChildren(Iterable<? extends I> elements) {
    if (this.children == elements) return this;
    ImmutableList<I> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        newValue,
        this.widgetClass,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        newValue,
        this.detailChild));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IRow#getDetailChild() detailChild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for detailChild (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIRow<I> withDetailChild(@Nullable IDetailChild<? extends IDetailChild> value) {
    if (this.detailChild == value) return this;
    return validate(new ImmutableIRow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.align,
        this.valign,
        this.nowrap,
        this.loaded,
        this.index,
        this.children,
        this.widgetClass,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIRow} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIRow<?>
        && equalTo((ImmutableIRow<?>) another);
  }

  private boolean equalTo(ImmutableIRow<?> another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && Objects.equals(align, another.align)
        && Objects.equals(valign, another.valign)
        && nowrap == another.nowrap
        && loaded == another.loaded
        && index == another.index
        && children.equals(another.children)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(width, another.width)
        && Objects.equals(hflex, another.hflex)
        && Objects.equals(detailChild, another.detailChild);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code align}, {@code valign}, {@code nowrap}, {@code loaded}, {@code index}, {@code children}, {@code widgetClass}, {@code width}, {@code hflex}, {@code detailChild}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + Objects.hashCode(align);
    h += (h << 5) + Objects.hashCode(valign);
    h += (h << 5) + Booleans.hashCode(nowrap);
    h += (h << 5) + Booleans.hashCode(loaded);
    h += (h << 5) + index;
    h += (h << 5) + children.hashCode();
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + Objects.hashCode(detailChild);
    return h;
  }

  /**
   * Prints the immutable value {@code IRow} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IRow")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("align", align)
        .add("valign", valign)
        .add("nowrap", nowrap)
        .add("loaded", loaded)
        .add("index", index)
        .add("children", children)
        .add("widgetClass", widgetClass)
        .add("width", width)
        .add("hflex", hflex)
        .add("detailChild", detailChild)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Row> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IRow#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Row> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IRow.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static final long ALL_COMPONENTS_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient List<IComponent> allComponents;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IRow#getAllComponents() allComponents} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code allComponents} attribute
   */
  @Override
  public List<IComponent> getAllComponents() {
    if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
          this.allComponents = Objects.requireNonNull(IRow.super.getAllComponents(), "allComponents");
          lazyInitBitmap |= ALL_COMPONENTS_LAZY_INIT_BIT;
        }
      }
    }
    return allComponents;
  }

  private static <I extends IAnyGroup> ImmutableIRow<I> validate(ImmutableIRow<I> instance) {
    instance.checkDetailChild();
    instance.check();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIRow<I>) instance.checkDroppable();
    instance = (ImmutableIRow<I>) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IRow} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <I> generic parameter I
   * @param instance The instance to copy
   * @return A copied immutable IRow instance
   */
  public static <I extends IAnyGroup> IRow<I> copyOf(IRow<I> instance) {
    if (instance instanceof ImmutableIRow<?>) {
      return (ImmutableIRow<I>) instance;
    }
    return new IRow.Builder<I>()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IRow IRow}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IRow", generator = "Immutables")
  @NotThreadSafe
  public static class Builder<I extends IAnyGroup> {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_NOWRAP = 0x10L;
    private static final long OPT_BIT_LOADED = 0x20L;
    private static final long OPT_BIT_INDEX = 0x40L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable String align;
    private @Nullable String valign;
    private boolean nowrap;
    private boolean loaded;
    private int index;
    private ImmutableList.Builder<I> children = ImmutableList.builder();
    private @Nullable String widgetClass;
    private @Nullable IDetailChild<? extends IDetailChild> detailChild;

    /**
     * Creates a builder for {@link IRow IRow} instances.
     * <pre>
     * new IRow.Builder&amp;lt;I&amp;gt;()
     *    .setId(String) // optional {@link IRow#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IRow#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IRow#getActions() actions}
     *    .setVisible(boolean) // optional {@link IRow#isVisible() visible}
     *    .setMold(String) // optional {@link IRow#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IRow#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IRow#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IRow#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IRow#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IRow#getLeft() left}
     *    .setTop(String | null) // nullable {@link IRow#getTop() top}
     *    .setZIndex(int) // optional {@link IRow#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IRow#getHeight() height}
     *    .setTooltiptext(String | null) // nullable {@link IRow#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IRow#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IRow#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IRow#getStyle() style}
     *    .setDraggable(String) // optional {@link IRow#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IRow#isFocus() focus}
     *    .setDroppable(String) // optional {@link IRow#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IRow#getVflex() vflex}
     *    .setRenderdefer(int) // optional {@link IRow#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IRow#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IRow#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IRow#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IRow#getContext() context}
     *    .setPopup(String | null) // nullable {@link IRow#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IRow#getTooltip() tooltip}
     *    .setAlign(String | null) // nullable {@link IRow#getAlign() align}
     *    .setValign(String | null) // nullable {@link IRow#getValign() valign}
     *    .setNowrap(boolean) // optional {@link IRow#isNowrap() nowrap}
     *    .setLoaded(boolean) // optional {@link IRow#isLoaded() loaded}
     *    .setIndex(int) // optional {@link IRow#getIndex() index}
     *    .addChildren|addAllChildren(I) // {@link IRow#getChildren() children} elements
     *    .setWidgetClass(String) // optional {@link IRow#getWidgetClass() widgetClass}
     *    .setDetailChild(org.zkoss.stateless.sul.IDetailChild&amp;lt;? extends org.zkoss.stateless.sul.IDetailChild&amp;gt; | null) // nullable {@link IRow#getDetailChild() detailChild}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IRow.Builder<?>)) {
        throw new UnsupportedOperationException("Use: new IRow.Builder<I>()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IRow} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> from(IRow<I> instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      @Nullable String alignValue = instance.getAlign();
      if (alignValue != null) {
        setAlign(alignValue);
      }
      @Nullable String valignValue = instance.getValign();
      if (valignValue != null) {
        setValign(valignValue);
      }
      setNowrap(instance.isNowrap());
      setLoaded(instance.isLoaded());
      setIndex(instance.getIndex());
      addAllChildren(instance.getChildren());
      setWidgetClass(instance.getWidgetClass());
      @Nullable IDetailChild<? extends IDetailChild> detailChildValue = instance.getDetailChild();
      if (detailChildValue != null) {
        setDetailChild(detailChildValue);
      }
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IRow#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IRow.Builder<I>) this;
    }

    /**
     * Adds one element to {@link IRow#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IRow.Builder<I>) this;
    }

    /**
     * Adds elements to {@link IRow#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IRow.Builder<I>) this;
    }


    /**
     * Sets or replaces all elements for {@link IRow#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IRow.Builder<I>) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IRow#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IRow#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IRow#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IRow.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IRow#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IRow.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IRow#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IRow.Builder<I>) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IRow#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IRow.Builder<I>) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IRow#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IRow.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IRow#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IRow.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IRow#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IRow.Builder<I>) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IRow#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IRow.Builder<I>) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IRow#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IRow.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IRow#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IRow.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IRow#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IRow.Builder<I>) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IRow#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IRow.Builder<I>) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IRow#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setLeft(@Nullable String left) {
      this.left = left;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setTop(@Nullable String top) {
      this.top = top;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IRow#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setHeight(@Nullable String height) {
      this.height = height;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setStyle(@Nullable String style) {
      this.style = style;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IRow#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IRow#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IRow#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IRow#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setContext(@Nullable String context) {
      this.context = context;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getAlign() align} attribute.
     * @param align The value for align (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setAlign(@Nullable String align) {
      this.align = align;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getValign() valign} attribute.
     * @param valign The value for valign (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setValign(@Nullable String valign) {
      this.valign = valign;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#isNowrap() nowrap} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IRow#isNowrap() nowrap}.</em>
     * @param nowrap The value for nowrap 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setNowrap(boolean nowrap) {
      this.nowrap = nowrap;
      optBits |= OPT_BIT_NOWRAP;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#isLoaded() loaded} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IRow#isLoaded() loaded}.</em>
     * @param loaded The value for loaded 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setLoaded(boolean loaded) {
      this.loaded = loaded;
      optBits |= OPT_BIT_LOADED;
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getIndex() index} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IRow#getIndex() index}.</em>
     * @param index The value for index 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setIndex(int index) {
      this.index = index;
      optBits |= OPT_BIT_INDEX;
      return (IRow.Builder<I>) this;
    }

    /**
     * Adds one element to {@link IRow#getChildren() children} list.
     * @param element A children element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> addChildren(I element) {
      this.children.add(element);
      return (IRow.Builder<I>) this;
    }

    /**
     * Adds elements to {@link IRow#getChildren() children} list.
     * @param elements An array of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final IRow.Builder<I> addChildren(I... elements) {
      this.children.add(elements);
      return (IRow.Builder<I>) this;
    }


    /**
     * Sets or replaces all elements for {@link IRow#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setChildren(Iterable<? extends I> elements) {
      this.children = ImmutableList.builder();
      return addAllChildren(elements);
    }

    /**
     * Adds elements to {@link IRow#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> addAllChildren(Iterable<? extends I> elements) {
      this.children.addAll(elements);
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IRow#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IRow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IRow#getDetailChild() detailChild} attribute.
     * @param detailChild The value for detailChild (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IRow.Builder<I> setDetailChild(@Nullable IDetailChild<? extends IDetailChild> detailChild) {
      this.detailChild = detailChild;
      return (IRow.Builder<I>) this;
    }

    /**
     * Builds a new {@link IRow IRow}.
     * @return An immutable instance of IRow
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IRow<I> build() {
      return ImmutableIRow.validate(new ImmutableIRow<I>(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean nowrapIsSet() {
      return (optBits & OPT_BIT_NOWRAP) != 0;
    }

    private boolean loadedIsSet() {
      return (optBits & OPT_BIT_LOADED) != 0;
    }

    private boolean indexIsSet() {
      return (optBits & OPT_BIT_INDEX) != 0;
    }
  }
}
