package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zkmax.zul.Signature;

/**
 * Immutable implementation of {@link ISignature}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ISignature.Builder()}.
 */
@Generated(from = "ISignature", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableISignature implements ISignature {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final String widgetClass;
  private final @Nullable String backgroundImage;
  private final @Nullable String undoLabel;
  private final @Nullable String saveLabel;
  private final @Nullable String clearLabel;
  private final int penSize;
  private final String penColor;
  private final String backgroundColor;
  private final String saveType;
  private final boolean backgroundIncluded;
  private final boolean toolbarVisible;

  private ImmutableISignature(ImmutableISignature.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.backgroundImage = builder.backgroundImage;
    this.undoLabel = builder.undoLabel;
    this.saveLabel = builder.saveLabel;
    this.clearLabel = builder.clearLabel;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.penSizeIsSet()) {
      initShim.setPenSize(builder.penSize);
    }
    if (builder.penColor != null) {
      initShim.setPenColor(builder.penColor);
    }
    if (builder.backgroundColor != null) {
      initShim.setBackgroundColor(builder.backgroundColor);
    }
    if (builder.saveType != null) {
      initShim.setSaveType(builder.saveType);
    }
    if (builder.backgroundIncludedIsSet()) {
      initShim.setBackgroundIncluded(builder.backgroundIncluded);
    }
    if (builder.toolbarVisibleIsSet()) {
      initShim.setToolbarVisible(builder.toolbarVisible);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.widgetClass = initShim.getWidgetClass();
    this.penSize = initShim.getPenSize();
    this.penColor = initShim.getPenColor();
    this.backgroundColor = initShim.getBackgroundColor();
    this.saveType = initShim.getSaveType();
    this.backgroundIncluded = initShim.isBackgroundIncluded();
    this.toolbarVisible = initShim.isToolbarVisible();
    this.initShim = null;
  }

  private ImmutableISignature(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      String widgetClass,
      @Nullable String backgroundImage,
      @Nullable String undoLabel,
      @Nullable String saveLabel,
      @Nullable String clearLabel,
      int penSize,
      String penColor,
      String backgroundColor,
      String saveType,
      boolean backgroundIncluded,
      boolean toolbarVisible) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.widgetClass = widgetClass;
    this.backgroundImage = backgroundImage;
    this.undoLabel = undoLabel;
    this.saveLabel = saveLabel;
    this.clearLabel = clearLabel;
    this.penSize = penSize;
    this.penColor = penColor;
    this.backgroundColor = backgroundColor;
    this.saveType = saveType;
    this.backgroundIncluded = backgroundIncluded;
    this.toolbarVisible = toolbarVisible;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ISignature", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte penSizeBuildStage = STAGE_UNINITIALIZED;
    private int penSize;

    int getPenSize() {
      if (penSizeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (penSizeBuildStage == STAGE_UNINITIALIZED) {
        penSizeBuildStage = STAGE_INITIALIZING;
        this.penSize = getPenSizeInitialize();
        penSizeBuildStage = STAGE_INITIALIZED;
      }
      return this.penSize;
    }

    void setPenSize(int penSize) {
      this.penSize = penSize;
      penSizeBuildStage = STAGE_INITIALIZED;
    }

    private byte penColorBuildStage = STAGE_UNINITIALIZED;
    private String penColor;

    String getPenColor() {
      if (penColorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (penColorBuildStage == STAGE_UNINITIALIZED) {
        penColorBuildStage = STAGE_INITIALIZING;
        this.penColor = Objects.requireNonNull(getPenColorInitialize(), "penColor");
        penColorBuildStage = STAGE_INITIALIZED;
      }
      return this.penColor;
    }

    void setPenColor(String penColor) {
      this.penColor = penColor;
      penColorBuildStage = STAGE_INITIALIZED;
    }

    private byte backgroundColorBuildStage = STAGE_UNINITIALIZED;
    private String backgroundColor;

    String getBackgroundColor() {
      if (backgroundColorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (backgroundColorBuildStage == STAGE_UNINITIALIZED) {
        backgroundColorBuildStage = STAGE_INITIALIZING;
        this.backgroundColor = Objects.requireNonNull(getBackgroundColorInitialize(), "backgroundColor");
        backgroundColorBuildStage = STAGE_INITIALIZED;
      }
      return this.backgroundColor;
    }

    void setBackgroundColor(String backgroundColor) {
      this.backgroundColor = backgroundColor;
      backgroundColorBuildStage = STAGE_INITIALIZED;
    }

    private byte saveTypeBuildStage = STAGE_UNINITIALIZED;
    private String saveType;

    String getSaveType() {
      if (saveTypeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (saveTypeBuildStage == STAGE_UNINITIALIZED) {
        saveTypeBuildStage = STAGE_INITIALIZING;
        this.saveType = Objects.requireNonNull(getSaveTypeInitialize(), "saveType");
        saveTypeBuildStage = STAGE_INITIALIZED;
      }
      return this.saveType;
    }

    void setSaveType(String saveType) {
      this.saveType = saveType;
      saveTypeBuildStage = STAGE_INITIALIZED;
    }

    private byte backgroundIncludedBuildStage = STAGE_UNINITIALIZED;
    private boolean backgroundIncluded;

    boolean isBackgroundIncluded() {
      if (backgroundIncludedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (backgroundIncludedBuildStage == STAGE_UNINITIALIZED) {
        backgroundIncludedBuildStage = STAGE_INITIALIZING;
        this.backgroundIncluded = isBackgroundIncludedInitialize();
        backgroundIncludedBuildStage = STAGE_INITIALIZED;
      }
      return this.backgroundIncluded;
    }

    void setBackgroundIncluded(boolean backgroundIncluded) {
      this.backgroundIncluded = backgroundIncluded;
      backgroundIncludedBuildStage = STAGE_INITIALIZED;
    }

    private byte toolbarVisibleBuildStage = STAGE_UNINITIALIZED;
    private boolean toolbarVisible;

    boolean isToolbarVisible() {
      if (toolbarVisibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (toolbarVisibleBuildStage == STAGE_UNINITIALIZED) {
        toolbarVisibleBuildStage = STAGE_INITIALIZING;
        this.toolbarVisible = isToolbarVisibleInitialize();
        toolbarVisibleBuildStage = STAGE_INITIALIZED;
      }
      return this.toolbarVisible;
    }

    void setToolbarVisible(boolean toolbarVisible) {
      this.toolbarVisible = toolbarVisible;
      toolbarVisibleBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (penSizeBuildStage == STAGE_INITIALIZING) attributes.add("penSize");
      if (penColorBuildStage == STAGE_INITIALIZING) attributes.add("penColor");
      if (backgroundColorBuildStage == STAGE_INITIALIZING) attributes.add("backgroundColor");
      if (saveTypeBuildStage == STAGE_INITIALIZING) attributes.add("saveType");
      if (backgroundIncludedBuildStage == STAGE_INITIALIZING) attributes.add("backgroundIncluded");
      if (toolbarVisibleBuildStage == STAGE_INITIALIZING) attributes.add("toolbarVisible");
      return "Cannot build ISignature, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return ISignature.super.getId();
  }

  private boolean isVisibleInitialize() {
    return ISignature.super.isVisible();
  }

  private String getMoldInitialize() {
    return ISignature.super.getMold();
  }

  private int getZIndexInitialize() {
    return ISignature.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return ISignature.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return ISignature.super.isFocus();
  }

  private String getDroppableInitialize() {
    return ISignature.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return ISignature.super.getRenderdefer();
  }

  private String getWidgetClassInitialize() {
    return ISignature.super.getWidgetClass();
  }

  private int getPenSizeInitialize() {
    return ISignature.super.getPenSize();
  }

  private String getPenColorInitialize() {
    return ISignature.super.getPenColor();
  }

  private String getBackgroundColorInitialize() {
    return ISignature.super.getBackgroundColor();
  }

  private String getSaveTypeInitialize() {
    return ISignature.super.getSaveType();
  }

  private boolean isBackgroundIncludedInitialize() {
    return ISignature.super.isBackgroundIncluded();
  }

  private boolean isToolbarVisibleInitialize() {
    return ISignature.super.isToolbarVisible();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code backgroundImage} attribute
   */
  @Override
  public @Nullable String getBackgroundImage() {
    return backgroundImage;
  }

  /**
   * @return The value of the {@code undoLabel} attribute
   */
  @Override
  public @Nullable String getUndoLabel() {
    return undoLabel;
  }

  /**
   * @return The value of the {@code saveLabel} attribute
   */
  @Override
  public @Nullable String getSaveLabel() {
    return saveLabel;
  }

  /**
   * @return The value of the {@code clearLabel} attribute
   */
  @Override
  public @Nullable String getClearLabel() {
    return clearLabel;
  }

  /**
   * @return The value of the {@code penSize} attribute
   */
  @Override
  public int getPenSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPenSize()
        : this.penSize;
  }

  /**
   * @return The value of the {@code penColor} attribute
   */
  @Override
  public String getPenColor() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPenColor()
        : this.penColor;
  }

  /**
   * @return The value of the {@code backgroundColor} attribute
   */
  @Override
  public String getBackgroundColor() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getBackgroundColor()
        : this.backgroundColor;
  }

  /**
   * @return The value of the {@code saveType} attribute
   */
  @Override
  public String getSaveType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSaveType()
        : this.saveType;
  }

  /**
   * @return The value of the {@code backgroundIncluded} attribute
   */
  @Override
  public boolean isBackgroundIncluded() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isBackgroundIncluded()
        : this.backgroundIncluded;
  }

  /**
   * @return The value of the {@code toolbarVisible} attribute
   */
  @Override
  public boolean isToolbarVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isToolbarVisible()
        : this.toolbarVisible;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableISignature(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableISignature(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ISignature#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISignature withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableISignature(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.widgetClass,
          this.backgroundImage,
          this.undoLabel,
          this.saveLabel,
          this.clearLabel,
          this.penSize,
          this.penColor,
          this.backgroundColor,
          this.saveType,
          this.backgroundIncluded,
          this.toolbarVisible));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ISignature#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISignature withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISignature#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISignature withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISignature#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISignature withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISignature#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISignature withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getBackgroundImage() backgroundImage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for backgroundImage (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withBackgroundImage(@Nullable String value) {
    if (Objects.equals(this.backgroundImage, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        value,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getUndoLabel() undoLabel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for undoLabel (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withUndoLabel(@Nullable String value) {
    if (Objects.equals(this.undoLabel, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        value,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getSaveLabel() saveLabel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for saveLabel (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withSaveLabel(@Nullable String value) {
    if (Objects.equals(this.saveLabel, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        value,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getClearLabel() clearLabel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clearLabel (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withClearLabel(@Nullable String value) {
    if (Objects.equals(this.clearLabel, value)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        value,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getPenSize() penSize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for penSize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withPenSize(int value) {
    if (this.penSize == value) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        value,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getPenColor() penColor} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for penColor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withPenColor(String value) {
    String newValue = Objects.requireNonNull(value, "penColor");
    if (this.penColor.equals(newValue)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        newValue,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getBackgroundColor() backgroundColor} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for backgroundColor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withBackgroundColor(String value) {
    String newValue = Objects.requireNonNull(value, "backgroundColor");
    if (this.backgroundColor.equals(newValue)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        newValue,
        this.saveType,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#getSaveType() saveType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for saveType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withSaveType(String value) {
    String newValue = Objects.requireNonNull(value, "saveType");
    if (this.saveType.equals(newValue)) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        newValue,
        this.backgroundIncluded,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#isBackgroundIncluded() backgroundIncluded} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for backgroundIncluded
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withBackgroundIncluded(boolean value) {
    if (this.backgroundIncluded == value) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        value,
        this.toolbarVisible));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISignature#isToolbarVisible() toolbarVisible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toolbarVisible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISignature withToolbarVisible(boolean value) {
    if (this.toolbarVisible == value) return this;
    return validate(new ImmutableISignature(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.backgroundImage,
        this.undoLabel,
        this.saveLabel,
        this.clearLabel,
        this.penSize,
        this.penColor,
        this.backgroundColor,
        this.saveType,
        this.backgroundIncluded,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableISignature} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableISignature
        && equalTo((ImmutableISignature) another);
  }

  private boolean equalTo(ImmutableISignature another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(backgroundImage, another.backgroundImage)
        && Objects.equals(undoLabel, another.undoLabel)
        && Objects.equals(saveLabel, another.saveLabel)
        && Objects.equals(clearLabel, another.clearLabel)
        && penSize == another.penSize
        && penColor.equals(another.penColor)
        && backgroundColor.equals(another.backgroundColor)
        && saveType.equals(another.saveType)
        && backgroundIncluded == another.backgroundIncluded
        && toolbarVisible == another.toolbarVisible;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code widgetClass}, {@code backgroundImage}, {@code undoLabel}, {@code saveLabel}, {@code clearLabel}, {@code penSize}, {@code penColor}, {@code backgroundColor}, {@code saveType}, {@code backgroundIncluded}, {@code toolbarVisible}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(backgroundImage);
    h += (h << 5) + Objects.hashCode(undoLabel);
    h += (h << 5) + Objects.hashCode(saveLabel);
    h += (h << 5) + Objects.hashCode(clearLabel);
    h += (h << 5) + penSize;
    h += (h << 5) + penColor.hashCode();
    h += (h << 5) + backgroundColor.hashCode();
    h += (h << 5) + saveType.hashCode();
    h += (h << 5) + Booleans.hashCode(backgroundIncluded);
    h += (h << 5) + Booleans.hashCode(toolbarVisible);
    return h;
  }

  /**
   * Prints the immutable value {@code ISignature} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ISignature")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("widgetClass", widgetClass)
        .add("backgroundImage", backgroundImage)
        .add("undoLabel", undoLabel)
        .add("saveLabel", saveLabel)
        .add("clearLabel", clearLabel)
        .add("penSize", penSize)
        .add("penColor", penColor)
        .add("backgroundColor", backgroundColor)
        .add("saveType", saveType)
        .add("backgroundIncluded", backgroundIncluded)
        .add("toolbarVisible", toolbarVisible)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Signature> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ISignature#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Signature> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(ISignature.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableISignature validate(ImmutableISignature instance) {
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableISignature) instance.checkDroppable();
    instance = (ImmutableISignature) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ISignature} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ISignature instance
   */
  public static ISignature copyOf(ISignature instance) {
    if (instance instanceof ImmutableISignature) {
      return (ImmutableISignature) instance;
    }
    return new ISignature.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ISignature ISignature}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ISignature", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_PEN_SIZE = 0x10L;
    private static final long OPT_BIT_BACKGROUND_INCLUDED = 0x20L;
    private static final long OPT_BIT_TOOLBAR_VISIBLE = 0x40L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable String widgetClass;
    private @Nullable String backgroundImage;
    private @Nullable String undoLabel;
    private @Nullable String saveLabel;
    private @Nullable String clearLabel;
    private int penSize;
    private @Nullable String penColor;
    private @Nullable String backgroundColor;
    private @Nullable String saveType;
    private boolean backgroundIncluded;
    private boolean toolbarVisible;

    /**
     * Creates a builder for {@link ISignature ISignature} instances.
     * <pre>
     * new ISignature.Builder()
     *    .setId(String) // optional {@link ISignature#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link ISignature#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link ISignature#getActions() actions}
     *    .setVisible(boolean) // optional {@link ISignature#isVisible() visible}
     *    .setMold(String) // optional {@link ISignature#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link ISignature#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ISignature#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ISignature#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ISignature#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link ISignature#getLeft() left}
     *    .setTop(String | null) // nullable {@link ISignature#getTop() top}
     *    .setZIndex(int) // optional {@link ISignature#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link ISignature#getHeight() height}
     *    .setWidth(String | null) // nullable {@link ISignature#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link ISignature#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link ISignature#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link ISignature#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link ISignature#getStyle() style}
     *    .setDraggable(String) // optional {@link ISignature#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link ISignature#isFocus() focus}
     *    .setDroppable(String) // optional {@link ISignature#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link ISignature#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link ISignature#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link ISignature#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link ISignature#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link ISignature#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link ISignature#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link ISignature#getContext() context}
     *    .setPopup(String | null) // nullable {@link ISignature#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link ISignature#getTooltip() tooltip}
     *    .setWidgetClass(String) // optional {@link ISignature#getWidgetClass() widgetClass}
     *    .setBackgroundImage(String | null) // nullable {@link ISignature#getBackgroundImage() backgroundImage}
     *    .setUndoLabel(String | null) // nullable {@link ISignature#getUndoLabel() undoLabel}
     *    .setSaveLabel(String | null) // nullable {@link ISignature#getSaveLabel() saveLabel}
     *    .setClearLabel(String | null) // nullable {@link ISignature#getClearLabel() clearLabel}
     *    .setPenSize(int) // optional {@link ISignature#getPenSize() penSize}
     *    .setPenColor(String) // optional {@link ISignature#getPenColor() penColor}
     *    .setBackgroundColor(String) // optional {@link ISignature#getBackgroundColor() backgroundColor}
     *    .setSaveType(String) // optional {@link ISignature#getSaveType() saveType}
     *    .setBackgroundIncluded(boolean) // optional {@link ISignature#isBackgroundIncluded() backgroundIncluded}
     *    .setToolbarVisible(boolean) // optional {@link ISignature#isToolbarVisible() toolbarVisible}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ISignature.Builder)) {
        throw new UnsupportedOperationException("Use: new ISignature.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ISignature} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder from(ISignature instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setWidgetClass(instance.getWidgetClass());
      @Nullable String backgroundImageValue = instance.getBackgroundImage();
      if (backgroundImageValue != null) {
        setBackgroundImage(backgroundImageValue);
      }
      @Nullable String undoLabelValue = instance.getUndoLabel();
      if (undoLabelValue != null) {
        setUndoLabel(undoLabelValue);
      }
      @Nullable String saveLabelValue = instance.getSaveLabel();
      if (saveLabelValue != null) {
        setSaveLabel(saveLabelValue);
      }
      @Nullable String clearLabelValue = instance.getClearLabel();
      if (clearLabelValue != null) {
        setClearLabel(clearLabelValue);
      }
      setPenSize(instance.getPenSize());
      setPenColor(instance.getPenColor());
      setBackgroundColor(instance.getBackgroundColor());
      setSaveType(instance.getSaveType());
      setBackgroundIncluded(instance.isBackgroundIncluded());
      setToolbarVisible(instance.isToolbarVisible());
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (ISignature.Builder) this;
    }

    /**
     * Adds one element to {@link ISignature#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (ISignature.Builder) this;
    }

    /**
     * Adds elements to {@link ISignature#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (ISignature.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link ISignature#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (ISignature.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link ISignature#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (ISignature.Builder) this;
    }

    /**
     * Put one entry to the {@link ISignature#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (ISignature.Builder) this;
    }

    /**
     * Put one entry to the {@link ISignature#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (ISignature.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISignature#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (ISignature.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISignature#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (ISignature.Builder) this;
    }

    /**
     * Put one entry to the {@link ISignature#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (ISignature.Builder) this;
    }

    /**
     * Put one entry to the {@link ISignature#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (ISignature.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISignature#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (ISignature.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISignature#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (ISignature.Builder) this;
    }

    /**
     * Put one entry to the {@link ISignature#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (ISignature.Builder) this;
    }

    /**
     * Put one entry to the {@link ISignature#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (ISignature.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISignature#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (ISignature.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISignature#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setTop(@Nullable String top) {
      this.top = top;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setContext(@Nullable String context) {
      this.context = context;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getBackgroundImage() backgroundImage} attribute.
     * @param backgroundImage The value for backgroundImage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setBackgroundImage(@Nullable String backgroundImage) {
      this.backgroundImage = backgroundImage;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getUndoLabel() undoLabel} attribute.
     * @param undoLabel The value for undoLabel (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setUndoLabel(@Nullable String undoLabel) {
      this.undoLabel = undoLabel;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getSaveLabel() saveLabel} attribute.
     * @param saveLabel The value for saveLabel (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setSaveLabel(@Nullable String saveLabel) {
      this.saveLabel = saveLabel;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getClearLabel() clearLabel} attribute.
     * @param clearLabel The value for clearLabel (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setClearLabel(@Nullable String clearLabel) {
      this.clearLabel = clearLabel;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getPenSize() penSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#getPenSize() penSize}.</em>
     * @param penSize The value for penSize 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setPenSize(int penSize) {
      this.penSize = penSize;
      optBits |= OPT_BIT_PEN_SIZE;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getPenColor() penColor} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#getPenColor() penColor}.</em>
     * @param penColor The value for penColor 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setPenColor(String penColor) {
      this.penColor = Objects.requireNonNull(penColor, "penColor");
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getBackgroundColor() backgroundColor} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#getBackgroundColor() backgroundColor}.</em>
     * @param backgroundColor The value for backgroundColor 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setBackgroundColor(String backgroundColor) {
      this.backgroundColor = Objects.requireNonNull(backgroundColor, "backgroundColor");
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#getSaveType() saveType} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#getSaveType() saveType}.</em>
     * @param saveType The value for saveType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setSaveType(String saveType) {
      this.saveType = Objects.requireNonNull(saveType, "saveType");
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#isBackgroundIncluded() backgroundIncluded} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#isBackgroundIncluded() backgroundIncluded}.</em>
     * @param backgroundIncluded The value for backgroundIncluded 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setBackgroundIncluded(boolean backgroundIncluded) {
      this.backgroundIncluded = backgroundIncluded;
      optBits |= OPT_BIT_BACKGROUND_INCLUDED;
      return (ISignature.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISignature#isToolbarVisible() toolbarVisible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISignature#isToolbarVisible() toolbarVisible}.</em>
     * @param toolbarVisible The value for toolbarVisible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISignature.Builder setToolbarVisible(boolean toolbarVisible) {
      this.toolbarVisible = toolbarVisible;
      optBits |= OPT_BIT_TOOLBAR_VISIBLE;
      return (ISignature.Builder) this;
    }

    /**
     * Builds a new {@link ISignature ISignature}.
     * @return An immutable instance of ISignature
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ISignature build() {
      return ImmutableISignature.validate(new ImmutableISignature(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean penSizeIsSet() {
      return (optBits & OPT_BIT_PEN_SIZE) != 0;
    }

    private boolean backgroundIncludedIsSet() {
      return (optBits & OPT_BIT_BACKGROUND_INCLUDED) != 0;
    }

    private boolean toolbarVisibleIsSet() {
      return (optBits & OPT_BIT_TOOLBAR_VISIBLE) != 0;
    }
  }
}
