package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Panel;

/**
 * Immutable implementation of {@link IPanel}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IPanel.Builder()}.
 */
@Generated(from = "IPanel", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIPanel implements IPanel {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final String widgetClass;
  private final @Nullable ICaption caption;
  private final @Nullable IToolbar topToolbar;
  private final @Nullable IToolbar bottomToolbar;
  private final @Nullable IToolbar footToolbar;
  private final @Nullable IPanelchildren<? extends IAnyGroup> panelchildren;
  private final String title;
  private final boolean closable;
  private final boolean floatable;
  private final boolean collapsible;
  private final boolean movable;
  private final boolean maximizable;
  private final boolean minimizable;
  private final boolean maximized;
  private final boolean minimized;
  private final boolean sizable;
  private final int minheight;
  private final int minwidth;
  private final boolean open;
  private final String border;
  private final boolean nativeScrollbar;

  private ImmutableIPanel(ImmutableIPanel.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.caption = builder.caption;
    this.topToolbar = builder.topToolbar;
    this.bottomToolbar = builder.bottomToolbar;
    this.footToolbar = builder.footToolbar;
    this.panelchildren = builder.panelchildren;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.title != null) {
      initShim.setTitle(builder.title);
    }
    if (builder.closableIsSet()) {
      initShim.setClosable(builder.closable);
    }
    if (builder.floatableIsSet()) {
      initShim.setFloatable(builder.floatable);
    }
    if (builder.collapsibleIsSet()) {
      initShim.setCollapsible(builder.collapsible);
    }
    if (builder.movableIsSet()) {
      initShim.setMovable(builder.movable);
    }
    if (builder.maximizableIsSet()) {
      initShim.setMaximizable(builder.maximizable);
    }
    if (builder.minimizableIsSet()) {
      initShim.setMinimizable(builder.minimizable);
    }
    if (builder.maximizedIsSet()) {
      initShim.setMaximized(builder.maximized);
    }
    if (builder.minimizedIsSet()) {
      initShim.setMinimized(builder.minimized);
    }
    if (builder.sizableIsSet()) {
      initShim.setSizable(builder.sizable);
    }
    if (builder.minheightIsSet()) {
      initShim.setMinheight(builder.minheight);
    }
    if (builder.minwidthIsSet()) {
      initShim.setMinwidth(builder.minwidth);
    }
    if (builder.openIsSet()) {
      initShim.setOpen(builder.open);
    }
    if (builder.border != null) {
      initShim.setBorder(builder.border);
    }
    if (builder.nativeScrollbarIsSet()) {
      initShim.setNativeScrollbar(builder.nativeScrollbar);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.widgetClass = initShim.getWidgetClass();
    this.title = initShim.getTitle();
    this.closable = initShim.isClosable();
    this.floatable = initShim.isFloatable();
    this.collapsible = initShim.isCollapsible();
    this.movable = initShim.isMovable();
    this.maximizable = initShim.isMaximizable();
    this.minimizable = initShim.isMinimizable();
    this.maximized = initShim.isMaximized();
    this.minimized = initShim.isMinimized();
    this.sizable = initShim.isSizable();
    this.minheight = initShim.getMinheight();
    this.minwidth = initShim.getMinwidth();
    this.open = initShim.isOpen();
    this.border = initShim.getBorder();
    this.nativeScrollbar = initShim.isNativeScrollbar();
    this.initShim = null;
  }

  private ImmutableIPanel(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      String widgetClass,
      @Nullable ICaption caption,
      @Nullable IToolbar topToolbar,
      @Nullable IToolbar bottomToolbar,
      @Nullable IToolbar footToolbar,
      @Nullable IPanelchildren<? extends IAnyGroup> panelchildren,
      String title,
      boolean closable,
      boolean floatable,
      boolean collapsible,
      boolean movable,
      boolean maximizable,
      boolean minimizable,
      boolean maximized,
      boolean minimized,
      boolean sizable,
      int minheight,
      int minwidth,
      boolean open,
      String border,
      boolean nativeScrollbar) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.widgetClass = widgetClass;
    this.caption = caption;
    this.topToolbar = topToolbar;
    this.bottomToolbar = bottomToolbar;
    this.footToolbar = footToolbar;
    this.panelchildren = panelchildren;
    this.title = title;
    this.closable = closable;
    this.floatable = floatable;
    this.collapsible = collapsible;
    this.movable = movable;
    this.maximizable = maximizable;
    this.minimizable = minimizable;
    this.maximized = maximized;
    this.minimized = minimized;
    this.sizable = sizable;
    this.minheight = minheight;
    this.minwidth = minwidth;
    this.open = open;
    this.border = border;
    this.nativeScrollbar = nativeScrollbar;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IPanel", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte titleBuildStage = STAGE_UNINITIALIZED;
    private String title;

    String getTitle() {
      if (titleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (titleBuildStage == STAGE_UNINITIALIZED) {
        titleBuildStage = STAGE_INITIALIZING;
        this.title = Objects.requireNonNull(getTitleInitialize(), "title");
        titleBuildStage = STAGE_INITIALIZED;
      }
      return this.title;
    }

    void setTitle(String title) {
      this.title = title;
      titleBuildStage = STAGE_INITIALIZED;
    }

    private byte closableBuildStage = STAGE_UNINITIALIZED;
    private boolean closable;

    boolean isClosable() {
      if (closableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (closableBuildStage == STAGE_UNINITIALIZED) {
        closableBuildStage = STAGE_INITIALIZING;
        this.closable = isClosableInitialize();
        closableBuildStage = STAGE_INITIALIZED;
      }
      return this.closable;
    }

    void setClosable(boolean closable) {
      this.closable = closable;
      closableBuildStage = STAGE_INITIALIZED;
    }

    private byte floatableBuildStage = STAGE_UNINITIALIZED;
    private boolean floatable;

    boolean isFloatable() {
      if (floatableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (floatableBuildStage == STAGE_UNINITIALIZED) {
        floatableBuildStage = STAGE_INITIALIZING;
        this.floatable = isFloatableInitialize();
        floatableBuildStage = STAGE_INITIALIZED;
      }
      return this.floatable;
    }

    void setFloatable(boolean floatable) {
      this.floatable = floatable;
      floatableBuildStage = STAGE_INITIALIZED;
    }

    private byte collapsibleBuildStage = STAGE_UNINITIALIZED;
    private boolean collapsible;

    boolean isCollapsible() {
      if (collapsibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (collapsibleBuildStage == STAGE_UNINITIALIZED) {
        collapsibleBuildStage = STAGE_INITIALIZING;
        this.collapsible = isCollapsibleInitialize();
        collapsibleBuildStage = STAGE_INITIALIZED;
      }
      return this.collapsible;
    }

    void setCollapsible(boolean collapsible) {
      this.collapsible = collapsible;
      collapsibleBuildStage = STAGE_INITIALIZED;
    }

    private byte movableBuildStage = STAGE_UNINITIALIZED;
    private boolean movable;

    boolean isMovable() {
      if (movableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (movableBuildStage == STAGE_UNINITIALIZED) {
        movableBuildStage = STAGE_INITIALIZING;
        this.movable = isMovableInitialize();
        movableBuildStage = STAGE_INITIALIZED;
      }
      return this.movable;
    }

    void setMovable(boolean movable) {
      this.movable = movable;
      movableBuildStage = STAGE_INITIALIZED;
    }

    private byte maximizableBuildStage = STAGE_UNINITIALIZED;
    private boolean maximizable;

    boolean isMaximizable() {
      if (maximizableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maximizableBuildStage == STAGE_UNINITIALIZED) {
        maximizableBuildStage = STAGE_INITIALIZING;
        this.maximizable = isMaximizableInitialize();
        maximizableBuildStage = STAGE_INITIALIZED;
      }
      return this.maximizable;
    }

    void setMaximizable(boolean maximizable) {
      this.maximizable = maximizable;
      maximizableBuildStage = STAGE_INITIALIZED;
    }

    private byte minimizableBuildStage = STAGE_UNINITIALIZED;
    private boolean minimizable;

    boolean isMinimizable() {
      if (minimizableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minimizableBuildStage == STAGE_UNINITIALIZED) {
        minimizableBuildStage = STAGE_INITIALIZING;
        this.minimizable = isMinimizableInitialize();
        minimizableBuildStage = STAGE_INITIALIZED;
      }
      return this.minimizable;
    }

    void setMinimizable(boolean minimizable) {
      this.minimizable = minimizable;
      minimizableBuildStage = STAGE_INITIALIZED;
    }

    private byte maximizedBuildStage = STAGE_UNINITIALIZED;
    private boolean maximized;

    boolean isMaximized() {
      if (maximizedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maximizedBuildStage == STAGE_UNINITIALIZED) {
        maximizedBuildStage = STAGE_INITIALIZING;
        this.maximized = isMaximizedInitialize();
        maximizedBuildStage = STAGE_INITIALIZED;
      }
      return this.maximized;
    }

    void setMaximized(boolean maximized) {
      this.maximized = maximized;
      maximizedBuildStage = STAGE_INITIALIZED;
    }

    private byte minimizedBuildStage = STAGE_UNINITIALIZED;
    private boolean minimized;

    boolean isMinimized() {
      if (minimizedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minimizedBuildStage == STAGE_UNINITIALIZED) {
        minimizedBuildStage = STAGE_INITIALIZING;
        this.minimized = isMinimizedInitialize();
        minimizedBuildStage = STAGE_INITIALIZED;
      }
      return this.minimized;
    }

    void setMinimized(boolean minimized) {
      this.minimized = minimized;
      minimizedBuildStage = STAGE_INITIALIZED;
    }

    private byte sizableBuildStage = STAGE_UNINITIALIZED;
    private boolean sizable;

    boolean isSizable() {
      if (sizableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sizableBuildStage == STAGE_UNINITIALIZED) {
        sizableBuildStage = STAGE_INITIALIZING;
        this.sizable = isSizableInitialize();
        sizableBuildStage = STAGE_INITIALIZED;
      }
      return this.sizable;
    }

    void setSizable(boolean sizable) {
      this.sizable = sizable;
      sizableBuildStage = STAGE_INITIALIZED;
    }

    private byte minheightBuildStage = STAGE_UNINITIALIZED;
    private int minheight;

    int getMinheight() {
      if (minheightBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minheightBuildStage == STAGE_UNINITIALIZED) {
        minheightBuildStage = STAGE_INITIALIZING;
        this.minheight = getMinheightInitialize();
        minheightBuildStage = STAGE_INITIALIZED;
      }
      return this.minheight;
    }

    void setMinheight(int minheight) {
      this.minheight = minheight;
      minheightBuildStage = STAGE_INITIALIZED;
    }

    private byte minwidthBuildStage = STAGE_UNINITIALIZED;
    private int minwidth;

    int getMinwidth() {
      if (minwidthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minwidthBuildStage == STAGE_UNINITIALIZED) {
        minwidthBuildStage = STAGE_INITIALIZING;
        this.minwidth = getMinwidthInitialize();
        minwidthBuildStage = STAGE_INITIALIZED;
      }
      return this.minwidth;
    }

    void setMinwidth(int minwidth) {
      this.minwidth = minwidth;
      minwidthBuildStage = STAGE_INITIALIZED;
    }

    private byte openBuildStage = STAGE_UNINITIALIZED;
    private boolean open;

    boolean isOpen() {
      if (openBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (openBuildStage == STAGE_UNINITIALIZED) {
        openBuildStage = STAGE_INITIALIZING;
        this.open = isOpenInitialize();
        openBuildStage = STAGE_INITIALIZED;
      }
      return this.open;
    }

    void setOpen(boolean open) {
      this.open = open;
      openBuildStage = STAGE_INITIALIZED;
    }

    private byte borderBuildStage = STAGE_UNINITIALIZED;
    private String border;

    String getBorder() {
      if (borderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (borderBuildStage == STAGE_UNINITIALIZED) {
        borderBuildStage = STAGE_INITIALIZING;
        this.border = Objects.requireNonNull(getBorderInitialize(), "border");
        borderBuildStage = STAGE_INITIALIZED;
      }
      return this.border;
    }

    void setBorder(String border) {
      this.border = border;
      borderBuildStage = STAGE_INITIALIZED;
    }

    private byte nativeScrollbarBuildStage = STAGE_UNINITIALIZED;
    private boolean nativeScrollbar;

    boolean isNativeScrollbar() {
      if (nativeScrollbarBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nativeScrollbarBuildStage == STAGE_UNINITIALIZED) {
        nativeScrollbarBuildStage = STAGE_INITIALIZING;
        this.nativeScrollbar = isNativeScrollbarInitialize();
        nativeScrollbarBuildStage = STAGE_INITIALIZED;
      }
      return this.nativeScrollbar;
    }

    void setNativeScrollbar(boolean nativeScrollbar) {
      this.nativeScrollbar = nativeScrollbar;
      nativeScrollbarBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (titleBuildStage == STAGE_INITIALIZING) attributes.add("title");
      if (closableBuildStage == STAGE_INITIALIZING) attributes.add("closable");
      if (floatableBuildStage == STAGE_INITIALIZING) attributes.add("floatable");
      if (collapsibleBuildStage == STAGE_INITIALIZING) attributes.add("collapsible");
      if (movableBuildStage == STAGE_INITIALIZING) attributes.add("movable");
      if (maximizableBuildStage == STAGE_INITIALIZING) attributes.add("maximizable");
      if (minimizableBuildStage == STAGE_INITIALIZING) attributes.add("minimizable");
      if (maximizedBuildStage == STAGE_INITIALIZING) attributes.add("maximized");
      if (minimizedBuildStage == STAGE_INITIALIZING) attributes.add("minimized");
      if (sizableBuildStage == STAGE_INITIALIZING) attributes.add("sizable");
      if (minheightBuildStage == STAGE_INITIALIZING) attributes.add("minheight");
      if (minwidthBuildStage == STAGE_INITIALIZING) attributes.add("minwidth");
      if (openBuildStage == STAGE_INITIALIZING) attributes.add("open");
      if (borderBuildStage == STAGE_INITIALIZING) attributes.add("border");
      if (nativeScrollbarBuildStage == STAGE_INITIALIZING) attributes.add("nativeScrollbar");
      return "Cannot build IPanel, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IPanel.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IPanel.super.isVisible();
  }

  private String getMoldInitialize() {
    return IPanel.super.getMold();
  }

  private int getZIndexInitialize() {
    return IPanel.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IPanel.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IPanel.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IPanel.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IPanel.super.getRenderdefer();
  }

  private String getWidgetClassInitialize() {
    return IPanel.super.getWidgetClass();
  }

  private String getTitleInitialize() {
    return IPanel.super.getTitle();
  }

  private boolean isClosableInitialize() {
    return IPanel.super.isClosable();
  }

  private boolean isFloatableInitialize() {
    return IPanel.super.isFloatable();
  }

  private boolean isCollapsibleInitialize() {
    return IPanel.super.isCollapsible();
  }

  private boolean isMovableInitialize() {
    return IPanel.super.isMovable();
  }

  private boolean isMaximizableInitialize() {
    return IPanel.super.isMaximizable();
  }

  private boolean isMinimizableInitialize() {
    return IPanel.super.isMinimizable();
  }

  private boolean isMaximizedInitialize() {
    return IPanel.super.isMaximized();
  }

  private boolean isMinimizedInitialize() {
    return IPanel.super.isMinimized();
  }

  private boolean isSizableInitialize() {
    return IPanel.super.isSizable();
  }

  private int getMinheightInitialize() {
    return IPanel.super.getMinheight();
  }

  private int getMinwidthInitialize() {
    return IPanel.super.getMinwidth();
  }

  private boolean isOpenInitialize() {
    return IPanel.super.isOpen();
  }

  private String getBorderInitialize() {
    return IPanel.super.getBorder();
  }

  private boolean isNativeScrollbarInitialize() {
    return IPanel.super.isNativeScrollbar();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code caption} attribute
   */
  @Override
  public @Nullable ICaption getCaption() {
    return caption;
  }

  /**
   * @return The value of the {@code topToolbar} attribute
   */
  @Override
  public @Nullable IToolbar getTopToolbar() {
    return topToolbar;
  }

  /**
   * @return The value of the {@code bottomToolbar} attribute
   */
  @Override
  public @Nullable IToolbar getBottomToolbar() {
    return bottomToolbar;
  }

  /**
   * @return The value of the {@code footToolbar} attribute
   */
  @Override
  public @Nullable IToolbar getFootToolbar() {
    return footToolbar;
  }

  /**
   * @return The value of the {@code panelchildren} attribute
   */
  @Override
  public @Nullable IPanelchildren<? extends IAnyGroup> getPanelchildren() {
    return panelchildren;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @Override
  public String getTitle() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getTitle()
        : this.title;
  }

  /**
   * @return The value of the {@code closable} attribute
   */
  @Override
  public boolean isClosable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isClosable()
        : this.closable;
  }

  /**
   * @return The value of the {@code floatable} attribute
   */
  @Override
  public boolean isFloatable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFloatable()
        : this.floatable;
  }

  /**
   * @return The value of the {@code collapsible} attribute
   */
  @Override
  public boolean isCollapsible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isCollapsible()
        : this.collapsible;
  }

  /**
   * @return The value of the {@code movable} attribute
   */
  @Override
  public boolean isMovable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMovable()
        : this.movable;
  }

  /**
   * @return The value of the {@code maximizable} attribute
   */
  @Override
  public boolean isMaximizable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMaximizable()
        : this.maximizable;
  }

  /**
   * @return The value of the {@code minimizable} attribute
   */
  @Override
  public boolean isMinimizable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMinimizable()
        : this.minimizable;
  }

  /**
   * @return The value of the {@code maximized} attribute
   */
  @Override
  public boolean isMaximized() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMaximized()
        : this.maximized;
  }

  /**
   * @return The value of the {@code minimized} attribute
   */
  @Override
  public boolean isMinimized() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMinimized()
        : this.minimized;
  }

  /**
   * @return The value of the {@code sizable} attribute
   */
  @Override
  public boolean isSizable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSizable()
        : this.sizable;
  }

  /**
   * @return The value of the {@code minheight} attribute
   */
  @Override
  public int getMinheight() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMinheight()
        : this.minheight;
  }

  /**
   * @return The value of the {@code minwidth} attribute
   */
  @Override
  public int getMinwidth() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMinwidth()
        : this.minwidth;
  }

  /**
   * @return The value of the {@code open} attribute
   */
  @Override
  public boolean isOpen() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isOpen()
        : this.open;
  }

  /**
   * @return The value of the {@code border} attribute
   */
  @Override
  public String getBorder() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getBorder()
        : this.border;
  }

  /**
   * @return The value of the {@code nativeScrollbar} attribute
   */
  @Override
  public boolean isNativeScrollbar() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isNativeScrollbar()
        : this.nativeScrollbar;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIPanel(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IPanel#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPanel withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIPanel(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.widgetClass,
          this.caption,
          this.topToolbar,
          this.bottomToolbar,
          this.footToolbar,
          this.panelchildren,
          this.title,
          this.closable,
          this.floatable,
          this.collapsible,
          this.movable,
          this.maximizable,
          this.minimizable,
          this.maximized,
          this.minimized,
          this.sizable,
          this.minheight,
          this.minwidth,
          this.open,
          this.border,
          this.nativeScrollbar));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IPanel#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPanel withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by replacing the {@link IPanel#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPanel withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by replacing the {@link IPanel#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPanel withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by replacing the {@link IPanel#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPanel withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getCaption() caption} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for caption (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withCaption(@Nullable ICaption value) {
    if (this.caption == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        value,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getTopToolbar() topToolbar} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for topToolbar (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withTopToolbar(@Nullable IToolbar value) {
    if (this.topToolbar == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        value,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getBottomToolbar() bottomToolbar} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bottomToolbar (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withBottomToolbar(@Nullable IToolbar value) {
    if (this.bottomToolbar == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        value,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getFootToolbar() footToolbar} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for footToolbar (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withFootToolbar(@Nullable IToolbar value) {
    if (this.footToolbar == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        value,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getPanelchildren() panelchildren} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for panelchildren (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withPanelchildren(@Nullable IPanelchildren<? extends IAnyGroup> value) {
    if (this.panelchildren == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        value,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withTitle(String value) {
    String newValue = Objects.requireNonNull(value, "title");
    if (this.title.equals(newValue)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        newValue,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#isClosable() closable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for closable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withClosable(boolean value) {
    if (this.closable == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        value,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#isFloatable() floatable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for floatable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withFloatable(boolean value) {
    if (this.floatable == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        value,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#isCollapsible() collapsible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collapsible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withCollapsible(boolean value) {
    if (this.collapsible == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        value,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#isMovable() movable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for movable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withMovable(boolean value) {
    if (this.movable == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        value,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#isMaximizable() maximizable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maximizable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withMaximizable(boolean value) {
    if (this.maximizable == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        value,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#isMinimizable() minimizable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minimizable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withMinimizable(boolean value) {
    if (this.minimizable == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        value,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#isMaximized() maximized} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maximized
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withMaximized(boolean value) {
    if (this.maximized == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        value,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#isMinimized() minimized} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minimized
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withMinimized(boolean value) {
    if (this.minimized == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        value,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#isSizable() sizable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sizable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withSizable(boolean value) {
    if (this.sizable == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        value,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getMinheight() minheight} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minheight
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withMinheight(int value) {
    if (this.minheight == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        value,
        this.minwidth,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getMinwidth() minwidth} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minwidth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withMinwidth(int value) {
    if (this.minwidth == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        value,
        this.open,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#isOpen() open} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for open
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withOpen(boolean value) {
    if (this.open == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        value,
        this.border,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#getBorder() border} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for border
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withBorder(String value) {
    String newValue = Objects.requireNonNull(value, "border");
    if (this.border.equals(newValue)) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        newValue,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPanel#isNativeScrollbar() nativeScrollbar} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nativeScrollbar
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPanel withNativeScrollbar(boolean value) {
    if (this.nativeScrollbar == value) return this;
    return validate(new ImmutableIPanel(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.caption,
        this.topToolbar,
        this.bottomToolbar,
        this.footToolbar,
        this.panelchildren,
        this.title,
        this.closable,
        this.floatable,
        this.collapsible,
        this.movable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.open,
        this.border,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIPanel} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIPanel
        && equalTo((ImmutableIPanel) another);
  }

  private boolean equalTo(ImmutableIPanel another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(caption, another.caption)
        && Objects.equals(topToolbar, another.topToolbar)
        && Objects.equals(bottomToolbar, another.bottomToolbar)
        && Objects.equals(footToolbar, another.footToolbar)
        && Objects.equals(panelchildren, another.panelchildren)
        && title.equals(another.title)
        && closable == another.closable
        && floatable == another.floatable
        && collapsible == another.collapsible
        && movable == another.movable
        && maximizable == another.maximizable
        && minimizable == another.minimizable
        && maximized == another.maximized
        && minimized == another.minimized
        && sizable == another.sizable
        && minheight == another.minheight
        && minwidth == another.minwidth
        && open == another.open
        && border.equals(another.border)
        && nativeScrollbar == another.nativeScrollbar;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code widgetClass}, {@code caption}, {@code topToolbar}, {@code bottomToolbar}, {@code footToolbar}, {@code panelchildren}, {@code title}, {@code closable}, {@code floatable}, {@code collapsible}, {@code movable}, {@code maximizable}, {@code minimizable}, {@code maximized}, {@code minimized}, {@code sizable}, {@code minheight}, {@code minwidth}, {@code open}, {@code border}, {@code nativeScrollbar}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(caption);
    h += (h << 5) + Objects.hashCode(topToolbar);
    h += (h << 5) + Objects.hashCode(bottomToolbar);
    h += (h << 5) + Objects.hashCode(footToolbar);
    h += (h << 5) + Objects.hashCode(panelchildren);
    h += (h << 5) + title.hashCode();
    h += (h << 5) + Booleans.hashCode(closable);
    h += (h << 5) + Booleans.hashCode(floatable);
    h += (h << 5) + Booleans.hashCode(collapsible);
    h += (h << 5) + Booleans.hashCode(movable);
    h += (h << 5) + Booleans.hashCode(maximizable);
    h += (h << 5) + Booleans.hashCode(minimizable);
    h += (h << 5) + Booleans.hashCode(maximized);
    h += (h << 5) + Booleans.hashCode(minimized);
    h += (h << 5) + Booleans.hashCode(sizable);
    h += (h << 5) + minheight;
    h += (h << 5) + minwidth;
    h += (h << 5) + Booleans.hashCode(open);
    h += (h << 5) + border.hashCode();
    h += (h << 5) + Booleans.hashCode(nativeScrollbar);
    return h;
  }

  /**
   * Prints the immutable value {@code IPanel} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IPanel")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("widgetClass", widgetClass)
        .add("caption", caption)
        .add("topToolbar", topToolbar)
        .add("bottomToolbar", bottomToolbar)
        .add("footToolbar", footToolbar)
        .add("panelchildren", panelchildren)
        .add("title", title)
        .add("closable", closable)
        .add("floatable", floatable)
        .add("collapsible", collapsible)
        .add("movable", movable)
        .add("maximizable", maximizable)
        .add("minimizable", minimizable)
        .add("maximized", maximized)
        .add("minimized", minimized)
        .add("sizable", sizable)
        .add("minheight", minheight)
        .add("minwidth", minwidth)
        .add("open", open)
        .add("border", border)
        .add("nativeScrollbar", nativeScrollbar)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Panel> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IPanel#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Panel> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IPanel.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static final long ALL_COMPONENTS_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient List<IChildrenOfPanel> allComponents;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IPanel#getAllComponents() allComponents} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code allComponents} attribute
   */
  @Override
  public List<IChildrenOfPanel> getAllComponents() {
    if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
          this.allComponents = Objects.requireNonNull(IPanel.super.getAllComponents(), "allComponents");
          lazyInitBitmap |= ALL_COMPONENTS_LAZY_INIT_BIT;
        }
      }
    }
    return allComponents;
  }

  private static ImmutableIPanel validate(ImmutableIPanel instance) {
    instance = (ImmutableIPanel) instance.checkBorder();
    instance = (ImmutableIPanel) instance.checkMinwidth();
    instance = (ImmutableIPanel) instance.checkMinheight();
    instance.checkMinimized();
    instance.checkMaximized();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIPanel) instance.checkDroppable();
    instance = (ImmutableIPanel) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IPanel} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IPanel instance
   */
  public static IPanel copyOf(IPanel instance) {
    if (instance instanceof ImmutableIPanel) {
      return (ImmutableIPanel) instance;
    }
    return new IPanel.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IPanel IPanel}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IPanel", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_CLOSABLE = 0x10L;
    private static final long OPT_BIT_FLOATABLE = 0x20L;
    private static final long OPT_BIT_COLLAPSIBLE = 0x40L;
    private static final long OPT_BIT_MOVABLE = 0x80L;
    private static final long OPT_BIT_MAXIMIZABLE = 0x100L;
    private static final long OPT_BIT_MINIMIZABLE = 0x200L;
    private static final long OPT_BIT_MAXIMIZED = 0x400L;
    private static final long OPT_BIT_MINIMIZED = 0x800L;
    private static final long OPT_BIT_SIZABLE = 0x1000L;
    private static final long OPT_BIT_MINHEIGHT = 0x2000L;
    private static final long OPT_BIT_MINWIDTH = 0x4000L;
    private static final long OPT_BIT_OPEN = 0x8000L;
    private static final long OPT_BIT_NATIVE_SCROLLBAR = 0x10000L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable String widgetClass;
    private @Nullable ICaption caption;
    private @Nullable IToolbar topToolbar;
    private @Nullable IToolbar bottomToolbar;
    private @Nullable IToolbar footToolbar;
    private @Nullable IPanelchildren<? extends IAnyGroup> panelchildren;
    private @Nullable String title;
    private boolean closable;
    private boolean floatable;
    private boolean collapsible;
    private boolean movable;
    private boolean maximizable;
    private boolean minimizable;
    private boolean maximized;
    private boolean minimized;
    private boolean sizable;
    private int minheight;
    private int minwidth;
    private boolean open;
    private @Nullable String border;
    private boolean nativeScrollbar;

    /**
     * Creates a builder for {@link IPanel IPanel} instances.
     * <pre>
     * new IPanel.Builder()
     *    .setId(String) // optional {@link IPanel#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IPanel#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IPanel#getActions() actions}
     *    .setVisible(boolean) // optional {@link IPanel#isVisible() visible}
     *    .setMold(String) // optional {@link IPanel#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IPanel#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IPanel#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IPanel#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IPanel#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IPanel#getLeft() left}
     *    .setTop(String | null) // nullable {@link IPanel#getTop() top}
     *    .setZIndex(int) // optional {@link IPanel#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IPanel#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IPanel#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IPanel#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IPanel#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IPanel#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IPanel#getStyle() style}
     *    .setDraggable(String) // optional {@link IPanel#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IPanel#isFocus() focus}
     *    .setDroppable(String) // optional {@link IPanel#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IPanel#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IPanel#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IPanel#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IPanel#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IPanel#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IPanel#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IPanel#getContext() context}
     *    .setPopup(String | null) // nullable {@link IPanel#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IPanel#getTooltip() tooltip}
     *    .setWidgetClass(String) // optional {@link IPanel#getWidgetClass() widgetClass}
     *    .setCaption(org.zkoss.stateless.sul.ICaption | null) // nullable {@link IPanel#getCaption() caption}
     *    .setTopToolbar(org.zkoss.stateless.sul.IToolbar | null) // nullable {@link IPanel#getTopToolbar() topToolbar}
     *    .setBottomToolbar(org.zkoss.stateless.sul.IToolbar | null) // nullable {@link IPanel#getBottomToolbar() bottomToolbar}
     *    .setFootToolbar(org.zkoss.stateless.sul.IToolbar | null) // nullable {@link IPanel#getFootToolbar() footToolbar}
     *    .setPanelchildren(org.zkoss.stateless.sul.IPanelchildren&amp;lt;? extends org.zkoss.stateless.sul.IAnyGroup&amp;gt; | null) // nullable {@link IPanel#getPanelchildren() panelchildren}
     *    .setTitle(String) // optional {@link IPanel#getTitle() title}
     *    .setClosable(boolean) // optional {@link IPanel#isClosable() closable}
     *    .setFloatable(boolean) // optional {@link IPanel#isFloatable() floatable}
     *    .setCollapsible(boolean) // optional {@link IPanel#isCollapsible() collapsible}
     *    .setMovable(boolean) // optional {@link IPanel#isMovable() movable}
     *    .setMaximizable(boolean) // optional {@link IPanel#isMaximizable() maximizable}
     *    .setMinimizable(boolean) // optional {@link IPanel#isMinimizable() minimizable}
     *    .setMaximized(boolean) // optional {@link IPanel#isMaximized() maximized}
     *    .setMinimized(boolean) // optional {@link IPanel#isMinimized() minimized}
     *    .setSizable(boolean) // optional {@link IPanel#isSizable() sizable}
     *    .setMinheight(int) // optional {@link IPanel#getMinheight() minheight}
     *    .setMinwidth(int) // optional {@link IPanel#getMinwidth() minwidth}
     *    .setOpen(boolean) // optional {@link IPanel#isOpen() open}
     *    .setBorder(String) // optional {@link IPanel#getBorder() border}
     *    .setNativeScrollbar(boolean) // optional {@link IPanel#isNativeScrollbar() nativeScrollbar}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IPanel.Builder)) {
        throw new UnsupportedOperationException("Use: new IPanel.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IPanel} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder from(IPanel instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setWidgetClass(instance.getWidgetClass());
      @Nullable ICaption captionValue = instance.getCaption();
      if (captionValue != null) {
        setCaption(captionValue);
      }
      @Nullable IToolbar topToolbarValue = instance.getTopToolbar();
      if (topToolbarValue != null) {
        setTopToolbar(topToolbarValue);
      }
      @Nullable IToolbar bottomToolbarValue = instance.getBottomToolbar();
      if (bottomToolbarValue != null) {
        setBottomToolbar(bottomToolbarValue);
      }
      @Nullable IToolbar footToolbarValue = instance.getFootToolbar();
      if (footToolbarValue != null) {
        setFootToolbar(footToolbarValue);
      }
      @Nullable IPanelchildren<? extends IAnyGroup> panelchildrenValue = instance.getPanelchildren();
      if (panelchildrenValue != null) {
        setPanelchildren(panelchildrenValue);
      }
      setTitle(instance.getTitle());
      setClosable(instance.isClosable());
      setFloatable(instance.isFloatable());
      setCollapsible(instance.isCollapsible());
      setMovable(instance.isMovable());
      setMaximizable(instance.isMaximizable());
      setMinimizable(instance.isMinimizable());
      setMaximized(instance.isMaximized());
      setMinimized(instance.isMinimized());
      setSizable(instance.isSizable());
      setMinheight(instance.getMinheight());
      setMinwidth(instance.getMinwidth());
      setOpen(instance.isOpen());
      setBorder(instance.getBorder());
      setNativeScrollbar(instance.isNativeScrollbar());
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IPanel.Builder) this;
    }

    /**
     * Adds one element to {@link IPanel#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IPanel.Builder) this;
    }

    /**
     * Adds elements to {@link IPanel#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IPanel.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IPanel#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IPanel.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IPanel#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IPanel.Builder) this;
    }

    /**
     * Put one entry to the {@link IPanel#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IPanel.Builder) this;
    }

    /**
     * Put one entry to the {@link IPanel#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IPanel.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IPanel#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IPanel.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IPanel#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IPanel.Builder) this;
    }

    /**
     * Put one entry to the {@link IPanel#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IPanel.Builder) this;
    }

    /**
     * Put one entry to the {@link IPanel#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IPanel.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IPanel#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IPanel.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IPanel#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IPanel.Builder) this;
    }

    /**
     * Put one entry to the {@link IPanel#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IPanel.Builder) this;
    }

    /**
     * Put one entry to the {@link IPanel#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IPanel.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IPanel#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IPanel.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IPanel#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setTop(@Nullable String top) {
      this.top = top;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setContext(@Nullable String context) {
      this.context = context;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getCaption() caption} attribute.
     * @param caption The value for caption (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setCaption(@Nullable ICaption caption) {
      this.caption = caption;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getTopToolbar() topToolbar} attribute.
     * @param topToolbar The value for topToolbar (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setTopToolbar(@Nullable IToolbar topToolbar) {
      this.topToolbar = topToolbar;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getBottomToolbar() bottomToolbar} attribute.
     * @param bottomToolbar The value for bottomToolbar (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setBottomToolbar(@Nullable IToolbar bottomToolbar) {
      this.bottomToolbar = bottomToolbar;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getFootToolbar() footToolbar} attribute.
     * @param footToolbar The value for footToolbar (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setFootToolbar(@Nullable IToolbar footToolbar) {
      this.footToolbar = footToolbar;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getPanelchildren() panelchildren} attribute.
     * @param panelchildren The value for panelchildren (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setPanelchildren(@Nullable IPanelchildren<? extends IAnyGroup> panelchildren) {
      this.panelchildren = panelchildren;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getTitle() title} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#getTitle() title}.</em>
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setTitle(String title) {
      this.title = Objects.requireNonNull(title, "title");
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#isClosable() closable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#isClosable() closable}.</em>
     * @param closable The value for closable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setClosable(boolean closable) {
      this.closable = closable;
      optBits |= OPT_BIT_CLOSABLE;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#isFloatable() floatable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#isFloatable() floatable}.</em>
     * @param floatable The value for floatable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setFloatable(boolean floatable) {
      this.floatable = floatable;
      optBits |= OPT_BIT_FLOATABLE;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#isCollapsible() collapsible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#isCollapsible() collapsible}.</em>
     * @param collapsible The value for collapsible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setCollapsible(boolean collapsible) {
      this.collapsible = collapsible;
      optBits |= OPT_BIT_COLLAPSIBLE;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#isMovable() movable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#isMovable() movable}.</em>
     * @param movable The value for movable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setMovable(boolean movable) {
      this.movable = movable;
      optBits |= OPT_BIT_MOVABLE;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#isMaximizable() maximizable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#isMaximizable() maximizable}.</em>
     * @param maximizable The value for maximizable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setMaximizable(boolean maximizable) {
      this.maximizable = maximizable;
      optBits |= OPT_BIT_MAXIMIZABLE;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#isMinimizable() minimizable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#isMinimizable() minimizable}.</em>
     * @param minimizable The value for minimizable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setMinimizable(boolean minimizable) {
      this.minimizable = minimizable;
      optBits |= OPT_BIT_MINIMIZABLE;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#isMaximized() maximized} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#isMaximized() maximized}.</em>
     * @param maximized The value for maximized 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setMaximized(boolean maximized) {
      this.maximized = maximized;
      optBits |= OPT_BIT_MAXIMIZED;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#isMinimized() minimized} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#isMinimized() minimized}.</em>
     * @param minimized The value for minimized 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setMinimized(boolean minimized) {
      this.minimized = minimized;
      optBits |= OPT_BIT_MINIMIZED;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#isSizable() sizable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#isSizable() sizable}.</em>
     * @param sizable The value for sizable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setSizable(boolean sizable) {
      this.sizable = sizable;
      optBits |= OPT_BIT_SIZABLE;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getMinheight() minheight} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#getMinheight() minheight}.</em>
     * @param minheight The value for minheight 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setMinheight(int minheight) {
      this.minheight = minheight;
      optBits |= OPT_BIT_MINHEIGHT;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getMinwidth() minwidth} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#getMinwidth() minwidth}.</em>
     * @param minwidth The value for minwidth 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setMinwidth(int minwidth) {
      this.minwidth = minwidth;
      optBits |= OPT_BIT_MINWIDTH;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#isOpen() open} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#isOpen() open}.</em>
     * @param open The value for open 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setOpen(boolean open) {
      this.open = open;
      optBits |= OPT_BIT_OPEN;
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#getBorder() border} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#getBorder() border}.</em>
     * @param border The value for border 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setBorder(String border) {
      this.border = Objects.requireNonNull(border, "border");
      return (IPanel.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPanel#isNativeScrollbar() nativeScrollbar} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPanel#isNativeScrollbar() nativeScrollbar}.</em>
     * @param nativeScrollbar The value for nativeScrollbar 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPanel.Builder setNativeScrollbar(boolean nativeScrollbar) {
      this.nativeScrollbar = nativeScrollbar;
      optBits |= OPT_BIT_NATIVE_SCROLLBAR;
      return (IPanel.Builder) this;
    }

    /**
     * Builds a new {@link IPanel IPanel}.
     * @return An immutable instance of IPanel
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IPanel build() {
      return ImmutableIPanel.validate(new ImmutableIPanel(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean closableIsSet() {
      return (optBits & OPT_BIT_CLOSABLE) != 0;
    }

    private boolean floatableIsSet() {
      return (optBits & OPT_BIT_FLOATABLE) != 0;
    }

    private boolean collapsibleIsSet() {
      return (optBits & OPT_BIT_COLLAPSIBLE) != 0;
    }

    private boolean movableIsSet() {
      return (optBits & OPT_BIT_MOVABLE) != 0;
    }

    private boolean maximizableIsSet() {
      return (optBits & OPT_BIT_MAXIMIZABLE) != 0;
    }

    private boolean minimizableIsSet() {
      return (optBits & OPT_BIT_MINIMIZABLE) != 0;
    }

    private boolean maximizedIsSet() {
      return (optBits & OPT_BIT_MAXIMIZED) != 0;
    }

    private boolean minimizedIsSet() {
      return (optBits & OPT_BIT_MINIMIZED) != 0;
    }

    private boolean sizableIsSet() {
      return (optBits & OPT_BIT_SIZABLE) != 0;
    }

    private boolean minheightIsSet() {
      return (optBits & OPT_BIT_MINHEIGHT) != 0;
    }

    private boolean minwidthIsSet() {
      return (optBits & OPT_BIT_MINWIDTH) != 0;
    }

    private boolean openIsSet() {
      return (optBits & OPT_BIT_OPEN) != 0;
    }

    private boolean nativeScrollbarIsSet() {
      return (optBits & OPT_BIT_NATIVE_SCROLLBAR) != 0;
    }
  }
}
