package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.West;

/**
 * Immutable implementation of {@link IWest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IWest.Builder()}.
 */
@Generated(from = "IWest", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIWest<I extends IAnyGroup>
    implements IWest<I> {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final @Nullable String title;
  private final String border;
  private final boolean autoscroll;
  private final String margins;
  private final int maxsize;
  private final int minsize;
  private final boolean splittable;
  private final boolean collapsible;
  private final boolean open;
  private final boolean slidable;
  private final boolean slide;
  private final boolean closable;
  private final boolean nativeScrollbar;
  private final @Nullable I child;
  private final String widgetClass;
  private final String cmargins;

  private ImmutableIWest(ImmutableIWest.Builder<I> builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.title = builder.title;
    this.child = builder.child;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.border != null) {
      initShim.setBorder(builder.border);
    }
    if (builder.autoscrollIsSet()) {
      initShim.setAutoscroll(builder.autoscroll);
    }
    if (builder.margins != null) {
      initShim.setMargins(builder.margins);
    }
    if (builder.maxsizeIsSet()) {
      initShim.setMaxsize(builder.maxsize);
    }
    if (builder.minsizeIsSet()) {
      initShim.setMinsize(builder.minsize);
    }
    if (builder.splittableIsSet()) {
      initShim.setSplittable(builder.splittable);
    }
    if (builder.collapsibleIsSet()) {
      initShim.setCollapsible(builder.collapsible);
    }
    if (builder.openIsSet()) {
      initShim.setOpen(builder.open);
    }
    if (builder.slidableIsSet()) {
      initShim.setSlidable(builder.slidable);
    }
    if (builder.slideIsSet()) {
      initShim.setSlide(builder.slide);
    }
    if (builder.closableIsSet()) {
      initShim.setClosable(builder.closable);
    }
    if (builder.nativeScrollbarIsSet()) {
      initShim.setNativeScrollbar(builder.nativeScrollbar);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.cmargins != null) {
      initShim.setCmargins(builder.cmargins);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.border = initShim.getBorder();
    this.autoscroll = initShim.isAutoscroll();
    this.margins = initShim.getMargins();
    this.maxsize = initShim.getMaxsize();
    this.minsize = initShim.getMinsize();
    this.splittable = initShim.isSplittable();
    this.collapsible = initShim.isCollapsible();
    this.open = initShim.isOpen();
    this.slidable = initShim.isSlidable();
    this.slide = initShim.isSlide();
    this.closable = initShim.isClosable();
    this.nativeScrollbar = initShim.isNativeScrollbar();
    this.widgetClass = initShim.getWidgetClass();
    this.cmargins = initShim.getCmargins();
    this.initShim = null;
  }

  private ImmutableIWest(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      @Nullable String title,
      String border,
      boolean autoscroll,
      String margins,
      int maxsize,
      int minsize,
      boolean splittable,
      boolean collapsible,
      boolean open,
      boolean slidable,
      boolean slide,
      boolean closable,
      boolean nativeScrollbar,
      @Nullable I child,
      String widgetClass,
      String cmargins) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.title = title;
    this.border = border;
    this.autoscroll = autoscroll;
    this.margins = margins;
    this.maxsize = maxsize;
    this.minsize = minsize;
    this.splittable = splittable;
    this.collapsible = collapsible;
    this.open = open;
    this.slidable = slidable;
    this.slide = slide;
    this.closable = closable;
    this.nativeScrollbar = nativeScrollbar;
    this.child = child;
    this.widgetClass = widgetClass;
    this.cmargins = cmargins;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IWest", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte borderBuildStage = STAGE_UNINITIALIZED;
    private String border;

    String getBorder() {
      if (borderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (borderBuildStage == STAGE_UNINITIALIZED) {
        borderBuildStage = STAGE_INITIALIZING;
        this.border = Objects.requireNonNull(getBorderInitialize(), "border");
        borderBuildStage = STAGE_INITIALIZED;
      }
      return this.border;
    }

    void setBorder(String border) {
      this.border = border;
      borderBuildStage = STAGE_INITIALIZED;
    }

    private byte autoscrollBuildStage = STAGE_UNINITIALIZED;
    private boolean autoscroll;

    boolean isAutoscroll() {
      if (autoscrollBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (autoscrollBuildStage == STAGE_UNINITIALIZED) {
        autoscrollBuildStage = STAGE_INITIALIZING;
        this.autoscroll = isAutoscrollInitialize();
        autoscrollBuildStage = STAGE_INITIALIZED;
      }
      return this.autoscroll;
    }

    void setAutoscroll(boolean autoscroll) {
      this.autoscroll = autoscroll;
      autoscrollBuildStage = STAGE_INITIALIZED;
    }

    private byte marginsBuildStage = STAGE_UNINITIALIZED;
    private String margins;

    String getMargins() {
      if (marginsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (marginsBuildStage == STAGE_UNINITIALIZED) {
        marginsBuildStage = STAGE_INITIALIZING;
        this.margins = Objects.requireNonNull(getMarginsInitialize(), "margins");
        marginsBuildStage = STAGE_INITIALIZED;
      }
      return this.margins;
    }

    void setMargins(String margins) {
      this.margins = margins;
      marginsBuildStage = STAGE_INITIALIZED;
    }

    private byte maxsizeBuildStage = STAGE_UNINITIALIZED;
    private int maxsize;

    int getMaxsize() {
      if (maxsizeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxsizeBuildStage == STAGE_UNINITIALIZED) {
        maxsizeBuildStage = STAGE_INITIALIZING;
        this.maxsize = getMaxsizeInitialize();
        maxsizeBuildStage = STAGE_INITIALIZED;
      }
      return this.maxsize;
    }

    void setMaxsize(int maxsize) {
      this.maxsize = maxsize;
      maxsizeBuildStage = STAGE_INITIALIZED;
    }

    private byte minsizeBuildStage = STAGE_UNINITIALIZED;
    private int minsize;

    int getMinsize() {
      if (minsizeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minsizeBuildStage == STAGE_UNINITIALIZED) {
        minsizeBuildStage = STAGE_INITIALIZING;
        this.minsize = getMinsizeInitialize();
        minsizeBuildStage = STAGE_INITIALIZED;
      }
      return this.minsize;
    }

    void setMinsize(int minsize) {
      this.minsize = minsize;
      minsizeBuildStage = STAGE_INITIALIZED;
    }

    private byte splittableBuildStage = STAGE_UNINITIALIZED;
    private boolean splittable;

    boolean isSplittable() {
      if (splittableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (splittableBuildStage == STAGE_UNINITIALIZED) {
        splittableBuildStage = STAGE_INITIALIZING;
        this.splittable = isSplittableInitialize();
        splittableBuildStage = STAGE_INITIALIZED;
      }
      return this.splittable;
    }

    void setSplittable(boolean splittable) {
      this.splittable = splittable;
      splittableBuildStage = STAGE_INITIALIZED;
    }

    private byte collapsibleBuildStage = STAGE_UNINITIALIZED;
    private boolean collapsible;

    boolean isCollapsible() {
      if (collapsibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (collapsibleBuildStage == STAGE_UNINITIALIZED) {
        collapsibleBuildStage = STAGE_INITIALIZING;
        this.collapsible = isCollapsibleInitialize();
        collapsibleBuildStage = STAGE_INITIALIZED;
      }
      return this.collapsible;
    }

    void setCollapsible(boolean collapsible) {
      this.collapsible = collapsible;
      collapsibleBuildStage = STAGE_INITIALIZED;
    }

    private byte openBuildStage = STAGE_UNINITIALIZED;
    private boolean open;

    boolean isOpen() {
      if (openBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (openBuildStage == STAGE_UNINITIALIZED) {
        openBuildStage = STAGE_INITIALIZING;
        this.open = isOpenInitialize();
        openBuildStage = STAGE_INITIALIZED;
      }
      return this.open;
    }

    void setOpen(boolean open) {
      this.open = open;
      openBuildStage = STAGE_INITIALIZED;
    }

    private byte slidableBuildStage = STAGE_UNINITIALIZED;
    private boolean slidable;

    boolean isSlidable() {
      if (slidableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (slidableBuildStage == STAGE_UNINITIALIZED) {
        slidableBuildStage = STAGE_INITIALIZING;
        this.slidable = isSlidableInitialize();
        slidableBuildStage = STAGE_INITIALIZED;
      }
      return this.slidable;
    }

    void setSlidable(boolean slidable) {
      this.slidable = slidable;
      slidableBuildStage = STAGE_INITIALIZED;
    }

    private byte slideBuildStage = STAGE_UNINITIALIZED;
    private boolean slide;

    boolean isSlide() {
      if (slideBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (slideBuildStage == STAGE_UNINITIALIZED) {
        slideBuildStage = STAGE_INITIALIZING;
        this.slide = isSlideInitialize();
        slideBuildStage = STAGE_INITIALIZED;
      }
      return this.slide;
    }

    void setSlide(boolean slide) {
      this.slide = slide;
      slideBuildStage = STAGE_INITIALIZED;
    }

    private byte closableBuildStage = STAGE_UNINITIALIZED;
    private boolean closable;

    boolean isClosable() {
      if (closableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (closableBuildStage == STAGE_UNINITIALIZED) {
        closableBuildStage = STAGE_INITIALIZING;
        this.closable = isClosableInitialize();
        closableBuildStage = STAGE_INITIALIZED;
      }
      return this.closable;
    }

    void setClosable(boolean closable) {
      this.closable = closable;
      closableBuildStage = STAGE_INITIALIZED;
    }

    private byte nativeScrollbarBuildStage = STAGE_UNINITIALIZED;
    private boolean nativeScrollbar;

    boolean isNativeScrollbar() {
      if (nativeScrollbarBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nativeScrollbarBuildStage == STAGE_UNINITIALIZED) {
        nativeScrollbarBuildStage = STAGE_INITIALIZING;
        this.nativeScrollbar = isNativeScrollbarInitialize();
        nativeScrollbarBuildStage = STAGE_INITIALIZED;
      }
      return this.nativeScrollbar;
    }

    void setNativeScrollbar(boolean nativeScrollbar) {
      this.nativeScrollbar = nativeScrollbar;
      nativeScrollbarBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte cmarginsBuildStage = STAGE_UNINITIALIZED;
    private String cmargins;

    String getCmargins() {
      if (cmarginsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (cmarginsBuildStage == STAGE_UNINITIALIZED) {
        cmarginsBuildStage = STAGE_INITIALIZING;
        this.cmargins = Objects.requireNonNull(getCmarginsInitialize(), "cmargins");
        cmarginsBuildStage = STAGE_INITIALIZED;
      }
      return this.cmargins;
    }

    void setCmargins(String cmargins) {
      this.cmargins = cmargins;
      cmarginsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (borderBuildStage == STAGE_INITIALIZING) attributes.add("border");
      if (autoscrollBuildStage == STAGE_INITIALIZING) attributes.add("autoscroll");
      if (marginsBuildStage == STAGE_INITIALIZING) attributes.add("margins");
      if (maxsizeBuildStage == STAGE_INITIALIZING) attributes.add("maxsize");
      if (minsizeBuildStage == STAGE_INITIALIZING) attributes.add("minsize");
      if (splittableBuildStage == STAGE_INITIALIZING) attributes.add("splittable");
      if (collapsibleBuildStage == STAGE_INITIALIZING) attributes.add("collapsible");
      if (openBuildStage == STAGE_INITIALIZING) attributes.add("open");
      if (slidableBuildStage == STAGE_INITIALIZING) attributes.add("slidable");
      if (slideBuildStage == STAGE_INITIALIZING) attributes.add("slide");
      if (closableBuildStage == STAGE_INITIALIZING) attributes.add("closable");
      if (nativeScrollbarBuildStage == STAGE_INITIALIZING) attributes.add("nativeScrollbar");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (cmarginsBuildStage == STAGE_INITIALIZING) attributes.add("cmargins");
      return "Cannot build IWest, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IWest.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IWest.super.isVisible();
  }

  private String getMoldInitialize() {
    return IWest.super.getMold();
  }

  private int getZIndexInitialize() {
    return IWest.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IWest.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IWest.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IWest.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IWest.super.getRenderdefer();
  }

  private String getBorderInitialize() {
    return IWest.super.getBorder();
  }

  private boolean isAutoscrollInitialize() {
    return IWest.super.isAutoscroll();
  }

  private String getMarginsInitialize() {
    return IWest.super.getMargins();
  }

  private int getMaxsizeInitialize() {
    return IWest.super.getMaxsize();
  }

  private int getMinsizeInitialize() {
    return IWest.super.getMinsize();
  }

  private boolean isSplittableInitialize() {
    return IWest.super.isSplittable();
  }

  private boolean isCollapsibleInitialize() {
    return IWest.super.isCollapsible();
  }

  private boolean isOpenInitialize() {
    return IWest.super.isOpen();
  }

  private boolean isSlidableInitialize() {
    return IWest.super.isSlidable();
  }

  private boolean isSlideInitialize() {
    return IWest.super.isSlide();
  }

  private boolean isClosableInitialize() {
    return IWest.super.isClosable();
  }

  private boolean isNativeScrollbarInitialize() {
    return IWest.super.isNativeScrollbar();
  }

  private String getWidgetClassInitialize() {
    return IWest.super.getWidgetClass();
  }

  private String getCmarginsInitialize() {
    return IWest.super.getCmargins();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @Override
  public @Nullable String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code border} attribute
   */
  @Override
  public String getBorder() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getBorder()
        : this.border;
  }

  /**
   * @return The value of the {@code autoscroll} attribute
   */
  @Override
  public boolean isAutoscroll() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isAutoscroll()
        : this.autoscroll;
  }

  /**
   * @return The value of the {@code margins} attribute
   */
  @Override
  public String getMargins() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMargins()
        : this.margins;
  }

  /**
   * @return The value of the {@code maxsize} attribute
   */
  @Override
  public int getMaxsize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMaxsize()
        : this.maxsize;
  }

  /**
   * @return The value of the {@code minsize} attribute
   */
  @Override
  public int getMinsize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMinsize()
        : this.minsize;
  }

  /**
   * @return The value of the {@code splittable} attribute
   */
  @Override
  public boolean isSplittable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSplittable()
        : this.splittable;
  }

  /**
   * @return The value of the {@code collapsible} attribute
   */
  @Override
  public boolean isCollapsible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isCollapsible()
        : this.collapsible;
  }

  /**
   * @return The value of the {@code open} attribute
   */
  @Override
  public boolean isOpen() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isOpen()
        : this.open;
  }

  /**
   * @return The value of the {@code slidable} attribute
   */
  @Override
  public boolean isSlidable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSlidable()
        : this.slidable;
  }

  /**
   * @return The value of the {@code slide} attribute
   */
  @Override
  public boolean isSlide() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSlide()
        : this.slide;
  }

  /**
   * @return The value of the {@code closable} attribute
   */
  @Override
  public boolean isClosable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isClosable()
        : this.closable;
  }

  /**
   * @return The value of the {@code nativeScrollbar} attribute
   */
  @Override
  public boolean isNativeScrollbar() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isNativeScrollbar()
        : this.nativeScrollbar;
  }

  /**
   * @return The value of the {@code child} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable I getChild() {
    return child;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code cmargins} attribute
   */
  @Override
  public String getCmargins() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCmargins()
        : this.cmargins;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIWest<>(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IWest#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIWest<I> withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIWest<>(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.title,
          this.border,
          this.autoscroll,
          this.margins,
          this.maxsize,
          this.minsize,
          this.splittable,
          this.collapsible,
          this.open,
          this.slidable,
          this.slide,
          this.closable,
          this.nativeScrollbar,
          this.child,
          this.widgetClass,
          this.cmargins));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IWest#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIWest<I> withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by replacing the {@link IWest#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIWest<I> withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by replacing the {@link IWest#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIWest<I> withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by replacing the {@link IWest#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIWest<I> withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withTitle(@Nullable String value) {
    if (Objects.equals(this.title, value)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        value,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getBorder() border} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for border
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withBorder(String value) {
    String newValue = Objects.requireNonNull(value, "border");
    if (this.border.equals(newValue)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        newValue,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#isAutoscroll() autoscroll} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autoscroll
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withAutoscroll(boolean value) {
    if (this.autoscroll == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        value,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getMargins() margins} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for margins
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withMargins(String value) {
    String newValue = Objects.requireNonNull(value, "margins");
    if (this.margins.equals(newValue)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        newValue,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getMaxsize() maxsize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxsize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withMaxsize(int value) {
    if (this.maxsize == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        value,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getMinsize() minsize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minsize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withMinsize(int value) {
    if (this.minsize == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        value,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#isSplittable() splittable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for splittable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withSplittable(boolean value) {
    if (this.splittable == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        value,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#isCollapsible() collapsible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collapsible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withCollapsible(boolean value) {
    if (this.collapsible == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        value,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#isOpen() open} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for open
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withOpen(boolean value) {
    if (this.open == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        value,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#isSlidable() slidable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for slidable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withSlidable(boolean value) {
    if (this.slidable == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        value,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#isSlide() slide} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for slide
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withSlide(boolean value) {
    if (this.slide == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        value,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#isClosable() closable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for closable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withClosable(boolean value) {
    if (this.closable == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        value,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#isNativeScrollbar() nativeScrollbar} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nativeScrollbar
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withNativeScrollbar(boolean value) {
    if (this.nativeScrollbar == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        value,
        this.child,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getChild() child} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for child (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withChild(@Nullable I value) {
    if (this.child == value) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        value,
        this.widgetClass,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        newValue,
        this.cmargins));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWest#getCmargins() cmargins} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cmargins
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWest<I> withCmargins(String value) {
    String newValue = Objects.requireNonNull(value, "cmargins");
    if (this.cmargins.equals(newValue)) return this;
    return validate(new ImmutableIWest<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.title,
        this.border,
        this.autoscroll,
        this.margins,
        this.maxsize,
        this.minsize,
        this.splittable,
        this.collapsible,
        this.open,
        this.slidable,
        this.slide,
        this.closable,
        this.nativeScrollbar,
        this.child,
        this.widgetClass,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIWest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIWest<?>
        && equalTo((ImmutableIWest<?>) another);
  }

  private boolean equalTo(ImmutableIWest<?> another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && Objects.equals(title, another.title)
        && border.equals(another.border)
        && autoscroll == another.autoscroll
        && margins.equals(another.margins)
        && maxsize == another.maxsize
        && minsize == another.minsize
        && splittable == another.splittable
        && collapsible == another.collapsible
        && open == another.open
        && slidable == another.slidable
        && slide == another.slide
        && closable == another.closable
        && nativeScrollbar == another.nativeScrollbar
        && Objects.equals(child, another.child)
        && widgetClass.equals(another.widgetClass)
        && cmargins.equals(another.cmargins);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code title}, {@code border}, {@code autoscroll}, {@code margins}, {@code maxsize}, {@code minsize}, {@code splittable}, {@code collapsible}, {@code open}, {@code slidable}, {@code slide}, {@code closable}, {@code nativeScrollbar}, {@code child}, {@code widgetClass}, {@code cmargins}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + border.hashCode();
    h += (h << 5) + Booleans.hashCode(autoscroll);
    h += (h << 5) + margins.hashCode();
    h += (h << 5) + maxsize;
    h += (h << 5) + minsize;
    h += (h << 5) + Booleans.hashCode(splittable);
    h += (h << 5) + Booleans.hashCode(collapsible);
    h += (h << 5) + Booleans.hashCode(open);
    h += (h << 5) + Booleans.hashCode(slidable);
    h += (h << 5) + Booleans.hashCode(slide);
    h += (h << 5) + Booleans.hashCode(closable);
    h += (h << 5) + Booleans.hashCode(nativeScrollbar);
    h += (h << 5) + Objects.hashCode(child);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + cmargins.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IWest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IWest")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("title", title)
        .add("border", border)
        .add("autoscroll", autoscroll)
        .add("margins", margins)
        .add("maxsize", maxsize)
        .add("minsize", minsize)
        .add("splittable", splittable)
        .add("collapsible", collapsible)
        .add("open", open)
        .add("slidable", slidable)
        .add("slide", slide)
        .add("closable", closable)
        .add("nativeScrollbar", nativeScrollbar)
        .add("child", child)
        .add("widgetClass", widgetClass)
        .add("cmargins", cmargins)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<West> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IWest#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<West> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IWest.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static final long SIZE_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient String size;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IWest#getSize() size} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code size} attribute
   */
  @Override
  public String getSize() {
    if ((lazyInitBitmap & SIZE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SIZE_LAZY_INIT_BIT) == 0) {
          this.size = IWest.super.getSize();
          lazyInitBitmap |= SIZE_LAZY_INIT_BIT;
        }
      }
    }
    return size;
  }

  private static <I extends IAnyGroup> ImmutableIWest<I> validate(ImmutableIWest<I> instance) {
    instance = (ImmutableIWest<I>) instance.checkBorder();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIWest<I>) instance.checkDroppable();
    instance = (ImmutableIWest<I>) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IWest} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <I> generic parameter I
   * @param instance The instance to copy
   * @return A copied immutable IWest instance
   */
  public static <I extends IAnyGroup> IWest<I> copyOf(IWest<I> instance) {
    if (instance instanceof ImmutableIWest<?>) {
      return (ImmutableIWest<I>) instance;
    }
    return new IWest.Builder<I>()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IWest IWest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IWest", generator = "Immutables")
  @NotThreadSafe
  public static class Builder<I extends IAnyGroup> {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_AUTOSCROLL = 0x10L;
    private static final long OPT_BIT_MAXSIZE = 0x20L;
    private static final long OPT_BIT_MINSIZE = 0x40L;
    private static final long OPT_BIT_SPLITTABLE = 0x80L;
    private static final long OPT_BIT_COLLAPSIBLE = 0x100L;
    private static final long OPT_BIT_OPEN = 0x200L;
    private static final long OPT_BIT_SLIDABLE = 0x400L;
    private static final long OPT_BIT_SLIDE = 0x800L;
    private static final long OPT_BIT_CLOSABLE = 0x1000L;
    private static final long OPT_BIT_NATIVE_SCROLLBAR = 0x2000L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable String title;
    private @Nullable String border;
    private boolean autoscroll;
    private @Nullable String margins;
    private int maxsize;
    private int minsize;
    private boolean splittable;
    private boolean collapsible;
    private boolean open;
    private boolean slidable;
    private boolean slide;
    private boolean closable;
    private boolean nativeScrollbar;
    private @Nullable I child;
    private @Nullable String widgetClass;
    private @Nullable String cmargins;

    /**
     * Creates a builder for {@link IWest IWest} instances.
     * <pre>
     * new IWest.Builder&amp;lt;I&amp;gt;()
     *    .setId(String) // optional {@link IWest#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IWest#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IWest#getActions() actions}
     *    .setVisible(boolean) // optional {@link IWest#isVisible() visible}
     *    .setMold(String) // optional {@link IWest#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IWest#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IWest#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IWest#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IWest#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IWest#getLeft() left}
     *    .setTop(String | null) // nullable {@link IWest#getTop() top}
     *    .setZIndex(int) // optional {@link IWest#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IWest#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IWest#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IWest#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IWest#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IWest#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IWest#getStyle() style}
     *    .setDraggable(String) // optional {@link IWest#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IWest#isFocus() focus}
     *    .setDroppable(String) // optional {@link IWest#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IWest#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IWest#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IWest#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IWest#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IWest#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IWest#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IWest#getContext() context}
     *    .setPopup(String | null) // nullable {@link IWest#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IWest#getTooltip() tooltip}
     *    .setTitle(String | null) // nullable {@link IWest#getTitle() title}
     *    .setBorder(String) // optional {@link IWest#getBorder() border}
     *    .setAutoscroll(boolean) // optional {@link IWest#isAutoscroll() autoscroll}
     *    .setMargins(String) // optional {@link IWest#getMargins() margins}
     *    .setMaxsize(int) // optional {@link IWest#getMaxsize() maxsize}
     *    .setMinsize(int) // optional {@link IWest#getMinsize() minsize}
     *    .setSplittable(boolean) // optional {@link IWest#isSplittable() splittable}
     *    .setCollapsible(boolean) // optional {@link IWest#isCollapsible() collapsible}
     *    .setOpen(boolean) // optional {@link IWest#isOpen() open}
     *    .setSlidable(boolean) // optional {@link IWest#isSlidable() slidable}
     *    .setSlide(boolean) // optional {@link IWest#isSlide() slide}
     *    .setClosable(boolean) // optional {@link IWest#isClosable() closable}
     *    .setNativeScrollbar(boolean) // optional {@link IWest#isNativeScrollbar() nativeScrollbar}
     *    .setChild(I | null) // nullable {@link IWest#getChild() child}
     *    .setWidgetClass(String) // optional {@link IWest#getWidgetClass() widgetClass}
     *    .setCmargins(String) // optional {@link IWest#getCmargins() cmargins}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IWest.Builder<?>)) {
        throw new UnsupportedOperationException("Use: new IWest.Builder<I>()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IWest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> from(IWest<I> instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      @Nullable String titleValue = instance.getTitle();
      if (titleValue != null) {
        setTitle(titleValue);
      }
      setBorder(instance.getBorder());
      setAutoscroll(instance.isAutoscroll());
      setMargins(instance.getMargins());
      setMaxsize(instance.getMaxsize());
      setMinsize(instance.getMinsize());
      setSplittable(instance.isSplittable());
      setCollapsible(instance.isCollapsible());
      setOpen(instance.isOpen());
      setSlidable(instance.isSlidable());
      setSlide(instance.isSlide());
      setClosable(instance.isClosable());
      setNativeScrollbar(instance.isNativeScrollbar());
      @Nullable I childValue = instance.getChild();
      if (childValue != null) {
        setChild(childValue);
      }
      setWidgetClass(instance.getWidgetClass());
      setCmargins(instance.getCmargins());
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IWest.Builder<I>) this;
    }

    /**
     * Adds one element to {@link IWest#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IWest.Builder<I>) this;
    }

    /**
     * Adds elements to {@link IWest#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IWest.Builder<I>) this;
    }


    /**
     * Sets or replaces all elements for {@link IWest#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IWest.Builder<I>) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IWest#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IWest.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IWest#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IWest.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IWest#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IWest.Builder<I>) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IWest#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IWest.Builder<I>) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IWest#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IWest.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IWest#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IWest.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IWest#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IWest.Builder<I>) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IWest#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IWest.Builder<I>) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IWest#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IWest.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IWest#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IWest.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IWest#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IWest.Builder<I>) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IWest#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IWest.Builder<I>) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IWest#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setLeft(@Nullable String left) {
      this.left = left;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setTop(@Nullable String top) {
      this.top = top;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setHeight(@Nullable String height) {
      this.height = height;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setWidth(@Nullable String width) {
      this.width = width;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setStyle(@Nullable String style) {
      this.style = style;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setContext(@Nullable String context) {
      this.context = context;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getTitle() title} attribute.
     * @param title The value for title (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setTitle(@Nullable String title) {
      this.title = title;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getBorder() border} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#getBorder() border}.</em>
     * @param border The value for border 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setBorder(String border) {
      this.border = Objects.requireNonNull(border, "border");
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#isAutoscroll() autoscroll} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#isAutoscroll() autoscroll}.</em>
     * @param autoscroll The value for autoscroll 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setAutoscroll(boolean autoscroll) {
      this.autoscroll = autoscroll;
      optBits |= OPT_BIT_AUTOSCROLL;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getMargins() margins} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#getMargins() margins}.</em>
     * @param margins The value for margins 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setMargins(String margins) {
      this.margins = Objects.requireNonNull(margins, "margins");
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getMaxsize() maxsize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#getMaxsize() maxsize}.</em>
     * @param maxsize The value for maxsize 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setMaxsize(int maxsize) {
      this.maxsize = maxsize;
      optBits |= OPT_BIT_MAXSIZE;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getMinsize() minsize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#getMinsize() minsize}.</em>
     * @param minsize The value for minsize 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setMinsize(int minsize) {
      this.minsize = minsize;
      optBits |= OPT_BIT_MINSIZE;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#isSplittable() splittable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#isSplittable() splittable}.</em>
     * @param splittable The value for splittable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setSplittable(boolean splittable) {
      this.splittable = splittable;
      optBits |= OPT_BIT_SPLITTABLE;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#isCollapsible() collapsible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#isCollapsible() collapsible}.</em>
     * @param collapsible The value for collapsible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setCollapsible(boolean collapsible) {
      this.collapsible = collapsible;
      optBits |= OPT_BIT_COLLAPSIBLE;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#isOpen() open} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#isOpen() open}.</em>
     * @param open The value for open 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setOpen(boolean open) {
      this.open = open;
      optBits |= OPT_BIT_OPEN;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#isSlidable() slidable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#isSlidable() slidable}.</em>
     * @param slidable The value for slidable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setSlidable(boolean slidable) {
      this.slidable = slidable;
      optBits |= OPT_BIT_SLIDABLE;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#isSlide() slide} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#isSlide() slide}.</em>
     * @param slide The value for slide 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setSlide(boolean slide) {
      this.slide = slide;
      optBits |= OPT_BIT_SLIDE;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#isClosable() closable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#isClosable() closable}.</em>
     * @param closable The value for closable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setClosable(boolean closable) {
      this.closable = closable;
      optBits |= OPT_BIT_CLOSABLE;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#isNativeScrollbar() nativeScrollbar} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#isNativeScrollbar() nativeScrollbar}.</em>
     * @param nativeScrollbar The value for nativeScrollbar 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setNativeScrollbar(boolean nativeScrollbar) {
      this.nativeScrollbar = nativeScrollbar;
      optBits |= OPT_BIT_NATIVE_SCROLLBAR;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getChild() child} attribute.
     * @param child The value for child (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setChild(@Nullable I child) {
      this.child = child;
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IWest.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWest#getCmargins() cmargins} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWest#getCmargins() cmargins}.</em>
     * @param cmargins The value for cmargins 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWest.Builder<I> setCmargins(String cmargins) {
      this.cmargins = Objects.requireNonNull(cmargins, "cmargins");
      return (IWest.Builder<I>) this;
    }

    /**
     * Builds a new {@link IWest IWest}.
     * @return An immutable instance of IWest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IWest<I> build() {
      return ImmutableIWest.validate(new ImmutableIWest<I>(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean autoscrollIsSet() {
      return (optBits & OPT_BIT_AUTOSCROLL) != 0;
    }

    private boolean maxsizeIsSet() {
      return (optBits & OPT_BIT_MAXSIZE) != 0;
    }

    private boolean minsizeIsSet() {
      return (optBits & OPT_BIT_MINSIZE) != 0;
    }

    private boolean splittableIsSet() {
      return (optBits & OPT_BIT_SPLITTABLE) != 0;
    }

    private boolean collapsibleIsSet() {
      return (optBits & OPT_BIT_COLLAPSIBLE) != 0;
    }

    private boolean openIsSet() {
      return (optBits & OPT_BIT_OPEN) != 0;
    }

    private boolean slidableIsSet() {
      return (optBits & OPT_BIT_SLIDABLE) != 0;
    }

    private boolean slideIsSet() {
      return (optBits & OPT_BIT_SLIDE) != 0;
    }

    private boolean closableIsSet() {
      return (optBits & OPT_BIT_CLOSABLE) != 0;
    }

    private boolean nativeScrollbarIsSet() {
      return (optBits & OPT_BIT_NATIVE_SCROLLBAR) != 0;
    }
  }
}
