package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Timebox;

/**
 * Immutable implementation of {@link ITimebox}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ITimebox.Builder()}.
 */
@Generated(from = "ITimebox", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableITimebox implements ITimebox {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final boolean readonly;
  private final @Nullable String name;
  private final @Nullable String placeholder;
  private final @Nullable ImmutableMap<String, String> inputAttributes;
  private final @Nullable Date value;
  private final @Nullable String constraint;
  private final @Nullable String errorboxSclass;
  private final @Nullable String errorboxIconSclass;
  private final boolean disabled;
  private final boolean inplace;
  private final int maxlength;
  private final boolean instant;
  private final @Nullable String errorMessage;
  private final @Nullable Locale locale;
  private final TimeZone timeZone;
  private final @Nullable ZonedDateTime valueInZonedDateTime;
  private final @Nullable LocalDateTime valueInLocalDateTime;
  private final @Nullable LocalDate valueInLocalDate;
  private final @Nullable LocalTime valueInLocalTime;
  private final String widgetClass;
  private final boolean buttonVisible;
  private final int cols;
  private final String format;

  private ImmutableITimebox(ImmutableITimebox.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.name = builder.name;
    this.placeholder = builder.placeholder;
    this.inputAttributes = builder.inputAttributes == null ? null : builder.inputAttributes.build();
    this.value = builder.value;
    this.constraint = builder.constraint;
    this.errorboxSclass = builder.errorboxSclass;
    this.errorboxIconSclass = builder.errorboxIconSclass;
    this.errorMessage = builder.errorMessage;
    this.locale = builder.locale;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.readonlyIsSet()) {
      initShim.setReadonly(builder.readonly);
    }
    if (builder.disabledIsSet()) {
      initShim.setDisabled(builder.disabled);
    }
    if (builder.inplaceIsSet()) {
      initShim.setInplace(builder.inplace);
    }
    if (builder.maxlengthIsSet()) {
      initShim.setMaxlength(builder.maxlength);
    }
    if (builder.instantIsSet()) {
      initShim.setInstant(builder.instant);
    }
    if (builder.timeZone != null) {
      initShim.setTimeZone(builder.timeZone);
    }
    if (builder.valueInZonedDateTimeIsSet()) {
      initShim.setValueInZonedDateTime(builder.valueInZonedDateTime);
    }
    if (builder.valueInLocalDateTimeIsSet()) {
      initShim.setValueInLocalDateTime(builder.valueInLocalDateTime);
    }
    if (builder.valueInLocalDateIsSet()) {
      initShim.setValueInLocalDate(builder.valueInLocalDate);
    }
    if (builder.valueInLocalTimeIsSet()) {
      initShim.setValueInLocalTime(builder.valueInLocalTime);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.buttonVisibleIsSet()) {
      initShim.setButtonVisible(builder.buttonVisible);
    }
    if (builder.colsIsSet()) {
      initShim.setCols(builder.cols);
    }
    if (builder.format != null) {
      initShim.setFormat(builder.format);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.readonly = initShim.isReadonly();
    this.disabled = initShim.isDisabled();
    this.inplace = initShim.isInplace();
    this.maxlength = initShim.getMaxlength();
    this.instant = initShim.getInstant();
    this.timeZone = initShim.getTimeZone();
    this.valueInZonedDateTime = initShim.getValueInZonedDateTime();
    this.valueInLocalDateTime = initShim.getValueInLocalDateTime();
    this.valueInLocalDate = initShim.getValueInLocalDate();
    this.valueInLocalTime = initShim.getValueInLocalTime();
    this.widgetClass = initShim.getWidgetClass();
    this.buttonVisible = initShim.isButtonVisible();
    this.cols = initShim.getCols();
    this.format = initShim.getFormat();
    this.initShim = null;
  }

  private ImmutableITimebox(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      boolean readonly,
      @Nullable String name,
      @Nullable String placeholder,
      @Nullable ImmutableMap<String, String> inputAttributes,
      @Nullable Date value,
      @Nullable String constraint,
      @Nullable String errorboxSclass,
      @Nullable String errorboxIconSclass,
      boolean disabled,
      boolean inplace,
      int maxlength,
      boolean instant,
      @Nullable String errorMessage,
      @Nullable Locale locale,
      TimeZone timeZone,
      @Nullable ZonedDateTime valueInZonedDateTime,
      @Nullable LocalDateTime valueInLocalDateTime,
      @Nullable LocalDate valueInLocalDate,
      @Nullable LocalTime valueInLocalTime,
      String widgetClass,
      boolean buttonVisible,
      int cols,
      String format) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.readonly = readonly;
    this.name = name;
    this.placeholder = placeholder;
    this.inputAttributes = inputAttributes;
    this.value = value;
    this.constraint = constraint;
    this.errorboxSclass = errorboxSclass;
    this.errorboxIconSclass = errorboxIconSclass;
    this.disabled = disabled;
    this.inplace = inplace;
    this.maxlength = maxlength;
    this.instant = instant;
    this.errorMessage = errorMessage;
    this.locale = locale;
    this.timeZone = timeZone;
    this.valueInZonedDateTime = valueInZonedDateTime;
    this.valueInLocalDateTime = valueInLocalDateTime;
    this.valueInLocalDate = valueInLocalDate;
    this.valueInLocalTime = valueInLocalTime;
    this.widgetClass = widgetClass;
    this.buttonVisible = buttonVisible;
    this.cols = cols;
    this.format = format;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ITimebox", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte readonlyBuildStage = STAGE_UNINITIALIZED;
    private boolean readonly;

    boolean isReadonly() {
      if (readonlyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (readonlyBuildStage == STAGE_UNINITIALIZED) {
        readonlyBuildStage = STAGE_INITIALIZING;
        this.readonly = isReadonlyInitialize();
        readonlyBuildStage = STAGE_INITIALIZED;
      }
      return this.readonly;
    }

    void setReadonly(boolean readonly) {
      this.readonly = readonly;
      readonlyBuildStage = STAGE_INITIALIZED;
    }

    private byte disabledBuildStage = STAGE_UNINITIALIZED;
    private boolean disabled;

    boolean isDisabled() {
      if (disabledBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disabledBuildStage == STAGE_UNINITIALIZED) {
        disabledBuildStage = STAGE_INITIALIZING;
        this.disabled = isDisabledInitialize();
        disabledBuildStage = STAGE_INITIALIZED;
      }
      return this.disabled;
    }

    void setDisabled(boolean disabled) {
      this.disabled = disabled;
      disabledBuildStage = STAGE_INITIALIZED;
    }

    private byte inplaceBuildStage = STAGE_UNINITIALIZED;
    private boolean inplace;

    boolean isInplace() {
      if (inplaceBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (inplaceBuildStage == STAGE_UNINITIALIZED) {
        inplaceBuildStage = STAGE_INITIALIZING;
        this.inplace = isInplaceInitialize();
        inplaceBuildStage = STAGE_INITIALIZED;
      }
      return this.inplace;
    }

    void setInplace(boolean inplace) {
      this.inplace = inplace;
      inplaceBuildStage = STAGE_INITIALIZED;
    }

    private byte maxlengthBuildStage = STAGE_UNINITIALIZED;
    private int maxlength;

    int getMaxlength() {
      if (maxlengthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxlengthBuildStage == STAGE_UNINITIALIZED) {
        maxlengthBuildStage = STAGE_INITIALIZING;
        this.maxlength = getMaxlengthInitialize();
        maxlengthBuildStage = STAGE_INITIALIZED;
      }
      return this.maxlength;
    }

    void setMaxlength(int maxlength) {
      this.maxlength = maxlength;
      maxlengthBuildStage = STAGE_INITIALIZED;
    }

    private byte instantBuildStage = STAGE_UNINITIALIZED;
    private boolean instant;

    boolean getInstant() {
      if (instantBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (instantBuildStage == STAGE_UNINITIALIZED) {
        instantBuildStage = STAGE_INITIALIZING;
        this.instant = getInstantInitialize();
        instantBuildStage = STAGE_INITIALIZED;
      }
      return this.instant;
    }

    void setInstant(boolean instant) {
      this.instant = instant;
      instantBuildStage = STAGE_INITIALIZED;
    }

    private byte timeZoneBuildStage = STAGE_UNINITIALIZED;
    private TimeZone timeZone;

    TimeZone getTimeZone() {
      if (timeZoneBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (timeZoneBuildStage == STAGE_UNINITIALIZED) {
        timeZoneBuildStage = STAGE_INITIALIZING;
        this.timeZone = Objects.requireNonNull(getTimeZoneInitialize(), "timeZone");
        timeZoneBuildStage = STAGE_INITIALIZED;
      }
      return this.timeZone;
    }

    void setTimeZone(TimeZone timeZone) {
      this.timeZone = timeZone;
      timeZoneBuildStage = STAGE_INITIALIZED;
    }

    private byte valueInZonedDateTimeBuildStage = STAGE_UNINITIALIZED;
    private ZonedDateTime valueInZonedDateTime;

    ZonedDateTime getValueInZonedDateTime() {
      if (valueInZonedDateTimeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (valueInZonedDateTimeBuildStage == STAGE_UNINITIALIZED) {
        valueInZonedDateTimeBuildStage = STAGE_INITIALIZING;
        this.valueInZonedDateTime = getValueInZonedDateTimeInitialize();
        valueInZonedDateTimeBuildStage = STAGE_INITIALIZED;
      }
      return this.valueInZonedDateTime;
    }

    void setValueInZonedDateTime(ZonedDateTime valueInZonedDateTime) {
      this.valueInZonedDateTime = valueInZonedDateTime;
      valueInZonedDateTimeBuildStage = STAGE_INITIALIZED;
    }

    private byte valueInLocalDateTimeBuildStage = STAGE_UNINITIALIZED;
    private LocalDateTime valueInLocalDateTime;

    LocalDateTime getValueInLocalDateTime() {
      if (valueInLocalDateTimeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (valueInLocalDateTimeBuildStage == STAGE_UNINITIALIZED) {
        valueInLocalDateTimeBuildStage = STAGE_INITIALIZING;
        this.valueInLocalDateTime = getValueInLocalDateTimeInitialize();
        valueInLocalDateTimeBuildStage = STAGE_INITIALIZED;
      }
      return this.valueInLocalDateTime;
    }

    void setValueInLocalDateTime(LocalDateTime valueInLocalDateTime) {
      this.valueInLocalDateTime = valueInLocalDateTime;
      valueInLocalDateTimeBuildStage = STAGE_INITIALIZED;
    }

    private byte valueInLocalDateBuildStage = STAGE_UNINITIALIZED;
    private LocalDate valueInLocalDate;

    LocalDate getValueInLocalDate() {
      if (valueInLocalDateBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (valueInLocalDateBuildStage == STAGE_UNINITIALIZED) {
        valueInLocalDateBuildStage = STAGE_INITIALIZING;
        this.valueInLocalDate = getValueInLocalDateInitialize();
        valueInLocalDateBuildStage = STAGE_INITIALIZED;
      }
      return this.valueInLocalDate;
    }

    void setValueInLocalDate(LocalDate valueInLocalDate) {
      this.valueInLocalDate = valueInLocalDate;
      valueInLocalDateBuildStage = STAGE_INITIALIZED;
    }

    private byte valueInLocalTimeBuildStage = STAGE_UNINITIALIZED;
    private LocalTime valueInLocalTime;

    LocalTime getValueInLocalTime() {
      if (valueInLocalTimeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (valueInLocalTimeBuildStage == STAGE_UNINITIALIZED) {
        valueInLocalTimeBuildStage = STAGE_INITIALIZING;
        this.valueInLocalTime = getValueInLocalTimeInitialize();
        valueInLocalTimeBuildStage = STAGE_INITIALIZED;
      }
      return this.valueInLocalTime;
    }

    void setValueInLocalTime(LocalTime valueInLocalTime) {
      this.valueInLocalTime = valueInLocalTime;
      valueInLocalTimeBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte buttonVisibleBuildStage = STAGE_UNINITIALIZED;
    private boolean buttonVisible;

    boolean isButtonVisible() {
      if (buttonVisibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (buttonVisibleBuildStage == STAGE_UNINITIALIZED) {
        buttonVisibleBuildStage = STAGE_INITIALIZING;
        this.buttonVisible = isButtonVisibleInitialize();
        buttonVisibleBuildStage = STAGE_INITIALIZED;
      }
      return this.buttonVisible;
    }

    void setButtonVisible(boolean buttonVisible) {
      this.buttonVisible = buttonVisible;
      buttonVisibleBuildStage = STAGE_INITIALIZED;
    }

    private byte colsBuildStage = STAGE_UNINITIALIZED;
    private int cols;

    int getCols() {
      if (colsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (colsBuildStage == STAGE_UNINITIALIZED) {
        colsBuildStage = STAGE_INITIALIZING;
        this.cols = getColsInitialize();
        colsBuildStage = STAGE_INITIALIZED;
      }
      return this.cols;
    }

    void setCols(int cols) {
      this.cols = cols;
      colsBuildStage = STAGE_INITIALIZED;
    }

    private byte formatBuildStage = STAGE_UNINITIALIZED;
    private String format;

    String getFormat() {
      if (formatBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (formatBuildStage == STAGE_UNINITIALIZED) {
        formatBuildStage = STAGE_INITIALIZING;
        this.format = Objects.requireNonNull(getFormatInitialize(), "format");
        formatBuildStage = STAGE_INITIALIZED;
      }
      return this.format;
    }

    void setFormat(String format) {
      this.format = format;
      formatBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (readonlyBuildStage == STAGE_INITIALIZING) attributes.add("readonly");
      if (disabledBuildStage == STAGE_INITIALIZING) attributes.add("disabled");
      if (inplaceBuildStage == STAGE_INITIALIZING) attributes.add("inplace");
      if (maxlengthBuildStage == STAGE_INITIALIZING) attributes.add("maxlength");
      if (instantBuildStage == STAGE_INITIALIZING) attributes.add("instant");
      if (timeZoneBuildStage == STAGE_INITIALIZING) attributes.add("timeZone");
      if (valueInZonedDateTimeBuildStage == STAGE_INITIALIZING) attributes.add("valueInZonedDateTime");
      if (valueInLocalDateTimeBuildStage == STAGE_INITIALIZING) attributes.add("valueInLocalDateTime");
      if (valueInLocalDateBuildStage == STAGE_INITIALIZING) attributes.add("valueInLocalDate");
      if (valueInLocalTimeBuildStage == STAGE_INITIALIZING) attributes.add("valueInLocalTime");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (buttonVisibleBuildStage == STAGE_INITIALIZING) attributes.add("buttonVisible");
      if (colsBuildStage == STAGE_INITIALIZING) attributes.add("cols");
      if (formatBuildStage == STAGE_INITIALIZING) attributes.add("format");
      return "Cannot build ITimebox, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return ITimebox.super.getId();
  }

  private boolean isVisibleInitialize() {
    return ITimebox.super.isVisible();
  }

  private String getMoldInitialize() {
    return ITimebox.super.getMold();
  }

  private int getZIndexInitialize() {
    return ITimebox.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return ITimebox.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return ITimebox.super.isFocus();
  }

  private String getDroppableInitialize() {
    return ITimebox.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return ITimebox.super.getRenderdefer();
  }

  private boolean isReadonlyInitialize() {
    return ITimebox.super.isReadonly();
  }

  private boolean isDisabledInitialize() {
    return ITimebox.super.isDisabled();
  }

  private boolean isInplaceInitialize() {
    return ITimebox.super.isInplace();
  }

  private int getMaxlengthInitialize() {
    return ITimebox.super.getMaxlength();
  }

  private boolean getInstantInitialize() {
    return ITimebox.super.getInstant();
  }

  private TimeZone getTimeZoneInitialize() {
    return ITimebox.super.getTimeZone();
  }

  private @Nullable ZonedDateTime getValueInZonedDateTimeInitialize() {
    return ITimebox.super.getValueInZonedDateTime();
  }

  private @Nullable LocalDateTime getValueInLocalDateTimeInitialize() {
    return ITimebox.super.getValueInLocalDateTime();
  }

  private @Nullable LocalDate getValueInLocalDateInitialize() {
    return ITimebox.super.getValueInLocalDate();
  }

  private @Nullable LocalTime getValueInLocalTimeInitialize() {
    return ITimebox.super.getValueInLocalTime();
  }

  private String getWidgetClassInitialize() {
    return ITimebox.super.getWidgetClass();
  }

  private boolean isButtonVisibleInitialize() {
    return ITimebox.super.isButtonVisible();
  }

  private int getColsInitialize() {
    return ITimebox.super.getCols();
  }

  private String getFormatInitialize() {
    return ITimebox.super.getFormat();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code readonly} attribute
   */
  @Override
  public boolean isReadonly() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isReadonly()
        : this.readonly;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @Override
  public @Nullable String getPlaceholder() {
    return placeholder;
  }

  /**
   * @return The value of the {@code inputAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getInputAttributes() {
    return inputAttributes;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public @Nullable Date getValue() {
    return value;
  }

  /**
   * @return The value of the {@code constraint} attribute
   */
  @Override
  public @Nullable String getConstraint() {
    return constraint;
  }

  /**
   * @return The value of the {@code errorboxSclass} attribute
   */
  @Override
  public @Nullable String getErrorboxSclass() {
    return errorboxSclass;
  }

  /**
   * @return The value of the {@code errorboxIconSclass} attribute
   */
  @Override
  public @Nullable String getErrorboxIconSclass() {
    return errorboxIconSclass;
  }

  /**
   * @return The value of the {@code disabled} attribute
   */
  @Override
  public boolean isDisabled() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDisabled()
        : this.disabled;
  }

  /**
   * @return The value of the {@code inplace} attribute
   */
  @Override
  public boolean isInplace() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isInplace()
        : this.inplace;
  }

  /**
   * @return The value of the {@code maxlength} attribute
   */
  @Override
  public int getMaxlength() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMaxlength()
        : this.maxlength;
  }

  /**
   * @return The value of the {@code instant} attribute
   */
  @Override
  public boolean getInstant() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getInstant()
        : this.instant;
  }

  /**
   * @return The value of the {@code errorMessage} attribute
   */
  @Override
  public @Nullable String getErrorMessage() {
    return errorMessage;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @Override
  public @Nullable Locale getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code timeZone} attribute
   */
  @Override
  public TimeZone getTimeZone() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getTimeZone()
        : this.timeZone;
  }

  /**
   * @return The value of the {@code valueInZonedDateTime} attribute
   */
  @Override
  public @Nullable ZonedDateTime getValueInZonedDateTime() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getValueInZonedDateTime()
        : this.valueInZonedDateTime;
  }

  /**
   * @return The value of the {@code valueInLocalDateTime} attribute
   */
  @Override
  public @Nullable LocalDateTime getValueInLocalDateTime() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getValueInLocalDateTime()
        : this.valueInLocalDateTime;
  }

  /**
   * @return The value of the {@code valueInLocalDate} attribute
   */
  @Override
  public @Nullable LocalDate getValueInLocalDate() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getValueInLocalDate()
        : this.valueInLocalDate;
  }

  /**
   * @return The value of the {@code valueInLocalTime} attribute
   */
  @Override
  public @Nullable LocalTime getValueInLocalTime() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getValueInLocalTime()
        : this.valueInLocalTime;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code buttonVisible} attribute
   */
  @Override
  public boolean isButtonVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isButtonVisible()
        : this.buttonVisible;
  }

  /**
   * @return The value of the {@code cols} attribute
   */
  @Override
  public int getCols() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCols()
        : this.cols;
  }

  /**
   * @return The value of the {@code format} attribute
   */
  @Override
  public String getFormat() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getFormat()
        : this.format;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableITimebox(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ITimebox#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITimebox withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableITimebox(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.readonly,
          this.name,
          this.placeholder,
          this.inputAttributes,
          this.value,
          this.constraint,
          this.errorboxSclass,
          this.errorboxIconSclass,
          this.disabled,
          this.inplace,
          this.maxlength,
          this.instant,
          this.errorMessage,
          this.locale,
          this.timeZone,
          this.valueInZonedDateTime,
          this.valueInLocalDateTime,
          this.valueInLocalDate,
          this.valueInLocalTime,
          this.widgetClass,
          this.buttonVisible,
          this.cols,
          this.format));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ITimebox#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITimebox withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by replacing the {@link ITimebox#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITimebox withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by replacing the {@link ITimebox#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITimebox withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by replacing the {@link ITimebox#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITimebox withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#isReadonly() readonly} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for readonly
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withReadonly(boolean value) {
    if (this.readonly == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        value,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        value,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getPlaceholder() placeholder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for placeholder (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withPlaceholder(@Nullable String value) {
    if (Objects.equals(this.placeholder, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        value,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by replacing the {@link ITimebox#getInputAttributes() inputAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the inputAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITimebox withInputAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.inputAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        newValue,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withValue(@Nullable Date value) {
    if (this.value == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getConstraint() constraint} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for constraint (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withConstraint(@Nullable String value) {
    if (Objects.equals(this.constraint, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        value,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getErrorboxSclass() errorboxSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorboxSclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withErrorboxSclass(@Nullable String value) {
    if (Objects.equals(this.errorboxSclass, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        value,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getErrorboxIconSclass() errorboxIconSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorboxIconSclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withErrorboxIconSclass(@Nullable String value) {
    if (Objects.equals(this.errorboxIconSclass, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        value,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#isDisabled() disabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withDisabled(boolean value) {
    if (this.disabled == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        value,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#isInplace() inplace} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inplace
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withInplace(boolean value) {
    if (this.inplace == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        value,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getMaxlength() maxlength} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxlength
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withMaxlength(int value) {
    if (this.maxlength == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        value,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getInstant() instant} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for instant
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withInstant(boolean value) {
    if (this.instant == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        value,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getErrorMessage() errorMessage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorMessage (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withErrorMessage(@Nullable String value) {
    if (Objects.equals(this.errorMessage, value)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        value,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getLocale() locale} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withLocale(@Nullable Locale value) {
    if (this.locale == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        value,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getTimeZone() timeZone} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeZone
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withTimeZone(TimeZone value) {
    if (this.timeZone == value) return this;
    TimeZone newValue = Objects.requireNonNull(value, "timeZone");
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        newValue,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getValueInZonedDateTime() valueInZonedDateTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueInZonedDateTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withValueInZonedDateTime(@Nullable ZonedDateTime value) {
    if (this.valueInZonedDateTime == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        value,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getValueInLocalDateTime() valueInLocalDateTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueInLocalDateTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withValueInLocalDateTime(@Nullable LocalDateTime value) {
    if (this.valueInLocalDateTime == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        value,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getValueInLocalDate() valueInLocalDate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueInLocalDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withValueInLocalDate(@Nullable LocalDate value) {
    if (this.valueInLocalDate == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        value,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getValueInLocalTime() valueInLocalTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueInLocalTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withValueInLocalTime(@Nullable LocalTime value) {
    if (this.valueInLocalTime == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        value,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        newValue,
        this.buttonVisible,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#isButtonVisible() buttonVisible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for buttonVisible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withButtonVisible(boolean value) {
    if (this.buttonVisible == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        value,
        this.cols,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getCols() cols} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cols
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withCols(int value) {
    if (this.cols == value) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        value,
        this.format));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITimebox#getFormat() format} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for format
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITimebox withFormat(String value) {
    String newValue = Objects.requireNonNull(value, "format");
    if (this.format.equals(newValue)) return this;
    return validate(new ImmutableITimebox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.instant,
        this.errorMessage,
        this.locale,
        this.timeZone,
        this.valueInZonedDateTime,
        this.valueInLocalDateTime,
        this.valueInLocalDate,
        this.valueInLocalTime,
        this.widgetClass,
        this.buttonVisible,
        this.cols,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableITimebox} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableITimebox
        && equalTo((ImmutableITimebox) another);
  }

  private boolean equalTo(ImmutableITimebox another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && readonly == another.readonly
        && Objects.equals(name, another.name)
        && Objects.equals(placeholder, another.placeholder)
        && Objects.equals(inputAttributes, another.inputAttributes)
        && Objects.equals(value, another.value)
        && Objects.equals(constraint, another.constraint)
        && Objects.equals(errorboxSclass, another.errorboxSclass)
        && Objects.equals(errorboxIconSclass, another.errorboxIconSclass)
        && disabled == another.disabled
        && inplace == another.inplace
        && maxlength == another.maxlength
        && instant == another.instant
        && Objects.equals(errorMessage, another.errorMessage)
        && Objects.equals(locale, another.locale)
        && timeZone.equals(another.timeZone)
        && Objects.equals(valueInZonedDateTime, another.valueInZonedDateTime)
        && Objects.equals(valueInLocalDateTime, another.valueInLocalDateTime)
        && Objects.equals(valueInLocalDate, another.valueInLocalDate)
        && Objects.equals(valueInLocalTime, another.valueInLocalTime)
        && widgetClass.equals(another.widgetClass)
        && buttonVisible == another.buttonVisible
        && cols == another.cols
        && format.equals(another.format);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code readonly}, {@code name}, {@code placeholder}, {@code inputAttributes}, {@code value}, {@code constraint}, {@code errorboxSclass}, {@code errorboxIconSclass}, {@code disabled}, {@code inplace}, {@code maxlength}, {@code instant}, {@code errorMessage}, {@code locale}, {@code timeZone}, {@code valueInZonedDateTime}, {@code valueInLocalDateTime}, {@code valueInLocalDate}, {@code valueInLocalTime}, {@code widgetClass}, {@code buttonVisible}, {@code cols}, {@code format}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + Booleans.hashCode(readonly);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(placeholder);
    h += (h << 5) + Objects.hashCode(inputAttributes);
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Objects.hashCode(constraint);
    h += (h << 5) + Objects.hashCode(errorboxSclass);
    h += (h << 5) + Objects.hashCode(errorboxIconSclass);
    h += (h << 5) + Booleans.hashCode(disabled);
    h += (h << 5) + Booleans.hashCode(inplace);
    h += (h << 5) + maxlength;
    h += (h << 5) + Booleans.hashCode(instant);
    h += (h << 5) + Objects.hashCode(errorMessage);
    h += (h << 5) + Objects.hashCode(locale);
    h += (h << 5) + timeZone.hashCode();
    h += (h << 5) + Objects.hashCode(valueInZonedDateTime);
    h += (h << 5) + Objects.hashCode(valueInLocalDateTime);
    h += (h << 5) + Objects.hashCode(valueInLocalDate);
    h += (h << 5) + Objects.hashCode(valueInLocalTime);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Booleans.hashCode(buttonVisible);
    h += (h << 5) + cols;
    h += (h << 5) + format.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ITimebox} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ITimebox")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("readonly", readonly)
        .add("name", name)
        .add("placeholder", placeholder)
        .add("inputAttributes", inputAttributes)
        .add("value", value)
        .add("constraint", constraint)
        .add("errorboxSclass", errorboxSclass)
        .add("errorboxIconSclass", errorboxIconSclass)
        .add("disabled", disabled)
        .add("inplace", inplace)
        .add("maxlength", maxlength)
        .add("instant", instant)
        .add("errorMessage", errorMessage)
        .add("locale", locale)
        .add("timeZone", timeZone)
        .add("valueInZonedDateTime", valueInZonedDateTime)
        .add("valueInLocalDateTime", valueInLocalDateTime)
        .add("valueInLocalDate", valueInLocalDate)
        .add("valueInLocalTime", valueInLocalTime)
        .add("widgetClass", widgetClass)
        .add("buttonVisible", buttonVisible)
        .add("cols", cols)
        .add("format", format)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long ZONE_ID_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient ZoneId zoneId;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ITimebox#getZoneId() zoneId} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zoneId} attribute
   */
  @Override
  public ZoneId getZoneId() {
    if ((lazyInitBitmap & ZONE_ID_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ZONE_ID_LAZY_INIT_BIT) == 0) {
          this.zoneId = ITimebox.super.getZoneId();
          lazyInitBitmap |= ZONE_ID_LAZY_INIT_BIT;
        }
      }
    }
    return zoneId;
  }

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient Class<Timebox> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ITimebox#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Timebox> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(ITimebox.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static final long UNFORMATER_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient String unformater;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ITimebox#getUnformater() unformater} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code unformater} attribute
   */
  @Override
  public String getUnformater() {
    if ((lazyInitBitmap & UNFORMATER_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & UNFORMATER_LAZY_INIT_BIT) == 0) {
          this.unformater = ITimebox.super.getUnformater();
          lazyInitBitmap |= UNFORMATER_LAZY_INIT_BIT;
        }
      }
    }
    return unformater;
  }

  private static final long REAL_FORMAT_LAZY_INIT_BIT = 0x8L;

  @SuppressWarnings("Immutable")
  private transient String realFormat;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ITimebox#getRealFormat() realFormat} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code realFormat} attribute
   */
  @Override
  public String getRealFormat() {
    if ((lazyInitBitmap & REAL_FORMAT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & REAL_FORMAT_LAZY_INIT_BIT) == 0) {
          this.realFormat = Objects.requireNonNull(ITimebox.super.getRealFormat(), "realFormat");
          lazyInitBitmap |= REAL_FORMAT_LAZY_INIT_BIT;
        }
      }
    }
    return realFormat;
  }

  private static ImmutableITimebox validate(ImmutableITimebox instance) {
    instance = (ImmutableITimebox) instance.updateValue();
    instance.checkCols();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableITimebox) instance.checkDroppable();
    instance = (ImmutableITimebox) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ITimebox} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ITimebox instance
   */
  public static ITimebox copyOf(ITimebox instance) {
    if (instance instanceof ImmutableITimebox) {
      return (ImmutableITimebox) instance;
    }
    return new ITimebox.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ITimebox ITimebox}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ITimebox", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_READONLY = 0x10L;
    private static final long OPT_BIT_DISABLED = 0x20L;
    private static final long OPT_BIT_INPLACE = 0x40L;
    private static final long OPT_BIT_MAXLENGTH = 0x80L;
    private static final long OPT_BIT_INSTANT = 0x100L;
    private static final long OPT_BIT_VALUE_IN_ZONED_DATE_TIME = 0x200L;
    private static final long OPT_BIT_VALUE_IN_LOCAL_DATE_TIME = 0x400L;
    private static final long OPT_BIT_VALUE_IN_LOCAL_DATE = 0x800L;
    private static final long OPT_BIT_VALUE_IN_LOCAL_TIME = 0x1000L;
    private static final long OPT_BIT_BUTTON_VISIBLE = 0x2000L;
    private static final long OPT_BIT_COLS = 0x4000L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private boolean readonly;
    private @Nullable String name;
    private @Nullable String placeholder;
    private ImmutableMap.Builder<String, String> inputAttributes = null;
    private @Nullable Date value;
    private @Nullable String constraint;
    private @Nullable String errorboxSclass;
    private @Nullable String errorboxIconSclass;
    private boolean disabled;
    private boolean inplace;
    private int maxlength;
    private boolean instant;
    private @Nullable String errorMessage;
    private @Nullable Locale locale;
    private @Nullable TimeZone timeZone;
    private @Nullable ZonedDateTime valueInZonedDateTime;
    private @Nullable LocalDateTime valueInLocalDateTime;
    private @Nullable LocalDate valueInLocalDate;
    private @Nullable LocalTime valueInLocalTime;
    private @Nullable String widgetClass;
    private boolean buttonVisible;
    private int cols;
    private @Nullable String format;

    /**
     * Creates a builder for {@link ITimebox ITimebox} instances.
     * <pre>
     * new ITimebox.Builder()
     *    .setId(String) // optional {@link ITimebox#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link ITimebox#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link ITimebox#getActions() actions}
     *    .setVisible(boolean) // optional {@link ITimebox#isVisible() visible}
     *    .setMold(String) // optional {@link ITimebox#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link ITimebox#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ITimebox#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ITimebox#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ITimebox#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link ITimebox#getLeft() left}
     *    .setTop(String | null) // nullable {@link ITimebox#getTop() top}
     *    .setZIndex(int) // optional {@link ITimebox#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link ITimebox#getHeight() height}
     *    .setWidth(String | null) // nullable {@link ITimebox#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link ITimebox#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link ITimebox#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link ITimebox#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link ITimebox#getStyle() style}
     *    .setDraggable(String) // optional {@link ITimebox#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link ITimebox#isFocus() focus}
     *    .setDroppable(String) // optional {@link ITimebox#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link ITimebox#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link ITimebox#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link ITimebox#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link ITimebox#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link ITimebox#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link ITimebox#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link ITimebox#getContext() context}
     *    .setPopup(String | null) // nullable {@link ITimebox#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link ITimebox#getTooltip() tooltip}
     *    .setReadonly(boolean) // optional {@link ITimebox#isReadonly() readonly}
     *    .setName(String | null) // nullable {@link ITimebox#getName() name}
     *    .setPlaceholder(String | null) // nullable {@link ITimebox#getPlaceholder() placeholder}
     *    .setInputAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ITimebox#getInputAttributes() inputAttributes}
     *    .setValue(Date | null) // nullable {@link ITimebox#getValue() value}
     *    .setConstraint(String | null) // nullable {@link ITimebox#getConstraint() constraint}
     *    .setErrorboxSclass(String | null) // nullable {@link ITimebox#getErrorboxSclass() errorboxSclass}
     *    .setErrorboxIconSclass(String | null) // nullable {@link ITimebox#getErrorboxIconSclass() errorboxIconSclass}
     *    .setDisabled(boolean) // optional {@link ITimebox#isDisabled() disabled}
     *    .setInplace(boolean) // optional {@link ITimebox#isInplace() inplace}
     *    .setMaxlength(int) // optional {@link ITimebox#getMaxlength() maxlength}
     *    .setInstant(boolean) // optional {@link ITimebox#getInstant() instant}
     *    .setErrorMessage(String | null) // nullable {@link ITimebox#getErrorMessage() errorMessage}
     *    .setLocale(Locale | null) // nullable {@link ITimebox#getLocale() locale}
     *    .setTimeZone(TimeZone) // optional {@link ITimebox#getTimeZone() timeZone}
     *    .setValueInZonedDateTime(java.time.ZonedDateTime | null) // nullable {@link ITimebox#getValueInZonedDateTime() valueInZonedDateTime}
     *    .setValueInLocalDateTime(java.time.LocalDateTime | null) // nullable {@link ITimebox#getValueInLocalDateTime() valueInLocalDateTime}
     *    .setValueInLocalDate(java.time.LocalDate | null) // nullable {@link ITimebox#getValueInLocalDate() valueInLocalDate}
     *    .setValueInLocalTime(java.time.LocalTime | null) // nullable {@link ITimebox#getValueInLocalTime() valueInLocalTime}
     *    .setWidgetClass(String) // optional {@link ITimebox#getWidgetClass() widgetClass}
     *    .setButtonVisible(boolean) // optional {@link ITimebox#isButtonVisible() buttonVisible}
     *    .setCols(int) // optional {@link ITimebox#getCols() cols}
     *    .setFormat(String) // optional {@link ITimebox#getFormat() format}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ITimebox.Builder)) {
        throw new UnsupportedOperationException("Use: new ITimebox.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ITimebox} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder from(ITimebox instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setReadonly(instance.isReadonly());
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        setName(nameValue);
      }
      @Nullable String placeholderValue = instance.getPlaceholder();
      if (placeholderValue != null) {
        setPlaceholder(placeholderValue);
      }
      @Nullable Map<String, String> inputAttributesValue = instance.getInputAttributes();
      if (inputAttributesValue != null) {
        putAllInputAttributes(inputAttributesValue);
      }
      @Nullable Date valueValue = instance.getValue();
      if (valueValue != null) {
        setValue(valueValue);
      }
      @Nullable String constraintValue = instance.getConstraint();
      if (constraintValue != null) {
        setConstraint(constraintValue);
      }
      @Nullable String errorboxSclassValue = instance.getErrorboxSclass();
      if (errorboxSclassValue != null) {
        setErrorboxSclass(errorboxSclassValue);
      }
      @Nullable String errorboxIconSclassValue = instance.getErrorboxIconSclass();
      if (errorboxIconSclassValue != null) {
        setErrorboxIconSclass(errorboxIconSclassValue);
      }
      setDisabled(instance.isDisabled());
      setInplace(instance.isInplace());
      setMaxlength(instance.getMaxlength());
      setInstant(instance.getInstant());
      @Nullable String errorMessageValue = instance.getErrorMessage();
      if (errorMessageValue != null) {
        setErrorMessage(errorMessageValue);
      }
      @Nullable Locale localeValue = instance.getLocale();
      if (localeValue != null) {
        setLocale(localeValue);
      }
      setTimeZone(instance.getTimeZone());
      @Nullable ZonedDateTime valueInZonedDateTimeValue = instance.getValueInZonedDateTime();
      if (valueInZonedDateTimeValue != null) {
        setValueInZonedDateTime(valueInZonedDateTimeValue);
      }
      @Nullable LocalDateTime valueInLocalDateTimeValue = instance.getValueInLocalDateTime();
      if (valueInLocalDateTimeValue != null) {
        setValueInLocalDateTime(valueInLocalDateTimeValue);
      }
      @Nullable LocalDate valueInLocalDateValue = instance.getValueInLocalDate();
      if (valueInLocalDateValue != null) {
        setValueInLocalDate(valueInLocalDateValue);
      }
      @Nullable LocalTime valueInLocalTimeValue = instance.getValueInLocalTime();
      if (valueInLocalTimeValue != null) {
        setValueInLocalTime(valueInLocalTimeValue);
      }
      setWidgetClass(instance.getWidgetClass());
      setButtonVisible(instance.isButtonVisible());
      setCols(instance.getCols());
      setFormat(instance.getFormat());
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (ITimebox.Builder) this;
    }

    /**
     * Adds one element to {@link ITimebox#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (ITimebox.Builder) this;
    }

    /**
     * Adds elements to {@link ITimebox#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (ITimebox.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link ITimebox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (ITimebox.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link ITimebox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (ITimebox.Builder) this;
    }

    /**
     * Put one entry to the {@link ITimebox#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (ITimebox.Builder) this;
    }

    /**
     * Put one entry to the {@link ITimebox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (ITimebox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ITimebox#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (ITimebox.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ITimebox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (ITimebox.Builder) this;
    }

    /**
     * Put one entry to the {@link ITimebox#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (ITimebox.Builder) this;
    }

    /**
     * Put one entry to the {@link ITimebox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (ITimebox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ITimebox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (ITimebox.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ITimebox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (ITimebox.Builder) this;
    }

    /**
     * Put one entry to the {@link ITimebox#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (ITimebox.Builder) this;
    }

    /**
     * Put one entry to the {@link ITimebox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (ITimebox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ITimebox#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (ITimebox.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ITimebox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setTop(@Nullable String top) {
      this.top = top;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setContext(@Nullable String context) {
      this.context = context;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#isReadonly() readonly} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#isReadonly() readonly}.</em>
     * @param readonly The value for readonly 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setReadonly(boolean readonly) {
      this.readonly = readonly;
      optBits |= OPT_BIT_READONLY;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setName(@Nullable String name) {
      this.name = name;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getPlaceholder() placeholder} attribute.
     * @param placeholder The value for placeholder (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setPlaceholder(@Nullable String placeholder) {
      this.placeholder = placeholder;
      return (ITimebox.Builder) this;
    }

    /**
     * Put one entry to the {@link ITimebox#getInputAttributes() inputAttributes} map.
     * @param key The key in the inputAttributes map
     * @param value The associated value in the inputAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder putInputAttributes(String key, String value) {
      if (this.inputAttributes == null) {
        this.inputAttributes = ImmutableMap.builder();
      }
      this.inputAttributes.put(key, value);
      return (ITimebox.Builder) this;
    }

    /**
     * Put one entry to the {@link ITimebox#getInputAttributes() inputAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder putInputAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.inputAttributes == null) {
        this.inputAttributes = ImmutableMap.builder();
      }
      this.inputAttributes.put(entry);
      return (ITimebox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ITimebox#getInputAttributes() inputAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the inputAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setInputAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.inputAttributes = null;
        return (ITimebox.Builder) this;
      }
      this.inputAttributes = ImmutableMap.builder();
      return putAllInputAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ITimebox#getInputAttributes() inputAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the inputAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder putAllInputAttributes(Map<String, ? extends String> entries) {
      if (this.inputAttributes == null) {
        this.inputAttributes = ImmutableMap.builder();
      }
      this.inputAttributes.putAll(entries);
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setValue(@Nullable Date value) {
      this.value = value;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getConstraint() constraint} attribute.
     * @param constraint The value for constraint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setConstraint(@Nullable String constraint) {
      this.constraint = constraint;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getErrorboxSclass() errorboxSclass} attribute.
     * @param errorboxSclass The value for errorboxSclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setErrorboxSclass(@Nullable String errorboxSclass) {
      this.errorboxSclass = errorboxSclass;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getErrorboxIconSclass() errorboxIconSclass} attribute.
     * @param errorboxIconSclass The value for errorboxIconSclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setErrorboxIconSclass(@Nullable String errorboxIconSclass) {
      this.errorboxIconSclass = errorboxIconSclass;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#isDisabled() disabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#isDisabled() disabled}.</em>
     * @param disabled The value for disabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setDisabled(boolean disabled) {
      this.disabled = disabled;
      optBits |= OPT_BIT_DISABLED;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#isInplace() inplace} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#isInplace() inplace}.</em>
     * @param inplace The value for inplace 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setInplace(boolean inplace) {
      this.inplace = inplace;
      optBits |= OPT_BIT_INPLACE;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getMaxlength() maxlength} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getMaxlength() maxlength}.</em>
     * @param maxlength The value for maxlength 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setMaxlength(int maxlength) {
      this.maxlength = maxlength;
      optBits |= OPT_BIT_MAXLENGTH;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getInstant() instant} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getInstant() instant}.</em>
     * @param instant The value for instant 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setInstant(boolean instant) {
      this.instant = instant;
      optBits |= OPT_BIT_INSTANT;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getErrorMessage() errorMessage} attribute.
     * @param errorMessage The value for errorMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setErrorMessage(@Nullable String errorMessage) {
      this.errorMessage = errorMessage;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getLocale() locale} attribute.
     * @param locale The value for locale (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setLocale(@Nullable Locale locale) {
      this.locale = locale;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getTimeZone() timeZone} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getTimeZone() timeZone}.</em>
     * @param timeZone The value for timeZone 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setTimeZone(TimeZone timeZone) {
      this.timeZone = Objects.requireNonNull(timeZone, "timeZone");
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getValueInZonedDateTime() valueInZonedDateTime} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getValueInZonedDateTime() valueInZonedDateTime}.</em>
     * @param valueInZonedDateTime The value for valueInZonedDateTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setValueInZonedDateTime(@Nullable ZonedDateTime valueInZonedDateTime) {
      this.valueInZonedDateTime = valueInZonedDateTime;
      optBits |= OPT_BIT_VALUE_IN_ZONED_DATE_TIME;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getValueInLocalDateTime() valueInLocalDateTime} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getValueInLocalDateTime() valueInLocalDateTime}.</em>
     * @param valueInLocalDateTime The value for valueInLocalDateTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setValueInLocalDateTime(@Nullable LocalDateTime valueInLocalDateTime) {
      this.valueInLocalDateTime = valueInLocalDateTime;
      optBits |= OPT_BIT_VALUE_IN_LOCAL_DATE_TIME;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getValueInLocalDate() valueInLocalDate} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getValueInLocalDate() valueInLocalDate}.</em>
     * @param valueInLocalDate The value for valueInLocalDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setValueInLocalDate(@Nullable LocalDate valueInLocalDate) {
      this.valueInLocalDate = valueInLocalDate;
      optBits |= OPT_BIT_VALUE_IN_LOCAL_DATE;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getValueInLocalTime() valueInLocalTime} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getValueInLocalTime() valueInLocalTime}.</em>
     * @param valueInLocalTime The value for valueInLocalTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setValueInLocalTime(@Nullable LocalTime valueInLocalTime) {
      this.valueInLocalTime = valueInLocalTime;
      optBits |= OPT_BIT_VALUE_IN_LOCAL_TIME;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#isButtonVisible() buttonVisible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#isButtonVisible() buttonVisible}.</em>
     * @param buttonVisible The value for buttonVisible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setButtonVisible(boolean buttonVisible) {
      this.buttonVisible = buttonVisible;
      optBits |= OPT_BIT_BUTTON_VISIBLE;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getCols() cols} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getCols() cols}.</em>
     * @param cols The value for cols 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setCols(int cols) {
      this.cols = cols;
      optBits |= OPT_BIT_COLS;
      return (ITimebox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITimebox#getFormat() format} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITimebox#getFormat() format}.</em>
     * @param format The value for format 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITimebox.Builder setFormat(String format) {
      this.format = Objects.requireNonNull(format, "format");
      return (ITimebox.Builder) this;
    }

    /**
     * Builds a new {@link ITimebox ITimebox}.
     * @return An immutable instance of ITimebox
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ITimebox build() {
      return ImmutableITimebox.validate(new ImmutableITimebox(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean readonlyIsSet() {
      return (optBits & OPT_BIT_READONLY) != 0;
    }

    private boolean disabledIsSet() {
      return (optBits & OPT_BIT_DISABLED) != 0;
    }

    private boolean inplaceIsSet() {
      return (optBits & OPT_BIT_INPLACE) != 0;
    }

    private boolean maxlengthIsSet() {
      return (optBits & OPT_BIT_MAXLENGTH) != 0;
    }

    private boolean instantIsSet() {
      return (optBits & OPT_BIT_INSTANT) != 0;
    }

    private boolean valueInZonedDateTimeIsSet() {
      return (optBits & OPT_BIT_VALUE_IN_ZONED_DATE_TIME) != 0;
    }

    private boolean valueInLocalDateTimeIsSet() {
      return (optBits & OPT_BIT_VALUE_IN_LOCAL_DATE_TIME) != 0;
    }

    private boolean valueInLocalDateIsSet() {
      return (optBits & OPT_BIT_VALUE_IN_LOCAL_DATE) != 0;
    }

    private boolean valueInLocalTimeIsSet() {
      return (optBits & OPT_BIT_VALUE_IN_LOCAL_TIME) != 0;
    }

    private boolean buttonVisibleIsSet() {
      return (optBits & OPT_BIT_BUTTON_VISIBLE) != 0;
    }

    private boolean colsIsSet() {
      return (optBits & OPT_BIT_COLS) != 0;
    }
  }
}
