package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zkmax.zul.GoldenLayout;

/**
 * Immutable implementation of {@link IGoldenLayout}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IGoldenLayout.Builder()}.
 */
@Generated(from = "IGoldenLayout", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIGoldenLayout implements IGoldenLayout {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final ImmutableList<IGoldenPanel<IAnyGroup>> children;
  private final String widgetClass;
  private final @Nullable String areas;
  private final String orient;

  private ImmutableIGoldenLayout(ImmutableIGoldenLayout.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.children = builder.children.build();
    this.areas = builder.areas;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.orient != null) {
      initShim.setOrient(builder.orient);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.widgetClass = initShim.getWidgetClass();
    this.orient = initShim.getOrient();
    this.initShim = null;
  }

  private ImmutableIGoldenLayout(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      ImmutableList<IGoldenPanel<IAnyGroup>> children,
      String widgetClass,
      @Nullable String areas,
      String orient) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.children = children;
    this.widgetClass = widgetClass;
    this.areas = areas;
    this.orient = orient;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IGoldenLayout", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte orientBuildStage = STAGE_UNINITIALIZED;
    private String orient;

    String getOrient() {
      if (orientBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (orientBuildStage == STAGE_UNINITIALIZED) {
        orientBuildStage = STAGE_INITIALIZING;
        this.orient = Objects.requireNonNull(getOrientInitialize(), "orient");
        orientBuildStage = STAGE_INITIALIZED;
      }
      return this.orient;
    }

    void setOrient(String orient) {
      this.orient = orient;
      orientBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (orientBuildStage == STAGE_INITIALIZING) attributes.add("orient");
      return "Cannot build IGoldenLayout, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IGoldenLayout.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IGoldenLayout.super.isVisible();
  }

  private String getMoldInitialize() {
    return IGoldenLayout.super.getMold();
  }

  private int getZIndexInitialize() {
    return IGoldenLayout.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IGoldenLayout.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IGoldenLayout.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IGoldenLayout.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IGoldenLayout.super.getRenderdefer();
  }

  private String getWidgetClassInitialize() {
    return IGoldenLayout.super.getWidgetClass();
  }

  private String getOrientInitialize() {
    return IGoldenLayout.super.getOrient();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code children} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableList<IGoldenPanel<IAnyGroup>> getChildren() {
    return children;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code areas} attribute
   */
  @Override
  public @Nullable String getAreas() {
    return areas;
  }

  /**
   * @return The value of the {@code orient} attribute
   */
  @Override
  public String getOrient() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getOrient()
        : this.orient;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIGoldenLayout(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IGoldenLayout#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGoldenLayout withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIGoldenLayout(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.children,
          this.widgetClass,
          this.areas,
          this.orient));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IGoldenLayout#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGoldenLayout withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by replacing the {@link IGoldenLayout#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGoldenLayout withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by replacing the {@link IGoldenLayout#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGoldenLayout withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by replacing the {@link IGoldenLayout#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGoldenLayout withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.children,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IGoldenLayout#getChildren() children}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableIGoldenLayout withChildren(IGoldenPanel<IAnyGroup>... elements) {
    ImmutableList<IGoldenPanel<IAnyGroup>> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IGoldenLayout#getChildren() children}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of children elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIGoldenLayout withChildren(Iterable<? extends IGoldenPanel<IAnyGroup>> elements) {
    if (this.children == elements) return this;
    ImmutableList<IGoldenPanel<IAnyGroup>> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.widgetClass,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        newValue,
        this.areas,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getAreas() areas} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for areas (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withAreas(@Nullable String value) {
    if (Objects.equals(this.areas, value)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        value,
        this.orient));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IGoldenLayout#getOrient() orient} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for orient
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIGoldenLayout withOrient(String value) {
    String newValue = Objects.requireNonNull(value, "orient");
    if (this.orient.equals(newValue)) return this;
    return validate(new ImmutableIGoldenLayout(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.areas,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIGoldenLayout} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIGoldenLayout
        && equalTo((ImmutableIGoldenLayout) another);
  }

  private boolean equalTo(ImmutableIGoldenLayout another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && children.equals(another.children)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(areas, another.areas)
        && orient.equals(another.orient);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code children}, {@code widgetClass}, {@code areas}, {@code orient}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + children.hashCode();
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(areas);
    h += (h << 5) + orient.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IGoldenLayout} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IGoldenLayout")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("children", children)
        .add("widgetClass", widgetClass)
        .add("areas", areas)
        .add("orient", orient)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<GoldenLayout> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IGoldenLayout#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<GoldenLayout> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IGoldenLayout.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static final long AREAS_MATRIX_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient List<List<String>> areasMatrix;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IGoldenLayout#getAreasMatrix() areasMatrix} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code areasMatrix} attribute
   */
  @Override
  public List<List<String>> getAreasMatrix() {
    if ((lazyInitBitmap & AREAS_MATRIX_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & AREAS_MATRIX_LAZY_INIT_BIT) == 0) {
          this.areasMatrix = Objects.requireNonNull(IGoldenLayout.super.getAreasMatrix(), "areasMatrix");
          lazyInitBitmap |= AREAS_MATRIX_LAZY_INIT_BIT;
        }
      }
    }
    return areasMatrix;
  }

  private static ImmutableIGoldenLayout validate(ImmutableIGoldenLayout instance) {
    instance = (ImmutableIGoldenLayout) instance.updateChildrenStatus();
    instance.checkOrient();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIGoldenLayout) instance.checkDroppable();
    instance = (ImmutableIGoldenLayout) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IGoldenLayout} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IGoldenLayout instance
   */
  public static IGoldenLayout copyOf(IGoldenLayout instance) {
    if (instance instanceof ImmutableIGoldenLayout) {
      return (ImmutableIGoldenLayout) instance;
    }
    return new IGoldenLayout.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IGoldenLayout IGoldenLayout}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IGoldenLayout", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private ImmutableList.Builder<IGoldenPanel<IAnyGroup>> children = ImmutableList.builder();
    private @Nullable String widgetClass;
    private @Nullable String areas;
    private @Nullable String orient;

    /**
     * Creates a builder for {@link IGoldenLayout IGoldenLayout} instances.
     * <pre>
     * new IGoldenLayout.Builder()
     *    .setId(String) // optional {@link IGoldenLayout#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IGoldenLayout#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IGoldenLayout#getActions() actions}
     *    .setVisible(boolean) // optional {@link IGoldenLayout#isVisible() visible}
     *    .setMold(String) // optional {@link IGoldenLayout#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IGoldenLayout#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IGoldenLayout#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IGoldenLayout#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IGoldenLayout#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IGoldenLayout#getLeft() left}
     *    .setTop(String | null) // nullable {@link IGoldenLayout#getTop() top}
     *    .setZIndex(int) // optional {@link IGoldenLayout#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IGoldenLayout#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IGoldenLayout#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IGoldenLayout#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IGoldenLayout#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IGoldenLayout#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IGoldenLayout#getStyle() style}
     *    .setDraggable(String) // optional {@link IGoldenLayout#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IGoldenLayout#isFocus() focus}
     *    .setDroppable(String) // optional {@link IGoldenLayout#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IGoldenLayout#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IGoldenLayout#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IGoldenLayout#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IGoldenLayout#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IGoldenLayout#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IGoldenLayout#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IGoldenLayout#getContext() context}
     *    .setPopup(String | null) // nullable {@link IGoldenLayout#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IGoldenLayout#getTooltip() tooltip}
     *    .addChildren|addAllChildren(org.zkoss.stateless.sul.IGoldenPanel&amp;lt;org.zkoss.stateless.sul.IAnyGroup&amp;gt;) // {@link IGoldenLayout#getChildren() children} elements
     *    .setWidgetClass(String) // optional {@link IGoldenLayout#getWidgetClass() widgetClass}
     *    .setAreas(String | null) // nullable {@link IGoldenLayout#getAreas() areas}
     *    .setOrient(String) // optional {@link IGoldenLayout#getOrient() orient}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IGoldenLayout.Builder)) {
        throw new UnsupportedOperationException("Use: new IGoldenLayout.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IGoldenLayout} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder from(IGoldenLayout instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      addAllChildren(instance.getChildren());
      setWidgetClass(instance.getWidgetClass());
      @Nullable String areasValue = instance.getAreas();
      if (areasValue != null) {
        setAreas(areasValue);
      }
      setOrient(instance.getOrient());
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGoldenLayout#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Adds one element to {@link IGoldenLayout#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Adds elements to {@link IGoldenLayout#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IGoldenLayout.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IGoldenLayout#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IGoldenLayout.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IGoldenLayout#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGoldenLayout#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGoldenLayout#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Put one entry to the {@link IGoldenLayout#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Put one entry to the {@link IGoldenLayout#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IGoldenLayout#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IGoldenLayout.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IGoldenLayout#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Put one entry to the {@link IGoldenLayout#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Put one entry to the {@link IGoldenLayout#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IGoldenLayout#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IGoldenLayout.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IGoldenLayout#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Put one entry to the {@link IGoldenLayout#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Put one entry to the {@link IGoldenLayout#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IGoldenLayout#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IGoldenLayout.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IGoldenLayout#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setTop(@Nullable String top) {
      this.top = top;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGoldenLayout#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGoldenLayout#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGoldenLayout#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGoldenLayout#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGoldenLayout#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setContext(@Nullable String context) {
      this.context = context;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Adds one element to {@link IGoldenLayout#getChildren() children} list.
     * @param element A children element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder addChildren(IGoldenPanel<IAnyGroup> element) {
      this.children.add(element);
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Adds elements to {@link IGoldenLayout#getChildren() children} list.
     * @param elements An array of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final IGoldenLayout.Builder addChildren(IGoldenPanel<IAnyGroup>... elements) {
      this.children.add(elements);
      return (IGoldenLayout.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IGoldenLayout#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setChildren(Iterable<? extends IGoldenPanel<IAnyGroup>> elements) {
      this.children = ImmutableList.builder();
      return addAllChildren(elements);
    }

    /**
     * Adds elements to {@link IGoldenLayout#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder addAllChildren(Iterable<? extends IGoldenPanel<IAnyGroup>> elements) {
      this.children.addAll(elements);
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGoldenLayout#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getAreas() areas} attribute.
     * @param areas The value for areas (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setAreas(@Nullable String areas) {
      this.areas = areas;
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Initializes the value for the {@link IGoldenLayout#getOrient() orient} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IGoldenLayout#getOrient() orient}.</em>
     * @param orient The value for orient 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IGoldenLayout.Builder setOrient(String orient) {
      this.orient = Objects.requireNonNull(orient, "orient");
      return (IGoldenLayout.Builder) this;
    }

    /**
     * Builds a new {@link IGoldenLayout IGoldenLayout}.
     * @return An immutable instance of IGoldenLayout
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IGoldenLayout build() {
      return ImmutableIGoldenLayout.validate(new ImmutableIGoldenLayout(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }
  }
}
