/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Strings;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.impl.GroupsListModel;

class ClientListDataListener
implements ListDataListener,
Serializable,
ComponentActivationListener {
    private String _expr;
    private int _rodSize;
    private Component _view;
    private transient ClientBindComposer _composer;

    ClientListDataListener(ClientBindComposer composer, String expr, int rodSize) {
        this._composer = composer;
        this._view = composer.view;
        this._expr = expr;
        this._rodSize = rodSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientListDataListener that = (ClientListDataListener)o;
        return this._rodSize == that._rodSize && Objects.equals(this._expr, that._expr);
    }

    public int hashCode() {
        return Objects.hash(this._expr, this._rodSize);
    }

    public void didActivate(Component comp) {
        this._composer = (ClientBindComposer)Components.getComposer((Component)comp);
    }

    public void willPassivate(Component comp) {
    }

    public void onChange(ListDataEvent event) {
        JavaScriptValue updatedListModel;
        if (this._composer.view.hasAttribute("$DISABLE_CLIENT_UPDATE$")) {
            return;
        }
        int type = event.getType();
        if (4 != type) {
            try {
                String vmExprPrefix = String.valueOf(this._view.getAttribute("$VM_ID$")) + ".";
                Object expr = this._expr;
                if (((String)expr).startsWith(vmExprPrefix)) {
                    expr = ((String)expr).substring(vmExprPrefix.length());
                }
                ListModel model = event.getModel();
                int modelSize = model.getSize();
                int size = Math.min(modelSize, this._rodSize == -1 ? modelSize : this._rodSize);
                ArrayList<Object> elements = new ArrayList<Object>();
                for (int i = 0; i < size; ++i) {
                    elements.add(model.getElementAt(i));
                }
                String groupInfoValueString = null;
                if (model instanceof GroupsListModel) {
                    groupInfoValueString = ClientBindComposer.getGroupsInfoValueStringFromModel((GroupsListModel)model);
                }
                Executions.getCurrent().setAttribute("$IGNORE_FIRST_LIST_ID$", (Object)true);
                Object result = this._composer.writeValueAsString(elements);
                if (!Strings.isEmpty((String)groupInfoValueString)) {
                    result = "{" + groupInfoValueString + ((String)result).substring(1);
                }
                if (((String)expr).contains("(")) {
                    int end;
                    if (((String)expr).startsWith("get")) {
                        end = ((String)expr).indexOf("(");
                        expr = ((String)expr).substring(3, end);
                    } else if (((String)expr).startsWith("is")) {
                        end = ((String)expr).indexOf("(");
                        expr = ((String)expr).substring(2, end);
                    }
                    expr = String.valueOf(((String)expr).charAt(0)).toLowerCase() + ((String)expr).substring(1);
                }
                if (modelSize > size) {
                    result = "{$ts$: " + modelSize + "," + ((String)result).substring(1);
                }
                JavaScriptValue updatedListModel2 = new JavaScriptValue("{" + (String)expr + ":" + (String)result + "}");
                Clients.response((String)((String)expr + "$" + type), (AuResponse)new AuInvoke(this._view, "update@vm", new Object[]{expr, updatedListModel2}));
            }
            catch (JsonProcessingException e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
        Object expr = this._expr;
        String vmExprPrefix = String.valueOf(this._view.getAttribute("$VM_ID$")) + ".";
        if (((String)expr).startsWith(vmExprPrefix)) {
            expr = ((String)expr).substring(vmExprPrefix.length());
        }
        if (((String)expr).contains("(")) {
            int end;
            if (((String)expr).startsWith("get")) {
                end = ((String)expr).indexOf("(");
                expr = ((String)expr).substring(3, end);
            } else if (((String)expr).startsWith("is")) {
                end = ((String)expr).indexOf("(");
                expr = ((String)expr).substring(2, end);
            }
            expr = String.valueOf(((String)expr).charAt(0)).toLowerCase() + ((String)expr).substring(1);
        }
        Selectable model = (Selectable)event.getModel();
        try {
            updatedListModel = new JavaScriptValue("{" + (String)expr + ": {\"$sel$\":" + this._composer.writeValueAsString(model.getSelection()) + "}}");
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        Clients.response((String)((String)expr + "$" + type), (AuResponse)new AuInvoke(this._view, "update@vm", new Object[]{expr, updatedListModel}));
    }
}

