/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.Property;
import org.zkoss.bind.impl.PropertyImpl;
import org.zkoss.bind.proxy.ProxyHelper;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.clientbind.ClientBinder;
import org.zkoss.clientbind.ClientSaveFormBindingImpl;
import org.zkoss.clientbind.ClientSavePropertyBindingImpl;
import org.zkoss.clientbind.DummyComponent;
import org.zkoss.clientbind.ui.util.ObjectMappers;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.Objects;
import org.zkoss.lang.OperationException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.Clients;

public class FormSaveCommand {
    private ClientBindComposer composer;
    private Component view;
    private ClientBinder binder;

    private FormSaveCommand(ClientBindComposer composer) {
        this.composer = composer;
        this.view = composer.view;
        this.binder = composer.getBinder();
    }

    private boolean process(String command, Map<String, Object> data) {
        Map args = (Map)data.get("args");
        String formId = (String)args.get("formId");
        JSONArray formDirtyFields = (JSONArray)args.get("$ubd$");
        JSONObject formJSONObject = (JSONObject)args.get("form");
        Map validatorData = (Map)args.get("$vbd$");
        String formBeanUid = (String)formJSONObject.get((Object)"$id$");
        String originBeanUid = formBeanUid.replace("$$", "");
        Object originBeanObject = this.composer.getCachedBeanById(originBeanUid);
        if (originBeanObject != null) {
            Map formSaveValidators = (Map)args.get("$vsfb$");
            if (validatorData != null || formSaveValidators != null) {
                boolean isValid;
                Object form = null;
                try {
                    form = ObjectMappers.SETTER_OBJECT_MAPPER.readValue(JSONValue.toJSONString((Object)formJSONObject), originBeanObject.getClass());
                }
                catch (JsonProcessingException e) {
                    throw new OperationException("Unable to write to bean, ", (Throwable)e);
                }
                Map validatorProperty = (Map)args.get("$vbp$");
                Map validatorComponentProperty = (Map)args.get("$vbcp$");
                Object finalForm = ProxyHelper.createFormProxy((Object)form, form.getClass());
                boolean bl = isValid = !validatorComponentProperty.values().stream().filter(v -> Objects.equals((Object)v, (Object)"$ERR$")).findFirst().isPresent();
                if (formSaveValidators != null) {
                    for (Map.Entry me : formSaveValidators.entrySet()) {
                        Map eachValidatorData = (Map)me.getValue();
                        Object propValue = validatorProperty.get(me.getKey());
                        String uuid = (String)eachValidatorData.remove("uuid");
                        Object component = Executions.getCurrent().getDesktop().getComponentByUuidIfAny(uuid);
                        if (component == null) {
                            component = new DummyComponent(this.view, uuid);
                        }
                        PropertyImpl property = new PropertyImpl(finalForm, (String)me.getKey(), propValue);
                        if (isValid &= this.binder.doValidate((Component)component, new ClientSavePropertyBindingImpl(this.binder, (Component)component, (String)validatorComponentProperty.get(uuid + (String)me.getKey()), (Property)property, (String)((List)eachValidatorData.remove("value")).get(0), eachValidatorData, (Set<Property>)Collections.singleton(property)), isValid)) continue;
                        break;
                    }
                }
                if (validatorData != null) {
                    String uuid = (String)validatorData.remove("uuid");
                    Object component = Executions.getCurrent().getDesktop().getComponentByUuidIfAny(uuid);
                    if (component == null) {
                        component = new DummyComponent(this.view, uuid);
                    }
                    isValid &= this.binder.doValidate((Component)component, new ClientSaveFormBindingImpl(this.binder, (Component)component, "form", (Property)new PropertyImpl(originBeanObject, ".", finalForm), (String)((List)validatorData.remove("value")).get(0), validatorData, validatorProperty, formId), isValid);
                }
                Clients.sendClientCommand((Component)this.view, (String)command, (Object)isValid);
                if (!isValid) {
                    return true;
                }
            } else {
                Clients.sendClientCommand((Component)this.view, (String)command, (Object)true);
            }
            for (Object dirtyField : formDirtyFields) {
                JSONObject field = (JSONObject)dirtyField;
                String fieldBeanUid = ((String)field.remove((Object)"$id$")).replace("$$", "");
                String fieldProp = (String)field.remove((Object)"prop");
                Object fieldValue = field.remove((Object)"value");
                Object fieldBeanObject = this.composer.getCachedBeanById(fieldBeanUid);
                if (fieldBeanObject == null) continue;
                field.put((Object)fieldProp, fieldValue);
                String encoded = JSONValue.toJSONString((Object)field);
                try {
                    ObjectReader objectReader = ObjectMappers.SETTER_OBJECT_MAPPER.readerForUpdating(fieldBeanObject);
                    objectReader.readValue(encoded);
                }
                catch (JsonProcessingException e) {
                    throw new UiException("Fail to update the bean, " + e.getMessage());
                }
            }
        } else {
            throw new NullPointerException("Bean is null [" + formBeanUid + "]");
        }
        this.binder.notifyChange(this.composer.getCachedBeanById(originBeanUid), ".");
        return true;
    }

    public static boolean processCommand(ClientBindComposer composer, String command, Map<String, Object> data) {
        return new FormSaveCommand(composer).process(command, data);
    }
}

