/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Property;
import org.zkoss.bind.PropertyChangeEvent;
import org.zkoss.bind.annotation.AfterCompose;
import org.zkoss.bind.annotation.AutoNotifyChange;
import org.zkoss.bind.annotation.HistoryPopState;
import org.zkoss.bind.annotation.ToServerCommand;
import org.zkoss.bind.impl.AbstractAnnotatedMethodInvoker;
import org.zkoss.bind.impl.AnnotationUtil;
import org.zkoss.bind.impl.BindContextImpl;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.BinderImpl;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.bind.impl.ParamCall;
import org.zkoss.bind.impl.PropertyImpl;
import org.zkoss.bind.impl.SimpleBindXelContext;
import org.zkoss.bind.impl.SystemConverters;
import org.zkoss.bind.impl.ValidationMessagesImpl;
import org.zkoss.bind.init.ViewModelAnnotationResolvers;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.ProxyHelper;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.bind.sys.debugger.BindingAnnotationInfoChecker;
import org.zkoss.bind.sys.debugger.DebuggerFactory;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.clientbind.ClientBinder;
import org.zkoss.clientbind.ClientBinderImpl;
import org.zkoss.clientbind.ClientBinderResolver;
import org.zkoss.clientbind.ClientListDataListener;
import org.zkoss.clientbind.ClientSavePropertyBindingImpl;
import org.zkoss.clientbind.ClientStepModelDataListener;
import org.zkoss.clientbind.ClientTreeDataListener;
import org.zkoss.clientbind.CreateTemplateCommand;
import org.zkoss.clientbind.CreateViewModelCommand;
import org.zkoss.clientbind.FormSaveCommand;
import org.zkoss.clientbind.IncludeTemplateCommand;
import org.zkoss.clientbind.ListModelPagingListener;
import org.zkoss.clientbind.OnDataLoadingCommand;
import org.zkoss.clientbind.ProcessPagingModelCommand;
import org.zkoss.clientbind.RemoteConverterCommand;
import org.zkoss.clientbind.RemoteELCommand;
import org.zkoss.clientbind.TreeModelPagingListener;
import org.zkoss.clientbind.UpdateBindingCommand;
import org.zkoss.clientbind.ValidateBindingCommand;
import org.zkoss.clientbind.ValidationMessagesMonitor;
import org.zkoss.clientbind.ui.util.ObjectMappers;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.ClassResolver;
import org.zkoss.lang.Classes;
import org.zkoss.lang.ImportedClassResolver;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.CacheMap;
import org.zkoss.util.EmptyCacheMap;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.util.Maps;
import org.zkoss.util.Pair;
import org.zkoss.xel.ExpressionX;
import org.zkoss.xel.ValueReference;
import org.zkoss.xel.XelContext;
import org.zkoss.zel.ELContext;
import org.zkoss.zel.PropertyNotFoundException;
import org.zkoss.zel.impl.lang.EvaluationContext;
import org.zkoss.zel.impl.lang.ExpressionBuilder;
import org.zkoss.zel.impl.parser.Node;
import org.zkoss.zel.impl.util.ReflectionUtil;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.HistoryPopStateEvent;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.impl.VolatilePage;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.TemplateInfo;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;
import org.zkoss.zk.ui.util.ConventionWires;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zk.ui.util.TemplateCtrl;
import org.zkoss.zkmax.bind.proxy.ProxyHelperEx;
import org.zkoss.zkmax.zul.Cascader;
import org.zkoss.zkmax.zul.Chosenbox;
import org.zkoss.zkmax.zul.Organigram;
import org.zkoss.zkmax.zul.StepModel;
import org.zkoss.zkmax.zul.Stepbar;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Grid;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListSubModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.PageableModel;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.event.TreeDataListener;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.ext.TreeOpenableModel;
import org.zkoss.zul.ext.TreeSelectableModel;
import org.zkoss.zul.impl.GroupsListModel;
import org.zkoss.zuti.zul.ForEach;

public class ClientBindComposer<T extends Component>
implements Composer<T>,
ComposerExt<T>,
Serializable,
AuService,
ComponentActivationListener {
    private static final long serialVersionUID = 2021090112065023L;
    protected static final Logger log = LoggerFactory.getLogger(ClientBindComposer.class);
    public static final String VM_ID = "$VM_ID$";
    public static final String BINDER_ID = "$BINDER_ID$";
    protected static final String VALIDATION_MESSAGE_ID = "$VMSG_ID$";
    protected static final String ID_ANNO = "id";
    protected static final String INIT_ANNO = "init";
    protected static final String VALUE_ANNO_ATTR = "value";
    public static final String FORM_ATTR = "form";
    public static final String VIEW_MODEL_ATTR = "viewModel";
    protected static final String BINDER_ATTR = "binder";
    protected static final String VALIDATION_MESSAGES_ATTR = "validationMessages";
    protected static final String CHILDREN_ATTR = "children";
    protected static final String MODEL_ATTR = "model";
    protected static final String QUEUE_NAME_ANNO_ATTR = "queueName";
    protected static final String QUEUE_SCOPE_ANNO_ATTR = "queueScope";
    protected static final String UPDATE_BINDING_CMD = "$ubc$";
    protected static final String UPDATE_BINDING_DATA = "$ubd$";
    protected static final String UPDATE_SELECTION_DATA = "$usc$";
    protected static final String VALIDATE_BINDING_CMD = "$vbc$";
    protected static final String VALIDATE_BINDING_DATA = "$vbd$";
    protected static final String VALIDATE_BINDING_PROPERTY = "$vbp$";
    protected static final String VALIDATE_BINDING_COMPONENT_PROPERTY = "$vbcp$";
    protected static final String VALIDATE_SAVE_FORM_BINDING = "$vsfb$";
    protected static final String REMOTE_EL_CMD = "$rec$";
    protected static final String REMOTE_CONVERTER_CMD = "$rcc$";
    protected static final String REMOTE_CMD_ARG = "$rca$";
    protected static final String FORM_SAVE_CMD = "$fsc$";
    protected static final String FETCH_BEAN_DATA_CMD = "$fbdc$";
    protected static final String REMOTE_CLEAR_VALIDATION_MESSAGE_CMD = "$rcvmc$";
    protected static final String TREEITEM_OPEN_CMD = "$tioc$";
    protected static final String GROUP_OPEN_CMD = "$gpoc$";
    protected static final String TREE_MODEL_SELECTION_CMD = "$tmsc$";
    protected static final String LIST_MODEL_SELECTION_CMD = "$lmsc$";
    protected static final String LIST_SUBMODEL_CMD = "$lsmc$";
    protected static final String LIST_SUBMODEL_SELECTION_CMD = "$lsmsc$";
    public static final String BEAN_UID = "$id$";
    public static final String IMMUTABLE = "$im$";
    protected static final String TO_STRING_CONVERTER = "$tsc$";
    private static final String CREATE_TEMPLATE_COMMAND = "$ctc$";
    private static final String INCLUDE_TEMPLATE_COMMAND = "$itc$";
    private static final String CREATE_VIEW_MODEL_COMMAND = "$cvc$";
    private static final String ON_DATA_LOADING_COMMAND = "$odl$";
    private static final String PROCESS_PAGING_MODEL_COMMAND = "$ppmc$";
    private static final String AT_VM = "'@vm'";
    private static final String AT_VMSG = "'@vmsg'";
    private static final String IMPORTED_CLASS = "$imclz$";
    public static final String CLIENT_BINDINGS = "$CLIENT_BINDINGS$";
    public static final String ROD_SIZE = "$ROD_SIZE$";
    public static final String COMMAND_EVENT = "$cevt$";
    public static final String COMMAND_TRACKING_ARGUMENTS = "$cta$";
    public static final String COMMAND_TRACKING_ARGUMENTS_CHANGES = "$ctac$";
    public static final String WRAPPED_TYPE = "_@t";
    public static final String WRAPPED_RAW_VALUE = "_@n";
    public static final String WRAPPED_STRING_VALUE = "_@s";
    public static final String WRAPPED_FORMAT_VALUE = "_@f";
    public static final String LOCAL_DATE_POSTFIX = "$ld";
    public static final String LOCAL_DATE_TIME_POSTFIX = "$ldt";
    public static final String LOCAL_TIME_POSTFIX = "$lt";
    public static final String ZONED_DATE_TIME = "$zdt";
    public static final String DISABLE_CLIENT_UPDATE = "$DISABLE_CLIENT_UPDATE$";
    public static final String RENDER_ALL_TREE_DATA = "$RENDER_ALL_TREE_DATA$";
    transient ObjectMapper objectMapper;
    Object viewModel;
    private BindEvaluatorX _evalx;
    Component view;
    private ClientBinder _binder;
    private final Map<String, Object> idMappings = new HashMap<String, Object>();
    private Map<String, Object> formIdMappings = null;
    public final Map<String, Map<String, Set<String>>> dependsOnMap = new HashMap<String, Map<String, Set<String>>>(1);
    public final Map<Object, ListModel> modelToListModel = new HashMap<Object, ListModel>(1);
    public final Map<Object, TreeModel> modelToTreeModel = new HashMap<Object, TreeModel>(1);
    public final Map<Object, StepModel> modelToStepModel = new HashMap<Object, StepModel>(1);
    public final Map<Object, Integer> modelRodSizeMap = new HashMap<Object, Integer>(1);
    final Map<Object, List<Component>> modelToComponents = new HashMap<Object, List<Component>>(1);
    private final Map<Component, Pair<ComponentBindInfo, Object>> componentToModel = new HashMap<Component, Pair<ComponentBindInfo, Object>>(1);
    private Map<String, Converter> _converters = new HashMap<String, Converter>();
    private static final Map<Class<?>, List<Method>> _afterComposeMethodCache = BinderImpl.DISABLE_METHOD_CACHE ? new EmptyCacheMap() : new CacheMap(600, 1800000);
    private static final Map<Class<?>, List<Method>> _historyPopStateMethodCache = BinderImpl.DISABLE_METHOD_CACHE ? new EmptyCacheMap() : new CacheMap(600, 1800000);
    private boolean _isClientWidgetOnly = false;
    private static final Object NULL = new Object();

    public ClientBindComposer() {
        this(false);
    }

    public ClientBindComposer(boolean isClientWidgetOnly) {
        this._isClientWidgetOnly = isClientWidgetOnly;
        this.viewModel = this;
    }

    public BindEvaluatorX getEvaluatorX() {
        if (this._evalx == null) {
            this._evalx = new ClientBinderResolver(this.view, BindEvaluatorXUtil.createEvaluator(null));
        }
        return this._evalx;
    }

    public ClientBinder getBinder() {
        return this._binder;
    }

    public Object getViewModel() {
        return this.viewModel;
    }

    public void addConverter(String name, Converter converter) {
        this._converters.put(name, converter);
    }

    public void renderProperties(ContentRenderer contentRenderer) throws IOException {
        if (this._isClientWidgetOnly) {
            return;
        }
        this.idMappings.clear();
        Object viewModel = this._binder.getViewModel();
        JavaScriptValue vmObject = new JavaScriptValue(viewModel instanceof ClientBindComposer ? "{}" : this.writeValueAsString(viewModel));
        Map vmData = Maps.of((Object[])new Object[]{this.view.getAttribute(VM_ID), vmObject});
        PageCtrl page = (PageCtrl)this.view.getPage();
        ClassResolver classResolver = page.getClassResolver();
        if (classResolver instanceof ImportedClassResolver) {
            List importedClasses = ((ImportedClassResolver)classResolver).getImportedClasses();
            int size = importedClasses.size();
            ArrayList<String> clsNames = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                int index = ((String)importedClasses.get(i)).lastIndexOf(".");
                index = index == -1 ? 0 : index + 1;
                clsNames.add(((String)importedClasses.get(i)).substring(index));
            }
            vmData.put(IMPORTED_CLASS, new JavaScriptValue(JSONArray.toJSONString(clsNames)));
        }
        contentRenderer.render(AT_VM, (Object)vmData);
        String vname = (String)this.view.getAttribute(VALIDATION_MESSAGE_ID);
        if (vname != null) {
            contentRenderer.render(AT_VMSG, vname);
        }
    }

    public void doAfterCompose(T comp) throws Exception {
        Page page;
        if (comp.getPage() == null) {
            final Map currentArg = Executions.getCurrent().getArg();
            ((ComponentCtrl)comp).addCallback("afterPageAttached", new Callback((Component)comp){
                final /* synthetic */ Component val$comp;
                {
                    this.val$comp = component;
                }

                public void call(Object data) {
                    try {
                        Executions.getCurrent().pushArg(currentArg);
                        ClientBindComposer.this.doAfterCompose(this.val$comp);
                    }
                    catch (Exception e) {
                        throw UiException.Aide.wrap((Throwable)e);
                    }
                    finally {
                        Executions.getCurrent().popArg();
                    }
                }
            });
            return;
        }
        this.objectMapper = ObjectMappers.createGetterObjectMapper(this);
        comp.setAuService((AuService)this);
        new AbstractAnnotatedMethodInvoker<AfterCompose>(AfterCompose.class, _afterComposeMethodCache){

            protected boolean shouldLookupSuperclass(AfterCompose annotation) {
                return annotation.superclass();
            }
        }.invokeMethod((Binder)this._binder, this.getViewModelInitArgs(this.getEvaluatorX(), (Component)comp));
        this.traverseComponentBindings((Component)comp);
        AbstractAnnotatedMethodInvoker<HistoryPopState> historyPopStateInvoker = new AbstractAnnotatedMethodInvoker<HistoryPopState>(HistoryPopState.class, _historyPopStateMethodCache){

            protected boolean shouldLookupSuperclass(HistoryPopState annotation) {
                return false;
            }

            protected void handleNotifyChange(Binder binder, BindContext ctx, Object viewModel, Method m, ParamCall parCall, Set<Property> changes) {
                ClientBinderImpl cfr_ignored_0 = (ClientBinderImpl)binder;
                ClientBinderImpl.handleNotifyChange(ctx, viewModel, m, parCall, changes);
            }

            protected void fireNotifyChanges(Binder binder, Set<Property> changes) {
                ((ClientBinderImpl)binder).fireNotifyChanges(changes);
            }
        };
        if (historyPopStateInvoker.hasAnnotatedMethod((Binder)this._binder) && (page = comp.getPage()) != null) {
            page.addEventListener("onHistoryPopState", (EventListener)new SerializableEventListener<HistoryPopStateEvent>((AbstractAnnotatedMethodInvoker)historyPopStateInvoker){
                private HistoryPopStateEvent _handling = null;
                final /* synthetic */ AbstractAnnotatedMethodInvoker val$historyPopStateInvoker;
                {
                    this.val$historyPopStateInvoker = abstractAnnotatedMethodInvoker;
                }

                public void onEvent(HistoryPopStateEvent event) throws Exception {
                    if (event != this._handling) {
                        this._handling = event;
                        this.val$historyPopStateInvoker.invokeMethod((Binder)ClientBindComposer.this.getBinder(), null, (Event)event, true);
                    }
                }
            });
        }
    }

    protected void traverseComponentBindings(Component comp) {
        this.processComponentBindings0(comp);
        for (ShadowElement shadowElement : ((ComponentCtrl)comp).getShadowRoots()) {
            this.traverseComponentBindings((Component)shadowElement);
        }
        for (Component kid : comp.getChildren()) {
            if (kid.hasAttribute(BINDER_ID)) continue;
            this.traverseComponentBindings(kid);
        }
    }

    private void processComponentBindings0(Component comp) {
        List props = AnnotationUtil.getNonSystemProperties((Component)comp);
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        LinkedHashMap<String, Object> bindings = new LinkedHashMap<String, Object>();
        for (String prop : props) {
            Map attrs;
            String converterExpr;
            Annotation ann;
            if (this.isEventProperty(prop)) {
                Map values;
                Annotation next;
                Collection annoCommands = compCtrl.getAnnotations(prop, "command");
                Collection annoGlobalCommands = compCtrl.getAnnotations(prop, "global-command");
                if (annoCommands.isEmpty() && annoGlobalCommands.isEmpty()) continue;
                if (annoCommands.size() > 1) {
                    throw new IllegalSyntaxException(MiscUtil.formatLocationMessage((String)("Allow only one command binding for event " + prop + " of " + String.valueOf(comp)), (Component)comp));
                }
                if (annoGlobalCommands.size() > 1) {
                    throw new IllegalSyntaxException(MiscUtil.formatLocationMessage((String)("Allow only one global-command binding for event " + prop + " of " + String.valueOf(comp)), (Component)comp));
                }
                if (!annoCommands.isEmpty()) {
                    next = (Annotation)annoCommands.iterator().next();
                    values = (Map)bindings.computeIfAbsent("@command", ignore -> new LinkedHashMap());
                    values.put(prop, next.getAttributes());
                }
                if (annoGlobalCommands.isEmpty()) continue;
                next = (Annotation)annoGlobalCommands.iterator().next();
                values = (Map)bindings.computeIfAbsent("@global-command", ignore -> new LinkedHashMap());
                values.put(prop, next.getAttributes());
                continue;
            }
            if (VIEW_MODEL_ATTR.equals(prop) || BINDER_ATTR.equals(prop) || VALIDATION_MESSAGES_ATTR.equals(prop)) continue;
            Map<String, String[]> converterInfo = this.parseConverter(comp, prop);
            if (converterInfo == null && (ann = AnnotationUtil.getSystemAnnotation((ComponentCtrl)compCtrl, (String)prop)) != null && !Strings.isEmpty((String)(converterExpr = AnnotationUtil.testString((String[])((String[])(attrs = ann.getAttributes()).get("CONVERTER")), (Annotation)ann)))) {
                converterInfo = new HashMap<String, String[]>();
                converterInfo.put(VALUE_ANNO_ATTR, new String[]{"'" + converterExpr + "'"});
            }
            if (converterInfo != null) {
                ClientBindComposer.processPropertyBinding(bindings, prop, "converter", converterInfo);
            }
            boolean isModel = false;
            if (MODEL_ATTR.equals(prop) || comp instanceof ForEach && "items".equals(prop) || CHILDREN_ATTR.equals(prop)) {
                isModel = true;
            }
            Collection annotations = compCtrl.getAnnotations(prop);
            for (Annotation annot : annotations) {
                String name = annot.getName();
                if (ID_ANNO.equals(name) && FORM_ATTR.equals(prop)) {
                    this.processFormBindings(comp);
                    ClientBindComposer.processPropertyBinding(bindings, FORM_ATTR, ID_ANNO, annot.getAttributes());
                    continue;
                }
                if ("bind".equals(name)) {
                    ClientBindComposer.processPropertyBinding(bindings, prop, "save", ClientBindComposer.processPropertySave(comp, prop, annot), true);
                    ClientBindComposer.processPropertyBinding(bindings, prop, "load", ClientBindComposer.processPropertyLoad(comp, prop, annot), true);
                    if (!isModel) continue;
                    this.handleModel(bindings, comp, annot.getAttribute(VALUE_ANNO_ATTR), converterInfo);
                    continue;
                }
                if ("load".equals(name)) {
                    ClientBindComposer.processPropertyBinding(bindings, prop, "load", ClientBindComposer.processPropertyLoad(comp, prop, annot), true);
                    if (!isModel) continue;
                    this.handleModel(bindings, comp, annot.getAttribute(VALUE_ANNO_ATTR), converterInfo);
                    continue;
                }
                if ("save".equals(name)) {
                    ClientBindComposer.processPropertyBinding(bindings, prop, "save", ClientBindComposer.processPropertySave(comp, prop, annot), true);
                    continue;
                }
                if (INIT_ANNO.equals(name)) {
                    ClientBindComposer.processPropertyBinding(bindings, prop, INIT_ANNO, ClientBindComposer.processPropertyLoad(comp, prop, annot), true);
                    if (!isModel) continue;
                    this.handleModel(bindings, comp, annot.getAttribute(VALUE_ANNO_ATTR), converterInfo);
                    continue;
                }
                if ("validator".equals(name)) {
                    ClientBindComposer.processPropertyBinding(bindings, prop, "validator", annot.getAttributes());
                    continue;
                }
                if ("ref".equals(name)) {
                    ClientBindComposer.processPropertyBinding(bindings, prop, "ref", annot.getAttributes());
                    continue;
                }
                if (!"template".equals(name)) continue;
                ClientBindComposer.processPropertyBinding(bindings, prop, "template", annot.getAttributes());
            }
        }
        comp.setAttribute(CLIENT_BINDINGS, bindings);
    }

    private boolean isEventProperty(String propName) {
        return propName.startsWith("on") && propName.length() >= 3 && Character.isUpperCase(propName.charAt(2));
    }

    private void processFormBindings(Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Collection idannos = compCtrl.getAnnotations(FORM_ATTR, ID_ANNO);
        if (idannos.size() == 0) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage((String)("@id is not found for a form binding of " + String.valueOf(comp)), (Component)comp));
        }
        if (idannos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage((String)("Allow only one @id for a form binding of " + String.valueOf(comp)), (Annotation)((Annotation)idannos.iterator().next())));
        }
    }

    private static Map<String, String[]> processPropertySave(Component comp, String prop, Annotation annot) {
        HashMap<String, String[]> attributes = new HashMap<String, String[]>(annot.getAttributes());
        Annotation annotation = AnnotationUtil.getSystemAnnotation((ComponentCtrl)((ComponentCtrl)comp), (String)prop);
        if (annotation != null) {
            String saveRep;
            Map attrs = annotation.getAttributes();
            String rw = AnnotationUtil.testString((String[])((String[])attrs.get("ACCESS")), (Annotation)annotation);
            if (!"both".equals(rw) && !"save".equals(rw)) {
                return Collections.emptyMap();
            }
            String evtnm = AnnotationUtil.testString((String[])((String[])attrs.get("SAVE_EVENT")), (Annotation)annotation);
            if (evtnm != null) {
                attributes.put("SAVE_EVENT", new String[]{evtnm});
            }
            if ((saveRep = AnnotationUtil.testString((String[])((String[])attrs.get("SAVE_REPLACEMENT")), (Annotation)annotation)) != null) {
                attributes.put("SAVE_REPLACEMENT", new String[]{saveRep});
            }
        } else if (!FORM_ATTR.equals(prop)) {
            return Collections.emptyMap();
        }
        return attributes;
    }

    private static Map<String, String[]> processPropertyLoad(Component comp, String prop, Annotation annot) {
        HashMap<String, String[]> attributes = new HashMap<String, String[]>(annot.getAttributes());
        Annotation annotation = AnnotationUtil.getSystemAnnotation((ComponentCtrl)((ComponentCtrl)comp), (String)prop);
        if (annotation != null) {
            String loadType;
            String loadRep;
            Map attrs = annotation.getAttributes();
            String rw = AnnotationUtil.testString((String[])((String[])attrs.get("ACCESS")), (Annotation)annotation);
            if (rw != null && !"both".equals(rw) && !"load".equals(rw)) {
                return Collections.emptyMap();
            }
            String evtnm = AnnotationUtil.testString((String[])((String[])attrs.get("LOAD_EVENT")), (Annotation)annotation);
            if (evtnm != null) {
                attributes.put("LOAD_EVENT", new String[]{evtnm});
            }
            if ((loadRep = AnnotationUtil.testString((String[])((String[])attrs.get("LOAD_REPLACEMENT")), (Annotation)annotation)) != null) {
                attributes.put("LOAD_REPLACEMENT", new String[]{loadRep});
            }
            if ((loadType = AnnotationUtil.testString((String[])((String[])attrs.get("LOAD_TYPE")), (Annotation)annotation)) != null) {
                attributes.put("LOAD_TYPE", new String[]{loadType});
            }
        }
        return attributes;
    }

    public static void processPropertyBinding(Map<String, Object> allBindings, String prop, String annot, Map<String, String[]> propertyBinding) {
        ClientBindComposer.processPropertyBinding(allBindings, prop, annot, propertyBinding, false);
    }

    public static void processPropertyBinding(Map<String, Object> allBindings, String prop, String annot, Map<String, String[]> propertyBinding, boolean multiple) {
        if (!propertyBinding.isEmpty()) {
            Map values = (Map)allBindings.computeIfAbsent("@" + annot, ignore -> new LinkedHashMap());
            if (multiple) {
                if (values.containsKey(prop)) {
                    List bindings = (List)values.get(prop);
                    bindings.add(propertyBinding);
                } else {
                    ArrayList<Map<String, String[]>> bindings = new ArrayList<Map<String, String[]>>();
                    bindings.add(propertyBinding);
                    values.put(prop, bindings);
                }
            } else {
                values.put(prop, propertyBinding);
            }
        }
    }

    Object getModelFromComponent(Component comp) {
        Pair<ComponentBindInfo, Object> componentBindInfoObjectPair = this.componentToModel.get(comp);
        if (componentBindInfoObjectPair != null) {
            return componentBindInfoObjectPair.getY();
        }
        return null;
    }

    private void unbindComponentToModel(Component comp, Object model, Map<String, Object> allBindings, Map<String, String[]> converterInfo, String expr) {
        if (model == null) {
            model = NULL;
        }
        List comps = this.modelToComponents.compute(model, (k, v) -> new ArrayList());
        comps.remove(comp);
        if (comps.isEmpty()) {
            this.modelToComponents.remove(model);
            this.modelToListModel.remove(model);
            this.modelToTreeModel.remove(model);
            this.modelToStepModel.remove(model);
        }
        this.componentToModel.remove(comp);
    }

    private void bindComponentToModel(Component comp, Object model, Map<String, Object> allBindings, Map<String, String[]> converterInfo, String expr) {
        if (model == null) {
            model = NULL;
        }
        List comps = this.modelToComponents.compute(model, (k, v) -> new ArrayList());
        comps.add(comp);
        this.componentToModel.put(comp, (Pair<ComponentBindInfo, Object>)new Pair((Object)new ComponentBindInfo(allBindings, converterInfo, expr), model));
    }

    private void unbindTreeModelHandler(Map<String, Object> allBindings, Object model, TreeModel treeModel, Component comp, String expr) {
        if (model != null && treeModel != null) {
            Desktop desktop;
            Set renderAllTreeModel;
            Execution exec = Executions.getCurrent();
            exec.removeAttribute(comp.getUuid());
            boolean renderAll = false;
            if (comp instanceof Tree) {
                Set templateNames = comp.getTemplateNames();
                block0: for (String name : templateNames) {
                    Template template = comp.getTemplate(name);
                    if (template instanceof TemplateCtrl) {
                        template = ((TemplateCtrl)template).getMeta();
                    }
                    if (!(template instanceof TemplateInfo)) continue;
                    for (NodeInfo child : ((TemplateInfo)template).getChildren()) {
                        AnnotationMap annotationMap;
                        if (!(child instanceof ComponentInfo) || (annotationMap = ((ComponentInfo)child).getAnnotationMap()) == null || annotationMap.getAnnotations("open").isEmpty()) continue;
                        renderAll = true;
                        continue block0;
                    }
                }
            } else if (comp instanceof Cascader) {
                renderAll = true;
            }
            if (renderAll && (renderAllTreeModel = (Set)(desktop = Executions.getCurrent().getDesktop()).getAttribute(RENDER_ALL_TREE_DATA)) != null) {
                renderAllTreeModel.remove(treeModel);
            }
            ClientTreeDataListener clientTreeDataListener = new ClientTreeDataListener(this, comp, expr);
            treeModel.removeTreeDataListener((TreeDataListener)clientTreeDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindTreeModelHandler(Map<String, Object> allBindings, Object model, TreeModel treeModel, Component comp, String expr) {
        if (model != null && treeModel != null) {
            this.modelToTreeModel.put(model, treeModel);
            Execution exec = Executions.getCurrent();
            exec.setAttribute(comp.getUuid(), (Object)new Pair((Object)this.view, (Object)expr));
            boolean renderAll = false;
            if (comp instanceof Tree) {
                int rodSize = -1;
                Method initRodSizeMethod = null;
                Integer cachedRodSize = this.modelRodSizeMap.get(model);
                try {
                    initRodSizeMethod = comp.getClass().getDeclaredMethod("initRodSize", new Class[0]);
                    initRodSizeMethod.setAccessible(true);
                    rodSize = (Integer)initRodSizeMethod.invoke((Object)comp, new Object[0]);
                    if (cachedRodSize != null && cachedRodSize > rodSize) {
                        rodSize = cachedRodSize;
                    }
                    this.modelRodSizeMap.put(model, rodSize);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                finally {
                    initRodSizeMethod.setAccessible(false);
                }
                Paginal paginal = ((Tree)comp).getPaginal();
                if (paginal != null) {
                    if (treeModel instanceof PageableModel) {
                        PageableModel pm = (PageableModel)treeModel;
                        if (pm.getPageSize() > 0) {
                            paginal.setPageSize(pm.getPageSize());
                        } else {
                            pm.setPageSize(paginal.getPageSize());
                        }
                        if (pm.getActivePage() >= 0) {
                            paginal.setActivePage(pm.getActivePage());
                        }
                        paginal.setTotalSize(pm.getTotalSize());
                        paginal.addEventListener("onPaging", (EventListener)new TreeModelPagingListener(this, treeModel, expr, paginal));
                    }
                    rodSize = paginal.getPageSize();
                    this.modelRodSizeMap.put(model, rodSize);
                }
                Set templateNames = comp.getTemplateNames();
                block5: for (String name : templateNames) {
                    Template template = comp.getTemplate(name);
                    if (template instanceof TemplateCtrl) {
                        template = ((TemplateCtrl)template).getMeta();
                    }
                    if (!(template instanceof TemplateInfo)) continue;
                    for (NodeInfo child : ((TemplateInfo)template).getChildren()) {
                        AnnotationMap annotationMap;
                        if (!(child instanceof ComponentInfo) || (annotationMap = ((ComponentInfo)child).getAnnotationMap()) == null || annotationMap.getAnnotations("open").isEmpty()) continue;
                        renderAll = true;
                        continue block5;
                    }
                }
            } else if (comp instanceof Cascader) {
                renderAll = true;
            }
            if (renderAll) {
                Desktop desktop = Executions.getCurrent().getDesktop();
                HashSet<TreeModel> renderAllTreeModel = (HashSet<TreeModel>)desktop.getAttribute(RENDER_ALL_TREE_DATA);
                if (renderAllTreeModel == null) {
                    renderAllTreeModel = new HashSet<TreeModel>(1);
                    renderAllTreeModel.add(treeModel);
                    desktop.setAttribute(RENDER_ALL_TREE_DATA, renderAllTreeModel);
                } else {
                    renderAllTreeModel.add(treeModel);
                }
            }
            if (treeModel instanceof TreeSelectableModel && ((TreeSelectableModel)treeModel).isMultiple()) {
                allBindings.put("multiple", true);
            }
            ClientTreeDataListener clientTreeDataListener = new ClientTreeDataListener(this, comp, expr);
            treeModel.removeTreeDataListener((TreeDataListener)clientTreeDataListener);
            treeModel.addTreeDataListener((TreeDataListener)clientTreeDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindListModelHandler(Map<String, Object> allBindings, Object model, ListModel listModel, Component comp, String expr) {
        if (model != null && listModel != null) {
            int rodSize = -1;
            boolean isGrid = comp instanceof Grid;
            boolean isListbox = comp instanceof Listbox;
            if (isGrid || isListbox) {
                Method evalRodMethod = null;
                boolean isRodOrPaging = false;
                try {
                    evalRodMethod = comp.getClass().getDeclaredMethod("evalRod", new Class[0]);
                    evalRodMethod.setAccessible(true);
                    isRodOrPaging = (Boolean)evalRodMethod.invoke((Object)comp, new Object[0]);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    return;
                }
                finally {
                    if (evalRodMethod != null) {
                        evalRodMethod.setAccessible(false);
                    }
                }
                Execution exec = Executions.getCurrent();
                exec.removeAttribute(comp.getUuid());
                if (isRodOrPaging) {
                    Method initRodSizeMethod = null;
                    try {
                        initRodSizeMethod = comp.getClass().getDeclaredMethod("initRodSize", new Class[0]);
                        initRodSizeMethod.setAccessible(true);
                        rodSize = (Integer)initRodSizeMethod.invoke((Object)comp, new Object[0]);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                    finally {
                        if (initRodSizeMethod != null) {
                            initRodSizeMethod.setAccessible(false);
                        }
                    }
                }
            }
            ClientListDataListener clientListDataListener = new ClientListDataListener(this, expr, rodSize);
            listModel.removeListDataListener((ListDataListener)clientListDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindListModelHandler(Map<String, Object> allBindings, Object model, ListModel listModel, Component comp, String expr) {
        if (model != null && listModel != null) {
            this.modelToListModel.put(model, listModel);
            int rodSize = -1;
            boolean isGrid = comp instanceof Grid;
            boolean isListbox = comp instanceof Listbox;
            if (isGrid || isListbox) {
                Paginal paginal;
                Method evalRodMethod = null;
                boolean isRodOrPaging = false;
                try {
                    evalRodMethod = comp.getClass().getDeclaredMethod("evalRod", new Class[0]);
                    evalRodMethod.setAccessible(true);
                    isRodOrPaging = (Boolean)evalRodMethod.invoke((Object)comp, new Object[0]);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    return;
                }
                finally {
                    if (evalRodMethod != null) {
                        evalRodMethod.setAccessible(false);
                    }
                }
                Execution exec = Executions.getCurrent();
                exec.setAttribute(comp.getUuid(), (Object)new Pair((Object)this.view, (Object)expr));
                if (isRodOrPaging) {
                    Method initRodSizeMethod = null;
                    Integer cachedRodSize = this.modelRodSizeMap.get(model);
                    try {
                        initRodSizeMethod = comp.getClass().getDeclaredMethod("initRodSize", new Class[0]);
                        initRodSizeMethod.setAccessible(true);
                        rodSize = (Integer)initRodSizeMethod.invoke((Object)comp, new Object[0]);
                        if (cachedRodSize != null && cachedRodSize > rodSize) {
                            rodSize = cachedRodSize;
                        }
                        this.modelRodSizeMap.put(model, rodSize);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                    finally {
                        if (initRodSizeMethod != null) {
                            initRodSizeMethod.setAccessible(false);
                        }
                    }
                }
                if (isListbox && !"select".equals(comp.getMold())) {
                    paginal = ((Listbox)comp).getPaginal();
                    if (paginal != null) {
                        isRodOrPaging = true;
                        ((Listbox)comp).setPaginal(null);
                        rodSize = paginal.getPageSize();
                        this.modelRodSizeMap.put(model, rodSize);
                        paginal.setTotalSize(listModel.getSize());
                        paginal.addEventListener("onPaging", (EventListener)new ListModelPagingListener(this, comp, expr, paginal));
                        comp.addEventListener("onAcrossPage", event -> {
                            ListModel listModelLive = this.modelToListModel.get(this.getModelFromComponent(comp));
                            Map data = (Map)event.getData();
                            int page = AuRequests.getInt((Map)data, (String)"page", (int)0);
                            int offset = AuRequests.getInt((Map)data, (String)"offset", (int)0);
                            int shift = AuRequests.getInt((Map)data, (String)"shift", (int)0);
                            int pageSize = paginal.getPageSize();
                            int index = page * pageSize + offset;
                            int from = shift < 0 ? index + shift : index;
                            int to = shift > 0 ? index + shift : index;
                            paginal.setActivePage(index / pageSize);
                            Events.postEvent((Event)new PagingEvent("onPaging", (Component)paginal, paginal.getActivePage()));
                            to = Math.min(to, listModelLive.getSize() - 1);
                            Selectable smodel = (Selectable)listModelLive;
                            if (!smodel.isMultiple() || shift == 0) {
                                if (!smodel.isMultiple()) {
                                    from = to;
                                }
                                smodel.clearSelection();
                            }
                            while (from <= to) {
                                smodel.addToSelection(listModelLive.getElementAt(from++));
                            }
                        });
                    }
                    if (listModel instanceof Selectable && ((Selectable)listModel).isMultiple()) {
                        allBindings.put("multiple", true);
                    }
                    if (isRodOrPaging) {
                        ClientBindComposer.initListboxRODProperties(allBindings, 0, rodSize);
                    }
                } else if (isGrid) {
                    paginal = ((Grid)comp).getPaginal();
                    if (paginal != null) {
                        isRodOrPaging = true;
                        ((Grid)comp).setPaginal(null);
                        rodSize = paginal.getPageSize();
                        this.modelRodSizeMap.put(model, rodSize);
                        paginal.setTotalSize(listModel.getSize());
                        paginal.addEventListener("onPaging", (EventListener)new ListModelPagingListener(this, comp, expr, paginal));
                    }
                    if (isRodOrPaging) {
                        ClientBindComposer.initGridRODProperties(allBindings, 0, rodSize);
                    }
                }
                String onInitModel = "onInitModel";
                if (comp.isListenerAvailable("onInitModel", false)) {
                    Iterator iterator = comp.getEventListeners("onInitModel").iterator();
                    while (iterator.hasNext()) {
                        comp.removeEventListener("onInitModel", (EventListener)iterator.next());
                    }
                }
            } else if (comp instanceof Chosenbox && model instanceof ListSubModel) {
                this.modelRodSizeMap.put(model, 0);
            }
            ClientListDataListener clientListDataListener = new ClientListDataListener(this, expr, rodSize);
            listModel.removeListDataListener((ListDataListener)clientListDataListener);
            listModel.addListDataListener((ListDataListener)clientListDataListener);
        }
    }

    private void unbindStepModelHandler(StepModel stepModel, String expr) {
        if (stepModel != null) {
            ListModel steps = stepModel.getSteps();
            ClientStepModelDataListener clientListDataListener = new ClientStepModelDataListener(this, expr);
            steps.removeListDataListener((ListDataListener)clientListDataListener);
        }
    }

    private void bindStepModelHandler(StepModel stepModel, String expr) {
        if (stepModel != null) {
            ListModel steps = stepModel.getSteps();
            ClientStepModelDataListener clientListDataListener = new ClientStepModelDataListener(this, expr);
            steps.removeListDataListener((ListDataListener)clientListDataListener);
            steps.addListDataListener((ListDataListener)clientListDataListener);
        }
    }

    public void handleModel(Map<String, Object> allBindings, Component comp, String expr, Map<String, String[]> converterInfo) {
        if (comp.hasAttribute(BindELContext.getModelName((Component)comp))) {
            return;
        }
        if (comp instanceof Tree || comp instanceof Organigram || comp instanceof Cascader) {
            this.handleTreeModel(allBindings, comp, expr, converterInfo);
        } else if (comp instanceof Stepbar) {
            this.handleStepModel(allBindings, (Stepbar)comp, expr, converterInfo);
        } else {
            this.handleListModel(allBindings, comp, expr, converterInfo);
        }
    }

    private void handleTreeModel(Map<String, Object> allBindings, Component comp, String expr, Map<String, String[]> converterInfo) {
        BindContext bindContext = BindContextUtil.newBindContext((Binder)this._binder, null, (boolean)false, null, (Component)this.view, null);
        ExpressionX expressionX = this.getEvaluatorX().parseExpressionX(null, expr, Object.class);
        Object model = this.getEvaluatorX().getValue(bindContext, this.view, expressionX);
        TreeModel treeModel = null;
        if (converterInfo != null) {
            Converter converter = this.findConverter(comp, converterInfo.get(VALUE_ANNO_ATTR)[0]);
            Object convertedModel = converter.coerceToUi(model, comp, bindContext);
            if (convertedModel instanceof TreeModel) {
                treeModel = (TreeModel)convertedModel;
            }
        } else if (model instanceof TreeModel) {
            treeModel = (TreeModel)model;
        }
        this.bindComponentToModel(comp, model, allBindings, converterInfo, expr);
        this.bindTreeModelHandler(allBindings, model, treeModel, comp, expr);
    }

    private void handleStepModel(Map<String, Object> allBindings, Stepbar comp, String expr, Map<String, String[]> converterInfo) {
        BindContext bindContext = BindContextUtil.newBindContext((Binder)this._binder, null, (boolean)false, null, (Component)this.view, null);
        ExpressionX expressionX = this.getEvaluatorX().parseExpressionX(null, expr, Object.class);
        Object model = this.getEvaluatorX().getValue(bindContext, this.view, expressionX);
        StepModel stepModel = null;
        if (converterInfo != null) {
            Converter converter = this.findConverter((Component)comp, converterInfo.get(VALUE_ANNO_ATTR)[0]);
            Object convertedModel = converter.coerceToUi(model, (Component)comp, bindContext);
            if (convertedModel instanceof StepModel) {
                stepModel = (StepModel)convertedModel;
            }
        } else {
            stepModel = (StepModel)model;
        }
        this.modelToStepModel.put(model, stepModel);
        this.bindComponentToModel((Component)comp, model, allBindings, converterInfo, expr);
        this.bindStepModelHandler(stepModel, expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListModel(Map<String, Object> allBindings, Component comp, String expr, Map<String, String[]> converterInfo) {
        BindContext bindContext = BindContextUtil.newBindContext((Binder)this._binder, null, (boolean)false, null, (Component)this.view, null);
        ExpressionX expressionX = this.getEvaluatorX().parseExpressionX(null, expr, Object.class);
        try {
            ValueReference valueReference = expressionX.getValueReference((XelContext)new SimpleBindXelContext(comp, (Binder)this._binder, null, null));
            Object model = this.getEvaluatorX().getValue(bindContext, this.view, expressionX);
            ListModel listModel = null;
            if (converterInfo != null) {
                Converter converter = this.findConverter(comp, converterInfo.get(VALUE_ANNO_ATTR)[0]);
                Object convertedModel = converter.coerceToUi(model, comp, bindContext);
                if (convertedModel instanceof ListModel) {
                    listModel = (ListModel)convertedModel;
                }
            } else if (model instanceof ListModel) {
                listModel = (ListModel)model;
            }
            if (comp instanceof Chosenbox) {
                if (!(listModel instanceof Selectable)) {
                    throw new UiException(String.valueOf(model.getClass()) + " must implement " + String.valueOf(Selectable.class));
                }
                try {
                    this.view.setAttribute(DISABLE_CLIENT_UPDATE, (Object)Boolean.TRUE);
                    ((Selectable)listModel).setMultiple(true);
                }
                finally {
                    this.view.removeAttribute(DISABLE_CLIENT_UPDATE);
                }
            } else if (comp instanceof Combobox && listModel instanceof ListSubModel) {
                listModel = ((ListSubModel)model).getSubModel(((Combobox)comp).getRawValue(), -1);
            }
            this.bindComponentToModel(comp, model, allBindings, converterInfo, expr);
            this.bindListModelHandler(allBindings, model, listModel, comp, expr);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            // empty catch block
        }
    }

    public void notifyPropertyChange(PropertyChangeEvent evt) {
        if (!this.componentToModel.isEmpty()) {
            new HashMap<Component, Pair<ComponentBindInfo, Object>>(this.componentToModel).forEach((comp, pair) -> {
                Object base;
                ComponentBindInfo bindInfo = (ComponentBindInfo)pair.getX();
                Object model = pair.getY();
                ExpressionX expressionX = this.getEvaluatorX().parseExpressionX(null, bindInfo.expression, Object.class);
                Node node = ExpressionBuilder.createNode((String)("${" + bindInfo.expression + "}"));
                Object object = base = node.jjtGetNumChildren() > 0 ? node.jjtGetChild(0).getValue(new EvaluationContext((ELContext)new BindELContext((XelContext)new SimpleBindXelContext(comp, (Binder)this._binder, null, null)), null, null)) : null;
                if (Objects.equals((Object)evt.getBase(), base)) {
                    BindContext bindContext = BindContextUtil.newBindContext((Binder)this._binder, null, (boolean)false, null, (Component)this.view, null);
                    Object newModel = this.getEvaluatorX().getValue(bindContext, this.view, expressionX);
                    if (!Objects.equals((Object)newModel, (Object)model)) {
                        if (model != NULL) {
                            StepModel stepModel;
                            TreeModel treeModel;
                            ListModel listModel = this.modelToListModel.get(model);
                            if (listModel != null) {
                                this.unbindListModelHandler(bindInfo.allBindings, model, listModel, (Component)comp, bindInfo.expression);
                            }
                            if ((treeModel = this.modelToTreeModel.get(model)) != null) {
                                this.unbindTreeModelHandler(bindInfo.allBindings, model, treeModel, (Component)comp, bindInfo.expression);
                            }
                            if ((stepModel = this.modelToStepModel.get(model)) != null) {
                                this.unbindStepModelHandler(stepModel, bindInfo.expression);
                            }
                        }
                        BindELContext.removeModel((Component)comp);
                        this.unbindComponentToModel((Component)comp, model, bindInfo.allBindings, bindInfo.converterInfo, bindInfo.expression);
                        if (newModel != null) {
                            this.handleModel(bindInfo.allBindings, (Component)comp, bindInfo.expression, bindInfo.converterInfo);
                        }
                        this.bindComponentToModel((Component)comp, newModel, bindInfo.allBindings, bindInfo.converterInfo, bindInfo.expression);
                        BindELContext.addModel((Component)comp, (Object)newModel);
                    }
                }
            });
        }
    }

    public ComponentInfo doBeforeCompose(Page page, Component component, ComponentInfo componentInfo) throws Exception {
        return componentInfo;
    }

    public void doBeforeComposeChildren(T comp) throws Exception {
        this.view = comp;
        ConventionWires.wireController(comp, (Object)this);
        if (comp.getPage() == null) {
            final Map currentArg = Executions.getCurrent().getArg();
            ((ComponentCtrl)comp).addCallback("afterPageAttached", new Callback((Component)comp){
                final /* synthetic */ Component val$comp;
                {
                    this.val$comp = component;
                }

                public void call(Object data) {
                    try {
                        Executions.getCurrent().pushArg(currentArg);
                        ClientBindComposer.this.doBeforeComposeChildren(this.val$comp);
                    }
                    catch (Exception e) {
                        throw UiException.Aide.wrap((Throwable)e);
                    }
                    finally {
                        Executions.getCurrent().popArg();
                    }
                }
            });
            return;
        }
        this.doBeforeComposeChildren0(comp, this.initViewModel(this.getEvaluatorX(), (Component)comp));
    }

    protected void doBeforeComposeChildren0(T comp, Object vmObject) throws Exception {
        this.viewModel = vmObject;
        this._binder = this.initBinder(this.getEvaluatorX(), (Component)comp);
        if (!this.equals(this.viewModel)) {
            Object vmProxy = null;
            String enabled = Library.getProperty((String)"org.zkoss.bind.viewModel.autoNotifyChange.enabled", (String)"false");
            if (Boolean.valueOf(enabled).booleanValue() || this.viewModel.getClass().getAnnotation(AutoNotifyChange.class) != null) {
                vmProxy = ProxyHelperEx.createViewModelProxy((Object)this.viewModel);
            }
            if (vmProxy != null) {
                this.viewModel = vmProxy;
                comp.setAttribute((String)comp.getAttribute(VM_ID), vmProxy);
            }
        }
        ValidationMessages vmsgs = this.initValidationMessages(this.getEvaluatorX(), (Component)comp, this._binder);
        Selectors.wireVariables(comp, (Object)this.viewModel, (List)Selectors.newVariableResolvers((Class)BindUtils.getViewModelClass((Object)this.viewModel), null));
        if (vmsgs != null) {
            this._binder.setValidationMessages(vmsgs);
        }
        this._binder.init((Component)comp, this.viewModel, this.getViewModelInitArgs(this.getEvaluatorX(), (Component)comp));
    }

    private Map<String, Object> getViewModelInitArgs(BindEvaluatorX evalx, Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Collection anncol = compCtrl.getAnnotations(VIEW_MODEL_ATTR, INIT_ANNO);
        if (anncol.size() == 0) {
            return null;
        }
        Annotation ann = (Annotation)anncol.iterator().next();
        Map attrs = ann.getAttributes();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : attrs.entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if (VALUE_ANNO_ATTR.equals(tag)) continue;
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        return args == null ? null : BindEvaluatorXUtil.parseArgs((BindEvaluatorX)this._binder.getEvaluatorX(), args);
    }

    private ValidationMessages initValidationMessages(BindEvaluatorX evalx, Component comp, Binder binder) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation idanno = compCtrl.getAnnotation(VALIDATION_MESSAGES_ATTR, ID_ANNO);
        Annotation initanno = compCtrl.getAnnotation(VALIDATION_MESSAGES_ATTR, INIT_ANNO);
        Object vmessages = null;
        String vname = null;
        BindingAnnotationInfoChecker checker = this.getBindingAnnotationInfoChecker();
        if (checker != null) {
            checker.checkValidationMessages(comp);
        }
        if (idanno != null) {
            vname = (String)BindEvaluatorXUtil.eval((BindEvaluatorX)evalx, (Component)comp, (String)AnnotationUtil.testString((String[])idanno.getAttributeValues(VALUE_ANNO_ATTR), (Annotation)idanno), String.class);
            if (Strings.isEmpty((String)vname)) {
                throw new UiException(MiscUtil.formatLocationMessage((String)"name of ValidationMessages is empty", (Annotation)idanno));
            }
        } else {
            return null;
        }
        if (initanno != null) {
            vmessages = BindEvaluatorXUtil.eval((BindEvaluatorX)evalx, (Component)comp, (String)AnnotationUtil.testString((String[])initanno.getAttributeValues(VALUE_ANNO_ATTR), (Annotation)initanno), Object.class);
            try {
                if (vmessages instanceof String) {
                    vmessages = comp.getPage().resolveClass((String)vmessages);
                }
                if (vmessages instanceof Class) {
                    vmessages = ((Class)vmessages).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e, (String)MiscUtil.formatLocationMessage((String)e.getMessage(), (Annotation)initanno));
            }
            if (!(vmessages instanceof ValidationMessages)) {
                throw new UiException(MiscUtil.formatLocationMessage((String)("evaluated validationMessages is not a ValidationMessages is " + String.valueOf(vmessages)), (Annotation)initanno));
            }
        } else {
            vmessages = new ValidationMessagesImpl();
        }
        vmessages = new ValidationMessagesMonitor(this, (ValidationMessages)vmessages);
        comp.setAttribute(vname, vmessages);
        comp.setAttribute(VALIDATION_MESSAGE_ID, (Object)vname);
        return (ValidationMessages)vmessages;
    }

    private BindingAnnotationInfoChecker getBindingAnnotationInfoChecker() {
        DebuggerFactory factory = DebuggerFactory.getInstance();
        return factory == null ? null : factory.getAnnotationInfoChecker();
    }

    private Object initViewModel(BindEvaluatorX evalx, Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation idanno = compCtrl.getAnnotation(VIEW_MODEL_ATTR, ID_ANNO);
        Annotation initanno = compCtrl.getAnnotation(VIEW_MODEL_ATTR, INIT_ANNO);
        String vmname = null;
        Object vm = null;
        BindingAnnotationInfoChecker checker = this.getBindingAnnotationInfoChecker();
        if (checker != null) {
            checker.checkViewModel(comp);
        }
        if (idanno == null && initanno == null) {
            return this.viewModel;
        }
        if (idanno == null) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage((String)"you have to use @id to assign the name of view model", (Component)comp));
        }
        if (initanno == null) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage((String)"you have to use @init to assign the view model", (Component)comp));
        }
        vmname = (String)BindEvaluatorXUtil.eval((BindEvaluatorX)evalx, (Component)comp, (String)AnnotationUtil.testString((String[])idanno.getAttributeValues(VALUE_ANNO_ATTR), (Annotation)idanno), String.class);
        vm = BindEvaluatorXUtil.eval((BindEvaluatorX)evalx, (Component)comp, (String)AnnotationUtil.testString((String[])initanno.getAttributeValues(VALUE_ANNO_ATTR), (Annotation)initanno), Object.class);
        if (Strings.isEmpty((String)vmname)) {
            throw new UiException(MiscUtil.formatLocationMessage((String)"name of view model is empty", (Annotation)idanno));
        }
        try {
            if (vm instanceof String) {
                Page page = comp.getPage();
                if (page == null) {
                    throw new UiException(MiscUtil.formatLocationMessage((String)("can't find Page to resolve a view model class :'" + String.valueOf(vm) + "'"), (Annotation)initanno));
                }
                vm = comp.getPage().resolveClass((String)vm);
            }
            if (vm instanceof Class) {
                vm = ((Class)vm).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw MiscUtil.mergeExceptionInfo((Exception)e, (Object)initanno);
        }
        this.checkViewModelObject(vm, vmname, initanno);
        comp.setAttribute(vmname, vm);
        comp.setAttribute(VM_ID, (Object)vmname);
        return vm;
    }

    protected Object initInnerViewModel(BindEvaluatorX evalx, Component comp, String vmname, Object vm) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        try {
            if (vm instanceof String) {
                Page page = comp.getPage();
                if (page == null) {
                    throw new UiException("can't find Page to resolve a view model class :'" + String.valueOf(vm) + "'");
                }
                vm = comp.getPage().resolveClass((String)vm);
            }
            if (vm instanceof Class) {
                vm = ((Class)vm).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
        this.checkViewModelObject(vm, vmname, null);
        comp.setAttribute(vmname, vm);
        comp.setAttribute(VM_ID, (Object)vmname);
        return vm;
    }

    private void checkViewModelObject(Object vm, String vmname, Annotation initanno) {
        if (vm == null) {
            Object vmNullExceptionMsg = "view model of '" + vmname + "' is null";
            if (initanno != null) {
                vmNullExceptionMsg = MiscUtil.formatLocationMessage((String)vmNullExceptionMsg, (Annotation)initanno);
            }
            throw new UiException((String)vmNullExceptionMsg);
        }
        if (vm.getClass().isPrimitive()) {
            Object vmPrimitiveExceptionMsg = "view model '" + vmname + "' is a primitive type, is " + String.valueOf(vm);
            if (initanno != null) {
                vmPrimitiveExceptionMsg = MiscUtil.formatLocationMessage((String)vmPrimitiveExceptionMsg, (Annotation)initanno);
            }
            throw new UiException((String)vmPrimitiveExceptionMsg);
        }
    }

    private ClientBinder initBinder(BindEvaluatorX evalx, Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation idanno = compCtrl.getAnnotation(BINDER_ATTR, ID_ANNO);
        Annotation initanno = compCtrl.getAnnotation(BINDER_ATTR, INIT_ANNO);
        Object binder = null;
        String bname = null;
        BindingAnnotationInfoChecker checker = this.getBindingAnnotationInfoChecker();
        if (checker != null) {
            checker.checkBinder(comp);
        }
        if (idanno != null) {
            bname = (String)BindEvaluatorXUtil.eval((BindEvaluatorX)evalx, (Component)comp, (String)AnnotationUtil.testString((String[])idanno.getAttributeValues(VALUE_ANNO_ATTR), (Annotation)idanno), String.class);
            if (Strings.isEmpty((String)bname)) {
                throw new UiException(MiscUtil.formatLocationMessage((String)"name of binder is empty", (Annotation)idanno));
            }
        } else {
            bname = BINDER_ATTR;
        }
        if (initanno != null) {
            String expr;
            binder = AnnotationUtil.testString((String[])initanno.getAttributeValues(VALUE_ANNO_ATTR), (Annotation)initanno);
            String name = AnnotationUtil.testString((String[])initanno.getAttributeValues(QUEUE_NAME_ANNO_ATTR), (Annotation)initanno);
            String scope = AnnotationUtil.testString((String[])initanno.getAttributeValues(QUEUE_SCOPE_ANNO_ATTR), (Annotation)initanno);
            if (name != null && Strings.isBlank((String)(name = (String)BindEvaluatorXUtil.eval((BindEvaluatorX)evalx, (Component)comp, (String)(expr = name), String.class)))) {
                throw new UiException(MiscUtil.formatLocationMessage((String)("evaluated queue name is empty, expression is " + expr), (Annotation)initanno));
            }
            if (scope != null && Strings.isBlank((String)(scope = (String)BindEvaluatorXUtil.eval((BindEvaluatorX)evalx, (Component)comp, (String)(expr = scope), String.class)))) {
                throw new UiException(MiscUtil.formatLocationMessage((String)("evaluated queue scope is empty, expression is " + expr), (Annotation)initanno));
            }
            if (binder != null) {
                binder = BindEvaluatorXUtil.eval((BindEvaluatorX)evalx, (Component)comp, (String)((String)binder), Object.class);
                try {
                    if (binder instanceof String) {
                        binder = comp.getPage().resolveClass((String)binder);
                    }
                    if (binder instanceof Class) {
                        binder = ((Class)binder).getDeclaredConstructor(String.class, String.class).newInstance(name, scope);
                    }
                }
                catch (Exception e) {
                    throw UiException.Aide.wrap((Throwable)e, (String)e.getMessage());
                }
                if (!(binder instanceof ClientBinder)) {
                    throw new UiException(MiscUtil.formatLocationMessage((String)("evaluated binder is not a client binder is " + String.valueOf(binder)), (Annotation)initanno));
                }
            } else {
                binder = this.newClientBinder(name, scope);
            }
        } else {
            binder = this.newClientBinder(null, null);
        }
        comp.setAttribute(bname, binder);
        comp.setAttribute(BINDER_ID, (Object)bname);
        return (ClientBinder)binder;
    }

    private ClientBinder newClientBinder(String name, String scope) {
        String clznm = Library.getProperty((String)"org.zkoss.clientbind.bind.ClientBinder.class");
        if (clznm != null) {
            try {
                return (ClientBinder)Classes.newInstanceByThread((String)clznm, (Class[])new Class[]{String.class, String.class}, (Object[])new String[]{name, scope});
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e, (String)"Can't initialize binder");
            }
        }
        return new ClientBinderImpl(name, scope);
    }

    public boolean doCatch(Throwable throwable) throws Exception {
        return false;
    }

    public void doFinally() throws Exception {
    }

    private static int getGroupIndex(List<int[]> groupInfo, int index) {
        int j = 0;
        int gindex = -1;
        int[] g2 = null;
        for (int[] g2 : groupInfo) {
            if (index == g2[0]) {
                gindex = j;
            } else if (index < g2[0]) break;
            ++j;
        }
        return gindex != -1 ? gindex : (g2 != null && index < g2[0] + g2[1] ? j - 1 : (g2 != null && index == g2[0] + g2[1] && g2[2] == -1 ? j - 1 : gindex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        Map data = request.getData();
        if (cmd.startsWith("onBindCommand$") || cmd.startsWith("onBindGlobalCommand$") || cmd.startsWith("onBindCommandUpload$")) {
            String vcmd;
            String command = data.get("cmd").toString();
            String[] vcmds = command.split("\\$__\\$");
            block28 : switch (vcmd = vcmds[0]) {
                case "$ubc$": {
                    return UpdateBindingCommand.processCommand(this, command, data);
                }
                case "$vbc$": {
                    return ValidateBindingCommand.processCommand(this, command, data);
                }
                case "$rec$": {
                    return RemoteELCommand.processCommand(this, command, data);
                }
                case "$rcc$": {
                    return RemoteConverterCommand.processCommand(this, command, data);
                }
                case "$fsc$": {
                    return FormSaveCommand.processCommand(this, command, data);
                }
                case "$ctc$": {
                    return CreateTemplateCommand.processCommand(this, command, data);
                }
                case "$itc$": {
                    return IncludeTemplateCommand.processCommand(this, command, data);
                }
                case "$cvc$": {
                    return CreateViewModelCommand.processCommand(this, command, data);
                }
                case "$odl$": {
                    return OnDataLoadingCommand.processCommand(this, command, data);
                }
                case "$ppmc$": {
                    return ProcessPagingModelCommand.processCommand(this, command, data);
                }
                case "$fbdc$": {
                    Map args = (Map)data.get("args");
                    String uuid = (String)args.get(BEAN_UID);
                    Object cachedBeanById = this.getCachedBeanById(uuid);
                    if (cachedBeanById == null) break;
                    try {
                        Clients.sendClientCommand((Component)this.view, (String)command, (Object)new JavaScriptValue(this.writeValueAsString(cachedBeanById)));
                        break;
                    }
                    catch (JsonProcessingException e) {
                        throw UiException.Aide.wrap((Throwable)e);
                    }
                }
                case "$rcvmc$": {
                    ValidationMessages validationMessages = this._binder.getValidationMessages();
                    if (validationMessages.getMessages().length <= 0) break;
                    Map args = (Map)data.get("args");
                    validationMessages.clearMessages(this.view.getDesktop().getComponentByUuidIfAny((String)args.get("uuid")), (String)args.get("prop"));
                    break;
                }
                case "$gpoc$": {
                    Map args = (Map)data.get("args");
                    String modelId = (String)args.get(MODEL_ATTR);
                    Object cachedBeanById = this.getCachedBeanById(modelId);
                    ListModel listModel = this.modelToListModel.get(cachedBeanById);
                    int index = (Integer)args.get("referenceIndex");
                    if (!(listModel instanceof GroupsListModel)) break;
                    List groupsInfos = ((GroupsListModel)listModel).getGroupsInfos();
                    int groupIndex = ClientBindComposer.getGroupIndex(groupsInfos, index);
                    GroupsModel gmodel = ((GroupsListModel)listModel).getGroupsModel();
                    if (((Boolean)args.get("open")).booleanValue()) {
                        gmodel.addOpenGroup(groupIndex);
                        break;
                    }
                    gmodel.removeOpenGroup(groupIndex);
                    break;
                }
                case "$tioc$": {
                    Map args = (Map)data.get("args");
                    String modelId = (String)args.get(MODEL_ATTR);
                    Object cachedBeanById = this.getCachedBeanById(modelId);
                    TreeModel treeModel = this.modelToTreeModel.get(cachedBeanById);
                    if (!(treeModel instanceof TreeOpenableModel)) break;
                    if (((Boolean)args.get("open")).booleanValue()) {
                        ((TreeOpenableModel)treeModel).addOpenPath(Optional.ofNullable((List)args.get("referencePath")).orElse(Collections.emptyList()).stream().mapToInt(i -> i).toArray());
                        break;
                    }
                    ((TreeOpenableModel)treeModel).removeOpenPath(Optional.ofNullable((List)args.get("referencePath")).orElse(Collections.emptyList()).stream().mapToInt(i -> i).toArray());
                    break;
                }
                case "$lmsc$": {
                    ListModel listModel;
                    Map args = (Map)data.get("args");
                    String modelId = (String)args.get(MODEL_ATTR);
                    Object cachedBeanById = this.getCachedBeanById(modelId);
                    ListModel listModel2 = listModel = cachedBeanById instanceof ListModel ? (ListModel)cachedBeanById : this.modelToListModel.get(cachedBeanById);
                    if (!(listModel instanceof Selectable)) break;
                    Selectable selectable = (Selectable)listModel;
                    Boolean isSelectAll = (Boolean)args.get("selectAll");
                    try {
                        int startIndex;
                        boolean multiple;
                        this.view.setAttribute(DISABLE_CLIENT_UPDATE, (Object)Boolean.TRUE);
                        ArrayList<Integer> selection = (ArrayList<Integer>)args.get("itemsIndex");
                        if (isSelectAll != null) {
                            if (isSelectAll.booleanValue()) {
                                selectable.getSelectionControl().setSelectAll(true);
                                boolean gmodel = true;
                                return gmodel;
                            }
                            if (selection.size() == 0) {
                                selectable.getSelectionControl().setSelectAll(false);
                                boolean gmodel = true;
                                return gmodel;
                            }
                        }
                        if (!(multiple = ((Selectable)listModel).isMultiple()) && selection.size() > 1) {
                            Integer lastSelIndex = (Integer)selection.get(selection.size() - 1);
                            selection = new ArrayList<Integer>();
                            selection.add(lastSelIndex);
                        }
                        Integer pageSize = (Integer)args.get("pageSize");
                        Integer activePage = (Integer)args.get("activePage");
                        Integer offset = (Integer)args.get("offset");
                        Integer limit = (Integer)args.get("limit");
                        if (pageSize == null && activePage == null && offset == null && limit == null) {
                            selectable.setSelection((Collection)selection.stream().map(i -> listModel.getElementAt(i.intValue())).collect(Collectors.toList()));
                            break;
                        }
                        int n = startIndex = pageSize == null ? offset : activePage * pageSize;
                        if (!multiple && selection.size() > 0) {
                            selectable.clearSelection();
                            selectable.addToSelection(listModel.getElementAt(startIndex + (Integer)selection.get(0)));
                            break;
                        }
                        int endIndex = Math.min(startIndex + (pageSize == null ? limit : pageSize), listModel.getSize()) - 1;
                        int i2 = 0;
                        while (startIndex + i2 <= endIndex) {
                            Object element = listModel.getElementAt(startIndex + i2);
                            if (selection.contains(i2)) {
                                selectable.addToSelection(element);
                            } else {
                                selectable.removeFromSelection(element);
                            }
                            ++i2;
                        }
                        break;
                    }
                    finally {
                        this.view.removeAttribute(DISABLE_CLIENT_UPDATE);
                    }
                }
                case "$lsmc$": {
                    String objectString;
                    Map args = (Map)data.get("args");
                    Object cachedBeanById = this.getCachedBeanById((String)args.get(MODEL_ATTR));
                    ListSubModel listSubModel = cachedBeanById instanceof ListSubModel ? (ListSubModel)cachedBeanById : (ListSubModel)this.modelToListModel.get(cachedBeanById);
                    ListModel subModel = listSubModel.getSubModel(args.get(VALUE_ANNO_ATTR), ((Integer)args.get("nRows")).intValue());
                    ArrayList<Object> listData = new ArrayList<Object>();
                    for (int i3 = 0; i3 < subModel.getSize(); ++i3) {
                        listData.add(subModel.getElementAt(i3));
                    }
                    try {
                        objectString = this.writeValueAsString(listData);
                    }
                    catch (JsonProcessingException e) {
                        throw UiException.Aide.wrap((Throwable)e);
                    }
                    Clients.sendClientCommand((Component)this.view, (String)command, (Object)new JavaScriptValue(objectString));
                    break;
                }
                case "$lsmsc$": {
                    ListModel listModel;
                    Map args = (Map)data.get("args");
                    Object cachedBeanById = this.getCachedBeanById((String)args.get(MODEL_ATTR));
                    ListModel listModel3 = listModel = cachedBeanById instanceof ListModel ? (ListModel)cachedBeanById : this.modelToListModel.get(cachedBeanById);
                    if (!(listModel instanceof Selectable)) break;
                    Selectable selectable = (Selectable)listModel;
                    String itemInfo = (String)args.get("itemInfo");
                    boolean isSelected = (Boolean)args.get("isSelected");
                    int size = listModel.getSize();
                    for (int i4 = 0; i4 < size; ++i4) {
                        Object element = listModel.getElementAt(i4);
                        if ((!(element instanceof String) || !element.equals(itemInfo)) && !this.getBeanUid(element).equals(itemInfo)) continue;
                        try {
                            this.view.setAttribute(DISABLE_CLIENT_UPDATE, (Object)Boolean.TRUE);
                            if (isSelected) {
                                selectable.addToSelection(element);
                                break block28;
                            }
                            selectable.removeFromSelection(element);
                            break block28;
                        }
                        finally {
                            this.view.removeAttribute(DISABLE_CLIENT_UPDATE);
                        }
                    }
                    break;
                }
                case "$tmsc$": {
                    Map args = (Map)data.get("args");
                    String modelId = (String)args.get(MODEL_ATTR);
                    Object cachedBeanById = this.getCachedBeanById(modelId);
                    TreeModel treeModel = this.modelToTreeModel.get(cachedBeanById);
                    if (!(treeModel instanceof TreeSelectableModel)) break;
                    TreeSelectableModel selectable = (TreeSelectableModel)treeModel;
                    List selection = (List)args.get("itemsPath");
                    try {
                        this.view.setAttribute(DISABLE_CLIENT_UPDATE, (Object)Boolean.TRUE);
                        if (selection == null) {
                            selectable.clearSelection();
                            break;
                        }
                        selectable.addSelectionPaths((int[][])selection.stream().map(path -> path.stream().mapToInt(i -> i).toArray()).collect(Collectors.toList()).toArray((T[])new int[0][0]));
                        break;
                    }
                    finally {
                        this.view.removeAttribute(DISABLE_CLIENT_UPDATE);
                    }
                }
                default: {
                    List remoteCmdArgs;
                    Map mmv;
                    ToServerCommand ccmd = (ToServerCommand)ViewModelAnnotationResolvers.getAnnotation((Class)BindUtils.getViewModelClass((Object)this.viewModel), ToServerCommand.class);
                    ArrayList<String> asList = new ArrayList<String>();
                    if (ccmd != null) {
                        asList.addAll(Arrays.asList(ccmd.value()));
                    }
                    if (!(mmv = this._binder.getMatchMediaValue()).isEmpty()) {
                        asList.addAll(mmv.keySet());
                    }
                    Object argsData = data.get("args");
                    Map args = Collections.emptyMap();
                    if (argsData instanceof Map) {
                        args = (Map)argsData;
                        for (Map.Entry me : args.entrySet()) {
                            Object valueBean;
                            String newbuid;
                            JSONObject json;
                            String bid;
                            if (!(me.getValue() instanceof JSONObject) || (bid = (String)(json = (JSONObject)me.getValue()).get((Object)BEAN_UID)) == null) continue;
                            boolean isForm = false;
                            if (bid != null && !(newbuid = bid.replace("$$", "")).equals(bid)) {
                                isForm = true;
                                bid = newbuid;
                            }
                            if ((valueBean = this.getCachedBeanById(bid)) == null) continue;
                            JavaType javaType = ObjectMappers.SETTER_OBJECT_MAPPER.getTypeFactory().constructType(valueBean.getClass());
                            valueBean = isForm ? ProxyHelper.createFormProxy((Object)valueBean, valueBean.getClass()) : valueBean;
                            ObjectReader valueObjectReader = ObjectMappers.SETTER_OBJECT_MAPPER.readerForUpdating(valueBean);
                            valueObjectReader = valueObjectReader.forType(javaType);
                            try {
                                Object valueObj = valueObjectReader.readValue(JSONValue.toJSONString((Object)json.get((Object)VALUE_ANNO_ATTR)));
                                args.put((String)me.getKey(), valueObj);
                            }
                            catch (Exception e) {
                                args.put((String)me.getKey(), valueBean);
                            }
                        }
                    }
                    if ((remoteCmdArgs = (List)args.remove(REMOTE_CMD_ARG)) != null) {
                        this.processRemoteArgs(args, remoteCmdArgs);
                    }
                    if (cmd.startsWith("onBindCommand$")) {
                        if (vcmds.length == 1 && !asList.contains("*") && !asList.contains(vcmd)) {
                            return false;
                        }
                        this._binder.sendCommand(vcmd, args);
                    } else if (cmd.startsWith("onBindGlobalCommand$")) {
                        ClientBinderImpl.parseEventArguments(args, this.view, command);
                        BindUtils.postGlobalCommand((String)this._binder.getQueueName(), (String)this._binder.getQueueScope(), (String)vcmd, (Map)args);
                    } else if (cmd.startsWith("onBindCommandUpload$")) {
                        this._binder.sendCommand(vcmd, Collections.singletonMap("$ZKCLIENTUPLOADINFO$", UploadEvent.getUploadEvent((String)vcmd, (Component)request.getComponent(), (AuRequest)request)));
                    }
                    Object updates = args != null ? args.get(COMMAND_TRACKING_ARGUMENTS_CHANGES) : null;
                    Clients.sendClientCommand((Component)this.view, (String)command, updates);
                }
            }
            return true;
        }
        if ("$rms$".equals(cmd)) {
            Object o = data.get("");
            if (o instanceof JSONArray) {
                ((JSONArray)o).forEach(d -> {
                    Desktop desktop = Executions.getCurrent().getDesktop();
                    Component component = desktop.getComponentByUuidIfAny(String.valueOf(d));
                    if (component != null) {
                        component.detach();
                    }
                });
            } else if (this.view.getPage() instanceof VolatilePage) {
                this.view.detach();
            }
        }
        return false;
    }

    private void processRemoteArgs(Map<String, Object> args, List<String> remoteArgs) {
        for (String arg : remoteArgs) {
            args.put(arg, RemoteELCommand.resolveRemoteEL(this, (String)args.get(arg), args));
        }
    }

    protected Object evalExpression(Component target, String expression) {
        BindEvaluatorX evaluatorX = this.getEvaluatorX();
        return evaluatorX.getValue(BindContextUtil.newBindContext((Binder)this._binder, null, (boolean)false, null, (Component)this.view, null), target, evaluatorX.parseExpressionX(null, expression, Object.class));
    }

    private Map<String, String[]> parseConverter(Component comp, String propName) {
        Collection annos = ((ComponentCtrl)comp).getAnnotations(propName, "converter");
        if (annos.size() == 0) {
            return null;
        }
        if (annos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage((String)("Allow only one converter for " + propName + " of " + String.valueOf(comp)), (Component)comp));
        }
        Annotation ann = (Annotation)annos.iterator().next();
        String expr = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if (!VALUE_ANNO_ATTR.equals(tag)) continue;
            expr = AnnotationUtil.testString((String[])tagExpr, (Annotation)ann);
        }
        if (Strings.isBlank(expr)) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage((String)("value of converter is empty, check " + propName + " of " + String.valueOf(comp)), (Component)comp));
        }
        return ((Annotation)annos.iterator().next()).getAttributes();
    }

    protected Converter findConverter(Component target, String expr) {
        Converter converter;
        Object converterObj = this.evalExpression(target, expr);
        if (converterObj instanceof Converter) {
            converter = (Converter)converterObj;
        } else if (converterObj instanceof String) {
            String converterName = (String)converterObj;
            converter = this._converters.get(converterName);
            if (converter == null) {
                converter = SystemConverters.get((String)converterName);
            }
            if (converter == null) {
                throw new UiException("Cannot find converter: " + converterName);
            }
        } else {
            throw new ClassCastException("result of expression '" + expr + "' is not a Converter, is " + String.valueOf(converterObj));
        }
        return converter;
    }

    protected BindContext prepareConverterContext(Component target, Map<String, Object> paramsFromClient) {
        final HashMap<String, Object> converterArgs = new HashMap<String, Object>();
        Iterator<Map.Entry<String, Object>> iterator = paramsFromClient.entrySet().iterator();
        while (iterator.hasNext()) {
            Object value;
            Map.Entry<String, Object> paramExpr;
            converterArgs.put(paramExpr.getKey(), (value = (paramExpr = iterator.next()).getValue()) instanceof String ? this.evalExpression(target, (String)value) : value);
        }
        return new BindContextImpl(null, null, false, null, target, null){

            public Map<String, Object> getConverterArgs() {
                return converterArgs;
            }

            public Object getConverterArg(String key) {
                return converterArgs.get(key);
            }
        };
    }

    protected Object doConvertCoerceToBean(Object origin, Component comp, String converterExpr, Map<String, Object> coverterParams) {
        Object value = origin;
        if (converterExpr != null) {
            Converter converter = this.findConverter(comp, converterExpr);
            value = converter.coerceToBean(origin, comp, this.prepareConverterContext(comp, coverterParams));
        }
        return value;
    }

    protected Object coerceToBeanProp(Object bean, String prop, Object value) {
        boolean hasConverted = false;
        if (value != null) {
            Method method;
            Method[] methods = ReflectionUtil.getSetter(bean.getClass(), (String)prop);
            Method method2 = method = methods.length > 0 ? methods[0] : null;
            if (method != null) {
                Class<?> targetClz;
                Type[] genericParameterTypes = method.getGenericParameterTypes();
                if (genericParameterTypes != null && genericParameterTypes.length > 0) {
                    Type genericParameterType = genericParameterTypes[0];
                    if (genericParameterType instanceof ParameterizedType && !value.getClass().isAssignableFrom(genericParameterType.getClass()) && !((Class)((ParameterizedType)genericParameterType).getRawType()).isAssignableFrom(value.getClass())) {
                        value = ObjectMappers.convert(this, value, (ParameterizedType)genericParameterType);
                        hasConverted = true;
                    }
                } else {
                    targetClz = method.getParameterTypes()[0];
                    if (!value.getClass().isAssignableFrom(targetClz)) {
                        value = ObjectMappers.convert(value, targetClz);
                        hasConverted = true;
                    }
                }
                if (!hasConverted) {
                    targetClz = method.getParameterTypes()[0];
                    if (!value.getClass().isAssignableFrom(targetClz) && !targetClz.isAssignableFrom(value.getClass())) {
                        value = ObjectMappers.convert(value, targetClz);
                    }
                }
            }
        }
        return value;
    }

    protected boolean doValidate(Map<String, Object> validatorData, Map<String, Object> validatorProperty, Object bean, Component comp, String prop, Object value) {
        JSONArray clientProperties = (JSONArray)validatorProperty.get("properties");
        HashSet<Property> properties = new HashSet<Property>();
        if (clientProperties != null) {
            for (Object clientProperty : clientProperties) {
                JSONObject clientProp = (JSONObject)clientProperty;
                Object propBean = this.getCachedBeanById((String)clientProp.get((Object)BEAN_UID));
                String propStr = (String)clientProp.get((Object)"prop");
                Object finalValue = this.coerceToBeanProp(propBean, propStr, clientProp.get((Object)VALUE_ANNO_ATTR));
                properties.add((Property)new PropertyImpl(propBean, propStr, finalValue));
            }
        }
        try {
            Class<?> returnType;
            AccessibleObject accessibleObject = Classes.getAccessibleObject(bean.getClass(), (String)prop, (Class[])new Class[0], (int)4);
            if (accessibleObject instanceof Method && !(returnType = ((Method)accessibleObject).getReturnType()).isInstance(value)) {
                value = ObjectMappers.convert(value, returnType);
            }
        }
        catch (NoSuchMethodException accessibleObject) {
            // empty catch block
        }
        String field = (String)validatorProperty.get("field");
        return this._binder.doValidate(comp, new ClientSavePropertyBindingImpl(this._binder, comp, field, (Property)new PropertyImpl(bean, prop, value), (String)((List)validatorData.remove(VALUE_ANNO_ATTR)).get(0), validatorData, properties), true);
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(value);
    }

    public void notifyDependsOn(Object bean, String beanUid, String prop) {
        String key;
        if (beanUid == null) {
            beanUid = this.getBeanUid(bean);
        }
        Map<String, Set<String>> dependsOnInfo = this.dependsOnMap.get(beanUid);
        Execution exec = Executions.getCurrent();
        HashSet<CallSite> dependsOnHandled = (HashSet<CallSite>)exec.getAttribute(key = "org.zkoss.clientbind.bind.dependson");
        if (dependsOnHandled == null) {
            dependsOnHandled = new HashSet<CallSite>(1);
            exec.setAttribute(key, dependsOnHandled);
        } else if (dependsOnHandled.contains(beanUid + "$" + prop)) {
            return;
        }
        if (dependsOnInfo != null) {
            Set<Object> infoSet = null;
            if (".".equals(prop) || "*".equals(prop)) {
                infoSet = new HashSet();
                for (Map.Entry<String, Set<String>> entry : dependsOnInfo.entrySet()) {
                    infoSet.addAll((Collection<Object>)entry.getValue());
                }
            } else {
                infoSet = dependsOnInfo.get(prop);
            }
            if (infoSet != null) {
                for (String string : infoSet) {
                    this._binder.notifyChange(bean, string);
                    dependsOnHandled.add((CallSite)((Object)(beanUid + "$" + string)));
                }
            }
        }
    }

    public Object getPartialFromModel(Object model, int offset) {
        ListModel listModel = this.modelToListModel.get(model);
        if (listModel != null) {
            return this.getPartialFromListModel(listModel, offset).getX();
        }
        Integer rodSize = this.modelRodSizeMap.get(model);
        if (rodSize != null && model instanceof Collection) {
            Collection collection = model;
            int size = collection.size();
            int limit = offset + rodSize;
            if (limit > size) {
                limit = size;
            }
            AbstractCollection partialData = null;
            partialData = model instanceof List ? new LinkedList() : (model instanceof Set ? new LinkedHashSet() : new ArrayList());
            Iterator iterator = collection.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (index < offset) {
                    ++index;
                    continue;
                }
                if (index >= limit) break;
                ++index;
                partialData.add(next);
            }
            model = partialData;
        }
        return model;
    }

    public Pair<List, Set> getPartialFromListModel(ListModel<?> model, int offset) {
        int limit;
        Integer rodSize = this.modelRodSizeMap.get(model);
        int size = model.getSize();
        int n = limit = rodSize != null ? offset + rodSize : size;
        if (limit > size) {
            limit = size;
        }
        ArrayList<Object> partialData = new ArrayList<Object>();
        for (int i = offset; i < limit; ++i) {
            partialData.add(model.getElementAt(i));
        }
        Set selection = null;
        if (model instanceof Selectable) {
            Selectable selectableModel = (Selectable)model;
            selection = selectableModel.getSelection();
        }
        return new Pair(partialData, selection);
    }

    public static String getGroupsInfoValueStringFromModel(GroupsListModel groupsListModel) {
        return ClientBindComposer.getGroupsInfoValueStringFromModel(groupsListModel, 0, groupsListModel.getSize() - 1, true);
    }

    public static String getGroupsInfoValueStringFromModel(GroupsListModel groupsListModel, int startIndex, int endIndex, boolean adjustIndex) {
        int[] info;
        StringBuilder sb = new StringBuilder();
        GroupsModel groupsModel = groupsListModel.getGroupsModel();
        List groupsInfos = groupsListModel.getGroupsInfos();
        int groupIndex = 0;
        Iterator iterator = groupsInfos.iterator();
        while (iterator.hasNext() && (info = (int[])iterator.next())[0] <= endIndex) {
            int reIndex;
            if (info[0] >= startIndex) {
                reIndex = adjustIndex ? info[0] - startIndex : info[0];
                sb.append("$").append(reIndex).append("$$open$:\"").append(groupsModel.isGroupOpened(groupIndex)).append("\",");
                sb.append("$").append(reIndex).append("$:\"").append("model:group\",");
            }
            if (groupsModel.hasGroupfoot(groupIndex) && info[2] >= startIndex && info[2] <= endIndex) {
                reIndex = adjustIndex ? info[2] - startIndex : info[2];
                sb.append("$").append(reIndex).append("$:\"").append("model:groupfoot\",");
            }
            ++groupIndex;
        }
        return sb.toString();
    }

    public Object getCachedBeanById(String id) {
        return this.idMappings.get(id);
    }

    public void setCachedBeanById(String id, Object data) {
        this.idMappings.put(id, data);
    }

    protected Object getCachedFormBeanById(String id) {
        return this.formIdMappings != null ? this.formIdMappings.get(id) : null;
    }

    protected void setCachedFormBeanById(String id, Object data) {
        if (this.formIdMappings != null) {
            this.formIdMappings.put(id, data);
        }
    }

    protected void clearCachedFormBeans() {
        this.formIdMappings = null;
    }

    protected void initCachedFormBeans() {
        this.formIdMappings = new HashMap<String, Object>();
    }

    public String getBeanUid(Object bean) {
        boolean isForm = bean instanceof FormProxyObject;
        int hashCode = System.identityHashCode(isForm ? ((FormProxyObject)bean).getOriginObject() : bean);
        String uid = ClientBindComposer.numToAbc(hashCode) + "_" + Integer.toUnsignedString(hashCode, 36);
        if (isForm) {
            uid = uid + "$$";
        }
        return uid;
    }

    private static String numToAbc(int num) {
        LinkedList<String> sb = new LinkedList<String>();
        for (long unsigned = Integer.toUnsignedLong(num); unsigned >= 0L; --unsigned) {
            long j = unsigned % 26L + 65L;
            sb.addFirst(String.valueOf((char)j));
            unsigned /= 26L;
        }
        return String.join((CharSequence)"", sb);
    }

    private static void initListboxRODProperties(Map<String, Object> properties, int topPad, int rodSize) {
        properties.put("_topPad", topPad);
        properties.put("_offset", 0);
        properties.put("_listbox$rod", true);
        properties.put("initRodSize", rodSize);
    }

    private static void initGridRODProperties(Map<String, Object> properties, int topPad, int rodSize) {
        properties.put("_topPad", topPad);
        properties.put("_offset", 0);
        properties.put("_grid$rod", true);
        properties.put("initRodSize", rodSize);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.objectMapper = ObjectMappers.createGetterObjectMapper(this);
    }

    public void didActivate(Component comp) {
        Selectors.rewireVariablesOnActivate((Component)comp, (Object)this.getViewModel(), (List)Selectors.newVariableResolvers((Class)BindUtils.getViewModelClass((Object)this.viewModel), null));
        for (Map.Entry<Object, ListModel> entry : this.modelToListModel.entrySet()) {
            List listDataListeners = entry.getValue().getListDataListeners();
            for (ListDataListener listener : listDataListeners) {
                if (!(listener instanceof ComponentActivationListener)) continue;
                ((ComponentActivationListener)listener).didActivate(comp);
            }
        }
        for (Map.Entry<Object, ListModel> entry : this.modelToTreeModel.entrySet()) {
            List treeDataListeners = ((TreeModel)entry.getValue()).getTreeDataListeners();
            for (ListDataListener listener : treeDataListeners) {
                if (!(listener instanceof ComponentActivationListener)) continue;
                ((ComponentActivationListener)listener).didActivate(comp);
            }
        }
    }

    public void willPassivate(Component comp) {
        for (Map.Entry<Object, ListModel> entry : this.modelToListModel.entrySet()) {
            List listDataListeners = entry.getValue().getListDataListeners();
            for (ListDataListener listener : listDataListeners) {
                if (!(listener instanceof ComponentActivationListener)) continue;
                ((ComponentActivationListener)listener).willPassivate(comp);
            }
        }
        for (Map.Entry<Object, ListModel> entry : this.modelToTreeModel.entrySet()) {
            List treeDataListeners = ((TreeModel)entry.getValue()).getTreeDataListeners();
            for (ListDataListener listener : treeDataListeners) {
                if (!(listener instanceof ComponentActivationListener)) continue;
                ((ComponentActivationListener)listener).willPassivate(comp);
            }
        }
    }

    private static class ComponentBindInfo
    implements Serializable {
        final Map<String, Object> allBindings;
        final Map<String, String[]> converterInfo;
        final String expression;

        public ComponentBindInfo(Map<String, Object> allBindings, Map<String, String[]> converterInfo, String expression) {
            this.allBindings = allBindings;
            this.converterInfo = converterInfo;
            this.expression = expression;
        }
    }
}

