/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Strings;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelMap;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.event.PagingListener;
import org.zkoss.zul.ext.Pageable;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.impl.GroupsListModel;

class ListModelPagingListener
implements PagingListener {
    private ClientBindComposer composer;
    private Component component;
    private String expr;
    private Paginal paginal;

    ListModelPagingListener(ClientBindComposer composer, Component component, String expr, Paginal paginal) {
        this.composer = composer;
        this.component = component;
        this.expr = expr;
        this.paginal = paginal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListModelPagingListener that = (ListModelPagingListener)o;
        return Objects.equals(this.composer, that.composer) && Objects.equals(this.component, that.component) && Objects.equals(this.expr, that.expr) && Objects.equals(this.paginal, that.paginal);
    }

    public int hashCode() {
        return Objects.hash(this.composer, this.component, this.expr, this.paginal);
    }

    public void onEvent(Event event) throws Exception {
        if (this.composer.view.hasAttribute("$DISABLE_CLIENT_UPDATE$")) {
            return;
        }
        ListModel listModel = this.composer.modelToListModel.get(this.composer.getModelFromComponent(this.component));
        if (event instanceof PagingEvent) {
            String vmExprPrefix;
            String prop;
            int i;
            Cloneable selections;
            Cloneable elements;
            PagingEvent pagingEvent = (PagingEvent)event;
            int pgsz = pagingEvent.getPageable().getPageSize();
            int actpg = pagingEvent.getActivePage();
            if ("internalModelEvent".equals(pagingEvent.getName())) {
                if (pgsz > 0) {
                    this.paginal.setPageSize(pgsz);
                }
                if (actpg >= 0) {
                    this.paginal.setActivePage(actpg);
                }
            } else if (listModel instanceof Pageable) {
                ((Pageable)listModel).setActivePage(actpg);
            }
            int startIndex = this.paginal.getPageSize() * actpg;
            int endIndex = Math.min(startIndex + this.paginal.getPageSize(), listModel.getSize()) - 1;
            boolean selectable = listModel instanceof Selectable;
            if (listModel instanceof ListModelMap) {
                elements = new HashMap();
                selections = new HashMap();
                Cloneable elementsMap = elements;
                Cloneable selectionsMap = selections;
                for (i = startIndex; i <= endIndex; ++i) {
                    Map.Entry entry = (Map.Entry)listModel.getElementAt(i);
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    elementsMap.put(key, value);
                    if (!((ListModelMap)listModel).isSelected((Object)entry)) continue;
                    selectionsMap.put(key, value);
                }
            } else {
                elements = new ArrayList();
                selections = new ArrayList();
                ArrayList elementsList = (ArrayList)elements;
                ArrayList selectionsList = (ArrayList)selections;
                for (i = startIndex; i <= endIndex; ++i) {
                    Object element = listModel.getElementAt(i);
                    elementsList.add(element);
                    if (!selectable || !((Selectable)listModel).isSelected(element)) continue;
                    selectionsList.add(element);
                }
            }
            String groupInfoValueString = null;
            if (listModel instanceof GroupsListModel) {
                groupInfoValueString = ClientBindComposer.getGroupsInfoValueStringFromModel((GroupsListModel)listModel, startIndex, endIndex, true);
            }
            if ((prop = this.expr).startsWith(vmExprPrefix = String.valueOf(this.composer.view.getAttribute("$VM_ID$")) + ".")) {
                prop = prop.substring(vmExprPrefix.length());
            }
            Executions.getCurrent().setAttribute("$IGNORE_FIRST_LIST_ID$", (Object)true);
            Object result = this.composer.writeValueAsString(elements);
            if (!Strings.isEmpty((String)groupInfoValueString)) {
                result = "{" + groupInfoValueString + ((String)result).substring(1);
            }
            JavaScriptValue updatedListModel = new JavaScriptValue("{" + prop + ":" + (String)result + "}");
            String resKey = String.valueOf(this.hashCode());
            Clients.response((String)(resKey + "$lc"), (AuResponse)new AuInvoke(this.composer.view, "update@vm", new Object[]{prop, updatedListModel}));
            if (selectable) {
                Object selectionStrValue = "{\"$sel$\":";
                selectionStrValue = ((Selectable)listModel).getSelectionControl().isSelectAll() ? (String)selectionStrValue + "['$SELECT_ALL$']}" : (String)selectionStrValue + this.composer.writeValueAsString(selections) + "}";
                JavaScriptValue updatedSelection = new JavaScriptValue("{" + prop + ": " + (String)selectionStrValue + "}");
                Clients.response((String)(resKey + "$sel"), (AuResponse)new AuInvoke(this.composer.view, "update@vm", new Object[]{prop, updatedSelection}));
            }
        }
    }

    public Object willClone(Component comp) {
        return null;
    }
}

