/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind.ui.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.Immutable;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.clientbind.ui.util.ClientBeanPropertyWriter;
import org.zkoss.json.JSONValue;
import org.zkoss.util.Pair;

class ExtraFieldSerializer
extends BeanSerializerBase {
    ClientBindComposer owner;

    ExtraFieldSerializer(ExtraFieldSerializer source, ObjectIdWriter objectIdWriter) {
        super((BeanSerializerBase)source, objectIdWriter);
    }

    ExtraFieldSerializer(ExtraFieldSerializer source, Set<String> toIgnore, Set<String> toInclude) {
        super((BeanSerializerBase)source, toIgnore, toInclude);
    }

    ExtraFieldSerializer(ExtraFieldSerializer src, ObjectIdWriter objectIdWriter, Object filterId) {
        super((BeanSerializerBase)src, objectIdWriter, filterId);
    }

    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new ExtraFieldSerializer(this, objectIdWriter);
    }

    protected BeanSerializerBase withByNameInclusion(Set<String> toIgnore, Set<String> toInclude) {
        return new ExtraFieldSerializer(this, toIgnore, toInclude);
    }

    protected BeanSerializerBase asArraySerializer() {
        return new ExtraFieldSerializer(this);
    }

    public BeanSerializerBase withFilterId(Object filterId) {
        return new ExtraFieldSerializer(this, this._objectIdWriter, filterId);
    }

    protected BeanSerializerBase withProperties(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        return null;
    }

    ExtraFieldSerializer(BeanSerializerBase source) {
        super(source);
        BeanPropertyWriter[] props = this._props;
        for (int i = 0; i < props.length; ++i) {
            ClientBeanPropertyWriter modifiedWriter = new ClientBeanPropertyWriter(props[i]);
            modifiedWriter.owner = this.owner;
            this._props[i] = modifiedWriter;
        }
    }

    public void serialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        this.serializeFields(bean, jgen, provider);
        String encoded = this.owner.getBeanUid(bean);
        this.owner.setCachedBeanById(encoded, bean);
        jgen.writeStringField("$id$", encoded);
        if (bean.getClass().isAnnotationPresent(Immutable.class)) {
            jgen.writeBooleanField("$im$", true);
        }
        try {
            if (!(bean instanceof Pair)) {
                Method toString = bean.getClass().getDeclaredMethod("toString", new Class[0]);
                String result = JSONValue.toJSONString((Object)toString.invoke(bean, new Object[0]));
                jgen.writeFieldName("toString");
                jgen.writeRaw(": function() { return " + result + ";}");
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException toString) {
            // empty catch block
        }
        HashMap<String, HashSet<String>> dependsOnInfo = new HashMap<String, HashSet<String>>(1);
        for (BeanPropertyWriter prop : this._props) {
            DependsOn annotation;
            if (prop == null || (annotation = (DependsOn)prop.getAnnotation(DependsOn.class)) == null) continue;
            String[] targets = annotation.value();
            String propName = prop.getFullName().getSimpleName();
            for (String target : targets) {
                HashSet<String> info = (HashSet<String>)dependsOnInfo.get(target);
                if (info == null) {
                    info = new HashSet<String>();
                    dependsOnInfo.put(target, info);
                }
                info.add(propName);
            }
        }
        if (dependsOnInfo.size() > 0) {
            this.owner.dependsOnMap.put(encoded, dependsOnInfo);
        }
        jgen.writeEndObject();
    }
}

