/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import java.util.Map;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.clientbind.ListModelPagingListener;
import org.zkoss.clientbind.TreeModelPagingListener;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.PageableModel;
import org.zkoss.zul.Paging;
import org.zkoss.zul.event.PagingListener;

public class ProcessPagingModelCommand {
    private ClientBindComposer composer;
    private Component view;

    private ProcessPagingModelCommand(ClientBindComposer composer) {
        this.composer = composer;
        this.view = composer.view;
    }

    private boolean process(String command, Map<String, Object> data) {
        Map args = (Map)data.get("args");
        String modelUid = (String)args.get("model");
        String type = (String)args.get("type");
        Integer activePage = (Integer)args.get("activePage");
        Integer pageSize = (Integer)args.get("pageSize");
        Object cachedModel = this.composer.getCachedBeanById(modelUid);
        PageableModel model = null;
        if (cachedModel instanceof PageableModel) {
            model = (PageableModel)cachedModel;
        } else if ("list".equals(type)) {
            model = (PageableModel)this.composer.modelToListModel.get(cachedModel);
        } else if ("tree".equals(type)) {
            model = (PageableModel)this.composer.modelToTreeModel.get(cachedModel);
        }
        Paging paginal = (Paging)this.view.getDesktop().getComponentByUuidIfAny((String)args.get("paginal"));
        if (model != null && paginal != null) {
            if (activePage != null) {
                paginal.setActivePage(activePage.intValue());
            }
            if (pageSize != null) {
                paginal.setPageSize(pageSize.intValue());
            }
            for (EventListener eventListener : paginal.getEventListeners("onPaging")) {
                if (!(eventListener instanceof ListModelPagingListener) && !(eventListener instanceof TreeModelPagingListener)) continue;
                model.removePagingEventListener((PagingListener)eventListener);
                model.addPagingEventListener((PagingListener)eventListener);
                model.setActivePage(paginal.getActivePage());
                model.setPageSize(paginal.getPageSize());
                break;
            }
        }
        return true;
    }

    public static boolean processCommand(ClientBindComposer composer, String command, Map<String, Object> data) {
        return new ProcessPagingModelCommand(composer).process(command, data);
    }
}

