/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind.ui.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.json.JSONValue;
import org.zkoss.util.Pair;

class ExtraFieldUnknownSerializer
extends UnknownSerializer {
    ClientBindComposer owner;

    public ExtraFieldUnknownSerializer(Class<?> cls, ClientBindComposer owner) {
        super(cls);
        this.owner = owner;
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        String encoded = this.owner.getBeanUid(value);
        this.owner.setCachedBeanById(encoded, value);
        gen.writeStringField("$id$", encoded);
        try {
            if (!(value instanceof Pair)) {
                Method toString = value.getClass().getDeclaredMethod("toString", new Class[0]);
                String result = JSONValue.toJSONString((Object)toString.invoke(value, new Object[0]));
                gen.writeFieldName("toString");
                gen.writeRaw(": function() { return " + result + ";}");
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        gen.writeEndObject();
    }
}

