/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind.ui.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.ListModel;

class PartialCollectionSerializerProxyHandler
implements MethodHandler {
    private ClientBindComposer _owner;
    private JsonSerializer<?> _origin;

    public PartialCollectionSerializerProxyHandler(JsonSerializer<?> serializer, ClientBindComposer owner) {
        this._origin = serializer;
        this._owner = owner;
    }

    public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Exception {
        try {
            String mname = method.getName();
            if (mname.equals("serialize")) {
                if (args[0] instanceof ListModel) {
                    method.invoke(this._origin, args);
                } else {
                    JsonGenerator g = (JsonGenerator)args[1];
                    Collection value = (Collection)args[0];
                    int totalSize = value.size();
                    g.writeStartObject();
                    if (Executions.getCurrent().removeAttribute("$IGNORE_FIRST_LIST_ID$") == null) {
                        String encoded = this._owner.getBeanUid(value);
                        this._owner.setCachedBeanById(encoded, value);
                        g.writeStringField("$id$", encoded);
                    }
                    g.writeFieldName("$lc$");
                    g.writeStartArray();
                    boolean isSet = args[0] instanceof Set;
                    args[0] = this._owner.getPartialFromModel(args[0], 0);
                    value = (Collection)args[0];
                    for (Object data : value) {
                        if (data instanceof Map.Entry) {
                            g.writeStartObject();
                            Map.Entry me = (Map.Entry)data;
                            g.writeStringField("key", String.valueOf(me.getKey()));
                            g.writeObjectField("value", me.getValue());
                            g.writeEndObject();
                            continue;
                        }
                        g.writeObject(data);
                    }
                    g.writeEndArray();
                    if (isSet) {
                        g.writeStringField("$set$", "true");
                    }
                    if (totalSize > ((Collection)args[0]).size()) {
                        g.writeNumberField("$ts$", totalSize);
                    }
                    g.writeEndObject();
                }
                return null;
            }
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
        return method.invoke(this._origin, args);
    }
}

