/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindComposer;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.bind.annotation.NotifyChangeDisabled;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BinderUtil;
import org.zkoss.bind.impl.SimpleBindXelContext;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.clientbind.ClientBinder;
import org.zkoss.clientbind.ui.sys.HtmlTemplateRenders;
import org.zkoss.clientbind.ui.util.ObjectMappers;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.xel.ExpressionX;
import org.zkoss.xel.ValueReference;
import org.zkoss.xel.XelContext;
import org.zkoss.zel.impl.util.ReflectionUtil;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.HtmlShadowElement;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.PropertiesRenderer;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zuti.zul.Apply;

public class BinderPropertiesRenderer
implements PropertiesRenderer {
    private static final Logger log = LoggerFactory.getLogger(BinderPropertiesRenderer.class);
    private static final String TEMPLATES_INFO = "'templatesInfo'";
    private static final String AT_DEPEND_PACKAGES = "'@dependPkgs'";

    public void renderProperties(Component component, ContentRenderer contentRenderer) throws IOException {
        Composer composer = Components.getComposer((Component)component);
        if (composer instanceof ClientBindComposer) {
            ClientBindComposer cbc = (ClientBindComposer)composer;
            cbc.renderProperties(contentRenderer);
            this.processComponentBindings(component, contentRenderer);
        } else if (!(composer instanceof BindComposer)) {
            boolean preparedClientBindings = component.hasAttribute("$CLIENT_BINDINGS$");
            boolean processClientBindings = preparedClientBindings;
            if (!processClientBindings && composer == null) {
                for (Component parent = component.getParent(); parent != null; parent = parent.getParent()) {
                    Composer parentComposer = Components.getComposer((Component)parent);
                    if (parentComposer instanceof ClientBindComposer) {
                        if (!preparedClientBindings) {
                            ((ClientBindComposer)parentComposer).traverseComponentBindings(component);
                        }
                        processClientBindings = true;
                        break;
                    }
                    if (parentComposer instanceof BindComposer) break;
                }
            }
            if (processClientBindings) {
                this.processComponentBindings(component, contentRenderer);
            }
        }
    }

    private void processComponentBindings(Component comp, ContentRenderer contentRenderer) throws IOException {
        Map attributes;
        Map forwards;
        Map preparedBindings = (Map)comp.getAttribute("$CLIENT_BINDINGS$");
        if (preparedBindings != null) {
            for (Map.Entry me : preparedBindings.entrySet()) {
                String key = (String)me.getKey();
                if ("@load".equals(key)) {
                    this.processPropertyLoad(comp.getClass(), (Map)me.getValue());
                } else if ("@save".equals(key)) {
                    for (Map.Entry mme : ((Map)me.getValue()).entrySet()) {
                        Map map = (Map)((List)mme.getValue()).get(0);
                        ClientBinder _binder = (ClientBinder)BinderUtil.getBinder((Component)comp, (boolean)true);
                        BindContext bindContext = BindContextUtil.newBindContext((Binder)_binder, null, (boolean)false, null, (Component)_binder.getView(), null);
                        ExpressionX expressionX = _binder.getEvaluatorX().parseExpressionX(null, ((String[])map.get("value"))[0], Object.class);
                        try {
                            ValueReference valueReference = expressionX.getValueReference((XelContext)new SimpleBindXelContext(comp, (Binder)_binder, null, null));
                            Object base = valueReference.getBase();
                            Method[] methods = ReflectionUtil.getSetter(base.getClass(), (String)((String)valueReference.getProperty()));
                            if (methods == null) continue;
                            if (methods[0].getAnnotation(NotifyChangeDisabled.class) != null) {
                                map.put("NotifyChange", Boolean.FALSE);
                                continue;
                            }
                            if (methods[0].getAnnotation(NotifyChange.class) == null) continue;
                            map.put("NotifyChange", Boolean.TRUE);
                        }
                        catch (Exception exception) {}
                    }
                } else if ("@command".equals(key)) {
                    for (Map.Entry mme : ((Map)me.getValue()).entrySet()) {
                        if (!"onFulfill".equals(mme.getKey())) continue;
                        comp.addEventListener("onFulfill", event -> {
                            Composer composer = null;
                            for (Component parent = comp; parent != null && !((composer = Components.getComposer((Component)parent)) instanceof ClientBindComposer); parent = parent.getParent()) {
                            }
                            if (composer instanceof ClientBindComposer) {
                                for (Component kid : comp.getChildren()) {
                                    if (kid.hasAttribute("$BINDER_ID$")) continue;
                                    ((ClientBindComposer)composer).traverseComponentBindings(kid);
                                }
                            }
                            Clients.response((AuResponse)new AuInvoke(comp, "fire", (Object)"onFulfill"));
                        });
                    }
                }
                contentRenderer.render("'" + (String)key + "'", me.getValue());
            }
        }
        if (!(forwards = ((ComponentCtrl)comp).getForwards()).isEmpty()) {
            JSONObject json = new JSONObject();
            for (Map.Entry entry : forwards.entrySet()) {
                AbstractComponent.ForwardInfo forwardInfo = (AbstractComponent.ForwardInfo)entry.getValue();
                List targets = forwardInfo.getTargets();
                json.put(entry.getKey(), targets.stream().map(targetInfo -> {
                    Object target = targetInfo.getTarget();
                    if (target instanceof Component) {
                        Map commandList;
                        JSONObject object = new JSONObject();
                        Component targetComponent = (Component)target;
                        Map targetBindings = (Map)targetComponent.getAttribute("$CLIENT_BINDINGS$");
                        if (targetBindings != null && targetBindings.containsKey("@command") && (commandList = (Map)targetBindings.get("@command")).containsKey(targetInfo.getEvent())) {
                            object.put((Object)targetComponent.getId(), (Object)targetInfo.getEvent());
                        }
                        if (!object.isEmpty()) {
                            return object;
                        }
                        return null;
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            contentRenderer.render("'@forwards'", (Object)json);
        }
        if (!(attributes = comp.getAttributes(0)).isEmpty()) {
            JSONObject jsonObject = new JSONObject();
            for (Map.Entry me : attributes.entrySet()) {
                Object value = me.getValue();
                if (!(value instanceof String) && !(value instanceof Boolean) && !(value instanceof Number)) continue;
                jsonObject.put(me.getKey(), me.getValue());
            }
            if (!jsonObject.isEmpty()) {
                contentRenderer.render("attributes", (Object)jsonObject);
            }
        }
        this.collectTemplates(comp, contentRenderer);
        this.processShadowComponentBindings(comp, contentRenderer);
    }

    private void processShadowComponentBindings(Component comp, ContentRenderer contentRenderer) throws IOException {
        if (comp instanceof ComponentCtrl) {
            LinkedList shadowInfos = new LinkedList();
            for (ShadowElement shadowElement : ((ComponentCtrl)comp).getShadowRoots()) {
                Component shadowComp = (Component)shadowElement;
                LinkedList<Object> shadowInfo = new LinkedList<Object>();
                shadowInfo.add("clientbind." + shadowComp.getClass().getSimpleName() + "Info");
                LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                Map preparedBindings = (Map)shadowComp.getAttribute("$CLIENT_BINDINGS$");
                if (preparedBindings != null) {
                    for (Map.Entry me : preparedBindings.entrySet()) {
                        String key = (String)me.getKey();
                        if ("@load".equals(key)) {
                            this.processPropertyLoad(shadowElement.getClass(), (Map)me.getValue());
                        }
                        properties.put(key, me.getValue());
                    }
                }
                try {
                    properties.put("uuid", shadowComp.getUuid());
                    Field shadowPropertiesField = shadowComp.getClass().getDeclaredField("_properties");
                    shadowPropertiesField.setAccessible(true);
                    HashMap shadowProperties = (HashMap)shadowPropertiesField.get(shadowComp);
                    for (Map.Entry entry : shadowProperties.entrySet()) {
                        properties.put((String)entry.getKey(), ((PropertyAccess)entry.getValue()).getValue(shadowComp));
                    }
                    shadowPropertiesField.setAccessible(false);
                    if (shadowComp instanceof Apply) {
                        Field props = shadowComp.getClass().getDeclaredField("_props");
                        props.setAccessible(true);
                        HashMap hashMap = (HashMap)props.get(shadowComp);
                        for (Map.Entry prop : hashMap.entrySet()) {
                            if (properties.containsKey(prop.getKey())) continue;
                            properties.put((String)prop.getKey(), prop.getValue());
                        }
                        props.setAccessible(false);
                    }
                }
                catch (Exception e) {
                    log.debug(e.getMessage());
                }
                Component previousInsertion = ((HtmlShadowElement)shadowElement).getPreviousInsertion();
                properties.put("previousInsertion", previousInsertion != null ? previousInsertion.getUuid() : null);
                Component nextInsertion = ((HtmlShadowElement)shadowElement).getNextInsertion();
                properties.put("nextInsertion", nextInsertion != null ? nextInsertion.getUuid() : null);
                shadowInfo.add(properties);
                List<JavaScriptValue> collect = this.collectTemplates(shadowComp, null);
                if (!collect.isEmpty()) {
                    shadowInfo.add(collect);
                }
                shadowInfos.add(shadowInfo);
            }
            if (!shadowInfos.isEmpty()) {
                contentRenderer.render("'@shadowElements'", shadowInfos);
            }
        }
    }

    private List<JavaScriptValue> collectTemplates(Component comp, ContentRenderer contentRenderer) throws IOException {
        Set templateNames = comp.getTemplateNames();
        HashSet dependPkgs = new HashSet();
        List<JavaScriptValue> collect = templateNames.stream().map(name -> {
            Template template = comp.getTemplate(name);
            return new JavaScriptValue(HtmlTemplateRenders.renderTemplate(template, comp, dependPkgs));
        }).collect(Collectors.toList());
        if (!collect.isEmpty() && contentRenderer != null) {
            contentRenderer.render(TEMPLATES_INFO, collect);
            contentRenderer.render(AT_DEPEND_PACKAGES, (Object)new JavaScriptValue(JSONValue.toJSONString(dependPkgs)));
        }
        return collect;
    }

    private void processPropertyLoad(Class<?> compClz, Map<String, List<Map>> loadBindingInfo) {
        for (Map.Entry<String, List<Map>> mme : loadBindingInfo.entrySet()) {
            List<Map> mmeValue = mme.getValue();
            boolean isPropertyLoadStringType = ObjectMappers.isPropertyLoadStringType(compClz, mme.getKey());
            for (Map loadBindingAnno : mmeValue) {
                if (loadBindingAnno.containsKey("LOAD_TYPE") || !isPropertyLoadStringType) continue;
                loadBindingAnno.put("LOAD_TYPE", new String[]{"java.lang.String"});
            }
        }
    }
}

