/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindComposer;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Form;
import org.zkoss.bind.GlobalCommandEvent;
import org.zkoss.bind.PhaseListener;
import org.zkoss.bind.Property;
import org.zkoss.bind.PropertyChangeEvent;
import org.zkoss.bind.ValidationContext;
import org.zkoss.bind.Validator;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.DefaultCommand;
import org.zkoss.bind.annotation.DefaultGlobalCommand;
import org.zkoss.bind.annotation.Destroy;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Immutable;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.MatchMedia;
import org.zkoss.bind.annotation.NotifyCommand;
import org.zkoss.bind.annotation.NotifyCommands;
import org.zkoss.bind.annotation.SmartNotifyChange;
import org.zkoss.bind.annotation.ToClientCommand;
import org.zkoss.bind.impl.AbstractAnnotatedMethodInvoker;
import org.zkoss.bind.impl.AllocUtil;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.BinderUtil;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.bind.impl.ParamCall;
import org.zkoss.bind.impl.PropertyImpl;
import org.zkoss.bind.impl.SystemConverters;
import org.zkoss.bind.impl.SystemValidators;
import org.zkoss.bind.impl.ValidationContextImpl;
import org.zkoss.bind.init.ViewModelAnnotationResolvers;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.ViewModelProxyObject;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.SaveBinding;
import org.zkoss.bind.sys.SaveFormBinding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.bind.sys.TemplateResolver;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.bind.sys.debugger.BindingAnnotationInfoChecker;
import org.zkoss.bind.sys.debugger.BindingExecutionInfoCollector;
import org.zkoss.bind.sys.tracker.Tracker;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.clientbind.ClientBinder;
import org.zkoss.clientbind.ClientBinderResolver;
import org.zkoss.clientbind.ClientSavePropertyBindingImpl;
import org.zkoss.clientbind.ParamCallEx;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.util.CacheMap;
import org.zkoss.util.EmptyCacheMap;
import org.zkoss.xel.ExpressionX;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.event.ClientInfoEvent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zkmax.ui.event.PortalDropEvent;

class ClientBinderImpl
implements ClientBinder {
    private static final Logger _log = LoggerFactory.getLogger(ClientBinderImpl.class);
    private static final String ON_POST_COMMAND = "onPostCommand";
    private static final String ON_VMSGS_CHANGED = "onVMsgsChanged";
    private static final String ACTIVATOR = "$ACTIVATOR$";
    private static final String DISABLE_METHOD_CACHE_PROP = "org.zkoss.bind.disableMethodCache";
    public static final boolean DISABLE_METHOD_CACHE = Boolean.parseBoolean(Library.getProperty((String)"org.zkoss.bind.disableMethodCache", (String)"false"));
    private static final Map<Class<?>, List<Method>> _initMethodCache = DISABLE_METHOD_CACHE ? new EmptyCacheMap() : new CacheMap(600, 1800000);
    private static final Map<Class<?>, List<Method>> _destroyMethodCache = DISABLE_METHOD_CACHE ? new EmptyCacheMap() : new CacheMap(600, 1800000);
    private static final Map<Class<?>, Map<String, CachedItem<Method>>> _commandMethodCache = DISABLE_METHOD_CACHE ? new EmptyCacheMap() : new CacheMap(200, 1800000);
    private static final Map<Class<?>, Map<String, CachedItem<Method>>> _globalCommandMethodCache = DISABLE_METHOD_CACHE ? new EmptyCacheMap() : new CacheMap(200, 1800000);
    private static final CachedItem<Method> NULL_METHOD = new CachedItem<Object>(null);
    private static final String COMMAND_METHOD_MAP_INIT = "$INIT_FLAG$";
    private static final String COMMAND_METHOD_DEFAULT = "$DEFAULT_FLAG$";
    private static final CommandMethodInfoProvider _commandMethodInfoProvider = new CommandMethodInfoProvider(){

        @Override
        public String getAnnotationName() {
            return Command.class.getSimpleName();
        }

        @Override
        public String getDefaultAnnotationName() {
            return DefaultCommand.class.getSimpleName();
        }

        @Override
        public String[] getCommandName(Method method) {
            Command cmd = (Command)ViewModelAnnotationResolvers.getAnnotation((Method)method, Command.class);
            return cmd == null ? null : cmd.value();
        }

        @Override
        public boolean isDefaultMethod(Method method) {
            return ViewModelAnnotationResolvers.getAnnotation((Method)method, DefaultCommand.class) != null;
        }
    };
    private static final CommandMethodInfoProvider _globalCommandMethodInfoProvider = new CommandMethodInfoProvider(){

        @Override
        public String getAnnotationName() {
            return GlobalCommand.class.getSimpleName();
        }

        @Override
        public String getDefaultAnnotationName() {
            return DefaultGlobalCommand.class.getSimpleName();
        }

        @Override
        public String[] getCommandName(Method method) {
            GlobalCommand cmd = (GlobalCommand)ViewModelAnnotationResolvers.getAnnotation((Method)method, GlobalCommand.class);
            return cmd == null ? null : cmd.value();
        }

        @Override
        public boolean isDefaultMethod(Method method) {
            return ViewModelAnnotationResolvers.getAnnotation((Method)method, DefaultGlobalCommand.class) != null;
        }
    };
    private BindEvaluatorX _eval;
    private final Component _dummyTarget = new AbstractComponent();
    private final String _quename;
    private final String _quescope;
    private final QueueListener _queueListener;
    private Component _view;
    private ValidationMessages _validationMessages;
    private boolean _hasGetConverterMethod = true;
    private boolean _hasGetValidatorMethod = true;
    private boolean _init = false;
    private transient Map<String, Method> _matchMediaValues;
    private static final Pattern CALL_OTHER_VM_COMMAND_PATTERN = Pattern.compile("\\$([^.]*)\\..*$");
    private transient Map<String, NotifyCommand> _notifyCommands;

    public ClientBinderImpl() {
        this(null, null);
    }

    public ClientBinderImpl(String qname, String qscope) {
        this._quename = qname != null && !Strings.isEmpty((String)qname) ? qname : "$ZKBIND_DEFQUE$";
        this._quescope = qscope != null && !Strings.isBlank((String)qscope) ? qscope : "desktop";
        this._queueListener = new QueueListener();
    }

    public void init(Component component, Object viewModel) {
        this.init(component, viewModel, null);
    }

    public void init(Component component, Object viewModel, Map<String, Object> initArgs) {
        if (this._init) {
            throw new UiException("binder is already initialized");
        }
        this._init = true;
        this._view = component;
        this.setViewModel(viewModel);
        this._dummyTarget.addEventListener(ON_POST_COMMAND, (EventListener)new PostCommandListener());
        this._dummyTarget.addEventListener(ON_VMSGS_CHANGED, (EventListener)new VMsgsChangedListener());
        this.initQueue();
        BinderUtil.markHandling((Component)component, (Binder)this);
        if (viewModel instanceof Composer && !(viewModel instanceof BindComposer)) {
            _log.warn("you are using a composer [{}] as a view model", viewModel);
        }
        new AbstractAnnotatedMethodInvoker<Init>(Init.class, _initMethodCache){

            protected boolean shouldLookupSuperclass(Init annotation) {
                return annotation.superclass();
            }
        }.invokeMethod((Binder)this, initArgs);
        this._matchMediaValues = this.initMatchMediaValues(viewModel);
        if (!this._matchMediaValues.isEmpty()) {
            Clients.response((AuResponse)new AuInvoke(this._view, "$binder"));
            Execution exec = Executions.getCurrent();
            if (exec != null) {
                Cookie[] cookies = ((HttpServletRequest)Executions.getCurrent().getNativeRequest()).getCookies();
                String[] matchMedias = null;
                JSONObject args = new JSONObject();
                if (cookies != null) {
                    for (Cookie c : cookies) {
                        String name = c.getName();
                        String value = c.getValue();
                        if (!name.matches("\\w*")) {
                            _log.error("Invalid cookie name: " + name);
                            continue;
                        }
                        try {
                            value = URLDecoder.decode(value, StandardCharsets.UTF_8.name());
                        }
                        catch (UnsupportedEncodingException e) {
                            _log.error("Failed to decode cookie " + name, (Throwable)e);
                            continue;
                        }
                        if ("ZKMatchMedia".equals(name)) {
                            matchMedias = value.trim().split(",");
                        } else if ("ZKClientInfo".equals(name)) {
                            args.put((Object)"$ZKCLIENTINFO$", JSONValue.parse((String)value));
                        }
                        if (matchMedias == null || args.size() == 0) continue;
                        if (matchMedias[0].isEmpty()) break;
                        for (String s : matchMedias) {
                            if (!this._matchMediaValues.containsKey(s)) continue;
                            Event evt = new Event(ON_POST_COMMAND, this._dummyTarget, (Object)new Object[]{s, args});
                            Events.postEvent((int)-1, (Event)evt);
                        }
                        break;
                    }
                }
            }
        }
    }

    protected void fireNotifyChanges(Set<Property> notifys) {
        for (Property prop : notifys) {
            this.notifyChange(prop.getBase(), prop.getProperty());
        }
    }

    public void postCommand(String command, Map<String, Object> args) {
        this.checkInit();
        Event evt = new Event(ON_POST_COMMAND, this._dummyTarget, (Object)new Object[]{command, args});
        Events.postEvent((Event)evt);
    }

    private void doGlobalCommand(Component comp, String command, Map<String, Object> commandArgs, Set<Property> notifys) {
        if (_log.isDebugEnabled()) {
            _log.debug("Start doGlobalCommand comp=[{}],command=[{}]", (Object)comp, (Object)command);
        }
        BindContext ctx = BindContextUtil.newBindContext((Binder)this, null, (boolean)false, (String)command, (Component)comp, null);
        BindContextUtil.setCommandArgs((Binder)this, (Component)comp, (BindContext)ctx, commandArgs);
        this.doGlobalCommandExecute(comp, command, commandArgs, ctx, notifys);
    }

    private void doGlobalCommandExecute(Component comp, String command, Map<String, Object> commandArgs, BindContext ctx, Set<Property> notifys) {
        Object viewModel;
        Method method;
        if (_log.isDebugEnabled()) {
            _log.debug("before doGlobalCommandExecute comp=[{}],command=[{}]", (Object)comp, (Object)command);
        }
        if ((method = this.getCommandMethod(BindUtils.getViewModelClass((Object)(viewModel = this.getViewModelInView())), command, _globalCommandMethodInfoProvider, _globalCommandMethodCache, commandArgs != null ? commandArgs.size() : 0, true)) != null) {
            ParamCallEx parCall = this.createParamCall(ctx);
            if (commandArgs != null) {
                parCall.setBindingArgs(commandArgs);
            }
            ClientBinderImpl.handleNotifyChange(ctx, viewModel, method, parCall, notifys);
            parCall.doCheckTrackingMap((ClientBindComposer)this._view.getAttribute("$composer"));
        } else if (_log.isDebugEnabled()) {
            _log.debug("no global command method in [{}]", viewModel);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("after doGlobalCommandExecute notifys=[{}]", notifys);
        }
    }

    static void handleNotifyChange(BindContext ctx, Object viewModel, Method method, ParamCall parCall, Set<Property> notifys) {
        SmartNotifyChange sannt = (SmartNotifyChange)ViewModelAnnotationResolvers.getAnnotation((Method)method, SmartNotifyChange.class);
        Object originViewModel = ClientBinderImpl.getOriginViewModel(viewModel);
        if (sannt != null) {
            LinkedHashSet properties = new LinkedHashSet(5);
            properties.addAll(BindELContext.getNotifys((Method)method, (Object)originViewModel, (String)null, null, (BindContext)ctx));
            parCall.call(viewModel, method);
            Iterator it = properties.iterator();
            while (it.hasNext()) {
                Property prop = (Property)it.next();
                Object result = null;
                try {
                    result = Fields.get((Object)prop.getBase(), (String)prop.getProperty());
                    if (!Objects.equals((Object)result, (Object)prop.getValue())) continue;
                    it.remove();
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            notifys.addAll(properties);
        } else {
            parCall.call(viewModel, method);
            notifys.addAll(BindELContext.getNotifys((Method)method, (Object)originViewModel, (String)null, null, (BindContext)ctx));
        }
    }

    protected ParamCallEx createParamCall(BindContext ctx) {
        Execution exec;
        ParamCallEx call = new ParamCallEx((ClientBindComposer)this._view.getAttribute("$composer"));
        call.setBinder(this);
        call.setBindContext(ctx);
        Component comp = ctx.getComponent();
        if (comp != null) {
            call.setComponent(comp);
        }
        if ((exec = Executions.getCurrent()) != null) {
            call.setExecution(exec);
        }
        return call;
    }

    private void notifyVMsgsChanged() {
        if (this._validationMessages != null) {
            Events.postEvent((int)-1, (Component)this._dummyTarget, (Event)new Event(ON_VMSGS_CHANGED));
        }
    }

    private Map<String, Method> initMatchMediaValues(Object viewModel) {
        HashMap<CallSite, Method> values = new HashMap<CallSite, Method>(6);
        for (Method m : BindUtils.getViewModelClass((Object)viewModel).getMethods()) {
            MatchMedia annomm = (MatchMedia)ViewModelAnnotationResolvers.getAnnotation((Method)m, MatchMedia.class);
            if (annomm == null) continue;
            for (String string : annomm.value()) {
                String string2 = "$$ZKMATCHMEDIA$$" + string.trim();
                if (values.containsKey(string2)) {
                    throw new UiException("there are more then one MatchMedia method \"" + string2.substring(16) + "\" in class " + String.valueOf(viewModel));
                }
                values.put((CallSite)((Object)string2), m);
            }
        }
        return values.isEmpty() ? Collections.emptyMap() : values;
    }

    public void destroy(Component comp, Object viewModel) {
        new AbstractAnnotatedMethodInvoker<Destroy>(Destroy.class, _destroyMethodCache){

            protected boolean shouldLookupSuperclass(Destroy annotation) {
                return annotation.superclass();
            }
        }.invokeMethod((Binder)this, null);
    }

    public void loadComponent(Component comp, boolean loadinit) {
        Binder selfBinder = BinderUtil.getBinder((Component)comp);
        if (selfBinder != null) {
            return;
        }
        this.loadComponent0(comp, loadinit);
    }

    protected void loadComponent0(Component comp, boolean loadinit) {
        for (Component kid : comp.getChildren()) {
            if (!kid.hasAttribute("$BINDER_ID$")) {
                this.loadComponent(kid, loadinit);
                continue;
            }
            if (!kid.hasAttribute("$REMOVE_BINDINGS$")) continue;
            kid.removeAttribute("$REMOVE_BINDINGS$");
            Binder nestedBinder = (Binder)kid.getAttribute((String)kid.getAttribute("$BINDER_ID$"));
            nestedBinder.loadComponent(kid, true);
            ((BinderCtrl)nestedBinder).initQueue();
            ((BinderCtrl)nestedBinder).initActivator();
            BinderUtil.markHandling((Component)kid, (Binder)nestedBinder);
        }
    }

    public BindEvaluatorX getEvaluatorX() {
        if (this._eval == null) {
            this._eval = new ClientBinderResolver(this._view, BindEvaluatorXUtil.createEvaluator(null));
        }
        return this._eval;
    }

    public void addCommandBinding(Component component, String s, String s1, Map<String, Object> map) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addGlobalCommandBinding(Component component, String s, String s1, Map<String, Object> map) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void setTemplate(Component component, String s, String s1, Map<String, Object> map) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addPropertyInitBinding(Component component, String s, String s1, Map<String, Object> map, String s2, Map<String, Object> map1) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addPropertyLoadBindings(Component component, String s, String s1, String[] strings, String[] strings1, Map<String, Object> map, String s2, Map<String, Object> map1) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addPropertySaveBindings(Component component, String s, String s1, String[] strings, String[] strings1, Map<String, Object> map, String s2, Map<String, Object> map1, String s3, Map<String, Object> map2) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addFormInitBinding(Component component, String s, String s1, Map<String, Object> map) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addFormLoadBindings(Component component, String s, String s1, String[] strings, String[] strings1, Map<String, Object> map) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addFormSaveBindings(Component component, String s, String s1, String[] strings, String[] strings1, Map<String, Object> map, String s2, Map<String, Object> map1) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addChildrenInitBinding(Component component, String s, Map<String, Object> map) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addChildrenInitBinding(Component component, String s, Map<String, Object> map, String s1, Map<String, Object> map1) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addChildrenLoadBindings(Component component, String s, String[] strings, String[] strings1, Map<String, Object> map) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addChildrenLoadBindings(Component component, String s, String[] strings, String[] strings1, Map<String, Object> map, String s1, Map<String, Object> map1) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addReferenceBinding(Component component, String s, String s1, Map<String, Object> map) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void removeBindings(Component comp) {
        this.removeBindings0(comp);
    }

    public void removeBindings(Set<Component> comps) {
        for (Component comp : comps) {
            this.removeBindings0(comp);
        }
    }

    private void removeBindings0(Component comp) {
        if (this._view == comp) {
            this.unsubscribeQueue(this._quename, this._quescope, this._queueListener);
            this._view.removeAttribute(ACTIVATOR);
            BinderUtil.unmarkHandling((Component)comp);
        }
        if (this._validationMessages != null) {
            this._validationMessages.clearMessages(comp);
        }
        if (comp.hasAttribute("$BINDER_ID$")) {
            comp.setAttribute("$REMOVE_BINDINGS$", (Object)Boolean.TRUE);
        }
    }

    public void removeBindings(Component component, String s) {
    }

    public Converter getConverter(String name) {
        Converter converter = null;
        if (this._hasGetConverterMethod) {
            Object vm = this.getViewModel();
            Class clz = BindUtils.getViewModelClass((Object)vm);
            Method m = null;
            Object result = null;
            try {
                m = clz.getMethod("getConverter", String.class);
            }
            catch (SecurityException x) {
                this._hasGetConverterMethod = false;
            }
            catch (NoSuchMethodException e) {
                this._hasGetConverterMethod = false;
            }
            if (m != null) {
                try {
                    result = m.invoke(vm, name);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    this._hasGetConverterMethod = false;
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                if (result != null && !(result instanceof Converter)) {
                    this._hasGetConverterMethod = false;
                } else {
                    converter = (Converter)result;
                }
            }
        }
        if (converter == null) {
            converter = SystemConverters.get((String)name);
        }
        if (converter == null) {
            throw new UiException("Cannot find converter:" + name);
        }
        return converter;
    }

    public Validator getValidator(String name) {
        this.checkInit();
        Validator validator = null;
        if (this._hasGetValidatorMethod) {
            Object vm = this.getViewModel();
            Class clz = BindUtils.getViewModelClass((Object)vm);
            Method m = null;
            Object result = null;
            try {
                m = clz.getMethod("getValidator", String.class);
            }
            catch (SecurityException var11) {
                this._hasGetValidatorMethod = false;
            }
            catch (NoSuchMethodException var12) {
                this._hasGetValidatorMethod = false;
            }
            if (m != null) {
                try {
                    result = m.invoke(vm, name);
                }
                catch (IllegalArgumentException var8) {
                    throw new RuntimeException(var8.getMessage(), var8);
                }
                catch (IllegalAccessException var9) {
                    this._hasGetValidatorMethod = false;
                }
                catch (InvocationTargetException var10) {
                    throw new RuntimeException(var10.getMessage(), var10);
                }
                if (result != null && !(result instanceof Validator)) {
                    this._hasGetValidatorMethod = false;
                } else {
                    validator = (Validator)result;
                }
            }
        }
        if (validator == null) {
            validator = SystemValidators.get((String)name);
        }
        if (validator == null) {
            throw new UiException("Cannot find validator:" + name);
        }
        return validator;
    }

    public void notifyChange(Object base, String attr) {
        this.checkInit();
        if (_log.isDebugEnabled()) {
            _log.debug("notifyChange base=[{}],attr=[{}]", base, (Object)attr);
        }
        this.getEventQueue().publish((Event)new PropertyChangeEvent(this._view, base, attr));
    }

    public int sendCommand(String command, Map<String, Object> args) {
        this.checkInit();
        HashSet<Property> notifys = new HashSet<Property>();
        Event evt = ClientBinderImpl.parseEventArguments(args, this._view, command);
        int result = this.doCommand(evt != null && evt.getTarget() != null ? evt.getTarget() : this._view, command, evt, args, notifys);
        if (this._validationMessages != null) {
            notifys.add((Property)new PropertyImpl((Object)this._validationMessages, ".", null));
        }
        this.fireNotifyChanges(notifys);
        return result;
    }

    static Event parseEventArguments(Map<String, Object> args, Component view, String command) {
        Event evt = null;
        if (args != null) {
            if (args.containsKey("$ZKCLIENTINFO$")) {
                HashMap<String, Object> inf = new HashMap<String, Object>();
                inf.put("", args.get("$ZKCLIENTINFO$"));
                evt = ClientInfoEvent.getClientInfoEvent((AuRequest)new AuRequest(view.getDesktop(), command, inf));
            } else if (args.containsKey("$ZKCLIENTUPLOADINFO$")) {
                Event uploadInfoEvt = (Event)args.get("$ZKCLIENTUPLOADINFO$");
                if (uploadInfoEvt != null) {
                    evt = uploadInfoEvt;
                }
            } else if (args.containsKey("$cevt$")) {
                evt = ClientBinderImpl.generateEvent((Map)args.remove("$cevt$"));
                for (Map.Entry<String, Object> me : new HashSet<Map.Entry<String, Object>>(args.entrySet())) {
                    if (!(me.getValue() instanceof JSONObject) || !Objects.equals((Object)evt.getName(), (Object)((JSONObject)me.getValue()).get((Object)"command")) && !Objects.equals((Object)evt.getName(), (Object)((JSONObject)me.getValue()).get((Object)"eventType"))) continue;
                    args.put(me.getKey(), evt);
                }
            }
        }
        return evt;
    }

    private int doCommand(Component comp, String command, Event evt, Map<String, Object> commandArgs, Set<Property> notifys) {
        String evtnm;
        String string = evtnm = evt == null ? null : evt.getName();
        if (_log.isDebugEnabled()) {
            _log.debug("Start doCommand comp=[{}],command=[{}],evtnm=[{}]", new Object[]{comp, command, evtnm});
        }
        BindContext ctx = BindContextUtil.newBindContext((Binder)this, null, (boolean)false, (String)command, (Component)comp, (Event)evt);
        BindContextUtil.setCommandArgs((Binder)this, (Component)comp, (BindContext)ctx, commandArgs);
        this.doExecute(comp, command, commandArgs, ctx, notifys);
        this.doToClientCommand(ctx);
        return 0;
    }

    @Override
    public boolean doValidate(Component comp, SavePropertyBinding binding, boolean isValid) {
        if (binding.hasValidator()) {
            BindContext ctx = BindContextUtil.newBindContext((Binder)this, (Binding)binding, (boolean)true, null, (Component)comp, null);
            BindContextUtil.setValidatorArgs((Binder)this, (Component)comp, (BindContext)ctx, (SavePropertyBinding)binding);
            try {
                Property p = binding.getValidate(ctx);
                if (p == null) {
                    throw new UiException("no main property for save-binding " + String.valueOf(binding));
                }
                this.clearValidationMessages(binding.getBinder(), binding.getComponent(), binding.getFieldName());
                Map<String, Property[]> properties = this.toCollectedProperties(p);
                Set<Property> bindingProperties = ((ClientSavePropertyBindingImpl)binding).getProperties();
                if (!bindingProperties.isEmpty()) {
                    properties.putAll(this.toCollectedProperties(bindingProperties));
                }
                ValidationContextImpl vctx = new ValidationContextImpl(null, p, properties, ctx, isValid);
                binding.validate((ValidationContext)vctx);
                return vctx.isValid();
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
        return true;
    }

    @Override
    public boolean doValidate(Component comp, SaveFormBinding binding, boolean isValid) {
        if (binding.hasValidator()) {
            BindContext ctx = BindContextUtil.newBindContext((Binder)this, (Binding)binding, (boolean)true, null, (Component)comp, null);
            BindContextUtil.setValidatorArgs((Binder)this, (Component)comp, (BindContext)ctx, (SaveFormBinding)binding);
            try {
                Property p = binding.getValidate(ctx);
                if (p == null) {
                    throw new UiException("no main property for save-binding " + String.valueOf(binding));
                }
                Map<String, Property[]> properties = this.toCollectedProperties(binding.getValidates(ctx));
                this.clearValidationMessages(binding.getBinder(), binding.getComponent(), binding.getFormId());
                ValidationContextImpl vctx = new ValidationContextImpl(null, p, properties, ctx, isValid);
                binding.validate((ValidationContext)vctx);
                return vctx.isValid();
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
        return true;
    }

    protected Map<String, Property[]> toCollectedProperties(Property validate) {
        HashSet<Property> cp = new HashSet<Property>();
        cp.add(validate);
        return this.toCollectedProperties(cp);
    }

    protected Map<String, Property[]> toCollectedProperties(Set<Property> validates) {
        if (validates == null || validates.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, ArrayList<Property>> temp = new HashMap<String, ArrayList<Property>>(validates.size());
        for (Property p : validates) {
            ArrayList<Property> l = (ArrayList<Property>)temp.get(p.getProperty());
            if (l == null) {
                l = new ArrayList<Property>();
                temp.put(p.getProperty(), l);
            }
            l.add(p);
        }
        HashMap<String, Property[]> collected = new HashMap<String, Property[]>(temp.size());
        for (Map.Entry e : temp.entrySet()) {
            collected.put((String)e.getKey(), ((List)e.getValue()).toArray(new Property[((List)e.getValue()).size()]));
        }
        return collected;
    }

    protected void clearValidationMessages(Binder binder, Component component, String attr) {
        ValidationMessages vmsgs = ((BinderCtrl)binder).getValidationMessages();
        if (vmsgs != null) {
            vmsgs.clearMessages(component, attr);
        }
    }

    protected void doExecute(Component comp, String command, Map<String, Object> commandArgs, BindContext ctx, Set<Property> notifys) {
        Object viewModel;
        Class viewModelClass;
        Method method;
        Matcher matcher = CALL_OTHER_VM_COMMAND_PATTERN.matcher(command);
        if (matcher.find()) {
            String vmId = matcher.group(1);
            Map vmIdBinderMap = (Map)comp.getDesktop().getAttribute("org.zkoss.bind.vmId_binder");
            Binder targetBinder = (Binder)vmIdBinderMap.get(vmId);
            if (targetBinder != null) {
                ((ClientBinderImpl)targetBinder).doExecute(comp, command.replace("$" + vmId + ".", ""), commandArgs, ctx, notifys);
                return;
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug("before doExecute comp=[{}],command=[{}],notifys=[{}]", new Object[]{comp, command, notifys});
        }
        if ((method = this.getCommandMethod(viewModelClass = BindUtils.getViewModelClass((Object)(viewModel = this.getViewModelInView())), command, _commandMethodInfoProvider, _commandMethodCache, commandArgs != null ? commandArgs.values().size() : 0, false)) != null) {
            ParamCallEx parCall = this.createParamCall(ctx);
            if (commandArgs != null) {
                parCall.setBindingArgs(commandArgs);
            }
            ClientBinderImpl.handleNotifyChange(ctx, viewModel, method, parCall, notifys);
            parCall.doCheckTrackingMap((ClientBindComposer)this._view.getAttribute("$composer"));
        } else if (!(this._notifyCommands != null && this._notifyCommands.containsKey(command) || command.startsWith(":") || command.startsWith("/"))) {
            throw new UiException(MiscUtil.formatLocationMessage((String)("cannot find any method that is annotated for the command " + command + " with @Command in " + String.valueOf(viewModel)), (Component)comp));
        }
        if (_log.isDebugEnabled()) {
            _log.debug("after doExecute notifys=[{}]", notifys);
        }
    }

    protected void checkInit() {
        if (!this._init) {
            throw new UiException("binder is not initialized yet");
        }
    }

    private Object getViewModelInView() {
        this.checkInit();
        return this._view.getAttribute("$VM$");
    }

    private void collectNotifyCommands(Object vm) {
        Class viewModelClz = BindUtils.getViewModelClass((Object)vm);
        NotifyCommands commands = (NotifyCommands)ViewModelAnnotationResolvers.getAnnotation((Class)viewModelClz, NotifyCommands.class);
        NotifyCommand command = (NotifyCommand)ViewModelAnnotationResolvers.getAnnotation((Class)viewModelClz, NotifyCommand.class);
        if (this._notifyCommands != null) {
            this._notifyCommands.clear();
        }
        if (command != null) {
            for (String string : command.value()) {
                this._notifyCommands = AllocUtil.inst.putMap(this._notifyCommands, (Object)string, (Object)command);
            }
        }
        if (commands != null) {
            for (String string : commands.value()) {
                for (String cmd : string.value()) {
                    this._notifyCommands = AllocUtil.inst.putMap(this._notifyCommands, (Object)cmd, (Object)string);
                }
            }
        }
        if (this._notifyCommands != null) {
            BindEvaluatorX evalx = BindEvaluatorXUtil.createEvaluator(null);
            BindContext bindContext = BindContextUtil.newBindContext((Binder)this, null, (boolean)false, null, (Component)this._view, null);
            for (Map.Entry<String, NotifyCommand> entry : this._notifyCommands.entrySet()) {
                LinkedHashSet notifys = new LinkedHashSet();
                for (Map.Entry<String, NotifyCommand> entry2 : this._notifyCommands.entrySet()) {
                    String vmname = (String)this._view.getAttribute("$VM_ID$");
                    String expr = entry.getValue().onChange().replace("_vm_", vmname);
                    String notifyCommandName = entry.getKey();
                    ExpressionX expressionX = evalx.parseExpressionX(null, expr, Object.class);
                    Event evt = new Event(ON_POST_COMMAND, this._dummyTarget, (Object)new Object[]{notifyCommandName, Collections.singletonMap("", evalx.getValue(bindContext, this._view, expressionX))});
                    Events.postEvent((Event)evt);
                }
            }
        }
    }

    public Object getViewModel() {
        this.checkInit();
        return ClientBinderImpl.getOriginViewModel(this._view.getAttribute("$VM$"));
    }

    private static Object getOriginViewModel(Object vm) {
        if (vm instanceof ViewModelProxyObject) {
            vm = ((ViewModelProxyObject)vm).getOriginObject();
        }
        return vm;
    }

    public void setViewModel(Object vm) {
        this.checkInit();
        this._view.setAttribute("$VM$", vm);
        this._hasGetConverterMethod = true;
        this._hasGetValidatorMethod = true;
        this.collectNotifyCommands(vm);
    }

    public void addFormAssociatedSaveBinding(Component component, String s, SaveBinding saveBinding, String s1) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public Set<SaveBinding> getFormAssociatedSaveBindings(Component component) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void storeForm(Component component, String s, Form form) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public Form getForm(Component component, String s) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public Tracker getTracker() {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public ValidationMessages getValidationMessages() {
        return this._validationMessages;
    }

    public void setValidationMessages(ValidationMessages validationMessages) {
        this._validationMessages = validationMessages;
    }

    public boolean hasValidator(Component component, String s) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public TemplateResolver getTemplateResolver(Component component, String s) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public List<Binding> getLoadPromptBindings(Component component, String s) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public PhaseListener getPhaseListener() {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public List<PhaseListener> getPhaseListeners() {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void setPhaseListener(PhaseListener phaseListener) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addPhaseListener(PhaseListener phaseListener) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public boolean isActivating() {
        return false;
    }

    public BindingExecutionInfoCollector getBindingExecutionInfoCollector() {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public BindingAnnotationInfoChecker getBindingAnnotationInfoChecker() {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public String getQueueName() {
        return this._quename;
    }

    public String getQueueScope() {
        return this._quescope;
    }

    public void addSaveFormFieldName(Form form, String s) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public void addSaveFormFieldName(Form form, Set<String> set) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public Set<String> getSaveFormFieldNames(Form form) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public Set<String> removeSaveFormFieldNames(Form form) {
        throw new UnsupportedOperationException("Not support for Client Binder");
    }

    public Map<String, Method> getMatchMediaValue() {
        if (this._matchMediaValues == null) {
            this._matchMediaValues = this.initMatchMediaValues(this.getViewModel());
        }
        return Collections.unmodifiableMap(this._matchMediaValues);
    }

    public void initQueue() {
        if (!this.isSubscribed(this._quename, this._quescope, this._queueListener)) {
            this.subscribeQueue(this._quename, this._quescope, this._queueListener);
        }
    }

    public void unbindQueue() {
        if (this.isSubscribed(this._quename, this._quescope, this._queueListener)) {
            this.unsubscribeQueue(this._quename, this._quescope, this._queueListener);
        }
    }

    public void initActivator() {
        if (this._view != null && !this._view.hasAttribute(ACTIVATOR)) {
            this._view.setAttribute(ACTIVATOR, (Object)new Activator());
        }
    }

    private void subscribeQueue(String quename, String quescope, EventListener<Event> listener) {
        EventQueue que = EventQueues.lookup((String)quename, (String)quescope, (boolean)true);
        que.subscribe(listener);
    }

    private void unsubscribeQueue(String quename, String quescope, EventListener<Event> listener) {
        EventQueue que = EventQueues.lookup((String)quename, (String)quescope, (boolean)false);
        if (que != null) {
            que.unsubscribe(listener);
        }
    }

    private boolean isSubscribed(String quename, String quescope, EventListener<Event> listener) {
        EventQueue que = EventQueues.lookup((String)quename, (String)quescope, (boolean)false);
        return que == null ? false : que.isSubscribed(listener);
    }

    @Override
    public EventQueue<Event> getEventQueue() {
        return EventQueues.lookup((String)this._quename, (String)this._quescope, (boolean)true);
    }

    public Component getView() {
        return this._view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getCommandMethod(Class<?> clz, String command, CommandMethodInfoProvider cmdInfo, Map<Class<?>, Map<String, CachedItem<Method>>> cache, int commandParamCount, boolean isGlobal) {
        Map methods;
        Map<Class<?>, Map<String, CachedItem<Method>>> map = cache == _globalCommandMethodCache ? _globalCommandMethodCache : _commandMethodCache;
        synchronized (map) {
            methods = cache.computeIfAbsent(clz, k -> new HashMap());
        }
        Method matchedMethodWithoutAnno = null;
        CachedItem method = null;
        Map map2 = methods;
        synchronized (map2) {
            method = (CachedItem)methods.get(command);
            boolean inited = false;
            if (method != null) {
                return (Method)method.value;
            }
            if (methods.get(COMMAND_METHOD_MAP_INIT) != null) {
                inited = true;
            }
            for (Method m : clz.getMethods()) {
                String[] vals;
                if (m.isBridge()) continue;
                String mName = m.getName();
                if (!isGlobal && mName.equals(command) && m.getParameterTypes().length == commandParamCount) {
                    matchedMethodWithoutAnno = m;
                }
                if (inited) continue;
                if (cmdInfo.isDefaultMethod(m)) {
                    if (methods.get(COMMAND_METHOD_DEFAULT) != null) {
                        throw new UiException("there are more than one " + cmdInfo.getDefaultAnnotationName() + " method in " + String.valueOf(clz) + ", " + String.valueOf(((CachedItem)methods.get((Object)COMMAND_METHOD_DEFAULT)).value) + " and " + String.valueOf(m));
                    }
                    methods.put(COMMAND_METHOD_DEFAULT, new CachedItem<Method>(m));
                }
                if ((vals = cmdInfo.getCommandName(m)) == null) continue;
                if (vals.length == 0) {
                    vals = new String[]{mName};
                }
                for (String val : vals) {
                    if (methods.get(val = val.trim()) != null) {
                        throw new UiException("there are more than one " + cmdInfo.getAnnotationName() + " method " + val + " in " + String.valueOf(clz) + ", " + String.valueOf(((CachedItem)methods.get((Object)val)).value) + " and " + String.valueOf(m));
                    }
                    methods.put(val, new CachedItem<Method>(m));
                }
            }
            if (!inited) {
                if (this._matchMediaValues != null) {
                    for (Map.Entry entry : this._matchMediaValues.entrySet()) {
                        methods.put((String)entry.getKey(), new CachedItem<Method>((Method)entry.getValue()));
                    }
                }
                methods.put(COMMAND_METHOD_MAP_INIT, NULL_METHOD);
            }
            if ((method = (CachedItem)methods.get(command)) == null) {
                if (matchedMethodWithoutAnno != null) {
                    method = new CachedItem(matchedMethodWithoutAnno);
                    methods.put(command, method);
                } else {
                    method = (CachedItem)methods.get(COMMAND_METHOD_DEFAULT);
                    if (method != null) {
                        methods.put(command, method);
                    }
                }
            }
        }
        return method == null ? null : (Method)method.value;
    }

    private void doToClientCommand(BindContext ctx) {
        List<String> asList;
        ToClientCommand ccmd;
        String commandName = ctx.getCommandName();
        Binder binder = ctx.getBinder();
        Object vm = binder.getViewModel();
        if (vm != null && (ccmd = vm.getClass().getAnnotation(ToClientCommand.class)) != null && ((asList = Arrays.asList(ccmd.value())).contains("*") || asList.contains(commandName))) {
            Map args = (Map)ctx.getAttribute((Object)"$BC_CMDARGS$");
            if (args != null) {
                if (args.size() == 1) {
                    JavaScriptValue data = new JavaScriptValue(String.valueOf(binder.getConverter("jsonBindingParam").coerceToUi(args.values().iterator().next(), ctx.getComponent(), ctx)));
                    Clients.response((AuResponse)new AuInvoke(ctx.getBinder().getView(), "$afterCommand", new Object[]{commandName, data}));
                } else {
                    JavaScriptValue data = new JavaScriptValue(String.valueOf(binder.getConverter("jsonBindingParam").coerceToUi((Object)args, ctx.getComponent(), ctx)));
                    Clients.response((AuResponse)new AuInvoke(ctx.getBinder().getView(), "$afterCommand", new Object[]{commandName, data}));
                }
            } else {
                Clients.response((AuResponse)new AuInvoke(ctx.getBinder().getView(), "$afterCommand", (Object)commandName));
            }
        }
    }

    private static Event generateEvent(Map<String, Object> data) {
        MouseEvent event;
        String eventType = (String)data.remove("eventType");
        AuRequest request = new AuRequest(Executions.getCurrent().getDesktop(), (String)data.get("uuid"), (String)data.remove("command"), data);
        try {
            request.activate();
        }
        catch (ComponentNotFoundException componentNotFoundException) {
            // empty catch block
        }
        if (eventType == null) {
            eventType = request.getCommand();
        }
        switch (eventType) {
            case "MouseEvent": {
                event = MouseEvent.getMouseEvent((AuRequest)request);
                break;
            }
            case "KeyboardEvent": {
                event = KeyEvent.getKeyEvent((AuRequest)request);
                break;
            }
            case "DropEvent": {
                event = DropEvent.getDropEvent((AuRequest)request);
                break;
            }
            case "InputEvent": {
                event = InputEvent.getInputEvent((AuRequest)request, (Object)data.get("oldValue"));
                break;
            }
            case "CheckEvent": {
                event = CheckEvent.getCheckEvent((AuRequest)request);
                break;
            }
            case "onSelect": {
                event = SelectEvent.getSelectEvent((AuRequest)request);
                break;
            }
            case "onPortalDrop": {
                event = PortalDropEvent.getPortalDropEvent((AuRequest)request);
                break;
            }
            case "onOpen": {
                event = OpenEvent.getOpenEvent((AuRequest)request);
                break;
            }
            case "onUpload": {
                event = UploadEvent.getUploadEvent((String)eventType, (Component)request.getComponent(), (AuRequest)request);
                break;
            }
            default: {
                event = new Event(eventType, null, (Object)request.getData());
            }
        }
        return event;
    }

    private static interface CommandMethodInfoProvider {
        public String getAnnotationName();

        public String getDefaultAnnotationName();

        public String[] getCommandName(Method var1);

        public boolean isDefaultMethod(Method var1);
    }

    private static class CachedItem<T> {
        final T value;

        public CachedItem(T value) {
            this.value = value;
        }
    }

    private class Activator
    implements ComponentActivationListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Activator() {
        }

        public void didActivate(Component comp) {
            if (ClientBinderImpl.this._view.equals(comp)) {
                ClientBinderImpl.this.initQueue();
            }
        }

        public void willPassivate(Component comp) {
        }
    }

    private class QueueListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private QueueListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (event instanceof PropertyChangeEvent) {
                Object jsVal;
                PropertyChangeEvent evt = (PropertyChangeEvent)event;
                Component target = evt.getTarget();
                if (target != null && !Objects.equals((Object)ClientBinderImpl.this._view, (Object)target)) {
                    return;
                }
                Object base = evt.getBase();
                String property = evt.getProperty();
                Object updateData = base;
                if (base.getClass().isAnnotationPresent(Immutable.class) || updateData instanceof FormProxyObject || updateData instanceof Binder) {
                    return;
                }
                String expr = property;
                Object viewModel = ClientBinderImpl.this._view.getAttribute("$VM$");
                ClientBindComposer composer = (ClientBindComposer)ClientBinderImpl.this._view.getAttribute("$composer");
                HashMap<String, String> notifyCommands = new HashMap<String, String>();
                if (viewModel.equals(base)) {
                    if (!".".equals(expr) && !"*".equals(expr)) {
                        int secondPartIndex = expr.indexOf(".");
                        if (secondPartIndex != -1) {
                            expr = expr.substring(0, secondPartIndex);
                        }
                        secondPartIndex = expr.indexOf("[");
                        boolean hasPropChanged = false;
                        boolean updateAll = false;
                        if (secondPartIndex != -1) {
                            expr = expr.substring(0, secondPartIndex);
                        }
                        Method[] methods = updateData.getClass().getMethods();
                        if (expr.startsWith("is") || expr.startsWith("get")) {
                            String methodName = expr;
                            Optional<Method> method = Arrays.stream(methods).filter(m -> m.getName().equals(methodName) && m.getParameterTypes().length == 0).findAny();
                            if (method.isPresent()) {
                                updateData = method.get().invoke(updateData, new Object[0]);
                                hasPropChanged = true;
                            } else {
                                updateAll = Arrays.stream(methods).filter(m -> m.getName().equals(methodName)).findAny().isPresent();
                            }
                        } else {
                            String capitalProp = Character.toUpperCase(expr.charAt(0)) + expr.substring(1);
                            String getMethodName = "get" + capitalProp;
                            String isMethodName = "is" + capitalProp;
                            Optional<Method> method = Arrays.stream(methods).filter(m -> (m.getName().equals(getMethodName) || m.getName().equals(isMethodName)) && m.getParameterTypes().length == 0).findAny();
                            if (method.isPresent()) {
                                updateData = method.get().invoke(updateData, new Object[0]);
                                hasPropChanged = true;
                            } else {
                                updateAll = Arrays.stream(methods).filter(m -> m.getName().equals(getMethodName) || m.getName().equals(isMethodName)).findAny().isPresent();
                            }
                        }
                        if (hasPropChanged) {
                            jsVal = new JavaScriptValue("{" + expr + ":" + composer.writeValueAsString(updateData) + "}");
                        } else {
                            if (!updateAll) {
                                try {
                                    Object result = composer.evalExpression(composer.view, composer.getBeanUid(composer.getViewModel()) + "." + property);
                                    if (result != null) {
                                        updateAll = true;
                                    }
                                }
                                catch (Exception e) {
                                    ClientBindComposer.log.error("Unable to eval the expression, " + e.getMessage());
                                }
                            }
                            jsVal = updateAll ? new JavaScriptValue(composer.writeValueAsString(updateData)) : null;
                        }
                    } else {
                        jsVal = new JavaScriptValue(composer.writeValueAsString(updateData));
                    }
                    if (ClientBinderImpl.this._notifyCommands != null) {
                        for (Map.Entry<String, NotifyCommand> me : ClientBinderImpl.this._notifyCommands.entrySet()) {
                            String prop = me.getValue().onChange().replace("_vm_.", "");
                            String notifyCommandName = me.getKey();
                            if (".".equals(expr) || "*".equals(expr)) {
                                notifyCommands.put(notifyCommandName, prop);
                                continue;
                            }
                            if (!prop.equals(property)) continue;
                            notifyCommands.put(notifyCommandName, prop);
                        }
                    }
                } else {
                    jsVal = new JavaScriptValue(composer.writeValueAsString(updateData));
                }
                if (jsVal != null) {
                    Clients.response((AuResponse)new AuInvoke(ClientBinderImpl.this._view, "update@vm", new Object[]{property, jsVal}));
                    composer.notifyDependsOn(base, null, property);
                    composer.notifyPropertyChange(evt);
                }
                if (!notifyCommands.isEmpty()) {
                    LinkedHashSet<Property> notifys = new LinkedHashSet<Property>();
                    for (Map.Entry entry : notifyCommands.entrySet()) {
                        ClientBinderImpl.this.doCommand(ClientBinderImpl.this._view, (String)entry.getKey(), (Event)new PropertyChangeEvent(ClientBinderImpl.this._view, base, (String)entry.getValue()), Collections.singletonMap("", updateData), notifys);
                    }
                    ClientBinderImpl.this.fireNotifyChanges(notifys);
                }
            } else if (event instanceof GlobalCommandEvent) {
                GlobalCommandEvent evt = (GlobalCommandEvent)event;
                LinkedHashSet<Property> notifys = new LinkedHashSet<Property>();
                ClientBinderImpl.this.doGlobalCommand(ClientBinderImpl.this._view, evt.getCommand(), evt.getArgs(), notifys);
                ClientBinderImpl.this.fireNotifyChanges(notifys);
                ClientBinderImpl.this.notifyVMsgsChanged();
            }
        }
    }

    private class VMsgsChangedListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private VMsgsChangedListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (ClientBinderImpl.this._validationMessages != null && ClientBinderImpl.this._view.getDesktop() != null) {
                HashSet<Property> notify = new HashSet<Property>();
                notify.add((Property)new PropertyImpl((Object)ClientBinderImpl.this._validationMessages, ".", null));
                ClientBinderImpl.this.fireNotifyChanges(notify);
            }
        }
    }

    private class PostCommandListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PostCommandListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (ClientBinderImpl.this._view.getDesktop() != null) {
                Object[] data = (Object[])event.getData();
                String command = (String)data[0];
                Map args = (Map)data[1];
                ClientBinderImpl.this.sendCommand(command, args);
            }
        }
    }
}

