/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.util.Objects;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zul.PageableModel;
import org.zkoss.zul.Tree;
import org.zkoss.zul.event.TreeDataEvent;
import org.zkoss.zul.event.TreeDataListener;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.ext.TreeSelectableModel;

class ClientTreeDataListener
implements TreeDataListener,
Serializable,
ComponentActivationListener {
    private ClientBindComposer _composer;
    private String _expr;
    private Component _component;
    private Component _view;

    ClientTreeDataListener(ClientBindComposer composer, Component comp, String expr) {
        this._composer = composer;
        this._view = composer.view;
        this._component = comp;
        this._expr = expr;
    }

    public void onChange(TreeDataEvent event) {
        if (this._view.hasAttribute("$DISABLE_CLIENT_UPDATE$")) {
            return;
        }
        Object prop = this._expr;
        String vmExprPrefix = String.valueOf(this._view.getAttribute("$VM_ID$")) + ".";
        if (((String)prop).startsWith(vmExprPrefix)) {
            prop = ((String)prop).substring(vmExprPrefix.length());
        }
        if (((String)prop).contains("(")) {
            int end;
            if (((String)prop).startsWith("get")) {
                end = ((String)prop).indexOf("(");
                prop = ((String)prop).substring(3, end);
            } else if (((String)prop).startsWith("is")) {
                end = ((String)prop).indexOf("(");
                prop = ((String)prop).substring(2, end);
            }
            prop = String.valueOf(((String)prop).charAt(0)).toLowerCase() + ((String)prop).substring(1);
        }
        JavaScriptValue updatedTreeModel = null;
        try {
            updatedTreeModel = new JavaScriptValue("{" + (String)prop + ":" + this._composer.writeValueAsString(event.getModel()) + "}");
        }
        catch (JsonProcessingException e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
        int type = event.getType();
        Clients.response((String)((String)prop + "$" + type), (AuResponse)new AuInvoke(this._view, "update@vm", new Object[]{prop, updatedTreeModel}));
        switch (type) {
            case 1: 
            case 2: 
            case 5: {
                Paginal paginal;
                if (!(this._component instanceof Tree) || (paginal = ((Tree)this._component).getPaginal()) == null) break;
                paginal.setTotalSize(((PageableModel)event.getModel()).getTotalSize());
                break;
            }
            case 6: {
                if (!(this._component instanceof Tree)) break;
                ((Tree)this._component).setMultiple(((TreeSelectableModel)event.getModel()).isMultiple());
            }
        }
    }

    public void didActivate(Component comp) {
        this._composer = (ClientBindComposer)Components.getComposer((Component)comp);
    }

    public void willPassivate(Component comp) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTreeDataListener that = (ClientTreeDataListener)o;
        return Objects.equals(this._expr, that._expr) && Objects.equals(this._component, that._component);
    }

    public int hashCode() {
        return Objects.hash(this._expr, this._component);
    }
}

