/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Map;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.impl.GroupsListModel;

public class OnDataLoadingCommand {
    private ClientBindComposer composer;
    private Component view;

    private OnDataLoadingCommand(ClientBindComposer composer) {
        this.composer = composer;
        this.view = composer.view;
    }

    private boolean process(String command, Map<String, Object> data) {
        Map args = (Map)data.get("args");
        String modelUid = (String)args.get("model");
        Object model = this.composer.getCachedBeanById(modelUid);
        if (model != null) {
            int offset = (Integer)args.get("offset");
            int limit = (Integer)args.get("limit");
            Boolean checkSelectAll = (Boolean)args.get("checkSelectAll");
            this.composer.modelRodSizeMap.put(model, limit);
            Object loadingModel = this.composer.getPartialFromModel(model, offset);
            try {
                Executions.getCurrent().setAttribute("$IGNORE_FIRST_LIST_ID$", (Object)true);
                Object objectString = this.composer.writeValueAsString(loadingModel);
                objectString = "{\"$id$\":\"" + modelUid + "\"," + ((String)objectString).substring(1);
                ListModel listModel = this.composer.modelToListModel.get(model);
                String groupInfoValueString = null;
                if (listModel instanceof GroupsListModel && !Strings.isEmpty((String)(groupInfoValueString = ClientBindComposer.getGroupsInfoValueStringFromModel((GroupsListModel)listModel, offset, offset + limit - 1, false)))) {
                    objectString = "{" + groupInfoValueString + ((String)objectString).substring(1);
                }
                if (listModel instanceof Selectable) {
                    Selectable selectable = (Selectable)listModel;
                    Object selectionValString = "{\"$sel$\":";
                    selectionValString = checkSelectAll != null && checkSelectAll != false && selectable.getSelectionControl().isSelectAll() ? (String)selectionValString + "['$SELECT_ALL$']" : (String)selectionValString + this.composer.writeValueAsString(selectable.getSelection());
                    objectString = (String)selectionValString + "," + ((String)objectString).substring(1);
                }
                Clients.sendClientCommand((Component)this.view, (String)command, (Object)new JavaScriptValue((String)objectString));
            }
            catch (JsonProcessingException e) {
                ClientBindComposer.log.error("Unable to write ListModel, " + e.getMessage());
            }
        }
        return true;
    }

    public static boolean processCommand(ClientBindComposer composer, String command, Map<String, Object> data) {
        return new OnDataLoadingCommand(composer).process(command, data);
    }
}

