/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.util.Clients;

public class ValidationMessagesMonitor
implements ValidationMessages,
Collection<String>,
Serializable {
    private final ClientBindComposer owner;
    private final ValidationMessages messages;

    public ValidationMessagesMonitor(ClientBindComposer owner, ValidationMessages messages) {
        this.owner = owner;
        this.messages = messages;
    }

    private static void sendNotification(ClientBindComposer owner) {
        Clients.response((String)owner.view.getUuid(), (AuResponse)new AuInvoke(owner.view, "$afterCommand", new Object[]{"$rec$", true}));
    }

    public void clearMessages(Component component, String s) {
        this.messages.clearMessages(component, s);
        ValidationMessagesMonitor.sendNotification(this.owner);
    }

    public void clearMessages(Component component) {
        this.messages.clearMessages(component);
        ValidationMessagesMonitor.sendNotification(this.owner);
    }

    public void clearKeyMessages(Component component, String s) {
        this.messages.clearKeyMessages(component, s);
        ValidationMessagesMonitor.sendNotification(this.owner);
    }

    public void clearKeyMessages(String s) {
        this.messages.clearKeyMessages(s);
        ValidationMessagesMonitor.sendNotification(this.owner);
    }

    public void clearAllMessages() {
        this.messages.clearAllMessages();
        ValidationMessagesMonitor.sendNotification(this.owner);
    }

    public String[] getMessages(Component component, String s) {
        return this.messages.getMessages(component, s);
    }

    public String[] getMessages(Component component) {
        return this.messages.getMessages(component);
    }

    public String[] getMessages() {
        return this.messages.getMessages();
    }

    public String[] getKeyMessages(Component component, String s) {
        return this.messages.getKeyMessages(component, s);
    }

    public String[] getKeyMessages(String s) {
        return this.messages.getKeyMessages(s);
    }

    public void setMessages(Component component, String s, String s1, String[] strings) {
        this.messages.setMessages(component, s, s1, strings);
        ValidationMessagesMonitor.sendNotification(this.owner);
    }

    public void setMessages(Component component, String s, String s1, String[] strings, Object o) {
        this.messages.setMessages(component, s, s1, strings, o);
        ValidationMessagesMonitor.sendNotification(this.owner);
    }

    public void addMessages(Component component, String s, String s1, String[] strings) {
        this.messages.addMessages(component, s, s1, strings);
        ValidationMessagesMonitor.sendNotification(this.owner);
    }

    public void addMessages(Component component, String s, String s1, String[] strings, Object o) {
        this.messages.addMessages(component, s, s1, strings, o);
        ValidationMessagesMonitor.sendNotification(this.owner);
    }

    public Object getFieldValue(String s) {
        return this.messages.getFieldValue(s);
    }

    public Object getFieldValue(Component component, String s) {
        return this.messages.getFieldValue(component, s);
    }

    public Object[] getFieldValues(String s) {
        return this.messages.getFieldValues(s);
    }

    public Object[] getFieldValues(Component component, String s) {
        return this.messages.getFieldValues(component, s);
    }

    public Component getAssociate(String s) {
        return this.messages.getAssociate(s);
    }

    public Component[] getAssociates(String s) {
        return this.messages.getAssociates(s);
    }

    @Override
    public int size() {
        return this.messages.getMessages().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return Arrays.asList(this.getMessages()).contains(o);
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.getMessages()).iterator();
    }

    public String[] toArray() {
        return this.getMessages();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getMessages();
    }

    @Override
    public boolean add(String e) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return Arrays.asList(this.getMessages()).containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("read only");
    }
}

