/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Form;
import org.zkoss.bind.Property;
import org.zkoss.bind.ValidationContext;
import org.zkoss.bind.Validator;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.PropertyImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.SaveFormBinding;
import org.zkoss.clientbind.ClientBinder;
import org.zkoss.json.JSONObject;
import org.zkoss.xel.ExpressionX;
import org.zkoss.zk.ui.Component;

public class ClientSaveFormBindingImpl
implements SaveFormBinding {
    private final ClientBinder _binder;
    private final Component _comp;
    private final String _fieldName;
    private final Property _property;
    private final ExpressionX _validator;
    private Map<String, Object> _validatorArgs;
    private final Map _formProps;
    private final String _formId;

    public ClientSaveFormBindingImpl(ClientBinder binder, Component comp, String fieldName, Property property, String validatorExpr, Map<String, Object> validatorArgs, Map formProps, String formId) {
        this._binder = binder;
        this._comp = comp;
        this._fieldName = fieldName;
        this._property = property;
        BindEvaluatorX eval = binder.getEvaluatorX();
        this._validator = validatorExpr == null ? null : this.parseValidator(eval, validatorExpr);
        HashMap args = new HashMap();
        if (validatorArgs != null) {
            validatorArgs.forEach((key, value) -> args.put(key, ((List)value).toArray(new String[0])));
        }
        this._validatorArgs = BindEvaluatorXUtil.parseArgs((BindEvaluatorX)eval, args);
        this._formProps = formProps;
        this._formId = formId;
    }

    private ExpressionX parseValidator(BindEvaluatorX eval, String validatorExpr) {
        return eval.parseExpressionX((BindContext)null, validatorExpr, Object.class);
    }

    public void save(BindContext bindContext) {
        throw new IllegalStateException("Not supported yet!");
    }

    public void validate(ValidationContext vctx) {
        Validator validator = this.getValidator();
        if (validator == null) {
            throw new NullPointerException("cannot find validator for " + String.valueOf(this));
        }
        validator.validate(vctx);
    }

    public Property getValidate(BindContext bindContext) {
        return this._property;
    }

    public boolean hasValidator() {
        return true;
    }

    public Validator getValidator() {
        if (this._validator == null) {
            return null;
        }
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        Object obj = eval.getValue(null, this.getComponent(), this._validator);
        if (obj instanceof Validator) {
            return (Validator)obj;
        }
        if (obj instanceof String) {
            return this.getBinder().getValidator((String)obj);
        }
        throw new ClassCastException("result of expression '" + this._validator.getExpressionString() + "' is not a Validator, is " + String.valueOf(obj));
    }

    public Map<String, Object> getValidatorArgs() {
        return this._validatorArgs;
    }

    public Binder getBinder() {
        return this._binder;
    }

    public Component getComponent() {
        return this._comp;
    }

    public Map<String, Object> getArgs() {
        return null;
    }

    public Converter getConverter() {
        throw new IllegalStateException("Not supported yet!");
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public Form getFormBean() {
        return (Form)this._property.getBase();
    }

    public String getFormId() {
        return this._formId;
    }

    public String getCommandName() {
        throw new IllegalStateException("Not supported yet!");
    }

    public String getPropertyString() {
        throw new IllegalStateException("Not supported yet!");
    }

    public ConditionType getConditionType() {
        throw new IllegalStateException("Not supported yet!");
    }

    public ExpressionX getFieldExpression(BindEvaluatorX eval, String field) {
        throw new IllegalStateException("Not supported yet!");
    }

    public ExpressionX getFormExpression(BindEvaluatorX eval, String field) {
        throw new IllegalStateException("Not supported yet!");
    }

    public Map<String, Object> getConverterArgs() {
        throw new IllegalStateException("Not supported yet!");
    }

    public ExpressionX getProperty() {
        throw new IllegalStateException("Not supported yet!");
    }

    public Set<Property> getValidates(BindContext ctx) {
        HashSet<Property> properties = new HashSet<Property>(3);
        properties.add(this._property);
        JSONObject formBean = (JSONObject)this._formProps;
        if (formBean != null) {
            for (Map.Entry entry : formBean.entrySet()) {
                String prop = (String)entry.getKey();
                Object value = entry.getValue();
                properties.add((Property)new PropertyImpl(this._property.getBase(), prop, value));
                properties.add((Property)new PropertyImpl(this._property.getValue(), prop, value));
            }
        }
        return properties;
    }
}

