/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.event.PagingListener;
import org.zkoss.zul.ext.Pageable;
import org.zkoss.zul.ext.Paginal;

class TreeModelPagingListener
implements PagingListener {
    private ClientBindComposer composer;
    private TreeModel treeModel;
    private String expr;
    private Paginal paginal;

    TreeModelPagingListener(ClientBindComposer composer, TreeModel treeModel, String expr, Paginal paginal) {
        this.composer = composer;
        this.treeModel = treeModel;
        this.expr = expr;
        this.paginal = paginal;
    }

    public void onEvent(Event event) throws JsonProcessingException {
        if (this.composer.view.hasAttribute("$DISABLE_CLIENT_UPDATE$")) {
            return;
        }
        if (event instanceof PagingEvent) {
            String vmExprPrefix;
            String prop;
            PagingEvent pe = (PagingEvent)event;
            int pgsz = pe.getPageable().getPageSize();
            int actpg = pe.getActivePage();
            if ("internalModelEvent".equals(pe.getName())) {
                if (pgsz > 0) {
                    this.paginal.setPageSize(pgsz);
                }
                if (actpg >= 0) {
                    this.paginal.setActivePage(actpg);
                }
            } else if (this.treeModel instanceof Pageable) {
                ((Pageable)this.treeModel).setActivePage(actpg);
            }
            if ((prop = this.expr).startsWith(vmExprPrefix = String.valueOf(this.composer.view.getAttribute("$VM_ID$")) + ".")) {
                prop = prop.substring(vmExprPrefix.length());
            }
            JavaScriptValue updatedListModel = new JavaScriptValue("{" + prop + ":" + this.composer.writeValueAsString(this.treeModel) + "}");
            Clients.response((String)prop, (AuResponse)new AuInvoke(this.composer.view, "update@vm", new Object[]{prop, updatedListModel}));
        }
    }

    public Object willClone(Component comp) {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeModelPagingListener that = (TreeModelPagingListener)o;
        return Objects.equals(this.composer, that.composer) && Objects.equals(this.treeModel, that.treeModel) && Objects.equals(this.expr, that.expr) && Objects.equals(this.paginal, that.paginal);
    }

    public int hashCode() {
        return Objects.hash(this.composer, this.treeModel, this.expr, this.paginal);
    }
}

