/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.bind.FormStatus;
import org.zkoss.bind.converter.FormatedDateConverter;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.clientbind.ui.util.ObjectMappers;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.OperationException;
import org.zkoss.lang.Strings;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.util.Clients;

public class RemoteConverterCommand {
    private ClientBindComposer composer;
    private Component view;

    private RemoteConverterCommand(ClientBindComposer composer) {
        this.composer = composer;
        this.view = composer.view;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean process(String command, Map<String, Object> data) {
        Set<String> invocationProps;
        void var5_25;
        Object result;
        Map args = (Map)data.get("args");
        String converterExpr = (String)args.get("cv");
        Object v = args.get("value");
        if ("$tsc$".equals(converterExpr)) {
            Object bean;
            String beanUid = (String)v;
            if (beanUid.endsWith("$$")) {
                beanUid = beanUid.substring(0, beanUid.length() - 2);
            }
            if ((bean = this.composer.getCachedBeanById(beanUid)) == null) throw new NullPointerException("Bean is null [" + beanUid + "]");
            result = bean.toString();
        } else {
            String uuid = (String)args.get("uuid");
            Component target = this.view.getDesktop().getComponentByUuidIfAny(uuid);
            Converter converter = this.composer.findConverter(target, converterExpr);
            if (v instanceof JSONObject) {
                String type = (String)((JSONObject)v).get((Object)"_@t");
                if (!Strings.isEmpty((String)type)) {
                    Object nValue = ((JSONObject)v).get((Object)"_@n");
                    if (nValue != null) {
                        String sValue = nValue.toString();
                        if (type.startsWith("date")) {
                            String string = type.substring("date".length());
                            long time = Long.parseLong(sValue);
                            switch (string) {
                                case "": {
                                    Date date = new Date(time);
                                    break;
                                }
                                case "$ld": {
                                    LocalDate localDate = LocalDate.parse((String)((JSONObject)v).get((Object)"_@s"));
                                    break;
                                }
                                case "$ldt": {
                                    LocalDateTime localDateTime = LocalDateTime.parse((String)((JSONObject)v).get((Object)"_@s"));
                                    break;
                                }
                                case "$lt": {
                                    LocalTime localTime = LocalTime.parse((String)((JSONObject)v).get((Object)"_@s"));
                                    break;
                                }
                                case "$zdt": {
                                    ZonedDateTime zonedDateTime = new Timestamp(time).toLocalDateTime().atZone(ZoneId.of(TimeZones.getCurrent().getID()));
                                }
                            }
                        } else if ("double".equals(type)) {
                            Double d = Double.parseDouble(sValue);
                        } else if ("float".equals(type)) {
                            Float f = Float.valueOf(Float.parseFloat(sValue));
                        }
                    } else {
                        Object var5_15 = null;
                    }
                } else {
                    Object bean;
                    String newbuid;
                    String beanUid = (String)((JSONObject)v).get((Object)"$id$");
                    if (beanUid != null && !(newbuid = beanUid.replace("$$", "")).equals(beanUid)) {
                        beanUid = newbuid;
                    }
                    Object object = bean = beanUid != null ? this.composer.getCachedBeanById(beanUid) : null;
                    if (bean != null) {
                        ObjectReader objectReader = ObjectMappers.SETTER_OBJECT_MAPPER.readerFor(bean.getClass()).withAttribute((Object)"$composer$", (Object)this.composer);
                        try {
                            Object object2 = objectReader.readValue(JSONValue.toJSONString(v));
                        }
                        catch (JsonProcessingException e) {
                            throw new OperationException("Unable to write to bean, ", (Throwable)e);
                        }
                    } else {
                        Object origin;
                        Object originJson;
                        void var15_56;
                        Method coerceToUi;
                        List list = Arrays.stream(converter.getClass().getMethods()).filter(method -> method.getName().equals("coerceToUi")).collect(Collectors.toList());
                        Method method2 = coerceToUi = list.size() == 1 ? (Method)list.get(0) : (Method)list.stream().filter(method -> method.getParameterTypes()[0] != Object.class).findFirst().orElse(null);
                        if (coerceToUi == null) {
                            throw new OperationException("Unable to find coerceToUi method");
                        }
                        Class<FormStatus> clazz = coerceToUi.getParameterTypes()[0];
                        if (clazz.isAssignableFrom(FormStatus.class)) {
                            Class<FormStatusImpl> clazz2 = FormStatusImpl.class;
                        }
                        JSONObject oldValue = (JSONObject)v;
                        Object t = ObjectMappers.convert(v, var15_56);
                        if (t instanceof FormStatusImpl && oldValue.containsKey((Object)"origin") && (originJson = oldValue.get((Object)"origin")) instanceof JSONObject && (origin = this.composer.getCachedBeanById((String)((JSONObject)originJson).get((Object)"$id$"))) != null) {
                            ((FormStatusImpl)t).setOrigin(origin);
                        }
                    }
                }
            } else if (v instanceof JSONArray) {
                Method coerceToUi;
                List coerceToUiMethods = Arrays.stream(converter.getClass().getMethods()).filter(method -> method.getName().equals("coerceToUi")).collect(Collectors.toList());
                Method method3 = coerceToUi = coerceToUiMethods.size() == 1 ? (Method)coerceToUiMethods.get(0) : (Method)coerceToUiMethods.stream().filter(method -> method.getParameterTypes()[0] != Object.class).findFirst().orElse(null);
                if (coerceToUi == null) {
                    throw new OperationException("Unable to find coerceToUi method");
                }
                Type[] genericParameterTypes = coerceToUi.getGenericParameterTypes();
                if (genericParameterTypes != null && genericParameterTypes.length > 0) {
                    Type type = genericParameterTypes[0];
                    if (type instanceof ParameterizedType && !v.getClass().isAssignableFrom(type.getClass())) {
                        Object t = ObjectMappers.convert(this.composer, v, (ParameterizedType)type);
                    }
                } else {
                    Object origin;
                    Object object;
                    void var13_44;
                    Class<FormStatus> clazz = coerceToUi.getParameterTypes()[0];
                    if (clazz.isAssignableFrom(FormStatus.class)) {
                        Class<FormStatusImpl> clazz3 = FormStatusImpl.class;
                    }
                    Object oldValue = ((JSONArray)v).get(0);
                    Object t = ObjectMappers.convert(v, var13_44);
                    if (t instanceof FormStatusImpl && oldValue instanceof JSONObject && ((JSONObject)oldValue).containsKey((Object)"origin") && (object = ((JSONObject)oldValue).get((Object)"origin")) instanceof JSONObject && (origin = this.composer.getCachedBeanById((String)((JSONObject)object).get((Object)"$id$"))) != null) {
                        ((FormStatusImpl)t).setOrigin(origin);
                    }
                }
            } else if (converter instanceof FormatedDateConverter && v instanceof Long) {
                Date date = new Date((Long)v);
            }
            result = converter.coerceToUi((Object)var5_25, target, this.composer.prepareConverterContext(target, (Map)args.get("cvp")));
        }
        if (result == Converter.IGNORED_VALUE) return true;
        if (var5_25 instanceof FormStatusImpl && !(invocationProps = ((FormStatusImpl)var5_25).getInvocationProps()).isEmpty()) {
            JSONObject json = new JSONObject();
            json.put((Object)"$value$", result);
            json.put((Object)"$props$", invocationProps);
            result = json;
        }
        Clients.sendClientCommand((Component)this.view, (String)command, (Object)result);
        return true;
    }

    public static boolean processCommand(ClientBindComposer composer, String command, Map<String, Object> data) {
        return new RemoteConverterCommand(composer).process(command, data);
    }

    private static class FormStatusImpl
    implements FormStatus {
        private boolean dirty;
        private Object _origin;
        private Set<String> _props = new HashSet<String>(1);

        private FormStatusImpl() {
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public boolean isDirty() {
            this._props.add("dirty");
            return this.dirty;
        }

        public void reset() {
        }

        public void submit(BindContext ctx) {
        }

        public Object getOrigin() {
            this._props.add("origin");
            return this._origin;
        }

        public void setOrigin(Object origin) {
            this._origin = origin;
        }

        public Set<String> getInvocationProps() {
            return this._props;
        }
    }
}

