/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.proxy.ProxyHelper;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.clientbind.ui.util.ObjectMappers;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.OperationException;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.util.Composer;

public class GsonConverter
extends org.zkoss.zkmax.bind.GsonConverter {
    public Object coerceToBean(Object compAttr, Component component, BindContext ctx) {
        Composer composer;
        if (compAttr != null && (composer = Components.getComposer((Component)component)) instanceof ClientBindComposer && compAttr instanceof JSONObject) {
            final ClientBindComposer clientBindComposer = (ClientBindComposer)composer;
            String id = (String)((JSONObject)compAttr).get((Object)"$id$");
            if (!Strings.isEmpty((String)id)) {
                Object cachedBean;
                boolean isForm = id.endsWith("$$");
                if (isForm) {
                    id = id.substring(0, id.length() - 2);
                }
                if ((cachedBean = clientBindComposer.getCachedBeanById(id)) != null) {
                    if (isForm) {
                        Object form;
                        try {
                            SimpleModule simpleModule = new SimpleModule();
                            simpleModule.setDeserializerModifier(new BeanDeserializerModifier(){

                                public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                                    if (deserializer instanceof BeanDeserializer) {
                                        return new MyDeserializer(clientBindComposer, (BeanDeserializer)deserializer);
                                    }
                                    return deserializer;
                                }
                            });
                            form = ObjectMappers.SETTER_OBJECT_MAPPER.copy().registerModule((Module)simpleModule).readValue(JSONValue.toJSONString((Object)((JSONObject)compAttr).get((Object)"value")), cachedBean.getClass());
                        }
                        catch (JsonProcessingException e) {
                            throw new OperationException("Unable to create a From Proxy Object, ", (Throwable)e);
                        }
                        clientBindComposer.setCachedBeanById(clientBindComposer.getBeanUid(form), id);
                        return ProxyHelper.createFormProxy((Object)form, form.getClass());
                    }
                    return cachedBean;
                }
            }
        }
        return super.coerceToBean(compAttr, component, ctx);
    }

    private static final class MyDeserializer
    extends BeanDeserializer {
        private ClientBindComposer composer;
        private Object current = null;

        public MyDeserializer(ClientBindComposer composer, BeanDeserializer deserializer) {
            super((BeanDeserializerBase)deserializer);
            this.composer = composer;
        }

        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            this.current = null;
            Object deserialize = super.deserialize(p, ctxt);
            if (this.current != null) {
                return this.current;
            }
            return deserialize;
        }

        protected void handleUnknownProperty(JsonParser p, DeserializationContext ctxt, Object beanOrClass, String propName) throws IOException {
            if ("$id$".equals(propName)) {
                String benaId = p.getValueAsString();
                this.current = this.composer.getCachedFormBeanById(benaId);
                if (this.current == null) {
                    this.current = beanOrClass;
                    this.composer.setCachedFormBeanById(benaId, this.current);
                }
            }
            super.handleUnknownProperty(p, ctxt, beanOrClass, propName);
        }

        protected void handleUnknownVanilla(JsonParser p, DeserializationContext ctxt, Object beanOrBuilder, String propName) throws IOException {
            if ("$id$".equals(propName)) {
                String benaId = p.getValueAsString();
                this.current = this.composer.getCachedFormBeanById(benaId);
                if (this.current == null) {
                    this.current = beanOrBuilder;
                    this.composer.setCachedFormBeanById(benaId, this.current);
                }
            }
            super.handleUnknownVanilla(p, ctxt, beanOrBuilder, propName);
        }
    }
}

