/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind.ui.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Validator;
import org.zkoss.bind.proxy.BeanProxyHandler;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.clientbind.ui.util.ObjectMappers;

class ClientBeanPropertyWriter
extends BeanPropertyWriter {
    ClientBindComposer owner;

    protected ClientBeanPropertyWriter(BeanPropertyWriter base) {
        super(base);
    }

    public void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        if (this._accessorMethod == null || !this._accessorMethod.getName().startsWith("get") && !this._accessorMethod.getName().startsWith("is")) {
            return;
        }
        Object value = this._accessorMethod.invoke(bean, (Object[])null);
        if (value instanceof Validator || value instanceof Converter) {
            return;
        }
        if (value == null) {
            gen.writeFieldName((SerializableString)this._name);
            ObjectMappers.serializeNULLObject(this._accessorMethod.getReturnType(), gen);
        } else {
            if (value instanceof BeanProxyHandler) {
                return;
            }
            JsonSerializer ser = this._serializer;
            if (ser == null) {
                PropertySerializerMap m = this._dynamicSerializers;
                Class<?> cls = value.getClass();
                ser = m.serializerFor(cls);
                if (ser == null) {
                    ser = this._findAndAddDynamic(m, cls, prov);
                }
            } else if (value instanceof Class && ((Class)value).isEnum()) {
                gen.writeFieldName((SerializableString)this._name);
                gen.writeStartArray();
                for (Object enumValue : ((Class)value).getEnumConstants()) {
                    gen.writeString(enumValue.toString());
                }
                gen.writeEndArray();
                return;
            }
            if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(prov, value) : this._suppressableValue.equals(value))) {
                return;
            }
            if (value != bean || !this._handleSelfReference(bean, gen, prov, ser)) {
                gen.writeFieldName((SerializableString)this._name);
                if (this._typeSerializer == null) {
                    ser.serialize(value, gen, prov);
                } else {
                    ser.serializeWithType(value, gen, prov, this._typeSerializer);
                }
            }
        }
    }
}

