!function(e,n){"object"==typeof exports&&"object"==typeof module?module.exports=n():"function"==typeof define&&define.amd?define([],n):"object"==typeof exports?exports.spel2js=n():e.spel2js=n()}(self,function(){"use strict";var __webpack_modules__={"./src/SpelExpressionEvaluator.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SpelExpressionEvaluator: function() { return /* binding */ spelExpressionEvaluator; }\n/* harmony export */ });\n/* harmony import */ var _SpelExpressionParser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelExpressionParser */ "./src/SpelExpressionParser.js");\n/* harmony import */ var _lib_Stack__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lib/Stack */ "./src/lib/Stack.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @author Ben March\n * @since 0.2.0\n */\n\n\n\nvar spelExpressionEvaluator = {};\nfunction evalCompiled(compiledExpression, context, locals) {\n  return compiledExpression.getValue(initState(context, locals));\n}\nfunction initState(context, locals) {\n  var activeContext = new _lib_Stack__WEBPACK_IMPORTED_MODULE_1__.Stack(),\n    state;\n  if (!context) {\n    context = {};\n  }\n  activeContext.push(context);\n  return {\n    rootContext: context,\n    activeContext: activeContext,\n    locals: locals\n  };\n}\nspelExpressionEvaluator.compile = function (expression) {\n  var compiledExpression = (0,_SpelExpressionParser__WEBPACK_IMPORTED_MODULE_0__.SpelExpressionParser)().parse(expression);\n  return {\n    expression: expression,\n    eval: function (context, locals) {\n      return evalCompiled(compiledExpression, context, locals);\n    },\n    _compiledExpression: compiledExpression,\n    initState: initState,\n    clone: function () {\n      return spelExpressionEvaluator.compile(expression);\n    }\n  };\n};\nspelExpressionEvaluator.eval = function (expression, context, locals) {\n  return spelExpressionEvaluator.compile(expression).eval(context, locals);\n};\n\n\n//# sourceURL=webpack://spel2js/./src/SpelExpressionEvaluator.js?')},"./src/SpelExpressionParser.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SpelExpressionParser: function() { return /* binding */ SpelExpressionParser; }\n/* harmony export */ });\n/* harmony import */ var _TokenKind__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TokenKind */ \"./src/TokenKind.js\");\n/* harmony import */ var _Tokenizer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Tokenizer */ \"./src/Tokenizer.js\");\n/* harmony import */ var _ast_BooleanLiteral__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ast/BooleanLiteral */ \"./src/ast/BooleanLiteral.js\");\n/* harmony import */ var _ast_NumberLiteral__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ast/NumberLiteral */ \"./src/ast/NumberLiteral.js\");\n/* harmony import */ var _ast_StringLiteral__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ast/StringLiteral */ \"./src/ast/StringLiteral.js\");\n/* harmony import */ var _ast_NullLiteral__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ast/NullLiteral */ \"./src/ast/NullLiteral.js\");\n/* harmony import */ var _ast_FunctionReference__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ast/FunctionReference */ \"./src/ast/FunctionReference.js\");\n/* harmony import */ var _ast_MethodReference__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ast/MethodReference */ \"./src/ast/MethodReference.js\");\n/* harmony import */ var _ast_PropertyReference__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ast/PropertyReference */ \"./src/ast/PropertyReference.js\");\n/* harmony import */ var _ast_VariableReference__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ast/VariableReference */ \"./src/ast/VariableReference.js\");\n/* harmony import */ var _ast_CompoundExpression__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ast/CompoundExpression */ \"./src/ast/CompoundExpression.js\");\n/* harmony import */ var _ast_Indexer__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ast/Indexer */ \"./src/ast/Indexer.js\");\n/* harmony import */ var _ast_Assign__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./ast/Assign */ \"./src/ast/Assign.js\");\n/* harmony import */ var _ast_OpEQ__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./ast/OpEQ */ \"./src/ast/OpEQ.js\");\n/* harmony import */ var _ast_OpNE__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./ast/OpNE */ \"./src/ast/OpNE.js\");\n/* harmony import */ var _ast_OpGE__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./ast/OpGE */ \"./src/ast/OpGE.js\");\n/* harmony import */ var _ast_OpGT__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./ast/OpGT */ \"./src/ast/OpGT.js\");\n/* harmony import */ var _ast_OpLE__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./ast/OpLE */ \"./src/ast/OpLE.js\");\n/* harmony import */ var _ast_OpLT__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./ast/OpLT */ \"./src/ast/OpLT.js\");\n/* harmony import */ var _ast_OpPlus__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./ast/OpPlus */ \"./src/ast/OpPlus.js\");\n/* harmony import */ var _ast_OpMinus__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./ast/OpMinus */ \"./src/ast/OpMinus.js\");\n/* harmony import */ var _ast_OpMultiply__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./ast/OpMultiply */ \"./src/ast/OpMultiply.js\");\n/* harmony import */ var _ast_OpDivide__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./ast/OpDivide */ \"./src/ast/OpDivide.js\");\n/* harmony import */ var _ast_OpModulus__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./ast/OpModulus */ \"./src/ast/OpModulus.js\");\n/* harmony import */ var _ast_OpPower__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./ast/OpPower */ \"./src/ast/OpPower.js\");\n/* harmony import */ var _ast_OpInc__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./ast/OpInc */ \"./src/ast/OpInc.js\");\n/* harmony import */ var _ast_OpDec__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./ast/OpDec */ \"./src/ast/OpDec.js\");\n/* harmony import */ var _ast_OpNot__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./ast/OpNot */ \"./src/ast/OpNot.js\");\n/* harmony import */ var _ast_OpAnd__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./ast/OpAnd */ \"./src/ast/OpAnd.js\");\n/* harmony import */ var _ast_OpOr__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./ast/OpOr */ \"./src/ast/OpOr.js\");\n/* harmony import */ var _ast_OpMatches__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./ast/OpMatches */ \"./src/ast/OpMatches.js\");\n/* harmony import */ var _ast_Ternary__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./ast/Ternary */ \"./src/ast/Ternary.js\");\n/* harmony import */ var _ast_Elvis__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./ast/Elvis */ \"./src/ast/Elvis.js\");\n/* harmony import */ var _ast_InlineList__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./ast/InlineList */ \"./src/ast/InlineList.js\");\n/* harmony import */ var _ast_InlineMap__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./ast/InlineMap */ \"./src/ast/InlineMap.js\");\n/* harmony import */ var _ast_Selection__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./ast/Selection */ \"./src/ast/Selection.js\");\n/* harmony import */ var _ast_Projection__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./ast/Projection */ \"./src/ast/Projection.js\");\n/* harmony import */ var _ast_OpInstanceof__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./ast/OpInstanceof */ \"./src/ast/OpInstanceof.js\");\n/* harmony import */ var _ast_OpBetween__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./ast/OpBetween */ \"./src/ast/OpBetween.js\");\n/* harmony import */ var _ast_TypeReference__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./ast/TypeReference */ \"./src/ast/TypeReference.js\");\n/* harmony import */ var _ast_BeanReference__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./ast/BeanReference */ \"./src/ast/BeanReference.js\");\n/* harmony import */ var _ast_Identifier__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./ast/Identifier */ \"./src/ast/Identifier.js\");\n/* harmony import */ var _ast_QualifiedIdentifier__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./ast/QualifiedIdentifier */ \"./src/ast/QualifiedIdentifier.js\");\n/* harmony import */ var _ast_ConstructorReference__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./ast/ConstructorReference */ \"./src/ast/ConstructorReference.js\");\n/* harmony import */ var _ast_OpEmpty__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./ast/OpEmpty */ \"./src/ast/OpEmpty.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Ben March\n * @since 0.2.0\n *\n */\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n//not yet implemented\n\n\n\n\n\n\n\n\nvar SpelExpressionParser = function () {\n  var VALID_QUALIFIED_ID_PATTERN = new RegExp('[\\\\p{L}\\\\p{N}_$]+');\n  var configuration;\n\n  // For rules that build nodes, they are stacked here for return\n  var constructedNodes = [];\n\n  // The expression being parsed\n  var expressionString;\n\n  // The token stream constructed from that expression string\n  var tokenStream;\n\n  // length of a populated token stream\n  var tokenStreamLength;\n\n  // Current location in the token stream when processing tokens\n  var tokenStreamPointer;\n\n  /**\n   * Create a parser with some configured behavior.\n   * @param config custom configuration options\n   */\n  function setConfiguration(config) {\n    configuration = config;\n  }\n  function parse(expression, context) {\n    try {\n      expressionString = expression;\n      tokenStream = _Tokenizer__WEBPACK_IMPORTED_MODULE_1__.Tokenizer.tokenize(expression);\n      tokenStreamLength = tokenStream.length;\n      tokenStreamPointer = 0;\n      constructedNodes = [];\n      var ast = eatExpression();\n      if (moreTokens()) {\n        raiseInternalException(peekToken().startPos, 'MORE_INPUT', nextToken().toString());\n      }\n      //Assert.isTrue(this.constructedNodes.isEmpty());\n      return ast;\n    } catch (e) {\n      throw e.message;\n    }\n  }\n\n  //\texpression\n  //    : logicalOrExpression\n  //      ( (ASSIGN^ logicalOrExpression)\n  //\t    | (DEFAULT^ logicalOrExpression)\n  //\t    | (QMARK^ expression COLON! expression)\n  //      | (ELVIS^ expression))?;\n  function eatExpression(prevToken) {\n    var expr = eatLogicalOrExpression();\n    if (moreTokens()) {\n      var token = peekToken();\n      if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.ASSIGN) {\n        // a=b\n        if (expr === null) {\n          expr = _ast_NullLiteral__WEBPACK_IMPORTED_MODULE_5__.NullLiteral.create(toPosBounds(token.startPos - 1, token.endPos - 1));\n        }\n        nextToken();\n        var assignedValue = eatLogicalOrExpression();\n        return _ast_Assign__WEBPACK_IMPORTED_MODULE_12__.Assign.create(toPosToken(token), expr, assignedValue);\n      }\n      if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.ELVIS) {\n        // a?:b (a if it isn't null, otherwise b)\n        if (expr === null) {\n          expr = _ast_NullLiteral__WEBPACK_IMPORTED_MODULE_5__.NullLiteral.create(toPosBounds(token.startPos - 1, token.endPos - 2));\n        }\n        nextToken(); // elvis has left the building\n        var valueIfNull = eatExpression();\n        if (valueIfNull === null) {\n          valueIfNull = _ast_NullLiteral__WEBPACK_IMPORTED_MODULE_5__.NullLiteral.create(toPosBounds(token.startPos + 1, token.endPos + 1));\n        }\n        return _ast_Elvis__WEBPACK_IMPORTED_MODULE_32__.Elvis.create(toPosToken(token), expr, valueIfNull);\n      }\n      if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.QMARK) {\n        // a?b:c\n        if (expr === null) {\n          expr = _ast_NullLiteral__WEBPACK_IMPORTED_MODULE_5__.NullLiteral.create(toPosBounds(token.startPos - 1, token.endPos - 1));\n        }\n        nextToken();\n        var ifTrueExprValue = eatExpression(token);\n        eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.COLON);\n        var ifFalseExprValue = eatExpression();\n        return _ast_Ternary__WEBPACK_IMPORTED_MODULE_31__.Ternary.create(toPosToken(token), expr, ifTrueExprValue, ifFalseExprValue);\n      }\n\n      /* James Chu, Potix, 20220127, support taglib */\n      if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.COLON && !(prevToken && prevToken.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.QMARK)) {\n        // taglib, ex. c:concat\n        var prev = tokenStream[tokenStreamPointer - 1];\n        nextToken();\n        var methodOrPropertyName = nextToken(),\n          args = maybeEatMethodArgs();\n        if (prev && prev.kind === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.IDENTIFIER) {\n          methodOrPropertyName.data = prev.data + ':' + methodOrPropertyName.data;\n        }\n        return _ast_MethodReference__WEBPACK_IMPORTED_MODULE_7__.MethodReference.create(false, methodOrPropertyName.stringValue(), toPosToken(methodOrPropertyName), args);\n      }\n    }\n    return expr;\n  }\n\n  //logicalOrExpression : logicalAndExpression (OR^ logicalAndExpression)*;\n  function eatLogicalOrExpression() {\n    var expr = eatLogicalAndExpression();\n    while (peekIdentifierToken('or') || peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.SYMBOLIC_OR)) {\n      var token = nextToken(); //consume OR\n      var rhExpr = eatLogicalAndExpression();\n      checkOperands(token, expr, rhExpr);\n      expr = _ast_OpOr__WEBPACK_IMPORTED_MODULE_29__.OpOr.create(toPosToken(token), expr, rhExpr);\n    }\n    return expr;\n  }\n\n  // logicalAndExpression : relationalExpression (AND^ relationalExpression)*;\n  function eatLogicalAndExpression() {\n    var expr = eatRelationalExpression();\n    while (peekIdentifierToken('and') || peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.SYMBOLIC_AND)) {\n      var token = nextToken(); // consume 'AND'\n      var rhExpr = eatRelationalExpression();\n      checkOperands(token, expr, rhExpr);\n      expr = _ast_OpAnd__WEBPACK_IMPORTED_MODULE_28__.OpAnd.create(toPosToken(token), expr, rhExpr);\n    }\n    return expr;\n  }\n\n  // relationalExpression : sumExpression (relationalOperator^ sumExpression)?;\n  function eatRelationalExpression() {\n    var expr = eatSumExpression();\n    var relationalOperatorToken = maybeEatRelationalOperator();\n    if (relationalOperatorToken !== null) {\n      var token = nextToken(); // consume relational operator token\n      var rhExpr = eatSumExpression();\n      checkOperands(token, expr, rhExpr);\n      var tk = relationalOperatorToken.kind;\n      if (relationalOperatorToken.isNumericRelationalOperator()) {\n        var pos = toPosToken(token);\n        if (tk === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.GT) {\n          return _ast_OpGT__WEBPACK_IMPORTED_MODULE_16__.OpGT.create(pos, expr, rhExpr);\n        }\n        if (tk === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LT) {\n          return _ast_OpLT__WEBPACK_IMPORTED_MODULE_18__.OpLT.create(pos, expr, rhExpr);\n        }\n        if (tk === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LE) {\n          return _ast_OpLE__WEBPACK_IMPORTED_MODULE_17__.OpLE.create(pos, expr, rhExpr);\n        }\n        if (tk === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.GE) {\n          return _ast_OpGE__WEBPACK_IMPORTED_MODULE_15__.OpGE.create(pos, expr, rhExpr);\n        }\n        if (tk === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.EQ) {\n          return _ast_OpEQ__WEBPACK_IMPORTED_MODULE_13__.OpEQ.create(pos, expr, rhExpr);\n        }\n        //Assert.isTrue(tk === TokenKind.NE);\n        return _ast_OpNE__WEBPACK_IMPORTED_MODULE_14__.OpNE.create(pos, expr, rhExpr);\n      }\n      if (tk === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.INSTANCEOF) {\n        return _ast_OpInstanceof__WEBPACK_IMPORTED_MODULE_37__.OpInstanceof.create(toPosToken(token), expr, rhExpr);\n      }\n      if (tk === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.MATCHES) {\n        return _ast_OpMatches__WEBPACK_IMPORTED_MODULE_30__.OpMatches.create(toPosToken(token), expr, rhExpr);\n      }\n\n      //Assert.isTrue(tk === TokenKind.BETWEEN);\n      return _ast_OpBetween__WEBPACK_IMPORTED_MODULE_38__.OpBetween.create(toPosToken(token), expr, rhExpr);\n    }\n    return expr;\n  }\n\n  //sumExpression: productExpression ( (PLUS^ | MINUS^) productExpression)*;\n  function eatSumExpression() {\n    var expr = eatProductExpression();\n    while (peekTokenAny(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.PLUS, _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.MINUS, _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.INC)) {\n      var token = nextToken(); //consume PLUS or MINUS or INC\n      var rhExpr = eatProductExpression();\n      if (!rhExpr) {\n        if (peekToken().getKind() == _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.ASSIGN) {\n          // ignore '+=' case\n          nextToken();\n          rhExpr = eatProductExpression();\n        }\n      }\n      checkRightOperand(token, rhExpr);\n      if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.PLUS) {\n        expr = _ast_OpPlus__WEBPACK_IMPORTED_MODULE_19__.OpPlus.create(toPosToken(token), expr, rhExpr);\n      } else if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.MINUS) {\n        expr = _ast_OpMinus__WEBPACK_IMPORTED_MODULE_20__.OpMinus.create(toPosToken(token), expr, rhExpr);\n      }\n    }\n    return expr;\n  }\n\n  // productExpression: powerExpr ((STAR^ | DIV^| MOD^) powerExpr)* ;\n  function eatProductExpression() {\n    var expr = eatPowerIncDecExpression();\n    while (peekTokenAny(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.STAR, _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.DIV, _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.MOD)) {\n      var token = nextToken(); // consume STAR/DIV/MOD\n      var rhExpr = eatPowerIncDecExpression();\n      checkOperands(token, expr, rhExpr);\n      if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.STAR) {\n        expr = _ast_OpMultiply__WEBPACK_IMPORTED_MODULE_21__.OpMultiply.create(toPosToken(token), expr, rhExpr);\n      } else if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.DIV) {\n        expr = _ast_OpDivide__WEBPACK_IMPORTED_MODULE_22__.OpDivide.create(toPosToken(token), expr, rhExpr);\n      } else {\n        //Assert.isTrue(token.getKind() === TokenKind.MOD);\n        expr = _ast_OpModulus__WEBPACK_IMPORTED_MODULE_23__.OpModulus.create(toPosToken(token), expr, rhExpr);\n      }\n    }\n    return expr;\n  }\n\n  // powerExpr  : unaryExpression (POWER^ unaryExpression)? (INC || DEC) ;\n  function eatPowerIncDecExpression() {\n    var expr = eatUnaryExpression(),\n      token;\n    if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.POWER)) {\n      token = nextToken(); //consume POWER\n      var rhExpr = eatUnaryExpression();\n      checkRightOperand(token, rhExpr);\n      return _ast_OpPower__WEBPACK_IMPORTED_MODULE_24__.OpPower.create(toPosToken(token), expr, rhExpr);\n    }\n    if (expr !== null && peekTokenAny(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.INC, _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.DEC)) {\n      token = nextToken(); //consume INC/DEC\n      if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.INC) {\n        return _ast_OpInc__WEBPACK_IMPORTED_MODULE_25__.OpInc.create(toPosToken(token), true, expr);\n      }\n      return _ast_OpDec__WEBPACK_IMPORTED_MODULE_26__.OpDec.create(toPosToken(token), true, expr);\n    }\n    return expr;\n  }\n\n  // unaryExpression: (PLUS^ | MINUS^ | BANG^ | INC^ | DEC^) unaryExpression | primaryExpression ;\n  function eatUnaryExpression() {\n    var token, expr;\n    if (peekTokenAny(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.PLUS, _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.MINUS, _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.NOT)) {\n      token = nextToken();\n      expr = eatUnaryExpression();\n      if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.NOT) {\n        return _ast_OpNot__WEBPACK_IMPORTED_MODULE_27__.OpNot.create(toPosToken(token), expr);\n      }\n      if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.PLUS) {\n        return _ast_OpPlus__WEBPACK_IMPORTED_MODULE_19__.OpPlus.create(toPosToken(token), expr);\n      }\n      //Assert.isTrue(token.getKind() === TokenKind.MINUS);\n      return _ast_OpMinus__WEBPACK_IMPORTED_MODULE_20__.OpMinus.create(toPosToken(token), expr);\n    }\n    if (peekTokenAny(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.INC, _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.DEC)) {\n      token = nextToken();\n      expr = eatUnaryExpression();\n      if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.INC) {\n        return _ast_OpInc__WEBPACK_IMPORTED_MODULE_25__.OpInc.create(toPosToken(token), false, expr);\n      }\n      return _ast_OpDec__WEBPACK_IMPORTED_MODULE_26__.OpDec.create(toPosToken(token), false, expr);\n    }\n    return eatPrimaryExpression();\n  }\n\n  // primaryExpression : startNode (node)? -> ^(EXPRESSION startNode (node)?);\n  function eatPrimaryExpression() {\n    var nodes = [];\n    var start = eatStartNode(); // always a start node\n    nodes.push(start);\n    while (maybeEatNode()) {\n      nodes.push(pop());\n    }\n    if (nodes.length === 1) {\n      return nodes[0];\n    }\n    return _ast_CompoundExpression__WEBPACK_IMPORTED_MODULE_10__.CompoundExpression.create(toPosBounds(start.getStartPosition(), nodes[nodes.length - 1].getEndPosition()), nodes);\n  }\n\n  // node : ((DOT dottedNode) | (SAFE_NAVI dottedNode) | nonDottedNode)+;\n  function maybeEatNode() {\n    var expr = null;\n    if (peekTokenAny(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.DOT, _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.SAFE_NAVI)) {\n      expr = eatDottedNode();\n    } else {\n      expr = maybeEatNonDottedNode();\n    }\n    if (expr === null) {\n      return false;\n    } else {\n      push(expr);\n      return true;\n    }\n  }\n\n  // nonDottedNode: indexer;\n  function maybeEatNonDottedNode() {\n    if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LSQUARE)) {\n      if (maybeEatIndexer()) {\n        return pop();\n      }\n    }\n    return null;\n  }\n\n  //dottedNode\n  // : ((methodOrProperty\n  //\t  | functionOrVar\n  //    | projection\n  //    | selection\n  //    | firstSelection\n  //    | lastSelection\n  //    ))\n  //\t;\n  function eatDottedNode() {\n    var token = nextToken(); // it was a '.' or a '?.'\n    var nullSafeNavigation = token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.SAFE_NAVI;\n    if (maybeEatMethodOrProperty(nullSafeNavigation) || maybeEatFunctionOrVar() || maybeEatProjection(nullSafeNavigation) || maybeEatSelection(nullSafeNavigation)) {\n      return pop();\n    }\n    if (peekToken() === null) {\n      // unexpectedly ran out of data\n      raiseInternalException(token.startPos, 'OOD');\n    } else {\n      raiseInternalException(token.startPos, 'UNEXPECTED_DATA_AFTER_DOT', toString(peekToken()));\n    }\n    return null;\n  }\n\n  // functionOrVar\n  // : (POUND ID LPAREN) => function\n  // | var\n  //\n  // function : POUND id=ID methodArgs -> ^(FUNCTIONREF[$id] methodArgs);\n  // var : POUND id=ID -> ^(VARIABLEREF[$id]);\n  function maybeEatFunctionOrVar() {\n    if (!peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.HASH)) {\n      return false;\n    }\n    var token = nextToken();\n    var functionOrVariableName = eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.IDENTIFIER);\n    var args = maybeEatMethodArgs();\n    if (args === null) {\n      push(_ast_VariableReference__WEBPACK_IMPORTED_MODULE_9__.VariableReference.create(functionOrVariableName.data, toPosBounds(token.startPos, functionOrVariableName.endPos)));\n      return true;\n    }\n    push(_ast_FunctionReference__WEBPACK_IMPORTED_MODULE_6__.FunctionReference.create(functionOrVariableName.data, toPosBounds(token.startPos, functionOrVariableName.endPos), args));\n    return true;\n  }\n\n  // methodArgs : LPAREN! (argument (COMMA! argument)* (COMMA!)?)? RPAREN!;\n  function maybeEatMethodArgs() {\n    if (!peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LPAREN)) {\n      return null;\n    }\n    var args = [];\n    consumeArguments(args);\n    eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RPAREN);\n    return args;\n  }\n  function eatConstructorArgs(accumulatedArguments) {\n    if (!peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LPAREN)) {\n      raiseInternalException(toPosToken(peekToken()), 'MISSING_CONSTRUCTOR_ARGS');\n    }\n    consumeArguments(accumulatedArguments);\n    eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RPAREN);\n  }\n\n  /**\n   * Used for consuming arguments for either a method or a constructor call\n   */\n  function consumeArguments(accumulatedArguments) {\n    var pos = peekToken().startPos;\n    var next;\n    do {\n      nextToken(); // consume ( (first time through) or comma (subsequent times)\n      var token = peekToken();\n      if (token === null) {\n        raiseInternalException(pos, 'RUN_OUT_OF_ARGUMENTS');\n      }\n      if (token.getKind() !== _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RPAREN) {\n        accumulatedArguments.push(eatExpression());\n      }\n      next = peekToken();\n    } while (next !== null && next.kind === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.COMMA);\n    if (next === null) {\n      raiseInternalException(pos, 'RUN_OUT_OF_ARGUMENTS');\n    }\n  }\n  function positionOf(token) {\n    if (token === null) {\n      // if null assume the problem is because the right token was\n      // not found at the end of the expression\n      return expressionString.length;\n    }\n    return token.startPos;\n  }\n\n  //startNode\n  // : parenExpr | literal\n  //\t    | type\n  //\t    | methodOrProperty\n  //\t    | functionOrVar\n  //\t    | projection\n  //\t    | selection\n  //\t    | firstSelection\n  //\t    | lastSelection\n  //\t    | indexer\n  //\t    | constructor\n  function eatStartNode() {\n    if (maybeEatLiteral()) {\n      return pop();\n    } else if (maybeEatParenExpression()) {\n      return pop();\n    } else if (maybeEatTypeReference() || maybeEatNullReference() || maybeEatConstructorReference() || maybeEatMethodOrProperty(false) || maybeEatFunctionOrVar()) {\n      return pop();\n    } else if (maybeEatBeanReference()) {\n      return pop();\n    } else if (maybeEatProjection(false) || maybeEatSelection(false) || maybeEatIndexer()) {\n      return pop();\n    } else if (maybeEatInlineListOrMap()) {\n      return pop();\n    } else {\n      return null;\n    }\n  }\n\n  // parse: @beanname @'bean.name'\n  // quoted if dotted\n  function maybeEatBeanReference() {\n    if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.BEAN_REF)) {\n      var beanRefToken = nextToken();\n      var beanNameToken = null;\n      var beanName = null;\n      if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.IDENTIFIER)) {\n        beanNameToken = eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.IDENTIFIER);\n        beanName = beanNameToken.data;\n      } else if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LITERAL_STRING)) {\n        beanNameToken = eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LITERAL_STRING);\n        beanName = beanNameToken.stringValue();\n        beanName = beanName.substring(1, beanName.length() - 1);\n      } else {\n        raiseInternalException(beanRefToken.startPos, 'INVALID_BEAN_REFERENCE');\n      }\n      var beanReference = _ast_BeanReference__WEBPACK_IMPORTED_MODULE_40__.BeanReference.create(toPosToken(beanNameToken), beanName);\n      push(beanReference);\n      return true;\n    }\n    return false;\n  }\n  function maybeEatTypeReference() {\n    if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.IDENTIFIER)) {\n      var typeName = peekToken();\n      if (typeName.stringValue() !== 'T') {\n        return false;\n      }\n      // It looks like a type reference but is T being used as a map key?\n      var token = nextToken();\n      if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RSQUARE)) {\n        // looks like 'T]' (T is map key)\n        push(_ast_PropertyReference__WEBPACK_IMPORTED_MODULE_8__.PropertyReference.create(token.stringValue(), toPosToken(token)));\n        return true;\n      }\n      eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LPAREN);\n      var node = eatPossiblyQualifiedId();\n      // dotted qualified id\n      // Are there array dimensions?\n      var dims = 0;\n      while (peekTokenConsumeIfMatched(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LSQUARE, true)) {\n        eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RSQUARE);\n        dims++;\n      }\n      eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RPAREN);\n      push(_ast_TypeReference__WEBPACK_IMPORTED_MODULE_39__.TypeReference.create(toPosToken(typeName), node, dims));\n      return true;\n    }\n    return false;\n  }\n  function maybeEatNullReference() {\n    if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.IDENTIFIER)) {\n      var nullToken = peekToken();\n      if (nullToken.stringValue().toLowerCase() !== 'null') {\n        return false;\n      }\n      nextToken();\n      push(_ast_NullLiteral__WEBPACK_IMPORTED_MODULE_5__.NullLiteral.create(toPosToken(nullToken)));\n      return true;\n    }\n    return false;\n  }\n\n  //projection: PROJECT^ expression RCURLY!;\n  function maybeEatProjection(nullSafeNavigation) {\n    var token = peekToken();\n    if (!peekTokenConsumeIfMatched(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.PROJECT, true)) {\n      return false;\n    }\n    var expr = eatExpression();\n    eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RSQUARE);\n    push(_ast_Projection__WEBPACK_IMPORTED_MODULE_36__.Projection.create(nullSafeNavigation, toPosToken(token), expr));\n    return true;\n  }\n\n  // list = LCURLY (element (COMMA element)*) RCURLY\n  // map  = LCURLY (key ':' value (COMMA key ':' value)*) RCURLY\n  function maybeEatInlineListOrMap() {\n    var token = peekToken(),\n      listElements = [];\n    var expr = null;\n    if (!peekTokenConsumeIfMatched(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LCURLY, true)) {\n      return false;\n    }\n    var closingCurly = peekToken();\n    if (peekTokenConsumeIfMatched(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RCURLY, true)) {\n      // empty list '{}'\n      expr = _ast_InlineList__WEBPACK_IMPORTED_MODULE_33__.InlineList.create(toPosBounds(token.startPos, closingCurly.endPos));\n    } else if (peekTokenConsumeIfMatched(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.COLON, true)) {\n      closingCurly = eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RCURLY);\n      // empty map '{:}'\n      expr = _ast_InlineMap__WEBPACK_IMPORTED_MODULE_34__.InlineMap.create(toPosBounds(token.startPos, closingCurly.endPos));\n    } else {\n      var firstExpression = eatExpression();\n      // Next is either:\n      // '}' - end of list\n      // ',' - more expressions in this list\n      // ':' - this is a map!\n\n      if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RCURLY)) {\n        // list with one item in it\n        listElements.push(firstExpression);\n        closingCurly = eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RCURLY);\n        expr = _ast_InlineList__WEBPACK_IMPORTED_MODULE_33__.InlineList.create(toPosBounds(token.startPos, closingCurly.endPos), listElements);\n      } else if (peekTokenConsumeIfMatched(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.COMMA, true)) {\n        // multi item list\n        listElements.push(firstExpression);\n        do {\n          listElements.push(eatExpression());\n        } while (peekTokenConsumeIfMatched(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.COMMA, true));\n        closingCurly = eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RCURLY);\n        expr = _ast_InlineList__WEBPACK_IMPORTED_MODULE_33__.InlineList.create(toPosToken(token.startPos, closingCurly.endPos), listElements);\n      } else if (peekTokenConsumeIfMatched(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.COLON, true)) {\n        // map!\n        var mapElements = [];\n        mapElements.push(firstExpression);\n        mapElements.push(eatExpression());\n        while (peekTokenConsumeIfMatched(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.COMMA, true)) {\n          mapElements.push(eatExpression());\n          eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.COLON);\n          mapElements.push(eatExpression());\n        }\n        closingCurly = eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RCURLY);\n        expr = _ast_InlineMap__WEBPACK_IMPORTED_MODULE_34__.InlineMap.create(toPosBounds(token.startPos, closingCurly.endPos), mapElements);\n      } else {\n        raiseInternalException(token.startPos, 'OOD');\n      }\n    }\n    push(expr);\n    return true;\n  }\n  function maybeEatIndexer() {\n    var token = peekToken();\n    if (!peekTokenConsumeIfMatched(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LSQUARE, true)) {\n      return false;\n    }\n    var expr = eatExpression();\n    eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RSQUARE);\n    if (expr) {\n      push(_ast_Indexer__WEBPACK_IMPORTED_MODULE_11__.Indexer.create(toPosToken(token), expr));\n    } else {\n      push(_ast_InlineList__WEBPACK_IMPORTED_MODULE_33__.InlineList.create(toPosToken(token)));\n    }\n    return true;\n  }\n  function maybeEatSelection(nullSafeNavigation) {\n    var token = peekToken();\n    if (!peekSelectToken()) {\n      return false;\n    }\n    nextToken();\n    var expr = eatExpression();\n    if (expr === null) {\n      raiseInternalException(toPosToken(token), 'MISSING_SELECTION_EXPRESSION');\n    }\n    eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RSQUARE);\n    if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.SELECT_FIRST) {\n      push(_ast_Selection__WEBPACK_IMPORTED_MODULE_35__.Selection.create(nullSafeNavigation, _ast_Selection__WEBPACK_IMPORTED_MODULE_35__.Selection.FIRST, toPosToken(token), expr));\n    } else if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.SELECT_LAST) {\n      push(_ast_Selection__WEBPACK_IMPORTED_MODULE_35__.Selection.create(nullSafeNavigation, _ast_Selection__WEBPACK_IMPORTED_MODULE_35__.Selection.LAST, toPosToken(token), expr));\n    } else {\n      push(_ast_Selection__WEBPACK_IMPORTED_MODULE_35__.Selection.create(nullSafeNavigation, _ast_Selection__WEBPACK_IMPORTED_MODULE_35__.Selection.ALL, toPosToken(token), expr));\n    }\n    return true;\n  }\n\n  /**\n   * Eat an identifier, possibly qualified (meaning that it is dotted).\n   * TODO AndyC Could create complete identifiers (a.b.c) here rather than a sequence of them? (a, b, c)\n   */\n  function eatPossiblyQualifiedId() {\n    var qualifiedIdPieces = [];\n    var node = peekToken();\n    while (isValidQualifiedId(node)) {\n      nextToken();\n      if (node.kind !== _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.DOT) {\n        qualifiedIdPieces.push(_ast_Identifier__WEBPACK_IMPORTED_MODULE_41__.Identifier.create(node.stringValue(), toPosToken(node)));\n      }\n      node = peekToken();\n    }\n    if (!qualifiedIdPieces.length) {\n      if (node === null) {\n        raiseInternalException(expressionString.length(), 'OOD');\n      }\n      raiseInternalException(node.startPos, 'NOT_EXPECTED_TOKEN', 'qualified ID', node.getKind().toString().toLowerCase());\n    }\n    var pos = toPosBounds(qualifiedIdPieces[0].getStartPosition(), qualifiedIdPieces[qualifiedIdPieces.length - 1].getEndPosition());\n    return _ast_QualifiedIdentifier__WEBPACK_IMPORTED_MODULE_42__.QualifiedIdentifier.create(pos, qualifiedIdPieces);\n  }\n  function isValidQualifiedId(node) {\n    if (node === null || node.kind === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LITERAL_STRING) {\n      return false;\n    }\n    if (node.kind === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.DOT || node.kind === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.IDENTIFIER) {\n      return true;\n    }\n    var value = node.stringValue();\n    return value && value.length && VALID_QUALIFIED_ID_PATTERN.test(value);\n  }\n\n  // This is complicated due to the support for dollars in identifiers.  Dollars are normally separate tokens but\n  // there we want to combine a series of identifiers and dollars into a single identifier\n  function maybeEatMethodOrProperty(nullSafeNavigation) {\n    if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.IDENTIFIER)) {\n      var methodOrPropertyName = nextToken();\n      var args = maybeEatMethodArgs();\n      if (args === null) {\n        // property\n        push(_ast_PropertyReference__WEBPACK_IMPORTED_MODULE_8__.PropertyReference.create(nullSafeNavigation, methodOrPropertyName.stringValue(), toPosToken(methodOrPropertyName)));\n        return true;\n      }\n      // methodreference\n      push(_ast_MethodReference__WEBPACK_IMPORTED_MODULE_7__.MethodReference.create(nullSafeNavigation, methodOrPropertyName.stringValue(), toPosToken(methodOrPropertyName), args));\n      // TODO what is the end position for a method reference? the name or the last arg?\n      return true;\n    }\n    /* James Chu, Potix, 20220211, support op empty */\n    if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.EMPTY)) {\n      nextToken();\n      push(_ast_OpEmpty__WEBPACK_IMPORTED_MODULE_44__.OpEmpty.create(toPosToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.EMPTY), eatUnaryExpression()));\n      return true;\n    }\n    return false;\n  }\n\n  //constructor\n  //:\t('new' qualifiedId LPAREN) => 'new' qualifiedId ctorArgs -> ^(CONSTRUCTOR qualifiedId ctorArgs)\n  function maybeEatConstructorReference() {\n    if (peekIdentifierToken('new')) {\n      var newToken = nextToken();\n      // It looks like a constructor reference but is NEW being used as a map key?\n      if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RSQUARE)) {\n        // looks like 'NEW]' (so NEW used as map key)\n        push(_ast_PropertyReference__WEBPACK_IMPORTED_MODULE_8__.PropertyReference.create(newToken.stringValue(), toPosToken(newToken)));\n        return true;\n      }\n      var possiblyQualifiedConstructorName = eatPossiblyQualifiedId();\n      var nodes = [];\n      nodes.push(possiblyQualifiedConstructorName);\n      if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LSQUARE)) {\n        // array initializer\n        var dimensions = [];\n        while (peekTokenConsumeIfMatched(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LSQUARE, true)) {\n          if (!peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RSQUARE)) {\n            dimensions.push(eatExpression());\n          } else {\n            dimensions.push(null);\n          }\n          eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RSQUARE);\n        }\n        if (maybeEatInlineListOrMap()) {\n          nodes.push(pop());\n        }\n        push(_ast_ConstructorReference__WEBPACK_IMPORTED_MODULE_43__.ConstructorReference.create(toPosToken(newToken), dimensions, nodes));\n      } else {\n        // regular constructor invocation\n        eatConstructorArgs(nodes);\n        // TODO correct end position?\n        push(_ast_ConstructorReference__WEBPACK_IMPORTED_MODULE_43__.ConstructorReference.create(toPosToken(newToken), nodes));\n      }\n      return true;\n    }\n    return false;\n  }\n  function push(newNode) {\n    constructedNodes.push(newNode);\n  }\n  function pop() {\n    return constructedNodes.pop();\n  }\n\n  //\tliteral\n  //  : INTEGER_LITERAL\n  //\t| boolLiteral\n  //\t| STRING_LITERAL\n  //  | HEXADECIMAL_INTEGER_LITERAL\n  //  | REAL_LITERAL\n  //\t| DQ_STRING_LITERAL\n  //\t| NULL_LITERAL\n  function maybeEatLiteral() {\n    var token = peekToken();\n    if (token === null) {\n      return false;\n    }\n    if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LITERAL_INT || token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LITERAL_LONG) {\n      push(_ast_NumberLiteral__WEBPACK_IMPORTED_MODULE_3__.NumberLiteral.create(parseInt(token.stringValue(), 10), toPosToken(token)));\n    } else if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LITERAL_REAL || token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LITERAL_REAL_FLOAT) {\n      push(_ast_NumberLiteral__WEBPACK_IMPORTED_MODULE_3__.NumberLiteral.create(parseFloat(token.stringValue()), toPosToken(token)));\n    } else if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LITERAL_HEXINT || token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LITERAL_HEXLONG) {\n      push(_ast_NumberLiteral__WEBPACK_IMPORTED_MODULE_3__.NumberLiteral.create(parseInt(token.stringValue(), 16), toPosToken(token)));\n    } else if (peekIdentifierToken('true')) {\n      push(_ast_BooleanLiteral__WEBPACK_IMPORTED_MODULE_2__.BooleanLiteral.create(true, toPosToken(token)));\n    } else if (peekIdentifierToken('false')) {\n      push(_ast_BooleanLiteral__WEBPACK_IMPORTED_MODULE_2__.BooleanLiteral.create(false, toPosToken(token)));\n    } else if (token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LITERAL_STRING) {\n      push(_ast_StringLiteral__WEBPACK_IMPORTED_MODULE_4__.StringLiteral.create(token.stringValue(), toPosToken(token)));\n    } else {\n      return false;\n    }\n    nextToken();\n    return true;\n  }\n\n  //parenExpr : LPAREN! expression RPAREN!;\n  function maybeEatParenExpression() {\n    if (peekTokenOne(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LPAREN)) {\n      nextToken();\n      var expr = eatExpression();\n      eatToken(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.RPAREN);\n      push(expr);\n      return true;\n    } else {\n      return false;\n    }\n  }\n\n  // relationalOperator\n  // : EQUAL | NOT_EQUAL | LESS_THAN | LESS_THAN_OR_EQUAL | GREATER_THAN\n  // | GREATER_THAN_OR_EQUAL | INSTANCEOF | BETWEEN | MATCHES\n  function maybeEatRelationalOperator() {\n    var token = peekToken();\n    if (token === null) {\n      return null;\n    }\n    if (token.isNumericRelationalOperator()) {\n      return token;\n    }\n    if (token.isIdentifier()) {\n      var idString = token.stringValue();\n      if (idString.toLowerCase() === 'instanceof') {\n        return token.asInstanceOfToken();\n      }\n      if (idString.toLowerCase() === 'matches') {\n        return token.asMatchesToken();\n      }\n      if (idString.toLowerCase() === 'between') {\n        return token.asBetweenToken();\n      }\n    }\n    return null;\n  }\n  function eatToken(expectedKind) {\n    var token = nextToken();\n    if (token === null) {\n      raiseInternalException(expressionString.length, 'OOD');\n    }\n    if (token.getKind() !== expectedKind) {\n      raiseInternalException(token.startPos, 'NOT_EXPECTED_TOKEN', expectedKind.toString().toLowerCase(), token.getKind().toString().toLowerCase());\n    }\n    return token;\n  }\n  function peekTokenOne(desiredTokenKind) {\n    return peekTokenConsumeIfMatched(desiredTokenKind, false);\n  }\n  function peekTokenConsumeIfMatched(desiredTokenKind, consumeIfMatched) {\n    if (!moreTokens()) {\n      return false;\n    }\n    var token = peekToken();\n    if (token.getKind() === desiredTokenKind) {\n      if (consumeIfMatched) {\n        tokenStreamPointer++;\n      }\n      return true;\n    }\n    if (desiredTokenKind === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.IDENTIFIER) {\n      // might be one of the textual forms of the operators (e.g. NE for !== ) - in which case we can treat it as an identifier\n      // The list is represented here: Tokenizer.alternativeOperatorNames and those ones are in order in the TokenKind enum\n      if (token.getKind().ordinal() >= _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.DIV.ordinal() && token.getKind().ordinal() <= _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.NOT.ordinal() && token.data !== null) {\n        // if token.data were null, we'd know it wasn'token the textual form, it was the symbol form\n        return true;\n      }\n    }\n    return false;\n  }\n  function peekTokenAny() {\n    if (!moreTokens()) {\n      return false;\n    }\n    var token = peekToken();\n    var args = Array.prototype.slice.call(arguments);\n    for (var i = 0, l = args.length; i < l; i += 1) {\n      if (token.getKind() === args[i]) {\n        return true;\n      }\n    }\n    return false;\n  }\n  function peekIdentifierToken(identifierString) {\n    if (!moreTokens()) {\n      return false;\n    }\n    var token = peekToken();\n    return token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.IDENTIFIER && token.stringValue().toLowerCase() === identifierString.toLowerCase();\n  }\n  function peekSelectToken() {\n    if (!moreTokens()) {\n      return false;\n    }\n    var token = peekToken();\n    return token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.SELECT || token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.SELECT_FIRST || token.getKind() === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.SELECT_LAST;\n  }\n  function moreTokens() {\n    return tokenStreamPointer < tokenStream.length;\n  }\n  function nextToken() {\n    if (tokenStreamPointer >= tokenStreamLength) {\n      return null;\n    }\n    return tokenStream[tokenStreamPointer++];\n  }\n  function peekToken() {\n    if (tokenStreamPointer >= tokenStreamLength) {\n      return null;\n    }\n    return tokenStream[tokenStreamPointer];\n  }\n  function raiseInternalException(pos, message, expected, actual) {\n    if (expected) {\n      message += '\\nExpected: ' + expected;\n    }\n    if (actual) {\n      message += '\\nActual: ' + actual;\n    }\n    throw {\n      name: 'InternalParseException',\n      message: 'Error occurred while attempting to parse expression \\'' + expressionString + '\\' at position ' + pos + '. Message: ' + message\n    };\n  }\n  function toString(token) {\n    if (token.getKind().hasPayload()) {\n      return token.stringValue();\n    }\n    return token.getKind().toString().toLowerCase();\n  }\n  function checkOperands(token, left, right) {\n    checkLeftOperand(token, left);\n    checkRightOperand(token, right);\n  }\n  function checkLeftOperand(token, operandExpression) {\n    if (operandExpression === null) {\n      raiseInternalException(token.startPos, 'LEFT_OPERAND_PROBLEM');\n    }\n  }\n  function checkRightOperand(token, operandExpression) {\n    if (operandExpression === null) {\n      raiseInternalException(token.startPos, 'RIGHT_OPERAND_PROBLEM');\n    }\n  }\n\n  /**\n   * Compress the start and end of a token into a single int.\n   */\n  function toPosToken(token) {\n    return (token.startPos << 16) + token.endPos;\n  }\n  function toPosBounds(start, end) {\n    return (start << 16) + end;\n  }\n  return {\n    setConfiguration: setConfiguration,\n    parse: parse\n  };\n};\n\n//# sourceURL=webpack://spel2js/./src/SpelExpressionParser.js?")},"./src/StandardContext.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   StandardContext: function() { return /* binding */ StandardContext; }\n/* harmony export */ });\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction create(authentication, principal) {\n  var context = {};\n  context.authentication = authentication || {};\n  context.principal = principal || {};\n  context.hasRole = function (role) {\n    var hasRole = false;\n    if (!role) {\n      return false;\n    }\n    if (!context.authentication && !Array.isArray(context.authentication.authorities)) {\n      return false;\n    }\n    context.authentication.authorities.forEach(function (grantedAuthority) {\n      if (grantedAuthority.authority.toLowerCase() === role.toLowerCase()) {\n        hasRole = true;\n      }\n    });\n    return hasRole;\n  };\n  context.hasPermission = function /*variable arguments*/\n  () {\n    var args = Array.prototype.slice.call(arguments);\n    if (args.length === 1) {\n      return context.hasRole(args[0]);\n    }\n  };\n  return context;\n}\nvar StandardContext = {\n  create: create\n};\n\n//# sourceURL=webpack://spel2js/./src/StandardContext.js?')},"./src/Token.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Token: function() { return /* binding */ Token; }\n/* harmony export */ });\n/* harmony import */ var _TokenKind__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TokenKind */ \"./src/TokenKind.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\n\nfunction Token(tokenKind, tokenData, startPos, endPos) {\n  this.kind = tokenKind;\n  this.startPos = startPos;\n  this.endPos = endPos;\n  if (tokenData) {\n    this.data = tokenData;\n  }\n}\nToken.prototype.getKind = function () {\n  return this.kind;\n};\nToken.prototype.toString = function () {\n  var s = '[';\n  s += this.kind.toString();\n  if (this.kind.hasPayload()) {\n    s += ':' + this.data;\n  }\n  s += ']';\n  s += '(' + this.startPos + ',' + this.endPos + ')';\n  return s;\n};\nToken.prototype.isIdentifier = function () {\n  return this.kind === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.IDENTIFIER;\n};\nToken.prototype.isNumericRelationalOperator = function () {\n  return this.kind === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.GT || this.kind === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.GE || this.kind === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LT || this.kind === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.LE || this.kind === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.EQ || this.kind === _TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.NE;\n};\nToken.prototype.stringValue = function () {\n  return this.data;\n};\nToken.prototype.asInstanceOfToken = function () {\n  return new Token(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.INSTANCEOF, this.startPos, this.endPos);\n};\nToken.prototype.asMatchesToken = function () {\n  return new Token(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.MATCHES, this.startPos, this.endPos);\n};\nToken.prototype.asBetweenToken = function () {\n  return new Token(_TokenKind__WEBPACK_IMPORTED_MODULE_0__.TokenKind.BETWEEN, this.startPos, this.endPos);\n};\nToken.prototype.getStartPosition = function () {\n  return this.startPos;\n};\nToken.prototype.getEndPosition = function () {\n  return this.endPos;\n};\n\n\n//# sourceURL=webpack://spel2js/./src/Token.js?")},"./src/TokenKind.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TokenKind: function() { return /* binding */ TokenKind; }\n/* harmony export */ });\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\nvar types = {\n  LITERAL_INT: 1,\n  //tested\n\n  LITERAL_LONG: 2,\n  //tested\n\n  LITERAL_HEXINT: 3,\n  //tested\n\n  LITERAL_HEXLONG: 4,\n  //tested\n\n  LITERAL_STRING: 5,\n  //tested\n\n  LITERAL_REAL: 6,\n  //tested\n\n  LITERAL_REAL_FLOAT: 7,\n  //tested\n\n  LPAREN: '(',\n  //tested\n\n  RPAREN: ')',\n  //tested\n\n  COMMA: ',',\n  //tested\n\n  IDENTIFIER: 0,\n  //tested\n\n  COLON: ':',\n  //tested\n\n  HASH: '#',\n  //tested\n\n  RSQUARE: ']',\n  //tested\n\n  LSQUARE: '[',\n  //tested\n\n  LCURLY: '{',\n  //tested\n\n  RCURLY: '}',\n  //tested\n\n  DOT: '.',\n  //tested\n\n  PLUS: '+',\n  //tested\n\n  STAR: '*',\n  //tested\n\n  MINUS: '-',\n  //tested\n\n  SELECT_FIRST: '^[',\n  //tested\n\n  SELECT_LAST: '$[',\n  //tested\n\n  QMARK: '?',\n  //tested\n\n  PROJECT: '![',\n  //tested\n\n  DIV: '/',\n  //tested\n\n  GE: '>=',\n  //tested\n\n  GT: '>',\n  //tested\n\n  LE: '<=',\n  //tested\n\n  LT: '<',\n  //tested\n\n  EQ: '==',\n  //tested\n\n  NE: '!=',\n  //tested\n\n  MOD: '%',\n  //tested\n\n  NOT: '!',\n  //tested\n\n  ASSIGN: '=',\n  //tested\n\n  INSTANCEOF: 'instanceof',\n  //test fails\n\n  MATCHES: 'matches',\n  //test fails\n\n  BETWEEN: 'between',\n  //test fails\n\n  SELECT: '?[',\n  //tested\n\n  POWER: '^',\n  //tested\n\n  ELVIS: '?:',\n  //tested\n\n  SAFE_NAVI: '?.',\n  //tested\n\n  BEAN_REF: '@',\n  //tested\n\n  SYMBOLIC_OR: '||',\n  //tested\n\n  SYMBOLIC_AND: '&&',\n  //tested\n\n  INC: '++',\n  //tested\n\n  DEC: '--',\n  //tested\n\n  EMPTY: 'empty' /* James Chu, Potix, 20220127, support 'empty' */\n};\n\nfunction TokenKind(type) {\n  this.type = type;\n  this.tokenChars = types[type];\n  this._hasPayload = typeof types[type] !== 'string';\n  if (typeof types[type] === 'number') {\n    this._ordinal = types[type];\n  }\n}\n\n//create enum\nfor (var t in types) {\n  if (types.hasOwnProperty(t)) {\n    TokenKind[t] = new TokenKind(t);\n  }\n}\nTokenKind.prototype.toString = function () {\n  return this.type + (this.tokenChars.length !== 0 ? '(' + this.tokenChars + ')' : '');\n};\nTokenKind.prototype.getLength = function () {\n  return this.tokenChars.length;\n};\nTokenKind.prototype.hasPayload = function () {\n  return this._hasPayload;\n};\nTokenKind.prototype.valueOf = function (id) {\n  for (var t in types) {\n    if (types.hasOwnProperty(t) && types[t] === id) {\n      return TokenKind[t];\n    }\n  }\n};\nTokenKind.prototype.ordinal = function () {\n  return this._ordinal;\n};\n\n\n//# sourceURL=webpack://spel2js/./src/TokenKind.js?")},"./src/Tokenizer.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Tokenizer: function() { return /* binding */ Tokenizer; }\n/* harmony export */ });\n/* harmony import */ var _Token__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Token */ \"./src/Token.js\");\n/* harmony import */ var _TokenKind__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./TokenKind */ \"./src/TokenKind.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @author Andy Clement\n * @author Phillip Webb\n * @author Ben March\n * @since 0.2.0\n */\n\n\n\nvar ALTERNATIVE_OPERATOR_NAMES = ['DIV', 'EQ', 'GE', 'GT', 'LE', 'LT', 'MOD', 'NE', 'NOT', 'EMPTY'],\n  /* James Chu, Potix, 20220127, support 'empty' */\n  FLAGS = [],\n  IS_DIGIT = 1,\n  IS_HEXDIGIT = 2,\n  IS_ALPHA = 4;\nfunction init() {\n  var ch;\n  for (ch = '0'.charCodeAt(0); ch <= '9'.charCodeAt(0); ch += 1) {\n    FLAGS[ch] |= IS_DIGIT | IS_HEXDIGIT;\n  }\n  for (ch = 'A'.charCodeAt(0); ch <= 'F'.charCodeAt(0); ch += 1) {\n    FLAGS[ch] |= IS_HEXDIGIT;\n  }\n  for (ch = 'a'.charCodeAt(0); ch <= 'f'.charCodeAt(0); ch += 1) {\n    FLAGS[ch] |= IS_HEXDIGIT;\n  }\n  for (ch = 'A'.charCodeAt(0); ch <= 'Z'.charCodeAt(0); ch += 1) {\n    FLAGS[ch] |= IS_ALPHA;\n  }\n  for (ch = 'a'.charCodeAt(0); ch <= 'z'.charCodeAt(0); ch += 1) {\n    FLAGS[ch] |= IS_ALPHA;\n  }\n}\ninit();\nfunction tokenize(inputData) {\n  var expressionString = inputData,\n    toProcess = inputData + '\\0',\n    max = toProcess.length,\n    pos = 0,\n    tokens = [];\n  function process() {\n    var ch;\n    while (pos < max) {\n      ch = toProcess[pos];\n      if (isAlphabetic(ch)) {\n        lexIdentifier();\n      } else {\n        switch (ch) {\n          case '+':\n            if (isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.INC)) {\n              pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.INC);\n            } else {\n              pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.PLUS);\n            }\n            break;\n          case '_':\n            // the other way to start an identifier\n            lexIdentifier();\n            break;\n          case '-':\n            if (isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.DEC)) {\n              pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.DEC);\n            } else {\n              pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.MINUS);\n            }\n            break;\n          case ':':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.COLON);\n            break;\n          case '.':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.DOT);\n            break;\n          case ',':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.COMMA);\n            break;\n          case '*':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.STAR);\n            break;\n          case '/':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.DIV);\n            break;\n          case '%':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.MOD);\n            break;\n          case '(':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LPAREN);\n            break;\n          case ')':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.RPAREN);\n            break;\n          case '[':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LSQUARE);\n            break;\n          case '#':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.HASH);\n            break;\n          case ']':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.RSQUARE);\n            break;\n          case '{':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LCURLY);\n            break;\n          case '}':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.RCURLY);\n            break;\n          case '@':\n            pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.BEAN_REF);\n            break;\n          case '^':\n            if (isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.SELECT_FIRST)) {\n              pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.SELECT_FIRST);\n            } else {\n              pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.POWER);\n            }\n            break;\n          case '!':\n            if (isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.NE)) {\n              pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.NE);\n            } else if (isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.PROJECT)) {\n              pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.PROJECT);\n            } else {\n              pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.NOT);\n            }\n            break;\n          case '=':\n            if (isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.EQ)) {\n              pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.EQ);\n            } else {\n              pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.ASSIGN);\n            }\n            break;\n          case '&':\n            if (!isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.SYMBOLIC_AND)) {\n              throw {\n                name: 'SpelParseException',\n                message: 'Missing character \\'&\\' in expression (' + expressionString + ') at position ' + pos\n              };\n            }\n            pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.SYMBOLIC_AND);\n            break;\n          case '|':\n            if (!isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.SYMBOLIC_OR)) {\n              throw {\n                name: 'SpelParseException',\n                message: 'Missing character \\'|\\' in expression (' + expressionString + ') at position ' + pos\n              };\n            }\n            pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.SYMBOLIC_OR);\n            break;\n          case '?':\n            if (isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.SELECT)) {\n              pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.SELECT);\n            } else if (isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.ELVIS)) {\n              pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.ELVIS);\n            } else if (isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.SAFE_NAVI)) {\n              pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.SAFE_NAVI);\n            } else {\n              pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.QMARK);\n            }\n            break;\n          case '$':\n            if (isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.SELECT_LAST)) {\n              pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.SELECT_LAST);\n            } else {\n              lexIdentifier();\n            }\n            break;\n          case '>':\n            if (isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.GE)) {\n              pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.GE);\n            } else {\n              pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.GT);\n            }\n            break;\n          case '<':\n            if (isTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LE)) {\n              pushPairToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LE);\n            } else {\n              pushCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LT);\n            }\n            break;\n          case '0':\n          case '1':\n          case '2':\n          case '3':\n          case '4':\n          case '5':\n          case '6':\n          case '7':\n          case '8':\n          case '9':\n            lexNumericLiteral(ch === '0');\n            break;\n          case ' ':\n          case '\\t':\n          case '\\r':\n          case '\\n':\n            // drift over white space\n            pos += 1;\n            break;\n          case '\\'':\n            lexQuotedStringLiteral();\n            break;\n          case '\"':\n            lexDoubleQuotedStringLiteral();\n            break;\n          case '\\0':\n            // hit sentinel at end of value\n            pos += 1; // will take us to the end\n            break;\n          case '\\\\':\n            throw {\n              name: 'SpelParseException',\n              message: 'Unexpected escape character in expression (' + expressionString + ') at position ' + pos\n            };\n          default:\n            throw {\n              name: 'SpelParseException',\n              message: 'Cannot handle character \\'' + ch + '\\' in expression (' + expressionString + ') at position ' + pos\n            };\n        }\n      }\n    }\n  }\n  function lexQuotedStringLiteral() {\n    var start = pos,\n      terminated = false,\n      ch;\n    while (!terminated) {\n      pos += 1;\n      ch = toProcess[pos];\n      if (ch === '\\'') {\n        // may not be the end if the char after is also a '\n        if (toProcess[pos + 1] === '\\'') {\n          pos += 1; // skip over that too, and continue\n        } else {\n          terminated = true;\n        }\n      }\n      if (ch.charCodeAt(0) === 0) {\n        throw {\n          name: 'SpelParseException',\n          message: 'Non-terminating quoted string in expression (' + expressionString + ') at position ' + pos\n        };\n      }\n    }\n    pos += 1;\n    tokens.push(new _Token__WEBPACK_IMPORTED_MODULE_0__.Token(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LITERAL_STRING, subarray(start, pos), start, pos));\n  }\n  function lexDoubleQuotedStringLiteral() {\n    var start = pos,\n      terminated = false,\n      ch;\n    while (!terminated) {\n      pos += 1;\n      ch = toProcess[pos];\n      if (ch === '\"') {\n        // may not be the end if the char after is also a '\n        if (toProcess[pos + 1] === '\"') {\n          pos += 1; // skip over that too, and continue\n        } else {\n          terminated = true;\n        }\n      }\n      if (ch.charCodeAt(0) === 0) {\n        throw {\n          name: 'SpelParseException',\n          message: 'Non-terminating double-quoted string in expression (' + expressionString + ') at position ' + pos\n        };\n      }\n    }\n    pos += 1;\n    tokens.push(new _Token__WEBPACK_IMPORTED_MODULE_0__.Token(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LITERAL_STRING, subarray(start, pos), start, pos));\n  }\n\n  // REAL_LITERAL :\n  // ('.' (DECIMAL_DIGIT)+ (EXPONENT_PART)? (REAL_TYPE_SUFFIX)?) |\n  // ((DECIMAL_DIGIT)+ '.' (DECIMAL_DIGIT)+ (EXPONENT_PART)? (REAL_TYPE_SUFFIX)?) |\n  // ((DECIMAL_DIGIT)+ (EXPONENT_PART) (REAL_TYPE_SUFFIX)?) |\n  // ((DECIMAL_DIGIT)+ (REAL_TYPE_SUFFIX));\n  // fragment INTEGER_TYPE_SUFFIX : ( 'L' | 'l' );\n  // fragment HEX_DIGIT :\n  // '0'|'1'|'2'|'3'|'4'|'5'|'6'|'7'|'8'|'9'|'A'|'B'|'C'|'D'|'E'|'F'|'a'|'b'|'c'|'d'|'e'|'f';\n  //\n  // fragment EXPONENT_PART : 'e' (SIGN)* (DECIMAL_DIGIT)+ | 'E' (SIGN)*\n  // (DECIMAL_DIGIT)+ ;\n  // fragment SIGN : '+' | '-' ;\n  // fragment REAL_TYPE_SUFFIX : 'F' | 'f' | 'D' | 'd';\n  // INTEGER_LITERAL\n  // : (DECIMAL_DIGIT)+ (INTEGER_TYPE_SUFFIX)?;\n\n  function lexNumericLiteral(firstCharIsZero) {\n    var isReal = false,\n      start = pos,\n      ch = toProcess[pos + 1],\n      isHex = ch === 'x' || ch === 'X',\n      dotpos,\n      endOfNumber,\n      possibleSign,\n      isFloat;\n\n    // deal with hexadecimal\n    if (firstCharIsZero && isHex) {\n      pos = pos + 1;\n      do {\n        pos += 1;\n      } while (isHexadecimalDigit(toProcess[pos]));\n      if (isChar('L', 'l')) {\n        pushHexIntToken(subarray(start + 2, pos), true, start, pos);\n        pos += 1;\n      } else {\n        pushHexIntToken(subarray(start + 2, pos), false, start, pos);\n      }\n      return;\n    }\n\n    // real numbers must have leading digits\n\n    // Consume first part of number\n    do {\n      pos += 1;\n    } while (isDigit(toProcess[pos]));\n\n    // a '.' indicates this number is a real\n    ch = toProcess[pos];\n    if (ch === '.') {\n      isReal = true;\n      dotpos = pos;\n      // carry on consuming digits\n      do {\n        pos += 1;\n      } while (isDigit(toProcess[pos]));\n      if (pos === dotpos + 1) {\n        // the number is something like '3.'. It is really an int but may be\n        // part of something like '3.toString()'. In this case process it as\n        // an int and leave the dot as a separate token.\n        pos = dotpos;\n        pushIntToken(subarray(start, pos), false, start, pos);\n        return;\n      }\n    }\n    endOfNumber = pos;\n\n    // Now there may or may not be an exponent\n\n    // is it a long ?\n    if (isChar('L', 'l')) {\n      if (isReal) {\n        // 3.4L - not allowed\n        throw {\n          name: 'SpelParseException',\n          message: 'Real cannot be long in expression (' + expressionString + ') at position ' + pos\n        };\n      }\n      pushIntToken(subarray(start, endOfNumber), true, start, endOfNumber);\n      pos += 1;\n    } else if (isExponentChar(toProcess[pos])) {\n      isReal = true; // if it wasn't before, it is now\n      pos += 1;\n      possibleSign = toProcess[pos];\n      if (isSign(possibleSign)) {\n        pos += 1;\n      }\n\n      // exponent digits\n      do {\n        pos += 1;\n      } while (isDigit(toProcess[pos]));\n      isFloat = false;\n      if (isFloatSuffix(toProcess[pos])) {\n        isFloat = true;\n        pos += 1;\n        endOfNumber = pos;\n      } else if (isDoubleSuffix(toProcess[pos])) {\n        pos += 1;\n        endOfNumber = pos;\n      }\n      pushRealToken(subarray(start, pos), isFloat, start, pos);\n    } else {\n      ch = toProcess[pos];\n      isFloat = false;\n      if (isFloatSuffix(ch)) {\n        isReal = true;\n        isFloat = true;\n        pos += 1;\n        endOfNumber = pos;\n      } else if (isDoubleSuffix(ch)) {\n        isReal = true;\n        pos += 1;\n        endOfNumber = pos;\n      }\n      if (isReal) {\n        pushRealToken(subarray(start, endOfNumber), isFloat, start, endOfNumber);\n      } else {\n        pushIntToken(subarray(start, endOfNumber), false, start, endOfNumber);\n      }\n    }\n  }\n  function lexIdentifier() {\n    var start = pos,\n      substring,\n      asString,\n      idx;\n    do {\n      pos += 1;\n    } while (isIdentifier(toProcess[pos]));\n    substring = subarray(start, pos);\n\n    // Check if this is the alternative (textual) representation of an operator (see\n    // alternativeOperatorNames)\n    if (pos - start === 2 || pos - start === 3 || pos - start === 5) {\n      asString = substring.toUpperCase();\n      idx = ALTERNATIVE_OPERATOR_NAMES.indexOf(asString);\n      if (idx >= 0) {\n        /* James Chu, Potix, 20220120, fix bug for alternative op name */\n        pushOneCharOrTwoCharToken(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind[asString], start, substring);\n        return;\n      }\n    }\n    tokens.push(new _Token__WEBPACK_IMPORTED_MODULE_0__.Token(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.IDENTIFIER, substring.replace('\\0', ''), start, pos));\n  }\n  function pushIntToken(data, isLong, start, end) {\n    if (isLong) {\n      tokens.push(new _Token__WEBPACK_IMPORTED_MODULE_0__.Token(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LITERAL_LONG, data, start, end));\n    } else {\n      tokens.push(new _Token__WEBPACK_IMPORTED_MODULE_0__.Token(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LITERAL_INT, data, start, end));\n    }\n  }\n  function pushHexIntToken(data, isLong, start, end) {\n    if (data.length === 0) {\n      if (isLong) {\n        throw {\n          name: 'SpelParseException',\n          message: 'Not a long in expression (' + expressionString + ') at position ' + pos\n        };\n      } else {\n        throw {\n          name: 'SpelParseException',\n          message: 'Not an int in expression (' + expressionString + ') at position ' + pos\n        };\n      }\n    }\n    if (isLong) {\n      tokens.push(new _Token__WEBPACK_IMPORTED_MODULE_0__.Token(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LITERAL_HEXLONG, data, start, end));\n    } else {\n      tokens.push(new _Token__WEBPACK_IMPORTED_MODULE_0__.Token(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LITERAL_HEXINT, data, start, end));\n    }\n  }\n  function pushRealToken(data, isFloat, start, end) {\n    if (isFloat) {\n      tokens.push(new _Token__WEBPACK_IMPORTED_MODULE_0__.Token(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LITERAL_REAL_FLOAT, data, start, end));\n    } else {\n      tokens.push(new _Token__WEBPACK_IMPORTED_MODULE_0__.Token(_TokenKind__WEBPACK_IMPORTED_MODULE_1__.TokenKind.LITERAL_REAL, data, start, end));\n    }\n  }\n  function subarray(start, end) {\n    return toProcess.substring(start, end);\n  }\n\n  /**\n   * Check if this might be a two character token.\n   */\n  function isTwoCharToken(kind) {\n    if (kind.tokenChars.length === 2 && toProcess[pos] === kind.tokenChars[0]) {\n      return toProcess[pos + 1] === kind.tokenChars[1];\n    }\n    return false;\n  }\n\n  /**\n   * Push a token of just one character in length.\n   */\n  function pushCharToken(kind) {\n    tokens.push(new _Token__WEBPACK_IMPORTED_MODULE_0__.Token(kind, null, pos, pos + 1));\n    pos += 1;\n  }\n\n  /**\n   * Push a token of two characters in length.\n   */\n  function pushPairToken(kind) {\n    tokens.push(new _Token__WEBPACK_IMPORTED_MODULE_0__.Token(kind, null, pos, pos + 2));\n    pos += 2;\n  }\n  function pushOneCharOrTwoCharToken(kind, pos, data) {\n    tokens.push(new _Token__WEBPACK_IMPORTED_MODULE_0__.Token(kind, data, pos, pos + kind.getLength()));\n  }\n\n  // ID: ('a'..'z'|'A'..'Z'|'_'|'$') ('a'..'z'|'A'..'Z'|'_'|'$'|'0'..'9'|DOT_ESCAPED)*;\n  function isIdentifier(ch) {\n    return isAlphabetic(ch) || isDigit(ch) || ch === '_' || ch === '$';\n  }\n  function isChar(a, b) {\n    var ch = toProcess[pos];\n    return ch === a || ch === b;\n  }\n  function isExponentChar(ch) {\n    return ch === 'e' || ch === 'E';\n  }\n  function isFloatSuffix(ch) {\n    return ch === 'f' || ch === 'F';\n  }\n  function isDoubleSuffix(ch) {\n    return ch === 'd' || ch === 'D';\n  }\n  function isSign(ch) {\n    return ch === '+' || ch === '-';\n  }\n  function isDigit(ch) {\n    if (ch.charCodeAt(0) > 255) {\n      return false;\n    }\n    return (FLAGS[ch.charCodeAt(0)] & IS_DIGIT) !== 0;\n  }\n  function isAlphabetic(ch) {\n    if (ch.charCodeAt(0) > 255) {\n      return false;\n    }\n    return (FLAGS[ch.charCodeAt(0)] & IS_ALPHA) !== 0;\n  }\n  function isHexadecimalDigit(ch) {\n    if (ch.charCodeAt(0) > 255) {\n      return false;\n    }\n    return (FLAGS[ch.charCodeAt(0)] & IS_HEXDIGIT) !== 0;\n  }\n  process();\n  return tokens;\n}\nvar Tokenizer = {\n  tokenize: tokenize\n};\n\n//# sourceURL=webpack://spel2js/./src/Tokenizer.js?")},"./src/ast/Assign.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Assign: function() { return /* binding */ Assign; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents assignment. An alternative to calling setValue() for an expression is to use\n * an assign.\n *\n * <p>Example: 'someNumberProperty=42'\n *\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, property, assignedValue) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('assign', position, property, assignedValue);\n  node.toString = function () {\n    return property + '=' + assignedValue;\n  };\n  node.getValue = function (state) {\n    var context = state.activeContext.peek();\n    if (!context) {\n      throw {\n        name: 'ContextDoesNotExistException',\n        message: 'Attempting to assign property \\'' + property.getValue(state) + '\\' for an undefined context.'\n      };\n    }\n    return property.setValue(assignedValue.getValue(state), state);\n  };\n  return node;\n}\nvar Assign = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/Assign.js?")},"./src/ast/BeanReference.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BeanReference: function() { return /* binding */ BeanReference; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2019 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      https://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents a bean reference to a type, for example <tt>@foo</tt> or <tt>@'foo.bar'</tt>.\n * For a FactoryBean the syntax <tt>&foo</tt> can be used to access the factory itself.\n *\n * @author Andy Clement\n */\nfunction createNode(position, beanName) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('beanref', position);\n  node.getValue = function (state) {\n    throw {\n      name: 'MethodNotImplementedException',\n      message: 'BeanReference: Not implemented'\n    };\n  };\n  return node;\n}\nvar BeanReference = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/BeanReference.js?")},"./src/ast/BooleanLiteral.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BooleanLiteral: function() { return /* binding */ BooleanLiteral; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents the literal values TRUE and FALSE.\n *\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(value, position) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'boolean\', position);\n  node.toString = function () {\n    return String(value);\n  };\n  node.getValue = function () {\n    return value;\n  };\n  node.setValue = function (newValue) {\n    /*jshint -W093 */\n    return value = newValue;\n    /*jshint +W093 */\n  };\n\n  return node;\n}\nvar BooleanLiteral = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/BooleanLiteral.js?')},"./src/ast/CompoundExpression.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CompoundExpression: function() { return /* binding */ CompoundExpression; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents a DOT separated expression sequence, such as 'property1.property2.methodOne()'\n *\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, expressionComponents) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create.apply(null, ['compound', position].concat(expressionComponents));\n  node.toString = function () {\n    var children = node.getChildren(),\n      childrenCount = children.length,\n      i,\n      raw = [];\n    for (i = 0; i < childrenCount; i += 1) {\n      if (children[i].getType() === 'indexer') {\n        raw.push('[', children[i].toString(), ']');\n      } else {\n        if (i > 0) {\n          raw.push('.');\n        }\n        raw.push(children[i].toString());\n      }\n    }\n    return raw.join('');\n  };\n  function buildContextStack(state) {\n    var children = node.getChildren(),\n      childrenCount = children.length,\n      i;\n    for (i = 0; i < childrenCount; i += 1) {\n      if (children[i].getType() === 'indexer') {\n        var value = state.activeContext.peek();\n        if (value != null) {\n          /* James Chu, Potix, 20230314, check $lc$ */\n          if (value['$lc$']) {\n            state.activeContext.push(value['$lc$'][children[i].getValue(state)]);\n          } else {\n            state.activeContext.push(value[children[i].getValue(state)]);\n          }\n        } else {\n          return function () {};\n        }\n      } else {\n        state.activeContext.push(children[i].getValue(state));\n      }\n    }\n    return function unbuildContextStack() {\n      for (i = 0; i < childrenCount; i += 1) {\n        state.activeContext.pop();\n      }\n    };\n  }\n  node.getValue = function (state) {\n    var context = state.activeContext.peek(),\n      value;\n    if (!context) {\n      throw {\n        name: 'ContextDoesNotExistException',\n        message: 'Attempting to evaluate compound expression with an undefined context.'\n      };\n    }\n    var unbuildContextStack = buildContextStack(state);\n    value = state.activeContext.peek();\n    unbuildContextStack();\n    return value;\n  };\n  node.setValue = function (value, state) {\n    var unbuildContextStack = buildContextStack(state),\n      childCount = node.getChildren().length;\n    state.activeContext.pop();\n    value = node.getChildren()[childCount - 1].setValue(value, state);\n    state.activeContext.push(null);\n    unbuildContextStack();\n    return value;\n  };\n  return node;\n}\nvar CompoundExpression = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/CompoundExpression.js?")},"./src/ast/ConstructorReference.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ConstructorReference: function() { return /* binding */ ConstructorReference; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/* harmony import */ var _lib_Stack__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../lib/Stack */ \"./src/lib/Stack.js\");\n/*\n * Copyright 2002-2019 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      https://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n\n/**\n * Represents the invocation of a constructor. Either a constructor on a regular type or\n * construction of an array. When an array is constructed, an initializer can be specified.\n *\n * <p>Examples:<br>\n * new String('hello world')<br>\n * new int[]{1,2,3,4}<br>\n * new int[3] new int[3]{1,2,3}\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @since 3.0\n */\nfunction createNode(position, dimensions, nodes) {\n  var isArray = nodes !== undefined;\n  var dimension;\n  if (isArray) {\n    dimension = dimensions.length && dimensions[0] && dimensions[0].getType() === 'number' ? dimensions[0].getValue() : null;\n  } else {\n    nodes = dimensions;\n    dimensions = undefined;\n  }\n  const [_qualifiedIdentifier, ...args] = nodes;\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('constructorref', position, ...nodes);\n  node.getRaw = function () {\n    return dimension;\n  };\n  node.getValue = function (state) {\n    if (isArray && args.length <= 1) {\n      var compiledArgs = [];\n\n      //populate arguments\n      args.forEach(function (arg) {\n        // reset the active context to root context for evaluating argument\n        const currentActiveContext = state.activeContext;\n        state.activeContext = new _lib_Stack__WEBPACK_IMPORTED_MODULE_1__.Stack();\n        state.activeContext.push(state.rootContext);\n\n        // evaluate argument\n        compiledArgs.push(arg.getValue(state));\n\n        // reset the active context\n        state.activeContext = currentActiveContext;\n      });\n      if (args.length === 1) {\n        return compiledArgs[0];\n      } else {\n        return dimension ? new Array(dimension) : [];\n      }\n    }\n    throw {\n      name: 'MethodNotImplementedException',\n      message: 'ConstructorReference: Not implemented'\n    };\n  };\n  return node;\n}\nvar ConstructorReference = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/ConstructorReference.js?")},"./src/ast/Elvis.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Elvis: function() { return /* binding */ Elvis; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents the elvis operator ?:. For an expression "a?:b" if a is not null, the value\n * of the expression is "a", if a is null then the value of the expression is "b".\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, expression, ifFalse) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'elvis\', position, expression, ifFalse);\n  node.getValue = function (state) {\n    return expression.getValue(state) !== null ? expression.getValue(state) : ifFalse.getValue(state);\n  };\n  return node;\n}\nvar Elvis = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/Elvis.js?')},"./src/ast/FunctionReference.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   FunctionReference: function() { return /* binding */ FunctionReference; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/* harmony import */ var _lib_Stack__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../lib/Stack */ "./src/lib/Stack.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n\n/**\n * A function reference is of the form "#someFunction(a,b,c)". Functions may be defined in\n * the context prior to the expression being evaluated or within the expression itself\n * using a lambda function definition. For example: Lambda function definition in an\n * expression: "(#max = {|x,y|$x>$y?$x:$y};max(2,3))" Calling context defined function:\n * "#isEven(37)". Functions may also be static java methods, registered in the context\n * prior to invocation of the expression.\n *\n * <p>Functions are very simplistic, the arguments are not part of the definition (right\n * now), so the names must be unique.\n *\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(functionName, position, args) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'function\', position);\n  node.getRaw = function () {\n    return {\n      functionName,\n      args\n    };\n  };\n  node.getValue = function (state) {\n    var locals = state.locals || {},\n      context = state.rootContext,\n      compiledArgs = [];\n\n    //populate arguments\n    args.forEach(function (arg) {\n      // reset the active context to root context for evaluating argument\n      const currentActiveContext = state.activeContext;\n      state.activeContext = new _lib_Stack__WEBPACK_IMPORTED_MODULE_1__.Stack();\n      state.activeContext.push(state.rootContext);\n\n      // evaluate argument\n      compiledArgs.push(arg.getValue(state));\n\n      // reset the active context\n      state.activeContext = currentActiveContext;\n    });\n    if (locals[functionName]) {\n      return locals[functionName].apply(context, compiledArgs);\n    }\n    throw {\n      name: \'FunctionDoesNotExistException\',\n      message: \'Function \\\'\' + functionName + \'\\\' does not exist.\'\n    };\n  };\n  return node;\n}\nvar FunctionReference = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/FunctionReference.js?')},"./src/ast/Identifier.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Identifier: function() { return /* binding */ Identifier; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2019 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      https://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * An 'identifier' {@link SpelNode}.\n *\n * @author Andy Clement\n * @since 3.0\n */\nfunction createNode(identifierName, position) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('identifier', position);\n  node.toString = node.getRaw = function () {\n    return identifierName;\n  };\n  node.getValue = function (state) {\n    throw {\n      name: 'MethodNotImplementedException',\n      message: 'Identifier: Not implemented'\n    };\n  };\n  return node;\n}\nvar Identifier = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/Identifier.js?")},"./src/ast/Indexer.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Indexer: function() { return /* binding */ Indexer; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/* harmony import */ var _lib_Stack__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../lib/Stack */ \"./src/lib/Stack.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n\n/**\n * An Indexer can index into some proceeding structure to access a particular piece of it.\n * Supported structures are: strings / collections (lists/sets) / arrays.\n *\n * @author Andy Clement\n * @author Phillip Webb\n * @author Stephane Nicoll\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, expressionComponents) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create.apply(null, ['indexer', position].concat(expressionComponents));\n  node.toString = function () {\n    var children = node.getChildren(),\n      childrenCount = children.length,\n      i,\n      raw = [];\n    for (i = 0; i < childrenCount; i += 1) {\n      if (children[i].getType() === 'indexer') {\n        raw.push('[', children[i].toString(), ']');\n      } else {\n        if (i > 0) {\n          raw.push('.');\n        }\n        raw.push(children[i].toString());\n      }\n    }\n    return raw.join('');\n  };\n  node.getValue = function (state) {\n    var activeContext = state.activeContext,\n      context,\n      childrenCount = node.getChildren().length,\n      i,\n      value;\n    state.activeContext = new _lib_Stack__WEBPACK_IMPORTED_MODULE_1__.Stack();\n    state.activeContext.push(state.rootContext);\n    context = state.activeContext.peek();\n    if (!context) {\n      throw {\n        name: 'ContextDoesNotExistException',\n        message: 'Attempting to evaluate compound expression with an undefined context.'\n      };\n    }\n    for (i = 0; i < childrenCount; i += 1) {\n      state.activeContext.push(node.getChildren()[i].getValue(state));\n    }\n    value = state.activeContext.peek();\n    for (i = 0; i < childrenCount; i += 1) {\n      state.activeContext.pop();\n    }\n    state.activeContext = activeContext;\n    return value;\n  };\n\n  //node.setContext(node.getValue());\n\n  return node;\n}\nvar Indexer = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/Indexer.js?")},"./src/ast/InlineList.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   InlineList: function() { return /* binding */ InlineList; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represent a list in an expression, e.g. '{1,2,3}'\n *\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, elements) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('list', position),\n    list = [].concat(elements || []);\n  node.getRaw = function () {\n    return list;\n  };\n  node.getValue = function (state) {\n    return list.map(function (element) {\n      return element.getValue(state);\n    });\n  };\n  node.toString = function () {\n    return '[]';\n  };\n  return node;\n}\nvar InlineList = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/InlineList.js?")},"./src/ast/InlineMap.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   InlineMap: function() { return /* binding */ InlineMap; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represent a map in an expression, e.g. '{name:'foo',age:12}'\n *\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, elements) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('map', position),\n    mapPieces = [].concat(elements || []);\n  node.getValue = function (state) {\n    var key = true,\n      keyValue = null,\n      map = {};\n    mapPieces.forEach(function (piece) {\n      if (key) {\n        //unquoted property names come as type \"property\" but should be treated as strings\n        if (piece.getType() === 'property') {\n          keyValue = piece.getName();\n        } else {\n          keyValue = piece.getValue(state);\n        }\n      } else {\n        map[keyValue] = piece.getValue(state);\n      }\n      key = !key;\n    });\n    return map;\n  };\n  return node;\n}\nvar InlineMap = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/InlineMap.js?")},"./src/ast/MethodReference.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   MethodReference: function() { return /* binding */ MethodReference; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/* harmony import */ var _lib_Stack__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../lib/Stack */ \"./src/lib/Stack.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n\n/**\n * Expression language AST node that represents a method reference.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(nullSafeNavigation, methodName, position, args) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('method', position);\n  node.getRaw = function () {\n    return {\n      methodName,\n      args\n    };\n  };\n  node.toString = function () {\n    return methodName + '(' + args.map(a => a.toString()) + ')';\n  };\n  node.getValue = function (state) {\n    var context = state.activeContext.peek(),\n      compiledArgs = [],\n      method;\n    if (!context) {\n      throw {\n        name: 'ContextDoesNotExistException',\n        message: 'Attempting to look up property \\'' + methodName + '\\' for an undefined context.'\n      };\n    }\n\n    //handle safe navigation\n    function maybeHandleNullSafeNavigation(member) {\n      if (member === undefined || member === null) {\n        if (nullSafeNavigation) {\n          return null;\n        }\n        throw {\n          name: 'NullPointerException',\n          message: 'Method ' + methodName + ' does not exist.'\n        };\n      }\n      return member;\n    }\n\n    //populate arguments\n    args.forEach(function (arg) {\n      // reset the active context to root context for evaluating argument\n      const currentActiveContext = state.activeContext;\n      state.activeContext = new _lib_Stack__WEBPACK_IMPORTED_MODULE_1__.Stack();\n      state.activeContext.push(state.rootContext);\n\n      // evaluate argument\n      compiledArgs.push(arg.getValue(state));\n\n      // reset the active context\n      state.activeContext = currentActiveContext;\n    });\n    if (context['$lc$']) {\n      context = context['$lc$'];\n    }\n\n    //array methods\n    if (Array.isArray(context)) {\n      //size() -> length\n      switch (methodName) {\n        case 'size':\n        case 'length':\n          return context.length;\n        case 'contains':\n          return context.includes(compiledArgs[0]);\n        case 'get':\n          return context[compiledArgs[0]];\n      }\n    }\n\n    //accessors might not be available\n    if (methodName.substr(0, 3) === 'get' && !context[methodName]) {\n      return maybeHandleNullSafeNavigation(context[methodName.charAt(3).toLowerCase() + methodName.substring(4)]);\n    }\n    if (methodName.substr(0, 3) === 'set' && !context[methodName]) {\n      /*jshint -W093 */\n      return context[methodName.charAt(3).toLowerCase() + methodName.substring(4)] = compiledArgs[0];\n      /*jshint +W093 */\n    }\n\n    method = maybeHandleNullSafeNavigation(context[methodName]);\n    if (method) {\n      return method.apply(context, compiledArgs);\n    }\n    return null;\n  };\n  return node;\n}\nvar MethodReference = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/MethodReference.js?")},"./src/ast/NullLiteral.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   NullLiteral: function() { return /* binding */ NullLiteral; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Expression language AST node that represents null.\n *\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(value, position) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'null\', position);\n  node.getValue = function () {\n    return null;\n  };\n  node.toString = function () {\n    return \'null\';\n  };\n  return node;\n}\nvar NullLiteral = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/NullLiteral.js?')},"./src/ast/NumberLiteral.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   NumberLiteral: function() { return /* binding */ NumberLiteral; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Expression language AST node that represents a literal number of any kind (since JavaScript only supports doubles anyway)\n *\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(value, position) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'number\', position);\n  node.toString = function () {\n    return String(value);\n  };\n  node.getValue = function () {\n    return value;\n  };\n  node.setValue = function (newValue) {\n    /*jshint -W093 */\n    return value = newValue;\n    /*jshint +W093 */\n  };\n\n  return node;\n}\nvar NumberLiteral = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/NumberLiteral.js?')},"./src/ast/OpAnd.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpAnd: function() { return /* binding */ OpAnd; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents the boolean AND operation.\n *\n * @author Andy Clement\n * @author Mark Fisher\n * @author Oliver Becker\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-and\', position, left, right);\n  node.getValue = function (state) {\n    //double bang for javascript\n    return !!left.getValue(state) && !!right.getValue(state);\n  };\n  return node;\n}\nvar OpAnd = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpAnd.js?')},"./src/ast/OpBetween.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpBetween: function() { return /* binding */ OpBetween; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2019 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      https://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents the between operator. The left operand to between must be a single value and\n * the right operand must be a list - this operator returns true if the left operand is\n * between (using the registered comparator) the two elements in the list. The definition\n * of between being inclusive follows the SQL BETWEEN definition.\n *\n * @author Andy Clement\n * @since 3.0\n */\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('between', position, left, right);\n\n  /**\n   * Returns a boolean based on whether a value is in the range expressed. The first\n   * operand is any value whilst the second is a list of two values - those two values\n   * being the bounds allowed for the first operand (inclusive).\n   * @param state the expression state\n   * @return true if the left operand is in the range specified, false otherwise\n   * @throws EvaluationException if there is a problem evaluating the expression\n   */\n  node.getValue = function (state) {\n    throw {\n      name: 'MethodNotImplementedException',\n      message: 'OpBetween: Not implemented'\n    };\n  };\n  return node;\n}\nvar OpBetween = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpBetween.js?")},"./src/ast/OpDec.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpDec: function() { return /* binding */ OpDec; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Decrement operator.  Can be used in a prefix or postfix form. This will throw\n * appropriate exceptions if the operand in question does not support decrement.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Giovanni Dall\'Oglio Risso\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, postfix, int) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-dec\', position, int);\n  node.getValue = function (state) {\n    var cur = int.getValue(state);\n    int.setValue(cur - 1, state);\n    if (postfix) {\n      return cur;\n    }\n    return cur - 1;\n  };\n  return node;\n}\nvar OpDec = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpDec.js?')},"./src/ast/OpDivide.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpDivide: function() { return /* binding */ OpDivide; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Implements division operator.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Giovanni Dall\'Oglio Risso\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-divide\', position, left, right);\n  node.getValue = function (state) {\n    return left.getValue(state) / right.getValue(state);\n  };\n  return node;\n}\nvar OpDivide = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpDivide.js?')},"./src/ast/OpEQ.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpEQ: function() { return /* binding */ OpEQ; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Implements the equality operator.\n *\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-eq\', position, left, right);\n  node.getValue = function (state) {\n    /* James Chu, Potix, 20220826, unwrap observable if any*/\n    return _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.isEqualValue(left.getValue(state), right.getValue(state));\n  };\n  return node;\n}\nvar OpEQ = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpEQ.js?')},"./src/ast/OpEmpty.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpEmpty: function() { return /* binding */ OpEmpty; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/* harmony import */ var _lib_Stack__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../lib/Stack */ \"./src/lib/Stack.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n\n/**\n * Expression language AST node that represents an empty method reference.\n *\n * @author James Chu\n * @since 0.2.9\n */\n\nfunction createNode(position, arg) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('op-empty', position, arg);\n  node.getValue = function (state) {\n    // only one arg\n    // reset the active context to root context for evaluating argument\n    const currentActiveContext = state.activeContext;\n    state.activeContext = new _lib_Stack__WEBPACK_IMPORTED_MODULE_1__.Stack();\n    state.activeContext.push(state.rootContext);\n\n    // evaluate argument\n    var targetValue = arg.getValue(state),\n      result = true;\n    if (targetValue != null) {\n      if (Array.isArray(targetValue) || typeof targetValue === 'string') {\n        /* Jumper Chen, Potix, 20221107, ZK-5275 */\n        result = !targetValue.length;\n      } else {\n        let listContent = targetValue['$lc$'];\n        if (listContent) {\n          result = !listContent.length;\n        } else {\n          let isMap = targetValue['$map$'];\n          for (var prop in targetValue) {\n            if (isMap && (prop == '$id$' || prop == '$map$' || prop == '$ts$')) {\n              //skip map uid and totalSize\n              continue;\n            } else if (targetValue.hasOwnProperty(prop)) {\n              result = false;\n              break;\n            }\n          }\n        }\n      }\n    }\n    // reset the active context\n    state.activeContext = currentActiveContext;\n    return result;\n  };\n  return node;\n}\nvar OpEmpty = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpEmpty.js?")},"./src/ast/OpGE.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpGE: function() { return /* binding */ OpGE; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Implements greater-than-or-equal operator.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Giovanni Dall\'Oglio Risso\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-ge\', position, left, right);\n  node.getValue = function (state) {\n    return left.getValue(state) >= right.getValue(state);\n  };\n  return node;\n}\nvar OpGE = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpGE.js?')},"./src/ast/OpGT.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpGT: function() { return /* binding */ OpGT; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Implements the greater-than operator.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Giovanni Dall\'Oglio Risso\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-gt\', position, left, right);\n  node.getValue = function (state) {\n    return left.getValue(state) > right.getValue(state);\n  };\n  return node;\n}\nvar OpGT = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpGT.js?')},"./src/ast/OpInc.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpInc: function() { return /* binding */ OpInc; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Increment operator. Can be used in a prefix or postfix form. This will throw\n * appropriate exceptions if the operand in question does not support increment.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Giovanni Dall\'Oglio Risso\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, postfix, int) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-inc\', position, int);\n  node.getValue = function (state) {\n    var cur = int.getValue(state);\n    int.setValue(cur + 1, state);\n    if (postfix) {\n      return cur;\n    }\n    return cur + 1;\n  };\n  return node;\n}\nvar OpInc = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpInc.js?')},"./src/ast/OpInstanceof.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpInstanceof: function() { return /* binding */ OpInstanceof; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2019 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      https://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * The operator 'instanceof' checks if an object is of the class specified in the right\n * hand operand, in the same way that {@code instanceof} does in Java.\n *\n * THIS OPERATOR IS NOT IMPLEMENTED AND WILL THROW AN EXCEPTION\n *\n * @author Andy Clement\n * @since 3.0\n */\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('instanceof', position, left, right);\n\n  /**\n   * Compare the left operand to see it is an instance of the type specified as the\n   * right operand. The right operand must be a class.\n   * @param state the expression state\n   * @return {@code true} if the left operand is an instanceof of the right operand,\n   * otherwise {@code false}\n   * @throws EvaluationException if there is a problem evaluating the expression\n   */\n  node.getValue = function (state) {\n    throw {\n      name: 'MethodNotImplementedException',\n      message: 'OpInstanceOf: Not implemented'\n    };\n  };\n  return node;\n}\nvar OpInstanceof = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpInstanceof.js?")},"./src/ast/OpLE.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpLE: function() { return /* binding */ OpLE; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Implements the less-than-or-equal operator.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Giovanni Dall\'Oglio Risso\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-le\', position, left, right);\n  node.getValue = function (state) {\n    return left.getValue(state) <= right.getValue(state);\n  };\n  return node;\n}\nvar OpLE = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpLE.js?')},"./src/ast/OpLT.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpLT: function() { return /* binding */ OpLT; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Implements the less-than operator.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Giovanni Dall\'Oglio Risso\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-lt\', position, left, right);\n  node.getValue = function (state) {\n    return left.getValue(state) < right.getValue(state);\n  };\n  return node;\n}\nvar OpLT = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpLT.js?')},"./src/ast/OpMatches.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpMatches: function() { return /* binding */ OpMatches; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2019 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      https://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Implements the matches operator. Matches takes two operands:\n * The first is a String and the second is a Java regex.\n * It will return {@code true} when {@link #getValue} is called\n * if the first operand matches the regex.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Chris Thielen\n * @since 3.0\n */\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'matches\', position, left, right);\n\n  /**\n   * Check the first operand matches the regex specified as the second operand.\n   * @param state the expression state\n   * @return {@code true} if the first operand matches the regex specified as the\n   * second operand, otherwise {@code false}\n   * @throws EvaluationException if there is a problem evaluating the expression\n   * (e.g. the regex is invalid)\n   */\n  node.getValue = function (state) {\n    var data = left.getValue(state);\n    var regexpString = right.getValue(state);\n    try {\n      var regexp = new RegExp(regexpString);\n      return !!regexp.exec(data);\n    } catch (error) {\n      throw {\n        name: \'EvaluationException\',\n        message: error.toString()\n      };\n    }\n  };\n  return node;\n}\nvar OpMatches = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpMatches.js?')},"./src/ast/OpMinus.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpMinus: function() { return /* binding */ OpMinus; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * The minus operator supports:\n * <ul>\n * <li>subtraction of numbers\n * <li>subtraction of an int from a string of one character\n * (effectively decreasing that character), so 'd'-3='a'\n * </ul>\n *\n * <p>It can be used as a unary operator for numbers.\n * The standard promotions are performed when the operand types vary (double-int=double).\n * For other options it defers to the registered overloader.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Giovanni Dall'Oglio Risso\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('op-minus', position, left, right);\n  node.getValue = function (state) {\n    if (!right) {\n      return -left.getValue(state);\n    }\n    return left.getValue(state) - right.getValue(state);\n  };\n  return node;\n}\nvar OpMinus = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpMinus.js?")},"./src/ast/OpModulus.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpModulus: function() { return /* binding */ OpModulus; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Implements the modulus operator.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Giovanni Dall\'Oglio Risso\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-modulus\', position, left, right);\n  node.getValue = function (state) {\n    return left.getValue(state) % right.getValue(state);\n  };\n  return node;\n}\nvar OpModulus = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpModulus.js?')},"./src/ast/OpMultiply.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpMultiply: function() { return /* binding */ OpMultiply; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Implements the {@code multiply} operator.\n *\n * <p>Conversions and promotions are handled as defined in\n * <a href=\"http://java.sun.com/docs/books/jls/third_edition/html/conversions.html\">Section 5.6.2 of the\n * Java Language Specification</a>, with the addiction of {@code BigDecimal}/{@code BigInteger} management:\n *\n * <p>If any of the operands is of a reference type, unboxing conversion (Section 5.1.8)\n * is performed. Then:<br>\n * If either operand is of type {@code BigDecimal}, the other is converted to {@code BigDecimal}.<br>\n * If either operand is of type double, the other is converted to double.<br>\n * Otherwise, if either operand is of type float, the other is converted to float.<br>\n * If either operand is of type {@code BigInteger}, the other is converted to {@code BigInteger}.<br>\n * Otherwise, if either operand is of type long, the other is converted to long.<br>\n * Otherwise, both operands are converted to type int.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Sam Brannen\n * @author Giovanni Dall'Oglio Risso\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('op-multiply', position, left, right);\n  node.getValue = function (state) {\n    var leftValue = left.getValue(state),\n      rightValue = right.getValue(state);\n    if (typeof leftValue === 'number' && typeof rightValue === 'number') {\n      return leftValue * rightValue;\n    }\n\n    //repeats (ex. 'abc' * 2 = 'abcabc')\n    if (typeof leftValue === 'string' && typeof rightValue === 'number') {\n      var s = '',\n        i = 0;\n      for (; i < rightValue; i += 1) {\n        s += leftValue;\n      }\n      return s;\n    }\n    return null;\n  };\n  return node;\n}\nvar OpMultiply = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpMultiply.js?")},"./src/ast/OpNE.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpNE: function() { return /* binding */ OpNE; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Implements the not-equal operator.\n *\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-ne\', position, left, right);\n  node.getValue = function (state) {\n    /* James Chu, Potix, 20220826, unwrap observable if any*/\n    return !_SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.isEqualValue(left.getValue(state), right.getValue(state));\n  };\n  return node;\n}\nvar OpNE = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpNE.js?')},"./src/ast/OpNot.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpNot: function() { return /* binding */ OpNot; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents a NOT operation.\n *\n * @author Andy Clement\n * @author Mark Fisher\n * @author Oliver Becker\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, expr) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-not\', position, expr);\n  node.getValue = function (state) {\n    return !expr.getValue(state);\n  };\n  return node;\n}\nvar OpNot = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpNot.js?')},"./src/ast/OpOr.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpOr: function() { return /* binding */ OpOr; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents the boolean OR operation.\n *\n * @author Andy Clement\n * @author Mark Fisher\n * @author Oliver Becker\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-or\', position, left, right);\n  node.getValue = function (state) {\n    //double bang for javascript\n    return !!left.getValue(state) || !!right.getValue(state);\n  };\n  return node;\n}\nvar OpOr = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpOr.js?')},"./src/ast/OpPlus.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpPlus: function() { return /* binding */ OpPlus; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * The plus operator will:\n * <ul>\n * <li>add numbers\n * <li>concatenate strings\n * </ul>\n *\n * <p>It can be used as a unary operator for numbers.\n * The standard promotions are performed when the operand types vary (double+int=double).\n * For other options it defers to the registered overloader.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Ivo Smid\n * @author Giovanni Dall\'Oglio Risso\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, left, right) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-plus\', position, left, right);\n  node.getValue = function (state) {\n    if (!right) {\n      return +left.getValue(state);\n    }\n    //javascript will handle string concatenation or addition depending on types\n    return left.getValue(state) + right.getValue(state);\n  };\n  return node;\n}\nvar OpPlus = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpPlus.js?')},"./src/ast/OpPower.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpPower: function() { return /* binding */ OpPower; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * The power operator.\n *\n * @author Andy Clement\n * @author Giovanni Dall\'Oglio Risso\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, base, exp) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'op-power\', position, base, exp);\n  node.getValue = function (state) {\n    return Math.pow(base.getValue(state), exp.getValue(state));\n  };\n  return node;\n}\nvar OpPower = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/OpPower.js?')},"./src/ast/Projection.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Projection: function() { return /* binding */ Projection; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents projection, where a given operation is performed on all elements in some\n * input sequence, returning a new sequence of the same size. For example:\n * "{1,2,3,4,5,6,7,8,9,10}.!{#isEven(#this)}" returns "[n, y, n, y, n, y, n, y, n, y]"\n *\n * @author Andy Clement\n * @author Mark Fisher\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction projectCollection(collection, expr, state) {\n  return collection.map(function (element) {\n    var matches;\n    state.activeContext.push(element);\n    matches = expr.getValue(state);\n    state.activeContext.pop();\n    return matches;\n  });\n}\nfunction createNode(nullSafeNavigation, position, expr) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'projection\', position, expr);\n  node.getValue = function (state) {\n    var collection = state.activeContext.peek(),\n      entries = [],\n      key;\n    if (Array.isArray(collection)) {\n      return projectCollection(collection, expr, state);\n    } else if (typeof collection === \'object\') {\n      for (key in collection) {\n        if (collection.hasOwnProperty(key)) {\n          entries.push(collection[key]);\n        }\n      }\n      return projectCollection(entries, expr, state);\n    }\n    return null;\n  };\n  return node;\n}\nvar Projection = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/Projection.js?')},"./src/ast/PropertyReference.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   PropertyReference: function() { return /* binding */ PropertyReference; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents a simple property or field reference.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Clark Duplichien\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(nullSafeNavigation, propertyName, position) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('property', position);\n  node.toString = node.getRaw = function () {\n    return propertyName;\n  };\n  node.getValue = function (state) {\n    var context = state.activeContext.peek();\n    if (!context) {\n      /* James Chu, Potix, 20211026, allow null value */\n      return null;\n    }\n    if (!Object.hasOwnProperty.call(context, propertyName)) {\n      //handle safe navigation\n      if (nullSafeNavigation || context === window.clientbind.RemoteEL) {\n        return null;\n      }\n\n      //handle conversion of Java properties to JavaScript properties\n      if (propertyName === 'size' && Array.isArray(context)) {\n        return context.length;\n      }\n      if (Object.hasOwnProperty.call(context, '$data$')) {\n        context = context['$data$'];\n        if (context == null) return null;\n      } else if (Object.hasOwnProperty.call(context, '$map$')) {\n        return context[propertyName];\n      }\n      if (Object.hasOwnProperty.call(context, '_@t') && context['_@t'] === 'date') {\n        let bean = window.Dates.newInstance(context['_@n'], 'UTC');\n        if (bean) {\n          if (bean[propertyName] == null) {\n            let methodName = 'get' + propertyName.charAt(0).toUpperCase() + propertyName.substring(1);\n            if (typeof bean[methodName] === 'function') {\n              return bean[methodName]();\n            }\n          } else {\n            return bean[propertyName];\n          }\n        }\n      }\n      if (Object.hasOwnProperty.call(context, propertyName)) {\n        return context[propertyName];\n      }\n\n      /* Jumper Chen, Potix 20221101, handle widget's getter if any */\n      if (typeof context.get === 'function') {\n        // try getExtraAttr() first.\n        if (typeof context.getExtraAttr === 'function') {\n          var extraAttr = context.getExtraAttr(propertyName);\n          if (extraAttr != null) {\n            return extraAttr;\n          }\n        }\n        return context.get(propertyName);\n      }\n\n      /* Jumper Chen, Potix 20221103, handle BindEL Resovlers */\n      if (state.rootContext === context) {\n        // resolve the property recursively\n        if (typeof context.resolve === 'function') {\n          return context.resolve(node, propertyName);\n        }\n      }\n      throw {\n        name: 'PropertyNotFoundException',\n        message: 'Property \\'' + propertyName + '\\' does not exist.'\n      };\n    }\n    return context[propertyName];\n  };\n  node.setValue = function (value, state) {\n    var context = state.activeContext.peek();\n    if (!context) {\n      throw {\n        name: 'ContextDoesNotExistException',\n        message: 'Attempting to assign property \\'' + propertyName + '\\' for an undefined context.'\n      };\n    }\n\n    /*jshint -W093 */\n    return context[propertyName] = value;\n    /*jshint +W093 */\n  };\n\n  node.getName = function () {\n    return propertyName;\n  };\n  return node;\n}\nvar PropertyReference = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/PropertyReference.js?")},"./src/ast/QualifiedIdentifier.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   QualifiedIdentifier: function() { return /* binding */ QualifiedIdentifier; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2019 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      https://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents a dot separated sequence of strings that indicate a package qualified type\n * reference.\n *\n * <p>Example: "java.lang.String" as in the expression "new java.lang.String(\'hello\')"\n *\n * @author Andy Clement\n * @since 3.0\n */\nfunction createNode(position, pieces) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'qualifiedidentifier\', position, ...pieces);\n  node.getRaw = function () {\n    return pieces.map(p => p.getRaw());\n  };\n  node.getValue = function (state) {\n    throw {\n      name: \'MethodNotImplementedException\',\n      message: \'QualifiedIdentifier: Not implemented\'\n    };\n  };\n  return node;\n}\nvar QualifiedIdentifier = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/QualifiedIdentifier.js?')},"./src/ast/Selection.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Selection: function() { return /* binding */ Selection; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents selection over a map or collection.\n * For example: {1,2,3,4,5,6,7,8,9,10}.?{#isEven(#this) == 'y'} returns [2, 4, 6, 8, 10]\n *\n * <p>Basically a subset of the input data is returned based on the\n * evaluation of the expression supplied as selection criteria.\n *\n * @author Andy Clement\n * @author Mark Fisher\n * @author Sam Brannen\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction matches(element, expr, state) {\n  var doesMatch = false;\n  state.activeContext.push(element);\n  doesMatch = expr.getValue(state);\n  state.activeContext.pop();\n  return doesMatch;\n}\nfunction selectFromArray(collection, whichElement, expr, state) {\n  var newCollection = collection.filter(function (element) {\n    return matches(element, expr, state);\n  });\n  switch (whichElement) {\n    case 'ALL':\n      return newCollection;\n    case 'FIRST':\n      return newCollection[0] || null;\n    case 'LAST':\n      if (newCollection.length) {\n        return newCollection[newCollection.length - 1];\n      }\n      return null;\n  }\n}\nfunction selectFromMap(collection, whichElement, expr, state) {\n  var newCollection = {},\n    entry,\n    key,\n    entries = [],\n    returnValue = {};\n  for (key in collection) {\n    if (collection.hasOwnProperty(key)) {\n      entry = {\n        key: key,\n        value: collection[key]\n      };\n      if (matches(entry, expr, state)) {\n        entries.push(entry);\n      }\n    }\n  }\n  switch (whichElement) {\n    case 'ALL':\n      entries.forEach(function (entry) {\n        newCollection[entry.key] = entry.value;\n      });\n      return newCollection;\n    case 'FIRST':\n      if (entries.length) {\n        returnValue[entries[0].key] = entries[0].value;\n        return returnValue;\n      }\n      return null;\n    case 'LAST':\n      if (entries.length) {\n        returnValue[entries[entries.length - 1].key] = entries[entries.length - 1].value;\n        return returnValue;\n      }\n      return null;\n  }\n  entries.forEach(function (entry) {\n    newCollection[entry.key] = entry.value;\n  });\n}\nfunction createNode(nullSafeNavigation, whichElement, position, expr) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('selection', position, expr);\n  node.getValue = function (state) {\n    var collection = state.activeContext.peek();\n    if (collection) {\n      if (Array.isArray(collection)) {\n        return selectFromArray(collection, whichElement, expr, state);\n      } else if (typeof collection === 'object') {\n        return selectFromMap(collection, whichElement, expr, state);\n      }\n    }\n    return null;\n  };\n  return node;\n}\nvar Selection = {\n  create: createNode,\n  FIRST: 'FIRST',\n  LAST: 'LAST',\n  ALL: 'ALL'\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/Selection.js?")},"./src/ast/SpelNode.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SpelNode: function() { return /* binding */ SpelNode; }\n/* harmony export */ });\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * The common supertype of all AST nodes in a parsed Spring Expression Language\n * format expression.\n *\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createSpelNode(nodeType, position) {\n  var node = {},\n    type = nodeType || 'Abstract',\n    children = [],\n    parent = null,\n    activeContext;\n  node._type = type;\n  node.getType = function () {\n    return type;\n  };\n  node.setType = function (nodeType) {\n    type = nodeType;\n  };\n  node.getChildren = function () {\n    return children;\n  };\n  node.addChild = function (childNode) {\n    if (!childNode) {\n      // See OpMinus and OpPlus: right node can be null for unary mode\n      return;\n    }\n    if (!childNode.setParent) {\n      throw {\n        name: 'Error',\n        message: 'Trying to add a child which is not a node: ' + JSON.stringify(childNode)\n      };\n    }\n    childNode.setParent(node);\n    children.push(childNode);\n  };\n  node.getParent = function () {\n    return parent;\n  };\n  node.setParent = function (parentNode) {\n    parent = parentNode;\n  };\n  node.getContext = function (state) {\n    return activeContext || state.activeContext.peek();\n  };\n  node.setContext = function (nodeContext) {\n    activeContext = nodeContext;\n  };\n  node.getStartPosition = function () {\n    return position >> 16;\n  };\n  node.getEndPosition = function () {\n    return position & 0xffff;\n  };\n\n  //must override\n  node.getValue = function () {\n    throw {\n      name: 'MethodNotImplementedException',\n      message: 'SpelNode#getValue() must be overridden.'\n    };\n  };\n  node.toString = function () {\n    var s = 'Kind: ' + node.getType();\n    //s += ', Value: ' + node.getValue();\n    s += ', Children: [';\n    for (var i = 0, l = node.getChildren().length; i < l; i += 1) {\n      s += '{' + node.getChildren()[i] + '}, ';\n    }\n    s += ']';\n    return s;\n  };\n\n  //constructor\n  if (position === 0) {\n    throw {\n      name: 'Error',\n      message: 'Position cannot be 0'\n    };\n  }\n  for (var _len = arguments.length, operands = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {\n    operands[_key - 2] = arguments[_key];\n  }\n  if (operands) {\n    operands.forEach(function (operand) {\n      node.addChild(operand);\n    });\n  }\n  return node;\n}\n\n/* James Chu, Potix, 20220826, unwrap observable if any*/\nfunction isEqualValue(obj1, obj2) {\n  if (obj1 === null || obj1 === undefined) {\n    return obj1 === obj2;\n  } else if (obj2 === null || obj2 === undefined) {\n    return false;\n  }\n  if (Object.hasOwnProperty.call(obj1, '$lc$') && Object.hasOwnProperty.call(obj2, '$lc$')) {\n    if (Object.hasOwnProperty.call(obj1, '$set$') == Object.hasOwnProperty.call(obj2, '$set$')) {\n      obj1 = mobx.isObservable(obj1) ? mobx.toJS(obj1)['$lc$'] : obj1['$lc$'];\n      obj2 = mobx.isObservable(obj2) ? mobx.toJS(obj2)['$lc$'] : obj2['$lc$'];\n    }\n  }\n  let obj1Type = typeof obj1,\n    obj2Type = typeof obj2;\n  if (obj1Type != obj2Type) {\n    return false;\n  } else if (obj1Type == 'object') {\n    let obj1Keys = Object.keys(obj1),\n      obj2Keys = Object.keys(obj2);\n    if (obj1Keys.length != obj2Keys.length) {\n      return false;\n    } else {\n      for (let key in obj1) {\n        if (!isEqualValue(obj1[key], obj2[key])) {\n          return false;\n        }\n      }\n      return true;\n    }\n  } else {\n    return obj1 === obj2;\n  }\n}\nvar SpelNode = {\n  create: createSpelNode,\n  isEqualValue: isEqualValue\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/SpelNode.js?")},"./src/ast/StringLiteral.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   StringLiteral: function() { return /* binding */ StringLiteral; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Expression language AST node that represents a string literal.\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(value, position) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('string', position),\n    raw = value;\n\n  /* Jumper Chen, Potix 20221115 */\n  node.toString = node.getRaw = function () {\n    return raw;\n  };\n  function stripQuotes(value) {\n    if (value[0] === '\\'' && value[value.length - 1] === '\\'' || value[0] === '\"' && value[value.length - 1] === '\"') {\n      value = value.substring(1, value.length - 1);\n    }\n    return value.replace(/''/g, '\\'').replace(/\"\"/g, '\"');\n  }\n\n  //value cannot be null so no check\n  value = stripQuotes(value);\n  node.getValue = function () {\n    return value;\n  };\n  node.setValue = function (newValue) {\n    /*jshint -W093 */\n    return value = newValue;\n    /*jshint +W093 */\n  };\n\n  return node;\n}\nvar StringLiteral = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/StringLiteral.js?")},"./src/ast/Ternary.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Ternary: function() { return /* binding */ Ternary; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents a ternary expression, for example: "someCheck()?true:false".\n *\n * @author Andy Clement\n * @author Juergen Hoeller\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(position, expression, ifTrue, ifFalse) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'ternary\', position, expression, ifTrue, ifFalse);\n  node.toString = function () {\n    return expression + \' ? \' + ifTrue.toString() + \' : \' + ifFalse.toString();\n  };\n  node.getValue = function (state) {\n    return expression.getValue(state) ? ifTrue.getValue(state) : ifFalse.getValue(state);\n  };\n  return node;\n}\nvar Ternary = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/Ternary.js?')},"./src/ast/TypeReference.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TypeReference: function() { return /* binding */ TypeReference; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ "./src/ast/SpelNode.js");\n/*\n * Copyright 2002-2019 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      https://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents a reference to a type, for example\n * {@code "T(String)" or "T(com.somewhere.Foo)"}.\n *\n * @author Andy Clement\n */\nfunction createNode(position, node, _dims) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create(\'typeref\', position, node);\n  node.getValue = function (state) {\n    throw {\n      name: \'MethodNotImplementedException\',\n      message: \'TypeReference: Not implemented\'\n    };\n  };\n  return node;\n}\nvar TypeReference = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/TypeReference.js?')},"./src/ast/VariableReference.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   VariableReference: function() { return /* binding */ VariableReference; }\n/* harmony export */ });\n/* harmony import */ var _SpelNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelNode */ \"./src/ast/SpelNode.js\");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/**\n * Represents a variable reference, eg. #someVar. Note this is different to a *local*\n * variable like $someVar\n *\n * @author Andy Clement\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction createNode(variableName, position) {\n  var node = _SpelNode__WEBPACK_IMPORTED_MODULE_0__.SpelNode.create('variable', position);\n  node.getRaw = function () {\n    return variableName;\n  };\n  node.getValue = function (state) {\n    var context = state.activeContext.peek(),\n      locals = state.locals;\n    if (!context) {\n      throw {\n        name: 'ContextDoesNotExistException',\n        message: 'Attempting to look up variable \\'' + variableName + '\\' for an undefined context.'\n      };\n    }\n\n    //there are 2 keywords (root, this) that need to be dealt with\n    if (variableName === 'this') {\n      return context;\n    }\n    if (variableName === 'root') {\n      return state.rootContext;\n    }\n    return locals[variableName];\n  };\n  node.setValue = function (value, state) {\n    var locals = state.locals;\n\n    /*jshint -W093 */\n    return locals[variableName] = value;\n    /*jshint +W093 */\n  };\n\n  return node;\n}\nvar VariableReference = {\n  create: createNode\n};\n\n//# sourceURL=webpack://spel2js/./src/ast/VariableReference.js?")},"./src/lib/Stack.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Stack: function() { return /* binding */ Stack; }\n/* harmony export */ });\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @author Ben March\n * @since 0.2.0\n */\n\nfunction Stack(startingElements) {\n  this.elements = startingElements || [];\n}\nStack.prototype.push = function (el) {\n  this.elements.push(el);\n  return el;\n};\nStack.prototype.pop = function () {\n  return this.elements.pop();\n};\nStack.prototype.peek = function () {\n  return this.elements[this.elements.length - 1];\n};\nStack.prototype.empty = function () {\n  return this.elements.length > 0;\n};\nStack.prototype.search = function (el) {\n  return this.elements.length - this.elements.indexOf(el);\n};\n\n//# sourceURL=webpack://spel2js/./src/lib/Stack.js?')},"./src/main.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SpelExpressionEvaluator: function() { return /* reexport safe */ _SpelExpressionEvaluator__WEBPACK_IMPORTED_MODULE_0__.SpelExpressionEvaluator; },\n/* harmony export */   StandardContext: function() { return /* reexport safe */ _StandardContext__WEBPACK_IMPORTED_MODULE_1__.StandardContext; }\n/* harmony export */ });\n/* harmony import */ var _SpelExpressionEvaluator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpelExpressionEvaluator */ "./src/SpelExpressionEvaluator.js");\n/* harmony import */ var _StandardContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./StandardContext */ "./src/StandardContext.js");\n/*\n * Copyright 2002-2015 the original author or authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @author Ben March\n * @since 0.2.0\n */\n\n\n\n\n\n//# sourceURL=webpack://spel2js/./src/main.js?')}},__webpack_module_cache__={};function __webpack_require__(e){var n=__webpack_module_cache__[e];return void 0!==n||(n=__webpack_module_cache__[e]={exports:{}},__webpack_modules__[e](n,n.exports,__webpack_require__)),n.exports}__webpack_require__.d=function(e,n){for(var t in n)__webpack_require__.o(n,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:n[t]})},__webpack_require__.o=function(e,n){return Object.prototype.hasOwnProperty.call(e,n)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var __webpack_exports__=__webpack_require__("./src/main.js");return __webpack_exports__});