/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind.ui.sys;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.owasp.encoder.Encode;
import org.zkoss.bind.impl.AnnotationUtil;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.clientbind.ui.util.ObjectMappers;
import org.zkoss.html.HTMLs;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.util.Locales;
import org.zkoss.zhtml.Text;
import org.zkoss.zhtml.impl.AbstractTag;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlNativeComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.AttributesInfo;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.NativeInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.Property;
import org.zkoss.zk.ui.metainfo.ShadowInfo;
import org.zkoss.zk.ui.metainfo.TemplateInfo;
import org.zkoss.zk.ui.metainfo.TextInfo;
import org.zkoss.zk.ui.metainfo.ZkInfo;
import org.zkoss.zk.ui.sys.ComponentRedraws;
import org.zkoss.zk.ui.sys.JsContentRenderer;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.Condition;
import org.zkoss.zk.ui.util.ConditionImpl;
import org.zkoss.zk.ui.util.ForEach;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zk.ui.util.TemplateCtrl;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.impl.MeshElement;

public class HtmlTemplateRenders {
    private static final Native.Helper _nativeHelper = new HtmlNativeComponent.HtmlHelper();
    private static final String DEFAULT = "default";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String renderTemplate(Template template, Component comp, Set<String> depends) {
        if (template instanceof TemplateCtrl) {
            TemplateCtrl ctrl = (TemplateCtrl)template;
            StringBuilder sb = new StringBuilder();
            TemplateInfo parentInfo = ctrl.getMeta();
            try {
                ComponentRedraws.saveStates();
                ReplaceableText replaceableText = new ReplaceableText();
                HtmlTemplateRenders.processNode(sb, (NodeInfo)parentInfo, comp, replaceableText, depends);
            }
            finally {
                ComponentRedraws.restoreStates();
            }
            return sb.toString();
        }
        throw new IllegalArgumentException("Unknown template: [" + String.valueOf(template) + "]");
    }

    private static boolean isEffective(Condition cond, Page page, Component comp) {
        return comp != null ? cond.isEffective(comp) : cond.isEffective(page);
    }

    private static void renderProperties(JsContentRenderer renderer, ComponentInfo info, Component comp, Class infoClass) {
        if (Hbox.class.isAssignableFrom(infoClass)) {
            renderer.render("mold", "horizontal");
        }
        if (Datebox.class.isAssignableFrom(infoClass)) {
            try {
                Datebox datebox = (Datebox)infoClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Locale locale = datebox.getLocale();
                renderer.render("format", datebox.getRealFormat());
                renderer.render("localizedFormat", new SimpleDateFormat(datebox.getRealFormat(), locale != null ? locale : Locales.getCurrent()).toLocalizedPattern());
            }
            catch (Exception e) {
                renderer.render("format", "yyyy/MM/dd");
                renderer.render("localizedFormat", "yyyy/MM/dd");
            }
        } else if (Treeitem.class.isAssignableFrom(infoClass)) {
            renderer.render("_loaded", true);
        }
        info.getProperties().forEach(prop -> renderer.render(prop.getName(), prop.isNativeInfo() ? prop.getValue(comp) : prop.getRawValue()));
        AnnotationMap annotationMap = info.getAnnotationMap();
        if (annotationMap != null) {
            LinkedHashMap allBindings = new LinkedHashMap();
            annotationMap.getAnnotatedProperties().forEach(key -> {
                Collection annotations = annotationMap.getAnnotations(key);
                if (annotations != null && !annotations.isEmpty()) {
                    boolean[] atIdExisted = new boolean[]{false};
                    annotations.forEach(annot -> {
                        String name = annot.getName();
                        if (HtmlTemplateRenders.isEventProperty(key)) {
                            if ("command".equals(name) || "global-command".equals(name)) {
                                Map values = (Map)allBindings.computeIfAbsent("@" + name, ignore -> new LinkedHashMap());
                                values.put(key, annot.getAttributes());
                            }
                        } else if ("bind".equals(name)) {
                            ClientBindComposer.processPropertyBinding(allBindings, key, "save", HtmlTemplateRenders.processPropertySave(info, key, annot), true);
                            ClientBindComposer.processPropertyBinding(allBindings, key, "load", HtmlTemplateRenders.processPropertyLoad(info, key, annot), true);
                        } else if ("load".equals(name)) {
                            ClientBindComposer.processPropertyBinding(allBindings, key, name, HtmlTemplateRenders.processPropertyLoad(info, key, annot), true);
                        } else if ("save".equals(name)) {
                            ClientBindComposer.processPropertyBinding(allBindings, key, name, HtmlTemplateRenders.processPropertySave(info, key, annot), true);
                        } else if ("init".equals(name)) {
                            ClientBindComposer.processPropertyBinding(allBindings, key, name, HtmlTemplateRenders.processPropertyLoad(info, key, annot), true);
                        } else if ("id".equals(name)) {
                            if (atIdExisted[0] && key.equals("viewModel")) {
                                throw new IllegalSyntaxException(MiscUtil.formatLocationMessage((String)"Allow only one @id to assign the name of view model", (Annotation)annot));
                            }
                            atIdExisted[0] = true;
                            ClientBindComposer.processPropertyBinding(allBindings, key, name, annot.getAttributes());
                        } else if ("validator".equals(name) || "ref".equals(name) || "converter".equals(name) || "template".equals(name)) {
                            ClientBindComposer.processPropertyBinding(allBindings, key, name, annot.getAttributes());
                        }
                    });
                }
            });
            for (Map.Entry me : allBindings.entrySet()) {
                renderer.render("'" + String.valueOf(me.getKey()) + "'", me.getValue());
            }
        }
    }

    private static boolean isEventProperty(String propName) {
        return propName.startsWith("on") && propName.length() >= 3 && Character.isUpperCase(propName.charAt(2));
    }

    private static Map<String, String[]> processPropertySave(ComponentInfo info, String prop, Annotation annot) {
        HashMap<String, String[]> attributes = new HashMap<String, String[]>(annot.getAttributes());
        Annotation annotation = HtmlTemplateRenders.getSystemAnnotation(info, prop);
        if (annotation != null) {
            Map attrs = annotation.getAttributes();
            String rw = AnnotationUtil.testString((String[])((String[])attrs.get("ACCESS")), (Annotation)annotation);
            if (!"both".equals(rw) && !"save".equals(rw)) {
                return Collections.emptyMap();
            }
            String evtnm = AnnotationUtil.testString((String[])((String[])attrs.get("SAVE_EVENT")), (Annotation)annotation);
            String saveRep = AnnotationUtil.testString((String[])((String[])attrs.get("SAVE_REPLACEMENT")), (Annotation)annotation);
            if (evtnm != null) {
                attributes.put("SAVE_EVENT", new String[]{evtnm});
            }
            if (saveRep != null) {
                attributes.put("SAVE_REPLACEMENT", new String[]{saveRep});
            }
        } else if (!"form".equals(prop)) {
            return Collections.emptyMap();
        }
        return attributes;
    }

    private static Map<String, String[]> processPropertyLoad(ComponentInfo info, String prop, Annotation annot) {
        HashMap<String, String[]> attributes = new HashMap<String, String[]>(annot.getAttributes());
        Annotation annotation = HtmlTemplateRenders.getSystemAnnotation(info, prop);
        String type = null;
        if (annotation != null) {
            Map attrs = annotation.getAttributes();
            String rw = AnnotationUtil.testString((String[])((String[])attrs.get("ACCESS")), (Annotation)annotation);
            if (rw != null && !"both".equals(rw) && !"load".equals(rw)) {
                return Collections.emptyMap();
            }
            String evtnm = AnnotationUtil.testString((String[])((String[])attrs.get("LOAD_EVENT")), (Annotation)annotation);
            type = AnnotationUtil.testString((String[])((String[])attrs.get("LOAD_TYPE")), (Annotation)annotation);
            String loadRep = AnnotationUtil.testString((String[])((String[])attrs.get("LOAD_REPLACEMENT")), (Annotation)annotation);
            if (evtnm != null) {
                attributes.put("LOAD_EVENT", new String[]{evtnm});
            }
            if (loadRep != null) {
                attributes.put("LOAD_REPLACEMENT", new String[]{loadRep});
            }
        }
        return HtmlTemplateRenders.processPropertyLoad((Class)info.getComponentDefinition().getImplementationClass(), prop, annot, type);
    }

    private static Map<String, String[]> processPropertyLoad(Class<?> compClz, String prop, Annotation annot, String type) {
        HashMap<String, String[]> attributes = new HashMap<String, String[]>(annot.getAttributes());
        if (Strings.isBlank((String)type) && ObjectMappers.isPropertyLoadStringType(compClz, prop)) {
            type = "java.lang.String";
        }
        if (!Strings.isBlank((String)type)) {
            attributes.put("LOAD_TYPE", new String[]{type});
        }
        return attributes;
    }

    private static Annotation getSystemAnnotation(ComponentInfo info, String attr) {
        AnnotationMap annoMap = info.getComponentDefinition().getAnnotationMap();
        if (annoMap == null || annoMap.isEmpty()) {
            return null;
        }
        Collection annos = annoMap.getAnnotations(attr, "ZKBIND");
        if (annos.isEmpty()) {
            annos = annoMap.getAnnotations("ZKBIND$" + attr, "ZKBIND");
        }
        if (annos != null && !annos.isEmpty()) {
            return HtmlTemplateRenders.getActivatedAnnotation(annos);
        }
        return null;
    }

    private static Annotation getActivatedAnnotation(Collection<Annotation> annos) {
        if (annos instanceof List) {
            return (Annotation)((List)annos).get(annos.size() - 1);
        }
        Iterator<Annotation> it = annos.iterator();
        Annotation anno = it.next();
        while (it.hasNext()) {
            anno = it.next();
        }
        return anno;
    }

    private static void processZkInfoNodes(StringBuilder out, ZkInfo childInfo, Component comp, ReplaceableText replaceableText, Set<String> depends) {
        if (childInfo.withSwitch()) {
            HtmlTemplateRenders.processSwitch(out, childInfo, comp, replaceableText, depends);
        } else {
            for (NodeInfo info : childInfo.getChildren()) {
                HtmlTemplateRenders.processNode(out, info, comp, replaceableText, depends);
            }
        }
    }

    private static void processSwitch(StringBuilder out, ZkInfo switchInfo, Component parent, ReplaceableText replaceableText, Set<String> depends) {
        Page page = parent.getPage();
        if (!switchInfo.getChildren().isEmpty()) {
            Object switchCond = switchInfo.resolveSwitch(page, parent);
            for (NodeInfo nodeInfo : switchInfo.getChildren()) {
                ZkInfo caseInfo = (ZkInfo)nodeInfo;
                ForEach forEach = caseInfo.resolveForEach(page, parent);
                if (forEach == null) {
                    if (!HtmlTemplateRenders.isEffective((Condition)caseInfo, page, parent) || !HtmlTemplateRenders.isCaseMatched(caseInfo, page, parent, switchCond)) continue;
                    HtmlTemplateRenders.processZkInfoNodes(out, caseInfo, parent, replaceableText, depends);
                    continue;
                }
                while (forEach.next()) {
                    if (!HtmlTemplateRenders.isEffective((Condition)caseInfo, page, parent) || !HtmlTemplateRenders.isCaseMatched(caseInfo, page, parent, switchCond)) continue;
                    HtmlTemplateRenders.processZkInfoNodes(out, caseInfo, parent, replaceableText, depends);
                }
            }
        }
    }

    private static void processNativeInfoNodes(StringBuilder out, NativeInfo nativeInfo, Component comp, ReplaceableText replaceableText, Set<String> depends, String rt) {
        Optional<Property> idProp = nativeInfo.getProperties().stream().filter(e -> "id".equals(e.getName())).findFirst();
        if (idProp.isPresent()) {
            out.append("id:'");
            Property id = idProp.get();
            if (id.isEffective(comp)) {
                out.append(Encode.forJavaScript((String)((String)Classes.coerce(String.class, (Object)id.getValue(comp)))));
            }
            out.append("',");
        }
        StringBuffer prologSb = new StringBuffer(128);
        HtmlTemplateRenders.getNativeFirstHalf(prologSb, comp, nativeInfo);
        out.append("prolog:'");
        if (rt != null) {
            out.append(rt);
        }
        out.append(Encode.forJavaScript((String)prologSb.toString()));
        out.append("',epilog:'");
        StringBuffer epilogSb = new StringBuffer(128);
        HtmlTemplateRenders.getNativeSecondHalf(epilogSb, comp, nativeInfo);
        out.append(Encode.forJavaScript((String)epilogSb.toString()));
        out.append("'},[");
        for (NodeInfo info : nativeInfo.getChildren()) {
            if (info instanceof TextInfo) continue;
            HtmlTemplateRenders.processNode(out, info, comp, replaceableText, depends);
        }
    }

    private static final void getNativeContent(StringBuffer sb, Component comp, List<NodeInfo> children) {
        for (NodeInfo meta : children) {
            ForEach forEach;
            Page page;
            if (meta instanceof NativeInfo) {
                NativeInfo childInfo = (NativeInfo)meta;
                page = comp.getPage();
                forEach = childInfo.resolveForEach(page, comp);
                if (forEach == null) {
                    if (!childInfo.isEffective(comp)) continue;
                    HtmlTemplateRenders.getNativeFirstHalf(sb, comp, childInfo);
                    HtmlTemplateRenders.getNativeSecondHalf(sb, comp, childInfo);
                    continue;
                }
                while (forEach.next()) {
                    if (!childInfo.isEffective(comp)) continue;
                    HtmlTemplateRenders.getNativeFirstHalf(sb, comp, childInfo);
                    HtmlTemplateRenders.getNativeSecondHalf(sb, comp, childInfo);
                }
                continue;
            }
            if (meta instanceof TextInfo) {
                String s = ((TextInfo)meta).getValue(comp);
                if (s == null) continue;
                _nativeHelper.appendText(sb, s);
                continue;
            }
            if (meta instanceof ZkInfo) {
                ZkInfo zkInfo = (ZkInfo)meta;
                if (zkInfo.withSwitch()) {
                    throw new UnsupportedOperationException("<zk switch> in native not allowed yet");
                }
                page = comp.getPage();
                forEach = zkInfo.resolveForEach(page, comp);
                if (forEach == null) {
                    if (!HtmlTemplateRenders.isEffective((Condition)zkInfo, page, comp)) continue;
                    HtmlTemplateRenders.getNativeContent(sb, comp, zkInfo.getChildren());
                    continue;
                }
                while (forEach.next()) {
                    if (!HtmlTemplateRenders.isEffective((Condition)zkInfo, page, comp)) continue;
                    HtmlTemplateRenders.getNativeContent(sb, comp, zkInfo.getChildren());
                }
                continue;
            }
            throw new IllegalArgumentException("Not supported yet! [" + String.valueOf(meta) + "]");
        }
    }

    private static final void getNativeFirstHalf(StringBuffer sb, Component comp, NativeInfo nativeInfo) {
        NativeInfo splitInfo;
        _nativeHelper.getFirstHalf(sb, nativeInfo.getTag(), HtmlTemplateRenders.evalProperties(comp, nativeInfo.getProperties().stream().filter(e -> !"id".equals(e.getName())).collect(Collectors.toList())), (Collection)nativeInfo.getDeclaredNamespaces());
        List prokids = nativeInfo.getPrologChildren();
        if (!prokids.isEmpty()) {
            HtmlTemplateRenders.getNativeContent(sb, comp, prokids);
        }
        if ((splitInfo = nativeInfo.getSplitChild()) != null && splitInfo.isEffective(comp)) {
            HtmlTemplateRenders.getNativeFirstHalf(sb, comp, splitInfo);
        }
    }

    private static final void getNativeSecondHalf(StringBuffer sb, Component comp, NativeInfo nativeInfo) {
        List epikids;
        NativeInfo splitInfo = nativeInfo.getSplitChild();
        if (splitInfo != null && splitInfo.isEffective(comp)) {
            HtmlTemplateRenders.getNativeSecondHalf(sb, comp, splitInfo);
        }
        if (!(epikids = nativeInfo.getEpilogChildren()).isEmpty()) {
            HtmlTemplateRenders.getNativeContent(sb, comp, epikids);
        }
        _nativeHelper.getSecondHalf(sb, nativeInfo.getTag());
    }

    private static final Map<String, Object> evalProperties(Component comp, List<Property> props) {
        if (props == null || props.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(props.size() * 2);
        for (Property prop : props) {
            if (!prop.isEffective(comp)) continue;
            map.put(prop.getName(), Classes.coerce(String.class, (Object)prop.getValue(comp)));
        }
        return map;
    }

    private static boolean isCaseMatched(ZkInfo caseInfo, Page page, Component parent, Object switchCond) {
        Object[] caseValues;
        if (!caseInfo.withCase()) {
            return true;
        }
        for (Object caseValue : caseValues = caseInfo.resolveCase(page, parent)) {
            String casev;
            int len;
            if (!(caseValue instanceof String && switchCond instanceof String && (len = (casev = (String)caseValue).length()) >= 2 && casev.charAt(0) == '/' && casev.charAt(len - 1) == '/' ? Pattern.compile(Pattern.quote(casev.substring(1, len - 1))).matcher((String)switchCond).matches() : Objects.equals((Object)switchCond, (Object)caseValue))) continue;
            return true;
        }
        return false;
    }

    private static void processZhtmlNodes(StringBuilder out, JsContentRenderer renderer, ComponentInfo childInfo, Component comp, ReplaceableText rt, Set<String> depends, Class childInfoClass) {
        Iterator infoIterator = childInfo.getChildren().iterator();
        HtmlTemplateRenders.renderProperties(renderer, childInfo, comp, childInfoClass);
        ComponentDefinition compDef = childInfo.getComponentDefinition();
        depends.add("zhtml");
        out.append("['");
        out.append(compDef.newInstance(comp.getPage(), null).getWidgetClass());
        out.append("',{prolog:'");
        String tagName = compDef.getName();
        out.append("<").append(tagName);
        Map<String, Object> properties = HtmlTemplateRenders.evalProperties(comp, childInfo.getProperties());
        properties.remove("id");
        for (Map.Entry<String, Object> me : properties.entrySet()) {
            if ("textContent".equals(me.getKey())) continue;
            Object v = me.getValue();
            if (v instanceof DeferredValue) {
                v = ((DeferredValue)v).getValue();
            }
            out.append(" ").append((Object)me.getKey()).append("=\"").append(Encode.forHtmlAttribute((String)Objects.toString((Object)v))).append("\"");
        }
        boolean isOrphanTag = HTMLs.isOrphanTag((String)tagName);
        if (isOrphanTag) {
            out.append("/");
        }
        out.append(">");
        Object textContent = properties.get("textContent");
        if (textContent != null) {
            out.append(Encode.forHtml((String)((String)textContent)));
        }
        out.append("',epilog:'");
        if (!isOrphanTag) {
            out.append("</");
            out.append(tagName);
            out.append(">");
        }
        out.append("',");
        out.append(renderer.getBuffer().toString());
        out.append("},[");
        while (infoIterator.hasNext()) {
            NodeInfo info = (NodeInfo)infoIterator.next();
            HtmlTemplateRenders.processNode(out, info, comp, rt, depends);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processNode(StringBuilder out, NodeInfo currentInfo, Component comp, ReplaceableText replaceableText, Set<String> depends) {
        String extra;
        String rt = null;
        ConditionImpl condition = null;
        if (currentInfo instanceof ComponentInfo) {
            ComponentInfo componentInfo = (ComponentInfo)currentInfo;
            condition = componentInfo.getCondition();
            NodeInfo parent = currentInfo.getParent();
            if ((parent instanceof TemplateInfo || parent instanceof ComponentInfo && ((ComponentInfo)parent).getComponentDefinition().isBlankPreserved() || comp instanceof ShadowElement) && !(comp instanceof MeshElement)) {
                rt = replaceableText.text;
            }
            replaceableText.text = componentInfo.getReplaceableText();
            if (replaceableText.text != null) {
                return;
            }
        }
        int order = ComponentRedraws.beforeRedraw((boolean)false);
        try {
            String mold;
            ZkInfo info;
            if (order < 0) {
                out.append('[');
            } else if (order > 0) {
                out.append(',');
            }
            Optional<Object> optional = Optional.empty();
            JsContentRenderer renderer = new JsContentRenderer();
            if (currentInfo instanceof ZkInfo) {
                info = (ZkInfo)currentInfo;
                ForEach forEach = info.resolveForEach(comp.getPage(), comp);
                out.append("['clientbind.ZkInfo',{");
                out.append("},[");
                if (forEach == null) {
                    if (HtmlTemplateRenders.isEffective((Condition)info, comp.getPage(), comp)) {
                        HtmlTemplateRenders.processZkInfoNodes(out, info, comp, replaceableText, depends);
                    }
                } else {
                    while (forEach.next()) {
                        if (!HtmlTemplateRenders.isEffective((Condition)info, comp.getPage(), comp)) continue;
                        HtmlTemplateRenders.processZkInfoNodes(out, info, comp, replaceableText, depends);
                    }
                }
            } else if (currentInfo instanceof NativeInfo) {
                NativeInfo nativeInfo = (NativeInfo)currentInfo;
                out.append("['");
                out.append("zk.Native");
                out.append("',{");
                HtmlTemplateRenders.processNativeInfoNodes(out, nativeInfo, comp, replaceableText, depends, rt);
            } else if (currentInfo instanceof ComponentInfo) {
                Class clz;
                ComponentInfo cmpInfo = (ComponentInfo)currentInfo;
                ComponentDefinition compDef = cmpInfo.getComponentDefinition();
                try {
                    clz = compDef.resolveImplementationClass(comp.getPage(), null);
                }
                catch (ClassNotFoundException e) {
                    throw UiException.Aide.wrap((Throwable)e);
                }
                if (AbstractTag.class.isAssignableFrom(clz)) {
                    HtmlTemplateRenders.processZhtmlNodes(out, renderer, cmpInfo, comp, replaceableText, depends, clz);
                } else {
                    String wgtcls;
                    String pkg;
                    if (Text.class.isAssignableFrom(clz)) {
                        pkg = "zhtml";
                        wgtcls = "zhtml.Text";
                    } else {
                        optional = cmpInfo.getProperties().stream().filter(property -> "mold".equals(property.getName())).findFirst();
                        if (optional.isPresent()) {
                            wgtcls = compDef.getWidgetClass(comp, (String)((Property)optional.get()).getValue(comp));
                        } else {
                            Component target = comp;
                            if (target instanceof ShadowElement) {
                                while (((ShadowElement)target).getShadowHost() == null) {
                                    target = target.getParent();
                                }
                                target = ((ShadowElement)target).getShadowHost();
                            }
                            if (target instanceof Listbox && "select".equals(target.getMold()) && (Listitem.class.isAssignableFrom(clz) || Listgroup.class.isAssignableFrom(clz))) {
                                wgtcls = compDef.getWidgetClass(target, "select");
                                optional = Optional.of(new Property(null, "mold", "select", null));
                            } else {
                                wgtcls = compDef.getDefaultWidgetClass(comp);
                            }
                        }
                        int lastIndexOf = wgtcls.lastIndexOf(".");
                        pkg = wgtcls.substring(0, lastIndexOf);
                    }
                    AnnotationMap annotationMap = cmpInfo.getAnnotationMap();
                    if (annotationMap != null) {
                        Component parent = comp;
                        Composer composer = null;
                        while (parent != null && !((composer = Components.getComposer((Component)parent)) instanceof ClientBindComposer)) {
                            Component shadowHost;
                            if (parent instanceof ShadowElement && (shadowHost = ((ShadowElement)parent).getShadowHost()) != null) {
                                parent = shadowHost;
                                continue;
                            }
                            parent = parent.getParent();
                        }
                        if (composer != null) {
                            for (String prop : annotationMap.getAnnotatedProperties()) {
                                if (!"model".equals(prop) && !"children".equals(prop)) continue;
                                Collection annotations = annotationMap.getAnnotations(prop);
                                for (Annotation annot : annotations) {
                                    String name = annot.getName();
                                    if (!"bind".equals(name) && !"load".equals(name) && !"init".equals(name)) continue;
                                    ((ClientBindComposer)composer).handleModel(new HashMap<String, Object>(), comp, annot.getAttribute("value"), null);
                                }
                            }
                        }
                    }
                    Iterator infoIterator = currentInfo.getChildren().iterator();
                    HtmlTemplateRenders.renderProperties(renderer, cmpInfo, comp, clz);
                    HashMap attributes = new HashMap();
                    for (NodeInfo node : currentInfo.getChildren()) {
                        if (!(node instanceof AttributesInfo)) continue;
                        attributes.putAll(((AttributesInfo)node).getAttrs());
                    }
                    if (!attributes.isEmpty()) {
                        renderer.render("attributes", attributes);
                    }
                    if (rt != null) {
                        renderer.render("prolog", rt);
                    }
                    if (condition != null) {
                        if (condition.isIf()) {
                            renderer.render("if", condition.getIf().getRawValue());
                        }
                        if (condition.isUnless()) {
                            renderer.render("unless", condition.getUnless().getRawValue());
                        }
                    }
                    depends.add(pkg);
                    out.append("['");
                    out.append(wgtcls);
                    out.append("',{");
                    out.append(renderer.getBuffer().toString());
                    out.append("},[");
                    while (infoIterator.hasNext()) {
                        NodeInfo info2 = (NodeInfo)infoIterator.next();
                        if (info2 instanceof AttributesInfo) continue;
                        HtmlTemplateRenders.processNode(out, info2, comp, replaceableText, depends);
                    }
                }
            } else if (currentInfo instanceof ShadowInfo) {
                info = (ShadowInfo)currentInfo;
                ComponentDefinition componentDefinition = info.getComponentDefinition();
                String shadowName = componentDefinition.getName();
                out.append("['clientbind." + shadowName.substring(0, 1).toUpperCase() + shadowName.substring(1) + "Info',{");
                info.getProperties().forEach(property -> {
                    Object value = property.getValue(comp);
                    renderer.render(property.getName(), value == null ? property.getRawValue() : value);
                });
                AnnotationMap annotationMap = info.getAnnotationMap();
                if (annotationMap != null) {
                    LinkedHashMap allBindings = new LinkedHashMap();
                    annotationMap.getAnnotatedProperties().forEach(arg_0 -> HtmlTemplateRenders.lambda$processNode$9(annotationMap, shadowName, comp, allBindings, (ShadowInfo)info, arg_0));
                    for (Map.Entry me : allBindings.entrySet()) {
                        renderer.render("'" + String.valueOf(me.getKey()) + "'", me.getValue());
                    }
                }
                out.append(renderer.getBuffer().toString());
                out.append("},[");
                Iterator infoIterator = currentInfo.getChildren().iterator();
                while (infoIterator.hasNext()) {
                    HtmlTemplateRenders.processNode(out, (NodeInfo)infoIterator.next(), comp, replaceableText, depends);
                }
            } else if (currentInfo instanceof TemplateInfo) {
                info = (TemplateInfo)currentInfo;
                String src = info.getSrc(comp);
                out.append("['clientbind.TemplateInfo',{");
                renderer.render("name", Encode.forJavaScript((String)info.getName()));
                Map parameters = info.getParameters();
                if (parameters != null) {
                    parameters.forEach((key, value) -> renderer.render(key, value.toString()));
                }
                out.append(renderer.getBuffer().toString());
                out.append("},[");
                if (!Strings.isBlank((String)src)) {
                    PageDefinition templatePageDefinition = Executions.getCurrent().getPageDefinition(src);
                    Iterator iterator = templatePageDefinition.getChildren().iterator();
                    while (iterator.hasNext()) {
                        HtmlTemplateRenders.processNode(out, (NodeInfo)iterator.next(), comp, replaceableText, depends);
                    }
                } else {
                    Iterator infoIterator = currentInfo.getChildren().iterator();
                    while (infoIterator.hasNext()) {
                        HtmlTemplateRenders.processNode(out, (NodeInfo)infoIterator.next(), comp, replaceableText, depends);
                    }
                }
            } else if (!(currentInfo instanceof AttributesInfo)) {
                throw new IllegalArgumentException("Not supported yet! [" + String.valueOf(currentInfo) + "]");
            }
            out.append(']');
            String string = mold = optional.isPresent() ? (String)((Property)optional.get()).getValue(comp) : DEFAULT;
            if (!DEFAULT.equals(mold)) {
                out.append(",'");
                out.append(mold);
                out.append('\'');
            }
            out.append(']');
        }
        finally {
            extra = ComponentRedraws.afterRedraw();
        }
        if (order < 0) {
            if (!extra.isEmpty()) {
                out.append(",0,null,'");
                out.append(Encode.forJavaScript((String)extra));
                out.append('\'');
            }
            out.append(']');
        }
    }

    private static /* synthetic */ void lambda$processNode$9(AnnotationMap annotationMap, String shadowName, Component comp, Map allBindings, ShadowInfo info, String property) {
        annotationMap.getAnnotations(property).forEach(annotation -> {
            String name;
            if ("forEach".equals(shadowName) && "items".equals(property)) {
                Component parent = comp;
                Composer composer = null;
                while (parent != null && !((composer = Components.getComposer((Component)parent)) instanceof ClientBindComposer)) {
                    Component shadowHost;
                    if (parent instanceof ShadowElement && (shadowHost = ((ShadowElement)parent).getShadowHost()) != null) {
                        parent = shadowHost;
                        continue;
                    }
                    parent = parent.getParent();
                }
                if (composer != null) {
                    ((ClientBindComposer)composer).handleModel(new HashMap<String, Object>(), comp, annotation.getAttribute("value"), null);
                }
            }
            if ("bind".equals(name = annotation.getName())) {
                ClientBindComposer.processPropertyBinding(allBindings, property, "save", annotation.getAttributes(), true);
                ClientBindComposer.processPropertyBinding(allBindings, property, "load", HtmlTemplateRenders.processPropertyLoad((Class)info.getComponentDefinition().getImplementationClass(), property, annotation, null), true);
            } else {
                boolean isInitSave;
                boolean bl = isInitSave = "init".equals(name) || "save".equals(name);
                if ("load".equals(name)) {
                    ClientBindComposer.processPropertyBinding(allBindings, property, name, HtmlTemplateRenders.processPropertyLoad((Class)info.getComponentDefinition().getImplementationClass(), property, annotation, null), true);
                } else {
                    ClientBindComposer.processPropertyBinding(allBindings, property, name, annotation.getAttributes(), isInitSave);
                }
            }
        });
    }

    private static class ReplaceableText {
        private String text;

        private ReplaceableText() {
        }
    }
}

