/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import java.util.Map;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.util.Clients;

public class ValidateBindingCommand {
    private ClientBindComposer composer;
    private Component view;

    private ValidateBindingCommand(ClientBindComposer composer) {
        this.composer = composer;
        this.view = composer.view;
    }

    private boolean process(String command, Map<String, Object> data) {
        Map args = (Map)data.get("args");
        Map validatorData = (Map)args.get("$vbd$");
        Map validatorProperty = (Map)args.get("$vbp$");
        Object bean = this.composer.getCachedBeanById((String)validatorProperty.get("$id$"));
        if (bean == null) {
            throw new NullPointerException("Bean is null [" + String.valueOf(validatorProperty.get("$id$")) + "]");
        }
        String converterExpr = (String)args.get("cv");
        Object value = validatorProperty.get("value");
        Component comp = this.view.getDesktop().getComponentByUuidIfAny((String)validatorProperty.get("uuid"));
        value = converterExpr != null ? this.composer.doConvertCoerceToBean(value, comp, converterExpr, (Map)args.get("cvp")) : this.composer.coerceToBeanProp(bean, (String)validatorProperty.get("prop"), value);
        boolean isValid = this.composer.doValidate(validatorData, validatorProperty, bean, comp, (String)validatorProperty.get("prop"), value);
        Clients.sendClientCommand((Component)this.view, (String)command, (Object)isValid);
        return true;
    }

    public static boolean processCommand(ClientBindComposer composer, String command, Map<String, Object> data) {
        return new ValidateBindingCommand(composer).process(command, data);
    }
}

