/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;

class ClientStepModelDataListener
implements ListDataListener {
    private String _expr;
    private Component _view;
    private ClientBindComposer _composer;

    ClientStepModelDataListener(ClientBindComposer composer, String expr) {
        this._composer = composer;
        this._view = composer.view;
        this._expr = expr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientStepModelDataListener that = (ClientStepModelDataListener)o;
        return Objects.equals(this._expr, that._expr);
    }

    public int hashCode() {
        return Objects.hash(this._expr);
    }

    public void onChange(ListDataEvent event) {
        if (this._composer.view.hasAttribute("$DISABLE_CLIENT_UPDATE$")) {
            return;
        }
        int type = event.getType();
        if (4 != type) {
            try {
                ArrayList<Object> elements;
                String vmExprPrefix = String.valueOf(this._view.getAttribute("$VM_ID$")) + ".";
                String expr = this._expr;
                if (expr.startsWith(vmExprPrefix)) {
                    expr = expr.substring(vmExprPrefix.length());
                }
                ListModel model = event.getModel();
                int modelSize = model.getSize();
                int size = Math.min(modelSize, modelSize);
                ArrayList<Object> elementsList = elements = new ArrayList<Object>();
                for (int i = 0; i < size; ++i) {
                    elementsList.add(model.getElementAt(i));
                }
                Executions.getCurrent().setAttribute("$IGNORE_FIRST_LIST_ID$", (Object)true);
                JavaScriptValue updatedListModel = new JavaScriptValue("{" + expr + ":" + this._composer.writeValueAsString(elements) + "}");
                Clients.response((String)(expr + "$" + type), (AuResponse)new AuInvoke(this._view, "update@vm", new Object[]{expr, updatedListModel}));
            }
            catch (JsonProcessingException e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        } else {
            String expr = this._expr;
            String vmExprPrefix = String.valueOf(this._view.getAttribute("$VM_ID$")) + ".";
            if (expr.startsWith(vmExprPrefix)) {
                expr = expr.substring(vmExprPrefix.length());
            }
            ListModel model = event.getModel();
            Set selection = ((Selectable)model).getSelection();
            int activeIndex = -1;
            if (selection.size() > 0) {
                Object selected = selection.iterator().next();
                for (int i = 0; i < model.getSize(); ++i) {
                    if (!model.getElementAt(i).equals(selected)) continue;
                    activeIndex = i;
                    break;
                }
            }
            JavaScriptValue updatedListModel = new JavaScriptValue("{" + expr + ": {\"$sel$\":[" + activeIndex + "]}}");
            Clients.response((String)(expr + "$" + type), (AuResponse)new AuInvoke(this._view, "update@vm", new Object[]{expr, updatedListModel}));
        }
    }
}

