/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.zkoss.bind.Form;
import org.zkoss.bind.FormStatus;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.ParamCall;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.clientbind.DummyComponent;
import org.zkoss.clientbind.ui.util.ObjectMappers;
import org.zkoss.json.JSONValue;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class ParamCallEx
extends ParamCall {
    private Map<String, Object> trackingMap;
    private boolean isTracking;
    private String lastParameterName;
    private ClientBindComposer _composer;
    private Function _originInterceptor;

    ParamCallEx(ClientBindComposer composer) {
        this._composer = composer;
        this._composer.initCachedFormBeans();
    }

    public void call(Object base, Method method) {
        try {
            this.isTracking = true;
            super.call(base, method);
        }
        finally {
            this.isTracking = false;
            this._composer.clearCachedFormBeans();
        }
    }

    public void setBindingArgs(Map<String, Object> bindingArgs) {
        List trackings;
        if (bindingArgs.containsKey("$cta$") && (trackings = (List)bindingArgs.get("$cta$")) != null) {
            this.trackingMap = new HashMap<String, Object>(trackings.size());
            trackings.forEach(key -> this.trackingMap.put((String)key, Boolean.FALSE));
        }
        super.setBindingArgs(bindingArgs);
    }

    protected String getAnnotatedParameterName(Class<? extends Annotation> annoClass, String annoValue, Supplier<String> parameterName) {
        String name = super.getAnnotatedParameterName(annoClass, annoValue, parameterName);
        if (this.isTracking && this.trackingMap != null) {
            if (this.trackingMap.get(this.lastParameterName) == Boolean.TRUE) {
                this.trackingMap.put(this.lastParameterName, Boolean.FALSE);
            }
            if (this.trackingMap.get(name) == Boolean.FALSE) {
                this.trackingMap.put(name, Boolean.TRUE);
            }
            this.lastParameterName = name;
        }
        return name;
    }

    protected Object resolveParameter0(Object val, Class<?> returnType) {
        try {
            Object result = super.resolveParameter0(val, returnType);
            if (val instanceof String && result.getClass() != returnType) {
                Component component;
                Desktop desktopIfAny;
                DesktopCache desktopCache;
                String stringValue = (String)val;
                if (stringValue.startsWith("_z_")) {
                    return new DummyComponent(this._composer.view, stringValue);
                }
                Session current = Sessions.getCurrent((boolean)false);
                if (current != null && (desktopCache = ((WebAppCtrl)current.getWebApp()).getDesktopCache(current)) != null && (desktopIfAny = desktopCache.getDesktopIfAny(stringValue)) != null) {
                    return desktopIfAny;
                }
                Execution exec = Executions.getCurrent();
                if (exec != null && (component = exec.getDesktop().getComponentByUuidIfAny(stringValue)) != null) {
                    return component;
                }
            }
            return result;
        }
        catch (Throwable e) {
            try {
                return ObjectMappers.SETTER_OBJECT_MAPPER.readValue(JSONValue.toJSONString((Object)val), returnType);
            }
            catch (Throwable throwable) {
                throw e;
            }
        }
    }

    protected Object resolveParameter(Annotation[] parmAnnos, Class<?> paramType, Method method, int index) {
        Object resolveParameter = super.resolveParameter(parmAnnos, paramType, method, index);
        if (this.isTracking && this.trackingMap != null && this.trackingMap.get(this.lastParameterName) == Boolean.TRUE) {
            this.trackingMap.put(this.lastParameterName, resolveParameter);
        }
        return resolveParameter;
    }

    public void doCheckTrackingMap(ClientBindComposer composer) {
        if (this.trackingMap != null) {
            try {
                for (Map.Entry<String, Object> me : new HashMap<String, Object>(this.trackingMap).entrySet()) {
                    if (me.getValue() instanceof Boolean) {
                        this.trackingMap.remove(me.getKey());
                        continue;
                    }
                    Object value = me.getValue();
                    TokenBuffer buf = null;
                    if (value instanceof Form) {
                        FormStatus formStatus = ((Form)value).getFormStatus();
                        if (formStatus.isDirty()) {
                            if (value instanceof FormProxyObject) {
                                Object origin = ((FormProxyObject)value).getOriginObject();
                                buf = new TokenBuffer((ObjectCodec)ObjectMappers.SETTER_OBJECT_MAPPER_ON_FAIL, false);
                                try {
                                    ObjectMappers.SETTER_OBJECT_MAPPER.writeValue((JsonGenerator)buf, origin);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            formStatus.submit(BindContextUtil.newBindContext(null, null, (boolean)false, null, null, null));
                            if (value instanceof FormProxyObject) {
                                value = ((FormProxyObject)value).getOriginObject();
                            }
                        } else {
                            this.trackingMap.remove(me.getKey());
                            continue;
                        }
                    }
                    String valueAsString = composer.writeValueAsString(value);
                    if (buf != null) {
                        try {
                            ObjectMappers.SETTER_OBJECT_MAPPER.readerForUpdating(value).readValue(buf.asParser());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (!Objects.equals(valueAsString, this._bindingArgs.get(me.getKey()))) {
                        this.trackingMap.put(me.getKey(), new JavaScriptValue(valueAsString));
                        continue;
                    }
                    this.trackingMap.remove(me.getKey());
                }
                if (!this.trackingMap.isEmpty()) {
                    this._bindingArgs.put("$ctac$", this.trackingMap);
                }
            }
            catch (JsonProcessingException e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
    }
}

