/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.SystemException;
import org.zkoss.util.Maps;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.fn.ZkFns;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.impl.VolatilePage;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.metainfo.Parser;
import org.zkoss.zk.ui.metainfo.TemplateInfo;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zk.ui.util.TemplateCtrl;
import org.zkoss.zul.NoDOM;

public class CreateTemplateCommand {
    private ClientBindComposer composer;
    private Component view;

    private CreateTemplateCommand(ClientBindComposer composer) {
        this.composer = composer;
        this.view = composer.view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process(String command, Map<String, Object> data) {
        Map args = (Map)data.get("args");
        String uri = (String)args.get("uri");
        int queryStart = uri.indexOf(63);
        String queryString = null;
        if (queryStart >= 0) {
            queryString = uri.substring(queryStart + 1);
            uri = uri.substring(0, queryStart);
        }
        Map map = Maps.parse(null, (String)queryString, (char)'&', (char)'=', (boolean)false);
        Execution exec = Executions.getCurrent();
        WebApp wapp = exec.getDesktop().getWebApp();
        uri = ZkFns.toAbsoluteURI((String)uri, (boolean)false);
        PageDefinition pageDefinition = null;
        try {
            pageDefinition = new Parser(wapp, PageDefinitions.getLocator((WebApp)wapp, (String)uri)).parse(wapp.getResource(uri), uri);
        }
        catch (Exception e) {
            throw SystemException.Aide.wrap((Throwable)e);
        }
        VolatilePage fakePage = new VolatilePage(pageDefinition);
        ((PageCtrl)fakePage).preInit();
        pageDefinition.preInit((Page)fakePage);
        NoDOM dummy = new NoDOM();
        try {
            pageDefinition.init((Page)fakePage, false);
            TemplateInfo templateInfo = new TemplateInfo(null, "", null, map, null);
            List children = pageDefinition.getChildren();
            for (NodeInfo nodeInfo : new ArrayList(children)) {
                templateInfo.appendChild(nodeInfo);
            }
            TemplateImpl template = new TemplateImpl(templateInfo);
            dummy.setTemplate("", (Template)template);
            dummy.setPage(this.view.getPage());
            this.composer.traverseComponentBindings((Component)dummy);
            StringWriter out = new StringWriter(8192);
            try {
                dummy.redraw((Writer)out);
            }
            catch (IOException e) {
                ClientBindComposer.log.error("", (Throwable)e);
            }
            Clients.sendClientCommand((Component)this.view, (String)command, (Object)new JavaScriptValue(out.toString()));
        }
        finally {
            dummy.setPage(null);
            ((PageCtrl)fakePage).destroy();
        }
        return true;
    }

    public static boolean processCommand(ClientBindComposer composer, String command, Map<String, Object> data) {
        return new CreateTemplateCommand(composer).process(command, data);
    }

    private static class TemplateImpl
    implements Template,
    TemplateCtrl,
    Serializable {
        private final TemplateInfo _tempInfo;

        private TemplateImpl(TemplateInfo tempInfo) {
            this._tempInfo = tempInfo;
        }

        public Component[] create(Component parent, Component insertBefore, VariableResolver resolver, Composer composer) {
            return null;
        }

        public Map<String, Object> getParameters() {
            return null;
        }

        public String getSrc() {
            return null;
        }

        public TemplateInfo getMeta() {
            return this._tempInfo;
        }
    }
}

