/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind.ui.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringCollectionDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.ser.std.ByteArraySerializer;
import com.fasterxml.jackson.databind.ser.std.ClassSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.StdArraySerializers;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.awt.image.RenderedImage;
import java.beans.Introspector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.clientbind.ui.util.ExtraFieldSerializer;
import org.zkoss.clientbind.ui.util.ExtraFieldUnknownSerializer;
import org.zkoss.clientbind.ui.util.ExtraMapEntrySerializer;
import org.zkoss.clientbind.ui.util.PartialArraySerializerProxyHandler;
import org.zkoss.clientbind.ui.util.PartialCollectionSerializerProxyHandler;
import org.zkoss.clientbind.ui.util.StringCollectionDeserializerProxyHandler;
import org.zkoss.image.Image;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Generics;
import org.zkoss.util.Pair;
import org.zkoss.util.TimeZones;
import org.zkoss.zel.impl.util.ReflectionUtil;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.OperationException;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zkex.util.Base64Coder;
import org.zkoss.zkmax.zul.MatrixModel;
import org.zkoss.zkmax.zul.StepModel;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListSubModel;
import org.zkoss.zul.PageableModel;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.ext.GroupingInfo;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.ext.SelectionControl;
import org.zkoss.zul.ext.TreeOpenableModel;
import org.zkoss.zul.ext.TreeSelectableModel;
import org.zkoss.zul.impl.GroupsListModel;

public class ObjectMappers {
    public static final String IGNORE_FIRST_LIST_ID = "$IGNORE_FIRST_LIST_ID$";
    private static final SimpleModule SIMPLE_MODULE = new SimpleModule(){

        public void setupModule(Module.SetupContext context) {
            super.setupModule(context);
            this.addDeserializer(Timestamp.class, (JsonDeserializer)new JsonDeserializer<Timestamp>(){

                public Timestamp deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    Long longValue = ObjectMappers.readDateLongValueInAny(p);
                    if (longValue == null) {
                        return null;
                    }
                    return new Timestamp(longValue);
                }
            });
            this.addDeserializer(Time.class, (JsonDeserializer)new JsonDeserializer<Time>(){

                public Time deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    Long longValue = ObjectMappers.readDateLongValueInAny(p);
                    if (longValue == null) {
                        return null;
                    }
                    return new Time(longValue);
                }
            });
            this.addDeserializer(Date.class, (JsonDeserializer)new JsonDeserializer<Date>(){

                public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    Long longValue = ObjectMappers.readDateLongValueInAny(p);
                    if (longValue == null) {
                        return null;
                    }
                    return new Date(longValue);
                }
            });
            this.addDeserializer(LocalDate.class, (JsonDeserializer)new JsonDeserializer<LocalDate>(){

                public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    Long longValue = ObjectMappers.readDateLongValueInAny(p);
                    if (longValue == null) {
                        return null;
                    }
                    return new Timestamp(longValue).toLocalDateTime().toLocalDate();
                }
            });
            this.addDeserializer(LocalDateTime.class, (JsonDeserializer)new JsonDeserializer<LocalDateTime>(){

                public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    Long longValue = ObjectMappers.readDateLongValueInAny(p);
                    if (longValue == null) {
                        return null;
                    }
                    return new Timestamp(longValue).toLocalDateTime();
                }
            });
            this.addDeserializer(LocalTime.class, (JsonDeserializer)new JsonDeserializer<LocalTime>(){

                public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    Long longValue = ObjectMappers.readDateLongValueInAny(p);
                    if (longValue == null) {
                        return null;
                    }
                    return new Timestamp(longValue).toLocalDateTime().toLocalTime();
                }
            });
            this.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new JsonDeserializer<ZonedDateTime>(){

                public ZonedDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    Long longValue = ObjectMappers.readDateLongValueInAny(p);
                    if (longValue == null) {
                        return null;
                    }
                    return new Timestamp(longValue).toLocalDateTime().atZone(ZoneId.of(TimeZones.getCurrent().getID()));
                }
            });
            this.addDeserializer(Float.TYPE, (JsonDeserializer)new JsonDeserializer<Float>(){

                public Float deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    return ObjectMappers.readFloatValueInAny(p);
                }
            });
            this.addDeserializer(Double.TYPE, (JsonDeserializer)new JsonDeserializer<Double>(){

                public Double deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    return ObjectMappers.readDoubleValueInAny(p);
                }
            });
            this.addDeserializer(Float.class, (JsonDeserializer)new JsonDeserializer<Float>(){

                public Float deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    return ObjectMappers.readFloatValueInAny(p);
                }
            });
            this.addDeserializer(Double.class, (JsonDeserializer)new JsonDeserializer<Double>(){

                public Double deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    return ObjectMappers.readDoubleValueInAny(p);
                }
            });
            context.addDeserializers((Deserializers)this._deserializers);
        }
    };
    public static final ObjectMapper SETTER_OBJECT_MAPPER = new ObjectMapper(null, null, (DefaultDeserializationContext)new DefaultDeserializationContext.Impl(BeanDeserializerFactory.instance.withDeserializerModifier((BeanDeserializerModifier)new BeanDeserializerModifierForIgnorables()))).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)SIMPLE_MODULE);
    public static final ObjectMapper SETTER_OBJECT_MAPPER_ON_FAIL = new ObjectMapper(null, null, (DefaultDeserializationContext)new DefaultDeserializationContext.Impl(BeanDeserializerFactory.instance.withDeserializerModifier((BeanDeserializerModifier)new BeanDeserializerModifierForIgnorables()))).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true).registerModule((Module)SIMPLE_MODULE);

    public static final ObjectMapper createGetterObjectMapper(final ClientBindComposer composer) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new CustomizedDecapitalizer());
        objectMapper.registerModule((Module)new SimpleModule(){

            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                this.addSerializer(Float.TYPE, (JsonSerializer)new JsonSerializer<Float>(){

                    public void serialize(Float value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
                        gen.writeStartObject();
                        gen.writeStringField("_@t", "float");
                        gen.writeNumberField("_@n", value.floatValue());
                        gen.writeStringField("_@s", (String)Classes.coerce(String.class, (Object)value));
                        gen.writeEndObject();
                    }
                });
                this.addSerializer(Double.TYPE, (JsonSerializer)new JsonSerializer<Double>(){

                    public void serialize(Double value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
                        gen.writeStartObject();
                        gen.writeStringField("_@t", "double");
                        gen.writeNumberField("_@n", value.doubleValue());
                        gen.writeStringField("_@s", (String)Classes.coerce(String.class, (Object)value));
                        gen.writeEndObject();
                    }
                });
                this.addSerializer(Double.class, (JsonSerializer)new JsonSerializer<Double>(){

                    public void serialize(Double value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
                        gen.writeStartObject();
                        gen.writeStringField("_@t", "double");
                        gen.writeNumberField("_@n", value.doubleValue());
                        gen.writeStringField("_@s", (String)Classes.coerce(String.class, (Object)value));
                        gen.writeEndObject();
                    }
                });
                this.addSerializer(Date.class, (JsonSerializer)new JsonSerializer<Date>(){

                    public void serialize(Date value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                        gen.writeStartObject();
                        gen.writeStringField("_@t", "date");
                        gen.writeNumberField("_@n", value.getTime());
                        gen.writeStringField("_@s", (String)Classes.coerce(String.class, (Object)value));
                        gen.writeEndObject();
                    }
                });
                this.addSerializer(LocalDate.class, (JsonSerializer)new JsonSerializer<LocalDate>(){

                    public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                        gen.writeStartObject();
                        gen.writeStringField("_@t", "date$ld");
                        gen.writeNumberField("_@n", value.atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli());
                        gen.writeStringField("_@s", (String)Classes.coerce(String.class, (Object)value));
                        gen.writeStringField("_@f", "");
                        gen.writeEndObject();
                    }
                });
                this.addSerializer(LocalDateTime.class, (JsonSerializer)new JsonSerializer<LocalDateTime>(){

                    public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                        gen.writeStartObject();
                        gen.writeStringField("_@t", "date$ldt");
                        gen.writeNumberField("_@n", value.toInstant(ZoneOffset.UTC).toEpochMilli());
                        gen.writeStringField("_@s", (String)Classes.coerce(String.class, (Object)value));
                        gen.writeStringField("_@f", "");
                        gen.writeEndObject();
                    }
                });
                this.addSerializer(LocalTime.class, (JsonSerializer)new JsonSerializer<LocalTime>(){

                    public void serialize(LocalTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                        gen.writeStartObject();
                        gen.writeStringField("_@t", "date$lt");
                        gen.writeNumberField("_@n", value.atDate(LocalDate.now()).toInstant(ZoneOffset.UTC).toEpochMilli());
                        gen.writeStringField("_@s", (String)Classes.coerce(String.class, (Object)value));
                        gen.writeStringField("_@f", "HH:mm:ss.SSS");
                        gen.writeEndObject();
                    }
                });
                this.addSerializer(ZonedDateTime.class, (JsonSerializer)new JsonSerializer<ZonedDateTime>(){

                    public void serialize(ZonedDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                        gen.writeStartObject();
                        gen.writeStringField("_@t", "date$zdt");
                        gen.writeNumberField("_@n", value.toInstant().toEpochMilli());
                        gen.writeStringField("_@s", (String)Classes.coerce(String.class, (Object)value));
                        gen.writeEndObject();
                    }
                });
                this.addSerializer(ListModel.class, (JsonSerializer)new JsonSerializer<ListModel>(){

                    public void serialize(ListModel listModel, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                        boolean shallSendTotalSize;
                        gen.writeStartObject();
                        String encodedHash = composer.getBeanUid(listModel);
                        composer.setCachedBeanById(encodedHash, listModel);
                        ListModel updateListModel = composer.modelToListModel.get(listModel);
                        if (updateListModel != null) {
                            listModel = updateListModel;
                        }
                        gen.writeStringField("$id$", encodedHash);
                        Pair<List, Set> partialFromListModel = composer.getPartialFromListModel(listModel, 0);
                        List partialData = (List)partialFromListModel.x;
                        Set partialSelection = (Set)partialFromListModel.y;
                        gen.writeFieldName("$lc$");
                        gen.writeStartArray();
                        boolean selectable = listModel instanceof Selectable;
                        List partialList = partialData;
                        SelectionControl selectionControl = selectable ? ((Selectable)listModel).getSelectionControl() : null;
                        ArrayList<Boolean> isSelectableList = new ArrayList<Boolean>();
                        for (Object e : partialList) {
                            if (e instanceof Map.Entry) {
                                gen.writeStartObject();
                                Map.Entry me = (Map.Entry)e;
                                gen.writeStringField("key", String.valueOf(me.getKey()));
                                gen.writeObjectField("value", me.getValue());
                                gen.writeEndObject();
                            } else {
                                gen.writeObject(e);
                            }
                            if (selectionControl == null) continue;
                            isSelectableList.add(selectionControl.isSelectable(e));
                        }
                        gen.writeEndArray();
                        if (selectionControl != null) {
                            gen.writeFieldName("$is$");
                            gen.writeStartArray();
                            for (Object e : isSelectableList) {
                                gen.writeObject(e);
                            }
                            gen.writeEndArray();
                        }
                        if (partialSelection != null) {
                            gen.writeFieldName("$sel$");
                            gen.writeStartArray();
                            for (Object e : partialSelection) {
                                gen.writeObject(e);
                            }
                            gen.writeEndArray();
                        }
                        if (listModel instanceof ListSubModel) {
                            gen.writeBooleanField("$sub$", true);
                        }
                        if (selectable && ((Selectable)listModel).isMultiple()) {
                            gen.writeBooleanField("$mul$", true);
                        }
                        boolean bl = shallSendTotalSize = listModel.getSize() > partialList.size();
                        if (listModel instanceof PageableModel) {
                            PageableModel pageableModel = (PageableModel)listModel;
                            gen.writeNumberField("pageSize", pageableModel.getPageSize());
                            shallSendTotalSize = true;
                        }
                        if (shallSendTotalSize) {
                            gen.writeNumberField("$ts$", listModel.getSize());
                        }
                        gen.writeEndObject();
                    }
                });
                this.addSerializer(TreeModel.class, (JsonSerializer)new JsonSerializer<TreeModel>(){

                    private int getOpenedChildrenSize(TreeModel treeModel, Object node, TreeOpenableModel treeOpenableModel, boolean renderAllChildren) {
                        int countSize = 0;
                        if (node == treeModel.getRoot() || renderAllChildren || treeOpenableModel.isPathOpened(treeModel.getPath(node))) {
                            int childCount = treeModel.getChildCount(node);
                            countSize += childCount;
                            for (int i = 0; i < childCount; ++i) {
                                Object child = treeModel.getChild(node, i);
                                countSize += this.getOpenedChildrenSize(treeModel, child, treeOpenableModel, renderAllChildren);
                            }
                        }
                        return countSize;
                    }

                    public void serialize(TreeModel treeModel, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                        Object root = treeModel.getRoot();
                        if (root != null) {
                            PageableModel pm;
                            boolean renderAllChildren;
                            gen.writeStartObject();
                            String encodedHash = composer.getBeanUid(treeModel);
                            composer.setCachedBeanById(encodedHash, treeModel);
                            gen.writeStringField("$id$", encodedHash);
                            gen.writeFieldName("$lc$");
                            int countSize = composer.modelRodSizeMap.getOrDefault(treeModel, -1);
                            Set renderAllTreeModel = (Set)Executions.getCurrent().getDesktop().getAttribute("$RENDER_ALL_TREE_DATA$");
                            boolean bl = renderAllChildren = renderAllTreeModel != null && renderAllTreeModel.contains(treeModel);
                            if (treeModel instanceof TreeOpenableModel) {
                                TreeOpenableModel treeOpenableModel = (TreeOpenableModel)treeModel;
                                countSize = this.getOpenedChildrenSize(treeModel, root, treeOpenableModel, renderAllChildren);
                            } else if (countSize < 0) {
                                countSize = treeModel.getChildCount(root);
                            }
                            int startSize = 0;
                            if (treeModel instanceof PageableModel && (pm = (PageableModel)treeModel).getActivePage() >= 0) {
                                startSize = pm.getPageSize() * pm.getActivePage();
                            }
                            int[] path = new int[]{0};
                            Counter counter = new Counter(startSize, countSize);
                            int childCount = treeModel.getChildCount(root);
                            gen.writeStartArray();
                            for (int index = startSize; index < childCount && counter.hasNext(); ++index) {
                                path[path.length - 1] = index;
                                this.writeNode(treeModel, treeModel.getChild(root, index), gen, serializers, counter, path, renderAllChildren);
                            }
                            gen.writeEndArray();
                            if (treeModel instanceof PageableModel) {
                                PageableModel pm2 = (PageableModel)treeModel;
                                gen.writeNumberField("pageSize", pm2.getPageSize());
                                gen.writeNumberField("$ts$", countSize);
                            }
                            gen.writeBooleanField("$tm$", true);
                            gen.writeEndObject();
                        }
                    }

                    private void writeNode(TreeModel treeModel, Object node, JsonGenerator jgen, SerializerProvider provider, Counter counter, int[] path, boolean renderAllChildren) throws IOException, JsonGenerationException {
                        if (!counter.hasNext()) {
                            return;
                        }
                        boolean isLeaf = treeModel.isLeaf(node);
                        if (!isLeaf || counter.contains()) {
                            TreeOpenableModel treeOpenableModel;
                            jgen.writeStartObject();
                            jgen.writeObjectField("$data$", counter.contains() ? node : null);
                            counter.increase();
                            boolean treeSelectable = treeModel instanceof TreeSelectableModel;
                            boolean selectable = treeModel instanceof Selectable;
                            if (treeSelectable || selectable) {
                                boolean selected = false;
                                if (treeSelectable) {
                                    TreeSelectableModel treeSelectableModel = (TreeSelectableModel)Generics.cast((Object)treeModel);
                                    selected = treeSelectableModel.isPathSelected(path);
                                }
                                if (selectable) {
                                    Selectable selectableModel = (Selectable)Generics.cast((Object)treeModel);
                                    boolean bl = selected = selected || selectableModel.isSelected(node);
                                }
                                if (selected) {
                                    jgen.writeObjectField("$selected$", (Object)true);
                                }
                            }
                            boolean isOpen = false;
                            if (treeModel instanceof TreeOpenableModel && (treeOpenableModel = (TreeOpenableModel)Generics.cast((Object)treeModel)).isPathOpened(path)) {
                                isOpen = true;
                                jgen.writeObjectField("$opened$", (Object)isOpen);
                            }
                            if (!isLeaf) {
                                if (isOpen || renderAllChildren) {
                                    this.writeChildrenNodes(treeModel, node, jgen, provider, counter, path, renderAllChildren);
                                } else {
                                    jgen.writeArrayFieldStart("$children$");
                                    jgen.writeEndArray();
                                }
                            }
                            jgen.writeFieldName("toString");
                            jgen.writeRaw(": function() { return String(this.$data$);}");
                            jgen.writeEndObject();
                        } else {
                            counter.increase();
                        }
                    }

                    private void writeChildrenNodes(TreeModel treeModel, Object node, JsonGenerator jgen, SerializerProvider provider, Counter counter, int[] path, boolean renderAllChildren) throws IOException, JsonGenerationException {
                        int childCount = treeModel.getChildCount(node);
                        jgen.writeArrayFieldStart("$children$");
                        path = this.addChildPath(path);
                        for (int i = 0; i < childCount && counter.hasNext(); ++i) {
                            path[path.length - 1] = i;
                            this.writeNode(treeModel, treeModel.getChild(node, i), jgen, provider, counter, path, renderAllChildren);
                        }
                        jgen.writeEndArray();
                    }

                    private int[] addChildPath(int[] parentPath) {
                        int arrLength = parentPath.length;
                        int[] path = new int[arrLength + 1];
                        System.arraycopy(parentPath, 0, path, 0, arrLength);
                        return path;
                    }
                });
                this.addSerializer(GroupsModel.class, (JsonSerializer)new JsonSerializer<GroupsModel>(){

                    public void serialize(GroupsModel groupsModel, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                        LinkedHashMap<CallSite, String> groupInfo = new LinkedHashMap<CallSite, String>();
                        gen.writeStartObject();
                        String encodedHash = composer.getBeanUid(groupsModel);
                        composer.setCachedBeanById(encodedHash, groupsModel);
                        gen.writeStringField("$id$", encodedHash);
                        GroupsListModel listModel = GroupsListModel.toListModel((GroupsModel)groupsModel);
                        Pair<List, Set> partialFromListModel = composer.getPartialFromListModel((ListModel<?>)listModel, 0);
                        List partialData = (List)partialFromListModel.x;
                        Set partialSelection = (Set)partialFromListModel.y;
                        gen.writeFieldName("$lc$");
                        gen.writeStartArray();
                        List partialList = partialData;
                        int index = 0;
                        int groupIndex = 0;
                        for (Object e : partialList) {
                            gen.writeObject(e);
                            GroupingInfo dataInfo = listModel.getDataInfo(index);
                            switch (dataInfo.getType()) {
                                case 0: {
                                    groupInfo.put((CallSite)((Object)("$" + index + "$$open$")), String.valueOf(groupsModel.isGroupOpened(groupIndex++)));
                                    groupInfo.put((CallSite)((Object)("$" + index + "$")), "model:group");
                                    break;
                                }
                                case 1: {
                                    groupInfo.put((CallSite)((Object)("$" + index + "$")), "model:groupfoot");
                                }
                            }
                            ++index;
                        }
                        gen.writeEndArray();
                        if (partialSelection != null) {
                            gen.writeFieldName("$sel$");
                            gen.writeStartArray();
                            for (Object object : partialSelection) {
                                gen.writeObject(object);
                            }
                            gen.writeEndArray();
                        }
                        if (listModel.getSize() > partialList.size()) {
                            gen.writeNumberField("$ts$", listModel.getSize());
                        }
                        for (Map.Entry entry : groupInfo.entrySet()) {
                            gen.writeStringField((String)entry.getKey(), (String)entry.getValue());
                        }
                        gen.writeEndObject();
                    }
                });
                this.addSerializer(StepModel.class, (JsonSerializer)new JsonSerializer<StepModel>(){

                    public void serialize(StepModel stepModel, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                        gen.writeStartObject();
                        String encodedHash = composer.getBeanUid(stepModel);
                        composer.setCachedBeanById(encodedHash, stepModel);
                        gen.writeStringField("$id$", encodedHash);
                        ListModel steps = stepModel.getSteps();
                        int size = steps.getSize();
                        gen.writeArrayFieldStart("$lc$");
                        for (int i = 0; i < size; ++i) {
                            gen.writeObject(steps.getElementAt(i));
                        }
                        gen.writeEndArray();
                        gen.writeArrayFieldStart("$sel$");
                        gen.writeNumber(stepModel.getActiveIndex());
                        gen.writeEndArray();
                        gen.writeEndObject();
                    }
                });
                this.addSerializer(MatrixModel.class, (JsonSerializer)new JsonSerializer<MatrixModel>(){

                    public void serialize(MatrixModel matrixModel, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                        gen.writeStartObject();
                        String encodedHash = composer.getBeanUid(matrixModel);
                        composer.setCachedBeanById(encodedHash, matrixModel);
                        gen.writeStringField("$id$", encodedHash);
                        gen.writeNumberField("columnSize", matrixModel.getColumnSize());
                        gen.writeNumberField("headSize", matrixModel.getHeadSize());
                        gen.writeStringField("$id$", encodedHash);
                        gen.writeArrayFieldStart("heads");
                        int headSize = matrixModel.getHeadSize();
                        int columnSize = matrixModel.getColumnSize();
                        for (int i = 0; i < headSize; ++i) {
                            gen.writeStartArray();
                            Object head = matrixModel.getHeadAt(i);
                            for (int j = 0; j < columnSize; ++j) {
                                gen.writeObject(matrixModel.getHeaderAt(head, j));
                            }
                            gen.writeEndArray();
                        }
                        gen.writeEndArray();
                        gen.writeArrayFieldStart("$lc$");
                        int rowSize = matrixModel.getSize();
                        for (int i = 0; i < rowSize; ++i) {
                            gen.writeObject(matrixModel.getElementAt(i));
                        }
                        gen.writeEndArray();
                        if (matrixModel instanceof Selectable) {
                            Set selection = ((Selectable)matrixModel).getSelection();
                            gen.writeFieldName("$sel$");
                            gen.writeStartArray();
                            for (Object data : selection) {
                                gen.writeObject(data);
                            }
                            gen.writeEndArray();
                        }
                        gen.writeEndObject();
                    }
                });
                this.addSerializer(WebApp.class, (JsonSerializer)new JsonSerializer<WebApp>(){

                    public void serialize(WebApp webApp, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
                        jgen.writeString(webApp.toString());
                    }
                });
                this.addSerializer(Session.class, (JsonSerializer)new JsonSerializer<Session>(){

                    public void serialize(Session session, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
                        jgen.writeString(session.toString());
                    }
                });
                this.addSerializer(Desktop.class, (JsonSerializer)new JsonSerializer<Desktop>(){

                    public void serialize(Desktop desktop, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
                        jgen.writeString(desktop.toString());
                    }
                });
                this.addSerializer(Page.class, (JsonSerializer)new JsonSerializer<Page>(){

                    public void serialize(Page page, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
                        jgen.writeString(page.toString());
                    }
                });
                this.addSerializer(RenderedImage.class, (JsonSerializer)new JsonSerializer<RenderedImage>(){

                    public void serialize(RenderedImage image, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        ImageIO.write(image, "PNG", out);
                        byte[] bytes = out.toByteArray();
                        String base64bytes = Base64Coder.encodeLines((byte[])bytes);
                        String src = "data:image/png;base64," + base64bytes;
                        jgen.writeString(src);
                    }
                });
                this.addSerializer(Image.class, (JsonSerializer)new JsonSerializer<Image>(){

                    public void serialize(Image image, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
                        byte[] bytes = null;
                        bytes = image.isBinary() ? image.getByteData() : IOUtils.toByteArray((InputStream)image.getStreamData());
                        String base64bytes = Base64Coder.encodeLines((byte[])bytes);
                        String src = "data:image/" + image.getFormat() + ";base64," + base64bytes;
                        jgen.writeString(src);
                    }
                });
                this.addSerializer(DynamicPropertied.class, (JsonSerializer)new JsonSerializer<DynamicPropertied>(){

                    public void serialize(DynamicPropertied dynamicPropertied, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
                        jgen.writeStartObject();
                        Map dynamicProperties = dynamicPropertied.getDynamicProperties();
                        if (dynamicProperties != null) {
                            for (Map.Entry me : dynamicProperties.entrySet()) {
                                jgen.writeFieldName((String)me.getKey());
                                jgen.writeObject(me.getValue());
                            }
                        }
                        jgen.writeEndObject();
                    }
                });
                this.addSerializer(boolean[].class, (JsonSerializer)new StdArraySerializers.BooleanArraySerializer());
                this.addSerializer(byte[].class, (JsonSerializer)new ByteArraySerializer());
                this.addSerializer(char[].class, (JsonSerializer)new StdArraySerializers.CharArraySerializer());
                this.addSerializer(short[].class, (JsonSerializer)new StdArraySerializers.ShortArraySerializer());
                this.addSerializer(int[].class, (JsonSerializer)new StdArraySerializers.IntArraySerializer());
                this.addSerializer(long[].class, (JsonSerializer)new StdArraySerializers.LongArraySerializer());
                this.addSerializer(float[].class, (JsonSerializer)new StdArraySerializers.FloatArraySerializer());
                this.addSerializer(double[].class, (JsonSerializer)new StdArraySerializers.DoubleArraySerializer());
                context.addSerializers((Serializers)this._serializers);
                context.addBeanSerializerModifier(new BeanSerializerModifier(){

                    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                        if (serializer instanceof BeanSerializerBase) {
                            ExtraFieldSerializer extraFieldSerializer = new ExtraFieldSerializer((BeanSerializerBase)serializer);
                            extraFieldSerializer.owner = composer;
                            return extraFieldSerializer;
                        }
                        if (serializer instanceof UnknownSerializer) {
                            return new ExtraFieldUnknownSerializer(serializer.handledType(), composer);
                        }
                        if (serializer instanceof ClassSerializer) {
                            return new ClassSerializer(){

                                public void serialize(Class<?> value, JsonGenerator g, SerializerProvider provider) throws IOException {
                                    g.writeStartObject();
                                    g.writeStringField("name", value.getName());
                                    g.writeFieldName("toString()");
                                    g.writeRaw(": function () {return String(this.name);}");
                                    g.writeEndObject();
                                }
                            };
                        }
                        return serializer;
                    }

                    public JsonSerializer<?> modifyCollectionSerializer(SerializationConfig config, CollectionType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                        Object p1;
                        JsonSerializer collectionSerializer = super.modifyCollectionSerializer(config, valueType, beanDesc, serializer);
                        ProxyFactory factory = new ProxyFactory();
                        factory.setUseWriteReplace(false);
                        factory.setSuperclass(JsonSerializer.class);
                        Class proxyClass = factory.createClass();
                        try {
                            p1 = proxyClass.newInstance();
                        }
                        catch (Exception e) {
                            throw UiException.Aide.wrap((Throwable)e);
                        }
                        ((Proxy)p1).setHandler((MethodHandler)new PartialCollectionSerializerProxyHandler(collectionSerializer, composer));
                        return (JsonSerializer)p1;
                    }

                    public JsonSerializer<?> modifyArraySerializer(SerializationConfig config, ArrayType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                        Object p1;
                        JsonSerializer arraySerializer = super.modifyArraySerializer(config, valueType, beanDesc, serializer);
                        ProxyFactory factory = new ProxyFactory();
                        factory.setUseWriteReplace(false);
                        factory.setSuperclass(JsonSerializer.class);
                        Class proxyClass = factory.createClass();
                        try {
                            p1 = proxyClass.newInstance();
                        }
                        catch (Exception e) {
                            throw UiException.Aide.wrap((Throwable)e);
                        }
                        ((Proxy)p1).setHandler((MethodHandler)new PartialArraySerializerProxyHandler(arraySerializer, composer));
                        return (JsonSerializer)p1;
                    }

                    public JsonSerializer<?> modifyMapSerializer(SerializationConfig config, MapType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                        if (serializer instanceof MapSerializer) {
                            ExtraMapEntrySerializer extraEntrySerializer = new ExtraMapEntrySerializer((MapSerializer)serializer);
                            extraEntrySerializer.owner = composer;
                            return extraEntrySerializer;
                        }
                        return serializer;
                    }
                });
            }
        });
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){

            public boolean hasIgnoreMarker(AnnotatedMember m) {
                ArrayList exclusions = new ArrayList();
                if (org.zkoss.zul.TreeNode.class.isAssignableFrom(m.getDeclaringClass())) {
                    String name;
                    switch (name = m.getName()) {
                        case "getChildren": 
                        case "getParent": 
                        case "getModel": 
                        case "getChildCount": 
                        case "isLeaf": {
                            return true;
                        }
                    }
                }
                return exclusions.contains(m.getName()) || super.hasIgnoreMarker(m);
            }
        });
        return objectMapper;
    }

    static void serializeNULLObject(Class clz, JsonGenerator gen) throws IOException {
        if (clz.equals(Date.class) || clz.equals(LocalDate.class) || clz.equals(LocalTime.class) || clz.equals(ZonedDateTime.class)) {
            Object type = "date";
            if (clz.equals(LocalDate.class)) {
                type = (String)type + "$ld";
            } else if (clz.equals(LocalDateTime.class)) {
                type = (String)type + "$ldt";
            } else if (clz.equals(LocalTime.class)) {
                type = (String)type + "$lt";
            } else if (clz.equals(ZonedDateTime.class)) {
                type = (String)type + "$zdt";
            }
            gen.writeStartObject();
            gen.writeStringField("_@t", (String)type);
            gen.writeNullField("_@n");
            gen.writeStringField("_@s", "");
            gen.writeEndObject();
        } else {
            gen.writeNull();
        }
    }

    private static Float readFloatValueInAny(JsonParser p) throws IOException {
        try {
            TreeNode treeNode = p.getCodec().readTree(p);
            TreeNode node = treeNode.get("_@n");
            if (node != null) {
                if (node instanceof IntNode) {
                    return Float.valueOf(((IntNode)node).floatValue());
                }
                return (Float)((FloatNode)node).numberValue();
            }
            if (treeNode instanceof IntNode) {
                return Float.valueOf(((IntNode)treeNode).floatValue());
            }
            if (treeNode instanceof TextNode) {
                String text = ((TextNode)treeNode).asText();
                return Float.valueOf(text.isEmpty() ? 0.0f : Float.parseFloat(text));
            }
            return Float.valueOf(((FloatNode)treeNode).floatValue());
        }
        catch (IOException e) {
            throw new OperationException("Fail to read float value", (Throwable)e);
        }
    }

    private static Double readDoubleValueInAny(JsonParser p) throws IOException {
        try {
            TreeNode treeNode = p.getCodec().readTree(p);
            TreeNode node = treeNode.get("_@n");
            if (node != null) {
                if (node instanceof IntNode) {
                    return ((IntNode)node).doubleValue();
                }
                return (Double)((DoubleNode)node).numberValue();
            }
            if (treeNode instanceof IntNode) {
                return ((IntNode)treeNode).doubleValue();
            }
            if (treeNode instanceof TextNode) {
                String text = ((TextNode)treeNode).asText();
                return text.isEmpty() ? 0.0 : Double.parseDouble(text);
            }
            return ((DoubleNode)treeNode).doubleValue();
        }
        catch (IOException e) {
            throw new OperationException("Fail to read double value", (Throwable)e);
        }
    }

    private static Long readDateLongValueInAny(JsonParser p) throws IOException {
        try {
            long value;
            TreeNode treeNode = p.getCodec().readTree(p);
            TreeNode node = treeNode.get("_@n");
            if (node != null) {
                if (node instanceof NullNode) {
                    return null;
                }
                return (Long)((LongNode)node).numberValue();
            }
            if (treeNode instanceof IntNode) {
                value = ((IntNode)treeNode).intValue();
            } else if (treeNode instanceof LongNode) {
                value = ((LongNode)treeNode).longValue();
            } else {
                throw new OperationException("Unkown node type to read long value: " + treeNode.getClass().getName());
            }
            return value;
        }
        catch (IOException e) {
            throw new OperationException("Fail to read long value", (Throwable)e);
        }
    }

    public static <T> T convert(Object data, Class<? extends T> type) {
        return (T)SETTER_OBJECT_MAPPER.convertValue(data, TypeFactory.rawClass(type));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T convert(ClientBindComposer composer, Object data, ParameterizedType type) {
        try (TokenBuffer buf = new TokenBuffer((ObjectCodec)SETTER_OBJECT_MAPPER_ON_FAIL, false);){
            TokenBuffer tokenBuffer = buf;
            if (SETTER_OBJECT_MAPPER_ON_FAIL.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                tokenBuffer = tokenBuffer.forceUseOfBigDecimal(true);
            }
            SerializationConfig config = SETTER_OBJECT_MAPPER_ON_FAIL.getSerializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE);
            ((DefaultSerializerProvider)SETTER_OBJECT_MAPPER_ON_FAIL.getSerializerProvider()).createInstance(config, SETTER_OBJECT_MAPPER_ON_FAIL.getSerializerFactory()).serializeValue((JsonGenerator)tokenBuffer, data);
            JsonParser p = tokenBuffer.asParser();
            Object object = SETTER_OBJECT_MAPPER_ON_FAIL.readerFor(TypeFactory.defaultInstance().constructParametricType((Class)type.getRawType(), Arrays.stream(type.getActualTypeArguments()).map(t -> (Class)t).collect(Collectors.toList()).toArray(new Class[0]))).withAttribute((Object)"$composer$", (Object)composer).readValue(p);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final boolean isPropertyLoadStringType(Class<?> compClz, String field) {
        Method[] setter = ReflectionUtil.getSetter(compClz, (String)field);
        if (setter != null && setter.length == 1) {
            return setter[0].getParameterTypes()[0] == String.class;
        }
        return false;
    }

    private static class BeanDeserializerModifierForIgnorables
    extends BeanDeserializerModifier {
        private static final Set<String> IGNORABLES = new HashSet<String>(Arrays.asList("$id$", "$map$"));

        private BeanDeserializerModifierForIgnorables() {
        }

        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
            for (String ignorable : IGNORABLES) {
                builder.addIgnorable(ignorable);
            }
            return builder;
        }

        public JsonDeserializer<?> modifyMapDeserializer(DeserializationConfig config, MapType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            ((MapDeserializer)deserializer).setIgnorableProperties(IGNORABLES);
            return deserializer;
        }

        public JsonDeserializer<?> modifyCollectionDeserializer(DeserializationConfig config, CollectionType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            if (deserializer instanceof CollectionDeserializer) {
                if (Set.class.isAssignableFrom(type.getRawClass())) {
                    return new LCCollectionDeserializer((CollectionDeserializer)deserializer){

                        protected Collection<Object> createDefaultInstance(DeserializationContext ctxt) throws IOException {
                            return new LinkedHashSet<Object>();
                        }

                        @Override
                        protected CollectionDeserializer withResolved(JsonDeserializer dd, JsonDeserializer vd, TypeDeserializer vtd, NullValueProvider nuller, Boolean unwrapSingle) {
                            return new LCCollectionDeserializer(this.getContentType(), vd, vtd, this._valueInstantiator, dd, nuller, unwrapSingle){

                                protected Collection createDefaultInstance(DeserializationContext ctxt) throws IOException {
                                    return new LinkedHashSet();
                                }
                            };
                        }
                    };
                }
                return new LCCollectionDeserializer((CollectionDeserializer)deserializer);
            }
            if (deserializer instanceof StringCollectionDeserializer) {
                Object p1;
                ProxyFactory factory = new ProxyFactory();
                factory.setUseWriteReplace(false);
                factory.setSuperclass(JsonDeserializer.class);
                Class proxyClass = factory.createClass();
                try {
                    p1 = proxyClass.newInstance();
                }
                catch (Exception e) {
                    throw UiException.Aide.wrap((Throwable)e);
                }
                ((Proxy)p1).setHandler((MethodHandler)new StringCollectionDeserializerProxyHandler(deserializer));
                return (JsonDeserializer)p1;
            }
            return super.modifyCollectionDeserializer(config, type, beanDesc, deserializer);
        }

        public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            if (deserializer instanceof BeanDeserializer) {
                return new ObjectMapperBeanDeserializer((BeanDeserializerBase)((BeanDeserializer)deserializer));
            }
            return super.modifyDeserializer(config, beanDesc, deserializer);
        }

        public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
            ArrayList<BeanPropertyDefinition> newPropDefs = new ArrayList<BeanPropertyDefinition>();
            for (BeanPropertyDefinition propDef : propDefs) {
                if (IGNORABLES.contains(propDef.getName())) continue;
                newPropDefs.add(propDef);
            }
            return newPropDefs;
        }

        private static class LCCollectionDeserializer
        extends CollectionDeserializer {
            protected LCCollectionDeserializer(CollectionDeserializer src) {
                super(src);
            }

            public LCCollectionDeserializer(JavaType collectionType, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser, ValueInstantiator valueInstantiator, JsonDeserializer<Object> delegateDeser, NullValueProvider nuller, Boolean unwrapSingle) {
                super(collectionType, valueDeser, valueTypeDeser, valueInstantiator, delegateDeser, nuller, unwrapSingle);
            }

            protected CollectionDeserializer withResolved(JsonDeserializer dd, JsonDeserializer vd, TypeDeserializer vtd, NullValueProvider nuller, Boolean unwrapSingle) {
                return new LCCollectionDeserializer(this.getContentType(), vd, vtd, this._valueInstantiator, dd, nuller, unwrapSingle){};
            }

            public Collection<Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                block1: {
                    if (p.isExpectedStartArrayToken()) break block1;
                    do {
                        p.nextToken();
                    } while (!"$lc$".equals(p.currentName()));
                    p.nextToken();
                }
                return super.deserialize(p, ctxt);
            }
        }
    }

    private static class ObjectMapperBeanDeserializer
    extends BeanDeserializer {
        protected ObjectMapperBeanDeserializer(BeanDeserializerBase src) {
            super(src);
        }

        protected Object deserializeFromObjectUsingNonDefault(JsonParser p, DeserializationContext ctxt) throws IOException {
            TreeNode treeNode = p.getCodec().readTree(p);
            TreeNode node = treeNode.get("$id$");
            if (node instanceof TextNode) {
                ClientBindComposer composer = (ClientBindComposer)ctxt.getAttribute((Object)"$composer$");
                if (composer != null) {
                    return composer.getCachedBeanById(((TextNode)node).asText());
                }
            } else if (treeNode instanceof NullNode) {
                return null;
            }
            return super.deserializeFromObjectUsingNonDefault(p, ctxt);
        }
    }

    private static class Counter {
        private AtomicInteger _start;
        private AtomicInteger _count;
        private final int _end;

        Counter(int start, int count) {
            this._start = new AtomicInteger(start);
            this._count = new AtomicInteger(start);
            this._end = start + count;
        }

        public boolean hasNext() {
            return this._start.get() < this._end;
        }

        public boolean contains() {
            return this._count.get() == this._start.get() && this._count.get() < this._end;
        }

        public void increase() {
            if (this._count.get() >= this._start.get()) {
                this._start.incrementAndGet();
            }
            this._count.incrementAndGet();
        }
    }

    private static final class CustomizedDecapitalizer
    extends PropertyNamingStrategy {
        private CustomizedDecapitalizer() {
        }

        public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            String methodName;
            return Introspector.decapitalize(methodName.substring((methodName = method.getName()).startsWith("is") ? 2 : 3));
        }

        public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return Introspector.decapitalize(method.getName().substring(3));
        }
    }
}

