/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.zkoss.clientbind.ClientBindComposer;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.SystemException;
import org.zkoss.util.Maps;
import org.zkoss.zk.fn.ZkFns;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.impl.VolatilePage;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.metainfo.Parser;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.util.Clients;

public class IncludeTemplateCommand {
    private ClientBindComposer composer;
    private Component view;

    private IncludeTemplateCommand(ClientBindComposer composer) {
        this.composer = composer;
        this.view = composer.view;
    }

    private boolean process(String command, Map<String, Object> data) {
        Map args = (Map)data.get("args");
        String uri = (String)args.get("uri");
        Map vargs = (Map)args.get("vargs");
        int queryStart = uri.indexOf(63);
        String queryString = null;
        if (queryStart >= 0) {
            queryString = uri.substring(queryStart + 1);
            uri = uri.substring(0, queryStart);
        }
        Map map = Maps.parse(null, (String)queryString, (char)'&', (char)'=', (boolean)false);
        if (vargs != null) {
            map.putAll(vargs);
        }
        Execution exec = Executions.getCurrent();
        WebApp wapp = exec.getDesktop().getWebApp();
        uri = ZkFns.toAbsoluteURI((String)uri, (boolean)false);
        PageDefinition pageDefinition = null;
        try {
            pageDefinition = new Parser(wapp, PageDefinitions.getLocator((WebApp)wapp, (String)uri)).parse(wapp.getResource(uri), uri);
        }
        catch (Exception e) {
            throw SystemException.Aide.wrap((Throwable)e);
        }
        this.view.getPage().addFunctionMapper(pageDefinition.getTaglibMapper());
        VolatilePage fakePage = new VolatilePage(pageDefinition){

            public void redraw(Writer out) throws IOException {
            }
        };
        ((PageCtrl)fakePage).preInit();
        pageDefinition.preInit((Page)fakePage);
        try {
            if (vargs != null) {
                exec.pushArg(vargs);
                vargs.forEach((arg_0, arg_1) -> ((Execution)exec).setAttribute(arg_0, arg_1));
            }
            pageDefinition.init((Page)fakePage, false);
            Component[] components = Executions.getCurrent().createComponents(uri, (Page)fakePage, null, map);
            StringWriter bufout = new StringWriter();
            bufout.write("[");
            for (int i = 0; i < components.length; ++i) {
                Component component = components[i];
                this.composer.traverseComponentBindings(component);
                if (i > 0) {
                    bufout.write(44);
                }
                ((ComponentCtrl)component).redraw((Writer)bufout);
            }
            bufout.write("]");
            Clients.sendClientCommand((Component)this.view, (String)command, (Object)new JavaScriptValue(bufout.toString()));
        }
        catch (IOException e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
        finally {
            if (vargs != null) {
                exec.popArg();
            }
        }
        return true;
    }

    public static boolean processCommand(ClientBindComposer composer, String command, Map<String, Object> data) {
        return new IncludeTemplateCommand(composer).process(command, data);
    }
}

