/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.clientbind.ui.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BidirectionalMap<K, V>
extends HashMap<K, V> {
    private HashMap<V, K> inversedMap;

    public BidirectionalMap(int i, float v) {
        super(i, v);
        this.inversedMap = new HashMap(i, v);
    }

    public BidirectionalMap(int i) {
        super(i);
        this.inversedMap = new HashMap(i);
    }

    public BidirectionalMap() {
        this.inversedMap = new HashMap();
    }

    public BidirectionalMap(Map<? extends K, ? extends V> map) {
        super(map);
        this.inversedMap = new HashMap();
        map.forEach((k, v) -> this.inversedMap.put(v, k));
    }

    public K getKey(V value) {
        return this.inversedMap.get(value);
    }

    @Override
    public V remove(Object key) {
        Object val = super.remove(key);
        this.inversedMap.remove(val);
        return val;
    }

    @Override
    public V put(K key, V value) {
        this.inversedMap.put(value, key);
        return super.put(key, value);
    }

    @Override
    public void clear() {
        super.clear();
        this.inversedMap.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BidirectionalMap that = (BidirectionalMap)o;
        return Objects.equals(this.inversedMap, that.inversedMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inversedMap);
    }
}

