/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.util;

import org.zkoss.pivot.PivotHeaderNode;
import org.zkoss.pivot.PivotHeaderTree;
import org.zkoss.pivot.impl.util.PagingInfo;
import org.zkoss.pivot.util.Trees;

public class HeaderTraverser {
    private final PivotHeaderTree _tree;
    private final PagingInfo _pgInfo;
    private final int _size;
    private final int _depth;
    private final int _nodeStart;
    private final int _nodeEnd;
    private final int _nodeLimit;
    private final boolean _isLimited;
    private final boolean _open;
    private final int _realSize;

    public HeaderTraverser(PivotHeaderTree tree, PagingInfo pgInfo, boolean open) {
        this._tree = tree;
        this._pgInfo = pgInfo;
        this._open = open;
        this._size = Trees.getSize(tree, open);
        this._depth = tree.getDepth() - 1;
        this._nodeStart = pgInfo.getNodeStart();
        this._nodeEnd = pgInfo.getNodeEnd();
        this._nodeLimit = pgInfo.getNodeLimit();
        this._isLimited = pgInfo.isLimited();
        int s = this._size - this._nodeStart;
        this._realSize = this._isLimited ? Math.min(this._pgInfo.getNodeLimit(), s) : s;
    }

    public int getSize() {
        return this._size;
    }

    public int getRealSize() {
        return this._realSize;
    }

    public int getDepth() {
        return this._depth;
    }

    public void run(final Filler[] fillers) {
        for (Filler f : fillers) {
            f.init(this, this._pgInfo);
        }
        Trees.traverse(this._tree, this._open, new Trees.NodeRunner(){

            @Override
            public void onNode(PivotHeaderNode node, Trees.TreeTravCtx ctx) {
                HeaderTraverser.this.fill(node, ctx, fillers);
            }
        });
        for (Filler f : fillers) {
            f.afterFill();
        }
    }

    private void fill(PivotHeaderNode node, Trees.TreeTravCtx ctx, Filler[] fillers) {
        if (Trees.isRoot(node)) {
            return;
        }
        if (ctx.postindex() <= this._nodeStart || this._isLimited && ctx.index() >= this._nodeEnd) {
            return;
        }
        boolean isTerminal = this._open ? node.isLeaf() : Trees.isTerminal(node);
        int dispDepth = node.getDepth() - 1;
        int index = ctx.index() - this._nodeStart;
        int calStart = index + ctx.nodesize();
        if (isTerminal || calStart > 0) {
            int noderi = Math.max(index, 0);
            for (Filler f : fillers) {
                f.forNode(node, ctx, noderi, dispDepth);
            }
        }
        if (!isTerminal) {
            int iStart = Math.max(-calStart, 0);
            int iLimit = this._isLimited ? Math.min(ctx.calsize(), this._nodeLimit - calStart) : ctx.calsize();
            for (int i = iStart; i < iLimit; ++i) {
                for (Filler f : fillers) {
                    f.forSubtotals(node, ctx, calStart + i, dispDepth, i);
                }
            }
        }
    }

    public static interface Filler {
        public void init(HeaderTraverser var1, PagingInfo var2);

        public void forNode(PivotHeaderNode var1, Trees.TreeTravCtx var2, int var3, int var4);

        public void forSubtotals(PivotHeaderNode var1, Trees.TreeTravCtx var2, int var3, int var4, int var5);

        public void afterFill();
    }
}

