/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.util;

import org.zkoss.pivot.Calculator;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotHeaderContext;
import org.zkoss.pivot.PivotHeaderNode;
import org.zkoss.pivot.PivotHeaderTree;
import org.zkoss.pivot.impl.util.AbstractFiller;
import org.zkoss.pivot.impl.util.HeaderTraverser;
import org.zkoss.pivot.impl.util.PagingInfo;
import org.zkoss.pivot.util.Trees;

public abstract class HeaderSizeFiller
extends AbstractFiller {
    private final boolean _hasDF;
    private final int _dispOffset;
    private final PivotField[] _dfs;
    private final int _dfsz;
    private final PivotHeaderTree _tree;
    private int[] _sizes;

    public HeaderSizeFiller(PivotField[] dataFields, boolean hasDataFields, int headerDispOffset, PivotHeaderTree tree) {
        this._dfs = dataFields;
        this._hasDF = hasDataFields;
        this._dispOffset = headerDispOffset;
        this._dfsz = hasDataFields ? dataFields.length : 1;
        this._tree = tree;
    }

    @Override
    public void init(HeaderTraverser context, PagingInfo pgInfo) {
        int i;
        super.init(context, pgInfo);
        int rsize = context.getRealSize() * this._dfsz - pgInfo.getCutoffStart();
        if (pgInfo.isLimited()) {
            rsize = Math.min(rsize, pgInfo.getLimit());
        }
        int len = this._dispOffset + rsize + this._dfsz;
        this._sizes = new int[len];
        for (i = 0; i < this._dispOffset; ++i) {
            this._sizes[i] = this.getRenderSize(new PivotHeaderContext(i - this._dispOffset), this.getOffsetField(i));
        }
        for (i = 0; i < this._dfsz; ++i) {
            int ri = len - this._dfsz + i;
            int dispIndex = ri - this._dispOffset;
            PivotHeaderContext phc = new PivotHeaderContext(this._tree.getRoot(), null, dispIndex);
            this._sizes[ri] = this.getRenderSize(phc, this._hasDF ? this._dfs[i] : null);
        }
    }

    public int[] getSizes() {
        return this._sizes;
    }

    @Override
    public void forNode(PivotHeaderNode node, Trees.TreeTravCtx ctx, int nodeIndex, int dispDepth) {
        if (!Trees.isTerminal(node)) {
            return;
        }
        this.fill(node, ctx, nodeIndex, dispDepth, -1);
    }

    @Override
    public void forSubtotals(PivotHeaderNode node, Trees.TreeTravCtx ctx, int nodeIndex, int dispDepth, int calIndex) {
        this.fill(node, ctx, nodeIndex, dispDepth, calIndex);
    }

    protected abstract int getRenderSize(PivotHeaderContext var1, PivotField var2);

    protected abstract PivotField getOffsetField(int var1);

    private void fill(PivotHeaderNode node, Trees.TreeTravCtx ctx, int nodeIndex, int dispDepth, int calIndex) {
        int ni = nodeIndex * this._dfsz - this._pgInfo.getCutoffStart();
        int iStart = nodeIndex == 0 ? this._pgInfo.getCutoffStart() : 0;
        int iLimit = this._pgInfo.isLimited() ? Math.min(this._dfsz, this._pgInfo.getLimit() - ni) : this._dfsz;
        for (int i = iStart; i < iLimit; ++i) {
            int dispIndex = ni + i;
            Calculator cal = calIndex < 0 ? null : Trees.getCalculator(node, calIndex);
            PivotHeaderContext phc = new PivotHeaderContext(node, cal, dispIndex);
            this._sizes[this._dispOffset + dispIndex] = this.getRenderSize(phc, this._hasDF ? this._dfs[i] : node.getField());
        }
    }
}

