/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.util;

import org.zkoss.pivot.PivotHeaderNode;
import org.zkoss.pivot.impl.util.AbstractFiller;
import org.zkoss.pivot.impl.util.HeaderTraverser;
import org.zkoss.pivot.impl.util.PagingInfo;
import org.zkoss.pivot.util.Trees;

public class HeaderMergeFiller
extends AbstractFiller {
    private int[][] _merges;
    private int[] _hasCutoffs;

    @Override
    public void init(HeaderTraverser context, PagingInfo pgInfo) {
        super.init(context, pgInfo);
        int depth = context.getDepth();
        this._merges = new int[context.getRealSize()][depth];
        this._hasCutoffs = new int[depth];
    }

    public int[][] getSpans() {
        return this._merges;
    }

    public int[] getIconCutoffs() {
        return this._hasCutoffs;
    }

    @Override
    public void forNode(PivotHeaderNode node, Trees.TreeTravCtx ctx, int nodeIndex, int dispDepth) {
        this._merges[nodeIndex][dispDepth] = this.getSpan(node, ctx, nodeIndex);
    }

    @Override
    public void forSubtotals(PivotHeaderNode node, Trees.TreeTravCtx ctx, int nodeIndex, int dispDepth, int calIndex) {
        this._merges[nodeIndex][dispDepth] = -2;
    }

    private int getSpan(PivotHeaderNode node, Trees.TreeTravCtx ctx, int nodeIndex) {
        int cutoff;
        if (node.isLeaf()) {
            return 1;
        }
        if (!node.isOpen()) {
            return -1;
        }
        int span = ctx.nodesize();
        if (nodeIndex == 0 && (cutoff = this._pgInfo.getNodeStart() - ctx.index()) > 0) {
            span -= cutoff;
            this._hasCutoffs[node.getDepth() - 1] = 1;
        }
        if (this._pgInfo.isLimited()) {
            span -= Math.max(ctx.index() + ctx.nodesize() - this._pgInfo.getNodeEnd(), 0);
        }
        return span;
    }
}

