/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.util;

import org.zkoss.pivot.PivotHeaderNode;
import org.zkoss.pivot.impl.util.AbstractFiller;
import org.zkoss.pivot.impl.util.HeaderTraverser;
import org.zkoss.pivot.impl.util.PagingInfo;
import org.zkoss.pivot.impl.util.Texts;
import org.zkoss.pivot.util.Trees;

public class HeaderKeyFiller
extends AbstractFiller {
    private String[][] _keys;

    @Override
    public void init(HeaderTraverser context, PagingInfo pgInfo) {
        super.init(context, pgInfo);
        this._keys = new String[context.getRealSize()][context.getDepth()];
    }

    public String[][] getKeys() {
        return this._keys;
    }

    @Override
    public void forNode(PivotHeaderNode node, Trees.TreeTravCtx ctx, int nodeIndex, int dispDepth) {
        this._keys[nodeIndex][dispDepth] = ctx.key();
    }

    @Override
    public void forSubtotals(PivotHeaderNode node, Trees.TreeTravCtx ctx, int nodeIndex, int dispDepth, int calIndex) {
        this._keys[nodeIndex][dispDepth] = ctx.key() + "%" + Texts.getRankKey(calIndex);
    }

    @Override
    public void afterFill() {
        for (int i = 0; i < this._keys.length; ++i) {
            String[] ks = this._keys[i];
            for (int j = 0; j < ks.length; ++j) {
                if (ks[j] != null) continue;
                ks[j] = "";
            }
        }
    }
}

