/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.zkoss.pivot.Calculator;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.impl.StandardContextType;
import org.zkoss.pivot.impl.TabularPivotField;
import org.zkoss.pivot.impl.TabularPivotModel;
import org.zkoss.pivot.impl.calc.ContextType;
import org.zkoss.pivot.impl.calc.ContextualCalculator;

public class CalculatorContextSignature {
    private final Set<PivotField> _rcfSet = new HashSet<PivotField>();
    private final Set<PivotField> _dfSet = new HashSet<PivotField>();
    private final boolean[] _stdCtxReq = new boolean[TabularPivotModel._STD_CAL_TYPE_SIZE];
    private final Set<ContextType<?>> _cusCtxTypeSet = new HashSet();
    private final ContextType<?>[] _cusCtxType;
    private final int _customCtxTypeCount;
    private final int _totalCtxTypeCount;
    private final int _dfCount;

    public CalculatorContextSignature(TabularPivotModel model) {
        this(model, null, null);
    }

    public CalculatorContextSignature(TabularPivotModel model, PivotField[] extraDataFields, ContextType<?>[] extraContextTypes) {
        this.scanRCFields(model.getRowFields());
        this.scanRCFields(model.getColumnFields());
        this.scanDataFields(model.getDataFields());
        this.scanDataFields(extraDataFields);
        if (extraContextTypes != null) {
            for (ContextType<?> t : extraContextTypes) {
                this.addContextType(t);
            }
        }
        this._dfCount = this._dfSet.size();
        this._customCtxTypeCount = this._cusCtxTypeSet.size();
        this._totalCtxTypeCount = TabularPivotModel._STD_CAL_TYPE_SIZE + this._customCtxTypeCount;
        this._cusCtxType = new ContextType[this._customCtxTypeCount];
        int i = 0;
        for (ContextType<?> t : this._cusCtxTypeSet) {
            this._cusCtxType[i] = t;
        }
    }

    private void scanRCFields(TabularPivotField[] fields) {
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            Calculator[] cals;
            TabularPivotField f = fields[i];
            this._rcfSet.add(f);
            if (i >= len - 1 || (cals = f.getSubtotals()) == null) continue;
            for (Calculator cal : cals) {
                this.scanForContext(cal);
            }
        }
    }

    private void scanDataFields(PivotField[] fields) {
        if (fields == null) {
            return;
        }
        for (PivotField f : fields) {
            this._dfSet.add(f);
            this.scanForContext(f.getSummary());
        }
    }

    private void scanForContext(Calculator cal) {
        this.addContextType(((ContextualCalculator)cal).getContextType());
    }

    private void addContextType(ContextType<?> ctxType) {
        if (ctxType instanceof StandardContextType) {
            this._stdCtxReq[((StandardContextType)ctxType).ordinal()] = true;
        } else {
            this._cusCtxTypeSet.add(ctxType);
        }
    }

    public Set<PivotField> getRowColumnFieldRequirement() {
        return Collections.unmodifiableSet(this._rcfSet);
    }

    public Set<PivotField> getDataFieldRequirement() {
        return Collections.unmodifiableSet(this._dfSet);
    }

    public boolean[] getStandardContextTypeRequirement() {
        return this._stdCtxReq;
    }

    public ContextType<?>[] getCustomContextTypeRequirement() {
        return this._cusCtxType;
    }

    public int getDataFieldCount() {
        return this._dfCount;
    }

    public int getCustomContextTypeCount() {
        return this._customCtxTypeCount;
    }

    public int getTotalContextTypeCount() {
        return this._totalCtxTypeCount;
    }

    public ContextType<?> getCustomContextType(int index) {
        return this._cusCtxType[index];
    }

    public boolean covers(CalculatorContextSignature signature) {
        if (!CalculatorContextSignature.subsetOf(signature._rcfSet, this._rcfSet) || !CalculatorContextSignature.subsetOf(signature._dfSet, this._dfSet)) {
            return false;
        }
        for (int i = 0; i < TabularPivotModel._STD_CAL_TYPE_SIZE; ++i) {
            if (!signature._stdCtxReq[i] || this._stdCtxReq[i]) continue;
            return false;
        }
        return CalculatorContextSignature.subsetOf(signature._cusCtxTypeSet, this._cusCtxTypeSet);
    }

    public int getIndexOf(ContextType<?> type) {
        for (int i = 0; i < this._cusCtxType.length; ++i) {
            if (type != this._cusCtxType[i]) continue;
            return i;
        }
        return -1;
    }

    private static boolean subsetOf(Set<?> s1, Set<?> s2) {
        for (Object item : s1) {
            if (s2.contains(item)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return CalculatorContextSignature.toString(this._rcfSet) + CalculatorContextSignature.toString(this._dfSet) + CalculatorContextSignature.toString(this._stdCtxReq) + "[" + this._cusCtxTypeSet.size() + "]";
    }

    private static String toString(Set<? extends PivotField> fset) {
        StringBuilder sb = new StringBuilder().append('[');
        boolean suc = false;
        for (PivotField pivotField : fset) {
            if (suc) {
                sb.append(", ");
            } else {
                suc = true;
            }
            sb.append(pivotField.getFieldName());
        }
        return sb.append(']').toString();
    }

    private static String toString(boolean[] bools) {
        StringBuilder sb = new StringBuilder().append('[');
        for (boolean b : bools) {
            sb.append(b ? 1 : 0);
        }
        return sb.append(']').toString();
    }
}

