/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.pivot.PivotModel;
import org.zkoss.pivot.event.PivotDataEvent;
import org.zkoss.pivot.event.PivotDataListener;

public abstract class AbstractPivotModel
implements PivotModel,
Serializable {
    private static final long serialVersionUID = 201102110924L;
    private transient List<PivotDataListener> _listeners = new LinkedList<PivotDataListener>();

    @Override
    public void addPivotDataListener(PivotDataListener p) {
        if (p == null) {
            throw new NullPointerException();
        }
        this._listeners.add(p);
    }

    @Override
    public void removePivotDataListener(PivotDataListener p) {
        this._listeners.remove(p);
    }

    protected void fireEvent() {
        PivotDataEvent evt = new PivotDataEvent(this);
        for (PivotDataListener p : this._listeners) {
            p.onChange(evt);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this._listeners.size());
        for (PivotDataListener p : this._listeners) {
            s.writeObject(p);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList<PivotDataListener>();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            this._listeners.add((PivotDataListener)s.readObject());
        }
    }
}

